// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DataSource;
use crate::MapProjection;
use crate::MapSource;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "ShumateVectorRenderer")]
    pub struct VectorRenderer(Object<ffi::ShumateVectorRenderer, ffi::ShumateVectorRendererClass>) @extends MapSource, @implements gio::Initable;

    match fn {
        type_ => || ffi::shumate_vector_renderer_get_type(),
    }
}

impl VectorRenderer {
    #[doc(alias = "shumate_vector_renderer_new")]
    pub fn new(
        data_source: &impl IsA<DataSource>,
        style_json: &str,
    ) -> Result<VectorRenderer, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::shumate_vector_renderer_new(
                data_source.as_ref().to_glib_none().0,
                style_json.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "shumate_vector_renderer_new_from_url")]
    #[doc(alias = "new_from_url")]
    pub fn from_url(url_template: &str, style_json: &str) -> Result<VectorRenderer, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::shumate_vector_renderer_new_from_url(
                url_template.to_glib_none().0,
                style_json.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "shumate_vector_renderer_new_full")]
    pub fn new_full(
        id: &str,
        name: &str,
        license: &str,
        license_uri: &str,
        min_zoom: u32,
        max_zoom: u32,
        tile_size: u32,
        projection: MapProjection,
        data_source: &impl IsA<DataSource>,
        style_json: &str,
    ) -> Result<VectorRenderer, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::shumate_vector_renderer_new_full(
                id.to_glib_none().0,
                name.to_glib_none().0,
                license.to_glib_none().0,
                license_uri.to_glib_none().0,
                min_zoom,
                max_zoom,
                tile_size,
                projection.into_glib(),
                data_source.as_ref().to_glib_none().0,
                style_json.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "shumate_vector_renderer_new_full_from_url")]
    pub fn new_full_from_url(
        id: &str,
        name: &str,
        license: &str,
        license_uri: &str,
        min_zoom: u32,
        max_zoom: u32,
        tile_size: u32,
        projection: MapProjection,
        url_template: &str,
        style_json: &str,
    ) -> Result<VectorRenderer, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::shumate_vector_renderer_new_full_from_url(
                id.to_glib_none().0,
                name.to_glib_none().0,
                license.to_glib_none().0,
                license_uri.to_glib_none().0,
                min_zoom,
                max_zoom,
                tile_size,
                projection.into_glib(),
                url_template.to_glib_none().0,
                style_json.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`VectorRenderer`] objects.
    ///
    /// This method returns an instance of [`VectorRendererBuilder`](crate::builders::VectorRendererBuilder) which can be used to create [`VectorRenderer`] objects.
    pub fn builder() -> VectorRendererBuilder {
        VectorRendererBuilder::default()
    }

    #[doc(alias = "data-source")]
    pub fn data_source(&self) -> Option<DataSource> {
        glib::ObjectExt::property(self, "data-source")
    }

    #[doc(alias = "style-json")]
    pub fn style_json(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self, "style-json")
    }

    #[doc(alias = "shumate_vector_renderer_is_supported")]
    pub fn is_supported() -> bool {
        assert_initialized_main_thread!();
        unsafe { from_glib(ffi::shumate_vector_renderer_is_supported()) }
    }
}

impl Default for VectorRenderer {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct VectorRenderer object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`VectorRenderer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct VectorRendererBuilder {
    data_source: Option<DataSource>,
    style_json: Option<String>,
    id: Option<String>,
    license: Option<String>,
    license_uri: Option<String>,
    max_zoom_level: Option<u32>,
    min_zoom_level: Option<u32>,
    name: Option<String>,
    projection: Option<MapProjection>,
    tile_size: Option<u32>,
}

impl VectorRendererBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`VectorRendererBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`VectorRenderer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> VectorRenderer {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref data_source) = self.data_source {
            properties.push(("data-source", data_source));
        }
        if let Some(ref style_json) = self.style_json {
            properties.push(("style-json", style_json));
        }
        if let Some(ref id) = self.id {
            properties.push(("id", id));
        }
        if let Some(ref license) = self.license {
            properties.push(("license", license));
        }
        if let Some(ref license_uri) = self.license_uri {
            properties.push(("license-uri", license_uri));
        }
        if let Some(ref max_zoom_level) = self.max_zoom_level {
            properties.push(("max-zoom-level", max_zoom_level));
        }
        if let Some(ref min_zoom_level) = self.min_zoom_level {
            properties.push(("min-zoom-level", min_zoom_level));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref projection) = self.projection {
            properties.push(("projection", projection));
        }
        if let Some(ref tile_size) = self.tile_size {
            properties.push(("tile-size", tile_size));
        }
        glib::Object::new::<VectorRenderer>(&properties)
            .expect("Failed to create an instance of VectorRenderer")
    }

    pub fn data_source(mut self, data_source: &impl IsA<DataSource>) -> Self {
        self.data_source = Some(data_source.clone().upcast());
        self
    }

    pub fn style_json(mut self, style_json: &str) -> Self {
        self.style_json = Some(style_json.to_string());
        self
    }

    pub fn id(mut self, id: &str) -> Self {
        self.id = Some(id.to_string());
        self
    }

    pub fn license(mut self, license: &str) -> Self {
        self.license = Some(license.to_string());
        self
    }

    pub fn license_uri(mut self, license_uri: &str) -> Self {
        self.license_uri = Some(license_uri.to_string());
        self
    }

    pub fn max_zoom_level(mut self, max_zoom_level: u32) -> Self {
        self.max_zoom_level = Some(max_zoom_level);
        self
    }

    pub fn min_zoom_level(mut self, min_zoom_level: u32) -> Self {
        self.min_zoom_level = Some(min_zoom_level);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn projection(mut self, projection: MapProjection) -> Self {
        self.projection = Some(projection);
        self
    }

    pub fn tile_size(mut self, tile_size: u32) -> Self {
        self.tile_size = Some(tile_size);
        self
    }
}

impl fmt::Display for VectorRenderer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("VectorRenderer")
    }
}
