// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "ShumateFileCache")]
    pub struct FileCache(Object<ffi::ShumateFileCache, ffi::ShumateFileCacheClass>);

    match fn {
        type_ => || ffi::shumate_file_cache_get_type(),
    }
}

impl FileCache {
    pub const NONE: Option<&'static FileCache> = None;

    #[doc(alias = "shumate_file_cache_new_full")]
    pub fn new_full(size_limit: u32, cache_key: &str, cache_dir: Option<&str>) -> FileCache {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::shumate_file_cache_new_full(
                size_limit,
                cache_key.to_glib_none().0,
                cache_dir.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FileCache`] objects.
    ///
    /// This method returns an instance of [`FileCacheBuilder`](crate::builders::FileCacheBuilder) which can be used to create [`FileCache`] objects.
    pub fn builder() -> FileCacheBuilder {
        FileCacheBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FileCache`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileCacheBuilder {
    cache_dir: Option<String>,
    cache_key: Option<String>,
    size_limit: Option<u32>,
}

impl FileCacheBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`FileCacheBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FileCache`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FileCache {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref cache_dir) = self.cache_dir {
            properties.push(("cache-dir", cache_dir));
        }
        if let Some(ref cache_key) = self.cache_key {
            properties.push(("cache-key", cache_key));
        }
        if let Some(ref size_limit) = self.size_limit {
            properties.push(("size-limit", size_limit));
        }
        glib::Object::new::<FileCache>(&properties)
            .expect("Failed to create an instance of FileCache")
    }

    pub fn cache_dir(mut self, cache_dir: &str) -> Self {
        self.cache_dir = Some(cache_dir.to_string());
        self
    }

    pub fn cache_key(mut self, cache_key: &str) -> Self {
        self.cache_key = Some(cache_key.to_string());
        self
    }

    pub fn size_limit(mut self, size_limit: u32) -> Self {
        self.size_limit = Some(size_limit);
        self
    }
}

pub trait FileCacheExt: 'static {
    #[doc(alias = "shumate_file_cache_get_cache_dir")]
    #[doc(alias = "get_cache_dir")]
    fn cache_dir(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_file_cache_get_cache_key")]
    #[doc(alias = "get_cache_key")]
    fn cache_key(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_file_cache_get_size_limit")]
    #[doc(alias = "get_size_limit")]
    fn size_limit(&self) -> u32;

    #[doc(alias = "shumate_file_cache_get_tile_async")]
    #[doc(alias = "get_tile_async")]
    fn tile_async<
        P: FnOnce(
                Result<(glib::Bytes, Option<glib::GString>, Option<glib::DateTime>), glib::Error>,
            ) + Send
            + 'static,
    >(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<
            dyn std::future::Future<
                    Output = Result<
                        (glib::Bytes, Option<glib::GString>, Option<glib::DateTime>),
                        glib::Error,
                    >,
                > + 'static,
        >,
    >;

    #[doc(alias = "shumate_file_cache_mark_up_to_date")]
    fn mark_up_to_date(&self, x: i32, y: i32, zoom_level: i32);

    #[doc(alias = "shumate_file_cache_purge_cache_async")]
    fn purge_cache_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn purge_cache_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "shumate_file_cache_set_size_limit")]
    fn set_size_limit(&self, size_limit: u32);

    #[doc(alias = "shumate_file_cache_store_tile_async")]
    fn store_tile_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn store_tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "size-limit")]
    fn connect_size_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<FileCache>> FileCacheExt for O {
    fn cache_dir(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_file_cache_get_cache_dir(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn cache_key(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::shumate_file_cache_get_cache_key(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn size_limit(&self) -> u32 {
        unsafe { ffi::shumate_file_cache_get_size_limit(self.as_ref().to_glib_none().0) }
    }

    fn tile_async<
        P: FnOnce(
                Result<(glib::Bytes, Option<glib::GString>, Option<glib::DateTime>), glib::Error>,
            ) + Send
            + 'static,
    >(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn tile_async_trampoline<
            P: FnOnce(
                    Result<
                        (glib::Bytes, Option<glib::GString>, Option<glib::DateTime>),
                        glib::Error,
                    >,
                ) + Send
                + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut etag = ptr::null_mut();
            let mut modtime = ptr::null_mut();
            let ret = ffi::shumate_file_cache_get_tile_finish(
                _source_object as *mut _,
                &mut etag,
                &mut modtime,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((
                    from_glib_full(ret),
                    from_glib_full(etag),
                    from_glib_full(modtime),
                ))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = tile_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_get_tile_async(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<
            dyn std::future::Future<
                    Output = Result<
                        (glib::Bytes, Option<glib::GString>, Option<glib::DateTime>),
                        glib::Error,
                    >,
                > + 'static,
        >,
    > {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.tile_async(x, y, zoom_level, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn mark_up_to_date(&self, x: i32, y: i32, zoom_level: i32) {
        unsafe {
            ffi::shumate_file_cache_mark_up_to_date(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
            );
        }
    }

    fn purge_cache_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn purge_cache_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::shumate_file_cache_purge_cache_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = purge_cache_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_purge_cache_async(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn purge_cache_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.purge_cache_async(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn set_size_limit(&self, size_limit: u32) {
        unsafe {
            ffi::shumate_file_cache_set_size_limit(self.as_ref().to_glib_none().0, size_limit);
        }
    }

    fn store_tile_async<P: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn store_tile_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::shumate_file_cache_store_tile_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = store_tile_async_trampoline::<P>;
        unsafe {
            ffi::shumate_file_cache_store_tile_async(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
                bytes.to_glib_none().0,
                etag.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn store_tile_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        bytes: &glib::Bytes,
        etag: Option<&str>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let bytes = bytes.clone();
        let etag = etag.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.store_tile_async(
                x,
                y,
                zoom_level,
                &bytes,
                etag.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn connect_size_limit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_limit_trampoline<
            P: IsA<FileCache>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::ShumateFileCache,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(FileCache::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-limit\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_limit_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for FileCache {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("FileCache")
    }
}
