// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::State;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "ShumateTile")]
    pub struct Tile(Object<ffi::ShumateTile, ffi::ShumateTileClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_tile_get_type(),
    }
}

impl Tile {
    pub const NONE: Option<&'static Tile> = None;

    #[doc(alias = "shumate_tile_new")]
    pub fn new() -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_tile_new()) }
    }

    #[doc(alias = "shumate_tile_new_full")]
    pub fn new_full(x: u32, y: u32, size: u32, zoom_level: u32) -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_tile_new_full(x, y, size, zoom_level)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Tile`] objects.
    ///
    /// This method returns an instance of [`TileBuilder`](crate::builders::TileBuilder) which can be used to create [`Tile`] objects.
    pub fn builder() -> TileBuilder {
        TileBuilder::default()
    }
}

impl Default for Tile {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Tile`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TileBuilder {
    fade_in: Option<bool>,
    size: Option<u32>,
    state: Option<State>,
    texture: Option<gdk::Texture>,
    x: Option<u32>,
    y: Option<u32>,
    zoom_level: Option<u32>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<gtk::Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<gtk::LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<gtk::Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<gtk::AccessibleRole>,
}

impl TileBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TileBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Tile`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Tile {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref fade_in) = self.fade_in {
            properties.push(("fade-in", fade_in));
        }
        if let Some(ref size) = self.size {
            properties.push(("size", size));
        }
        if let Some(ref state) = self.state {
            properties.push(("state", state));
        }
        if let Some(ref texture) = self.texture {
            properties.push(("texture", texture));
        }
        if let Some(ref x) = self.x {
            properties.push(("x", x));
        }
        if let Some(ref y) = self.y {
            properties.push(("y", y));
        }
        if let Some(ref zoom_level) = self.zoom_level {
            properties.push(("zoom-level", zoom_level));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        glib::Object::new::<Tile>(&properties).expect("Failed to create an instance of Tile")
    }

    pub fn fade_in(mut self, fade_in: bool) -> Self {
        self.fade_in = Some(fade_in);
        self
    }

    pub fn size(mut self, size: u32) -> Self {
        self.size = Some(size);
        self
    }

    pub fn state(mut self, state: State) -> Self {
        self.state = Some(state);
        self
    }

    pub fn texture(mut self, texture: &impl IsA<gdk::Texture>) -> Self {
        self.texture = Some(texture.clone().upcast());
        self
    }

    pub fn x(mut self, x: u32) -> Self {
        self.x = Some(x);
        self
    }

    pub fn y(mut self, y: u32) -> Self {
        self.y = Some(y);
        self
    }

    pub fn zoom_level(mut self, zoom_level: u32) -> Self {
        self.zoom_level = Some(zoom_level);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: gtk::Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: gtk::AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }
}

pub trait TileExt: 'static {
    #[doc(alias = "shumate_tile_get_etag")]
    #[doc(alias = "get_etag")]
    fn etag(&self) -> Option<glib::GString>;

    #[doc(alias = "shumate_tile_get_fade_in")]
    #[doc(alias = "get_fade_in")]
    fn is_fade_in(&self) -> bool;

    #[doc(alias = "shumate_tile_get_modified_time")]
    #[doc(alias = "get_modified_time")]
    fn modified_time(&self) -> Option<glib::DateTime>;

    #[doc(alias = "shumate_tile_get_size")]
    #[doc(alias = "get_size")]
    fn size(&self) -> u32;

    #[doc(alias = "shumate_tile_get_state")]
    #[doc(alias = "get_state")]
    fn state(&self) -> State;

    #[doc(alias = "shumate_tile_get_texture")]
    #[doc(alias = "get_texture")]
    fn texture(&self) -> Option<gdk::Texture>;

    #[doc(alias = "shumate_tile_get_x")]
    #[doc(alias = "get_x")]
    fn x(&self) -> u32;

    #[doc(alias = "shumate_tile_get_y")]
    #[doc(alias = "get_y")]
    fn y(&self) -> u32;

    #[doc(alias = "shumate_tile_get_zoom_level")]
    #[doc(alias = "get_zoom_level")]
    fn zoom_level(&self) -> u32;

    #[doc(alias = "shumate_tile_set_etag")]
    fn set_etag(&self, etag: &str);

    #[doc(alias = "shumate_tile_set_fade_in")]
    fn set_fade_in(&self, fade_in: bool);

    #[doc(alias = "shumate_tile_set_modified_time")]
    fn set_modified_time(&self, modified_time: &glib::DateTime);

    #[doc(alias = "shumate_tile_set_size")]
    fn set_size(&self, size: u32);

    #[doc(alias = "shumate_tile_set_state")]
    fn set_state(&self, state: State);

    #[doc(alias = "shumate_tile_set_texture")]
    fn set_texture(&self, texture: &impl IsA<gdk::Texture>);

    #[doc(alias = "shumate_tile_set_x")]
    fn set_x(&self, x: u32);

    #[doc(alias = "shumate_tile_set_y")]
    fn set_y(&self, y: u32);

    #[doc(alias = "shumate_tile_set_zoom_level")]
    fn set_zoom_level(&self, zoom_level: u32);

    #[doc(alias = "fade-in")]
    fn connect_fade_in_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size")]
    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "state")]
    fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "texture")]
    fn connect_texture_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "x")]
    fn connect_x_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "y")]
    fn connect_y_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "zoom-level")]
    fn connect_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Tile>> TileExt for O {
    fn etag(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::shumate_tile_get_etag(self.as_ref().to_glib_none().0)) }
    }

    fn is_fade_in(&self) -> bool {
        unsafe {
            from_glib(ffi::shumate_tile_get_fade_in(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn modified_time(&self) -> Option<glib::DateTime> {
        unsafe {
            from_glib_full(ffi::shumate_tile_get_modified_time(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn size(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_size(self.as_ref().to_glib_none().0) }
    }

    fn state(&self) -> State {
        unsafe { from_glib(ffi::shumate_tile_get_state(self.as_ref().to_glib_none().0)) }
    }

    fn texture(&self) -> Option<gdk::Texture> {
        unsafe {
            from_glib_none(ffi::shumate_tile_get_texture(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn x(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_x(self.as_ref().to_glib_none().0) }
    }

    fn y(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_y(self.as_ref().to_glib_none().0) }
    }

    fn zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_zoom_level(self.as_ref().to_glib_none().0) }
    }

    fn set_etag(&self, etag: &str) {
        unsafe {
            ffi::shumate_tile_set_etag(self.as_ref().to_glib_none().0, etag.to_glib_none().0);
        }
    }

    fn set_fade_in(&self, fade_in: bool) {
        unsafe {
            ffi::shumate_tile_set_fade_in(self.as_ref().to_glib_none().0, fade_in.into_glib());
        }
    }

    fn set_modified_time(&self, modified_time: &glib::DateTime) {
        unsafe {
            ffi::shumate_tile_set_modified_time(
                self.as_ref().to_glib_none().0,
                modified_time.to_glib_none().0,
            );
        }
    }

    fn set_size(&self, size: u32) {
        unsafe {
            ffi::shumate_tile_set_size(self.as_ref().to_glib_none().0, size);
        }
    }

    fn set_state(&self, state: State) {
        unsafe {
            ffi::shumate_tile_set_state(self.as_ref().to_glib_none().0, state.into_glib());
        }
    }

    fn set_texture(&self, texture: &impl IsA<gdk::Texture>) {
        unsafe {
            ffi::shumate_tile_set_texture(
                self.as_ref().to_glib_none().0,
                texture.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_x(&self, x: u32) {
        unsafe {
            ffi::shumate_tile_set_x(self.as_ref().to_glib_none().0, x);
        }
    }

    fn set_y(&self, y: u32) {
        unsafe {
            ffi::shumate_tile_set_y(self.as_ref().to_glib_none().0, y);
        }
    }

    fn set_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_tile_set_zoom_level(self.as_ref().to_glib_none().0, zoom_level);
        }
    }

    fn connect_fade_in_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fade_in_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fade-in\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fade_in_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_state_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_texture_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_texture_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::texture\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_texture_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_x_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_x_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::x\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_x_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_y_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_y_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::y\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_y_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_level_trampoline<P: IsA<Tile>, F: Fn(&P) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Tile::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::zoom-level\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_zoom_level_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Tile {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Tile")
    }
}
