// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "ShumateDataSource")]
    pub struct DataSource(Object<ffi::ShumateDataSource, ffi::ShumateDataSourceClass>);

    match fn {
        type_ => || ffi::shumate_data_source_get_type(),
    }
}

impl DataSource {
    pub const NONE: Option<&'static DataSource> = None;
}

pub trait DataSourceExt: 'static {
    #[doc(alias = "shumate_data_source_get_tile_data_async")]
    #[doc(alias = "get_tile_data_async")]
    fn tile_data_async<P: FnOnce(Result<Option<glib::Bytes>, glib::Error>) + Send + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn tile_data_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<Option<glib::Bytes>, glib::Error>> + 'static>,
    >;

    #[doc(alias = "received-data")]
    fn connect_received_data<F: Fn(&Self, i32, i32, i32, &glib::Bytes) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<DataSource>> DataSourceExt for O {
    fn tile_data_async<P: FnOnce(Result<Option<glib::Bytes>, glib::Error>) + Send + 'static>(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let user_data: Box_<P> = Box_::new(callback);
        unsafe extern "C" fn tile_data_async_trampoline<
            P: FnOnce(Result<Option<glib::Bytes>, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::shumate_data_source_get_tile_data_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<P> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = tile_data_async_trampoline::<P>;
        unsafe {
            ffi::shumate_data_source_get_tile_data_async(
                self.as_ref().to_glib_none().0,
                x,
                y,
                zoom_level,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn tile_data_future(
        &self,
        x: i32,
        y: i32,
        zoom_level: i32,
    ) -> Pin<
        Box_<dyn std::future::Future<Output = Result<Option<glib::Bytes>, glib::Error>> + 'static>,
    > {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.tile_data_async(x, y, zoom_level, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn connect_received_data<F: Fn(&Self, i32, i32, i32, &glib::Bytes) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn received_data_trampoline<
            P: IsA<DataSource>,
            F: Fn(&P, i32, i32, i32, &glib::Bytes) + 'static,
        >(
            this: *mut ffi::ShumateDataSource,
            x: libc::c_int,
            y: libc::c_int,
            zoom_level: libc::c_int,
            bytes: *mut glib::ffi::GBytes,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                DataSource::from_glib_borrow(this).unsafe_cast_ref(),
                x,
                y,
                zoom_level,
                &from_glib_borrow(bytes),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"received-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    received_data_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for DataSource {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DataSource")
    }
}
