// Generated by gir (https://github.com/gtk-rs/gir @ f64f90a)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 8e47c67)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(feature = "dox", feature(doc_cfg))]

use gdk_pixbuf_sys as gdk_pixbuf;
use gdk_sys as gdk;
use gio_sys as gio;
use glib_sys as glib;
use gobject_sys as gobject;
use gtk_sys as gtk;
use pango_sys as pango;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type ShumateFileCacheError = c_int;
pub const SHUMATE_FILE_CACHE_ERROR_FAILED: ShumateFileCacheError = 0;

pub type ShumateMapProjection = c_int;
pub const SHUMATE_MAP_PROJECTION_MERCATOR: ShumateMapProjection = 0;

pub type ShumateNetworkSourceError = c_int;
pub const SHUMATE_NETWORK_SOURCE_ERROR_FAILED: ShumateNetworkSourceError = 0;
pub const SHUMATE_NETWORK_SOURCE_ERROR_BAD_RESPONSE: ShumateNetworkSourceError = 1;
pub const SHUMATE_NETWORK_SOURCE_ERROR_COULD_NOT_CONNECT: ShumateNetworkSourceError = 2;
pub const SHUMATE_NETWORK_SOURCE_ERROR_MALFORMED_URL: ShumateNetworkSourceError = 3;
pub const SHUMATE_NETWORK_SOURCE_ERROR_OFFLINE: ShumateNetworkSourceError = 4;

pub type ShumateState = c_int;
pub const SHUMATE_STATE_NONE: ShumateState = 0;
pub const SHUMATE_STATE_LOADING: ShumateState = 1;
pub const SHUMATE_STATE_LOADED: ShumateState = 2;
pub const SHUMATE_STATE_DONE: ShumateState = 3;

pub type ShumateUnit = c_int;
pub const SHUMATE_UNIT_BOTH: ShumateUnit = 0;
pub const SHUMATE_UNIT_METRIC: ShumateUnit = 1;
pub const SHUMATE_UNIT_IMPERIAL: ShumateUnit = 2;

// Constants
pub const SHUMATE_MAJOR_VERSION: c_int = 0;
pub const SHUMATE_MAP_SOURCE_MFF_RELIEF: *const c_char =
    b"mff-relief\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OSM_CYCLE_MAP: *const c_char =
    b"osm-cyclemap\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OSM_MAPNIK: *const c_char =
    b"osm-mapnik\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OSM_TRANSPORT_MAP: *const c_char =
    b"osm-transportmap\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OWM_CLOUDS: *const c_char =
    b"owm-clouds\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OWM_PRECIPITATION: *const c_char =
    b"owm-precipitation\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OWM_PRESSURE: *const c_char =
    b"owm-pressure\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OWM_TEMPERATURE: *const c_char =
    b"owm-temperature\0" as *const u8 as *const c_char;
pub const SHUMATE_MAP_SOURCE_OWM_WIND: *const c_char = b"owm-wind\0" as *const u8 as *const c_char;
pub const SHUMATE_MAX_LATITUDE: c_double = 85.0511287798;
pub const SHUMATE_MAX_LONGITUDE: c_double = 180.0;
pub const SHUMATE_MICRO_VERSION: c_int = 0;
pub const SHUMATE_MINOR_VERSION: c_int = 0;
pub const SHUMATE_MIN_LATITUDE: c_double = -85.0511287798;
pub const SHUMATE_MIN_LONGITUDE: c_double = -180.0;

// Records
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateCompassClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateCompassClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateCompassClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateCoordinateClass {
    pub parent_class: gobject::GInitiallyUnownedClass,
}

impl ::std::fmt::Debug for ShumateCoordinateClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateCoordinateClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateFileCacheClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for ShumateFileCacheClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateFileCacheClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateLayerClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateLayerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateLayerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateLicenseClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateLicenseClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateLicenseClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateLocationInterface {
    pub g_iface: gobject::GTypeInterface,
    pub get_latitude: Option<unsafe extern "C" fn(*mut ShumateLocation) -> c_double>,
    pub get_longitude: Option<unsafe extern "C" fn(*mut ShumateLocation) -> c_double>,
    pub set_location: Option<unsafe extern "C" fn(*mut ShumateLocation, c_double, c_double)>,
}

impl ::std::fmt::Debug for ShumateLocationInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateLocationInterface @ {:p}", self))
            .field("get_latitude", &self.get_latitude)
            .field("get_longitude", &self.get_longitude)
            .field("set_location", &self.set_location)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMapClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateMapClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMapLayerClass {
    pub parent_class: ShumateLayerClass,
}

impl ::std::fmt::Debug for ShumateMapLayerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapLayerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMapSourceClass {
    pub parent_class: gobject::GObjectClass,
    pub fill_tile_async: Option<
        unsafe extern "C" fn(
            *mut ShumateMapSource,
            *mut ShumateTile,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
}

impl ::std::fmt::Debug for ShumateMapSourceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapSourceClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("fill_tile_async", &self.fill_tile_async)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMapSourceRegistryClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for ShumateMapSourceRegistryClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapSourceRegistryClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMarkerClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateMarkerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMarkerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMarkerLayerClass {
    pub parent_class: ShumateLayerClass,
}

impl ::std::fmt::Debug for ShumateMarkerLayerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMarkerLayerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMemoryCacheClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for ShumateMemoryCacheClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMemoryCacheClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateNetworkTileSourceClass {
    pub parent_class: ShumateMapSourceClass,
}

impl ::std::fmt::Debug for ShumateNetworkTileSourceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateNetworkTileSourceClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumatePathLayerClass {
    pub parent_class: ShumateLayerClass,
}

impl ::std::fmt::Debug for ShumatePathLayerClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumatePathLayerClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumatePointClass {
    pub parent_class: ShumateMarkerClass,
}

impl ::std::fmt::Debug for ShumatePointClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumatePointClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateScaleClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateScaleClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateScaleClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateTileClass {
    pub parent_class: gtk::GtkWidgetClass,
}

impl ::std::fmt::Debug for ShumateTileClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateTileClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateViewportClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for ShumateViewportClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateViewportClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

// Classes
#[repr(C)]
pub struct ShumateCompass(c_void);

impl ::std::fmt::Debug for ShumateCompass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateCompass @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateCoordinate {
    pub parent_instance: gobject::GInitiallyUnowned,
}

impl ::std::fmt::Debug for ShumateCoordinate {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateCoordinate @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateFileCache {
    pub parent_instance: gobject::GObject,
}

impl ::std::fmt::Debug for ShumateFileCache {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateFileCache @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateLayer {
    pub parent_instance: gtk::GtkWidget,
}

impl ::std::fmt::Debug for ShumateLayer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateLayer @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct ShumateLicense(c_void);

impl ::std::fmt::Debug for ShumateLicense {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateLicense @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMap {
    pub parent_instance: gtk::GtkWidget,
}

impl ::std::fmt::Debug for ShumateMap {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMap @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct ShumateMapLayer(c_void);

impl ::std::fmt::Debug for ShumateMapLayer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapLayer @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMapSource {
    pub parent_instance: gobject::GObject,
}

impl ::std::fmt::Debug for ShumateMapSource {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapSource @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct ShumateMapSourceRegistry(c_void);

impl ::std::fmt::Debug for ShumateMapSourceRegistry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMapSourceRegistry @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMarker {
    pub parent_instance: gtk::GtkWidget,
}

impl ::std::fmt::Debug for ShumateMarker {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMarker @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMarkerLayer {
    pub parent_instance: ShumateLayer,
}

impl ::std::fmt::Debug for ShumateMarkerLayer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMarkerLayer @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateMemoryCache {
    pub parent_instance: gobject::GObject,
}

impl ::std::fmt::Debug for ShumateMemoryCache {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateMemoryCache @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateNetworkTileSource {
    pub parent_instance: ShumateMapSource,
}

impl ::std::fmt::Debug for ShumateNetworkTileSource {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateNetworkTileSource @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumatePathLayer {
    pub parent_instance: ShumateLayer,
}

impl ::std::fmt::Debug for ShumatePathLayer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumatePathLayer @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct ShumatePoint(c_void);

impl ::std::fmt::Debug for ShumatePoint {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumatePoint @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
pub struct ShumateScale(c_void);

impl ::std::fmt::Debug for ShumateScale {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateScale @ {:p}", self))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ShumateTile {
    pub parent_instance: gtk::GtkWidget,
}

impl ::std::fmt::Debug for ShumateTile {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateTile @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[repr(C)]
pub struct ShumateViewport(c_void);

impl ::std::fmt::Debug for ShumateViewport {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("ShumateViewport @ {:p}", self))
            .finish()
    }
}

// Interfaces
#[repr(C)]
pub struct ShumateLocation(c_void);

impl ::std::fmt::Debug for ShumateLocation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "ShumateLocation @ {:p}", self)
    }
}

#[link(name = "shumate-0.0")]
extern "C" {

    //=========================================================================
    // ShumateFileCacheError
    //=========================================================================
    pub fn shumate_file_cache_error_get_type() -> GType;
    pub fn shumate_file_cache_error_quark() -> glib::GQuark;

    //=========================================================================
    // ShumateMapProjection
    //=========================================================================
    pub fn shumate_map_projection_get_type() -> GType;

    //=========================================================================
    // ShumateNetworkSourceError
    //=========================================================================
    pub fn shumate_network_source_error_get_type() -> GType;
    pub fn shumate_network_source_error_quark() -> glib::GQuark;

    //=========================================================================
    // ShumateState
    //=========================================================================
    pub fn shumate_state_get_type() -> GType;

    //=========================================================================
    // ShumateUnit
    //=========================================================================
    pub fn shumate_unit_get_type() -> GType;

    //=========================================================================
    // ShumateCompass
    //=========================================================================
    pub fn shumate_compass_get_type() -> GType;
    pub fn shumate_compass_new(viewport: *mut ShumateViewport) -> *mut ShumateCompass;
    pub fn shumate_compass_get_viewport(compass: *mut ShumateCompass) -> *mut ShumateViewport;
    pub fn shumate_compass_set_viewport(
        compass: *mut ShumateCompass,
        viewport: *mut ShumateViewport,
    );

    //=========================================================================
    // ShumateCoordinate
    //=========================================================================
    pub fn shumate_coordinate_get_type() -> GType;
    pub fn shumate_coordinate_new() -> *mut ShumateCoordinate;
    pub fn shumate_coordinate_new_full(
        latitude: c_double,
        longitude: c_double,
    ) -> *mut ShumateCoordinate;

    //=========================================================================
    // ShumateFileCache
    //=========================================================================
    pub fn shumate_file_cache_get_type() -> GType;
    pub fn shumate_file_cache_new_full(
        size_limit: c_uint,
        cache_key: *const c_char,
        cache_dir: *const c_char,
    ) -> *mut ShumateFileCache;
    pub fn shumate_file_cache_get_cache_dir(file_cache: *mut ShumateFileCache) -> *const c_char;
    pub fn shumate_file_cache_get_cache_key(file_cache: *mut ShumateFileCache) -> *const c_char;
    pub fn shumate_file_cache_get_size_limit(file_cache: *mut ShumateFileCache) -> c_uint;
    pub fn shumate_file_cache_get_tile_async(
        self_: *mut ShumateFileCache,
        tile: *mut ShumateTile,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn shumate_file_cache_get_tile_finish(
        self_: *mut ShumateFileCache,
        etag: *mut *mut c_char,
        modtime: *mut *mut glib::GDateTime,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GBytes;
    pub fn shumate_file_cache_mark_up_to_date(self_: *mut ShumateFileCache, tile: *mut ShumateTile);
    pub fn shumate_file_cache_purge_cache_async(
        self_: *mut ShumateFileCache,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn shumate_file_cache_purge_cache_finish(
        self_: *mut ShumateFileCache,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn shumate_file_cache_set_size_limit(file_cache: *mut ShumateFileCache, size_limit: c_uint);
    pub fn shumate_file_cache_store_tile_async(
        self_: *mut ShumateFileCache,
        tile: *mut ShumateTile,
        bytes: *mut glib::GBytes,
        etag: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn shumate_file_cache_store_tile_finish(
        self_: *mut ShumateFileCache,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // ShumateLayer
    //=========================================================================
    pub fn shumate_layer_get_type() -> GType;
    pub fn shumate_layer_get_viewport(self_: *mut ShumateLayer) -> *mut ShumateViewport;

    //=========================================================================
    // ShumateLicense
    //=========================================================================
    pub fn shumate_license_get_type() -> GType;
    pub fn shumate_license_new() -> *mut ShumateLicense;
    pub fn shumate_license_append_map_source(
        license: *mut ShumateLicense,
        map_source: *mut ShumateMapSource,
    );
    pub fn shumate_license_get_extra_text(license: *mut ShumateLicense) -> *const c_char;
    pub fn shumate_license_get_xalign(license: *mut ShumateLicense) -> c_float;
    pub fn shumate_license_prepend_map_source(
        license: *mut ShumateLicense,
        map_source: *mut ShumateMapSource,
    );
    pub fn shumate_license_remove_map_source(
        license: *mut ShumateLicense,
        map_source: *mut ShumateMapSource,
    );
    pub fn shumate_license_set_extra_text(license: *mut ShumateLicense, text: *const c_char);
    pub fn shumate_license_set_xalign(license: *mut ShumateLicense, xalign: c_float);

    //=========================================================================
    // ShumateMap
    //=========================================================================
    pub fn shumate_map_get_type() -> GType;
    pub fn shumate_map_new() -> *mut ShumateMap;
    pub fn shumate_map_new_simple() -> *mut ShumateMap;
    pub fn shumate_map_add_layer(self_: *mut ShumateMap, layer: *mut ShumateLayer);
    pub fn shumate_map_center_on(self_: *mut ShumateMap, latitude: c_double, longitude: c_double);
    pub fn shumate_map_get_animate_zoom(self_: *mut ShumateMap) -> gboolean;
    pub fn shumate_map_get_go_to_duration(self_: *mut ShumateMap) -> c_uint;
    pub fn shumate_map_get_state(self_: *mut ShumateMap) -> ShumateState;
    pub fn shumate_map_get_viewport(self_: *mut ShumateMap) -> *mut ShumateViewport;
    pub fn shumate_map_get_zoom_on_double_click(self_: *mut ShumateMap) -> gboolean;
    pub fn shumate_map_go_to(self_: *mut ShumateMap, latitude: c_double, longitude: c_double);
    pub fn shumate_map_insert_layer_above(
        self_: *mut ShumateMap,
        layer: *mut ShumateLayer,
        next_sibling: *mut ShumateLayer,
    );
    pub fn shumate_map_insert_layer_behind(
        self_: *mut ShumateMap,
        layer: *mut ShumateLayer,
        next_sibling: *mut ShumateLayer,
    );
    pub fn shumate_map_remove_layer(self_: *mut ShumateMap, layer: *mut ShumateLayer);
    pub fn shumate_map_set_animate_zoom(self_: *mut ShumateMap, value: gboolean);
    pub fn shumate_map_set_go_to_duration(self_: *mut ShumateMap, duration: c_uint);
    pub fn shumate_map_set_map_source(self_: *mut ShumateMap, map_source: *mut ShumateMapSource);
    pub fn shumate_map_set_zoom_on_double_click(self_: *mut ShumateMap, value: gboolean);
    pub fn shumate_map_stop_go_to(self_: *mut ShumateMap);

    //=========================================================================
    // ShumateMapLayer
    //=========================================================================
    pub fn shumate_map_layer_get_type() -> GType;
    pub fn shumate_map_layer_new(
        map_source: *mut ShumateMapSource,
        viewport: *mut ShumateViewport,
    ) -> *mut ShumateMapLayer;

    //=========================================================================
    // ShumateMapSource
    //=========================================================================
    pub fn shumate_map_source_get_type() -> GType;
    pub fn shumate_map_source_fill_tile_async(
        self_: *mut ShumateMapSource,
        tile: *mut ShumateTile,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn shumate_map_source_fill_tile_finish(
        self_: *mut ShumateMapSource,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn shumate_map_source_get_column_count(
        map_source: *mut ShumateMapSource,
        zoom_level: c_uint,
    ) -> c_uint;
    pub fn shumate_map_source_get_id(map_source: *mut ShumateMapSource) -> *const c_char;
    pub fn shumate_map_source_get_latitude(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
        y: c_double,
    ) -> c_double;
    pub fn shumate_map_source_get_license(map_source: *mut ShumateMapSource) -> *const c_char;
    pub fn shumate_map_source_get_license_uri(map_source: *mut ShumateMapSource) -> *const c_char;
    pub fn shumate_map_source_get_longitude(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
        x: c_double,
    ) -> c_double;
    pub fn shumate_map_source_get_max_zoom_level(map_source: *mut ShumateMapSource) -> c_uint;
    pub fn shumate_map_source_get_meters_per_pixel(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
        latitude: c_double,
        longitude: c_double,
    ) -> c_double;
    pub fn shumate_map_source_get_min_zoom_level(map_source: *mut ShumateMapSource) -> c_uint;
    pub fn shumate_map_source_get_name(map_source: *mut ShumateMapSource) -> *const c_char;
    pub fn shumate_map_source_get_projection(
        map_source: *mut ShumateMapSource,
    ) -> ShumateMapProjection;
    pub fn shumate_map_source_get_row_count(
        map_source: *mut ShumateMapSource,
        zoom_level: c_uint,
    ) -> c_uint;
    pub fn shumate_map_source_get_tile_size(map_source: *mut ShumateMapSource) -> c_uint;
    pub fn shumate_map_source_get_tile_size_at_zoom(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
    ) -> c_double;
    pub fn shumate_map_source_get_x(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
        longitude: c_double,
    ) -> c_double;
    pub fn shumate_map_source_get_y(
        map_source: *mut ShumateMapSource,
        zoom_level: c_double,
        latitude: c_double,
    ) -> c_double;
    pub fn shumate_map_source_set_id(map_source: *mut ShumateMapSource, id: *const c_char);
    pub fn shumate_map_source_set_license(
        map_source: *mut ShumateMapSource,
        license: *const c_char,
    );
    pub fn shumate_map_source_set_license_uri(
        map_source: *mut ShumateMapSource,
        license_uri: *const c_char,
    );
    pub fn shumate_map_source_set_max_zoom_level(
        map_source: *mut ShumateMapSource,
        zoom_level: c_uint,
    );
    pub fn shumate_map_source_set_min_zoom_level(
        map_source: *mut ShumateMapSource,
        zoom_level: c_uint,
    );
    pub fn shumate_map_source_set_name(map_source: *mut ShumateMapSource, name: *const c_char);
    pub fn shumate_map_source_set_projection(
        map_source: *mut ShumateMapSource,
        projection: ShumateMapProjection,
    );
    pub fn shumate_map_source_set_tile_size(map_source: *mut ShumateMapSource, tile_size: c_uint);

    //=========================================================================
    // ShumateMapSourceRegistry
    //=========================================================================
    pub fn shumate_map_source_registry_get_type() -> GType;
    pub fn shumate_map_source_registry_new() -> *mut ShumateMapSourceRegistry;
    pub fn shumate_map_source_registry_new_with_defaults() -> *mut ShumateMapSourceRegistry;
    pub fn shumate_map_source_registry_add(
        self_: *mut ShumateMapSourceRegistry,
        map_source: *mut ShumateMapSource,
    );
    pub fn shumate_map_source_registry_get_by_id(
        self_: *mut ShumateMapSourceRegistry,
        id: *const c_char,
    ) -> *mut ShumateMapSource;
    pub fn shumate_map_source_registry_populate_defaults(self_: *mut ShumateMapSourceRegistry);
    pub fn shumate_map_source_registry_remove(
        self_: *mut ShumateMapSourceRegistry,
        id: *const c_char,
    );

    //=========================================================================
    // ShumateMarker
    //=========================================================================
    pub fn shumate_marker_get_type() -> GType;
    pub fn shumate_marker_new() -> *mut ShumateMarker;
    pub fn shumate_marker_animate_in(marker: *mut ShumateMarker);
    pub fn shumate_marker_animate_in_with_delay(marker: *mut ShumateMarker, delay: c_uint);
    pub fn shumate_marker_animate_out(marker: *mut ShumateMarker);
    pub fn shumate_marker_animate_out_with_delay(marker: *mut ShumateMarker, delay: c_uint);
    pub fn shumate_marker_get_child(marker: *mut ShumateMarker) -> *mut gtk::GtkWidget;
    pub fn shumate_marker_get_draggable(marker: *mut ShumateMarker) -> gboolean;
    pub fn shumate_marker_get_selectable(marker: *mut ShumateMarker) -> gboolean;
    pub fn shumate_marker_is_selected(marker: *mut ShumateMarker) -> gboolean;
    pub fn shumate_marker_set_child(marker: *mut ShumateMarker, child: *mut gtk::GtkWidget);
    pub fn shumate_marker_set_draggable(marker: *mut ShumateMarker, value: gboolean);
    pub fn shumate_marker_set_selectable(marker: *mut ShumateMarker, value: gboolean);

    //=========================================================================
    // ShumateMarkerLayer
    //=========================================================================
    pub fn shumate_marker_layer_get_type() -> GType;
    pub fn shumate_marker_layer_new(viewport: *mut ShumateViewport) -> *mut ShumateMarkerLayer;
    pub fn shumate_marker_layer_new_full(
        viewport: *mut ShumateViewport,
        mode: gtk::GtkSelectionMode,
    ) -> *mut ShumateMarkerLayer;
    pub fn shumate_marker_layer_add_marker(
        layer: *mut ShumateMarkerLayer,
        marker: *mut ShumateMarker,
    );
    pub fn shumate_marker_layer_animate_in_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_animate_out_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_get_markers(layer: *mut ShumateMarkerLayer) -> *mut glib::GList;
    pub fn shumate_marker_layer_get_selected(layer: *mut ShumateMarkerLayer) -> *mut glib::GList;
    pub fn shumate_marker_layer_get_selection_mode(
        layer: *mut ShumateMarkerLayer,
    ) -> gtk::GtkSelectionMode;
    pub fn shumate_marker_layer_hide_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_remove_all(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_remove_marker(
        layer: *mut ShumateMarkerLayer,
        marker: *mut ShumateMarker,
    );
    pub fn shumate_marker_layer_select_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_select_marker(
        self_: *mut ShumateMarkerLayer,
        marker: *mut ShumateMarker,
    ) -> gboolean;
    pub fn shumate_marker_layer_set_all_markers_draggable(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_set_all_markers_undraggable(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_set_selection_mode(
        layer: *mut ShumateMarkerLayer,
        mode: gtk::GtkSelectionMode,
    );
    pub fn shumate_marker_layer_show_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_unselect_all_markers(layer: *mut ShumateMarkerLayer);
    pub fn shumate_marker_layer_unselect_marker(
        self_: *mut ShumateMarkerLayer,
        marker: *mut ShumateMarker,
    );

    //=========================================================================
    // ShumateMemoryCache
    //=========================================================================
    pub fn shumate_memory_cache_get_type() -> GType;
    pub fn shumate_memory_cache_new_full(size_limit: c_uint) -> *mut ShumateMemoryCache;
    pub fn shumate_memory_cache_clean(memory_cache: *mut ShumateMemoryCache);
    pub fn shumate_memory_cache_get_size_limit(memory_cache: *mut ShumateMemoryCache) -> c_uint;
    pub fn shumate_memory_cache_set_size_limit(
        memory_cache: *mut ShumateMemoryCache,
        size_limit: c_uint,
    );
    pub fn shumate_memory_cache_store_texture(
        self_: *mut ShumateMemoryCache,
        tile: *mut ShumateTile,
        texture: *mut gdk::GdkTexture,
        source_id: *const c_char,
    );
    pub fn shumate_memory_cache_try_fill_tile(
        self_: *mut ShumateMemoryCache,
        tile: *mut ShumateTile,
        source_id: *const c_char,
    ) -> gboolean;

    //=========================================================================
    // ShumateNetworkTileSource
    //=========================================================================
    pub fn shumate_network_tile_source_get_type() -> GType;
    pub fn shumate_network_tile_source_new_full(
        id: *const c_char,
        name: *const c_char,
        license: *const c_char,
        license_uri: *const c_char,
        min_zoom: c_uint,
        max_zoom: c_uint,
        tile_size: c_uint,
        projection: ShumateMapProjection,
        uri_format: *const c_char,
    ) -> *mut ShumateNetworkTileSource;
    pub fn shumate_network_tile_source_get_max_conns(
        tile_source: *mut ShumateNetworkTileSource,
    ) -> c_int;
    pub fn shumate_network_tile_source_get_offline(
        tile_source: *mut ShumateNetworkTileSource,
    ) -> gboolean;
    pub fn shumate_network_tile_source_get_proxy_uri(
        tile_source: *mut ShumateNetworkTileSource,
    ) -> *const c_char;
    pub fn shumate_network_tile_source_get_uri_format(
        tile_source: *mut ShumateNetworkTileSource,
    ) -> *const c_char;
    pub fn shumate_network_tile_source_set_max_conns(
        tile_source: *mut ShumateNetworkTileSource,
        max_conns: c_int,
    );
    pub fn shumate_network_tile_source_set_offline(
        tile_source: *mut ShumateNetworkTileSource,
        offline: gboolean,
    );
    pub fn shumate_network_tile_source_set_proxy_uri(
        tile_source: *mut ShumateNetworkTileSource,
        proxy_uri: *const c_char,
    );
    pub fn shumate_network_tile_source_set_uri_format(
        tile_source: *mut ShumateNetworkTileSource,
        uri_format: *const c_char,
    );
    pub fn shumate_network_tile_source_set_user_agent(
        tile_source: *mut ShumateNetworkTileSource,
        user_agent: *const c_char,
    );

    //=========================================================================
    // ShumatePathLayer
    //=========================================================================
    pub fn shumate_path_layer_get_type() -> GType;
    pub fn shumate_path_layer_new(viewport: *mut ShumateViewport) -> *mut ShumatePathLayer;
    pub fn shumate_path_layer_add_node(
        layer: *mut ShumatePathLayer,
        location: *mut ShumateLocation,
    );
    pub fn shumate_path_layer_get_closed(layer: *mut ShumatePathLayer) -> gboolean;
    pub fn shumate_path_layer_get_dash(layer: *mut ShumatePathLayer) -> *mut glib::GList;
    pub fn shumate_path_layer_get_fill(layer: *mut ShumatePathLayer) -> gboolean;
    pub fn shumate_path_layer_get_fill_color(layer: *mut ShumatePathLayer) -> *mut gdk::GdkRGBA;
    pub fn shumate_path_layer_get_nodes(layer: *mut ShumatePathLayer) -> *mut glib::GList;
    pub fn shumate_path_layer_get_outline_color(layer: *mut ShumatePathLayer) -> *mut gdk::GdkRGBA;
    pub fn shumate_path_layer_get_outline_width(layer: *mut ShumatePathLayer) -> c_double;
    pub fn shumate_path_layer_get_stroke(layer: *mut ShumatePathLayer) -> gboolean;
    pub fn shumate_path_layer_get_stroke_color(layer: *mut ShumatePathLayer) -> *mut gdk::GdkRGBA;
    pub fn shumate_path_layer_get_stroke_width(layer: *mut ShumatePathLayer) -> c_double;
    pub fn shumate_path_layer_insert_node(
        layer: *mut ShumatePathLayer,
        location: *mut ShumateLocation,
        position: c_uint,
    );
    pub fn shumate_path_layer_remove_all(layer: *mut ShumatePathLayer);
    pub fn shumate_path_layer_remove_node(
        layer: *mut ShumatePathLayer,
        location: *mut ShumateLocation,
    );
    pub fn shumate_path_layer_set_closed(layer: *mut ShumatePathLayer, value: gboolean);
    pub fn shumate_path_layer_set_dash(
        layer: *mut ShumatePathLayer,
        dash_pattern: *mut glib::GList,
    );
    pub fn shumate_path_layer_set_fill(layer: *mut ShumatePathLayer, value: gboolean);
    pub fn shumate_path_layer_set_fill_color(
        layer: *mut ShumatePathLayer,
        color: *const gdk::GdkRGBA,
    );
    pub fn shumate_path_layer_set_outline_color(
        layer: *mut ShumatePathLayer,
        color: *const gdk::GdkRGBA,
    );
    pub fn shumate_path_layer_set_outline_width(layer: *mut ShumatePathLayer, value: c_double);
    pub fn shumate_path_layer_set_stroke(layer: *mut ShumatePathLayer, value: gboolean);
    pub fn shumate_path_layer_set_stroke_color(
        layer: *mut ShumatePathLayer,
        color: *const gdk::GdkRGBA,
    );
    pub fn shumate_path_layer_set_stroke_width(layer: *mut ShumatePathLayer, value: c_double);

    //=========================================================================
    // ShumatePoint
    //=========================================================================
    pub fn shumate_point_get_type() -> GType;
    pub fn shumate_point_new() -> *mut ShumatePoint;

    //=========================================================================
    // ShumateScale
    //=========================================================================
    pub fn shumate_scale_get_type() -> GType;
    pub fn shumate_scale_new(viewport: *mut ShumateViewport) -> *mut ShumateScale;
    pub fn shumate_scale_get_max_width(scale: *mut ShumateScale) -> c_uint;
    pub fn shumate_scale_get_unit(scale: *mut ShumateScale) -> ShumateUnit;
    pub fn shumate_scale_get_viewport(scale: *mut ShumateScale) -> *mut ShumateViewport;
    pub fn shumate_scale_set_max_width(scale: *mut ShumateScale, value: c_uint);
    pub fn shumate_scale_set_unit(scale: *mut ShumateScale, unit: ShumateUnit);
    pub fn shumate_scale_set_viewport(scale: *mut ShumateScale, viewport: *mut ShumateViewport);

    //=========================================================================
    // ShumateTile
    //=========================================================================
    pub fn shumate_tile_get_type() -> GType;
    pub fn shumate_tile_new() -> *mut ShumateTile;
    pub fn shumate_tile_new_full(
        x: c_uint,
        y: c_uint,
        size: c_uint,
        zoom_level: c_uint,
    ) -> *mut ShumateTile;
    pub fn shumate_tile_get_etag(self_: *mut ShumateTile) -> *const c_char;
    pub fn shumate_tile_get_fade_in(self_: *mut ShumateTile) -> gboolean;
    pub fn shumate_tile_get_modified_time(self_: *mut ShumateTile) -> *mut glib::GDateTime;
    pub fn shumate_tile_get_size(self_: *mut ShumateTile) -> c_uint;
    pub fn shumate_tile_get_state(self_: *mut ShumateTile) -> ShumateState;
    pub fn shumate_tile_get_texture(self_: *mut ShumateTile) -> *mut gdk::GdkTexture;
    pub fn shumate_tile_get_x(self_: *mut ShumateTile) -> c_uint;
    pub fn shumate_tile_get_y(self_: *mut ShumateTile) -> c_uint;
    pub fn shumate_tile_get_zoom_level(self_: *mut ShumateTile) -> c_uint;
    pub fn shumate_tile_set_etag(self_: *mut ShumateTile, etag: *const c_char);
    pub fn shumate_tile_set_fade_in(self_: *mut ShumateTile, fade_in: gboolean);
    pub fn shumate_tile_set_modified_time(
        self_: *mut ShumateTile,
        modified_time: *mut glib::GDateTime,
    );
    pub fn shumate_tile_set_size(self_: *mut ShumateTile, size: c_uint);
    pub fn shumate_tile_set_state(self_: *mut ShumateTile, state: ShumateState);
    pub fn shumate_tile_set_texture(self_: *mut ShumateTile, texture: *mut gdk::GdkTexture);
    pub fn shumate_tile_set_x(self_: *mut ShumateTile, x: c_uint);
    pub fn shumate_tile_set_y(self_: *mut ShumateTile, y: c_uint);
    pub fn shumate_tile_set_zoom_level(self_: *mut ShumateTile, zoom_level: c_uint);

    //=========================================================================
    // ShumateViewport
    //=========================================================================
    pub fn shumate_viewport_get_type() -> GType;
    pub fn shumate_viewport_new() -> *mut ShumateViewport;
    pub fn shumate_viewport_get_max_zoom_level(self_: *mut ShumateViewport) -> c_uint;
    pub fn shumate_viewport_get_min_zoom_level(self_: *mut ShumateViewport) -> c_uint;
    pub fn shumate_viewport_get_reference_map_source(
        self_: *mut ShumateViewport,
    ) -> *mut ShumateMapSource;
    pub fn shumate_viewport_get_rotation(self_: *mut ShumateViewport) -> c_double;
    pub fn shumate_viewport_get_zoom_level(self_: *mut ShumateViewport) -> c_double;
    pub fn shumate_viewport_location_to_widget_coords(
        self_: *mut ShumateViewport,
        widget: *mut gtk::GtkWidget,
        latitude: c_double,
        longitude: c_double,
        x: *mut c_double,
        y: *mut c_double,
    );
    pub fn shumate_viewport_set_max_zoom_level(self_: *mut ShumateViewport, max_zoom_level: c_uint);
    pub fn shumate_viewport_set_min_zoom_level(self_: *mut ShumateViewport, min_zoom_level: c_uint);
    pub fn shumate_viewport_set_reference_map_source(
        self_: *mut ShumateViewport,
        map_source: *mut ShumateMapSource,
    );
    pub fn shumate_viewport_set_rotation(self_: *mut ShumateViewport, rotation: c_double);
    pub fn shumate_viewport_set_zoom_level(self_: *mut ShumateViewport, zoom_level: c_double);
    pub fn shumate_viewport_widget_coords_to_location(
        self_: *mut ShumateViewport,
        widget: *mut gtk::GtkWidget,
        x: c_double,
        y: c_double,
        latitude: *mut c_double,
        longitude: *mut c_double,
    );
    pub fn shumate_viewport_zoom_in(self_: *mut ShumateViewport);
    pub fn shumate_viewport_zoom_out(self_: *mut ShumateViewport);

    //=========================================================================
    // ShumateLocation
    //=========================================================================
    pub fn shumate_location_get_type() -> GType;
    pub fn shumate_location_get_latitude(location: *mut ShumateLocation) -> c_double;
    pub fn shumate_location_get_longitude(location: *mut ShumateLocation) -> c_double;
    pub fn shumate_location_set_location(
        location: *mut ShumateLocation,
        latitude: c_double,
        longitude: c_double,
    );

}
