// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#[cfg(any(feature = "v0_19", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_19")))]
use crate::Backend;
use crate::Collection;
use crate::Item;
use crate::Prompt;
use crate::ServiceFlags;
use crate::Value;
use glib::object::IsA;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::pin::Pin;
use std::ptr;

#[cfg(any(feature = "v0_19", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v0_19")))]
glib::wrapper! {
    #[doc(alias = "SecretService")]
    pub struct Service(Object<ffi::SecretService, ffi::SecretServiceClass>) @extends gio::DBusProxy, @implements gio::DBusInterface, gio::Initable, Backend;

    match fn {
        type_ => || ffi::secret_service_get_type(),
    }
}

#[cfg(not(any(feature = "v0_19", feature = "dox")))]
glib::wrapper! {
    #[doc(alias = "SecretService")]
    pub struct Service(Object<ffi::SecretService, ffi::SecretServiceClass>) @extends gio::DBusProxy, @implements gio::DBusInterface, gio::Initable;

    match fn {
        type_ => || ffi::secret_service_get_type(),
    }
}

impl Service {
    pub const NONE: Option<&'static Service> = None;

    #[doc(alias = "secret_service_disconnect")]
    pub fn disconnect() {
        unsafe {
            ffi::secret_service_disconnect();
        }
    }

    #[doc(alias = "secret_service_get")]
    pub fn get<P: FnOnce(Result<Service, glib::Error>) + 'static>(
        flags: ServiceFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn get_trampoline<P: FnOnce(Result<Service, glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_get_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = get_trampoline::<P>;
        unsafe {
            ffi::secret_service_get(
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn get_future(
        flags: ServiceFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Service, glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::get(flags, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "secret_service_get_sync")]
    #[doc(alias = "get_sync")]
    pub fn sync(
        flags: ServiceFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Service, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_get_sync(
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "secret_service_open")]
    pub fn open<P: FnOnce(Result<Service, glib::Error>) + 'static>(
        service_gtype: glib::types::Type,
        service_bus_name: Option<&str>,
        flags: ServiceFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn open_trampoline<P: FnOnce(Result<Service, glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_open_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = open_trampoline::<P>;
        unsafe {
            ffi::secret_service_open(
                service_gtype.into_glib(),
                service_bus_name.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn open_future(
        service_gtype: glib::types::Type,
        service_bus_name: Option<&str>,
        flags: ServiceFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Service, glib::Error>> + 'static>> {
        let service_bus_name = service_bus_name.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::open(
                service_gtype,
                service_bus_name.as_ref().map(::std::borrow::Borrow::borrow),
                flags,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "secret_service_open_sync")]
    pub fn open_sync(
        service_gtype: glib::types::Type,
        service_bus_name: Option<&str>,
        flags: ServiceFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Service, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_open_sync(
                service_gtype.into_glib(),
                service_bus_name.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

pub trait ServiceExt: 'static {
    //#[doc(alias = "secret_service_clear_sync")]
    //fn clear_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error>;

    //#[doc(alias = "secret_service_create_collection_dbus_path_sync")]
    //fn create_collection_dbus_path_sync(&self, properties: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 2, id: 201 }, alias: Option<&str>, flags: CollectionCreateFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<glib::GString, glib::Error>;

    //#[doc(alias = "secret_service_create_item_dbus_path_sync")]
    //fn create_item_dbus_path_sync(&self, collection_path: &str, properties: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 2, id: 201 }, value: &Value, flags: ItemCreateFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<glib::GString, glib::Error>;

    #[doc(alias = "secret_service_decode_dbus_secret")]
    fn decode_dbus_secret(&self, value: &glib::Variant) -> Value;

    #[doc(alias = "secret_service_delete_item_dbus_path")]
    fn delete_item_dbus_path<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn delete_item_dbus_path_future(
        &self,
        item_path: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_delete_item_dbus_path_sync")]
    fn delete_item_dbus_path_sync(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "secret_service_encode_dbus_secret")]
    fn encode_dbus_secret(&self, value: &Value) -> glib::Variant;

    #[doc(alias = "secret_service_ensure_session")]
    fn ensure_session<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn ensure_session_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_ensure_session_sync")]
    fn ensure_session_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "secret_service_get_collection_gtype")]
    #[doc(alias = "get_collection_gtype")]
    fn collection_gtype(&self) -> glib::types::Type;

    #[doc(alias = "secret_service_get_collections")]
    #[doc(alias = "get_collections")]
    fn collections(&self) -> Vec<Collection>;

    #[doc(alias = "secret_service_get_flags")]
    #[doc(alias = "get_flags")]
    fn flags(&self) -> ServiceFlags;

    #[doc(alias = "secret_service_get_item_gtype")]
    #[doc(alias = "get_item_gtype")]
    fn item_gtype(&self) -> glib::types::Type;

    #[doc(alias = "secret_service_get_secret_for_dbus_path")]
    #[doc(alias = "get_secret_for_dbus_path")]
    fn secret_for_dbus_path<P: FnOnce(Result<Option<Value>, glib::Error>) + 'static>(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn secret_for_dbus_path_future(
        &self,
        item_path: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Option<Value>, glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_get_secret_for_dbus_path_sync")]
    #[doc(alias = "get_secret_for_dbus_path_sync")]
    fn secret_for_dbus_path_sync(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<Value>, glib::Error>;

    //#[doc(alias = "secret_service_get_secrets_for_dbus_paths_sync")]
    //#[doc(alias = "get_secrets_for_dbus_paths_sync")]
    //fn secrets_for_dbus_paths_sync(&self, item_paths: &str, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result</*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 1, id: 4 }, glib::Error>;

    #[doc(alias = "secret_service_get_session_algorithms")]
    #[doc(alias = "get_session_algorithms")]
    fn session_algorithms(&self) -> Option<glib::GString>;

    #[doc(alias = "secret_service_get_session_dbus_path")]
    #[doc(alias = "get_session_dbus_path")]
    fn session_dbus_path(&self) -> Option<glib::GString>;

    #[doc(alias = "secret_service_load_collections")]
    fn load_collections<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn load_collections_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_load_collections_sync")]
    fn load_collections_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    //#[doc(alias = "secret_service_lock_sync")]
    //fn lock_sync(&self, objects: &[gio::DBusProxy], cancellable: Option<&impl IsA<gio::Cancellable>>, locked: /*Unimplemented*/Vec<gio::DBusProxy>) -> Result<i32, glib::Error>;

    //#[doc(alias = "secret_service_lookup_sync")]
    //fn lookup_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Value, glib::Error>;

    #[doc(alias = "secret_service_prompt")]
    fn prompt<P: FnOnce(Result<glib::Variant, glib::Error>) + 'static>(
        &self,
        prompt: &impl IsA<Prompt>,
        return_type: Option<&glib::VariantTy>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn prompt_future(
        &self,
        prompt: &(impl IsA<Prompt> + Clone + 'static),
        return_type: Option<&glib::VariantTy>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<glib::Variant, glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_prompt_at_dbus_path")]
    fn prompt_at_dbus_path<P: FnOnce(Result<Option<glib::Variant>, glib::Error>) + 'static>(
        &self,
        prompt_path: &str,
        return_type: Option<&glib::VariantTy>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn prompt_at_dbus_path_future(
        &self,
        prompt_path: &str,
        return_type: Option<&glib::VariantTy>,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<Option<glib::Variant>, glib::Error>> + 'static,
        >,
    >;

    #[doc(alias = "secret_service_prompt_at_dbus_path_sync")]
    fn prompt_at_dbus_path_sync(
        &self,
        prompt_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        return_type: Option<&glib::VariantTy>,
    ) -> Result<Option<glib::Variant>, glib::Error>;

    #[doc(alias = "secret_service_prompt_sync")]
    fn prompt_sync(
        &self,
        prompt: &impl IsA<Prompt>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        return_type: &glib::VariantTy,
    ) -> Result<glib::Variant, glib::Error>;

    #[doc(alias = "secret_service_read_alias_dbus_path")]
    fn read_alias_dbus_path<P: FnOnce(Result<Option<glib::GString>, glib::Error>) + 'static>(
        &self,
        alias: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn read_alias_dbus_path_future(
        &self,
        alias: &str,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<Option<glib::GString>, glib::Error>> + 'static,
        >,
    >;

    #[doc(alias = "secret_service_read_alias_dbus_path_sync")]
    fn read_alias_dbus_path_sync(
        &self,
        alias: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<glib::GString>, glib::Error>;

    //#[doc(alias = "secret_service_search_for_dbus_paths_sync")]
    //fn search_for_dbus_paths_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(Vec<glib::GString>, Vec<glib::GString>), glib::Error>;

    //#[doc(alias = "secret_service_search_sync")]
    //fn search_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, flags: SearchFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Vec<Item>, glib::Error>;

    #[doc(alias = "secret_service_set_alias")]
    fn set_alias<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        alias: &str,
        collection: Option<&impl IsA<Collection>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn set_alias_future(
        &self,
        alias: &str,
        collection: Option<&(impl IsA<Collection> + Clone + 'static)>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_set_alias_sync")]
    fn set_alias_sync(
        &self,
        alias: &str,
        collection: Option<&impl IsA<Collection>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "secret_service_set_alias_to_dbus_path")]
    fn set_alias_to_dbus_path<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        alias: &str,
        collection_path: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn set_alias_to_dbus_path_future(
        &self,
        alias: &str,
        collection_path: Option<&str>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_service_set_alias_to_dbus_path_sync")]
    fn set_alias_to_dbus_path_sync(
        &self,
        alias: &str,
        collection_path: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    //#[doc(alias = "secret_service_store_sync")]
    //fn store_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, collection: Option<&str>, label: &str, value: &Value, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error>;

    #[doc(alias = "secret_service_unlock_dbus_paths_sync")]
    fn unlock_dbus_paths_sync(
        &self,
        paths: &[&str],
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(i32, Vec<glib::GString>), glib::Error>;

    //#[doc(alias = "secret_service_unlock_sync")]
    //fn unlock_sync(&self, objects: &[gio::DBusProxy], cancellable: Option<&impl IsA<gio::Cancellable>>, unlocked: /*Unimplemented*/Vec<gio::DBusProxy>) -> Result<i32, glib::Error>;
}

impl<O: IsA<Service>> ServiceExt for O {
    //fn clear_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_clear_sync() }
    //}

    //fn create_collection_dbus_path_sync(&self, properties: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 2, id: 201 }, alias: Option<&str>, flags: CollectionCreateFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<glib::GString, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_create_collection_dbus_path_sync() }
    //}

    //fn create_item_dbus_path_sync(&self, collection_path: &str, properties: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 2, id: 201 }, value: &Value, flags: ItemCreateFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<glib::GString, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_create_item_dbus_path_sync() }
    //}

    fn decode_dbus_secret(&self, value: &glib::Variant) -> Value {
        unsafe {
            from_glib_full(ffi::secret_service_decode_dbus_secret(
                self.as_ref().to_glib_none().0,
                value.to_glib_none().0,
            ))
        }
    }

    fn delete_item_dbus_path<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn delete_item_dbus_path_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_service_delete_item_dbus_path_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = delete_item_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_service_delete_item_dbus_path(
                self.as_ref().to_glib_none().0,
                item_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn delete_item_dbus_path_future(
        &self,
        item_path: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let item_path = String::from(item_path);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.delete_item_dbus_path(&item_path, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn delete_item_dbus_path_sync(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_service_delete_item_dbus_path_sync(
                self.as_ref().to_glib_none().0,
                item_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn encode_dbus_secret(&self, value: &Value) -> glib::Variant {
        unsafe {
            from_glib_none(ffi::secret_service_encode_dbus_secret(
                self.as_ref().to_glib_none().0,
                value.to_glib_none().0,
            ))
        }
    }

    fn ensure_session<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn ensure_session_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_service_ensure_session_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = ensure_session_trampoline::<P>;
        unsafe {
            ffi::secret_service_ensure_session(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn ensure_session_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.ensure_session(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn ensure_session_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_service_ensure_session_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn collection_gtype(&self) -> glib::types::Type {
        unsafe {
            from_glib(ffi::secret_service_get_collection_gtype(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn collections(&self) -> Vec<Collection> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::secret_service_get_collections(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn flags(&self) -> ServiceFlags {
        unsafe {
            from_glib(ffi::secret_service_get_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn item_gtype(&self) -> glib::types::Type {
        unsafe {
            from_glib(ffi::secret_service_get_item_gtype(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn secret_for_dbus_path<P: FnOnce(Result<Option<Value>, glib::Error>) + 'static>(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn secret_for_dbus_path_trampoline<
            P: FnOnce(Result<Option<Value>, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_get_secret_for_dbus_path_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = secret_for_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_service_get_secret_for_dbus_path(
                self.as_ref().to_glib_none().0,
                item_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn secret_for_dbus_path_future(
        &self,
        item_path: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Option<Value>, glib::Error>> + 'static>>
    {
        let item_path = String::from(item_path);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.secret_for_dbus_path(&item_path, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn secret_for_dbus_path_sync(
        &self,
        item_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<Value>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_get_secret_for_dbus_path_sync(
                self.as_ref().to_glib_none().0,
                item_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn secrets_for_dbus_paths_sync(&self, item_paths: &str, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result</*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 1, id: 4 }, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_get_secrets_for_dbus_paths_sync() }
    //}

    fn session_algorithms(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::secret_service_get_session_algorithms(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn session_dbus_path(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::secret_service_get_session_dbus_path(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn load_collections<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn load_collections_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_service_load_collections_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = load_collections_trampoline::<P>;
        unsafe {
            ffi::secret_service_load_collections(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn load_collections_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.load_collections(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn load_collections_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_service_load_collections_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn lock_sync(&self, objects: &[gio::DBusProxy], cancellable: Option<&impl IsA<gio::Cancellable>>, locked: /*Unimplemented*/Vec<gio::DBusProxy>) -> Result<i32, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_lock_sync() }
    //}

    //fn lookup_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Value, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_lookup_sync() }
    //}

    fn prompt<P: FnOnce(Result<glib::Variant, glib::Error>) + 'static>(
        &self,
        prompt: &impl IsA<Prompt>,
        return_type: Option<&glib::VariantTy>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn prompt_trampoline<
            P: FnOnce(Result<glib::Variant, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_prompt_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = prompt_trampoline::<P>;
        unsafe {
            ffi::secret_service_prompt(
                self.as_ref().to_glib_none().0,
                prompt.as_ref().to_glib_none().0,
                return_type.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn prompt_future(
        &self,
        prompt: &(impl IsA<Prompt> + Clone + 'static),
        return_type: Option<&glib::VariantTy>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<glib::Variant, glib::Error>> + 'static>>
    {
        let prompt = prompt.clone();
        let return_type = return_type.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.prompt(
                &prompt,
                return_type.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn prompt_at_dbus_path<P: FnOnce(Result<Option<glib::Variant>, glib::Error>) + 'static>(
        &self,
        prompt_path: &str,
        return_type: Option<&glib::VariantTy>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn prompt_at_dbus_path_trampoline<
            P: FnOnce(Result<Option<glib::Variant>, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_prompt_at_dbus_path_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = prompt_at_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_service_prompt_at_dbus_path(
                self.as_ref().to_glib_none().0,
                prompt_path.to_glib_none().0,
                return_type.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn prompt_at_dbus_path_future(
        &self,
        prompt_path: &str,
        return_type: Option<&glib::VariantTy>,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<Option<glib::Variant>, glib::Error>> + 'static,
        >,
    > {
        let prompt_path = String::from(prompt_path);
        let return_type = return_type.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.prompt_at_dbus_path(
                &prompt_path,
                return_type.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn prompt_at_dbus_path_sync(
        &self,
        prompt_path: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        return_type: Option<&glib::VariantTy>,
    ) -> Result<Option<glib::Variant>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_prompt_at_dbus_path_sync(
                self.as_ref().to_glib_none().0,
                prompt_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                return_type.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn prompt_sync(
        &self,
        prompt: &impl IsA<Prompt>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        return_type: &glib::VariantTy,
    ) -> Result<glib::Variant, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_prompt_sync(
                self.as_ref().to_glib_none().0,
                prompt.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                return_type.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn read_alias_dbus_path<P: FnOnce(Result<Option<glib::GString>, glib::Error>) + 'static>(
        &self,
        alias: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn read_alias_dbus_path_trampoline<
            P: FnOnce(Result<Option<glib::GString>, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_read_alias_dbus_path_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = read_alias_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_service_read_alias_dbus_path(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn read_alias_dbus_path_future(
        &self,
        alias: &str,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<Option<glib::GString>, glib::Error>> + 'static,
        >,
    > {
        let alias = String::from(alias);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.read_alias_dbus_path(&alias, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn read_alias_dbus_path_sync(
        &self,
        alias: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<glib::GString>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_read_alias_dbus_path_sync(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn search_for_dbus_paths_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(Vec<glib::GString>, Vec<glib::GString>), glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_search_for_dbus_paths_sync() }
    //}

    //fn search_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, flags: SearchFlags, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Vec<Item>, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_search_sync() }
    //}

    fn set_alias<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        alias: &str,
        collection: Option<&impl IsA<Collection>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn set_alias_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_service_set_alias_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = set_alias_trampoline::<P>;
        unsafe {
            ffi::secret_service_set_alias(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                collection.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn set_alias_future(
        &self,
        alias: &str,
        collection: Option<&(impl IsA<Collection> + Clone + 'static)>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let alias = String::from(alias);
        let collection = collection.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.set_alias(
                &alias,
                collection.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn set_alias_sync(
        &self,
        alias: &str,
        collection: Option<&impl IsA<Collection>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_service_set_alias_sync(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                collection.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_alias_to_dbus_path<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        alias: &str,
        collection_path: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn set_alias_to_dbus_path_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_service_set_alias_to_dbus_path_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = set_alias_to_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_service_set_alias_to_dbus_path(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                collection_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn set_alias_to_dbus_path_future(
        &self,
        alias: &str,
        collection_path: Option<&str>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let alias = String::from(alias);
        let collection_path = collection_path.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.set_alias_to_dbus_path(
                &alias,
                collection_path.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    fn set_alias_to_dbus_path_sync(
        &self,
        alias: &str,
        collection_path: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_service_set_alias_to_dbus_path_sync(
                self.as_ref().to_glib_none().0,
                alias.to_glib_none().0,
                collection_path.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn store_sync(&self, schema: Option<&Schema>, attributes: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }, collection: Option<&str>, label: &str, value: &Value, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_store_sync() }
    //}

    fn unlock_dbus_paths_sync(
        &self,
        paths: &[&str],
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(i32, Vec<glib::GString>), glib::Error> {
        unsafe {
            let mut unlocked = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::secret_service_unlock_dbus_paths_sync(
                self.as_ref().to_glib_none().0,
                paths.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut unlocked,
                &mut error,
            );
            if error.is_null() {
                Ok((ret, FromGlibPtrContainer::from_glib_full(unlocked)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn unlock_sync(&self, objects: &[gio::DBusProxy], cancellable: Option<&impl IsA<gio::Cancellable>>, unlocked: /*Unimplemented*/Vec<gio::DBusProxy>) -> Result<i32, glib::Error> {
    //    unsafe { TODO: call ffi:secret_service_unlock_sync() }
    //}
}

impl fmt::Display for Service {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Service")
    }
}
