// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::BackendFlags;
use crate::ServiceFlags;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SecretBackend")]
    pub struct Backend(Interface<ffi::SecretBackend, ffi::SecretBackendInterface>);

    match fn {
        type_ => || ffi::secret_backend_get_type(),
    }
}

impl Backend {
    pub const NONE: Option<&'static Backend> = None;

    #[doc(alias = "secret_backend_get")]
    pub fn get<P: FnOnce(Result<Backend, glib::Error>) + 'static>(
        flags: BackendFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn get_trampoline<P: FnOnce(Result<Backend, glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_backend_get_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = get_trampoline::<P>;
        unsafe {
            ffi::secret_backend_get(
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn get_future(
        flags: BackendFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Backend, glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::get(flags, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }
}

pub trait BackendExt: 'static {
    #[cfg(any(feature = "v0_19", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_19")))]
    fn flags(&self) -> ServiceFlags;
}

impl<O: IsA<Backend>> BackendExt for O {
    #[cfg(any(feature = "v0_19", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v0_19")))]
    fn flags(&self) -> ServiceFlags {
        glib::ObjectExt::property(self.as_ref(), "flags")
    }
}

impl fmt::Display for Backend {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Backend")
    }
}
