// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Value;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SecretRetrievable")]
    pub struct Retrievable(Interface<ffi::SecretRetrievable, ffi::SecretRetrievableInterface>);

    match fn {
        type_ => || ffi::secret_retrievable_get_type(),
    }
}

impl Retrievable {
    pub const NONE: Option<&'static Retrievable> = None;
}

pub trait RetrievableExt: 'static {
    #[doc(alias = "secret_retrievable_get_created")]
    #[doc(alias = "get_created")]
    fn created(&self) -> u64;

    #[doc(alias = "secret_retrievable_get_label")]
    #[doc(alias = "get_label")]
    fn label(&self) -> glib::GString;

    #[doc(alias = "secret_retrievable_get_modified")]
    #[doc(alias = "get_modified")]
    fn modified(&self) -> u64;

    #[doc(alias = "secret_retrievable_retrieve_secret")]
    fn retrieve_secret<P: FnOnce(Result<Option<Value>, glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn retrieve_secret_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Option<Value>, glib::Error>> + 'static>>;

    #[doc(alias = "secret_retrievable_retrieve_secret_sync")]
    fn retrieve_secret_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<Value>, glib::Error>;

    //fn set_attributes(&self, attributes: /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 });

    fn set_created(&self, created: u64);

    fn set_label(&self, label: Option<&str>);

    fn set_modified(&self, modified: u64);

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "created")]
    fn connect_created_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "label")]
    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "modified")]
    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Retrievable>> RetrievableExt for O {
    fn created(&self) -> u64 {
        unsafe { ffi::secret_retrievable_get_created(self.as_ref().to_glib_none().0) }
    }

    fn label(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::secret_retrievable_get_label(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn modified(&self) -> u64 {
        unsafe { ffi::secret_retrievable_get_modified(self.as_ref().to_glib_none().0) }
    }

    fn retrieve_secret<P: FnOnce(Result<Option<Value>, glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn retrieve_secret_trampoline<
            P: FnOnce(Result<Option<Value>, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_retrievable_retrieve_secret_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = retrieve_secret_trampoline::<P>;
        unsafe {
            ffi::secret_retrievable_retrieve_secret(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn retrieve_secret_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Option<Value>, glib::Error>> + 'static>>
    {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.retrieve_secret(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn retrieve_secret_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Option<Value>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_retrievable_retrieve_secret_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn set_attributes(&self, attributes: /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }) {
    //    glib::ObjectExt::set_property(self.as_ref(),"attributes", &attributes)
    //}

    fn set_created(&self, created: u64) {
        glib::ObjectExt::set_property(self.as_ref(), "created", &created)
    }

    fn set_label(&self, label: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "label", &label)
    }

    fn set_modified(&self, modified: u64) {
        glib::ObjectExt::set_property(self.as_ref(), "modified", &modified)
    }

    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<
            P: IsA<Retrievable>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SecretRetrievable,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Retrievable::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_created_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_created_trampoline<P: IsA<Retrievable>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretRetrievable,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Retrievable::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::created\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_created_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_trampoline<P: IsA<Retrievable>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretRetrievable,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Retrievable::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modified_trampoline<
            P: IsA<Retrievable>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SecretRetrievable,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Retrievable::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modified\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modified_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Retrievable {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Retrievable")
    }
}
