// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SecretBackendFlags")]
pub enum BackendFlags {
    #[doc(alias = "SECRET_BACKEND_NONE")]
    None,
    #[doc(alias = "SECRET_BACKEND_OPEN_SESSION")]
    OpenSession,
    #[doc(alias = "SECRET_BACKEND_LOAD_COLLECTIONS")]
    LoadCollections,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for BackendFlags {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BackendFlags::{}",
            match *self {
                Self::None => "None",
                Self::OpenSession => "OpenSession",
                Self::LoadCollections => "LoadCollections",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for BackendFlags {
    type GlibType = ffi::SecretBackendFlags;

    fn into_glib(self) -> ffi::SecretBackendFlags {
        match self {
            Self::None => ffi::SECRET_BACKEND_NONE,
            Self::OpenSession => ffi::SECRET_BACKEND_OPEN_SESSION,
            Self::LoadCollections => ffi::SECRET_BACKEND_LOAD_COLLECTIONS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SecretBackendFlags> for BackendFlags {
    unsafe fn from_glib(value: ffi::SecretBackendFlags) -> Self {
        match value {
            ffi::SECRET_BACKEND_NONE => Self::None,
            ffi::SECRET_BACKEND_OPEN_SESSION => Self::OpenSession,
            ffi::SECRET_BACKEND_LOAD_COLLECTIONS => Self::LoadCollections,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for BackendFlags {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::secret_backend_flags_get_type()) }
    }
}

impl glib::value::ValueType for BackendFlags {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for BackendFlags {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for BackendFlags {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SecretError")]
pub enum Error {
    #[doc(alias = "SECRET_ERROR_PROTOCOL")]
    Protocol,
    #[doc(alias = "SECRET_ERROR_IS_LOCKED")]
    IsLocked,
    #[doc(alias = "SECRET_ERROR_NO_SUCH_OBJECT")]
    NoSuchObject,
    #[doc(alias = "SECRET_ERROR_ALREADY_EXISTS")]
    AlreadyExists,
    #[doc(alias = "SECRET_ERROR_INVALID_FILE_FORMAT")]
    InvalidFileFormat,
    #[doc(hidden)]
    __Unknown(i32),
}

impl Error {
    #[doc(alias = "secret_error_get_quark")]
    #[doc(alias = "get_quark")]
    pub fn quark() -> glib::Quark {
        unsafe { from_glib(ffi::secret_error_get_quark()) }
    }
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Error::{}",
            match *self {
                Self::Protocol => "Protocol",
                Self::IsLocked => "IsLocked",
                Self::NoSuchObject => "NoSuchObject",
                Self::AlreadyExists => "AlreadyExists",
                Self::InvalidFileFormat => "InvalidFileFormat",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Error {
    type GlibType = ffi::SecretError;

    fn into_glib(self) -> ffi::SecretError {
        match self {
            Self::Protocol => ffi::SECRET_ERROR_PROTOCOL,
            Self::IsLocked => ffi::SECRET_ERROR_IS_LOCKED,
            Self::NoSuchObject => ffi::SECRET_ERROR_NO_SUCH_OBJECT,
            Self::AlreadyExists => ffi::SECRET_ERROR_ALREADY_EXISTS,
            Self::InvalidFileFormat => ffi::SECRET_ERROR_INVALID_FILE_FORMAT,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SecretError> for Error {
    unsafe fn from_glib(value: ffi::SecretError) -> Self {
        match value {
            ffi::SECRET_ERROR_PROTOCOL => Self::Protocol,
            ffi::SECRET_ERROR_IS_LOCKED => Self::IsLocked,
            ffi::SECRET_ERROR_NO_SUCH_OBJECT => Self::NoSuchObject,
            ffi::SECRET_ERROR_ALREADY_EXISTS => Self::AlreadyExists,
            ffi::SECRET_ERROR_INVALID_FILE_FORMAT => Self::InvalidFileFormat,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for Error {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::secret_error_get_type()) }
    }
}

impl glib::value::ValueType for Error {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Error {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Error {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SecretSchemaAttributeType")]
pub enum SchemaAttributeType {
    #[doc(alias = "SECRET_SCHEMA_ATTRIBUTE_STRING")]
    String,
    #[doc(alias = "SECRET_SCHEMA_ATTRIBUTE_INTEGER")]
    Integer,
    #[doc(alias = "SECRET_SCHEMA_ATTRIBUTE_BOOLEAN")]
    Boolean,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SchemaAttributeType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SchemaAttributeType::{}",
            match *self {
                Self::String => "String",
                Self::Integer => "Integer",
                Self::Boolean => "Boolean",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SchemaAttributeType {
    type GlibType = ffi::SecretSchemaAttributeType;

    fn into_glib(self) -> ffi::SecretSchemaAttributeType {
        match self {
            Self::String => ffi::SECRET_SCHEMA_ATTRIBUTE_STRING,
            Self::Integer => ffi::SECRET_SCHEMA_ATTRIBUTE_INTEGER,
            Self::Boolean => ffi::SECRET_SCHEMA_ATTRIBUTE_BOOLEAN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SecretSchemaAttributeType> for SchemaAttributeType {
    unsafe fn from_glib(value: ffi::SecretSchemaAttributeType) -> Self {
        match value {
            ffi::SECRET_SCHEMA_ATTRIBUTE_STRING => Self::String,
            ffi::SECRET_SCHEMA_ATTRIBUTE_INTEGER => Self::Integer,
            ffi::SECRET_SCHEMA_ATTRIBUTE_BOOLEAN => Self::Boolean,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SchemaAttributeType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::secret_schema_attribute_type_get_type()) }
    }
}

impl glib::value::ValueType for SchemaAttributeType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SchemaAttributeType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SchemaAttributeType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "SecretSchemaType")]
pub enum SchemaType {
    #[doc(alias = "SECRET_SCHEMA_TYPE_NOTE")]
    Note,
    #[doc(alias = "SECRET_SCHEMA_TYPE_COMPAT_NETWORK")]
    CompatNetwork,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for SchemaType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "SchemaType::{}",
            match *self {
                Self::Note => "Note",
                Self::CompatNetwork => "CompatNetwork",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for SchemaType {
    type GlibType = ffi::SecretSchemaType;

    fn into_glib(self) -> ffi::SecretSchemaType {
        match self {
            Self::Note => ffi::SECRET_SCHEMA_TYPE_NOTE,
            Self::CompatNetwork => ffi::SECRET_SCHEMA_TYPE_COMPAT_NETWORK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::SecretSchemaType> for SchemaType {
    unsafe fn from_glib(value: ffi::SecretSchemaType) -> Self {
        match value {
            ffi::SECRET_SCHEMA_TYPE_NOTE => Self::Note,
            ffi::SECRET_SCHEMA_TYPE_COMPAT_NETWORK => Self::CompatNetwork,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for SchemaType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::secret_schema_type_get_type()) }
    }
}

impl glib::value::ValueType for SchemaType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SchemaType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for SchemaType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
