// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::CollectionCreateFlags;
use crate::CollectionFlags;
use crate::Item;
use crate::Service;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SecretCollection")]
    pub struct Collection(Object<ffi::SecretCollection, ffi::SecretCollectionClass>) @extends gio::DBusProxy, @implements gio::DBusInterface, gio::Initable;

    match fn {
        type_ => || ffi::secret_collection_get_type(),
    }
}

impl Collection {
    pub const NONE: Option<&'static Collection> = None;

    #[doc(alias = "secret_collection_new_for_dbus_path_sync")]
    #[doc(alias = "new_for_dbus_path_sync")]
    pub fn for_dbus_path_sync(
        service: Option<&impl IsA<Service>>,
        collection_path: &str,
        flags: CollectionFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Collection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_new_for_dbus_path_sync(
                service.map(|p| p.as_ref()).to_glib_none().0,
                collection_path.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "secret_collection_create")]
    pub fn create<P: FnOnce(Result<Collection, glib::Error>) + 'static>(
        service: Option<&impl IsA<Service>>,
        label: &str,
        alias: Option<&str>,
        flags: CollectionCreateFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn create_trampoline<
            P: FnOnce(Result<Collection, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_create_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = create_trampoline::<P>;
        unsafe {
            ffi::secret_collection_create(
                service.map(|p| p.as_ref()).to_glib_none().0,
                label.to_glib_none().0,
                alias.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn create_future(
        service: Option<&(impl IsA<Service> + Clone + 'static)>,
        label: &str,
        alias: Option<&str>,
        flags: CollectionCreateFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Collection, glib::Error>> + 'static>>
    {
        let service = service.map(ToOwned::to_owned);
        let label = String::from(label);
        let alias = alias.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::create(
                service.as_ref().map(::std::borrow::Borrow::borrow),
                &label,
                alias.as_ref().map(::std::borrow::Borrow::borrow),
                flags,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "secret_collection_create_sync")]
    pub fn create_sync(
        service: Option<&impl IsA<Service>>,
        label: &str,
        alias: Option<&str>,
        flags: CollectionCreateFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Collection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_create_sync(
                service.map(|p| p.as_ref()).to_glib_none().0,
                label.to_glib_none().0,
                alias.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "secret_collection_for_alias")]
    pub fn for_alias<P: FnOnce(Result<Collection, glib::Error>) + 'static>(
        service: Option<&impl IsA<Service>>,
        alias: &str,
        flags: CollectionFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn for_alias_trampoline<
            P: FnOnce(Result<Collection, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_for_alias_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = for_alias_trampoline::<P>;
        unsafe {
            ffi::secret_collection_for_alias(
                service.map(|p| p.as_ref()).to_glib_none().0,
                alias.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn for_alias_future(
        service: Option<&(impl IsA<Service> + Clone + 'static)>,
        alias: &str,
        flags: CollectionFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Collection, glib::Error>> + 'static>>
    {
        let service = service.map(ToOwned::to_owned);
        let alias = String::from(alias);
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::for_alias(
                service.as_ref().map(::std::borrow::Borrow::borrow),
                &alias,
                flags,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "secret_collection_for_alias_sync")]
    pub fn for_alias_sync(
        service: Option<&impl IsA<Service>>,
        alias: &str,
        flags: CollectionFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Collection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_for_alias_sync(
                service.map(|p| p.as_ref()).to_glib_none().0,
                alias.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "secret_collection_new_for_dbus_path")]
    pub fn new_for_dbus_path<P: FnOnce(Result<Collection, glib::Error>) + 'static>(
        service: Option<&impl IsA<Service>>,
        collection_path: &str,
        flags: CollectionFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn new_for_dbus_path_trampoline<
            P: FnOnce(Result<Collection, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::secret_collection_new_for_dbus_path_finish(res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = new_for_dbus_path_trampoline::<P>;
        unsafe {
            ffi::secret_collection_new_for_dbus_path(
                service.map(|p| p.as_ref()).to_glib_none().0,
                collection_path.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn new_for_dbus_path_future(
        service: Option<&(impl IsA<Service> + Clone + 'static)>,
        collection_path: &str,
        flags: CollectionFlags,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<Collection, glib::Error>> + 'static>>
    {
        let service = service.map(ToOwned::to_owned);
        let collection_path = String::from(collection_path);
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::new_for_dbus_path(
                service.as_ref().map(::std::borrow::Borrow::borrow),
                &collection_path,
                flags,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }
}

pub trait CollectionExt: 'static {
    #[doc(alias = "secret_collection_delete")]
    fn delete<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn delete_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_collection_delete_sync")]
    fn delete_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "secret_collection_get_created")]
    #[doc(alias = "get_created")]
    fn created(&self) -> u64;

    #[doc(alias = "secret_collection_get_flags")]
    #[doc(alias = "get_flags")]
    fn flags(&self) -> CollectionFlags;

    #[doc(alias = "secret_collection_get_items")]
    #[doc(alias = "get_items")]
    fn items(&self) -> Vec<Item>;

    #[doc(alias = "secret_collection_get_label")]
    #[doc(alias = "get_label")]
    fn label(&self) -> glib::GString;

    #[doc(alias = "secret_collection_get_locked")]
    #[doc(alias = "get_locked")]
    fn is_locked(&self) -> bool;

    #[doc(alias = "secret_collection_get_modified")]
    #[doc(alias = "get_modified")]
    fn modified(&self) -> u64;

    #[doc(alias = "secret_collection_get_service")]
    #[doc(alias = "get_service")]
    fn service(&self) -> Service;

    #[doc(alias = "secret_collection_load_items")]
    fn load_items<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn load_items_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_collection_load_items_sync")]
    fn load_items_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "secret_collection_refresh")]
    fn refresh(&self);

    #[doc(alias = "secret_collection_set_label")]
    fn set_label<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        label: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    );

    fn set_label_future(
        &self,
        label: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "secret_collection_set_label_sync")]
    fn set_label_sync(
        &self,
        label: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    fn set_created(&self, created: u64);

    fn set_modified(&self, modified: u64);

    #[doc(alias = "created")]
    fn connect_created_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "label")]
    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "locked")]
    fn connect_locked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "modified")]
    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Collection>> CollectionExt for O {
    fn delete<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn delete_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::secret_collection_delete_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = delete_trampoline::<P>;
        unsafe {
            ffi::secret_collection_delete(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn delete_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.delete(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn delete_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_collection_delete_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn created(&self) -> u64 {
        unsafe { ffi::secret_collection_get_created(self.as_ref().to_glib_none().0) }
    }

    fn flags(&self) -> CollectionFlags {
        unsafe {
            from_glib(ffi::secret_collection_get_flags(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn items(&self) -> Vec<Item> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::secret_collection_get_items(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn label(&self) -> glib::GString {
        unsafe {
            from_glib_full(ffi::secret_collection_get_label(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_locked(&self) -> bool {
        unsafe {
            from_glib(ffi::secret_collection_get_locked(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn modified(&self) -> u64 {
        unsafe { ffi::secret_collection_get_modified(self.as_ref().to_glib_none().0) }
    }

    fn service(&self) -> Service {
        unsafe {
            from_glib_none(ffi::secret_collection_get_service(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn load_items<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn load_items_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ =
                ffi::secret_collection_load_items_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = load_items_trampoline::<P>;
        unsafe {
            ffi::secret_collection_load_items(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn load_items_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.load_items(Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn load_items_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_collection_load_items_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn refresh(&self) {
        unsafe {
            ffi::secret_collection_refresh(self.as_ref().to_glib_none().0);
        }
    }

    fn set_label<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        label: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn set_label_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ =
                ffi::secret_collection_set_label_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = set_label_trampoline::<P>;
        unsafe {
            ffi::secret_collection_set_label(
                self.as_ref().to_glib_none().0,
                label.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn set_label_future(
        &self,
        label: &str,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let label = String::from(label);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.set_label(&label, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    fn set_label_sync(
        &self,
        label: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::secret_collection_set_label_sync(
                self.as_ref().to_glib_none().0,
                label.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_created(&self, created: u64) {
        glib::ObjectExt::set_property(self.as_ref(), "created", &created)
    }

    fn set_modified(&self, modified: u64) {
        glib::ObjectExt::set_property(self.as_ref(), "modified", &modified)
    }

    fn connect_created_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_created_trampoline<P: IsA<Collection>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretCollection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Collection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::created\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_created_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_trampoline<P: IsA<Collection>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretCollection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Collection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_locked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_locked_trampoline<P: IsA<Collection>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretCollection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Collection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::locked\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_locked_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modified_trampoline<P: IsA<Collection>, F: Fn(&P) + 'static>(
            this: *mut ffi::SecretCollection,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Collection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modified\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modified_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Collection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Collection")
    }
}
