// Generated by gir (https://github.com/gtk-rs/gir @ e0d8d8d645b1)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 86743c80d34b)
// DO NOT EDIT

use libsecret_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["libsecret-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
#[cfg(target_os = "linux")]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
#[cfg(target_os = "linux")]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "SecretBackendFlags",
        Layout {
            size: size_of::<SecretBackendFlags>(),
            alignment: align_of::<SecretBackendFlags>(),
        },
    ),
    (
        "SecretBackendInterface",
        Layout {
            size: size_of::<SecretBackendInterface>(),
            alignment: align_of::<SecretBackendInterface>(),
        },
    ),
    (
        "SecretCollection",
        Layout {
            size: size_of::<SecretCollection>(),
            alignment: align_of::<SecretCollection>(),
        },
    ),
    (
        "SecretCollectionClass",
        Layout {
            size: size_of::<SecretCollectionClass>(),
            alignment: align_of::<SecretCollectionClass>(),
        },
    ),
    (
        "SecretCollectionCreateFlags",
        Layout {
            size: size_of::<SecretCollectionCreateFlags>(),
            alignment: align_of::<SecretCollectionCreateFlags>(),
        },
    ),
    (
        "SecretCollectionFlags",
        Layout {
            size: size_of::<SecretCollectionFlags>(),
            alignment: align_of::<SecretCollectionFlags>(),
        },
    ),
    (
        "SecretError",
        Layout {
            size: size_of::<SecretError>(),
            alignment: align_of::<SecretError>(),
        },
    ),
    (
        "SecretItem",
        Layout {
            size: size_of::<SecretItem>(),
            alignment: align_of::<SecretItem>(),
        },
    ),
    (
        "SecretItemClass",
        Layout {
            size: size_of::<SecretItemClass>(),
            alignment: align_of::<SecretItemClass>(),
        },
    ),
    (
        "SecretItemCreateFlags",
        Layout {
            size: size_of::<SecretItemCreateFlags>(),
            alignment: align_of::<SecretItemCreateFlags>(),
        },
    ),
    (
        "SecretItemFlags",
        Layout {
            size: size_of::<SecretItemFlags>(),
            alignment: align_of::<SecretItemFlags>(),
        },
    ),
    (
        "SecretPrompt",
        Layout {
            size: size_of::<SecretPrompt>(),
            alignment: align_of::<SecretPrompt>(),
        },
    ),
    (
        "SecretPromptClass",
        Layout {
            size: size_of::<SecretPromptClass>(),
            alignment: align_of::<SecretPromptClass>(),
        },
    ),
    (
        "SecretRetrievableInterface",
        Layout {
            size: size_of::<SecretRetrievableInterface>(),
            alignment: align_of::<SecretRetrievableInterface>(),
        },
    ),
    (
        "SecretSchema",
        Layout {
            size: size_of::<SecretSchema>(),
            alignment: align_of::<SecretSchema>(),
        },
    ),
    (
        "SecretSchemaAttribute",
        Layout {
            size: size_of::<SecretSchemaAttribute>(),
            alignment: align_of::<SecretSchemaAttribute>(),
        },
    ),
    (
        "SecretSchemaAttributeType",
        Layout {
            size: size_of::<SecretSchemaAttributeType>(),
            alignment: align_of::<SecretSchemaAttributeType>(),
        },
    ),
    (
        "SecretSchemaFlags",
        Layout {
            size: size_of::<SecretSchemaFlags>(),
            alignment: align_of::<SecretSchemaFlags>(),
        },
    ),
    (
        "SecretSchemaType",
        Layout {
            size: size_of::<SecretSchemaType>(),
            alignment: align_of::<SecretSchemaType>(),
        },
    ),
    (
        "SecretSearchFlags",
        Layout {
            size: size_of::<SecretSearchFlags>(),
            alignment: align_of::<SecretSearchFlags>(),
        },
    ),
    (
        "SecretService",
        Layout {
            size: size_of::<SecretService>(),
            alignment: align_of::<SecretService>(),
        },
    ),
    (
        "SecretServiceClass",
        Layout {
            size: size_of::<SecretServiceClass>(),
            alignment: align_of::<SecretServiceClass>(),
        },
    ),
    (
        "SecretServiceFlags",
        Layout {
            size: size_of::<SecretServiceFlags>(),
            alignment: align_of::<SecretServiceFlags>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("SECRET_BACKEND_EXTENSION_POINT_NAME", "secret-backend"),
    ("(gint) SECRET_BACKEND_LOAD_COLLECTIONS", "4"),
    ("(gint) SECRET_BACKEND_NONE", "0"),
    ("(gint) SECRET_BACKEND_OPEN_SESSION", "2"),
    ("(guint) SECRET_COLLECTION_CREATE_NONE", "0"),
    ("SECRET_COLLECTION_DEFAULT", "default"),
    ("(guint) SECRET_COLLECTION_LOAD_ITEMS", "2"),
    ("(guint) SECRET_COLLECTION_NONE", "0"),
    ("SECRET_COLLECTION_SESSION", "session"),
    ("(gint) SECRET_ERROR_ALREADY_EXISTS", "4"),
    ("(gint) SECRET_ERROR_INVALID_FILE_FORMAT", "5"),
    ("(gint) SECRET_ERROR_IS_LOCKED", "2"),
    ("(gint) SECRET_ERROR_NO_SUCH_OBJECT", "3"),
    ("(gint) SECRET_ERROR_PROTOCOL", "1"),
    ("(guint) SECRET_ITEM_CREATE_NONE", "0"),
    ("(guint) SECRET_ITEM_CREATE_REPLACE", "2"),
    ("(guint) SECRET_ITEM_LOAD_SECRET", "2"),
    ("(guint) SECRET_ITEM_NONE", "0"),
    ("(gint) SECRET_SCHEMA_ATTRIBUTE_BOOLEAN", "2"),
    ("(gint) SECRET_SCHEMA_ATTRIBUTE_INTEGER", "1"),
    ("(gint) SECRET_SCHEMA_ATTRIBUTE_STRING", "0"),
    ("(guint) SECRET_SCHEMA_DONT_MATCH_NAME", "2"),
    ("(guint) SECRET_SCHEMA_NONE", "0"),
    ("(gint) SECRET_SCHEMA_TYPE_COMPAT_NETWORK", "1"),
    ("(gint) SECRET_SCHEMA_TYPE_NOTE", "0"),
    ("(guint) SECRET_SEARCH_ALL", "2"),
    ("(guint) SECRET_SEARCH_LOAD_SECRETS", "8"),
    ("(guint) SECRET_SEARCH_NONE", "0"),
    ("(guint) SECRET_SEARCH_UNLOCK", "4"),
    ("(guint) SECRET_SERVICE_LOAD_COLLECTIONS", "4"),
    ("(guint) SECRET_SERVICE_NONE", "0"),
    ("(guint) SECRET_SERVICE_OPEN_SESSION", "2"),
];
