// Generated by gir (https://github.com/gtk-rs/gir @ e0d8d8d645b1)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 86743c80d34b)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(feature = "dox", feature(doc_cfg))]

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type SecretBackendFlags = c_int;
pub const SECRET_BACKEND_NONE: SecretBackendFlags = 0;
pub const SECRET_BACKEND_OPEN_SESSION: SecretBackendFlags = 2;
pub const SECRET_BACKEND_LOAD_COLLECTIONS: SecretBackendFlags = 4;

pub type SecretError = c_int;
pub const SECRET_ERROR_PROTOCOL: SecretError = 1;
pub const SECRET_ERROR_IS_LOCKED: SecretError = 2;
pub const SECRET_ERROR_NO_SUCH_OBJECT: SecretError = 3;
pub const SECRET_ERROR_ALREADY_EXISTS: SecretError = 4;
pub const SECRET_ERROR_INVALID_FILE_FORMAT: SecretError = 5;

pub type SecretSchemaAttributeType = c_int;
pub const SECRET_SCHEMA_ATTRIBUTE_STRING: SecretSchemaAttributeType = 0;
pub const SECRET_SCHEMA_ATTRIBUTE_INTEGER: SecretSchemaAttributeType = 1;
pub const SECRET_SCHEMA_ATTRIBUTE_BOOLEAN: SecretSchemaAttributeType = 2;

pub type SecretSchemaType = c_int;
pub const SECRET_SCHEMA_TYPE_NOTE: SecretSchemaType = 0;
pub const SECRET_SCHEMA_TYPE_COMPAT_NETWORK: SecretSchemaType = 1;

// Constants
pub const SECRET_BACKEND_EXTENSION_POINT_NAME: *const c_char =
    b"secret-backend\0" as *const u8 as *const c_char;
pub const SECRET_COLLECTION_DEFAULT: *const c_char = b"default\0" as *const u8 as *const c_char;
pub const SECRET_COLLECTION_SESSION: *const c_char = b"session\0" as *const u8 as *const c_char;

// Flags
pub type SecretCollectionCreateFlags = c_uint;
pub const SECRET_COLLECTION_CREATE_NONE: SecretCollectionCreateFlags = 0;

pub type SecretCollectionFlags = c_uint;
pub const SECRET_COLLECTION_NONE: SecretCollectionFlags = 0;
pub const SECRET_COLLECTION_LOAD_ITEMS: SecretCollectionFlags = 2;

pub type SecretItemCreateFlags = c_uint;
pub const SECRET_ITEM_CREATE_NONE: SecretItemCreateFlags = 0;
pub const SECRET_ITEM_CREATE_REPLACE: SecretItemCreateFlags = 2;

pub type SecretItemFlags = c_uint;
pub const SECRET_ITEM_NONE: SecretItemFlags = 0;
pub const SECRET_ITEM_LOAD_SECRET: SecretItemFlags = 2;

pub type SecretSchemaFlags = c_uint;
pub const SECRET_SCHEMA_NONE: SecretSchemaFlags = 0;
pub const SECRET_SCHEMA_DONT_MATCH_NAME: SecretSchemaFlags = 2;

pub type SecretSearchFlags = c_uint;
pub const SECRET_SEARCH_NONE: SecretSearchFlags = 0;
pub const SECRET_SEARCH_ALL: SecretSearchFlags = 2;
pub const SECRET_SEARCH_UNLOCK: SecretSearchFlags = 4;
pub const SECRET_SEARCH_LOAD_SECRETS: SecretSearchFlags = 8;

pub type SecretServiceFlags = c_uint;
pub const SECRET_SERVICE_NONE: SecretServiceFlags = 0;
pub const SECRET_SERVICE_OPEN_SESSION: SecretServiceFlags = 2;
pub const SECRET_SERVICE_LOAD_COLLECTIONS: SecretServiceFlags = 4;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretBackendInterface {
    pub parent_iface: gobject::GTypeInterface,
    pub ensure_for_flags: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            SecretBackendFlags,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub ensure_for_flags_finish: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub store: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *const SecretSchema,
            *mut glib::GHashTable,
            *const c_char,
            *const c_char,
            *mut SecretValue,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub store_finish: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub lookup: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *const SecretSchema,
            *mut glib::GHashTable,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub lookup_finish: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> *mut SecretValue,
    >,
    pub clear: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *const SecretSchema,
            *mut glib::GHashTable,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub clear_finish: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> gboolean,
    >,
    pub search: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *const SecretSchema,
            *mut glib::GHashTable,
            SecretSearchFlags,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub search_finish: Option<
        unsafe extern "C" fn(
            *mut SecretBackend,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> *mut glib::GList,
    >,
}

impl ::std::fmt::Debug for SecretBackendInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretBackendInterface @ {:p}", self))
            .field("parent_iface", &self.parent_iface)
            .field("ensure_for_flags", &self.ensure_for_flags)
            .field("ensure_for_flags_finish", &self.ensure_for_flags_finish)
            .field("store", &self.store)
            .field("store_finish", &self.store_finish)
            .field("lookup", &self.lookup)
            .field("lookup_finish", &self.lookup_finish)
            .field("clear", &self.clear)
            .field("clear_finish", &self.clear_finish)
            .field("search", &self.search)
            .field("search_finish", &self.search_finish)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretCollectionClass {
    pub parent_class: gio::GDBusProxyClass,
    pub padding: [gpointer; 8],
}

impl ::std::fmt::Debug for SecretCollectionClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretCollectionClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SecretCollectionPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type SecretCollectionPrivate = *mut _SecretCollectionPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretItemClass {
    pub parent_class: gio::GDBusProxyClass,
    pub padding: [gpointer; 4],
}

impl ::std::fmt::Debug for SecretItemClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretItemClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SecretItemPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type SecretItemPrivate = *mut _SecretItemPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretPromptClass {
    pub parent_class: gio::GDBusProxyClass,
    pub padding: [gpointer; 8],
}

impl ::std::fmt::Debug for SecretPromptClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretPromptClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _SecretPromptPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type SecretPromptPrivate = *mut _SecretPromptPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretRetrievableInterface {
    pub parent_iface: gobject::GTypeInterface,
    pub retrieve_secret: Option<
        unsafe extern "C" fn(
            *mut SecretRetrievable,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub retrieve_secret_finish: Option<
        unsafe extern "C" fn(
            *mut SecretRetrievable,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> *mut SecretValue,
    >,
}

impl ::std::fmt::Debug for SecretRetrievableInterface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretRetrievableInterface @ {:p}", self))
            .field("parent_iface", &self.parent_iface)
            .field("retrieve_secret", &self.retrieve_secret)
            .field("retrieve_secret_finish", &self.retrieve_secret_finish)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretSchema {
    pub name: *const c_char,
    pub flags: SecretSchemaFlags,
    pub attributes: [SecretSchemaAttribute; 32],
    pub reserved: c_int,
    pub reserved1: gpointer,
    pub reserved2: gpointer,
    pub reserved3: gpointer,
    pub reserved4: gpointer,
    pub reserved5: gpointer,
    pub reserved6: gpointer,
    pub reserved7: gpointer,
}

impl ::std::fmt::Debug for SecretSchema {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretSchema @ {:p}", self))
            .field("name", &self.name)
            .field("flags", &self.flags)
            .field("attributes", &self.attributes)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretSchemaAttribute {
    pub name: *const c_char,
    pub type_: SecretSchemaAttributeType,
}

impl ::std::fmt::Debug for SecretSchemaAttribute {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretSchemaAttribute @ {:p}", self))
            .field("name", &self.name)
            .field("type_", &self.type_)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretServiceClass {
    pub parent_class: gio::GDBusProxyClass,
    pub collection_gtype: GType,
    pub item_gtype: GType,
    pub prompt_sync: Option<
        unsafe extern "C" fn(
            *mut SecretService,
            *mut SecretPrompt,
            *mut gio::GCancellable,
            *const glib::GVariantType,
            *mut *mut glib::GError,
        ) -> *mut glib::GVariant,
    >,
    pub prompt_async: Option<
        unsafe extern "C" fn(
            *mut SecretService,
            *mut SecretPrompt,
            *const glib::GVariantType,
            *mut gio::GCancellable,
            gio::GAsyncReadyCallback,
            gpointer,
        ),
    >,
    pub prompt_finish: Option<
        unsafe extern "C" fn(
            *mut SecretService,
            *mut gio::GAsyncResult,
            *mut *mut glib::GError,
        ) -> *mut glib::GVariant,
    >,
    pub get_collection_gtype: Option<unsafe extern "C" fn(*mut SecretService) -> GType>,
    pub get_item_gtype: Option<unsafe extern "C" fn(*mut SecretService) -> GType>,
    pub padding: [gpointer; 14],
}

impl ::std::fmt::Debug for SecretServiceClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretServiceClass @ {:p}", self))
            .field("parent_class", &self.parent_class)
            .field("collection_gtype", &self.collection_gtype)
            .field("item_gtype", &self.item_gtype)
            .field("prompt_sync", &self.prompt_sync)
            .field("prompt_async", &self.prompt_async)
            .field("prompt_finish", &self.prompt_finish)
            .field("get_collection_gtype", &self.get_collection_gtype)
            .field("get_item_gtype", &self.get_item_gtype)
            .finish()
    }
}

#[repr(C)]
pub struct _SecretServicePrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type SecretServicePrivate = *mut _SecretServicePrivate;

#[repr(C)]
pub struct SecretValue {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for SecretValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretValue @ {:p}", self))
            .finish()
    }
}

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretCollection {
    pub parent: gio::GDBusProxy,
    pub pv: *mut SecretCollectionPrivate,
}

impl ::std::fmt::Debug for SecretCollection {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretCollection @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretItem {
    pub parent_instance: gio::GDBusProxy,
    pub pv: *mut SecretItemPrivate,
}

impl ::std::fmt::Debug for SecretItem {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretItem @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretPrompt {
    pub parent_instance: gio::GDBusProxy,
    pub pv: *mut SecretPromptPrivate,
}

impl ::std::fmt::Debug for SecretPrompt {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretPrompt @ {:p}", self))
            .field("parent_instance", &self.parent_instance)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct SecretService {
    pub parent: gio::GDBusProxy,
    pub pv: *mut SecretServicePrivate,
}

impl ::std::fmt::Debug for SecretService {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("SecretService @ {:p}", self))
            .field("parent", &self.parent)
            .finish()
    }
}

// Interfaces
#[repr(C)]
pub struct SecretBackend {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for SecretBackend {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "SecretBackend @ {:p}", self)
    }
}

#[repr(C)]
pub struct SecretRetrievable {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

impl ::std::fmt::Debug for SecretRetrievable {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "SecretRetrievable @ {:p}", self)
    }
}

#[link(name = "secret-1")]
extern "C" {

    //=========================================================================
    // SecretBackendFlags
    //=========================================================================
    pub fn secret_backend_flags_get_type() -> GType;

    //=========================================================================
    // SecretError
    //=========================================================================
    pub fn secret_error_get_type() -> GType;
    pub fn secret_error_get_quark() -> glib::GQuark;

    //=========================================================================
    // SecretSchemaAttributeType
    //=========================================================================
    pub fn secret_schema_attribute_type_get_type() -> GType;

    //=========================================================================
    // SecretSchemaType
    //=========================================================================
    pub fn secret_schema_type_get_type() -> GType;

    //=========================================================================
    // SecretCollectionCreateFlags
    //=========================================================================
    pub fn secret_collection_create_flags_get_type() -> GType;

    //=========================================================================
    // SecretCollectionFlags
    //=========================================================================
    pub fn secret_collection_flags_get_type() -> GType;

    //=========================================================================
    // SecretItemCreateFlags
    //=========================================================================
    pub fn secret_item_create_flags_get_type() -> GType;

    //=========================================================================
    // SecretItemFlags
    //=========================================================================
    pub fn secret_item_flags_get_type() -> GType;

    //=========================================================================
    // SecretSchemaFlags
    //=========================================================================
    pub fn secret_schema_flags_get_type() -> GType;

    //=========================================================================
    // SecretSearchFlags
    //=========================================================================
    pub fn secret_search_flags_get_type() -> GType;

    //=========================================================================
    // SecretServiceFlags
    //=========================================================================
    pub fn secret_service_flags_get_type() -> GType;

    //=========================================================================
    // SecretSchema
    //=========================================================================
    pub fn secret_schema_get_type() -> GType;
    pub fn secret_schema_new(
        name: *const c_char,
        flags: SecretSchemaFlags,
        ...
    ) -> *mut SecretSchema;
    pub fn secret_schema_newv(
        name: *const c_char,
        flags: SecretSchemaFlags,
        attribute_names_and_types: *mut glib::GHashTable,
    ) -> *mut SecretSchema;
    pub fn secret_schema_ref(schema: *mut SecretSchema) -> *mut SecretSchema;
    pub fn secret_schema_unref(schema: *mut SecretSchema);

    //=========================================================================
    // SecretSchemaAttribute
    //=========================================================================
    pub fn secret_schema_attribute_get_type() -> GType;

    //=========================================================================
    // SecretValue
    //=========================================================================
    pub fn secret_value_get_type() -> GType;
    pub fn secret_value_new(
        secret: *const c_char,
        length: ssize_t,
        content_type: *const c_char,
    ) -> *mut SecretValue;
    pub fn secret_value_new_full(
        secret: *mut c_char,
        length: ssize_t,
        content_type: *const c_char,
        destroy: glib::GDestroyNotify,
    ) -> *mut SecretValue;
    pub fn secret_value_get(value: *mut SecretValue, length: *mut size_t) -> *const u8;
    pub fn secret_value_get_content_type(value: *mut SecretValue) -> *const c_char;
    pub fn secret_value_get_text(value: *mut SecretValue) -> *const c_char;
    pub fn secret_value_ref(value: *mut SecretValue) -> *mut SecretValue;
    pub fn secret_value_unref(value: gpointer);
    pub fn secret_value_unref_to_password(
        value: *mut SecretValue,
        length: *mut size_t,
    ) -> *mut c_char;

    //=========================================================================
    // SecretCollection
    //=========================================================================
    pub fn secret_collection_get_type() -> GType;
    pub fn secret_collection_new_for_dbus_path_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_new_for_dbus_path_sync(
        service: *mut SecretService,
        collection_path: *const c_char,
        flags: SecretCollectionFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_create(
        service: *mut SecretService,
        label: *const c_char,
        alias: *const c_char,
        flags: SecretCollectionCreateFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_create_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_create_sync(
        service: *mut SecretService,
        label: *const c_char,
        alias: *const c_char,
        flags: SecretCollectionCreateFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_for_alias(
        service: *mut SecretService,
        alias: *const c_char,
        flags: SecretCollectionFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_for_alias_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_for_alias_sync(
        service: *mut SecretService,
        alias: *const c_char,
        flags: SecretCollectionFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretCollection;
    pub fn secret_collection_new_for_dbus_path(
        service: *mut SecretService,
        collection_path: *const c_char,
        flags: SecretCollectionFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_delete(
        self_: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_delete_finish(
        self_: *mut SecretCollection,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_collection_delete_sync(
        self_: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_collection_get_created(self_: *mut SecretCollection) -> u64;
    pub fn secret_collection_get_flags(self_: *mut SecretCollection) -> SecretCollectionFlags;
    pub fn secret_collection_get_items(self_: *mut SecretCollection) -> *mut glib::GList;
    pub fn secret_collection_get_label(self_: *mut SecretCollection) -> *mut c_char;
    pub fn secret_collection_get_locked(self_: *mut SecretCollection) -> gboolean;
    pub fn secret_collection_get_modified(self_: *mut SecretCollection) -> u64;
    pub fn secret_collection_get_service(self_: *mut SecretCollection) -> *mut SecretService;
    pub fn secret_collection_load_items(
        self_: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_load_items_finish(
        self_: *mut SecretCollection,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_collection_load_items_sync(
        self_: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_collection_refresh(self_: *mut SecretCollection);
    pub fn secret_collection_search(
        self_: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_search_finish(
        self_: *mut SecretCollection,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_collection_search_for_dbus_paths(
        collection: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_search_for_dbus_paths_finish(
        collection: *mut SecretCollection,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut *mut c_char;
    pub fn secret_collection_search_for_dbus_paths_sync(
        collection: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut *mut c_char;
    pub fn secret_collection_search_sync(
        self_: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_collection_set_label(
        self_: *mut SecretCollection,
        label: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_collection_set_label_finish(
        self_: *mut SecretCollection,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_collection_set_label_sync(
        self_: *mut SecretCollection,
        label: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // SecretItem
    //=========================================================================
    pub fn secret_item_get_type() -> GType;
    pub fn secret_item_new_for_dbus_path_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretItem;
    pub fn secret_item_new_for_dbus_path_sync(
        service: *mut SecretService,
        item_path: *const c_char,
        flags: SecretItemFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretItem;
    pub fn secret_item_create(
        collection: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        label: *const c_char,
        value: *mut SecretValue,
        flags: SecretItemCreateFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_create_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretItem;
    pub fn secret_item_create_sync(
        collection: *mut SecretCollection,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        label: *const c_char,
        value: *mut SecretValue,
        flags: SecretItemCreateFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretItem;
    pub fn secret_item_load_secrets(
        items: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_load_secrets_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_load_secrets_sync(
        items: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_new_for_dbus_path(
        service: *mut SecretService,
        item_path: *const c_char,
        flags: SecretItemFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_delete(
        self_: *mut SecretItem,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_delete_finish(
        self_: *mut SecretItem,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_delete_sync(
        self_: *mut SecretItem,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_get_attributes(self_: *mut SecretItem) -> *mut glib::GHashTable;
    pub fn secret_item_get_created(self_: *mut SecretItem) -> u64;
    pub fn secret_item_get_flags(self_: *mut SecretItem) -> SecretItemFlags;
    pub fn secret_item_get_label(self_: *mut SecretItem) -> *mut c_char;
    pub fn secret_item_get_locked(self_: *mut SecretItem) -> gboolean;
    pub fn secret_item_get_modified(self_: *mut SecretItem) -> u64;
    pub fn secret_item_get_schema_name(self_: *mut SecretItem) -> *mut c_char;
    pub fn secret_item_get_secret(self_: *mut SecretItem) -> *mut SecretValue;
    pub fn secret_item_get_service(self_: *mut SecretItem) -> *mut SecretService;
    pub fn secret_item_load_secret(
        self_: *mut SecretItem,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_load_secret_finish(
        self_: *mut SecretItem,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_load_secret_sync(
        self_: *mut SecretItem,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_refresh(self_: *mut SecretItem);
    pub fn secret_item_set_attributes(
        self_: *mut SecretItem,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_set_attributes_finish(
        self_: *mut SecretItem,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_set_attributes_sync(
        self_: *mut SecretItem,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_set_label(
        self_: *mut SecretItem,
        label: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_set_label_finish(
        self_: *mut SecretItem,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_set_label_sync(
        self_: *mut SecretItem,
        label: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_set_secret(
        self_: *mut SecretItem,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_item_set_secret_finish(
        self_: *mut SecretItem,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_item_set_secret_sync(
        self_: *mut SecretItem,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;

    //=========================================================================
    // SecretPrompt
    //=========================================================================
    pub fn secret_prompt_get_type() -> GType;
    pub fn secret_prompt_perform(
        self_: *mut SecretPrompt,
        window_id: *const c_char,
        return_type: *const glib::GVariantType,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_prompt_perform_finish(
        self_: *mut SecretPrompt,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_prompt_perform_sync(
        self_: *mut SecretPrompt,
        window_id: *const c_char,
        cancellable: *mut gio::GCancellable,
        return_type: *const glib::GVariantType,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_prompt_run(
        self_: *mut SecretPrompt,
        window_id: *const c_char,
        cancellable: *mut gio::GCancellable,
        return_type: *const glib::GVariantType,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;

    //=========================================================================
    // SecretService
    //=========================================================================
    pub fn secret_service_get_type() -> GType;
    pub fn secret_service_disconnect();
    pub fn secret_service_get(
        flags: SecretServiceFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_get_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretService;
    pub fn secret_service_get_sync(
        flags: SecretServiceFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretService;
    pub fn secret_service_open(
        service_gtype: GType,
        service_bus_name: *const c_char,
        flags: SecretServiceFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_open_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretService;
    pub fn secret_service_open_sync(
        service_gtype: GType,
        service_bus_name: *const c_char,
        flags: SecretServiceFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretService;
    pub fn secret_service_clear(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_clear_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_clear_sync(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_create_collection_dbus_path(
        self_: *mut SecretService,
        properties: *mut glib::GHashTable,
        alias: *const c_char,
        flags: SecretCollectionCreateFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_create_collection_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_create_collection_dbus_path_sync(
        self_: *mut SecretService,
        properties: *mut glib::GHashTable,
        alias: *const c_char,
        flags: SecretCollectionCreateFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_create_item_dbus_path(
        self_: *mut SecretService,
        collection_path: *const c_char,
        properties: *mut glib::GHashTable,
        value: *mut SecretValue,
        flags: SecretItemCreateFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_create_item_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_create_item_dbus_path_sync(
        self_: *mut SecretService,
        collection_path: *const c_char,
        properties: *mut glib::GHashTable,
        value: *mut SecretValue,
        flags: SecretItemCreateFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_decode_dbus_secret(
        service: *mut SecretService,
        value: *mut glib::GVariant,
    ) -> *mut SecretValue;
    pub fn secret_service_delete_item_dbus_path(
        self_: *mut SecretService,
        item_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_delete_item_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_delete_item_dbus_path_sync(
        self_: *mut SecretService,
        item_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_encode_dbus_secret(
        service: *mut SecretService,
        value: *mut SecretValue,
    ) -> *mut glib::GVariant;
    pub fn secret_service_ensure_session(
        self_: *mut SecretService,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_ensure_session_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_ensure_session_sync(
        self_: *mut SecretService,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_get_collection_gtype(self_: *mut SecretService) -> GType;
    pub fn secret_service_get_collections(self_: *mut SecretService) -> *mut glib::GList;
    pub fn secret_service_get_flags(self_: *mut SecretService) -> SecretServiceFlags;
    pub fn secret_service_get_item_gtype(self_: *mut SecretService) -> GType;
    pub fn secret_service_get_secret_for_dbus_path(
        self_: *mut SecretService,
        item_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_get_secret_for_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_service_get_secret_for_dbus_path_sync(
        self_: *mut SecretService,
        item_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_service_get_secrets_for_dbus_paths(
        self_: *mut SecretService,
        item_paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_get_secrets_for_dbus_paths_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GHashTable;
    pub fn secret_service_get_secrets_for_dbus_paths_sync(
        self_: *mut SecretService,
        item_paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GHashTable;
    pub fn secret_service_get_session_algorithms(self_: *mut SecretService) -> *const c_char;
    pub fn secret_service_get_session_dbus_path(self_: *mut SecretService) -> *const c_char;
    pub fn secret_service_load_collections(
        self_: *mut SecretService,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_load_collections_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_load_collections_sync(
        self_: *mut SecretService,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_lock(
        service: *mut SecretService,
        objects: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_lock_dbus_paths(
        self_: *mut SecretService,
        paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_lock_dbus_paths_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        locked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_lock_dbus_paths_sync(
        self_: *mut SecretService,
        paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        locked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_lock_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        locked: *mut *mut glib::GList,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_lock_sync(
        service: *mut SecretService,
        objects: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        locked: *mut *mut glib::GList,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_lookup(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_lookup_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_service_lookup_sync(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_service_prompt(
        self_: *mut SecretService,
        prompt: *mut SecretPrompt,
        return_type: *const glib::GVariantType,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_prompt_at_dbus_path(
        self_: *mut SecretService,
        prompt_path: *const c_char,
        return_type: *const glib::GVariantType,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_prompt_at_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_service_prompt_at_dbus_path_sync(
        self_: *mut SecretService,
        prompt_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        return_type: *const glib::GVariantType,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_service_prompt_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_service_prompt_sync(
        self_: *mut SecretService,
        prompt: *mut SecretPrompt,
        cancellable: *mut gio::GCancellable,
        return_type: *const glib::GVariantType,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GVariant;
    pub fn secret_service_read_alias_dbus_path(
        self_: *mut SecretService,
        alias: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_read_alias_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_read_alias_dbus_path_sync(
        self_: *mut SecretService,
        alias: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_service_search(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_search_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_service_search_for_dbus_paths(
        self_: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_search_for_dbus_paths_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        unlocked: *mut *mut *mut c_char,
        locked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_search_for_dbus_paths_sync(
        self_: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        unlocked: *mut *mut *mut c_char,
        locked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_search_sync(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_service_set_alias(
        service: *mut SecretService,
        alias: *const c_char,
        collection: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_set_alias_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_set_alias_sync(
        service: *mut SecretService,
        alias: *const c_char,
        collection: *mut SecretCollection,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_set_alias_to_dbus_path(
        self_: *mut SecretService,
        alias: *const c_char,
        collection_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_set_alias_to_dbus_path_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_set_alias_to_dbus_path_sync(
        self_: *mut SecretService,
        alias: *const c_char,
        collection_path: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_store(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_store_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_store_sync(
        service: *mut SecretService,
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_service_unlock(
        service: *mut SecretService,
        objects: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_unlock_dbus_paths(
        self_: *mut SecretService,
        paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_service_unlock_dbus_paths_finish(
        self_: *mut SecretService,
        result: *mut gio::GAsyncResult,
        unlocked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_unlock_dbus_paths_sync(
        self_: *mut SecretService,
        paths: *mut *const c_char,
        cancellable: *mut gio::GCancellable,
        unlocked: *mut *mut *mut c_char,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_unlock_finish(
        service: *mut SecretService,
        result: *mut gio::GAsyncResult,
        unlocked: *mut *mut glib::GList,
        error: *mut *mut glib::GError,
    ) -> c_int;
    pub fn secret_service_unlock_sync(
        service: *mut SecretService,
        objects: *mut glib::GList,
        cancellable: *mut gio::GCancellable,
        unlocked: *mut *mut glib::GList,
        error: *mut *mut glib::GError,
    ) -> c_int;

    //=========================================================================
    // SecretBackend
    //=========================================================================
    pub fn secret_backend_get_type() -> GType;
    pub fn secret_backend_get(
        flags: SecretBackendFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_backend_get_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretBackend;

    //=========================================================================
    // SecretRetrievable
    //=========================================================================
    pub fn secret_retrievable_get_type() -> GType;
    pub fn secret_retrievable_get_attributes(
        self_: *mut SecretRetrievable,
    ) -> *mut glib::GHashTable;
    pub fn secret_retrievable_get_created(self_: *mut SecretRetrievable) -> u64;
    pub fn secret_retrievable_get_label(self_: *mut SecretRetrievable) -> *mut c_char;
    pub fn secret_retrievable_get_modified(self_: *mut SecretRetrievable) -> u64;
    pub fn secret_retrievable_retrieve_secret(
        self_: *mut SecretRetrievable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_retrievable_retrieve_secret_finish(
        self_: *mut SecretRetrievable,
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_retrievable_retrieve_secret_sync(
        self_: *mut SecretRetrievable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn secret_attributes_build(schema: *const SecretSchema, ...) -> *mut glib::GHashTable;
    //pub fn secret_attributes_buildv(schema: *const SecretSchema, va: /*Unimplemented*/va_list) -> *mut glib::GHashTable;
    pub fn secret_get_schema(type_: SecretSchemaType) -> *const SecretSchema;
    pub fn secret_password_clear(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
        ...
    );
    pub fn secret_password_clear_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_password_clear_sync(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> gboolean;
    pub fn secret_password_clearv(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_password_clearv_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_password_free(password: *mut c_char);
    pub fn secret_password_lookup(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
        ...
    );
    pub fn secret_password_lookup_binary_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_password_lookup_binary_sync(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut SecretValue;
    pub fn secret_password_lookup_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_password_lookup_nonpageable_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_password_lookup_nonpageable_sync(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut c_char;
    pub fn secret_password_lookup_sync(
        schema: *const SecretSchema,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut c_char;
    pub fn secret_password_lookupv(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_password_lookupv_binary_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut SecretValue;
    pub fn secret_password_lookupv_nonpageable_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_password_lookupv_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut c_char;
    pub fn secret_password_search(
        schema: *const SecretSchema,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
        ...
    );
    pub fn secret_password_search_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_password_search_sync(
        schema: *const SecretSchema,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> *mut glib::GList;
    pub fn secret_password_searchv(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_password_searchv_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        flags: SecretSearchFlags,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> *mut glib::GList;
    pub fn secret_password_store(
        schema: *const SecretSchema,
        collection: *const c_char,
        label: *const c_char,
        password: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
        ...
    );
    pub fn secret_password_store_binary(
        schema: *const SecretSchema,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
        ...
    );
    pub fn secret_password_store_binary_sync(
        schema: *const SecretSchema,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> gboolean;
    pub fn secret_password_store_finish(
        result: *mut gio::GAsyncResult,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_password_store_sync(
        schema: *const SecretSchema,
        collection: *const c_char,
        label: *const c_char,
        password: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
        ...
    ) -> gboolean;
    pub fn secret_password_storev(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        password: *const c_char,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_password_storev_binary(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        callback: gio::GAsyncReadyCallback,
        user_data: gpointer,
    );
    pub fn secret_password_storev_binary_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        value: *mut SecretValue,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_password_storev_sync(
        schema: *const SecretSchema,
        attributes: *mut glib::GHashTable,
        collection: *const c_char,
        label: *const c_char,
        password: *const c_char,
        cancellable: *mut gio::GCancellable,
        error: *mut *mut glib::GError,
    ) -> gboolean;
    pub fn secret_password_wipe(password: *mut c_char);

}
