/*
 * Copyright (c) 2020-2021 Thomas Kramer.
 *
 * This file is part of LibrEDA 
 * (see https://codeberg.org/libreda).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
//! The `prelude` helps to import most commonly used modules.

pub use iron_shapes::prelude::*;
pub use crate::hierarchy::prelude::*;
pub use crate::layout::prelude::*;
pub use crate::netlist::prelude::*;
pub use crate::l2n::*;
pub use crate::chip::Chip;
pub use crate::traits::*;
pub use crate::rc_string::RcString;
pub use crate::property_storage::PropertyValue;
pub use crate::flat_view::FlatView;
pub use crate::reference_access;
pub use crate::reference_access::*;
pub use crate::netlist::util::*;
pub use crate::technology;

/// Re-export of most traits.
/// This can be useful if only traits should be used but not the rest.
pub mod traits {
    pub use crate::traits::*;
    pub use crate::hierarchy::traits::*;
    pub use crate::hierarchy::util::*;
    pub use crate::layout::traits::*;
    pub use crate::layout::util::*;
    pub use crate::netlist::traits::*;
    pub use crate::netlist::util::*;
    pub use crate::l2n::*;
    pub use crate::reference_access::*;
    pub use iron_shapes::traits::*;
}
