// This file is part of librador-rs, a project to provide a safe Rust API
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-rs is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-rs is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// Example of using Librador to get the Labrador's firmware information.
use librador::Labrador;

fn main() {
    println!("Getting Labrador...");
    let labrador = match Labrador::find() {
        Err(_) => panic!("Unable to find Labrador..."),
        Ok(l) => l,
    };

    println!("Getting version info...");
    let variant = labrador.firmware_variant();
    let version = labrador.firmware_version();
    println!("Labrador found, variant {}, version {}", variant, version);
}
