librador-rs
============

This crate exposes a safe, Rusty API to the [EspoTek Labrador] electronics lab board.

[EspoTek Labrador]: https://espotek.com/labrador/

API Support
-----------

- [x] Library initialization
- [x] USB initialization
- [x] Device firmware version
- [x] Mode configuration
- [x] Power supply
- [x] Digital output
- [x] Signal generator
- [x] Logic analyzer
- [ ] Oscilloscope
- [ ] Multimeter

More Information
----------------

Take a look at the documentation with `cargo doc --open` or by visiting
[the docs.rs page](https://docs.rs/librador/latest/librador/).

Refer to the [`librador` project documentation] for further details.

[`librador` project documentation]: https://docs.google.com/document/d/11Cu6602X_y5x0IwIBZnP7ImIx0jykX7AzToh83-7hCM/edit

Contributing
------------

All contributions are welcome, whether they're bug reports, feature
requests, code changes, or well wishes.  Thanks!

Note that many of the tests expect an actual Labrador board to be
connected to your computer, and each of them needs exclusive access.
Try running tests with `cargo test -- --test-threads=1`.

License Information
-------------------

librador-rs is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

librador-rs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Please see the file `LICENSE` in the root of this project for a copy
of the GNU General Public License, or see <http://www.gnu.org/licenses/>.

_This project incorporates code from the `Labrador` project, which is
also licensed under the GPL v3._
