// This file is part of librador-sys, Rust bindings to librador, the driver
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-sys is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-sys is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

use librador_sys::{
    librador_get_analog_data, librador_init, librador_set_device_mode,
    librador_set_oscilloscope_gain, librador_setup_usb, librador_update_signal_gen_settings,
};

fn main() {
    println!("Initializing library...");
    let res = librador_init();
    assert_eq!(res, 0);

    println!("Setting up USB...");
    let res = librador_setup_usb();
    assert_eq!(res, 0);

    println!("Setting device mode to 0...");
    let res = librador_set_device_mode(0);
    assert_eq!(res, 0);

    println!("Setting oscilloscope gain to 8...");
    let res = librador_set_oscilloscope_gain(8.);
    assert_eq!(res, 0);

    println!("Setting signal out...");
    let mut samples = [255, 204, 153, 102, 51, 0];
    let res = unsafe {
        librador_update_signal_gen_settings(
            1,
            samples.as_mut_ptr(),
            samples.len() as _,
            10000.,
            1.,
            0.,
        )
    };
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(500));

    println!("Getting analog data...");
    let data = librador_get_analog_data(1, 0.1, 200., 0.1, 1 /* linear interpolation */);

    if data.is_null() {
        println!("Unable to get data!");
    } else {
        unsafe { println!("Data: {:?}", *data) };
    }
}
