// This file is part of librador-sys, Rust bindings to librador, the driver
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-sys is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-sys is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//! Example of configuring the power supply.
//!
//! Connect the power supply output to the multimeter input.
//! - Power Supply (Positive) to OSC CH1 (DC)
//! - Power Supply (GND) to OSC CH2 (DC)

use librador_sys::{
    librador_get_analog_data, librador_init, librador_set_device_mode,
    librador_set_power_supply_voltage, librador_setup_usb,
};

fn main() {
    println!("Initializing library...");
    let res = librador_init();
    assert_eq!(res, 0);

    println!("Setting up USB...");
    let res = librador_setup_usb();
    assert_eq!(res, 0);

    println!("Setting device mode to 7...");
    let res = librador_set_device_mode(7);
    assert_eq!(res, 0);

    println!("Setting power supply voltage...");
    let res = librador_set_power_supply_voltage(5.);
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(500));

    println!("Getting analog data...");
    let data = librador_get_analog_data(1, 0.4, 100., 0., 0 /* #nofilter */);

    if data.is_null() {
        println!("Unable to get data!");
    } else {
        unsafe { println!("Data: {:?}", *data) };
    }
}
