// This file is part of librador-sys, Rust bindings to librador, the driver
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-sys is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-sys is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//! Example of setting digital outputs and reading the logic analyzer.
//!
//! Connect the digital output to the logic analyzer.
//! - Digital Output CH1 to Logic Analyzer CH1

use librador_sys::{
    librador_get_digital_data, librador_init, librador_set_device_mode, librador_set_digital_out,
    librador_setup_usb,
};

fn main() {
    println!("Initializing library...");
    let res = librador_init();
    assert_eq!(res, 0);

    println!("Setting up USB...");
    let res = librador_setup_usb();
    assert_eq!(res, 0);

    println!("Setting device mode to 3...");
    let res = librador_set_device_mode(3);
    assert_eq!(res, 0);

    println!("Setting digital out...");
    let res = librador_set_digital_out(1, true);
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(50));

    println!("Clearing digital out...");
    let res = librador_set_digital_out(1, false);
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(50));

    println!("Setting digital out...");
    let res = librador_set_digital_out(1, true);
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(150));

    println!("Clearing digital out...");
    let res = librador_set_digital_out(1, false);
    assert_eq!(res, 0);

    println!("Waiting...");
    std::thread::sleep(std::time::Duration::from_millis(30));

    println!("Getting digital data...");
    let data = librador_get_digital_data(1, 0.4, 100., 0.);

    if data.is_null() {
        println!("Unable to get data!");
    } else {
        unsafe { println!("Data: {:?}", *data) };
    }
}
