// This file is part of librador-sys, Rust bindings to librador, the driver
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-sys is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-sys is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

use librador_sys::{
    librador_avr_debug, librador_get_device_firmware_variant, librador_get_device_firmware_version,
    librador_init, librador_setup_usb,
};

fn main() {
    println!("Initializing library...");
    let res = librador_init();
    assert_eq!(res, 0);

    println!("Setting up USB...");
    let res = librador_setup_usb();
    assert_eq!(res, 0);

    println!("Getting AVR debug...");
    let res = librador_avr_debug();
    assert_eq!(res, 0);

    println!("Getting version info...");
    let variant = librador_get_device_firmware_variant();
    let version = librador_get_device_firmware_version();
    println!("Labrador found, variant {}, version {}", variant, version);
}
