// This file is part of librador-sys, Rust bindings to librador, the driver
// for the EspoTek Labrador electronics lab board.
//
// Copyright 2021 Andrew Dona-Couch
//
// librador-sys is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// librador-sys is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

fn main() {
    let lib_name = "rador"; // i.e. librador.a

    let libusb_dir = std::env::var("DEP_USB_1.0_INCLUDE").unwrap();

    let source =
        std::path::PathBuf::from(std::env::var_os("CARGO_MANIFEST_DIR").unwrap()).join("Labrador");
    let desktop_dir = source.join("Desktop_Interface");
    let librador_dir = source.join("Librador_API/___librador/librador_shared_library");

    cxx_build::bridge("src/lib.rs")
        .warnings(false)
        .define("_REENTRANT", None)
        .define("LIBRADOR_LIBRARY", None)
        .define("PLATFORM_LINUX", None)
        .include(&desktop_dir)
        .include(desktop_dir.join("build_linux/libdfuprog/include"))
        .include(&librador_dir)
        .include(&libusb_dir)
        .file(librador_dir.join("librador.cpp"))
        .file(librador_dir.join("o1buffer.cpp"))
        .file(librador_dir.join("usbcallhandler.cpp"))
        .compile(lib_name);

    println!("cargo:rerun-if-changed=src/lib.rs");
}
