librador-sys
============

This crate exposes Rust bindings to [**librador**], the driver library for
the [EspoTek Labrador] electronics lab board.

You might rather use the safe, Rusty API provided by [`librador-rs`].

[**librador**]: https://github.com/EspoTek/Labrador/tree/master/Librador_API/___librador/librador_shared_library
[EspoTek Labrador]: https://espotek.com/labrador/
[`librador-rs`]: git.sr.ht/~couch/librador-rs

More Information
----------------

Take a look at the documentation with `cargo doc --open` or by visiting
[the docs.rs page](https://docs.rs/librador-sys/latest/librador-sys/).

Refer to the [`librador` project documentation] for further details.

[`librador` project documentation]: https://docs.google.com/document/d/11Cu6602X_y5x0IwIBZnP7ImIx0jykX7AzToh83-7hCM/edit

Supported API
-------------

- Control Functions
  - [x] librador_init
  - [x] librador_exit
  - [x] librador_setup_usb
  - [x] librador_reset_usb
- USB-Control Functions
  - [x] librador_avr_debug
  - [x] librador_update_signal_gen_settings
  - [x] librador_send_sin_wave
  - [x] librador_send_square_wave
  - [x] librador_send_sawtooth_wave
  - [x] librador_send_triangle_wave
  - [x] librador_set_power_supply_voltage
  - [x] librador_set_device_mode
  - [x] librador_set_oscilloscope_gain
  - [x] librador_set_digital_out
  - [ ] librador_reset_device
  - [ ] librador_jump_to_bootloader
  - [x] librador_get_device_firmware_version
  - [x] librador_get_device_firmware_variant
- USB-Iso Functions
  - [x] librador_get_analog_data
  - [x] librador_get_analog_data_sincelast
  - [x] librador_get_digital_data

Contributing
------------

All contributions are welcome, whether they're bug reports, feature
requests, code changes, or well wishes.  Thanks!

License Information
-------------------

librador-sys is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

librador-sys is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

Please see the file `LICENSE` in the root of this project for a copy
of the GNU General Public License, or see <http://www.gnu.org/licenses/>.

_This project incorporates code from the `Labrador` project, which is
also licensed under the GPL v3._
