// Autogenerated file - DO NOT EDIT

/// BOOL - boolean, &#39;true&#39;/&#39;false&#39;
pub const BOOL: Type = Type {
    oid: 16,
    descr: "BOOL - boolean, &#39;true&#39;/&#39;false&#39;",
    name: "bool",
    kind: Kind::Boolean,
};

/// BYTEA - variable-length string, binary values escaped
pub const BYTEA: Type = Type {
    oid: 17,
    descr: "BYTEA - variable-length string, binary values escaped",
    name: "bytea",
    kind: Kind::UserDefined,
};

/// CHAR - single character
pub const CHAR: Type = Type {
    oid: 18,
    descr: "CHAR - single character",
    name: "char",
    kind: Kind::String,
};

/// NAME - 63-byte type for storing system identifiers
pub const NAME: Type = Type {
    oid: 19,
    descr: "NAME - 63-byte type for storing system identifiers",
    name: "name",
    kind: Kind::String,
};

/// INT8 - ~18 digit integer, 8-byte storage
pub const INT8: Type = Type {
    oid: 20,
    descr: "INT8 - ~18 digit integer, 8-byte storage",
    name: "int8",
    kind: Kind::Numeric,
};

/// INT2 - -32 thousand to 32 thousand, 2-byte storage
pub const INT2: Type = Type {
    oid: 21,
    descr: "INT2 - -32 thousand to 32 thousand, 2-byte storage",
    name: "int2",
    kind: Kind::Numeric,
};

/// INT2VECTOR - array of int2, used in system tables
pub const INT2_VECTOR: Type = Type {
    oid: 22,
    descr: "INT2VECTOR - array of int2, used in system tables",
    name: "int2vector",
    kind: Kind::Array(21),
};

/// INT4 - -2 billion to 2 billion integer, 4-byte storage
pub const INT4: Type = Type {
    oid: 23,
    descr: "INT4 - -2 billion to 2 billion integer, 4-byte storage",
    name: "int4",
    kind: Kind::Numeric,
};

/// REGPROC - registered procedure
pub const REGPROC: Type = Type {
    oid: 24,
    descr: "REGPROC - registered procedure",
    name: "regproc",
    kind: Kind::Numeric,
};

/// TEXT - variable-length string, no limit specified
pub const TEXT: Type = Type {
    oid: 25,
    descr: "TEXT - variable-length string, no limit specified",
    name: "text",
    kind: Kind::String,
};

/// OID - object identifier&#40;oid&#41;, maximum 4 billion
pub const OID: Type = Type {
    oid: 26,
    descr: "OID - object identifier&#40;oid&#41;, maximum 4 billion",
    name: "oid",
    kind: Kind::Numeric,
};

/// TID - &#40;block, offset&#41;, physical location of tuple
pub const TID: Type = Type {
    oid: 27,
    descr: "TID - &#40;block, offset&#41;, physical location of tuple",
    name: "tid",
    kind: Kind::UserDefined,
};

/// XID - transaction id
pub const XID: Type = Type {
    oid: 28,
    descr: "XID - transaction id",
    name: "xid",
    kind: Kind::UserDefined,
};

/// CID - command identifier type, sequence in transaction id
pub const CID: Type = Type {
    oid: 29,
    descr: "CID - command identifier type, sequence in transaction id",
    name: "cid",
    kind: Kind::UserDefined,
};

/// OIDVECTOR - array of oids, used in system tables
pub const OID_VECTOR: Type = Type {
    oid: 30,
    descr: "OIDVECTOR - array of oids, used in system tables",
    name: "oidvector",
    kind: Kind::Array(26),
};

/// PG_DDL_COMMAND - internal type for passing CollectedCommand
pub const PG_DDL_COMMAND: Type = Type {
    oid: 32,
    descr: "PG_DDL_COMMAND - internal type for passing CollectedCommand",
    name: "pg_ddl_command",
    kind: Kind::Pseudo,
};

/// JSON - JSON stored as text
pub const JSON: Type = Type {
    oid: 114,
    descr: "JSON - JSON stored as text",
    name: "json",
    kind: Kind::UserDefined,
};

/// XML - XML content
pub const XML: Type = Type {
    oid: 142,
    descr: "XML - XML content",
    name: "xml",
    kind: Kind::UserDefined,
};

/// XML&#91;&#93;
pub const XML_ARRAY: Type = Type {
    oid: 143,
    descr: "XML&#91;&#93;",
    name: "_xml",
    kind: Kind::Array(142),
};

/// PG_NODE_TREE - string representing an internal node tree
pub const PG_NODE_TREE: Type = Type {
    oid: 194,
    descr: "PG_NODE_TREE - string representing an internal node tree",
    name: "pg_node_tree",
    kind: Kind::String,
};

/// JSON&#91;&#93;
pub const JSON_ARRAY: Type = Type {
    oid: 199,
    descr: "JSON&#91;&#93;",
    name: "_json",
    kind: Kind::Array(114),
};

/// TABLE_AM_HANDLER
pub const TABLE_AM_HANDLER: Type = Type {
    oid: 269,
    descr: "TABLE_AM_HANDLER",
    name: "table_am_handler",
    kind: Kind::Pseudo,
};

/// XID8&#91;&#93;
pub const XID8_ARRAY: Type = Type {
    oid: 271,
    descr: "XID8&#91;&#93;",
    name: "_xid8",
    kind: Kind::Array(5069),
};

/// INDEX_AM_HANDLER - pseudo-type for the result of an index AM handler function
pub const INDEX_AM_HANDLER: Type = Type {
    oid: 325,
    descr: "INDEX_AM_HANDLER - pseudo-type for the result of an index AM handler function",
    name: "index_am_handler",
    kind: Kind::Pseudo,
};

/// POINT - geometric point &#39;&#40;x, y&#41;&#39;
pub const POINT: Type = Type {
    oid: 600,
    descr: "POINT - geometric point &#39;&#40;x, y&#41;&#39;",
    name: "point",
    kind: Kind::Geometric,
};

/// LSEG - geometric line segment &#39;&#40;pt1,pt2&#41;&#39;
pub const LSEG: Type = Type {
    oid: 601,
    descr: "LSEG - geometric line segment &#39;&#40;pt1,pt2&#41;&#39;",
    name: "lseg",
    kind: Kind::Geometric,
};

/// PATH - geometric path &#39;&#40;pt1,...&#41;&#39;
pub const PATH: Type = Type {
    oid: 602,
    descr: "PATH - geometric path &#39;&#40;pt1,...&#41;&#39;",
    name: "path",
    kind: Kind::Geometric,
};

/// BOX - geometric box &#39;&#40;lower left,upper right&#41;&#39;
pub const BOX: Type = Type {
    oid: 603,
    descr: "BOX - geometric box &#39;&#40;lower left,upper right&#41;&#39;",
    name: "box",
    kind: Kind::Geometric,
};

/// POLYGON - geometric polygon &#39;&#40;pt1,...&#41;&#39;
pub const POLYGON: Type = Type {
    oid: 604,
    descr: "POLYGON - geometric polygon &#39;&#40;pt1,...&#41;&#39;",
    name: "polygon",
    kind: Kind::Geometric,
};

/// LINE - geometric line
pub const LINE: Type = Type {
    oid: 628,
    descr: "LINE - geometric line",
    name: "line",
    kind: Kind::Geometric,
};

/// LINE&#91;&#93;
pub const LINE_ARRAY: Type = Type {
    oid: 629,
    descr: "LINE&#91;&#93;",
    name: "_line",
    kind: Kind::Array(628),
};

/// CIDR - network IP address/netmask, network address
pub const CIDR: Type = Type {
    oid: 650,
    descr: "CIDR - network IP address/netmask, network address",
    name: "cidr",
    kind: Kind::Network,
};

/// CIDR&#91;&#93;
pub const CIDR_ARRAY: Type = Type {
    oid: 651,
    descr: "CIDR&#91;&#93;",
    name: "_cidr",
    kind: Kind::Array(650),
};

/// FLOAT4 - single-precision floating point number, 4-byte storage
pub const FLOAT4: Type = Type {
    oid: 700,
    descr: "FLOAT4 - single-precision floating point number, 4-byte storage",
    name: "float4",
    kind: Kind::Numeric,
};

/// FLOAT8 - double-precision floating point number, 8-byte storage
pub const FLOAT8: Type = Type {
    oid: 701,
    descr: "FLOAT8 - double-precision floating point number, 8-byte storage",
    name: "float8",
    kind: Kind::Numeric,
};

/// UNKNOWN - pseudo-type representing an undetermined type
pub const UNKNOWN: Type = Type {
    oid: 705,
    descr: "UNKNOWN - pseudo-type representing an undetermined type",
    name: "unknown",
    kind: Kind::Unknow,
};

/// CIRCLE - geometric circle &#39;&#40;center,radius&#41;&#39;
pub const CIRCLE: Type = Type {
    oid: 718,
    descr: "CIRCLE - geometric circle &#39;&#40;center,radius&#41;&#39;",
    name: "circle",
    kind: Kind::Geometric,
};

/// CIRCLE&#91;&#93;
pub const CIRCLE_ARRAY: Type = Type {
    oid: 719,
    descr: "CIRCLE&#91;&#93;",
    name: "_circle",
    kind: Kind::Array(718),
};

/// MACADDR8 - XX:XX:XX:XX:XX:XX:XX:XX, MAC address
pub const MACADDR8: Type = Type {
    oid: 774,
    descr: "MACADDR8 - XX:XX:XX:XX:XX:XX:XX:XX, MAC address",
    name: "macaddr8",
    kind: Kind::UserDefined,
};

/// MACADDR8&#91;&#93;
pub const MACADDR8_ARRAY: Type = Type {
    oid: 775,
    descr: "MACADDR8&#91;&#93;",
    name: "_macaddr8",
    kind: Kind::Array(774),
};

/// MONEY - monetary amounts, &#36;d,ddd.cc
pub const MONEY: Type = Type {
    oid: 790,
    descr: "MONEY - monetary amounts, &#36;d,ddd.cc",
    name: "money",
    kind: Kind::Numeric,
};

/// MONEY&#91;&#93;
pub const MONEY_ARRAY: Type = Type {
    oid: 791,
    descr: "MONEY&#91;&#93;",
    name: "_money",
    kind: Kind::Array(790),
};

/// MACADDR - XX:XX:XX:XX:XX:XX, MAC address
pub const MACADDR: Type = Type {
    oid: 829,
    descr: "MACADDR - XX:XX:XX:XX:XX:XX, MAC address",
    name: "macaddr",
    kind: Kind::UserDefined,
};

/// INET - IP address/netmask, host address, netmask optional
pub const INET: Type = Type {
    oid: 869,
    descr: "INET - IP address/netmask, host address, netmask optional",
    name: "inet",
    kind: Kind::Network,
};

/// BOOL&#91;&#93;
pub const BOOL_ARRAY: Type = Type {
    oid: 1000,
    descr: "BOOL&#91;&#93;",
    name: "_bool",
    kind: Kind::Array(16),
};

/// BYTEA&#91;&#93;
pub const BYTEA_ARRAY: Type = Type {
    oid: 1001,
    descr: "BYTEA&#91;&#93;",
    name: "_bytea",
    kind: Kind::Array(17),
};

/// CHAR&#91;&#93;
pub const CHAR_ARRAY: Type = Type {
    oid: 1002,
    descr: "CHAR&#91;&#93;",
    name: "_char",
    kind: Kind::Array(18),
};

/// NAME&#91;&#93;
pub const NAME_ARRAY: Type = Type {
    oid: 1003,
    descr: "NAME&#91;&#93;",
    name: "_name",
    kind: Kind::Array(19),
};

/// INT2&#91;&#93;
pub const INT2_ARRAY: Type = Type {
    oid: 1005,
    descr: "INT2&#91;&#93;",
    name: "_int2",
    kind: Kind::Array(21),
};

/// INT2VECTOR&#91;&#93;
pub const INT2_VECTOR_ARRAY: Type = Type {
    oid: 1006,
    descr: "INT2VECTOR&#91;&#93;",
    name: "_int2vector",
    kind: Kind::Array(22),
};

/// INT4&#91;&#93;
pub const INT4_ARRAY: Type = Type {
    oid: 1007,
    descr: "INT4&#91;&#93;",
    name: "_int4",
    kind: Kind::Array(23),
};

/// REGPROC&#91;&#93;
pub const REGPROC_ARRAY: Type = Type {
    oid: 1008,
    descr: "REGPROC&#91;&#93;",
    name: "_regproc",
    kind: Kind::Array(24),
};

/// TEXT&#91;&#93;
pub const TEXT_ARRAY: Type = Type {
    oid: 1009,
    descr: "TEXT&#91;&#93;",
    name: "_text",
    kind: Kind::Array(25),
};

/// TID&#91;&#93;
pub const TID_ARRAY: Type = Type {
    oid: 1010,
    descr: "TID&#91;&#93;",
    name: "_tid",
    kind: Kind::Array(27),
};

/// XID&#91;&#93;
pub const XID_ARRAY: Type = Type {
    oid: 1011,
    descr: "XID&#91;&#93;",
    name: "_xid",
    kind: Kind::Array(28),
};

/// CID&#91;&#93;
pub const CID_ARRAY: Type = Type {
    oid: 1012,
    descr: "CID&#91;&#93;",
    name: "_cid",
    kind: Kind::Array(29),
};

/// OIDVECTOR&#91;&#93;
pub const OID_VECTOR_ARRAY: Type = Type {
    oid: 1013,
    descr: "OIDVECTOR&#91;&#93;",
    name: "_oidvector",
    kind: Kind::Array(30),
};

/// BPCHAR&#91;&#93;
pub const BPCHAR_ARRAY: Type = Type {
    oid: 1014,
    descr: "BPCHAR&#91;&#93;",
    name: "_bpchar",
    kind: Kind::Array(1042),
};

/// VARCHAR&#91;&#93;
pub const VARCHAR_ARRAY: Type = Type {
    oid: 1015,
    descr: "VARCHAR&#91;&#93;",
    name: "_varchar",
    kind: Kind::Array(1043),
};

/// INT8&#91;&#93;
pub const INT8_ARRAY: Type = Type {
    oid: 1016,
    descr: "INT8&#91;&#93;",
    name: "_int8",
    kind: Kind::Array(20),
};

/// POINT&#91;&#93;
pub const POINT_ARRAY: Type = Type {
    oid: 1017,
    descr: "POINT&#91;&#93;",
    name: "_point",
    kind: Kind::Array(600),
};

/// LSEG&#91;&#93;
pub const LSEG_ARRAY: Type = Type {
    oid: 1018,
    descr: "LSEG&#91;&#93;",
    name: "_lseg",
    kind: Kind::Array(601),
};

/// PATH&#91;&#93;
pub const PATH_ARRAY: Type = Type {
    oid: 1019,
    descr: "PATH&#91;&#93;",
    name: "_path",
    kind: Kind::Array(602),
};

/// BOX&#91;&#93;
pub const BOX_ARRAY: Type = Type {
    oid: 1020,
    descr: "BOX&#91;&#93;",
    name: "_box",
    kind: Kind::Array(603),
};

/// FLOAT4&#91;&#93;
pub const FLOAT4_ARRAY: Type = Type {
    oid: 1021,
    descr: "FLOAT4&#91;&#93;",
    name: "_float4",
    kind: Kind::Array(700),
};

/// FLOAT8&#91;&#93;
pub const FLOAT8_ARRAY: Type = Type {
    oid: 1022,
    descr: "FLOAT8&#91;&#93;",
    name: "_float8",
    kind: Kind::Array(701),
};

/// POLYGON&#91;&#93;
pub const POLYGON_ARRAY: Type = Type {
    oid: 1027,
    descr: "POLYGON&#91;&#93;",
    name: "_polygon",
    kind: Kind::Array(604),
};

/// OID&#91;&#93;
pub const OID_ARRAY: Type = Type {
    oid: 1028,
    descr: "OID&#91;&#93;",
    name: "_oid",
    kind: Kind::Array(26),
};

/// ACLITEM - access control list
pub const ACLITEM: Type = Type {
    oid: 1033,
    descr: "ACLITEM - access control list",
    name: "aclitem",
    kind: Kind::UserDefined,
};

/// ACLITEM&#91;&#93;
pub const ACLITEM_ARRAY: Type = Type {
    oid: 1034,
    descr: "ACLITEM&#91;&#93;",
    name: "_aclitem",
    kind: Kind::Array(1033),
};

/// MACADDR&#91;&#93;
pub const MACADDR_ARRAY: Type = Type {
    oid: 1040,
    descr: "MACADDR&#91;&#93;",
    name: "_macaddr",
    kind: Kind::Array(829),
};

/// INET&#91;&#93;
pub const INET_ARRAY: Type = Type {
    oid: 1041,
    descr: "INET&#91;&#93;",
    name: "_inet",
    kind: Kind::Array(869),
};

/// BPCHAR - char&#40;length&#41;, blank-padded string, fixed storage length
pub const BPCHAR: Type = Type {
    oid: 1042,
    descr: "BPCHAR - char&#40;length&#41;, blank-padded string, fixed storage length",
    name: "bpchar",
    kind: Kind::String,
};

/// VARCHAR - varchar&#40;length&#41;, non-blank-padded string, variable storage length
pub const VARCHAR: Type = Type {
    oid: 1043,
    descr: "VARCHAR - varchar&#40;length&#41;, non-blank-padded string, variable storage length",
    name: "varchar",
    kind: Kind::String,
};

/// DATE - date
pub const DATE: Type = Type {
    oid: 1082,
    descr: "DATE - date",
    name: "date",
    kind: Kind::DateTime,
};

/// TIME - time of day
pub const TIME: Type = Type {
    oid: 1083,
    descr: "TIME - time of day",
    name: "time",
    kind: Kind::DateTime,
};

/// TIMESTAMP - date and time
pub const TIMESTAMP: Type = Type {
    oid: 1114,
    descr: "TIMESTAMP - date and time",
    name: "timestamp",
    kind: Kind::DateTime,
};

/// TIMESTAMP&#91;&#93;
pub const TIMESTAMP_ARRAY: Type = Type {
    oid: 1115,
    descr: "TIMESTAMP&#91;&#93;",
    name: "_timestamp",
    kind: Kind::Array(1114),
};

/// DATE&#91;&#93;
pub const DATE_ARRAY: Type = Type {
    oid: 1182,
    descr: "DATE&#91;&#93;",
    name: "_date",
    kind: Kind::Array(1082),
};

/// TIME&#91;&#93;
pub const TIME_ARRAY: Type = Type {
    oid: 1183,
    descr: "TIME&#91;&#93;",
    name: "_time",
    kind: Kind::Array(1083),
};

/// TIMESTAMPTZ - date and time with time zone
pub const TIMESTAMPTZ: Type = Type {
    oid: 1184,
    descr: "TIMESTAMPTZ - date and time with time zone",
    name: "timestamptz",
    kind: Kind::DateTime,
};

/// TIMESTAMPTZ&#91;&#93;
pub const TIMESTAMPTZ_ARRAY: Type = Type {
    oid: 1185,
    descr: "TIMESTAMPTZ&#91;&#93;",
    name: "_timestamptz",
    kind: Kind::Array(1184),
};

/// INTERVAL - &#64; &lt;number&gt; &lt;units&gt;, time interval
pub const INTERVAL: Type = Type {
    oid: 1186,
    descr: "INTERVAL - &#64; &lt;number&gt; &lt;units&gt;, time interval",
    name: "interval",
    kind: Kind::Timestamp,
};

/// INTERVAL&#91;&#93;
pub const INTERVAL_ARRAY: Type = Type {
    oid: 1187,
    descr: "INTERVAL&#91;&#93;",
    name: "_interval",
    kind: Kind::Array(1186),
};

/// NUMERIC&#91;&#93;
pub const NUMERIC_ARRAY: Type = Type {
    oid: 1231,
    descr: "NUMERIC&#91;&#93;",
    name: "_numeric",
    kind: Kind::Array(1700),
};

/// CSTRING&#91;&#93;
pub const CSTRING_ARRAY: Type = Type {
    oid: 1263,
    descr: "CSTRING&#91;&#93;",
    name: "_cstring",
    kind: Kind::Array(2275),
};

/// TIMETZ - time of day with time zone
pub const TIMETZ: Type = Type {
    oid: 1266,
    descr: "TIMETZ - time of day with time zone",
    name: "timetz",
    kind: Kind::DateTime,
};

/// TIMETZ&#91;&#93;
pub const TIMETZ_ARRAY: Type = Type {
    oid: 1270,
    descr: "TIMETZ&#91;&#93;",
    name: "_timetz",
    kind: Kind::Array(1266),
};

/// BIT - fixed-length bit string
pub const BIT: Type = Type {
    oid: 1560,
    descr: "BIT - fixed-length bit string",
    name: "bit",
    kind: Kind::BitString,
};

/// BIT&#91;&#93;
pub const BIT_ARRAY: Type = Type {
    oid: 1561,
    descr: "BIT&#91;&#93;",
    name: "_bit",
    kind: Kind::Array(1560),
};

/// VARBIT - variable-length bit string
pub const VARBIT: Type = Type {
    oid: 1562,
    descr: "VARBIT - variable-length bit string",
    name: "varbit",
    kind: Kind::BitString,
};

/// VARBIT&#91;&#93;
pub const VARBIT_ARRAY: Type = Type {
    oid: 1563,
    descr: "VARBIT&#91;&#93;",
    name: "_varbit",
    kind: Kind::Array(1562),
};

/// NUMERIC - numeric&#40;precision, decimal&#41;, arbitrary precision number
pub const NUMERIC: Type = Type {
    oid: 1700,
    descr: "NUMERIC - numeric&#40;precision, decimal&#41;, arbitrary precision number",
    name: "numeric",
    kind: Kind::Numeric,
};

/// REFCURSOR - reference to cursor &#40;portal name&#41;
pub const REFCURSOR: Type = Type {
    oid: 1790,
    descr: "REFCURSOR - reference to cursor &#40;portal name&#41;",
    name: "refcursor",
    kind: Kind::UserDefined,
};

/// REFCURSOR&#91;&#93;
pub const REFCURSOR_ARRAY: Type = Type {
    oid: 2201,
    descr: "REFCURSOR&#91;&#93;",
    name: "_refcursor",
    kind: Kind::Array(1790),
};

/// REGPROCEDURE - registered procedure &#40;with args&#41;
pub const REGPROCEDURE: Type = Type {
    oid: 2202,
    descr: "REGPROCEDURE - registered procedure &#40;with args&#41;",
    name: "regprocedure",
    kind: Kind::Numeric,
};

/// REGOPER - registered operator
pub const REGOPER: Type = Type {
    oid: 2203,
    descr: "REGOPER - registered operator",
    name: "regoper",
    kind: Kind::Numeric,
};

/// REGOPERATOR - registered operator &#40;with args&#41;
pub const REGOPERATOR: Type = Type {
    oid: 2204,
    descr: "REGOPERATOR - registered operator &#40;with args&#41;",
    name: "regoperator",
    kind: Kind::Numeric,
};

/// REGCLASS - registered class
pub const REGCLASS: Type = Type {
    oid: 2205,
    descr: "REGCLASS - registered class",
    name: "regclass",
    kind: Kind::Numeric,
};

/// REGTYPE - registered type
pub const REGTYPE: Type = Type {
    oid: 2206,
    descr: "REGTYPE - registered type",
    name: "regtype",
    kind: Kind::Numeric,
};

/// REGPROCEDURE&#91;&#93;
pub const REGPROCEDURE_ARRAY: Type = Type {
    oid: 2207,
    descr: "REGPROCEDURE&#91;&#93;",
    name: "_regprocedure",
    kind: Kind::Array(2202),
};

/// REGOPER&#91;&#93;
pub const REGOPER_ARRAY: Type = Type {
    oid: 2208,
    descr: "REGOPER&#91;&#93;",
    name: "_regoper",
    kind: Kind::Array(2203),
};

/// REGOPERATOR&#91;&#93;
pub const REGOPERATOR_ARRAY: Type = Type {
    oid: 2209,
    descr: "REGOPERATOR&#91;&#93;",
    name: "_regoperator",
    kind: Kind::Array(2204),
};

/// REGCLASS&#91;&#93;
pub const REGCLASS_ARRAY: Type = Type {
    oid: 2210,
    descr: "REGCLASS&#91;&#93;",
    name: "_regclass",
    kind: Kind::Array(2205),
};

/// REGTYPE&#91;&#93;
pub const REGTYPE_ARRAY: Type = Type {
    oid: 2211,
    descr: "REGTYPE&#91;&#93;",
    name: "_regtype",
    kind: Kind::Array(2206),
};

/// RECORD - pseudo-type representing any composite type
pub const RECORD: Type = Type {
    oid: 2249,
    descr: "RECORD - pseudo-type representing any composite type",
    name: "record",
    kind: Kind::Pseudo,
};

/// CSTRING - C-style string
pub const CSTRING: Type = Type {
    oid: 2275,
    descr: "CSTRING - C-style string",
    name: "cstring",
    kind: Kind::Pseudo,
};

/// ANY - pseudo-type representing any type
pub const ANY: Type = Type {
    oid: 2276,
    descr: "ANY - pseudo-type representing any type",
    name: "any",
    kind: Kind::Pseudo,
};

/// ANYARRAY - pseudo-type representing a polymorphic array type
pub const ANYARRAY: Type = Type {
    oid: 2277,
    descr: "ANYARRAY - pseudo-type representing a polymorphic array type",
    name: "anyarray",
    kind: Kind::Pseudo,
};

/// VOID - pseudo-type for the result of a function with no real result
pub const VOID: Type = Type {
    oid: 2278,
    descr: "VOID - pseudo-type for the result of a function with no real result",
    name: "void",
    kind: Kind::Pseudo,
};

/// TRIGGER - pseudo-type for the result of a trigger function
pub const TRIGGER: Type = Type {
    oid: 2279,
    descr: "TRIGGER - pseudo-type for the result of a trigger function",
    name: "trigger",
    kind: Kind::Pseudo,
};

/// LANGUAGE_HANDLER - pseudo-type for the result of a language handler function
pub const LANGUAGE_HANDLER: Type = Type {
    oid: 2280,
    descr: "LANGUAGE_HANDLER - pseudo-type for the result of a language handler function",
    name: "language_handler",
    kind: Kind::Pseudo,
};

/// INTERNAL - pseudo-type representing an internal data structure
pub const INTERNAL: Type = Type {
    oid: 2281,
    descr: "INTERNAL - pseudo-type representing an internal data structure",
    name: "internal",
    kind: Kind::Pseudo,
};

/// OPAQUE - obsolete, deprecated pseudo-type
#[deprecated = "Remove in postgresql 13"]
pub const OPAQUE: Type = Type {
    oid: 2282,
    descr: "OPAQUE - obsolete, deprecated pseudo-type",
    name: "opaque",
    kind: Kind::Pseudo,
};

/// ANYELEMENT - pseudo-type representing a polymorphic base type
pub const ANYELEMENT: Type = Type {
    oid: 2283,
    descr: "ANYELEMENT - pseudo-type representing a polymorphic base type",
    name: "anyelement",
    kind: Kind::Pseudo,
};

/// RECORD&#91;&#93;
pub const RECORD_ARRAY: Type = Type {
    oid: 2287,
    descr: "RECORD&#91;&#93;",
    name: "_record",
    kind: Kind::Pseudo,
};

/// ANYNONARRAY - pseudo-type representing a polymorphic base type that is not an array
pub const ANYNONARRAY: Type = Type {
    oid: 2776,
    descr: "ANYNONARRAY - pseudo-type representing a polymorphic base type that is not an array",
    name: "anynonarray",
    kind: Kind::Pseudo,
};

/// TXID_SNAPSHOT&#91;&#93;
pub const TXID_SNAPSHOT_ARRAY: Type = Type {
    oid: 2949,
    descr: "TXID_SNAPSHOT&#91;&#93;",
    name: "_txid_snapshot",
    kind: Kind::Array(2970),
};

/// UUID - UUID datatype
pub const UUID: Type = Type {
    oid: 2950,
    descr: "UUID - UUID datatype",
    name: "uuid",
    kind: Kind::UserDefined,
};

/// UUID&#91;&#93;
pub const UUID_ARRAY: Type = Type {
    oid: 2951,
    descr: "UUID&#91;&#93;",
    name: "_uuid",
    kind: Kind::Array(2950),
};

/// TXID_SNAPSHOT - txid snapshot
pub const TXID_SNAPSHOT: Type = Type {
    oid: 2970,
    descr: "TXID_SNAPSHOT - txid snapshot",
    name: "txid_snapshot",
    kind: Kind::UserDefined,
};

/// FDW_HANDLER - pseudo-type for the result of an FDW handler function
pub const FDW_HANDLER: Type = Type {
    oid: 3115,
    descr: "FDW_HANDLER - pseudo-type for the result of an FDW handler function",
    name: "fdw_handler",
    kind: Kind::Pseudo,
};

/// PG_LSN - PostgreSQL LSN datatype
pub const PG_LSN: Type = Type {
    oid: 3220,
    descr: "PG_LSN - PostgreSQL LSN datatype",
    name: "pg_lsn",
    kind: Kind::UserDefined,
};

/// PG_LSN&#91;&#93;
pub const PG_LSN_ARRAY: Type = Type {
    oid: 3221,
    descr: "PG_LSN&#91;&#93;",
    name: "_pg_lsn",
    kind: Kind::Array(3220),
};

/// TSM_HANDLER - pseudo-type for the result of a tablesample method function
pub const TSM_HANDLER: Type = Type {
    oid: 3310,
    descr: "TSM_HANDLER - pseudo-type for the result of a tablesample method function",
    name: "tsm_handler",
    kind: Kind::Pseudo,
};

/// PG_NDISTINCT - multivariate ndistinct coefficients
pub const PG_NDISTINCT: Type = Type {
    oid: 3361,
    descr: "PG_NDISTINCT - multivariate ndistinct coefficients",
    name: "pg_ndistinct",
    kind: Kind::String,
};

/// PG_DEPENDENCIES - multivariate dependencies
pub const PG_DEPENDENCIES: Type = Type {
    oid: 3402,
    descr: "PG_DEPENDENCIES - multivariate dependencies",
    name: "pg_dependencies",
    kind: Kind::String,
};

/// ANYENUM - pseudo-type representing a polymorphic base type that is an enum
pub const ANYENUM: Type = Type {
    oid: 3500,
    descr: "ANYENUM - pseudo-type representing a polymorphic base type that is an enum",
    name: "anyenum",
    kind: Kind::Pseudo,
};

/// TSVECTOR - text representation for text search
pub const TS_VECTOR: Type = Type {
    oid: 3614,
    descr: "TSVECTOR - text representation for text search",
    name: "tsvector",
    kind: Kind::UserDefined,
};

/// TSQUERY - query representation for text search
pub const TSQUERY: Type = Type {
    oid: 3615,
    descr: "TSQUERY - query representation for text search",
    name: "tsquery",
    kind: Kind::UserDefined,
};

/// GTSVECTOR - GiST index internal text representation for text search
pub const GTS_VECTOR: Type = Type {
    oid: 3642,
    descr: "GTSVECTOR - GiST index internal text representation for text search",
    name: "gtsvector",
    kind: Kind::UserDefined,
};

/// TSVECTOR&#91;&#93;
pub const TS_VECTOR_ARRAY: Type = Type {
    oid: 3643,
    descr: "TSVECTOR&#91;&#93;",
    name: "_tsvector",
    kind: Kind::Array(3614),
};

/// GTSVECTOR&#91;&#93;
pub const GTS_VECTOR_ARRAY: Type = Type {
    oid: 3644,
    descr: "GTSVECTOR&#91;&#93;",
    name: "_gtsvector",
    kind: Kind::Array(3642),
};

/// TSQUERY&#91;&#93;
pub const TSQUERY_ARRAY: Type = Type {
    oid: 3645,
    descr: "TSQUERY&#91;&#93;",
    name: "_tsquery",
    kind: Kind::Array(3615),
};

/// REGCONFIG - registered text search configuration
pub const REGCONFIG: Type = Type {
    oid: 3734,
    descr: "REGCONFIG - registered text search configuration",
    name: "regconfig",
    kind: Kind::Numeric,
};

/// REGCONFIG&#91;&#93;
pub const REGCONFIG_ARRAY: Type = Type {
    oid: 3735,
    descr: "REGCONFIG&#91;&#93;",
    name: "_regconfig",
    kind: Kind::Array(3734),
};

/// REGDICTIONARY - registered text search dictionary
pub const REGDICTIONARY: Type = Type {
    oid: 3769,
    descr: "REGDICTIONARY - registered text search dictionary",
    name: "regdictionary",
    kind: Kind::Numeric,
};

/// REGDICTIONARY&#91;&#93;
pub const REGDICTIONARY_ARRAY: Type = Type {
    oid: 3770,
    descr: "REGDICTIONARY&#91;&#93;",
    name: "_regdictionary",
    kind: Kind::Array(3769),
};

/// JSONB - Binary JSON
pub const JSONB: Type = Type {
    oid: 3802,
    descr: "JSONB - Binary JSON",
    name: "jsonb",
    kind: Kind::UserDefined,
};

/// JSONB&#91;&#93;
pub const JSONB_ARRAY: Type = Type {
    oid: 3807,
    descr: "JSONB&#91;&#93;",
    name: "_jsonb",
    kind: Kind::Array(3802),
};

/// ANYRANGE - pseudo-type representing a range over a polymorphic base type
pub const ANY_RANGE: Type = Type {
    oid: 3831,
    descr: "ANYRANGE - pseudo-type representing a range over a polymorphic base type",
    name: "anyrange",
    kind: Kind::Pseudo,
};

/// EVENT_TRIGGER - pseudo-type for the result of an event trigger function
pub const EVENT_TRIGGER: Type = Type {
    oid: 3838,
    descr: "EVENT_TRIGGER - pseudo-type for the result of an event trigger function",
    name: "event_trigger",
    kind: Kind::Pseudo,
};

/// INT4RANGE - range of integers
pub const INT4_RANGE: Type = Type {
    oid: 3904,
    descr: "INT4RANGE - range of integers",
    name: "int4range",
    kind: Kind::Range(23),
};

/// INT4RANGE&#91;&#93;
pub const INT4_RANGE_ARRAY: Type = Type {
    oid: 3905,
    descr: "INT4RANGE&#91;&#93;",
    name: "_int4range",
    kind: Kind::Array(3904),
};

/// NUMRANGE - range of numerics
pub const NUM_RANGE: Type = Type {
    oid: 3906,
    descr: "NUMRANGE - range of numerics",
    name: "numrange",
    kind: Kind::Range(1700),
};

/// NUMRANGE&#91;&#93;
pub const NUM_RANGE_ARRAY: Type = Type {
    oid: 3907,
    descr: "NUMRANGE&#91;&#93;",
    name: "_numrange",
    kind: Kind::Array(3906),
};

/// TSRANGE - range of timestamps without time zone
pub const TS_RANGE: Type = Type {
    oid: 3908,
    descr: "TSRANGE - range of timestamps without time zone",
    name: "tsrange",
    kind: Kind::Range(1114),
};

/// TSRANGE&#91;&#93;
pub const TS_RANGE_ARRAY: Type = Type {
    oid: 3909,
    descr: "TSRANGE&#91;&#93;",
    name: "_tsrange",
    kind: Kind::Array(3908),
};

/// TSTZRANGE - range of timestamps with time zone
pub const TSTZ_RANGE: Type = Type {
    oid: 3910,
    descr: "TSTZRANGE - range of timestamps with time zone",
    name: "tstzrange",
    kind: Kind::Range(1184),
};

/// TSTZRANGE&#91;&#93;
pub const TSTZ_RANGE_ARRAY: Type = Type {
    oid: 3911,
    descr: "TSTZRANGE&#91;&#93;",
    name: "_tstzrange",
    kind: Kind::Array(3910),
};

/// DATERANGE - range of dates
pub const DATE_RANGE: Type = Type {
    oid: 3912,
    descr: "DATERANGE - range of dates",
    name: "daterange",
    kind: Kind::Range(1082),
};

/// DATERANGE&#91;&#93;
pub const DATE_RANGE_ARRAY: Type = Type {
    oid: 3913,
    descr: "DATERANGE&#91;&#93;",
    name: "_daterange",
    kind: Kind::Array(3912),
};

/// INT8RANGE - range of bigints
pub const INT8_RANGE: Type = Type {
    oid: 3926,
    descr: "INT8RANGE - range of bigints",
    name: "int8range",
    kind: Kind::Range(20),
};

/// INT8RANGE&#91;&#93;
pub const INT8_RANGE_ARRAY: Type = Type {
    oid: 3927,
    descr: "INT8RANGE&#91;&#93;",
    name: "_int8range",
    kind: Kind::Array(3926),
};

/// JSONPATH - JSON path
pub const JSONPATH: Type = Type {
    oid: 4072,
    descr: "JSONPATH - JSON path",
    name: "jsonpath",
    kind: Kind::UserDefined,
};

/// JSONPATH&#91;&#93;
pub const JSONPATH_ARRAY: Type = Type {
    oid: 4073,
    descr: "JSONPATH&#91;&#93;",
    name: "_jsonpath",
    kind: Kind::Array(4072),
};

/// REGNAMESPACE - registered namespace
pub const REGNAMESPACE: Type = Type {
    oid: 4089,
    descr: "REGNAMESPACE - registered namespace",
    name: "regnamespace",
    kind: Kind::Numeric,
};

/// REGNAMESPACE&#91;&#93;
pub const REGNAMESPACE_ARRAY: Type = Type {
    oid: 4090,
    descr: "REGNAMESPACE&#91;&#93;",
    name: "_regnamespace",
    kind: Kind::Array(4089),
};

/// REGROLE - registered role
pub const REGROLE: Type = Type {
    oid: 4096,
    descr: "REGROLE - registered role",
    name: "regrole",
    kind: Kind::Numeric,
};

/// REGROLE&#91;&#93;
pub const REGROLE_ARRAY: Type = Type {
    oid: 4097,
    descr: "REGROLE&#91;&#93;",
    name: "_regrole",
    kind: Kind::Array(4096),
};

/// REGCOLLATION - registered collation
pub const REGCOLLATION: Type = Type {
    oid: 4191,
    descr: "REGCOLLATION - registered collation",
    name: "regcollation",
    kind: Kind::Numeric,
};

/// REGCOLLATION&#91;&#93;
pub const REGCOLLATION_ARRAY: Type = Type {
    oid: 4192,
    descr: "REGCOLLATION&#91;&#93;",
    name: "_regcollation",
    kind: Kind::Array(4191),
};

/// INT4MULTIRANGE - multirange of integers
pub const INT4MULTI_RANGE: Type = Type {
    oid: 4451,
    descr: "INT4MULTIRANGE - multirange of integers",
    name: "int4multirange",
    kind: Kind::Range(23),
};

/// NUMMULTIRANGE - multirange of numerics
pub const NUMMULTI_RANGE: Type = Type {
    oid: 4532,
    descr: "NUMMULTIRANGE - multirange of numerics",
    name: "nummultirange",
    kind: Kind::Range(1700),
};

/// TSMULTIRANGE - multirange of timestamps without time zone
pub const TSMULTI_RANGE: Type = Type {
    oid: 4533,
    descr: "TSMULTIRANGE - multirange of timestamps without time zone",
    name: "tsmultirange",
    kind: Kind::Range(1114),
};

/// TSTZMULTIRANGE - multirange of timestamps with time zone
pub const TSTZMULTI_RANGE: Type = Type {
    oid: 4534,
    descr: "TSTZMULTIRANGE - multirange of timestamps with time zone",
    name: "tstzmultirange",
    kind: Kind::Range(1184),
};

/// DATEMULTIRANGE - multirange of dates
pub const DATEMULTI_RANGE: Type = Type {
    oid: 4535,
    descr: "DATEMULTIRANGE - multirange of dates",
    name: "datemultirange",
    kind: Kind::Range(1082),
};

/// INT8MULTIRANGE - multirange of bigints
pub const INT8MULTI_RANGE: Type = Type {
    oid: 4536,
    descr: "INT8MULTIRANGE - multirange of bigints",
    name: "int8multirange",
    kind: Kind::Range(20),
};

/// ANYMULTIRANGE - pseudo-type representing a polymorphic base type that is a multirange
pub const ANYMULTI_RANGE: Type = Type {
    oid: 4537,
    descr: "ANYMULTIRANGE - pseudo-type representing a polymorphic base type that is a multirange",
    name: "anymultirange",
    kind: Kind::Pseudo,
};

/// ANYCOMPATIBLEMULTIRANGE - pseudo-type representing a multirange over a polymorphic common type
pub const ANYCOMPATIBLEMULTI_RANGE: Type = Type {
    oid: 4538,
    descr: "ANYCOMPATIBLEMULTIRANGE - pseudo-type representing a multirange over a polymorphic common type",
    name: "anycompatiblemultirange",
    kind: Kind::Pseudo,
};

/// PG_BRIN_BLOOM_SUMMARY - BRIN bloom summary
pub const PG_BRIN_BLOOM_SUMMARY: Type = Type {
    oid: 4600,
    descr: "PG_BRIN_BLOOM_SUMMARY - BRIN bloom summary",
    name: "pg_brin_bloom_summary",
    kind: Kind::String,
};

/// PG_BRIN_MINMAX_MULTI_SUMMARY - BRIN minmax-multi summary
pub const PG_BRIN_MINMAX_MULTI_SUMMARY: Type = Type {
    oid: 4601,
    descr: "PG_BRIN_MINMAX_MULTI_SUMMARY - BRIN minmax-multi summary",
    name: "pg_brin_minmax_multi_summary",
    kind: Kind::String,
};

/// PG_MCV_LIST - multivariate MCV list
pub const PG_MCV_LIST: Type = Type {
    oid: 5017,
    descr: "PG_MCV_LIST - multivariate MCV list",
    name: "pg_mcv_list",
    kind: Kind::String,
};

/// PG_SNAPSHOT - snapshot
pub const PG_SNAPSHOT: Type = Type {
    oid: 5038,
    descr: "PG_SNAPSHOT - snapshot",
    name: "pg_snapshot",
    kind: Kind::UserDefined,
};

/// PG_SNAPSHOT&#91;&#93;
pub const PG_SNAPSHOT_ARRAY: Type = Type {
    oid: 5039,
    descr: "PG_SNAPSHOT&#91;&#93;",
    name: "_pg_snapshot",
    kind: Kind::Array(5038),
};

/// XID8 - full transaction id
pub const XID8: Type = Type {
    oid: 5069,
    descr: "XID8 - full transaction id",
    name: "xid8",
    kind: Kind::UserDefined,
};

/// ANYCOMPATIBLE - pseudo-type representing a polymorphic common type
pub const ANYCOMPATIBLE: Type = Type {
    oid: 5077,
    descr: "ANYCOMPATIBLE - pseudo-type representing a polymorphic common type",
    name: "anycompatible",
    kind: Kind::Pseudo,
};

/// ANYCOMPATIBLEARRAY - pseudo-type representing an array of polymorphic common type elements
pub const ANYCOMPATIBLEARRAY: Type = Type {
    oid: 5078,
    descr: "ANYCOMPATIBLEARRAY - pseudo-type representing an array of polymorphic common type elements",
    name: "anycompatiblearray",
    kind: Kind::Pseudo,
};

/// ANYCOMPATIBLENONARRAY - pseudo-type representing a polymorphic common type that is not an array
pub const ANYCOMPATIBLENONARRAY: Type = Type {
    oid: 5079,
    descr: "ANYCOMPATIBLENONARRAY - pseudo-type representing a polymorphic common type that is not an array",
    name: "anycompatiblenonarray",
    kind: Kind::Pseudo,
};

/// ANYCOMPATIBLERANGE - pseudo-type representing a range over a polymorphic common type
pub const ANYCOMPATIBLE_RANGE: Type = Type {
    oid: 5080,
    descr: "ANYCOMPATIBLERANGE - pseudo-type representing a range over a polymorphic common type",
    name: "anycompatiblerange",
    kind: Kind::Pseudo,
};

/// INT4MULTIRANGE&#91;&#93;
pub const INT4MULTI_RANGE_ARRAY: Type = Type {
    oid: 6150,
    descr: "INT4MULTIRANGE&#91;&#93;",
    name: "_int4multirange",
    kind: Kind::Array(4451),
};

/// NUMMULTIRANGE&#91;&#93;
pub const NUMMULTI_RANGE_ARRAY: Type = Type {
    oid: 6151,
    descr: "NUMMULTIRANGE&#91;&#93;",
    name: "_nummultirange",
    kind: Kind::Array(4532),
};

/// TSMULTIRANGE&#91;&#93;
pub const TSMULTI_RANGE_ARRAY: Type = Type {
    oid: 6152,
    descr: "TSMULTIRANGE&#91;&#93;",
    name: "_tsmultirange",
    kind: Kind::Array(4533),
};

/// TSTZMULTIRANGE&#91;&#93;
pub const TSTZMULTI_RANGE_ARRAY: Type = Type {
    oid: 6153,
    descr: "TSTZMULTIRANGE&#91;&#93;",
    name: "_tstzmultirange",
    kind: Kind::Array(4534),
};

/// DATEMULTIRANGE&#91;&#93;
pub const DATEMULTI_RANGE_ARRAY: Type = Type {
    oid: 6155,
    descr: "DATEMULTIRANGE&#91;&#93;",
    name: "_datemultirange",
    kind: Kind::Array(4535),
};

/// INT8MULTIRANGE&#91;&#93;
pub const INT8MULTI_RANGE_ARRAY: Type = Type {
    oid: 6157,
    descr: "INT8MULTIRANGE&#91;&#93;",
    name: "_int8multirange",
    kind: Kind::Array(4536),
};

impl std::convert::TryFrom<u32> for Type {
    type Error = String;

    fn try_from(oid: u32) -> std::result::Result<Self, Self::Error> {
        match oid {
            16 => Ok(BOOL),
            17 => Ok(BYTEA),
            18 => Ok(CHAR),
            19 => Ok(NAME),
            20 => Ok(INT8),
            21 => Ok(INT2),
            22 => Ok(INT2_VECTOR),
            23 => Ok(INT4),
            24 => Ok(REGPROC),
            25 => Ok(TEXT),
            26 => Ok(OID),
            27 => Ok(TID),
            28 => Ok(XID),
            29 => Ok(CID),
            30 => Ok(OID_VECTOR),
            32 => Ok(PG_DDL_COMMAND),
            114 => Ok(JSON),
            142 => Ok(XML),
            143 => Ok(XML_ARRAY),
            194 => Ok(PG_NODE_TREE),
            199 => Ok(JSON_ARRAY),
            269 => Ok(TABLE_AM_HANDLER),
            271 => Ok(XID8_ARRAY),
            325 => Ok(INDEX_AM_HANDLER),
            600 => Ok(POINT),
            601 => Ok(LSEG),
            602 => Ok(PATH),
            603 => Ok(BOX),
            604 => Ok(POLYGON),
            628 => Ok(LINE),
            629 => Ok(LINE_ARRAY),
            650 => Ok(CIDR),
            651 => Ok(CIDR_ARRAY),
            700 => Ok(FLOAT4),
            701 => Ok(FLOAT8),
            705 => Ok(UNKNOWN),
            718 => Ok(CIRCLE),
            719 => Ok(CIRCLE_ARRAY),
            774 => Ok(MACADDR8),
            775 => Ok(MACADDR8_ARRAY),
            790 => Ok(MONEY),
            791 => Ok(MONEY_ARRAY),
            829 => Ok(MACADDR),
            869 => Ok(INET),
            1000 => Ok(BOOL_ARRAY),
            1001 => Ok(BYTEA_ARRAY),
            1002 => Ok(CHAR_ARRAY),
            1003 => Ok(NAME_ARRAY),
            1005 => Ok(INT2_ARRAY),
            1006 => Ok(INT2_VECTOR_ARRAY),
            1007 => Ok(INT4_ARRAY),
            1008 => Ok(REGPROC_ARRAY),
            1009 => Ok(TEXT_ARRAY),
            1010 => Ok(TID_ARRAY),
            1011 => Ok(XID_ARRAY),
            1012 => Ok(CID_ARRAY),
            1013 => Ok(OID_VECTOR_ARRAY),
            1014 => Ok(BPCHAR_ARRAY),
            1015 => Ok(VARCHAR_ARRAY),
            1016 => Ok(INT8_ARRAY),
            1017 => Ok(POINT_ARRAY),
            1018 => Ok(LSEG_ARRAY),
            1019 => Ok(PATH_ARRAY),
            1020 => Ok(BOX_ARRAY),
            1021 => Ok(FLOAT4_ARRAY),
            1022 => Ok(FLOAT8_ARRAY),
            1027 => Ok(POLYGON_ARRAY),
            1028 => Ok(OID_ARRAY),
            1033 => Ok(ACLITEM),
            1034 => Ok(ACLITEM_ARRAY),
            1040 => Ok(MACADDR_ARRAY),
            1041 => Ok(INET_ARRAY),
            1042 => Ok(BPCHAR),
            1043 => Ok(VARCHAR),
            1082 => Ok(DATE),
            1083 => Ok(TIME),
            1114 => Ok(TIMESTAMP),
            1115 => Ok(TIMESTAMP_ARRAY),
            1182 => Ok(DATE_ARRAY),
            1183 => Ok(TIME_ARRAY),
            1184 => Ok(TIMESTAMPTZ),
            1185 => Ok(TIMESTAMPTZ_ARRAY),
            1186 => Ok(INTERVAL),
            1187 => Ok(INTERVAL_ARRAY),
            1231 => Ok(NUMERIC_ARRAY),
            1263 => Ok(CSTRING_ARRAY),
            1266 => Ok(TIMETZ),
            1270 => Ok(TIMETZ_ARRAY),
            1560 => Ok(BIT),
            1561 => Ok(BIT_ARRAY),
            1562 => Ok(VARBIT),
            1563 => Ok(VARBIT_ARRAY),
            1700 => Ok(NUMERIC),
            1790 => Ok(REFCURSOR),
            2201 => Ok(REFCURSOR_ARRAY),
            2202 => Ok(REGPROCEDURE),
            2203 => Ok(REGOPER),
            2204 => Ok(REGOPERATOR),
            2205 => Ok(REGCLASS),
            2206 => Ok(REGTYPE),
            2207 => Ok(REGPROCEDURE_ARRAY),
            2208 => Ok(REGOPER_ARRAY),
            2209 => Ok(REGOPERATOR_ARRAY),
            2210 => Ok(REGCLASS_ARRAY),
            2211 => Ok(REGTYPE_ARRAY),
            2249 => Ok(RECORD),
            2275 => Ok(CSTRING),
            2276 => Ok(ANY),
            2277 => Ok(ANYARRAY),
            2278 => Ok(VOID),
            2279 => Ok(TRIGGER),
            2280 => Ok(LANGUAGE_HANDLER),
            2281 => Ok(INTERNAL),
            #[allow(deprecated)]
            2282 => Ok(OPAQUE),
            2283 => Ok(ANYELEMENT),
            2287 => Ok(RECORD_ARRAY),
            2776 => Ok(ANYNONARRAY),
            2949 => Ok(TXID_SNAPSHOT_ARRAY),
            2950 => Ok(UUID),
            2951 => Ok(UUID_ARRAY),
            2970 => Ok(TXID_SNAPSHOT),
            3115 => Ok(FDW_HANDLER),
            3220 => Ok(PG_LSN),
            3221 => Ok(PG_LSN_ARRAY),
            3310 => Ok(TSM_HANDLER),
            3361 => Ok(PG_NDISTINCT),
            3402 => Ok(PG_DEPENDENCIES),
            3500 => Ok(ANYENUM),
            3614 => Ok(TS_VECTOR),
            3615 => Ok(TSQUERY),
            3642 => Ok(GTS_VECTOR),
            3643 => Ok(TS_VECTOR_ARRAY),
            3644 => Ok(GTS_VECTOR_ARRAY),
            3645 => Ok(TSQUERY_ARRAY),
            3734 => Ok(REGCONFIG),
            3735 => Ok(REGCONFIG_ARRAY),
            3769 => Ok(REGDICTIONARY),
            3770 => Ok(REGDICTIONARY_ARRAY),
            3802 => Ok(JSONB),
            3807 => Ok(JSONB_ARRAY),
            3831 => Ok(ANY_RANGE),
            3838 => Ok(EVENT_TRIGGER),
            3904 => Ok(INT4_RANGE),
            3905 => Ok(INT4_RANGE_ARRAY),
            3906 => Ok(NUM_RANGE),
            3907 => Ok(NUM_RANGE_ARRAY),
            3908 => Ok(TS_RANGE),
            3909 => Ok(TS_RANGE_ARRAY),
            3910 => Ok(TSTZ_RANGE),
            3911 => Ok(TSTZ_RANGE_ARRAY),
            3912 => Ok(DATE_RANGE),
            3913 => Ok(DATE_RANGE_ARRAY),
            3926 => Ok(INT8_RANGE),
            3927 => Ok(INT8_RANGE_ARRAY),
            4072 => Ok(JSONPATH),
            4073 => Ok(JSONPATH_ARRAY),
            4089 => Ok(REGNAMESPACE),
            4090 => Ok(REGNAMESPACE_ARRAY),
            4096 => Ok(REGROLE),
            4097 => Ok(REGROLE_ARRAY),
            4191 => Ok(REGCOLLATION),
            4192 => Ok(REGCOLLATION_ARRAY),
            4451 => Ok(INT4MULTI_RANGE),
            4532 => Ok(NUMMULTI_RANGE),
            4533 => Ok(TSMULTI_RANGE),
            4534 => Ok(TSTZMULTI_RANGE),
            4535 => Ok(DATEMULTI_RANGE),
            4536 => Ok(INT8MULTI_RANGE),
            4537 => Ok(ANYMULTI_RANGE),
            4538 => Ok(ANYCOMPATIBLEMULTI_RANGE),
            4600 => Ok(PG_BRIN_BLOOM_SUMMARY),
            4601 => Ok(PG_BRIN_MINMAX_MULTI_SUMMARY),
            5017 => Ok(PG_MCV_LIST),
            5038 => Ok(PG_SNAPSHOT),
            5039 => Ok(PG_SNAPSHOT_ARRAY),
            5069 => Ok(XID8),
            5077 => Ok(ANYCOMPATIBLE),
            5078 => Ok(ANYCOMPATIBLEARRAY),
            5079 => Ok(ANYCOMPATIBLENONARRAY),
            5080 => Ok(ANYCOMPATIBLE_RANGE),
            6150 => Ok(INT4MULTI_RANGE_ARRAY),
            6151 => Ok(NUMMULTI_RANGE_ARRAY),
            6152 => Ok(TSMULTI_RANGE_ARRAY),
            6153 => Ok(TSTZMULTI_RANGE_ARRAY),
            6155 => Ok(DATEMULTI_RANGE_ARRAY),
            6157 => Ok(INT8MULTI_RANGE_ARRAY),

            _ => Err("unknow type".to_string()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = String;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        match s {
            "bool" => Ok(BOOL),
            "bytea" => Ok(BYTEA),
            "char" => Ok(CHAR),
            "name" => Ok(NAME),
            "int8" => Ok(INT8),
            "int2" => Ok(INT2),
            "int2vector" => Ok(INT2_VECTOR),
            "int4" => Ok(INT4),
            "regproc" => Ok(REGPROC),
            "text" => Ok(TEXT),
            "oid" => Ok(OID),
            "tid" => Ok(TID),
            "xid" => Ok(XID),
            "cid" => Ok(CID),
            "oidvector" => Ok(OID_VECTOR),
            "pg_ddl_command" => Ok(PG_DDL_COMMAND),
            "json" => Ok(JSON),
            "xml" => Ok(XML),
            "_xml" => Ok(XML_ARRAY),
            "pg_node_tree" => Ok(PG_NODE_TREE),
            "_json" => Ok(JSON_ARRAY),
            "table_am_handler" => Ok(TABLE_AM_HANDLER),
            "_xid8" => Ok(XID8_ARRAY),
            "index_am_handler" => Ok(INDEX_AM_HANDLER),
            "point" => Ok(POINT),
            "lseg" => Ok(LSEG),
            "path" => Ok(PATH),
            "box" => Ok(BOX),
            "polygon" => Ok(POLYGON),
            "line" => Ok(LINE),
            "_line" => Ok(LINE_ARRAY),
            "cidr" => Ok(CIDR),
            "_cidr" => Ok(CIDR_ARRAY),
            "float4" => Ok(FLOAT4),
            "float8" => Ok(FLOAT8),
            "unknown" => Ok(UNKNOWN),
            "circle" => Ok(CIRCLE),
            "_circle" => Ok(CIRCLE_ARRAY),
            "macaddr8" => Ok(MACADDR8),
            "_macaddr8" => Ok(MACADDR8_ARRAY),
            "money" => Ok(MONEY),
            "_money" => Ok(MONEY_ARRAY),
            "macaddr" => Ok(MACADDR),
            "inet" => Ok(INET),
            "_bool" => Ok(BOOL_ARRAY),
            "_bytea" => Ok(BYTEA_ARRAY),
            "_char" => Ok(CHAR_ARRAY),
            "_name" => Ok(NAME_ARRAY),
            "_int2" => Ok(INT2_ARRAY),
            "_int2vector" => Ok(INT2_VECTOR_ARRAY),
            "_int4" => Ok(INT4_ARRAY),
            "_regproc" => Ok(REGPROC_ARRAY),
            "_text" => Ok(TEXT_ARRAY),
            "_tid" => Ok(TID_ARRAY),
            "_xid" => Ok(XID_ARRAY),
            "_cid" => Ok(CID_ARRAY),
            "_oidvector" => Ok(OID_VECTOR_ARRAY),
            "_bpchar" => Ok(BPCHAR_ARRAY),
            "_varchar" => Ok(VARCHAR_ARRAY),
            "_int8" => Ok(INT8_ARRAY),
            "_point" => Ok(POINT_ARRAY),
            "_lseg" => Ok(LSEG_ARRAY),
            "_path" => Ok(PATH_ARRAY),
            "_box" => Ok(BOX_ARRAY),
            "_float4" => Ok(FLOAT4_ARRAY),
            "_float8" => Ok(FLOAT8_ARRAY),
            "_polygon" => Ok(POLYGON_ARRAY),
            "_oid" => Ok(OID_ARRAY),
            "aclitem" => Ok(ACLITEM),
            "_aclitem" => Ok(ACLITEM_ARRAY),
            "_macaddr" => Ok(MACADDR_ARRAY),
            "_inet" => Ok(INET_ARRAY),
            "bpchar" => Ok(BPCHAR),
            "varchar" => Ok(VARCHAR),
            "date" => Ok(DATE),
            "time" => Ok(TIME),
            "timestamp" => Ok(TIMESTAMP),
            "_timestamp" => Ok(TIMESTAMP_ARRAY),
            "_date" => Ok(DATE_ARRAY),
            "_time" => Ok(TIME_ARRAY),
            "timestamptz" => Ok(TIMESTAMPTZ),
            "_timestamptz" => Ok(TIMESTAMPTZ_ARRAY),
            "interval" => Ok(INTERVAL),
            "_interval" => Ok(INTERVAL_ARRAY),
            "_numeric" => Ok(NUMERIC_ARRAY),
            "_cstring" => Ok(CSTRING_ARRAY),
            "timetz" => Ok(TIMETZ),
            "_timetz" => Ok(TIMETZ_ARRAY),
            "bit" => Ok(BIT),
            "_bit" => Ok(BIT_ARRAY),
            "varbit" => Ok(VARBIT),
            "_varbit" => Ok(VARBIT_ARRAY),
            "numeric" => Ok(NUMERIC),
            "refcursor" => Ok(REFCURSOR),
            "_refcursor" => Ok(REFCURSOR_ARRAY),
            "regprocedure" => Ok(REGPROCEDURE),
            "regoper" => Ok(REGOPER),
            "regoperator" => Ok(REGOPERATOR),
            "regclass" => Ok(REGCLASS),
            "regtype" => Ok(REGTYPE),
            "_regprocedure" => Ok(REGPROCEDURE_ARRAY),
            "_regoper" => Ok(REGOPER_ARRAY),
            "_regoperator" => Ok(REGOPERATOR_ARRAY),
            "_regclass" => Ok(REGCLASS_ARRAY),
            "_regtype" => Ok(REGTYPE_ARRAY),
            "record" => Ok(RECORD),
            "cstring" => Ok(CSTRING),
            "any" => Ok(ANY),
            "anyarray" => Ok(ANYARRAY),
            "void" => Ok(VOID),
            "trigger" => Ok(TRIGGER),
            "language_handler" => Ok(LANGUAGE_HANDLER),
            "internal" => Ok(INTERNAL),
            #[allow(deprecated)]
            "opaque" => Ok(OPAQUE),
            "anyelement" => Ok(ANYELEMENT),
            "_record" => Ok(RECORD_ARRAY),
            "anynonarray" => Ok(ANYNONARRAY),
            "_txid_snapshot" => Ok(TXID_SNAPSHOT_ARRAY),
            "uuid" => Ok(UUID),
            "_uuid" => Ok(UUID_ARRAY),
            "txid_snapshot" => Ok(TXID_SNAPSHOT),
            "fdw_handler" => Ok(FDW_HANDLER),
            "pg_lsn" => Ok(PG_LSN),
            "_pg_lsn" => Ok(PG_LSN_ARRAY),
            "tsm_handler" => Ok(TSM_HANDLER),
            "pg_ndistinct" => Ok(PG_NDISTINCT),
            "pg_dependencies" => Ok(PG_DEPENDENCIES),
            "anyenum" => Ok(ANYENUM),
            "tsvector" => Ok(TS_VECTOR),
            "tsquery" => Ok(TSQUERY),
            "gtsvector" => Ok(GTS_VECTOR),
            "_tsvector" => Ok(TS_VECTOR_ARRAY),
            "_gtsvector" => Ok(GTS_VECTOR_ARRAY),
            "_tsquery" => Ok(TSQUERY_ARRAY),
            "regconfig" => Ok(REGCONFIG),
            "_regconfig" => Ok(REGCONFIG_ARRAY),
            "regdictionary" => Ok(REGDICTIONARY),
            "_regdictionary" => Ok(REGDICTIONARY_ARRAY),
            "jsonb" => Ok(JSONB),
            "_jsonb" => Ok(JSONB_ARRAY),
            "anyrange" => Ok(ANY_RANGE),
            "event_trigger" => Ok(EVENT_TRIGGER),
            "int4range" => Ok(INT4_RANGE),
            "_int4range" => Ok(INT4_RANGE_ARRAY),
            "numrange" => Ok(NUM_RANGE),
            "_numrange" => Ok(NUM_RANGE_ARRAY),
            "tsrange" => Ok(TS_RANGE),
            "_tsrange" => Ok(TS_RANGE_ARRAY),
            "tstzrange" => Ok(TSTZ_RANGE),
            "_tstzrange" => Ok(TSTZ_RANGE_ARRAY),
            "daterange" => Ok(DATE_RANGE),
            "_daterange" => Ok(DATE_RANGE_ARRAY),
            "int8range" => Ok(INT8_RANGE),
            "_int8range" => Ok(INT8_RANGE_ARRAY),
            "jsonpath" => Ok(JSONPATH),
            "_jsonpath" => Ok(JSONPATH_ARRAY),
            "regnamespace" => Ok(REGNAMESPACE),
            "_regnamespace" => Ok(REGNAMESPACE_ARRAY),
            "regrole" => Ok(REGROLE),
            "_regrole" => Ok(REGROLE_ARRAY),
            "regcollation" => Ok(REGCOLLATION),
            "_regcollation" => Ok(REGCOLLATION_ARRAY),
            "int4multirange" => Ok(INT4MULTI_RANGE),
            "nummultirange" => Ok(NUMMULTI_RANGE),
            "tsmultirange" => Ok(TSMULTI_RANGE),
            "tstzmultirange" => Ok(TSTZMULTI_RANGE),
            "datemultirange" => Ok(DATEMULTI_RANGE),
            "int8multirange" => Ok(INT8MULTI_RANGE),
            "anymultirange" => Ok(ANYMULTI_RANGE),
            "anycompatiblemultirange" => Ok(ANYCOMPATIBLEMULTI_RANGE),
            "pg_brin_bloom_summary" => Ok(PG_BRIN_BLOOM_SUMMARY),
            "pg_brin_minmax_multi_summary" => Ok(PG_BRIN_MINMAX_MULTI_SUMMARY),
            "pg_mcv_list" => Ok(PG_MCV_LIST),
            "pg_snapshot" => Ok(PG_SNAPSHOT),
            "_pg_snapshot" => Ok(PG_SNAPSHOT_ARRAY),
            "xid8" => Ok(XID8),
            "anycompatible" => Ok(ANYCOMPATIBLE),
            "anycompatiblearray" => Ok(ANYCOMPATIBLEARRAY),
            "anycompatiblenonarray" => Ok(ANYCOMPATIBLENONARRAY),
            "anycompatiblerange" => Ok(ANYCOMPATIBLE_RANGE),
            "_int4multirange" => Ok(INT4MULTI_RANGE_ARRAY),
            "_nummultirange" => Ok(NUMMULTI_RANGE_ARRAY),
            "_tsmultirange" => Ok(TSMULTI_RANGE_ARRAY),
            "_tstzmultirange" => Ok(TSTZMULTI_RANGE_ARRAY),
            "_datemultirange" => Ok(DATEMULTI_RANGE_ARRAY),
            "_int8multirange" => Ok(INT8MULTI_RANGE_ARRAY),

            _ => Err("unknow type".to_string()),
        }
    }
}