// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::SaveDelegate;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "PanelWidget")]
    pub struct Widget(Object<ffi::PanelWidget, ffi::PanelWidgetClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::panel_widget_get_type(),
    }
}

impl Widget {
    pub const NONE: Option<&'static Widget> = None;

    #[doc(alias = "panel_widget_new")]
    pub fn new() -> Widget {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_full(ffi::panel_widget_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Widget`] objects.
    ///
    /// This method returns an instance of [`WidgetBuilder`](crate::builders::WidgetBuilder) which can be used to create [`Widget`] objects.
    pub fn builder() -> WidgetBuilder {
        WidgetBuilder::default()
    }
}

impl Default for Widget {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Widget`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct WidgetBuilder {
    background_rgba: Option<gdk::RGBA>,
    can_maximize: Option<bool>,
    child: Option<gtk::Widget>,
    foreground_rgba: Option<gdk::RGBA>,
    icon: Option<gio::Icon>,
    icon_name: Option<String>,
    kind: Option<String>,
    menu_model: Option<gio::MenuModel>,
    modified: Option<bool>,
    needs_attention: Option<bool>,
    reorderable: Option<bool>,
    save_delegate: Option<SaveDelegate>,
    title: Option<String>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    //cursor: /*Unknown type*/,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    //halign: /*Unknown type*/,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    //layout-manager: /*Unknown type*/,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    //overflow: /*Unknown type*/,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    //valign: /*Unknown type*/,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    //accessible-role: /*Unknown type*/,
}

impl WidgetBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`WidgetBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Widget`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Widget {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref background_rgba) = self.background_rgba {
            properties.push(("background-rgba", background_rgba));
        }
        if let Some(ref can_maximize) = self.can_maximize {
            properties.push(("can-maximize", can_maximize));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref foreground_rgba) = self.foreground_rgba {
            properties.push(("foreground-rgba", foreground_rgba));
        }
        if let Some(ref icon) = self.icon {
            properties.push(("icon", icon));
        }
        if let Some(ref icon_name) = self.icon_name {
            properties.push(("icon-name", icon_name));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref menu_model) = self.menu_model {
            properties.push(("menu-model", menu_model));
        }
        if let Some(ref modified) = self.modified {
            properties.push(("modified", modified));
        }
        if let Some(ref needs_attention) = self.needs_attention {
            properties.push(("needs-attention", needs_attention));
        }
        if let Some(ref reorderable) = self.reorderable {
            properties.push(("reorderable", reorderable));
        }
        if let Some(ref save_delegate) = self.save_delegate {
            properties.push(("save-delegate", save_delegate));
        }
        if let Some(ref title) = self.title {
            properties.push(("title", title));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        glib::Object::new::<Widget>(&properties).expect("Failed to create an instance of Widget")
    }

    pub fn background_rgba(mut self, background_rgba: &gdk::RGBA) -> Self {
        self.background_rgba = Some(background_rgba.clone());
        self
    }

    pub fn can_maximize(mut self, can_maximize: bool) -> Self {
        self.can_maximize = Some(can_maximize);
        self
    }

    pub fn child(mut self, child: &impl IsA<gtk::Widget>) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn foreground_rgba(mut self, foreground_rgba: &gdk::RGBA) -> Self {
        self.foreground_rgba = Some(foreground_rgba.clone());
        self
    }

    pub fn icon(mut self, icon: &impl IsA<gio::Icon>) -> Self {
        self.icon = Some(icon.clone().upcast());
        self
    }

    pub fn icon_name(mut self, icon_name: &str) -> Self {
        self.icon_name = Some(icon_name.to_string());
        self
    }

    pub fn kind(mut self, kind: &str) -> Self {
        self.kind = Some(kind.to_string());
        self
    }

    pub fn menu_model(mut self, menu_model: &impl IsA<gio::MenuModel>) -> Self {
        self.menu_model = Some(menu_model.clone().upcast());
        self
    }

    pub fn modified(mut self, modified: bool) -> Self {
        self.modified = Some(modified);
        self
    }

    pub fn needs_attention(mut self, needs_attention: bool) -> Self {
        self.needs_attention = Some(needs_attention);
        self
    }

    pub fn reorderable(mut self, reorderable: bool) -> Self {
        self.reorderable = Some(reorderable);
        self
    }

    pub fn save_delegate(mut self, save_delegate: &impl IsA<SaveDelegate>) -> Self {
        self.save_delegate = Some(save_delegate.clone().upcast());
        self
    }

    pub fn title(mut self, title: &str) -> Self {
        self.title = Some(title.to_string());
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub trait WidgetExt: 'static {
    #[doc(alias = "panel_widget_focus_default")]
    fn focus_default(&self) -> bool;

    #[doc(alias = "panel_widget_get_background_rgba")]
    #[doc(alias = "get_background_rgba")]
    fn background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "panel_widget_get_busy")]
    #[doc(alias = "get_busy")]
    fn is_busy(&self) -> bool;

    #[doc(alias = "panel_widget_get_can_maximize")]
    #[doc(alias = "get_can_maximize")]
    fn can_maximize(&self) -> bool;

    #[doc(alias = "panel_widget_get_child")]
    #[doc(alias = "get_child")]
    fn child(&self) -> Option<gtk::Widget>;

    #[doc(alias = "panel_widget_get_default_focus")]
    #[doc(alias = "get_default_focus")]
    fn default_focus(&self) -> Option<gtk::Widget>;

    #[doc(alias = "panel_widget_get_foreground_rgba")]
    #[doc(alias = "get_foreground_rgba")]
    fn foreground_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "panel_widget_get_icon")]
    #[doc(alias = "get_icon")]
    fn icon(&self) -> Option<gio::Icon>;

    #[doc(alias = "panel_widget_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    fn icon_name(&self) -> Option<glib::GString>;

    #[doc(alias = "panel_widget_get_kind")]
    #[doc(alias = "get_kind")]
    fn kind(&self) -> glib::GString;

    #[doc(alias = "panel_widget_get_menu_model")]
    #[doc(alias = "get_menu_model")]
    fn menu_model(&self) -> Option<gio::MenuModel>;

    #[doc(alias = "panel_widget_get_modified")]
    #[doc(alias = "get_modified")]
    fn is_modified(&self) -> bool;

    #[doc(alias = "panel_widget_get_needs_attention")]
    #[doc(alias = "get_needs_attention")]
    fn needs_attention(&self) -> bool;

    #[doc(alias = "panel_widget_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    fn is_reorderable(&self) -> bool;

    #[doc(alias = "panel_widget_get_save_delegate")]
    #[doc(alias = "get_save_delegate")]
    fn save_delegate(&self) -> Option<SaveDelegate>;

    #[doc(alias = "panel_widget_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[doc(alias = "panel_widget_mark_busy")]
    fn mark_busy(&self);

    #[doc(alias = "panel_widget_maximize")]
    fn maximize(&self);

    #[doc(alias = "panel_widget_raise")]
    fn raise(&self);

    #[doc(alias = "panel_widget_set_background_rgba")]
    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "panel_widget_set_can_maximize")]
    fn set_can_maximize(&self, can_maximize: bool);

    #[doc(alias = "panel_widget_set_child")]
    fn set_child(&self, child: Option<&impl IsA<gtk::Widget>>);

    #[doc(alias = "panel_widget_set_foreground_rgba")]
    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "panel_widget_set_icon")]
    fn set_icon(&self, icon: Option<&impl IsA<gio::Icon>>);

    #[doc(alias = "panel_widget_set_icon_name")]
    fn set_icon_name(&self, icon_name: Option<&str>);

    #[doc(alias = "panel_widget_set_kind")]
    fn set_kind(&self, kind: Option<&str>);

    #[doc(alias = "panel_widget_set_menu_model")]
    fn set_menu_model(&self, menu_model: Option<&impl IsA<gio::MenuModel>>);

    #[doc(alias = "panel_widget_set_modified")]
    fn set_modified(&self, modified: bool);

    #[doc(alias = "panel_widget_set_needs_attention")]
    fn set_needs_attention(&self, needs_attention: bool);

    #[doc(alias = "panel_widget_set_reorderable")]
    fn set_reorderable(&self, reorderable: bool);

    #[doc(alias = "panel_widget_set_save_delegate")]
    fn set_save_delegate(&self, save_delegate: Option<&impl IsA<SaveDelegate>>);

    #[doc(alias = "panel_widget_set_title")]
    fn set_title(&self, title: Option<&str>);

    #[doc(alias = "panel_widget_unmark_busy")]
    fn unmark_busy(&self);

    #[doc(alias = "panel_widget_unmaximize")]
    fn unmaximize(&self);

    #[doc(alias = "get-default-focus")]
    fn connect_get_default_focus<F: Fn(&Self) -> Option<gtk::Widget> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "background-rgba")]
    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "busy")]
    fn connect_busy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-maximize")]
    fn connect_can_maximize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child")]
    fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-rgba")]
    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon")]
    fn connect_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "icon-name")]
    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "kind")]
    fn connect_kind_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "menu-model")]
    fn connect_menu_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "modified")]
    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "needs-attention")]
    fn connect_needs_attention_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "reorderable")]
    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "save-delegate")]
    fn connect_save_delegate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Widget>> WidgetExt for O {
    fn focus_default(&self) -> bool {
        unsafe {
            from_glib(ffi::panel_widget_focus_default(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn background_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_background_rgba(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_busy(&self) -> bool {
        unsafe { from_glib(ffi::panel_widget_get_busy(self.as_ref().to_glib_none().0)) }
    }

    fn can_maximize(&self) -> bool {
        unsafe {
            from_glib(ffi::panel_widget_get_can_maximize(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn child(&self) -> Option<gtk::Widget> {
        unsafe { from_glib_none(ffi::panel_widget_get_child(self.as_ref().to_glib_none().0)) }
    }

    fn default_focus(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_default_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn foreground_rgba(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_foreground_rgba(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn icon(&self) -> Option<gio::Icon> {
        unsafe { from_glib_none(ffi::panel_widget_get_icon(self.as_ref().to_glib_none().0)) }
    }

    fn icon_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_icon_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn kind(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::panel_widget_get_kind(self.as_ref().to_glib_none().0)) }
    }

    fn menu_model(&self) -> Option<gio::MenuModel> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_menu_model(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_modified(&self) -> bool {
        unsafe {
            from_glib(ffi::panel_widget_get_modified(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn needs_attention(&self) -> bool {
        unsafe {
            from_glib(ffi::panel_widget_get_needs_attention(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_reorderable(&self) -> bool {
        unsafe {
            from_glib(ffi::panel_widget_get_reorderable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn save_delegate(&self) -> Option<SaveDelegate> {
        unsafe {
            from_glib_none(ffi::panel_widget_get_save_delegate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::panel_widget_get_title(self.as_ref().to_glib_none().0)) }
    }

    fn mark_busy(&self) {
        unsafe {
            ffi::panel_widget_mark_busy(self.as_ref().to_glib_none().0);
        }
    }

    fn maximize(&self) {
        unsafe {
            ffi::panel_widget_maximize(self.as_ref().to_glib_none().0);
        }
    }

    fn raise(&self) {
        unsafe {
            ffi::panel_widget_raise(self.as_ref().to_glib_none().0);
        }
    }

    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        unsafe {
            ffi::panel_widget_set_background_rgba(
                self.as_ref().to_glib_none().0,
                background_rgba.to_glib_none().0,
            );
        }
    }

    fn set_can_maximize(&self, can_maximize: bool) {
        unsafe {
            ffi::panel_widget_set_can_maximize(
                self.as_ref().to_glib_none().0,
                can_maximize.into_glib(),
            );
        }
    }

    fn set_child(&self, child: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::panel_widget_set_child(
                self.as_ref().to_glib_none().0,
                child.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        unsafe {
            ffi::panel_widget_set_foreground_rgba(
                self.as_ref().to_glib_none().0,
                foreground_rgba.to_glib_none().0,
            );
        }
    }

    fn set_icon(&self, icon: Option<&impl IsA<gio::Icon>>) {
        unsafe {
            ffi::panel_widget_set_icon(
                self.as_ref().to_glib_none().0,
                icon.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_icon_name(&self, icon_name: Option<&str>) {
        unsafe {
            ffi::panel_widget_set_icon_name(
                self.as_ref().to_glib_none().0,
                icon_name.to_glib_none().0,
            );
        }
    }

    fn set_kind(&self, kind: Option<&str>) {
        unsafe {
            ffi::panel_widget_set_kind(self.as_ref().to_glib_none().0, kind.to_glib_none().0);
        }
    }

    fn set_menu_model(&self, menu_model: Option<&impl IsA<gio::MenuModel>>) {
        unsafe {
            ffi::panel_widget_set_menu_model(
                self.as_ref().to_glib_none().0,
                menu_model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_modified(&self, modified: bool) {
        unsafe {
            ffi::panel_widget_set_modified(self.as_ref().to_glib_none().0, modified.into_glib());
        }
    }

    fn set_needs_attention(&self, needs_attention: bool) {
        unsafe {
            ffi::panel_widget_set_needs_attention(
                self.as_ref().to_glib_none().0,
                needs_attention.into_glib(),
            );
        }
    }

    fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::panel_widget_set_reorderable(
                self.as_ref().to_glib_none().0,
                reorderable.into_glib(),
            );
        }
    }

    fn set_save_delegate(&self, save_delegate: Option<&impl IsA<SaveDelegate>>) {
        unsafe {
            ffi::panel_widget_set_save_delegate(
                self.as_ref().to_glib_none().0,
                save_delegate.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_title(&self, title: Option<&str>) {
        unsafe {
            ffi::panel_widget_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn unmark_busy(&self) {
        unsafe {
            ffi::panel_widget_unmark_busy(self.as_ref().to_glib_none().0);
        }
    }

    fn unmaximize(&self) {
        unsafe {
            ffi::panel_widget_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    fn connect_get_default_focus<F: Fn(&Self) -> Option<gtk::Widget> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn get_default_focus_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) -> Option<gtk::Widget> + 'static,
        >(
            this: *mut ffi::PanelWidget,
            f: glib::ffi::gpointer,
        ) -> *mut gtk::ffi::GtkWidget {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref()) /*Not checked*/
                .to_glib_none()
                .0
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"get-default-focus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    get_default_focus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_busy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_busy_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::busy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_busy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_maximize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_maximize_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-maximize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_maximize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_kind_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_kind_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::kind\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_kind_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_menu_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_menu_model_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::menu-model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_menu_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modified_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modified\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_modified_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_needs_attention_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_needs_attention_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::needs-attention\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_needs_attention_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::reorderable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_save_delegate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_save_delegate_trampoline<
            P: IsA<Widget>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::save-delegate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_save_delegate_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<Widget>, F: Fn(&P) + 'static>(
            this: *mut ffi::PanelWidget,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Widget::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Widget {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Widget")
    }
}
