//! common utilities for several examples.

#![allow(dead_code)]

mod canvas;
pub use canvas::Canvas;

mod counter;
pub use counter::Counter;

mod synth;
pub use synth::Synth;

// WIP
pub mod game_loop;

// mod ui;
// pub use ui::*;

// mod service_thread;
// pub use service_thread::ServiceThread;

/// WIP macro
/// (not sure this will work)
///
/// INTENTION: replace:
/// ```
/// #[cfg(not(any(test, doc)))]
/// use libnotcurses_sys::*;
/// #[cfg(any(test,doc))]
/// use crate::*;
/// ```
///
///
// CHECK: why this is not exported in the docs
#[macro_export]
#[doc(hidden)]
macro_rules! use_libnotcurses_sys {
    ($($i:ident),*) => {
        #[cfg(any(test, doc))]
        use crate::$i;
        #[cfg(not(any(test, doc)))]
        use libnotcurses_sys::$i;

        //     #[doc = concat!("Enables the [`", stringify!($type), "`] associated methods and constants.")]
        //     pub trait $trait {
        //         $($i)*
        //     }
        //
        // impl $trait for $type {
        //     $($i)*
        // }
    };
}
