#![cfg_attr(feature = "unstable", feature(allocator_api))]
#![cfg_attr(not(test), no_std)]
#[cfg(test)]
mod tests {
    pub mod test_utils {

        use std::io::Read;
use std::fs::File;

pub fn get_test_file_path(file_name: &str) -> String {
            let mut path = String::from(env!("CARGO_MANIFEST_DIR"));
            path.push_str("/tests/");
            path.push_str(file_name);
            path
        }

        pub fn get_test_file_content(file_name: &str) -> String {
            let mut file = File::open(get_test_file_path(file_name)).unwrap();
            let mut content = String::new();
            file.read_to_string(&mut content).unwrap();
            content
        }
    }
}