<div align="center">
<h1>libmacchina</h1>

Provides the fetching capabilities for [macchina](https://github.com/Macchina-CLI/macchina)

Linux • macOS • Windows • NetBSD • Android • OpenWrt

<img src="screenshots/preview.png" alt="Preview" />

<a href="https://crates.io/crates/libmacchina">
    <img src="https://img.shields.io/crates/v/libmacchina" alt="Version" />
</a>

<a href="https://docs.rs/crate/libmacchina/">
    <img src="https://docs.rs/libmacchina/badge.svg" alt="Docs" />
</a>

</div>

---

This library provides the fetching capabilities for [macchina](https://github.com/Macchina-CLI/macchina), a fast, minimal and customizable system information fetching program, written in Rust 🦀.

The information you see in the image above, was fetched by this library.

# 💬 Tell me more!

Through this library, you can access a variety of system information, such as:
- Host
  - Username
  - Hostname
- Product
  - Family
  - Name
  - Model
  - Version
- Kernel
  - Type
  - Version
- Distribution
- Operating System
- Desktop Environment
- Window Manager
- Package Count
- Shell
- Terminal
- Processor
  - Model
  - Thread count
- Processor Usage
- Local IP Address
- Uptime
- Memory Usage
  - Used
  - Total
- Battery
  - Percentage
  - Status
  - Health (Linux)
- Palette

# 💻 Platform Support

|  Platform |      Support       |
| :-:       |        :-:         |
| GNU/Linux |        Yes         |
| NetBSD    |        Yes         |
| macOS     |        Yes         |
| Windows   |        80%         |
| OpenWrt   |        Yes         |
| Android   |        Yes         |
