/* automatically generated by rust-bindgen 0.56.0 */
#![allow(non_camel_case_types)]

pub const LBFGS_FLOAT: u32 = 64;
pub const LBFGS_IEEE_FLOAT: u32 = 1;
pub type lbfgsfloatval_t = f64;
#[doc = " L-BFGS reaches convergence."]
pub const LBFGS_SUCCESS: ::std::os::raw::c_int = 0;
#[doc = " L-BFGS reaches convergence."]
pub const LBFGS_CONVERGENCE: ::std::os::raw::c_int = 0;
#[doc = " L-BFGS reaches convergence."]
pub const LBFGS_STOP: ::std::os::raw::c_int = 1;
#[doc = " The initial variables already minimize the objective function."]
pub const LBFGS_ALREADY_MINIMIZED: ::std::os::raw::c_int = 2;
#[doc = " Unknown error."]
pub const LBFGSERR_UNKNOWNERROR: ::std::os::raw::c_int = -1024;
#[doc = " Logic error."]
pub const LBFGSERR_LOGICERROR: ::std::os::raw::c_int = -1023;
#[doc = " Insufficient memory."]
pub const LBFGSERR_OUTOFMEMORY: ::std::os::raw::c_int = -1022;
#[doc = " The minimization process has been canceled."]
pub const LBFGSERR_CANCELED: ::std::os::raw::c_int = -1021;
#[doc = " Invalid number of variables specified."]
pub const LBFGSERR_INVALID_N: ::std::os::raw::c_int = -1020;
#[doc = " Invalid number of variables (for SSE) specified."]
pub const LBFGSERR_INVALID_N_SSE: ::std::os::raw::c_int = -1019;
#[doc = " The array x must be aligned to 16 (for SSE)."]
pub const LBFGSERR_INVALID_X_SSE: ::std::os::raw::c_int = -1018;
#[doc = " Invalid parameter lbfgs_parameter_t::epsilon specified."]
pub const LBFGSERR_INVALID_EPSILON: ::std::os::raw::c_int = -1017;
#[doc = " Invalid parameter lbfgs_parameter_t::past specified."]
pub const LBFGSERR_INVALID_TESTPERIOD: ::std::os::raw::c_int = -1016;
#[doc = " Invalid parameter lbfgs_parameter_t::delta specified."]
pub const LBFGSERR_INVALID_DELTA: ::std::os::raw::c_int = -1015;
#[doc = " Invalid parameter lbfgs_parameter_t::linesearch specified."]
pub const LBFGSERR_INVALID_LINESEARCH: ::std::os::raw::c_int = -1014;
#[doc = " Invalid parameter lbfgs_parameter_t::max_step specified."]
pub const LBFGSERR_INVALID_MINSTEP: ::std::os::raw::c_int = -1013;
#[doc = " Invalid parameter lbfgs_parameter_t::max_step specified."]
pub const LBFGSERR_INVALID_MAXSTEP: ::std::os::raw::c_int = -1012;
#[doc = " Invalid parameter lbfgs_parameter_t::ftol specified."]
pub const LBFGSERR_INVALID_FTOL: ::std::os::raw::c_int = -1011;
#[doc = " Invalid parameter lbfgs_parameter_t::wolfe specified."]
pub const LBFGSERR_INVALID_WOLFE: ::std::os::raw::c_int = -1010;
#[doc = " Invalid parameter lbfgs_parameter_t::gtol specified."]
pub const LBFGSERR_INVALID_GTOL: ::std::os::raw::c_int = -1009;
#[doc = " Invalid parameter lbfgs_parameter_t::xtol specified."]
pub const LBFGSERR_INVALID_XTOL: ::std::os::raw::c_int = -1008;
#[doc = " Invalid parameter lbfgs_parameter_t::max_linesearch specified."]
pub const LBFGSERR_INVALID_MAXLINESEARCH: ::std::os::raw::c_int = -1007;
#[doc = " Invalid parameter lbfgs_parameter_t::orthantwise_c specified."]
pub const LBFGSERR_INVALID_ORTHANTWISE: ::std::os::raw::c_int = -1006;
#[doc = " Invalid parameter lbfgs_parameter_t::orthantwise_start specified."]
pub const LBFGSERR_INVALID_ORTHANTWISE_START: ::std::os::raw::c_int = -1005;
#[doc = " Invalid parameter lbfgs_parameter_t::orthantwise_end specified."]
pub const LBFGSERR_INVALID_ORTHANTWISE_END: ::std::os::raw::c_int = -1004;
#[doc = " The line-search step went out of the interval of uncertainty."]
pub const LBFGSERR_OUTOFINTERVAL: ::std::os::raw::c_int = -1003;
#[doc = " A logic error occurred; alternatively, the interval of uncertainty"]
#[doc = "became too small."]
pub const LBFGSERR_INCORRECT_TMINMAX: ::std::os::raw::c_int = -1002;
#[doc = " A rounding error occurred; alternatively, no line-search step"]
#[doc = "satisfies the sufficient decrease and curvature conditions."]
pub const LBFGSERR_ROUNDING_ERROR: ::std::os::raw::c_int = -1001;
#[doc = " The line-search step became smaller than lbfgs_parameter_t::min_step."]
pub const LBFGSERR_MINIMUMSTEP: ::std::os::raw::c_int = -1000;
#[doc = " The line-search step became larger than lbfgs_parameter_t::max_step."]
pub const LBFGSERR_MAXIMUMSTEP: ::std::os::raw::c_int = -999;
#[doc = " The line-search routine reaches the maximum number of evaluations."]
pub const LBFGSERR_MAXIMUMLINESEARCH: ::std::os::raw::c_int = -998;
#[doc = " The algorithm routine reaches the maximum number of iterations."]
pub const LBFGSERR_MAXIMUMITERATION: ::std::os::raw::c_int = -997;
#[doc = " Relative width of the interval of uncertainty is at most"]
#[doc = "lbfgs_parameter_t::xtol."]
pub const LBFGSERR_WIDTHTOOSMALL: ::std::os::raw::c_int = -996;
#[doc = " A logic error (negative line-search step) occurred."]
pub const LBFGSERR_INVALIDPARAMETERS: ::std::os::raw::c_int = -995;
#[doc = " The current search direction increases the objective function value."]
pub const LBFGSERR_INCREASEGRADIENT: ::std::os::raw::c_int = -994;
#[doc = " Return values of lbfgs()."]
#[doc = ""]
#[doc = "  Roughly speaking, a negative value indicates an error."]
pub type _bindgen_ty_1 = ::std::os::raw::c_int;
#[doc = " The default algorithm (MoreThuente method)."]
pub const LBFGS_LINESEARCH_DEFAULT: ::std::os::raw::c_uint = 0;
#[doc = " MoreThuente method proposd by More and Thuente."]
pub const LBFGS_LINESEARCH_MORETHUENTE: ::std::os::raw::c_uint = 0;
#[doc = " Backtracking method with the Armijo condition."]
#[doc = "  The backtracking method finds the step length such that it satisfies"]
#[doc = "  the sufficient decrease (Armijo) condition,"]
#[doc = "    - f(x + a * d) <= f(x) + lbfgs_parameter_t::ftol * a * g(x)^T d,"]
#[doc = ""]
#[doc = "  where x is the current point, d is the current search direction, and"]
#[doc = "  a is the step length."]
pub const LBFGS_LINESEARCH_BACKTRACKING_ARMIJO: ::std::os::raw::c_uint = 1;
#[doc = " The backtracking method with the defualt (regular Wolfe) condition."]
pub const LBFGS_LINESEARCH_BACKTRACKING: ::std::os::raw::c_uint = 2;
#[doc = " Backtracking method with regular Wolfe condition."]
#[doc = "  The backtracking method finds the step length such that it satisfies"]
#[doc = "  both the Armijo condition (LBFGS_LINESEARCH_BACKTRACKING_ARMIJO)"]
#[doc = "  and the curvature condition,"]
#[doc = "    - g(x + a * d)^T d >= lbfgs_parameter_t::wolfe * g(x)^T d,"]
#[doc = ""]
#[doc = "  where x is the current point, d is the current search direction, and"]
#[doc = "  a is the step length."]
pub const LBFGS_LINESEARCH_BACKTRACKING_WOLFE: ::std::os::raw::c_uint = 2;
#[doc = " Backtracking method with strong Wolfe condition."]
#[doc = "  The backtracking method finds the step length such that it satisfies"]
#[doc = "  both the Armijo condition (LBFGS_LINESEARCH_BACKTRACKING_ARMIJO)"]
#[doc = "  and the following condition,"]
#[doc = "    - |g(x + a * d)^T d| <= lbfgs_parameter_t::wolfe * |g(x)^T d|,"]
#[doc = ""]
#[doc = "  where x is the current point, d is the current search direction, and"]
#[doc = "  a is the step length."]
pub const LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE: ::std::os::raw::c_uint = 3;
#[doc = " Line search algorithms."]
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[doc = " L-BFGS optimization parameters."]
#[doc = "  Call lbfgs_parameter_init() function to initialize parameters to the"]
#[doc = "  default values."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lbfgs_parameter_t {
    #[doc = " The number of corrections to approximate the inverse hessian matrix."]
    #[doc = "  The L-BFGS routine stores the computation results of previous \\ref m"]
    #[doc = "  iterations to approximate the inverse hessian matrix of the current"]
    #[doc = "  iteration. This parameter controls the size of the limited memories"]
    #[doc = "  (corrections). The default value is \\c 6. Values less than \\c 3 are"]
    #[doc = "  not recommended. Large values will result in excessive computing time."]
    pub m: ::std::os::raw::c_int,
    #[doc = " Epsilon for convergence test."]
    #[doc = "  This parameter determines the accuracy with which the solution is to"]
    #[doc = "  be found. A minimization terminates when"]
    #[doc = "      ||g|| < \\ref epsilon * max(1, ||x||),"]
    #[doc = "  where ||.|| denotes the Euclidean (L2) norm. The default value is"]
    #[doc = "  \\c 1e-5."]
    pub epsilon: lbfgsfloatval_t,
    #[doc = " Distance for delta-based convergence test."]
    #[doc = "  This parameter determines the distance, in iterations, to compute"]
    #[doc = "  the rate of decrease of the objective function. If the value of this"]
    #[doc = "  parameter is zero, the library does not perform the delta-based"]
    #[doc = "  convergence test. The default value is \\c 0."]
    pub past: ::std::os::raw::c_int,
    #[doc = " Delta for convergence test."]
    #[doc = "  This parameter determines the minimum rate of decrease of the"]
    #[doc = "  objective function. The library stops iterations when the"]
    #[doc = "  following condition is met:"]
    #[doc = "      (f' - f) / f < \\ref delta,"]
    #[doc = "  where f' is the objective value of \\ref past iterations ago, and f is"]
    #[doc = "  the objective value of the current iteration."]
    #[doc = "  The default value is \\c 1e-5."]
    pub delta: lbfgsfloatval_t,
    #[doc = " The maximum number of iterations."]
    #[doc = "  The lbfgs() function terminates an optimization process with"]
    #[doc = "  ::LBFGSERR_MAXIMUMITERATION status code when the iteration count"]
    #[doc = "  exceedes this parameter. Setting this parameter to zero continues an"]
    #[doc = "  optimization process until a convergence or error. The default value"]
    #[doc = "  is \\c 0."]
    pub max_iterations: ::std::os::raw::c_int,
    #[doc = " The line search algorithm."]
    #[doc = "  This parameter specifies a line search algorithm to be used by the"]
    #[doc = "  L-BFGS routine."]
    pub linesearch: ::std::os::raw::c_int,
    #[doc = " The maximum number of trials for the line search."]
    #[doc = "  This parameter controls the number of function and gradients evaluations"]
    #[doc = "  per iteration for the line search routine. The default value is \\c 40."]
    pub max_linesearch: ::std::os::raw::c_int,
    #[doc = " The minimum step of the line search routine."]
    #[doc = "  The default value is \\c 1e-20. This value need not be modified unless"]
    #[doc = "  the exponents are too large for the machine being used, or unless the"]
    #[doc = "  problem is extremely badly scaled (in which case the exponents should"]
    #[doc = "  be increased)."]
    pub min_step: lbfgsfloatval_t,
    #[doc = " The maximum step of the line search."]
    #[doc = "  The default value is \\c 1e+20. This value need not be modified unless"]
    #[doc = "  the exponents are too large for the machine being used, or unless the"]
    #[doc = "  problem is extremely badly scaled (in which case the exponents should"]
    #[doc = "  be increased)."]
    pub max_step: lbfgsfloatval_t,
    #[doc = " A parameter to control the accuracy of the line search routine."]
    #[doc = "  The default value is \\c 1e-4. This parameter should be greater"]
    #[doc = "  than zero and smaller than \\c 0.5."]
    pub ftol: lbfgsfloatval_t,
    #[doc = " A coefficient for the Wolfe condition."]
    #[doc = "  This parameter is valid only when the backtracking line-search"]
    #[doc = "  algorithm is used with the Wolfe condition,"]
    #[doc = "  ::LBFGS_LINESEARCH_BACKTRACKING_STRONG_WOLFE or"]
    #[doc = "  ::LBFGS_LINESEARCH_BACKTRACKING_WOLFE ."]
    #[doc = "  The default value is \\c 0.9. This parameter should be greater"]
    #[doc = "  the \\ref ftol parameter and smaller than \\c 1.0."]
    pub wolfe: lbfgsfloatval_t,
    #[doc = " A parameter to control the accuracy of the line search routine."]
    #[doc = "  The default value is \\c 0.9. If the function and gradient"]
    #[doc = "  evaluations are inexpensive with respect to the cost of the"]
    #[doc = "  iteration (which is sometimes the case when solving very large"]
    #[doc = "  problems) it may be advantageous to set this parameter to a small"]
    #[doc = "  value. A typical small value is \\c 0.1. This parameter shuold be"]
    #[doc = "  greater than the \\ref ftol parameter (\\c 1e-4) and smaller than"]
    #[doc = "  \\c 1.0."]
    pub gtol: lbfgsfloatval_t,
    #[doc = " The machine precision for floating-point values."]
    #[doc = "  This parameter must be a positive value set by a client program to"]
    #[doc = "  estimate the machine precision. The line search routine will terminate"]
    #[doc = "  with the status code (::LBFGSERR_ROUNDING_ERROR) if the relative width"]
    #[doc = "  of the interval of uncertainty is less than this parameter."]
    pub xtol: lbfgsfloatval_t,
    #[doc = " Coeefficient for the L1 norm of variables."]
    #[doc = "  This parameter should be set to zero for standard minimization"]
    #[doc = "  problems. Setting this parameter to a positive value activates"]
    #[doc = "  Orthant-Wise Limited-memory Quasi-Newton (OWL-QN) method, which"]
    #[doc = "  minimizes the objective function F(x) combined with the L1 norm |x|"]
    #[doc = "  of the variables, {F(x) + C |x|}. This parameter is the coeefficient"]
    #[doc = "  for the |x|, i.e., C. As the L1 norm |x| is not differentiable at"]
    #[doc = "  zero, the library modifies function and gradient evaluations from"]
    #[doc = "  a client program suitably; a client program thus have only to return"]
    #[doc = "  the function value F(x) and gradients G(x) as usual. The default value"]
    #[doc = "  is zero."]
    pub orthantwise_c: lbfgsfloatval_t,
    #[doc = " Start index for computing L1 norm of the variables."]
    #[doc = "  This parameter is valid only for OWL-QN method"]
    #[doc = "  (i.e., \\ref orthantwise_c != 0). This parameter b (0 <= b < N)"]
    #[doc = "  specifies the index number from which the library computes the"]
    #[doc = "  L1 norm of the variables x,"]
    #[doc = "      |x| := |x_{b}| + |x_{b+1}| + ... + |x_{N}| ."]
    #[doc = "  In other words, variables x_1, ..., x_{b-1} are not used for"]
    #[doc = "  computing the L1 norm. Setting b (0 < b < N), one can protect"]
    #[doc = "  variables, x_1, ..., x_{b-1} (e.g., a bias term of logistic"]
    #[doc = "  regression) from being regularized. The default value is zero."]
    pub orthantwise_start: ::std::os::raw::c_int,
    #[doc = " End index for computing L1 norm of the variables."]
    #[doc = "  This parameter is valid only for OWL-QN method"]
    #[doc = "  (i.e., \\ref orthantwise_c != 0). This parameter e (0 < e <= N)"]
    #[doc = "  specifies the index number at which the library stops computing the"]
    #[doc = "  L1 norm of the variables x,"]
    pub orthantwise_end: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_lbfgs_parameter_t() {
    assert_eq!(
        ::std::mem::size_of::<lbfgs_parameter_t>(),
        112usize,
        concat!("Size of: ", stringify!(lbfgs_parameter_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lbfgs_parameter_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lbfgs_parameter_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).m as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(m)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).epsilon as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(epsilon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).past as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(past)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).delta as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(delta)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lbfgs_parameter_t>())).max_iterations as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(max_iterations)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).linesearch as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(linesearch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lbfgs_parameter_t>())).max_linesearch as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(max_linesearch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).min_step as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(min_step)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).max_step as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(max_step)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).ftol as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(ftol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).wolfe as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(wolfe)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).gtol as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(gtol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).xtol as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(xtol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lbfgs_parameter_t>())).orthantwise_c as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(orthantwise_c)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lbfgs_parameter_t>())).orthantwise_start as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(orthantwise_start)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<lbfgs_parameter_t>())).orthantwise_end as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(lbfgs_parameter_t),
            "::",
            stringify!(orthantwise_end)
        )
    );
}
#[doc = " Callback interface to provide objective function and gradient evaluations."]
#[doc = ""]
#[doc = "  The lbfgs() function call this function to obtain the values of objective"]
#[doc = "  function and its gradients when needed. A client program must implement"]
#[doc = "  this function to evaluate the values of the objective function and its"]
#[doc = "  gradients, given current values of variables."]
#[doc = ""]
#[doc = "  @param  instance    The user data sent for lbfgs() function by the client."]
#[doc = "  @param  x           The current values of variables."]
#[doc = "  @param  g           The gradient vector. The callback function must compute"]
#[doc = "                      the gradient values for the current variables."]
#[doc = "  @param  n           The number of variables."]
#[doc = "  @param  step        The current step of the line search routine."]
#[doc = "  @retval lbfgsfloatval_t The value of the objective function for the current"]
#[doc = "                          variables."]
pub type lbfgs_evaluate_t = ::std::option::Option<
    unsafe extern "C" fn(
        instance: *mut ::std::os::raw::c_void,
        x: *const lbfgsfloatval_t,
        g: *mut lbfgsfloatval_t,
        n: ::std::os::raw::c_int,
        step: lbfgsfloatval_t,
    ) -> lbfgsfloatval_t,
>;
#[doc = " Callback interface to receive the progress of the optimization process."]
#[doc = ""]
#[doc = "  The lbfgs() function call this function for each iteration. Implementing"]
#[doc = "  this function, a client program can store or display the current progress"]
#[doc = "  of the optimization process."]
#[doc = ""]
#[doc = "  @param  instance    The user data sent for lbfgs() function by the client."]
#[doc = "  @param  x           The current values of variables."]
#[doc = "  @param  g           The current gradient values of variables."]
#[doc = "  @param  fx          The current value of the objective function."]
#[doc = "  @param  xnorm       The Euclidean norm of the variables."]
#[doc = "  @param  gnorm       The Euclidean norm of the gradients."]
#[doc = "  @param  step        The line-search step used for this iteration."]
#[doc = "  @param  n           The number of variables."]
#[doc = "  @param  k           The iteration count."]
#[doc = "  @param  ls          The number of evaluations called for this iteration."]
#[doc = "  @retval int         Zero to continue the optimization process. Returning a"]
#[doc = "                      non-zero value will cancel the optimization process."]
pub type lbfgs_progress_t = ::std::option::Option<
    unsafe extern "C" fn(
        instance: *mut ::std::os::raw::c_void,
        x: *const lbfgsfloatval_t,
        g: *const lbfgsfloatval_t,
        fx: lbfgsfloatval_t,
        xnorm: lbfgsfloatval_t,
        gnorm: lbfgsfloatval_t,
        step: lbfgsfloatval_t,
        n: ::std::os::raw::c_int,
        k: ::std::os::raw::c_int,
        ls: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    #[doc = " Start a L-BFGS optimization."]
    #[doc = ""]
    #[doc = "  @param  n           The number of variables."]
    #[doc = "  @param  x           The array of variables. A client program can set"]
    #[doc = "                      default values for the optimization and receive the"]
    #[doc = "                      optimization result through this array. This array"]
    #[doc = "                      must be allocated by ::lbfgs_malloc function"]
    #[doc = "                      for libLBFGS built with SSE/SSE2 optimization routine"]
    #[doc = "                      enabled. The library built without SSE/SSE2"]
    #[doc = "                      optimization does not have such a requirement."]
    #[doc = "  @param  ptr_fx      The pointer to the variable that receives the final"]
    #[doc = "                      value of the objective function for the variables."]
    #[doc = "                      This argument can be set to \\c NULL if the final"]
    #[doc = "                      value of the objective function is unnecessary."]
    #[doc = "  @param  proc_evaluate   The callback function to provide function and"]
    #[doc = "                          gradient evaluations given a current values of"]
    #[doc = "                          variables. A client program must implement a"]
    #[doc = "                          callback function compatible with \\ref"]
    #[doc = "                          lbfgs_evaluate_t and pass the pointer to the"]
    #[doc = "                          callback function."]
    #[doc = "  @param  proc_progress   The callback function to receive the progress"]
    #[doc = "                          (the number of iterations, the current value of"]
    #[doc = "                          the objective function) of the minimization"]
    #[doc = "                          process. This argument can be set to \\c NULL if"]
    #[doc = "                          a progress report is unnecessary."]
    #[doc = "  @param  instance    A user data for the client program. The callback"]
    #[doc = "                      functions will receive the value of this argument."]
    #[doc = "  @param  param       The pointer to a structure representing parameters for"]
    #[doc = "                      L-BFGS optimization. A client program can set this"]
    #[doc = "                      parameter to \\c NULL to use the default parameters."]
    #[doc = "                      Call lbfgs_parameter_init() function to fill a"]
    #[doc = "                      structure with the default values."]
    #[doc = "  @retval int         The status code. This function returns zero if the"]
    #[doc = "                      minimization process terminates without an error. A"]
    #[doc = "                      non-zero value indicates an error."]
    pub fn lbfgs(
        n: ::std::os::raw::c_int,
        x: *mut lbfgsfloatval_t,
        ptr_fx: *mut lbfgsfloatval_t,
        proc_evaluate: lbfgs_evaluate_t,
        proc_progress: lbfgs_progress_t,
        instance: *mut ::std::os::raw::c_void,
        param: *mut lbfgs_parameter_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Initialize L-BFGS parameters to the default values."]
    #[doc = ""]
    #[doc = "  Call this function to fill a parameter structure with the default values"]
    #[doc = "  and overwrite parameter values if necessary."]
    #[doc = ""]
    #[doc = "  @param  param       The pointer to the parameter structure."]
    pub fn lbfgs_parameter_init(param: *mut lbfgs_parameter_t);
}
extern "C" {
    #[doc = " Allocate an array for variables."]
    #[doc = ""]
    #[doc = "  This function allocates an array of variables for the convenience of"]
    #[doc = "  ::lbfgs function; the function has a requreiemt for a variable array"]
    #[doc = "  when libLBFGS is built with SSE/SSE2 optimization routines. A user does"]
    #[doc = "  not have to use this function for libLBFGS built without SSE/SSE2"]
    #[doc = "  optimization."]
    #[doc = ""]
    #[doc = "  @param  n           The number of variables."]
    pub fn lbfgs_malloc(n: ::std::os::raw::c_int) -> *mut lbfgsfloatval_t;
}
extern "C" {
    #[doc = " Free an array of variables."]
    #[doc = ""]
    #[doc = "  @param  x           The array of variables allocated by ::lbfgs_malloc"]
    #[doc = "                      function."]
    pub fn lbfgs_free(x: *mut lbfgsfloatval_t);
}
extern "C" {
    #[doc = " Get string description of an lbfgs() return code."]
    #[doc = ""]
    #[doc = "  @param err          A value returned by lbfgs()."]
    pub fn lbfgs_strerror(err: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
