// Copyright (C) 2021 Paolo Jovon <paolo.jovon@gmail.com>
// SPDX-License-Identifier: Apache-2.0

//! A low-level Rust wrapper over [KhronosGroup/KTX-Software](https://github.com/KhronosGroup/KTX-Software),
//! a library for reading, transcoding and writing [Khronos Textures (KTX)](https://www.khronos.org/ktx/).
//!
//! You very likely want to use the high-level wrapper, [`libktx_rs`] instead of this crate!

#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(deref_nullptr)] // (for the tests generated by bindgen)

#[cfg(feature = "run-bindgen")]
include!(concat!(env!("OUT_DIR"), "/bindings.rs"));
#[cfg(not(feature = "run-bindgen"))]
include!("ffi.rs");

pub type ktxStream__data = ktxStream__bindgen_ty_1;
pub type ktxStream__custom_ptr = __BindgenUnionField<ktxStream__bindgen_ty_1__bindgen_ty_1>;
