# [UNMAINTAINED] libkrb5 bindings for Rust

This crate is no longer actively maintained. API coverage is very limited, and
I no longer have a use case that requires me to develop it further.  While it
should be relatively straightforward to add wrappers for more FFI calls by
following the patterns already established in this crate, I have no plans to do
so.

If you need libkrb5 bindings in Rust, I recommend to look at the other crates
which provide this functionality, or investigate whether using something like
GSSAPI bindings directly would actually be a better fit for your needs.

Nevertheless, if somebody really wants to take over maintenance of the libkrb5
and libkrb5-sys crates, feel free to reach out.

---

This repository contains both work-in-progress safe, idiomatic Rust bindings for
`libkrb5`, the client library of [MIT Kerberos 5][krb5], and the underlying
"unsafe" bindings generated by `bindgen` in `libkrb5-sys`.

[krb5]: https://web.mit.edu/kerberos/

## Thread-safety

According to the libkrb5 documentation, MIT Kerberos 5 is [thread-safe] as of
version 1.4, with the exception of context initialization and de-initialization
functions, which are expected to not run concurrently on different threads.
For this reason, calls to the `krb5_init_context` and `krb5_init_secure_context`
functions as well as `krb5_free_contex` are synchronized by a global Mutex.

**NOTE**: Running this crate's test suite with LLVM's sanitizers shows errors
in some cases. AddressSanitizer and LeakSanitizer show no issues, but
MemorySanitizer makes the build fail during the build of `log` (so that's
unrelated to this crate), and ThreadSanitizer fails - apparently due to false
positives in the `lazy_static` code (according to a [closed issue][tsan]).

To my best knowledge, this library follows the documentation regarding
thread-safe usage of libkrb5 (context initialization and teardown protected
by a global Mutex), and all other functions in libkrb5 should be thread-safe.

[thread-safe]: http://web.mit.edu/Kerberos/krb5-1.4/krb5-1.4/doc/thread-safe.txt
[tsan]: https://github.com/rust-lang-nursery/lazy-static.rs/issues/83

## Contributions welcome

If you see a bug or want to expand API coverage, it should be fairly easy to
look at the existing wrapper functions and adapt that code for other `libkrb5`
APIs.

