// Copyright (c) the JPEG XL Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef TOOLS_CODEC_CONFIG_H_
#define TOOLS_CODEC_CONFIG_H_

#include <string>

namespace jpegxl {
namespace tools {

// Returns a short string describing the codec version (if known) and build
// settings such as sanitizers and SIMD targets. Used in the benchmark and
// command-line tools.
std::string CodecConfigString(uint32_t lib_version);

}  // namespace tools
}  // namespace jpegxl

#endif  // TOOLS_CODEC_CONFIG_H_
