// Copyright (c) the JPEG XL Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef LIB_JXL_ENC_GAMMA_CORRECT_H_
#define LIB_JXL_ENC_GAMMA_CORRECT_H_

// Deprecated: sRGB transfer function. Use color_management.h instead.

#include <cmath>

#include "lib/jxl/base/compiler_specific.h"
#include "lib/jxl/transfer_functions-inl.h"

namespace jxl {

// Values are in [0, 1].
static JXL_INLINE double Srgb8ToLinearDirect(double srgb) {
  if (srgb <= 0.0) return 0.0;
  if (srgb <= 0.04045) return srgb / 12.92;
  if (srgb >= 1.0) return 1.0;
  return std::pow((srgb + 0.055) / 1.055, 2.4);
}

// Values are in [0, 1].
static JXL_INLINE double LinearToSrgb8Direct(double linear) {
  if (linear <= 0.0) return 0.0;
  if (linear >= 1.0) return 1.0;
  if (linear <= 0.0031308) return linear * 12.92;
  return std::pow(linear, 1.0 / 2.4) * 1.055 - 0.055;
}

}  // namespace jxl

#endif  // LIB_JXL_ENC_GAMMA_CORRECT_H_
