// Copyright (c) the JPEG XL Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef TOOLS_COMPARISON_VIEWER_SETTINGS_H_
#define TOOLS_COMPARISON_VIEWER_SETTINGS_H_

#include <QDialog>
#include <QSettings>

#include "tools/comparison_viewer/split_image_renderer.h"
#include "tools/comparison_viewer/ui_settings.h"

namespace jxl {

class SettingsDialog : public QDialog {
  Q_OBJECT

 public:
  explicit SettingsDialog(QWidget* parent = nullptr);
  ~SettingsDialog() override = default;

  SplitImageRenderingSettings renderingSettings() const;

 private slots:
  void on_SettingsDialog_accepted();
  void on_SettingsDialog_rejected();

 private:
  void settingsToUi();

  Ui::SettingsDialog ui_;
  QSettings settings_;
  SplitImageRenderingSettings renderingSettings_;
};

}  // namespace jxl

#endif  // TOOLS_COMPARISON_VIEWER_SETTINGS_H_
