pub mod irc {

	//structure for defining irc packets
	pub struct IrcPacket {
		from: String,
		to: String,
		cmd: String,
		params: String
	}

	impl IrcPacket {

		//create a new irc packet
		pub fn new(from: String, to: String, cmd: String, params: String) -> IrcPacket {
			IrcPacket { from, to, cmd, params }
		}

		//parse an irc packet to string
		pub fn to_string(&self) -> String {
			format!(":{from}\r\n{cmd}\r\n{to}\r\n:{params}", 
					from=self.from,
					cmd=self.cmd,
					to=self.to,
					params=self.params)
		}

		//parse a string to an irc packet
		pub fn from_string(irc_string: String) -> IrcPacket {
			let parts_vec: Vec<&str> = irc_string.as_str().split("\r\n").collect();
			let mut out_ircp: IrcPacket = IrcPacket { from: String::new(), to: String::new(), cmd: String::new(), params: String::new() };
			out_ircp.from = parts_vec[0][1..].to_string();
			out_ircp.to = parts_vec[2].to_string();
			out_ircp.cmd = parts_vec[1].to_string();
			out_ircp.params = parts_vec[3][1..].to_string();
			return out_ircp;
		}
		
		pub fn copy(&self) -> IrcPacket {
			let from = self.from.as_str();
			let to = self.to.as_str();
			let cmd = self.cmd.as_str();
			let params = self.params.as_str();
			IrcPacket::new(from.to_string(), to.to_string(), cmd.to_string(), params.to_string())
		}
	}
}
