//! A highly opinionated Rust library for writing Heroku buildpacks.
//!
//! Contains common helpers and functionality that is not present in the more generic libcnb.rs library.

// Enable rustc and Clippy lints that are disabled by default.
// https://doc.rust-lang.org/rustc/lints/listing/allowed-by-default.html#unused-crate-dependencies
#![warn(unused_crate_dependencies)]
// https://rust-lang.github.io/rust-clippy/stable/index.html
#![warn(clippy::pedantic)]
// In most cases adding error docs provides little value.
#![allow(clippy::missing_errors_doc)]
// This lint is too noisy and enforces a style that reduces readability in many cases.
#![allow(clippy::module_name_repetitions)]

pub use crate::fs::*;
pub use crate::tar::*;
pub use digest::*;
pub use download::*;
pub use error::*;
pub use log::*;

mod digest;
mod download;
mod error;
mod fs;
mod log;
mod tar;

#[cfg(feature = "toml")]
pub use crate::toml::*;

#[cfg(feature = "toml")]
mod toml;
