//! A highly opinionated Rust library for writing Heroku buildpacks.
//!
//! Contains common helpers and functionality that is not present in the more generic libcnb.rs library.

// Enable rustc and Clippy lints that are disabled by default.
// https://doc.rust-lang.org/rustc/lints/listing/allowed-by-default.html#unused-crate-dependencies
#![warn(unused_crate_dependencies)]
// https://rust-lang.github.io/rust-clippy/stable/index.html
#![warn(clippy::pedantic)]
// Re-disable pedantic lints that are currently failing, until they are triaged and fixed/wontfixed.
// https://github.com/heroku/libherokubuildpack/issues/16
#![allow(clippy::doc_markdown)]
// https://github.com/heroku/libherokubuildpack/issues/13
#![allow(clippy::missing_errors_doc)]
// https://github.com/heroku/libherokubuildpack/issues/15
#![allow(clippy::missing_panics_doc)]
// https://github.com/heroku/libherokubuildpack/issues/24
#![allow(clippy::module_name_repetitions)]
// https://github.com/heroku/libherokubuildpack/issues/14
#![allow(clippy::must_use_candidate)]

pub use crate::fs::*;
pub use crate::tar::*;
pub use digest::*;
pub use download::*;
pub use error::*;
pub use log::*;

mod digest;
mod download;
mod error;
mod fs;
mod log;
mod tar;

#[cfg(feature = "toml")]
pub use crate::toml::*;

#[cfg(feature = "toml")]
mod toml;
