/* automatically generated by rust-bindgen 0.59.2 */

pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __time_t = ::std::os::raw::c_long;
pub type time_t = __time_t;
pub type size_t = ::std::os::raw::c_ulong;
#[doc = " Some utility decls used in libhdfs."]
pub type tSize = i32;
#[doc = " size of data for read/write io ops"]
pub type tTime = time_t;
#[doc = " time type in seconds"]
pub type tOffset = i64;
#[doc = " offset within the file"]
pub type tPort = u16;
#[repr(u32)]
#[doc = " port"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tObjectKind {
    kObjectKindFile = 70,
    kObjectKindDirectory = 68,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HdfsFileSystemInternalWrapper {
    _unused: [u8; 0],
}
pub type hdfsFS = *mut HdfsFileSystemInternalWrapper;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct HdfsFileInternalWrapper {
    _unused: [u8; 0],
}
pub type hdfsFile = *mut HdfsFileInternalWrapper;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdfsBuilder {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Return error information of last failed operation."]
    #[doc = ""]
    #[doc = " @return \t\t\tA not NULL const string point of last error information."]
    #[doc = " \t\t\t\t\tCaller can only read this message and keep it unchanged. No need to free it."]
    #[doc = " \t\t\t\t\tIf last operation finished successfully, the returned message is undefined."]
    pub fn hdfsGetLastError() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Determine if a file is open for read."]
    #[doc = ""]
    #[doc = " @param file     The HDFS file"]
    #[doc = " @return         1 if the file is open for read; 0 otherwise"]
    pub fn hdfsFileIsOpenForRead(file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Determine if a file is open for write."]
    #[doc = ""]
    #[doc = " @param file     The HDFS file"]
    #[doc = " @return         1 if the file is open for write; 0 otherwise"]
    pub fn hdfsFileIsOpenForWrite(file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsConnectAsUser - Connect to a hdfs file system as a specific user"]
    #[doc = " Connect to the hdfs."]
    #[doc = " @param nn   The NameNode.  See hdfsBuilderSetNameNode for details."]
    #[doc = " @param port The port on which the server is listening."]
    #[doc = " @param user the user name (this is hadoop domain user). Or NULL is equivelant to hhdfsConnect(host, port)"]
    #[doc = " @return Returns a handle to the filesystem or NULL on error."]
    #[doc = " @deprecated Use hdfsBuilderConnect instead."]
    pub fn hdfsConnectAsUser(
        nn: *const ::std::os::raw::c_char,
        port: tPort,
        user: *const ::std::os::raw::c_char,
    ) -> hdfsFS;
}
extern "C" {
    #[doc = " hdfsConnect - Connect to a hdfs file system."]
    #[doc = " Connect to the hdfs."]
    #[doc = " @param nn   The NameNode.  See hdfsBuilderSetNameNode for details."]
    #[doc = " @param port The port on which the server is listening."]
    #[doc = " @return Returns a handle to the filesystem or NULL on error."]
    #[doc = " @deprecated Use hdfsBuilderConnect instead."]
    pub fn hdfsConnect(nn: *const ::std::os::raw::c_char, port: tPort) -> hdfsFS;
}
extern "C" {
    #[doc = " hdfsConnect - Connect to an hdfs file system."]
    #[doc = ""]
    #[doc = " Forces a new instance to be created"]
    #[doc = ""]
    #[doc = " @param nn     The NameNode.  See hdfsBuilderSetNameNode for details."]
    #[doc = " @param port   The port on which the server is listening."]
    #[doc = " @param user   The user name to use when connecting"]
    #[doc = " @return       Returns a handle to the filesystem or NULL on error."]
    #[doc = " @deprecated   Use hdfsBuilderConnect instead."]
    pub fn hdfsConnectAsUserNewInstance(
        nn: *const ::std::os::raw::c_char,
        port: tPort,
        user: *const ::std::os::raw::c_char,
    ) -> hdfsFS;
}
extern "C" {
    #[doc = " hdfsConnect - Connect to an hdfs file system."]
    #[doc = ""]
    #[doc = " Forces a new instance to be created"]
    #[doc = ""]
    #[doc = " @param nn     The NameNode.  See hdfsBuilderSetNameNode for details."]
    #[doc = " @param port   The port on which the server is listening."]
    #[doc = " @return       Returns a handle to the filesystem or NULL on error."]
    #[doc = " @deprecated   Use hdfsBuilderConnect instead."]
    pub fn hdfsConnectNewInstance(nn: *const ::std::os::raw::c_char, port: tPort) -> hdfsFS;
}
extern "C" {
    #[doc = " Connect to HDFS using the parameters defined by the builder."]
    #[doc = ""]
    #[doc = " The HDFS builder will be freed, whether or not the connection was"]
    #[doc = " successful."]
    #[doc = ""]
    #[doc = " Every successful call to hdfsBuilderConnect should be matched with a call"]
    #[doc = " to hdfsDisconnect, when the hdfsFS is no longer needed."]
    #[doc = ""]
    #[doc = " @param bld    The HDFS builder"]
    #[doc = " @return       Returns a handle to the filesystem, or NULL on error."]
    pub fn hdfsBuilderConnect(bld: *mut hdfsBuilder) -> hdfsFS;
}
extern "C" {
    #[doc = " Create an HDFS builder."]
    #[doc = ""]
    #[doc = " @return The HDFS builder, or NULL on error."]
    pub fn hdfsNewBuilder() -> *mut hdfsBuilder;
}
extern "C" {
    #[doc = " Do nothing, we always create a new instance"]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    pub fn hdfsBuilderSetForceNewInstance(bld: *mut hdfsBuilder);
}
extern "C" {
    #[doc = " Set the HDFS NameNode to connect to."]
    pub fn hdfsBuilderSetNameNode(bld: *mut hdfsBuilder, nn: *const ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " Set the port of the HDFS NameNode to connect to."]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    #[doc = " @param port The port."]
    pub fn hdfsBuilderSetNameNodePort(bld: *mut hdfsBuilder, port: tPort);
}
extern "C" {
    #[doc = " Set the username to use when connecting to the HDFS cluster."]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    #[doc = " @param userName The user name.  The string will be shallow-copied."]
    pub fn hdfsBuilderSetUserName(bld: *mut hdfsBuilder, userName: *const ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " Set the path to the Kerberos ticket cache to use when connecting to"]
    #[doc = " the HDFS cluster."]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    #[doc = " @param kerbTicketCachePath The Kerberos ticket cache path.  The string"]
    #[doc = "                            will be shallow-copied."]
    pub fn hdfsBuilderSetKerbTicketCachePath(
        bld: *mut hdfsBuilder,
        kerbTicketCachePath: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " Set the token used to authenticate"]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    #[doc = " @param token The token used to authenticate"]
    pub fn hdfsBuilderSetToken(bld: *mut hdfsBuilder, token: *const ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " Free an HDFS builder."]
    #[doc = ""]
    #[doc = " It is normally not necessary to call this function since"]
    #[doc = " hdfsBuilderConnect frees the builder."]
    #[doc = ""]
    #[doc = " @param bld The HDFS builder"]
    pub fn hdfsFreeBuilder(bld: *mut hdfsBuilder);
}
extern "C" {
    #[doc = " Set a configuration string for an HdfsBuilder."]
    #[doc = ""]
    #[doc = " @param key      The key to set."]
    #[doc = " @param val      The value, or NULL to set no value."]
    #[doc = "                 This will be shallow-copied.  You are responsible for"]
    #[doc = "                 ensuring that it remains valid until the builder is"]
    #[doc = "                 freed."]
    #[doc = ""]
    #[doc = " @return         0 on success; nonzero error code otherwise."]
    pub fn hdfsBuilderConfSetStr(
        bld: *mut hdfsBuilder,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get a configuration string."]
    #[doc = ""]
    #[doc = " @param key      The key to find"]
    #[doc = " @param val      (out param) The value.  This will be set to NULL if the"]
    #[doc = "                 key isn't found.  You must free this string with"]
    #[doc = "                 hdfsConfStrFree."]
    #[doc = ""]
    #[doc = " @return         0 on success; nonzero error code otherwise."]
    #[doc = "                 Failure to find the key is not an error."]
    pub fn hdfsConfGetStr(
        key: *const ::std::os::raw::c_char,
        val: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get a configuration integer."]
    #[doc = ""]
    #[doc = " @param key      The key to find"]
    #[doc = " @param val      (out param) The value.  This will NOT be changed if the"]
    #[doc = "                 key isn't found."]
    #[doc = ""]
    #[doc = " @return         0 on success; nonzero error code otherwise."]
    #[doc = "                 Failure to find the key is not an error."]
    pub fn hdfsConfGetInt(
        key: *const ::std::os::raw::c_char,
        val: *mut i32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Free a configuration string found with hdfsConfGetStr."]
    #[doc = ""]
    #[doc = " @param val      A configuration string obtained from hdfsConfGetStr"]
    pub fn hdfsConfStrFree(val: *mut ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " hdfsDisconnect - Disconnect from the hdfs file system."]
    #[doc = " Disconnect from hdfs."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    #[doc = "         Even if there is an error, the resources associated with the"]
    #[doc = "         hdfsFS will be freed."]
    pub fn hdfsDisconnect(fs: hdfsFS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsOpenFile - Open a hdfs file in given mode."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The full path to the file."]
    #[doc = " @param flags - an | of bits/fcntl.h file flags - supported flags are O_RDONLY, O_WRONLY (meaning create or overwrite i.e., implies O_TRUNCAT),"]
    #[doc = " O_WRONLY|O_APPEND and O_SYNC. Other flags are generally ignored other than (O_RDWR || (O_EXCL & O_CREAT)) which return NULL and set errno equal ENOTSUP."]
    #[doc = " @param bufferSize Size of buffer for read/write - pass 0 if you want"]
    #[doc = " to use the default configured values."]
    #[doc = " @param replication Block replication - pass 0 if you want to use"]
    #[doc = " the default configured values."]
    #[doc = " @param blocksize Size of block - pass 0 if you want to use the"]
    #[doc = " default configured values."]
    #[doc = " @return Returns the handle to the open file or NULL on error."]
    pub fn hdfsOpenFile(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
        bufferSize: ::std::os::raw::c_int,
        replication: ::std::os::raw::c_short,
        blocksize: tOffset,
    ) -> hdfsFile;
}
extern "C" {
    #[doc = " hdfsCloseFile - Close an open file."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    #[doc = "         On error, errno will be set appropriately."]
    #[doc = "         If the hdfs file was valid, the memory associated with it will"]
    #[doc = "         be freed at the end of this call, even if there was an I/O"]
    #[doc = "         error."]
    pub fn hdfsCloseFile(fs: hdfsFS, file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsExists - Checks if a given path exsits on the filesystem"]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path to look for"]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsExists(fs: hdfsFS, path: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsSeek - Seek to given offset in file."]
    #[doc = " This works only for files opened in read-only mode."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @param desiredPos Offset into the file to seek into."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsSeek(fs: hdfsFS, file: hdfsFile, desiredPos: tOffset) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsTell - Get the current offset in the file, in bytes."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @return Current offset, -1 on error."]
    pub fn hdfsTell(fs: hdfsFS, file: hdfsFile) -> tOffset;
}
extern "C" {
    #[doc = " hdfsRead - Read data from an open file."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @param buffer The buffer to copy read bytes into."]
    #[doc = " @param length The length of the buffer."]
    #[doc = " @return      On success, a positive number indicating how many bytes"]
    #[doc = "              were read."]
    #[doc = "              On end-of-file, 0."]
    #[doc = "              On error, -1.  Errno will be set to the error code."]
    #[doc = "              Just like the POSIX read function, hdfsRead will return -1"]
    #[doc = "              and set errno to EINTR if data is temporarily unavailable,"]
    #[doc = "              but we are not yet at the end of the file."]
    pub fn hdfsRead(
        fs: hdfsFS,
        file: hdfsFile,
        buffer: *mut ::std::os::raw::c_void,
        length: tSize,
    ) -> tSize;
}
extern "C" {
    #[doc = " hdfsWrite - Write data into an open file."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @param buffer The data."]
    #[doc = " @param length The no. of bytes to write."]
    #[doc = " @return Returns the number of bytes written, -1 on error."]
    pub fn hdfsWrite(
        fs: hdfsFS,
        file: hdfsFile,
        buffer: *const ::std::os::raw::c_void,
        length: tSize,
    ) -> tSize;
}
extern "C" {
    #[doc = " hdfsWrite - Flush the data."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsFlush(fs: hdfsFS, file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsHFlush - Flush out the data in client's user buffer. After the"]
    #[doc = " return of this call, new readers will see the data."]
    #[doc = " @param fs configured filesystem handle"]
    #[doc = " @param file file handle"]
    #[doc = " @return 0 on success, -1 on error and sets errno"]
    pub fn hdfsHFlush(fs: hdfsFS, file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsSync - Flush out and sync the data in client's user buffer. After the"]
    #[doc = " return of this call, new readers will see the data."]
    #[doc = " @param fs configured filesystem handle"]
    #[doc = " @param file file handle"]
    #[doc = " @return 0 on success, -1 on error and sets errno"]
    pub fn hdfsSync(fs: hdfsFS, file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsAvailable - Number of bytes that can be read from this"]
    #[doc = " input stream without blocking."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param file The file handle."]
    #[doc = " @return Returns available bytes; -1 on error."]
    pub fn hdfsAvailable(fs: hdfsFS, file: hdfsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsCopy - Copy file from one filesystem to another."]
    #[doc = " @param srcFS The handle to source filesystem."]
    #[doc = " @param src The path of source file."]
    #[doc = " @param dstFS The handle to destination filesystem."]
    #[doc = " @param dst The path of destination file."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsCopy(
        srcFS: hdfsFS,
        src: *const ::std::os::raw::c_char,
        dstFS: hdfsFS,
        dst: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsMove - Move file from one filesystem to another."]
    #[doc = " @param srcFS The handle to source filesystem."]
    #[doc = " @param src The path of source file."]
    #[doc = " @param dstFS The handle to destination filesystem."]
    #[doc = " @param dst The path of destination file."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsMove(
        srcFS: hdfsFS,
        src: *const ::std::os::raw::c_char,
        dstFS: hdfsFS,
        dst: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsDelete - Delete file."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the file."]
    #[doc = " @param recursive if path is a directory and set to"]
    #[doc = " non-zero, the directory is deleted else throws an exception. In"]
    #[doc = " case of a file the recursive argument is irrelevant."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsDelete(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        recursive: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsRename - Rename file."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param oldPath The path of the source file."]
    #[doc = " @param newPath The path of the destination file."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsRename(
        fs: hdfsFS,
        oldPath: *const ::std::os::raw::c_char,
        newPath: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsGetWorkingDirectory - Get the current working directory for"]
    #[doc = " the given filesystem."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param buffer The user-buffer to copy path of cwd into."]
    #[doc = " @param bufferSize The length of user-buffer."]
    #[doc = " @return Returns buffer, NULL on error."]
    pub fn hdfsGetWorkingDirectory(
        fs: hdfsFS,
        buffer: *mut ::std::os::raw::c_char,
        bufferSize: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " hdfsSetWorkingDirectory - Set the working directory. All relative"]
    #[doc = " paths will be resolved relative to it."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the new 'cwd'."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsSetWorkingDirectory(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsCreateDirectory - Make the given file and all non-existent"]
    #[doc = " parents into directories."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the directory."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsCreateDirectory(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsSetReplication - Set the replication of the specified"]
    #[doc = " file to the supplied value"]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the file."]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsSetReplication(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        replication: i16,
    ) -> ::std::os::raw::c_int;
}
#[doc = " hdfsEncryptionZoneInfo- Information about an encryption zone."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdfsEncryptionZoneInfo {
    pub mSuite: ::std::os::raw::c_int,
    pub mCryptoProtocolVersion: ::std::os::raw::c_int,
    pub mId: i64,
    pub mPath: *mut ::std::os::raw::c_char,
    pub mKeyName: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_hdfsEncryptionZoneInfo() {
    assert_eq!(
        ::std::mem::size_of::<hdfsEncryptionZoneInfo>(),
        32usize,
        concat!("Size of: ", stringify!(hdfsEncryptionZoneInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<hdfsEncryptionZoneInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(hdfsEncryptionZoneInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionZoneInfo>())).mSuite as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionZoneInfo),
            "::",
            stringify!(mSuite)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hdfsEncryptionZoneInfo>())).mCryptoProtocolVersion as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionZoneInfo),
            "::",
            stringify!(mCryptoProtocolVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionZoneInfo>())).mId as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionZoneInfo),
            "::",
            stringify!(mId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionZoneInfo>())).mPath as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionZoneInfo),
            "::",
            stringify!(mPath)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionZoneInfo>())).mKeyName as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionZoneInfo),
            "::",
            stringify!(mKeyName)
        )
    );
}
#[doc = " hdfsEncryptionFileInfo - Information about an encryption file/directory."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdfsEncryptionFileInfo {
    pub mSuite: ::std::os::raw::c_int,
    pub mCryptoProtocolVersion: ::std::os::raw::c_int,
    pub mKey: *mut ::std::os::raw::c_char,
    pub mKeyName: *mut ::std::os::raw::c_char,
    pub mIv: *mut ::std::os::raw::c_char,
    pub mEzKeyVersionName: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_hdfsEncryptionFileInfo() {
    assert_eq!(
        ::std::mem::size_of::<hdfsEncryptionFileInfo>(),
        40usize,
        concat!("Size of: ", stringify!(hdfsEncryptionFileInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<hdfsEncryptionFileInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(hdfsEncryptionFileInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mSuite as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mSuite)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mCryptoProtocolVersion as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mCryptoProtocolVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mKey as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mKey)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mKeyName as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mKeyName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mIv as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mIv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hdfsEncryptionFileInfo>())).mEzKeyVersionName as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsEncryptionFileInfo),
            "::",
            stringify!(mEzKeyVersionName)
        )
    );
}
#[doc = " hdfsFileInfo - Information about a file/directory."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hdfsFileInfo {
    pub mKind: tObjectKind,
    pub mName: *mut ::std::os::raw::c_char,
    pub mLastMod: tTime,
    pub mSize: tOffset,
    pub mReplication: ::std::os::raw::c_short,
    pub mBlockSize: tOffset,
    pub mOwner: *mut ::std::os::raw::c_char,
    pub mGroup: *mut ::std::os::raw::c_char,
    pub mPermissions: ::std::os::raw::c_short,
    pub mLastAccess: tTime,
    pub mHdfsEncryptionFileInfo: *mut hdfsEncryptionFileInfo,
}
#[test]
fn bindgen_test_layout_hdfsFileInfo() {
    assert_eq!(
        ::std::mem::size_of::<hdfsFileInfo>(),
        88usize,
        concat!("Size of: ", stringify!(hdfsFileInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<hdfsFileInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(hdfsFileInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mKind as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mKind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mName as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mLastMod as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mLastMod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mSize as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mReplication as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mReplication)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mBlockSize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mBlockSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mOwner as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mOwner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mGroup as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mGroup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mPermissions as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mPermissions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hdfsFileInfo>())).mLastAccess as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mLastAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hdfsFileInfo>())).mHdfsEncryptionFileInfo as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(hdfsFileInfo),
            "::",
            stringify!(mHdfsEncryptionFileInfo)
        )
    );
}
extern "C" {
    #[doc = " hdfsListDirectory - Get list of files/directories for a given"]
    #[doc = " directory-path. hdfsFreeFileInfo should be called to deallocate memory."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the directory."]
    #[doc = " @param numEntries Set to the number of files/directories in path."]
    #[doc = " @return Returns a dynamically-allocated array of hdfsFileInfo"]
    #[doc = " objects; NULL on error."]
    pub fn hdfsListDirectory(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        numEntries: *mut ::std::os::raw::c_int,
    ) -> *mut hdfsFileInfo;
}
extern "C" {
    #[doc = " hdfsGetPathInfo - Get information about a path as a (dynamically"]
    #[doc = " allocated) single hdfsFileInfo struct. hdfsFreeFileInfo should be"]
    #[doc = " called when the pointer is no longer needed."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the file."]
    #[doc = " @return Returns a dynamically-allocated hdfsFileInfo object;"]
    #[doc = " NULL on error."]
    pub fn hdfsGetPathInfo(fs: hdfsFS, path: *const ::std::os::raw::c_char) -> *mut hdfsFileInfo;
}
extern "C" {
    #[doc = " hdfsFreeFileInfo - Free up the hdfsFileInfo array (including fields)"]
    #[doc = " @param infos The array of dynamically-allocated hdfsFileInfo"]
    #[doc = " objects."]
    #[doc = " @param numEntries The size of the array."]
    pub fn hdfsFreeFileInfo(infos: *mut hdfsFileInfo, numEntries: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " hdfsFreeEncryptionZoneInfo - Free up the hdfsEncryptionZoneInfo array (including fields)"]
    #[doc = " @param infos The array of dynamically-allocated hdfsEncryptionZoneInfo"]
    #[doc = " objects."]
    #[doc = " @param numEntries The size of the array."]
    pub fn hdfsFreeEncryptionZoneInfo(
        infos: *mut hdfsEncryptionZoneInfo,
        numEntries: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " hdfsGetHosts - Get hostnames where a particular block (determined by"]
    #[doc = " pos & blocksize) of a file is stored. The last element in the array"]
    #[doc = " is NULL. Due to replication, a single block could be present on"]
    #[doc = " multiple hosts."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the file."]
    #[doc = " @param start The start of the block."]
    #[doc = " @param length The length of the block."]
    #[doc = " @return Returns a dynamically-allocated 2-d array of blocks-hosts;"]
    #[doc = " NULL on error."]
    pub fn hdfsGetHosts(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        start: tOffset,
        length: tOffset,
    ) -> *mut *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " hdfsFreeHosts - Free up the structure returned by hdfsGetHosts"]
    #[doc = " @param hdfsFileInfo The array of dynamically-allocated hdfsFileInfo"]
    #[doc = " objects."]
    #[doc = " @param numEntries The size of the array."]
    pub fn hdfsFreeHosts(blockHosts: *mut *mut *mut ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " hdfsGetDefaultBlockSize - Get the default blocksize."]
    #[doc = ""]
    #[doc = " @param fs            The configured filesystem handle."]
    #[doc = " @deprecated          Use hdfsGetDefaultBlockSizeAtPath instead."]
    #[doc = ""]
    #[doc = " @return              Returns the default blocksize, or -1 on error."]
    pub fn hdfsGetDefaultBlockSize(fs: hdfsFS) -> tOffset;
}
extern "C" {
    #[doc = " hdfsGetCapacity - Return the raw capacity of the filesystem."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @return Returns the raw-capacity; -1 on error."]
    pub fn hdfsGetCapacity(fs: hdfsFS) -> tOffset;
}
extern "C" {
    #[doc = " hdfsGetUsed - Return the total raw size of all files in the filesystem."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @return Returns the total-size; -1 on error."]
    pub fn hdfsGetUsed(fs: hdfsFS) -> tOffset;
}
extern "C" {
    #[doc = " Change the user and/or group of a file or directory."]
    #[doc = ""]
    #[doc = " @param fs            The configured filesystem handle."]
    #[doc = " @param path          the path to the file or directory"]
    #[doc = " @param owner         User string.  Set to NULL for 'no change'"]
    #[doc = " @param group         Group string.  Set to NULL for 'no change'"]
    #[doc = " @return              0 on success else -1"]
    pub fn hdfsChown(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        owner: *const ::std::os::raw::c_char,
        group: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsChmod"]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path the path to the file or directory"]
    #[doc = " @param mode the bitmask to set it to"]
    #[doc = " @return 0 on success else -1"]
    pub fn hdfsChmod(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        mode: ::std::os::raw::c_short,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsUtime"]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path the path to the file or directory"]
    #[doc = " @param mtime new modification time or -1 for no change"]
    #[doc = " @param atime new access time or -1 for no change"]
    #[doc = " @return 0 on success else -1"]
    pub fn hdfsUtime(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        mtime: tTime,
        atime: tTime,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsTruncate - Truncate the file in the indicated path to the indicated size."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path the path to the file."]
    #[doc = " @param pos the position the file will be truncated to."]
    #[doc = " @param shouldWait output value, true if and client does not need to wait for block recovery,"]
    #[doc = " false if client needs to wait for block recovery."]
    pub fn hdfsTruncate(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        pos: tOffset,
        shouldWait: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get a delegation token from namenode."]
    #[doc = " The token should be freed using hdfsFreeDelegationToken after canceling the token or token expired."]
    #[doc = ""]
    #[doc = " @param fs The file system"]
    #[doc = " @param renewer The user who will renew the token"]
    #[doc = ""]
    #[doc = " @return Return a delegation token, NULL on error."]
    pub fn hdfsGetDelegationToken(
        fs: hdfsFS,
        renewer: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Free a delegation token."]
    #[doc = ""]
    #[doc = " @param token The token to be freed."]
    pub fn hdfsFreeDelegationToken(token: *mut ::std::os::raw::c_char);
}
extern "C" {
    #[doc = " Renew a delegation token."]
    #[doc = ""]
    #[doc = " @param fs The file system."]
    #[doc = " @param token The token to be renewed."]
    #[doc = ""]
    #[doc = " @return the new expiration time"]
    pub fn hdfsRenewDelegationToken(fs: hdfsFS, token: *const ::std::os::raw::c_char) -> i64;
}
extern "C" {
    #[doc = " Cancel a delegation token."]
    #[doc = ""]
    #[doc = " @param fs The file system."]
    #[doc = " @param token The token to be canceled."]
    #[doc = ""]
    #[doc = " @return return 0 on success, -1 on error."]
    pub fn hdfsCancelDelegationToken(
        fs: hdfsFS,
        token: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Namenode {
    pub rpc_addr: *mut ::std::os::raw::c_char,
    pub http_addr: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_Namenode() {
    assert_eq!(
        ::std::mem::size_of::<Namenode>(),
        16usize,
        concat!("Size of: ", stringify!(Namenode))
    );
    assert_eq!(
        ::std::mem::align_of::<Namenode>(),
        8usize,
        concat!("Alignment of ", stringify!(Namenode))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Namenode>())).rpc_addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Namenode),
            "::",
            stringify!(rpc_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Namenode>())).http_addr as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Namenode),
            "::",
            stringify!(http_addr)
        )
    );
}
extern "C" {
    #[doc = " If hdfs is configured with HA namenode, return all namenode informations as an array."]
    #[doc = " Else return NULL."]
    #[doc = ""]
    #[doc = " Using configure file which is given by environment parameter LIBHDFS3_CONF"]
    #[doc = " or \"hdfs-client.xml\" in working directory."]
    #[doc = ""]
    #[doc = " @param nameservice hdfs name service id."]
    #[doc = " @param size output the size of returning array."]
    #[doc = ""]
    #[doc = " @return return an array of all namenode information."]
    pub fn hdfsGetHANamenodes(
        nameservice: *const ::std::os::raw::c_char,
        size: *mut ::std::os::raw::c_int,
    ) -> *mut Namenode;
}
extern "C" {
    #[doc = " If hdfs is configured with HA namenode, return all namenode informations as an array."]
    #[doc = " Else return NULL."]
    #[doc = ""]
    #[doc = " @param conf the path of configure file."]
    #[doc = " @param nameservice hdfs name service id."]
    #[doc = " @param size output the size of returning array."]
    #[doc = ""]
    #[doc = " @return return an array of all namenode information."]
    pub fn hdfsGetHANamenodesWithConfig(
        conf: *const ::std::os::raw::c_char,
        nameservice: *const ::std::os::raw::c_char,
        size: *mut ::std::os::raw::c_int,
    ) -> *mut Namenode;
}
extern "C" {
    #[doc = " Free the array returned by hdfsGetConfiguredNamenodes()"]
    #[doc = ""]
    #[doc = " @param the array return by hdfsGetConfiguredNamenodes()"]
    pub fn hdfsFreeNamenodeInformation(namenodes: *mut Namenode, size: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BlockLocation {
    pub rangeId: u32,
    pub replicaGroupId: u32,
    pub corrupt: ::std::os::raw::c_int,
    pub numOfNodes: ::std::os::raw::c_int,
    pub hosts: *mut *mut ::std::os::raw::c_char,
    pub names: *mut *mut ::std::os::raw::c_char,
    pub topologyPaths: *mut *mut ::std::os::raw::c_char,
    pub length: tOffset,
    pub offset: tOffset,
}
#[test]
fn bindgen_test_layout_BlockLocation() {
    assert_eq!(
        ::std::mem::size_of::<BlockLocation>(),
        56usize,
        concat!("Size of: ", stringify!(BlockLocation))
    );
    assert_eq!(
        ::std::mem::align_of::<BlockLocation>(),
        8usize,
        concat!("Alignment of ", stringify!(BlockLocation))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).rangeId as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(rangeId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).replicaGroupId as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(replicaGroupId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).corrupt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(corrupt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).numOfNodes as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(numOfNodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).hosts as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(hosts)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).names as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).topologyPaths as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(topologyPaths)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).length as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<BlockLocation>())).offset as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(BlockLocation),
            "::",
            stringify!(offset)
        )
    );
}
extern "C" {
    #[doc = " Get an array containing hostnames, offset and size of portions of the given file."]
    #[doc = ""]
    #[doc = " @param fs The file system"]
    #[doc = " @param path The path to the file"]
    #[doc = " @param start The start offset into the given file"]
    #[doc = " @param length The length for which to get locations for"]
    #[doc = " @param numOfBlock Output the number of elements in the returned array"]
    #[doc = ""]
    #[doc = " @return An array of BlockLocation struct."]
    pub fn hdfsGetFileBlockLocations(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        start: tOffset,
        length: tOffset,
        numOfBlock: *mut ::std::os::raw::c_int,
    ) -> *mut BlockLocation;
}
extern "C" {
    #[doc = " Free the BlockLocation array returned by hdfsGetFileBlockLocations"]
    #[doc = ""]
    #[doc = " @param locations The array returned by hdfsGetFileBlockLocations"]
    #[doc = " @param numOfBlock The number of elements in the locaitons"]
    pub fn hdfsFreeFileBlockLocations(
        locations: *mut BlockLocation,
        numOfBlock: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " Create encryption zone for the directory with specific key name"]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the directory."]
    #[doc = " @param keyname The key name of the encryption zone"]
    #[doc = " @return Returns 0 on success, -1 on error."]
    pub fn hdfsCreateEncryptionZone(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
        keyName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " hdfsEncryptionZoneInfo - Get information about a path as a (dynamically"]
    #[doc = " allocated) single hdfsEncryptionZoneInfo struct. hdfsEncryptionZoneInfo should be"]
    #[doc = " called when the pointer is no longer needed."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @param path The path of the encryption zone."]
    #[doc = " @return Returns a dynamically-allocated hdfsEncryptionZoneInfo object;"]
    #[doc = " NULL on error."]
    pub fn hdfsGetEZForPath(
        fs: hdfsFS,
        path: *const ::std::os::raw::c_char,
    ) -> *mut hdfsEncryptionZoneInfo;
}
extern "C" {
    #[doc = " hdfsEncryptionZoneInfo -  Get list of all the encryption zones."]
    #[doc = " hdfsFreeEncryptionZoneInfo should be called to deallocate memory."]
    #[doc = " @param fs The configured filesystem handle."]
    #[doc = " @return Returns a dynamically-allocated array of hdfsEncryptionZoneInfo objects;"]
    #[doc = " NULL on error."]
    pub fn hdfsListEncryptionZones(
        fs: hdfsFS,
        numEntries: *mut ::std::os::raw::c_int,
    ) -> *mut hdfsEncryptionZoneInfo;
}
