
#[derive(Debug)]
pub enum Error {
    ArrayCountError,
    ArrayItemNotFound,
    ArrayItemUnexpectedType,
    BinaryLengthError,
    CannotGetPallet,
    DictCountError,
    DictItemNotFound,
    DictItemUnexpectedType,
    DictStreamLengthNotFound,
    DocEncryptdictNotFound,
    DocInvalidObject,
    DuplicateRegistration,
    ExceedJwwCodeNumLimit,
    EncryptInvalidPassword,
    ErrorUnknownClass,
    ExceedGstateLimit,
    FailedToAllocMem,
    FileIoError,
    FileOpenError,
    FontExists,
    FontInvalidWidthsTable,
    InvalidAfmHeader,
    InvalidAnnotation,
    InvalidBitPerComponent,
    InvalidCharMatricsData,
    InvalidColorSpace,
    InvalidCompressionMode,
    InvalidDateTime,
    InvalidDestination,
    InvalidDocument,
    InvalidDocumentState,
    InvalidEncoder,
    InvalidEncoderType,
    InvalidEncodingName,
    InvalidEncryptKeyLen,
    InvalidFontdefData,
    InvalidFOntDefType,
    InvalidFontName,
    InvalidImage,
    InvalidJpegData,
    InvalidNData,
    InvalidObject,
    InvalidObjectId,
    InvalidOperation,
    InvalidOutline,
    InvalidPage,
    InvalidPages,
    InvalidParameter,
    InvalidPngImage,
    InvalidStream,
    MissingFileNameEntry,
    InvalidTtcFile,
    InvalidTtcIndex,
    InvalidWxData,
    ItemNotFound,
    LibpngError,
    NameInvalidValue,
    NameOutOfRange,
    PageInvalidParamCount,
    PagesMissingKidsEntry,
    PageCannotFindObject,
    PageCannotGetRootPages,
    PageCannotRestoreGstate,
    PageCannotSetParent,
    PageFontNotFound,
    PageInvalidFont,
    PageInvalidFontSize,
    PageInvalidGMode,
    PageInvalidIndex,
    PageInvalidRotateValue,
    PageInvalidSize,
    PageInvalidXobject,
    PageOutOfRange,
    RealOutOfRange,
    StreamEof,
    StreamReadlnContinue,
    StringOutOfRange,
    ThisFuncWasSkipped,
    TtfCannotEmbeddingFont,
    TtfInvalidCmap,
    TtfInvalidFormat,
    TtfMissingTable,
    UnsupportedFontType,
    UnsupportedFunc,
    UnsupportedJpegFormat,
    UnsupportedType1Font,
    XrefCountError,
    ZlibError,
    InvalidPageIndex,
    InvalidUri,
    PageLayoutOutOfRange,
    PageModeOutOfRange,
    PageNumStyleOutOfRange,
    AnnotInvalidIcon,
    AnnotInvalidBorderStyle,
    PageInvalidDirection,
    InvalidFont,
    PageInsufficientSpace,
    PageInvalidDisplayTime,
    PageInvalidTransitionTime,
    InvalidPageSlideshowType,
    ExtGstateOutOfRange,
    InvalidExtGstate,
    ExtGstateReadOnly,
    InvalidU3dData,
    NameCannotGetNames,
    InvalidIccComponentNum,
    Other(libharu_sys::HPDF_STATUS)
}

impl Error {
    pub(crate) fn from_num(num: libharu_sys::HPDF_STATUS) -> Self {
        match num {
            0x1001 => Self::ArrayCountError,
            0x1002 => Self::ArrayItemNotFound,
            0x1003 => Self::ArrayItemUnexpectedType,
            0x1004 => Self::BinaryLengthError,
            0x1005 => Self::CannotGetPallet,
            /* 0x1006 */
            0x1007 => Self::DictCountError,
            0x1008 => Self::DictItemNotFound,
            0x1009 => Self::DictItemUnexpectedType,
            0x100A => Self::DictStreamLengthNotFound,
            0x100B => Self::DocEncryptdictNotFound,
            0x100C => Self::DocInvalidObject,
            /* 0x100D */
            0x100E => Self::DuplicateRegistration,
            0x100F => Self::ExceedJwwCodeNumLimit,
            /* 0x1010 */
            0x1011 => Self::EncryptInvalidPassword,
            /* 0x1012 */
            0x1013 => Self::ErrorUnknownClass,
            0x1014 => Self::ExceedGstateLimit,
            0x1015 => Self::FailedToAllocMem,
            0x1016 => Self::FileIoError,
            0x1017 => Self::FileOpenError,
            /* 0x1018 */
            0x1019 => Self::FontExists,
            0x101A => Self::FontInvalidWidthsTable,
            0x101B => Self::InvalidAfmHeader,
            0x101C => Self::InvalidAnnotation,
            /* 0x101D */
            0x101E => Self::InvalidBitPerComponent,
            0x101F => Self::InvalidCharMatricsData,
            0x1020 => Self::InvalidColorSpace,
            0x1021 => Self::InvalidCompressionMode,
            0x1022 => Self::InvalidDateTime,
            0x1023 => Self::InvalidDestination,
            /* 0x1024 */
            0x1025 => Self::InvalidDocument,
            0x1026 => Self::InvalidDocumentState,
            0x1027 => Self::InvalidEncoder,
            0x1028 => Self::InvalidEncoderType,
            /* 0x1029 */
            /* 0x102A */
            0x102B => Self::InvalidEncodingName,
            0x102C => Self::InvalidEncryptKeyLen,
            0x102D => Self::InvalidFontdefData,
            0x102E => Self::InvalidFOntDefType,
            0x102F => Self::InvalidFontName,
            0x1030 => Self::InvalidImage,
            0x1031 => Self::InvalidJpegData,
            0x1032 => Self::InvalidNData,
            0x1033 => Self::InvalidObject,
            0x1034 => Self::InvalidObjectId,
            0x1035 => Self::InvalidOperation,
            0x1036 => Self::InvalidOutline,
            0x1037 => Self::InvalidPage,
            0x1038 => Self::InvalidPages,
            0x1039 => Self::InvalidParameter,
            /* 0x103A */
            0x103B => Self::InvalidPngImage,
            0x103C => Self::InvalidStream,
            0x103D => Self::MissingFileNameEntry,
            /* 0x103E */
            0x103F => Self::InvalidTtcFile,
            0x1040 => Self::InvalidTtcIndex,
            0x1041 => Self::InvalidWxData,
            0x1042 => Self::ItemNotFound,
            0x1043 => Self::LibpngError,
            0x1044 => Self::NameInvalidValue,
            0x1045 => Self::NameOutOfRange,
            /* 0x1046 */
            /* 0x1047 */
            0x1048 => Self::PageInvalidParamCount,
            0x1049 => Self::PagesMissingKidsEntry,
            0x104A => Self::PageCannotFindObject,
            0x104B => Self::PageCannotGetRootPages,
            0x104C => Self::PageCannotRestoreGstate,
            0x104D => Self::PageCannotSetParent,
            0x104E => Self::PageFontNotFound,
            0x104F => Self::PageInvalidFont,
            0x1050 => Self::PageInvalidFontSize,
            0x1051 => Self::PageInvalidGMode,
            0x1052 => Self::PageInvalidIndex,
            0x1053 => Self::PageInvalidRotateValue,
            0x1054 => Self::PageInvalidSize,
            0x1055 => Self::PageInvalidXobject,
            0x1056 => Self::PageOutOfRange,
            0x1057 => Self::RealOutOfRange,
            0x1058 => Self::StreamEof,
            0x1059 => Self::StreamReadlnContinue,
            /* 0x105A */
            0x105B => Self::StringOutOfRange,
            0x105C => Self::ThisFuncWasSkipped,
            0x105D => Self::TtfCannotEmbeddingFont,
            0x105E => Self::TtfInvalidCmap,
            0x105F => Self::TtfInvalidFormat,
            0x1060 => Self::TtfMissingTable,
            0x1061 => Self::UnsupportedFontType,
            0x1062 => Self::UnsupportedFunc,
            0x1063 => Self::UnsupportedJpegFormat,
            0x1064 => Self::UnsupportedType1Font,
            0x1065 => Self::XrefCountError,
            0x1066 => Self::ZlibError,
            0x1067 => Self::InvalidPageIndex,
            0x1068 => Self::InvalidUri,
            0x1069 => Self::PageLayoutOutOfRange,
            /* 0x106A-0x106F */
            0x1070 => Self::PageModeOutOfRange,
            0x1071 => Self::PageNumStyleOutOfRange,
            0x1072 => Self::AnnotInvalidIcon,
            0x1073 => Self::AnnotInvalidBorderStyle,
            0x1074 => Self::PageInvalidDirection,
            0x1075 => Self::InvalidFont,
            0x1076 => Self::PageInsufficientSpace,
            0x1077 => Self::PageInvalidDisplayTime,
            0x1078 => Self::PageInvalidTransitionTime,
            0x1079 => Self::InvalidPageSlideshowType,
            /* 0x107A-0x107F */
            0x1080 => Self::ExtGstateOutOfRange,
            0x1081 => Self::InvalidExtGstate,
            0x1082 => Self::ExtGstateReadOnly,
            0x1083 => Self::InvalidU3dData,
            0x1084 => Self::NameCannotGetNames,
            0x1085 => Self::InvalidIccComponentNum,
            
            n => Self::Other(n),
        }
    }
}
