// Generated by gir (https://github.com/gtk-rs/gir @ ee37253c10af)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git @ 5264fd0c3183)
// DO NOT EDIT

use libhandy_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["libhandy-1"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "HdyActionRow",
        Layout {
            size: size_of::<HdyActionRow>(),
            alignment: align_of::<HdyActionRow>(),
        },
    ),
    (
        "HdyActionRowClass",
        Layout {
            size: size_of::<HdyActionRowClass>(),
            alignment: align_of::<HdyActionRowClass>(),
        },
    ),
    (
        "HdyApplicationWindow",
        Layout {
            size: size_of::<HdyApplicationWindow>(),
            alignment: align_of::<HdyApplicationWindow>(),
        },
    ),
    (
        "HdyApplicationWindowClass",
        Layout {
            size: size_of::<HdyApplicationWindowClass>(),
            alignment: align_of::<HdyApplicationWindowClass>(),
        },
    ),
    (
        "HdyAvatarClass",
        Layout {
            size: size_of::<HdyAvatarClass>(),
            alignment: align_of::<HdyAvatarClass>(),
        },
    ),
    (
        "HdyCarouselClass",
        Layout {
            size: size_of::<HdyCarouselClass>(),
            alignment: align_of::<HdyCarouselClass>(),
        },
    ),
    (
        "HdyCarouselIndicatorDotsClass",
        Layout {
            size: size_of::<HdyCarouselIndicatorDotsClass>(),
            alignment: align_of::<HdyCarouselIndicatorDotsClass>(),
        },
    ),
    (
        "HdyCarouselIndicatorLinesClass",
        Layout {
            size: size_of::<HdyCarouselIndicatorLinesClass>(),
            alignment: align_of::<HdyCarouselIndicatorLinesClass>(),
        },
    ),
    (
        "HdyCenteringPolicy",
        Layout {
            size: size_of::<HdyCenteringPolicy>(),
            alignment: align_of::<HdyCenteringPolicy>(),
        },
    ),
    (
        "HdyClampClass",
        Layout {
            size: size_of::<HdyClampClass>(),
            alignment: align_of::<HdyClampClass>(),
        },
    ),
    (
        "HdyColorScheme",
        Layout {
            size: size_of::<HdyColorScheme>(),
            alignment: align_of::<HdyColorScheme>(),
        },
    ),
    (
        "HdyComboRow",
        Layout {
            size: size_of::<HdyComboRow>(),
            alignment: align_of::<HdyComboRow>(),
        },
    ),
    (
        "HdyComboRowClass",
        Layout {
            size: size_of::<HdyComboRowClass>(),
            alignment: align_of::<HdyComboRowClass>(),
        },
    ),
    (
        "HdyDeck",
        Layout {
            size: size_of::<HdyDeck>(),
            alignment: align_of::<HdyDeck>(),
        },
    ),
    (
        "HdyDeckClass",
        Layout {
            size: size_of::<HdyDeckClass>(),
            alignment: align_of::<HdyDeckClass>(),
        },
    ),
    (
        "HdyDeckTransitionType",
        Layout {
            size: size_of::<HdyDeckTransitionType>(),
            alignment: align_of::<HdyDeckTransitionType>(),
        },
    ),
    (
        "HdyEnumValueObjectClass",
        Layout {
            size: size_of::<HdyEnumValueObjectClass>(),
            alignment: align_of::<HdyEnumValueObjectClass>(),
        },
    ),
    (
        "HdyExpanderRow",
        Layout {
            size: size_of::<HdyExpanderRow>(),
            alignment: align_of::<HdyExpanderRow>(),
        },
    ),
    (
        "HdyExpanderRowClass",
        Layout {
            size: size_of::<HdyExpanderRowClass>(),
            alignment: align_of::<HdyExpanderRowClass>(),
        },
    ),
    (
        "HdyFlapClass",
        Layout {
            size: size_of::<HdyFlapClass>(),
            alignment: align_of::<HdyFlapClass>(),
        },
    ),
    (
        "HdyFlapFoldPolicy",
        Layout {
            size: size_of::<HdyFlapFoldPolicy>(),
            alignment: align_of::<HdyFlapFoldPolicy>(),
        },
    ),
    (
        "HdyFlapTransitionType",
        Layout {
            size: size_of::<HdyFlapTransitionType>(),
            alignment: align_of::<HdyFlapTransitionType>(),
        },
    ),
    (
        "HdyHeaderBar",
        Layout {
            size: size_of::<HdyHeaderBar>(),
            alignment: align_of::<HdyHeaderBar>(),
        },
    ),
    (
        "HdyHeaderBarClass",
        Layout {
            size: size_of::<HdyHeaderBarClass>(),
            alignment: align_of::<HdyHeaderBarClass>(),
        },
    ),
    (
        "HdyHeaderGroupChildClass",
        Layout {
            size: size_of::<HdyHeaderGroupChildClass>(),
            alignment: align_of::<HdyHeaderGroupChildClass>(),
        },
    ),
    (
        "HdyHeaderGroupChildType",
        Layout {
            size: size_of::<HdyHeaderGroupChildType>(),
            alignment: align_of::<HdyHeaderGroupChildType>(),
        },
    ),
    (
        "HdyHeaderGroupClass",
        Layout {
            size: size_of::<HdyHeaderGroupClass>(),
            alignment: align_of::<HdyHeaderGroupClass>(),
        },
    ),
    (
        "HdyKeypad",
        Layout {
            size: size_of::<HdyKeypad>(),
            alignment: align_of::<HdyKeypad>(),
        },
    ),
    (
        "HdyKeypadClass",
        Layout {
            size: size_of::<HdyKeypadClass>(),
            alignment: align_of::<HdyKeypadClass>(),
        },
    ),
    (
        "HdyLeaflet",
        Layout {
            size: size_of::<HdyLeaflet>(),
            alignment: align_of::<HdyLeaflet>(),
        },
    ),
    (
        "HdyLeafletClass",
        Layout {
            size: size_of::<HdyLeafletClass>(),
            alignment: align_of::<HdyLeafletClass>(),
        },
    ),
    (
        "HdyLeafletTransitionType",
        Layout {
            size: size_of::<HdyLeafletTransitionType>(),
            alignment: align_of::<HdyLeafletTransitionType>(),
        },
    ),
    (
        "HdyNavigationDirection",
        Layout {
            size: size_of::<HdyNavigationDirection>(),
            alignment: align_of::<HdyNavigationDirection>(),
        },
    ),
    (
        "HdyPreferencesGroup",
        Layout {
            size: size_of::<HdyPreferencesGroup>(),
            alignment: align_of::<HdyPreferencesGroup>(),
        },
    ),
    (
        "HdyPreferencesGroupClass",
        Layout {
            size: size_of::<HdyPreferencesGroupClass>(),
            alignment: align_of::<HdyPreferencesGroupClass>(),
        },
    ),
    (
        "HdyPreferencesPage",
        Layout {
            size: size_of::<HdyPreferencesPage>(),
            alignment: align_of::<HdyPreferencesPage>(),
        },
    ),
    (
        "HdyPreferencesPageClass",
        Layout {
            size: size_of::<HdyPreferencesPageClass>(),
            alignment: align_of::<HdyPreferencesPageClass>(),
        },
    ),
    (
        "HdyPreferencesRow",
        Layout {
            size: size_of::<HdyPreferencesRow>(),
            alignment: align_of::<HdyPreferencesRow>(),
        },
    ),
    (
        "HdyPreferencesRowClass",
        Layout {
            size: size_of::<HdyPreferencesRowClass>(),
            alignment: align_of::<HdyPreferencesRowClass>(),
        },
    ),
    (
        "HdyPreferencesWindow",
        Layout {
            size: size_of::<HdyPreferencesWindow>(),
            alignment: align_of::<HdyPreferencesWindow>(),
        },
    ),
    (
        "HdyPreferencesWindowClass",
        Layout {
            size: size_of::<HdyPreferencesWindowClass>(),
            alignment: align_of::<HdyPreferencesWindowClass>(),
        },
    ),
    (
        "HdySearchBar",
        Layout {
            size: size_of::<HdySearchBar>(),
            alignment: align_of::<HdySearchBar>(),
        },
    ),
    (
        "HdySearchBarClass",
        Layout {
            size: size_of::<HdySearchBarClass>(),
            alignment: align_of::<HdySearchBarClass>(),
        },
    ),
    (
        "HdySqueezerClass",
        Layout {
            size: size_of::<HdySqueezerClass>(),
            alignment: align_of::<HdySqueezerClass>(),
        },
    ),
    (
        "HdySqueezerTransitionType",
        Layout {
            size: size_of::<HdySqueezerTransitionType>(),
            alignment: align_of::<HdySqueezerTransitionType>(),
        },
    ),
    (
        "HdyStatusPageClass",
        Layout {
            size: size_of::<HdyStatusPageClass>(),
            alignment: align_of::<HdyStatusPageClass>(),
        },
    ),
    (
        "HdyStyleManagerClass",
        Layout {
            size: size_of::<HdyStyleManagerClass>(),
            alignment: align_of::<HdyStyleManagerClass>(),
        },
    ),
    (
        "HdySwipeGroupClass",
        Layout {
            size: size_of::<HdySwipeGroupClass>(),
            alignment: align_of::<HdySwipeGroupClass>(),
        },
    ),
    (
        "HdySwipeTrackerClass",
        Layout {
            size: size_of::<HdySwipeTrackerClass>(),
            alignment: align_of::<HdySwipeTrackerClass>(),
        },
    ),
    (
        "HdySwipeableInterface",
        Layout {
            size: size_of::<HdySwipeableInterface>(),
            alignment: align_of::<HdySwipeableInterface>(),
        },
    ),
    (
        "HdyTabBarClass",
        Layout {
            size: size_of::<HdyTabBarClass>(),
            alignment: align_of::<HdyTabBarClass>(),
        },
    ),
    (
        "HdyTabPageClass",
        Layout {
            size: size_of::<HdyTabPageClass>(),
            alignment: align_of::<HdyTabPageClass>(),
        },
    ),
    (
        "HdyTabViewClass",
        Layout {
            size: size_of::<HdyTabViewClass>(),
            alignment: align_of::<HdyTabViewClass>(),
        },
    ),
    (
        "HdyTitleBarClass",
        Layout {
            size: size_of::<HdyTitleBarClass>(),
            alignment: align_of::<HdyTitleBarClass>(),
        },
    ),
    (
        "HdyValueObjectClass",
        Layout {
            size: size_of::<HdyValueObjectClass>(),
            alignment: align_of::<HdyValueObjectClass>(),
        },
    ),
    (
        "HdyViewSwitcherBarClass",
        Layout {
            size: size_of::<HdyViewSwitcherBarClass>(),
            alignment: align_of::<HdyViewSwitcherBarClass>(),
        },
    ),
    (
        "HdyViewSwitcherClass",
        Layout {
            size: size_of::<HdyViewSwitcherClass>(),
            alignment: align_of::<HdyViewSwitcherClass>(),
        },
    ),
    (
        "HdyViewSwitcherPolicy",
        Layout {
            size: size_of::<HdyViewSwitcherPolicy>(),
            alignment: align_of::<HdyViewSwitcherPolicy>(),
        },
    ),
    (
        "HdyViewSwitcherTitleClass",
        Layout {
            size: size_of::<HdyViewSwitcherTitleClass>(),
            alignment: align_of::<HdyViewSwitcherTitleClass>(),
        },
    ),
    (
        "HdyWindow",
        Layout {
            size: size_of::<HdyWindow>(),
            alignment: align_of::<HdyWindow>(),
        },
    ),
    (
        "HdyWindowClass",
        Layout {
            size: size_of::<HdyWindowClass>(),
            alignment: align_of::<HdyWindowClass>(),
        },
    ),
    (
        "HdyWindowHandleClass",
        Layout {
            size: size_of::<HdyWindowHandleClass>(),
            alignment: align_of::<HdyWindowHandleClass>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) HDY_CENTERING_POLICY_LOOSE", "0"),
    ("(gint) HDY_CENTERING_POLICY_STRICT", "1"),
    ("(gint) HDY_COLOR_SCHEME_DEFAULT", "0"),
    ("(gint) HDY_COLOR_SCHEME_FORCE_DARK", "4"),
    ("(gint) HDY_COLOR_SCHEME_FORCE_LIGHT", "1"),
    ("(gint) HDY_COLOR_SCHEME_PREFER_DARK", "3"),
    ("(gint) HDY_COLOR_SCHEME_PREFER_LIGHT", "2"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_OVER", "0"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_SLIDE", "2"),
    ("(gint) HDY_DECK_TRANSITION_TYPE_UNDER", "1"),
    ("(gint) HDY_FLAP_FOLD_POLICY_ALWAYS", "1"),
    ("(gint) HDY_FLAP_FOLD_POLICY_AUTO", "2"),
    ("(gint) HDY_FLAP_FOLD_POLICY_NEVER", "0"),
    ("(gint) HDY_FLAP_TRANSITION_TYPE_OVER", "0"),
    ("(gint) HDY_FLAP_TRANSITION_TYPE_SLIDE", "2"),
    ("(gint) HDY_FLAP_TRANSITION_TYPE_UNDER", "1"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_GTK_HEADER_BAR", "1"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_HEADER_BAR", "0"),
    ("(gint) HDY_HEADER_GROUP_CHILD_TYPE_HEADER_GROUP", "2"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_OVER", "0"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_SLIDE", "2"),
    ("(gint) HDY_LEAFLET_TRANSITION_TYPE_UNDER", "1"),
    ("(gint) HDY_NAVIGATION_DIRECTION_BACK", "0"),
    ("(gint) HDY_NAVIGATION_DIRECTION_FORWARD", "1"),
    ("(gint) HDY_SQUEEZER_TRANSITION_TYPE_CROSSFADE", "1"),
    ("(gint) HDY_SQUEEZER_TRANSITION_TYPE_NONE", "0"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_AUTO", "0"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_NARROW", "1"),
    ("(gint) HDY_VIEW_SWITCHER_POLICY_WIDE", "2"),
];
