/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const FT_OPEN_BY_SERIAL_NUMBER: u32 = 1;
pub const FT_OPEN_BY_DESCRIPTION: u32 = 2;
pub const FT_OPEN_BY_LOCATION: u32 = 4;
pub const FT_OPEN_MASK: u32 = 7;
pub const FT_LIST_NUMBER_ONLY: u32 = 2147483648;
pub const FT_LIST_BY_INDEX: u32 = 1073741824;
pub const FT_LIST_ALL: u32 = 536870912;
pub const FT_LIST_MASK: u32 = 3758096384;
pub const FT_BAUD_300: u32 = 300;
pub const FT_BAUD_600: u32 = 600;
pub const FT_BAUD_1200: u32 = 1200;
pub const FT_BAUD_2400: u32 = 2400;
pub const FT_BAUD_4800: u32 = 4800;
pub const FT_BAUD_9600: u32 = 9600;
pub const FT_BAUD_14400: u32 = 14400;
pub const FT_BAUD_19200: u32 = 19200;
pub const FT_BAUD_38400: u32 = 38400;
pub const FT_BAUD_57600: u32 = 57600;
pub const FT_BAUD_115200: u32 = 115200;
pub const FT_BAUD_230400: u32 = 230400;
pub const FT_BAUD_460800: u32 = 460800;
pub const FT_BAUD_921600: u32 = 921600;
pub const FT_FLOW_NONE: u32 = 0;
pub const FT_FLOW_RTS_CTS: u32 = 256;
pub const FT_FLOW_DTR_DSR: u32 = 512;
pub const FT_FLOW_XON_XOFF: u32 = 1024;
pub const FT_PURGE_RX: u32 = 1;
pub const FT_PURGE_TX: u32 = 2;
pub const FT_EVENT_RXCHAR: u32 = 1;
pub const FT_EVENT_MODEM_STATUS: u32 = 2;
pub const FT_EVENT_LINE_STATUS: u32 = 4;
pub const FT_DEFAULT_RX_TIMEOUT: u32 = 300;
pub const FT_DEFAULT_TX_TIMEOUT: u32 = 300;
pub const FT_BITMODE_RESET: u32 = 0;
pub const FT_BITMODE_ASYNC_BITBANG: u32 = 1;
pub const FT_BITMODE_MPSSE: u32 = 2;
pub const FT_BITMODE_SYNC_BITBANG: u32 = 4;
pub const FT_BITMODE_MCU_HOST: u32 = 8;
pub const FT_BITMODE_FAST_SERIAL: u32 = 16;
pub const FT_BITMODE_CBUS_BITBANG: u32 = 32;
pub const FT_BITMODE_SYNC_FIFO: u32 = 64;
pub const FT_232R_CBUS_TXDEN: u32 = 0;
pub const FT_232R_CBUS_PWRON: u32 = 1;
pub const FT_232R_CBUS_RXLED: u32 = 2;
pub const FT_232R_CBUS_TXLED: u32 = 3;
pub const FT_232R_CBUS_TXRXLED: u32 = 4;
pub const FT_232R_CBUS_SLEEP: u32 = 5;
pub const FT_232R_CBUS_CLK48: u32 = 6;
pub const FT_232R_CBUS_CLK24: u32 = 7;
pub const FT_232R_CBUS_CLK12: u32 = 8;
pub const FT_232R_CBUS_CLK6: u32 = 9;
pub const FT_232R_CBUS_IOMODE: u32 = 10;
pub const FT_232R_CBUS_BITBANG_WR: u32 = 11;
pub const FT_232R_CBUS_BITBANG_RD: u32 = 12;
pub const FT_232H_CBUS_TRISTATE: u32 = 0;
pub const FT_232H_CBUS_TXLED: u32 = 1;
pub const FT_232H_CBUS_RXLED: u32 = 2;
pub const FT_232H_CBUS_TXRXLED: u32 = 3;
pub const FT_232H_CBUS_PWREN: u32 = 4;
pub const FT_232H_CBUS_SLEEP: u32 = 5;
pub const FT_232H_CBUS_DRIVE_0: u32 = 6;
pub const FT_232H_CBUS_DRIVE_1: u32 = 7;
pub const FT_232H_CBUS_IOMODE: u32 = 8;
pub const FT_232H_CBUS_TXDEN: u32 = 9;
pub const FT_232H_CBUS_CLK30: u32 = 10;
pub const FT_232H_CBUS_CLK15: u32 = 11;
pub const FT_232H_CBUS_CLK7_5: u32 = 12;
pub const FT_X_SERIES_CBUS_TRISTATE: u32 = 0;
pub const FT_X_SERIES_CBUS_TXLED: u32 = 1;
pub const FT_X_SERIES_CBUS_RXLED: u32 = 2;
pub const FT_X_SERIES_CBUS_TXRXLED: u32 = 3;
pub const FT_X_SERIES_CBUS_PWREN: u32 = 4;
pub const FT_X_SERIES_CBUS_SLEEP: u32 = 5;
pub const FT_X_SERIES_CBUS_DRIVE_0: u32 = 6;
pub const FT_X_SERIES_CBUS_DRIVE_1: u32 = 7;
pub const FT_X_SERIES_CBUS_IOMODE: u32 = 8;
pub const FT_X_SERIES_CBUS_TXDEN: u32 = 9;
pub const FT_X_SERIES_CBUS_CLK24: u32 = 10;
pub const FT_X_SERIES_CBUS_CLK12: u32 = 11;
pub const FT_X_SERIES_CBUS_CLK6: u32 = 12;
pub const FT_X_SERIES_CBUS_BCD_CHARGER: u32 = 13;
pub const FT_X_SERIES_CBUS_BCD_CHARGER_N: u32 = 14;
pub const FT_X_SERIES_CBUS_I2C_TXE: u32 = 15;
pub const FT_X_SERIES_CBUS_I2C_RXF: u32 = 16;
pub const FT_X_SERIES_CBUS_VBUS_SENSE: u32 = 17;
pub const FT_X_SERIES_CBUS_BITBANG_WR: u32 = 18;
pub const FT_X_SERIES_CBUS_BITBANG_RD: u32 = 19;
pub const FT_X_SERIES_CBUS_TIMESTAMP: u32 = 20;
pub const FT_X_SERIES_CBUS_KEEP_AWAKE: u32 = 21;
pub const FT_DRIVER_TYPE_D2XX: u32 = 0;
pub const FT_DRIVER_TYPE_VCP: u32 = 1;
pub type ULONG = ::std::os::raw::c_ulong;
pub type PULONG = *mut ULONG;
pub type USHORT = ::std::os::raw::c_ushort;
pub type UCHAR = ::std::os::raw::c_uchar;
pub type PUCHAR = *mut UCHAR;
pub type DWORD = ::std::os::raw::c_ulong;
pub type BOOL = ::std::os::raw::c_int;
pub type BYTE = ::std::os::raw::c_uchar;
pub type WORD = ::std::os::raw::c_ushort;
pub type LPWORD = *mut WORD;
pub type LPLONG = *mut ::std::os::raw::c_long;
pub type LPDWORD = *mut DWORD;
pub type LPVOID = *mut ::std::os::raw::c_void;
pub type UINT = ::std::os::raw::c_uint;
pub type ULONG_PTR = ::std::os::raw::c_ulonglong;
pub type PVOID = *mut ::std::os::raw::c_void;
pub type CHAR = ::std::os::raw::c_char;
pub type PCHAR = *mut CHAR;
pub type LPCSTR = *const CHAR;
pub type LPCTSTR = LPCSTR;
pub type HANDLE = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SECURITY_ATTRIBUTES {
    pub nLength: DWORD,
    pub lpSecurityDescriptor: LPVOID,
    pub bInheritHandle: BOOL,
}
#[test]
fn bindgen_test_layout__SECURITY_ATTRIBUTES() {
    assert_eq!(
        ::std::mem::size_of::<_SECURITY_ATTRIBUTES>(),
        24usize,
        concat!("Size of: ", stringify!(_SECURITY_ATTRIBUTES))
    );
    assert_eq!(
        ::std::mem::align_of::<_SECURITY_ATTRIBUTES>(),
        8usize,
        concat!("Alignment of ", stringify!(_SECURITY_ATTRIBUTES))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).nLength as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(nLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).lpSecurityDescriptor as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(lpSecurityDescriptor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).bInheritHandle as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(bInheritHandle)
        )
    );
}
impl Default for _SECURITY_ATTRIBUTES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type LPSECURITY_ATTRIBUTES = *mut _SECURITY_ATTRIBUTES;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _OVERLAPPED {
    pub Internal: ULONG_PTR,
    pub InternalHigh: ULONG_PTR,
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1,
    pub hEvent: HANDLE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _OVERLAPPED__bindgen_ty_1 {
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1__bindgen_ty_1,
    pub Pointer: PVOID,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _OVERLAPPED__bindgen_ty_1__bindgen_ty_1 {
    pub Offset: DWORD,
    pub OffsetHigh: DWORD,
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).Offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(Offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).OffsetHigh
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(OffsetHigh)
        )
    );
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1>())).Pointer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1),
            "::",
            stringify!(Pointer)
        )
    );
}
impl Default for _OVERLAPPED__bindgen_ty_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[test]
fn bindgen_test_layout__OVERLAPPED() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED>(),
        32usize,
        concat!("Size of: ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).Internal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(Internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).InternalHigh as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(InternalHigh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).hEvent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(hEvent)
        )
    );
}
impl Default for _OVERLAPPED {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type LPOVERLAPPED = *mut _OVERLAPPED;
pub type FT_HANDLE = PVOID;
pub type FT_STATUS = ULONG;
pub const FT_OK: ::std::os::raw::c_int = 0;
pub const FT_INVALID_HANDLE: ::std::os::raw::c_int = 1;
pub const FT_DEVICE_NOT_FOUND: ::std::os::raw::c_int = 2;
pub const FT_DEVICE_NOT_OPENED: ::std::os::raw::c_int = 3;
pub const FT_IO_ERROR: ::std::os::raw::c_int = 4;
pub const FT_INSUFFICIENT_RESOURCES: ::std::os::raw::c_int = 5;
pub const FT_INVALID_PARAMETER: ::std::os::raw::c_int = 6;
pub const FT_INVALID_BAUD_RATE: ::std::os::raw::c_int = 7;
pub const FT_DEVICE_NOT_OPENED_FOR_ERASE: ::std::os::raw::c_int = 8;
pub const FT_DEVICE_NOT_OPENED_FOR_WRITE: ::std::os::raw::c_int = 9;
pub const FT_FAILED_TO_WRITE_DEVICE: ::std::os::raw::c_int = 10;
pub const FT_EEPROM_READ_FAILED: ::std::os::raw::c_int = 11;
pub const FT_EEPROM_WRITE_FAILED: ::std::os::raw::c_int = 12;
pub const FT_EEPROM_ERASE_FAILED: ::std::os::raw::c_int = 13;
pub const FT_EEPROM_NOT_PRESENT: ::std::os::raw::c_int = 14;
pub const FT_EEPROM_NOT_PROGRAMMED: ::std::os::raw::c_int = 15;
pub const FT_INVALID_ARGS: ::std::os::raw::c_int = 16;
pub const FT_NOT_SUPPORTED: ::std::os::raw::c_int = 17;
pub const FT_OTHER_ERROR: ::std::os::raw::c_int = 18;
pub const FT_DEVICE_LIST_NOT_READY: ::std::os::raw::c_int = 19;
pub type _bindgen_ty_5 = ::std::os::raw::c_int;
pub type FT_DEVICE = ULONG;
pub const FT_DEVICE_BM: ::std::os::raw::c_int = 0;
pub const FT_DEVICE_AM: ::std::os::raw::c_int = 1;
pub const FT_DEVICE_100AX: ::std::os::raw::c_int = 2;
pub const FT_DEVICE_UNKNOWN: ::std::os::raw::c_int = 3;
pub const FT_DEVICE_2232C: ::std::os::raw::c_int = 4;
pub const FT_DEVICE_232R: ::std::os::raw::c_int = 5;
pub const FT_DEVICE_2232H: ::std::os::raw::c_int = 6;
pub const FT_DEVICE_4232H: ::std::os::raw::c_int = 7;
pub const FT_DEVICE_232H: ::std::os::raw::c_int = 8;
pub const FT_DEVICE_X_SERIES: ::std::os::raw::c_int = 9;
pub const FT_DEVICE_4222H_0: ::std::os::raw::c_int = 10;
pub const FT_DEVICE_4222H_1_2: ::std::os::raw::c_int = 11;
pub const FT_DEVICE_4222H_3: ::std::os::raw::c_int = 12;
pub const FT_DEVICE_4222_PROG: ::std::os::raw::c_int = 13;
pub const FT_DEVICE_900: ::std::os::raw::c_int = 14;
pub const FT_DEVICE_930: ::std::os::raw::c_int = 15;
pub const FT_DEVICE_UMFTPD3A: ::std::os::raw::c_int = 16;
pub const FT_DEVICE_2233HP: ::std::os::raw::c_int = 17;
pub const FT_DEVICE_4233HP: ::std::os::raw::c_int = 18;
pub const FT_DEVICE_2232HP: ::std::os::raw::c_int = 19;
pub const FT_DEVICE_4232HP: ::std::os::raw::c_int = 20;
pub const FT_DEVICE_233HP: ::std::os::raw::c_int = 21;
pub const FT_DEVICE_232HP: ::std::os::raw::c_int = 22;
pub const FT_DEVICE_2232HA: ::std::os::raw::c_int = 23;
pub const FT_DEVICE_4232HA: ::std::os::raw::c_int = 24;
pub const FT_DEVICE_232RN: ::std::os::raw::c_int = 25;
pub type _bindgen_ty_6 = ::std::os::raw::c_int;
extern "C" {
    pub fn FT_Open(deviceNumber: ::std::os::raw::c_int, pHandle: *mut FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_OpenEx(pArg1: PVOID, Flags: DWORD, pHandle: *mut FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ListDevices(pArg1: PVOID, pArg2: PVOID, Flags: DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_Close(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_Read(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        dwBytesToRead: DWORD,
        lpBytesReturned: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_Write(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        dwBytesToWrite: DWORD,
        lpBytesWritten: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_IoCtl(
        ftHandle: FT_HANDLE,
        dwIoControlCode: DWORD,
        lpInBuf: LPVOID,
        nInBufSize: DWORD,
        lpOutBuf: LPVOID,
        nOutBufSize: DWORD,
        lpBytesReturned: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetBaudRate(ftHandle: FT_HANDLE, BaudRate: ULONG) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetDivisor(ftHandle: FT_HANDLE, Divisor: USHORT) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetDataCharacteristics(
        ftHandle: FT_HANDLE,
        WordLength: UCHAR,
        StopBits: UCHAR,
        Parity: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetFlowControl(
        ftHandle: FT_HANDLE,
        FlowControl: USHORT,
        XonChar: UCHAR,
        XoffChar: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ResetDevice(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetDtr(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ClrDtr(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetRts(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ClrRts(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetModemStatus(ftHandle: FT_HANDLE, pModemStatus: *mut ULONG) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetChars(
        ftHandle: FT_HANDLE,
        EventChar: UCHAR,
        EventCharEnabled: UCHAR,
        ErrorChar: UCHAR,
        ErrorCharEnabled: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_Purge(ftHandle: FT_HANDLE, Mask: ULONG) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetTimeouts(
        ftHandle: FT_HANDLE,
        ReadTimeout: ULONG,
        WriteTimeout: ULONG,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetQueueStatus(ftHandle: FT_HANDLE, dwRxBytes: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetEventNotification(ftHandle: FT_HANDLE, Mask: DWORD, Param: PVOID) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetStatus(
        ftHandle: FT_HANDLE,
        dwRxBytes: *mut DWORD,
        dwTxBytes: *mut DWORD,
        dwEventDWord: *mut DWORD,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetBreakOn(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetBreakOff(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetWaitMask(ftHandle: FT_HANDLE, Mask: DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_WaitOnMask(ftHandle: FT_HANDLE, Mask: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetEventStatus(ftHandle: FT_HANDLE, dwEventDWord: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ReadEE(ftHandle: FT_HANDLE, dwWordOffset: DWORD, lpwValue: LPWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_WriteEE(ftHandle: FT_HANDLE, dwWordOffset: DWORD, wValue: WORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EraseEE(ftHandle: FT_HANDLE) -> FT_STATUS;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_program_data {
    pub Signature1: DWORD,
    pub Signature2: DWORD,
    pub Version: DWORD,
    pub VendorId: WORD,
    pub ProductId: WORD,
    pub Manufacturer: *mut ::std::os::raw::c_char,
    pub ManufacturerId: *mut ::std::os::raw::c_char,
    pub Description: *mut ::std::os::raw::c_char,
    pub SerialNumber: *mut ::std::os::raw::c_char,
    pub MaxPower: WORD,
    pub PnP: WORD,
    pub SelfPowered: WORD,
    pub RemoteWakeup: WORD,
    pub Rev4: UCHAR,
    pub IsoIn: UCHAR,
    pub IsoOut: UCHAR,
    pub PullDownEnable: UCHAR,
    pub SerNumEnable: UCHAR,
    pub USBVersionEnable: UCHAR,
    pub USBVersion: WORD,
    pub Rev5: UCHAR,
    pub IsoInA: UCHAR,
    pub IsoInB: UCHAR,
    pub IsoOutA: UCHAR,
    pub IsoOutB: UCHAR,
    pub PullDownEnable5: UCHAR,
    pub SerNumEnable5: UCHAR,
    pub USBVersionEnable5: UCHAR,
    pub USBVersion5: WORD,
    pub AIsHighCurrent: UCHAR,
    pub BIsHighCurrent: UCHAR,
    pub IFAIsFifo: UCHAR,
    pub IFAIsFifoTar: UCHAR,
    pub IFAIsFastSer: UCHAR,
    pub AIsVCP: UCHAR,
    pub IFBIsFifo: UCHAR,
    pub IFBIsFifoTar: UCHAR,
    pub IFBIsFastSer: UCHAR,
    pub BIsVCP: UCHAR,
    pub UseExtOsc: UCHAR,
    pub HighDriveIOs: UCHAR,
    pub EndpointSize: UCHAR,
    pub PullDownEnableR: UCHAR,
    pub SerNumEnableR: UCHAR,
    pub InvertTXD: UCHAR,
    pub InvertRXD: UCHAR,
    pub InvertRTS: UCHAR,
    pub InvertCTS: UCHAR,
    pub InvertDTR: UCHAR,
    pub InvertDSR: UCHAR,
    pub InvertDCD: UCHAR,
    pub InvertRI: UCHAR,
    pub Cbus0: UCHAR,
    pub Cbus1: UCHAR,
    pub Cbus2: UCHAR,
    pub Cbus3: UCHAR,
    pub Cbus4: UCHAR,
    pub RIsD2XX: UCHAR,
    pub PullDownEnable7: UCHAR,
    pub SerNumEnable7: UCHAR,
    pub ALSlowSlew: UCHAR,
    pub ALSchmittInput: UCHAR,
    pub ALDriveCurrent: UCHAR,
    pub AHSlowSlew: UCHAR,
    pub AHSchmittInput: UCHAR,
    pub AHDriveCurrent: UCHAR,
    pub BLSlowSlew: UCHAR,
    pub BLSchmittInput: UCHAR,
    pub BLDriveCurrent: UCHAR,
    pub BHSlowSlew: UCHAR,
    pub BHSchmittInput: UCHAR,
    pub BHDriveCurrent: UCHAR,
    pub IFAIsFifo7: UCHAR,
    pub IFAIsFifoTar7: UCHAR,
    pub IFAIsFastSer7: UCHAR,
    pub AIsVCP7: UCHAR,
    pub IFBIsFifo7: UCHAR,
    pub IFBIsFifoTar7: UCHAR,
    pub IFBIsFastSer7: UCHAR,
    pub BIsVCP7: UCHAR,
    pub PowerSaveEnable: UCHAR,
    pub PullDownEnable8: UCHAR,
    pub SerNumEnable8: UCHAR,
    pub ASlowSlew: UCHAR,
    pub ASchmittInput: UCHAR,
    pub ADriveCurrent: UCHAR,
    pub BSlowSlew: UCHAR,
    pub BSchmittInput: UCHAR,
    pub BDriveCurrent: UCHAR,
    pub CSlowSlew: UCHAR,
    pub CSchmittInput: UCHAR,
    pub CDriveCurrent: UCHAR,
    pub DSlowSlew: UCHAR,
    pub DSchmittInput: UCHAR,
    pub DDriveCurrent: UCHAR,
    pub ARIIsTXDEN: UCHAR,
    pub BRIIsTXDEN: UCHAR,
    pub CRIIsTXDEN: UCHAR,
    pub DRIIsTXDEN: UCHAR,
    pub AIsVCP8: UCHAR,
    pub BIsVCP8: UCHAR,
    pub CIsVCP8: UCHAR,
    pub DIsVCP8: UCHAR,
    pub PullDownEnableH: UCHAR,
    pub SerNumEnableH: UCHAR,
    pub ACSlowSlewH: UCHAR,
    pub ACSchmittInputH: UCHAR,
    pub ACDriveCurrentH: UCHAR,
    pub ADSlowSlewH: UCHAR,
    pub ADSchmittInputH: UCHAR,
    pub ADDriveCurrentH: UCHAR,
    pub Cbus0H: UCHAR,
    pub Cbus1H: UCHAR,
    pub Cbus2H: UCHAR,
    pub Cbus3H: UCHAR,
    pub Cbus4H: UCHAR,
    pub Cbus5H: UCHAR,
    pub Cbus6H: UCHAR,
    pub Cbus7H: UCHAR,
    pub Cbus8H: UCHAR,
    pub Cbus9H: UCHAR,
    pub IsFifoH: UCHAR,
    pub IsFifoTarH: UCHAR,
    pub IsFastSerH: UCHAR,
    pub IsFT1248H: UCHAR,
    pub FT1248CpolH: UCHAR,
    pub FT1248LsbH: UCHAR,
    pub FT1248FlowControlH: UCHAR,
    pub IsVCPH: UCHAR,
    pub PowerSaveEnableH: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_program_data() {
    assert_eq!(
        ::std::mem::size_of::<ft_program_data>(),
        176usize,
        concat!("Size of: ", stringify!(ft_program_data))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_program_data>(),
        8usize,
        concat!("Alignment of ", stringify!(ft_program_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Signature1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Signature1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Signature2 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Signature2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).VendorId as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(VendorId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ProductId as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ProductId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Manufacturer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Manufacturer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ManufacturerId as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ManufacturerId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Description as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerialNumber as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerialNumber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).MaxPower as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(MaxPower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PnP as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PnP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SelfPowered as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SelfPowered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).RemoteWakeup as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(RemoteWakeup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Rev4 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Rev4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoIn as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoIn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOut as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOut)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable as *const _ as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).USBVersionEnable as *const _ as usize
        },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersionEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).USBVersion as *const _ as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Rev5 as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Rev5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoInA as *const _ as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoInA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoInB as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoInB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOutA as *const _ as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOutA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOutB as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOutB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable5 as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable5 as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).USBVersionEnable5 as *const _ as usize
        },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersionEnable5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).USBVersion5 as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersion5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsHighCurrent as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsHighCurrent as *const _ as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifo as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifoTar as *const _ as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFastSer as *const _ as usize },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP as *const _ as usize },
        79usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifo as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifoTar as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFastSer as *const _ as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP as *const _ as usize },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).UseExtOsc as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(UseExtOsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).HighDriveIOs as *const _ as usize },
        85usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(HighDriveIOs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).EndpointSize as *const _ as usize },
        86usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(EndpointSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnableR as *const _ as usize },
        87usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnableR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnableR as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnableR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertTXD as *const _ as usize },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRXD as *const _ as usize },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRTS as *const _ as usize },
        91usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertCTS as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDTR as *const _ as usize },
        93usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDSR as *const _ as usize },
        94usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDCD as *const _ as usize },
        95usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRI as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus0 as *const _ as usize },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus1 as *const _ as usize },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus2 as *const _ as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus3 as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus4 as *const _ as usize },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).RIsD2XX as *const _ as usize },
        102usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(RIsD2XX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable7 as *const _ as usize },
        103usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable7 as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALSlowSlew as *const _ as usize },
        105usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALSchmittInput as *const _ as usize },
        106usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALDriveCurrent as *const _ as usize },
        107usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHSlowSlew as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHSchmittInput as *const _ as usize },
        109usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHDriveCurrent as *const _ as usize },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLSlowSlew as *const _ as usize },
        111usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLSchmittInput as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLDriveCurrent as *const _ as usize },
        113usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHSlowSlew as *const _ as usize },
        114usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHSchmittInput as *const _ as usize },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHDriveCurrent as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifo7 as *const _ as usize },
        117usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifo7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifoTar7 as *const _ as usize },
        118usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifoTar7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFastSer7 as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFastSer7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP7 as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifo7 as *const _ as usize },
        121usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifo7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifoTar7 as *const _ as usize },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifoTar7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFastSer7 as *const _ as usize },
        123usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFastSer7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP7 as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PowerSaveEnable as *const _ as usize },
        125usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable8 as *const _ as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable8 as *const _ as usize },
        127usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ASlowSlew as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ASlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ASchmittInput as *const _ as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ASchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADriveCurrent as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BSlowSlew as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BSchmittInput as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BDriveCurrent as *const _ as usize },
        133usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CSlowSlew as *const _ as usize },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CSchmittInput as *const _ as usize },
        135usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CDriveCurrent as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DSlowSlew as *const _ as usize },
        137usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DSchmittInput as *const _ as usize },
        138usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DDriveCurrent as *const _ as usize },
        139usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ARIIsTXDEN as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ARIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BRIIsTXDEN as *const _ as usize },
        141usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CRIIsTXDEN as *const _ as usize },
        142usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DRIIsTXDEN as *const _ as usize },
        143usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP8 as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP8 as *const _ as usize },
        145usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CIsVCP8 as *const _ as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DIsVCP8 as *const _ as usize },
        147usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnableH as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnableH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnableH as *const _ as usize },
        149usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnableH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACSlowSlewH as *const _ as usize },
        150usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACSlowSlewH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACSchmittInputH as *const _ as usize },
        151usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACSchmittInputH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACDriveCurrentH as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACDriveCurrentH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADSlowSlewH as *const _ as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADSlowSlewH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADSchmittInputH as *const _ as usize },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADSchmittInputH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADDriveCurrentH as *const _ as usize },
        155usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADDriveCurrentH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus0H as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus0H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus1H as *const _ as usize },
        157usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus1H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus2H as *const _ as usize },
        158usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus2H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus3H as *const _ as usize },
        159usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus3H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus4H as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus4H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus5H as *const _ as usize },
        161usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus5H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus6H as *const _ as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus6H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus7H as *const _ as usize },
        163usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus7H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus8H as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus8H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus9H as *const _ as usize },
        165usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus9H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFifoH as *const _ as usize },
        166usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFifoH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFifoTarH as *const _ as usize },
        167usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFifoTarH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFastSerH as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFastSerH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFT1248H as *const _ as usize },
        169usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFT1248H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).FT1248CpolH as *const _ as usize },
        170usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248CpolH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).FT1248LsbH as *const _ as usize },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248LsbH)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).FT1248FlowControlH as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248FlowControlH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsVCPH as *const _ as usize },
        173usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsVCPH)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).PowerSaveEnableH as *const _ as usize
        },
        174usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PowerSaveEnableH)
        )
    );
}
impl Default for ft_program_data {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type FT_PROGRAM_DATA = ft_program_data;
pub type PFT_PROGRAM_DATA = *mut ft_program_data;
extern "C" {
    pub fn FT_EE_Program(ftHandle: FT_HANDLE, pData: PFT_PROGRAM_DATA) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_ProgramEx(
        ftHandle: FT_HANDLE,
        pData: PFT_PROGRAM_DATA,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_Read(ftHandle: FT_HANDLE, pData: PFT_PROGRAM_DATA) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_ReadEx(
        ftHandle: FT_HANDLE,
        pData: PFT_PROGRAM_DATA,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_UASize(ftHandle: FT_HANDLE, lpdwSize: LPDWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_UAWrite(ftHandle: FT_HANDLE, pucData: PUCHAR, dwDataLen: DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_UARead(
        ftHandle: FT_HANDLE,
        pucData: PUCHAR,
        dwDataLen: DWORD,
        lpdwBytesRead: LPDWORD,
    ) -> FT_STATUS;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_header {
    pub deviceType: FT_DEVICE,
    pub VendorId: WORD,
    pub ProductId: WORD,
    pub SerNumEnable: UCHAR,
    pub MaxPower: WORD,
    pub SelfPowered: UCHAR,
    pub RemoteWakeup: UCHAR,
    pub PullDownEnable: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_header() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_header>(),
        16usize,
        concat!("Size of: ", stringify!(ft_eeprom_header))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_header>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).deviceType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(deviceType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).VendorId as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(VendorId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).ProductId as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(ProductId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).SerNumEnable as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(SerNumEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).MaxPower as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(MaxPower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).SelfPowered as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(SelfPowered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).RemoteWakeup as *const _ as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(RemoteWakeup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).PullDownEnable as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(PullDownEnable)
        )
    );
}
pub type FT_EEPROM_HEADER = ft_eeprom_header;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_232b {
    pub common: FT_EEPROM_HEADER,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232b() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232b>(),
        16usize,
        concat!("Size of: ", stringify!(ft_eeprom_232b))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232b>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232b))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232b>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232b),
            "::",
            stringify!(common)
        )
    );
}
pub type FT_EEPROM_232B = ft_eeprom_232b;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_2232 {
    pub common: FT_EEPROM_HEADER,
    pub AIsHighCurrent: UCHAR,
    pub BIsHighCurrent: UCHAR,
    pub AIsFifo: UCHAR,
    pub AIsFifoTar: UCHAR,
    pub AIsFastSer: UCHAR,
    pub BIsFifo: UCHAR,
    pub BIsFifoTar: UCHAR,
    pub BIsFastSer: UCHAR,
    pub ADriverType: UCHAR,
    pub BDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_2232() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_2232>(),
        28usize,
        concat!("Size of: ", stringify!(ft_eeprom_2232))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_2232>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_2232))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsHighCurrent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsHighCurrent as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFifo as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFifoTar as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFastSer as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFifo as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFifoTar as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFastSer as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).ADriverType as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BDriverType as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BDriverType)
        )
    );
}
pub type FT_EEPROM_2232 = ft_eeprom_2232;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_232r {
    pub common: FT_EEPROM_HEADER,
    pub IsHighCurrent: UCHAR,
    pub UseExtOsc: UCHAR,
    pub InvertTXD: UCHAR,
    pub InvertRXD: UCHAR,
    pub InvertRTS: UCHAR,
    pub InvertCTS: UCHAR,
    pub InvertDTR: UCHAR,
    pub InvertDSR: UCHAR,
    pub InvertDCD: UCHAR,
    pub InvertRI: UCHAR,
    pub Cbus0: UCHAR,
    pub Cbus1: UCHAR,
    pub Cbus2: UCHAR,
    pub Cbus3: UCHAR,
    pub Cbus4: UCHAR,
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232r() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232r>(),
        32usize,
        concat!("Size of: ", stringify!(ft_eeprom_232r))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232r>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232r))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).IsHighCurrent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(IsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).UseExtOsc as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(UseExtOsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertTXD as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRXD as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRTS as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertCTS as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDTR as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDSR as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDCD as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRI as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus0 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus1 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus2 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus3 as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus4 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).DriverType as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(DriverType)
        )
    );
}
pub type FT_EEPROM_232R = ft_eeprom_232r;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_2232h {
    pub common: FT_EEPROM_HEADER,
    pub ALSlowSlew: UCHAR,
    pub ALSchmittInput: UCHAR,
    pub ALDriveCurrent: UCHAR,
    pub AHSlowSlew: UCHAR,
    pub AHSchmittInput: UCHAR,
    pub AHDriveCurrent: UCHAR,
    pub BLSlowSlew: UCHAR,
    pub BLSchmittInput: UCHAR,
    pub BLDriveCurrent: UCHAR,
    pub BHSlowSlew: UCHAR,
    pub BHSchmittInput: UCHAR,
    pub BHDriveCurrent: UCHAR,
    pub AIsFifo: UCHAR,
    pub AIsFifoTar: UCHAR,
    pub AIsFastSer: UCHAR,
    pub BIsFifo: UCHAR,
    pub BIsFifoTar: UCHAR,
    pub BIsFastSer: UCHAR,
    pub PowerSaveEnable: UCHAR,
    pub ADriverType: UCHAR,
    pub BDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_2232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_2232h>(),
        40usize,
        concat!("Size of: ", stringify!(ft_eeprom_2232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_2232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_2232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALSchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALDriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLSlowSlew as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLSchmittInput as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLDriveCurrent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHSlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHSchmittInput as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHDriveCurrent as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFifo as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFifoTar as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFastSer as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFifo as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFifoTar as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFastSer as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).PowerSaveEnable as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ADriverType as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BDriverType as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BDriverType)
        )
    );
}
pub type FT_EEPROM_2232H = ft_eeprom_2232h;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_4232h {
    pub common: FT_EEPROM_HEADER,
    pub ASlowSlew: UCHAR,
    pub ASchmittInput: UCHAR,
    pub ADriveCurrent: UCHAR,
    pub BSlowSlew: UCHAR,
    pub BSchmittInput: UCHAR,
    pub BDriveCurrent: UCHAR,
    pub CSlowSlew: UCHAR,
    pub CSchmittInput: UCHAR,
    pub CDriveCurrent: UCHAR,
    pub DSlowSlew: UCHAR,
    pub DSchmittInput: UCHAR,
    pub DDriveCurrent: UCHAR,
    pub ARIIsTXDEN: UCHAR,
    pub BRIIsTXDEN: UCHAR,
    pub CRIIsTXDEN: UCHAR,
    pub DRIIsTXDEN: UCHAR,
    pub ADriverType: UCHAR,
    pub BDriverType: UCHAR,
    pub CDriverType: UCHAR,
    pub DDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_4232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_4232h>(),
        36usize,
        concat!("Size of: ", stringify!(ft_eeprom_4232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_4232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_4232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ASlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ASlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ASchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ASchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ADriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ADriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CSlowSlew as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CSchmittInput as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CDriveCurrent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DSlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DSchmittInput as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DDriveCurrent as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ARIIsTXDEN as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ARIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BRIIsTXDEN as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CRIIsTXDEN as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DRIIsTXDEN as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ADriverType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BDriverType as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BDriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CDriverType as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CDriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DDriverType as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DDriverType)
        )
    );
}
pub type FT_EEPROM_4232H = ft_eeprom_4232h;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_232h {
    pub common: FT_EEPROM_HEADER,
    pub ACSlowSlew: UCHAR,
    pub ACSchmittInput: UCHAR,
    pub ACDriveCurrent: UCHAR,
    pub ADSlowSlew: UCHAR,
    pub ADSchmittInput: UCHAR,
    pub ADDriveCurrent: UCHAR,
    pub Cbus0: UCHAR,
    pub Cbus1: UCHAR,
    pub Cbus2: UCHAR,
    pub Cbus3: UCHAR,
    pub Cbus4: UCHAR,
    pub Cbus5: UCHAR,
    pub Cbus6: UCHAR,
    pub Cbus7: UCHAR,
    pub Cbus8: UCHAR,
    pub Cbus9: UCHAR,
    pub FT1248Cpol: UCHAR,
    pub FT1248Lsb: UCHAR,
    pub FT1248FlowControl: UCHAR,
    pub IsFifo: UCHAR,
    pub IsFifoTar: UCHAR,
    pub IsFastSer: UCHAR,
    pub IsFT1248: UCHAR,
    pub PowerSaveEnable: UCHAR,
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232h>(),
        44usize,
        concat!("Size of: ", stringify!(ft_eeprom_232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACSchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACDriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus0 as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus1 as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus3 as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus4 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus5 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus7 as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus8 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus9 as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248Cpol as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248Cpol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248Lsb as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248Lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248FlowControl as *const _ as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248FlowControl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFifo as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFifoTar as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFastSer as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFT1248 as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFT1248)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).PowerSaveEnable as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).DriverType as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(DriverType)
        )
    );
}
pub type FT_EEPROM_232H = ft_eeprom_232h;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_x_series {
    pub common: FT_EEPROM_HEADER,
    pub ACSlowSlew: UCHAR,
    pub ACSchmittInput: UCHAR,
    pub ACDriveCurrent: UCHAR,
    pub ADSlowSlew: UCHAR,
    pub ADSchmittInput: UCHAR,
    pub ADDriveCurrent: UCHAR,
    pub Cbus0: UCHAR,
    pub Cbus1: UCHAR,
    pub Cbus2: UCHAR,
    pub Cbus3: UCHAR,
    pub Cbus4: UCHAR,
    pub Cbus5: UCHAR,
    pub Cbus6: UCHAR,
    pub InvertTXD: UCHAR,
    pub InvertRXD: UCHAR,
    pub InvertRTS: UCHAR,
    pub InvertCTS: UCHAR,
    pub InvertDTR: UCHAR,
    pub InvertDSR: UCHAR,
    pub InvertDCD: UCHAR,
    pub InvertRI: UCHAR,
    pub BCDEnable: UCHAR,
    pub BCDForceCbusPWREN: UCHAR,
    pub BCDDisableSleep: UCHAR,
    pub I2CSlaveAddress: WORD,
    pub I2CDeviceId: DWORD,
    pub I2CDisableSchmitt: UCHAR,
    pub FT1248Cpol: UCHAR,
    pub FT1248Lsb: UCHAR,
    pub FT1248FlowControl: UCHAR,
    pub RS485EchoSuppress: UCHAR,
    pub PowerSaveEnable: UCHAR,
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_x_series() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_x_series>(),
        56usize,
        concat!("Size of: ", stringify!(ft_eeprom_x_series))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_x_series>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_x_series))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACSlowSlew)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACSchmittInput as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACSchmittInput)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACDriveCurrent as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADSlowSlew)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADSchmittInput as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADSchmittInput)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADDriveCurrent as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus0 as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus1 as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus3 as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus4 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus5 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertTXD as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRXD as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRTS as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertCTS as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDTR as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDSR as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDCD as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRI as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDEnable as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDForceCbusPWREN as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDForceCbusPWREN)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDDisableSleep as *const _ as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDDisableSleep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CSlaveAddress as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CSlaveAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CDeviceId as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CDeviceId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CDisableSchmitt as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CDisableSchmitt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248Cpol as *const _ as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248Cpol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248Lsb as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248Lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248FlowControl as *const _ as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248FlowControl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).RS485EchoSuppress as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(RS485EchoSuppress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).PowerSaveEnable as *const _ as usize
        },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).DriverType as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(DriverType)
        )
    );
}
pub type FT_EEPROM_X_SERIES = ft_eeprom_x_series;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_4222h {
    pub common: FT_EEPROM_HEADER,
    pub Revision: CHAR,
    pub I2C_Slave_Address: UCHAR,
    pub SPISuspend: UCHAR,
    pub SuspendOutPol: UCHAR,
    pub EnableSuspendOut: UCHAR,
    pub Clock_SlowSlew: UCHAR,
    pub Clock_Drive: UCHAR,
    pub IO0_SlowSlew: UCHAR,
    pub IO1_SlowSlew: UCHAR,
    pub IO2_SlowSlew: UCHAR,
    pub IO3_SlowSlew: UCHAR,
    pub IO_Drive: UCHAR,
    pub SlaveSelect_PullUp: UCHAR,
    pub SlaveSelect_PullDown: UCHAR,
    pub SlaveSelect_Drive: UCHAR,
    pub SlaveSelect_SlowSlew: UCHAR,
    pub MISO_Suspend: UCHAR,
    pub SIMO_Suspend: UCHAR,
    pub IO2_IO3_Suspend: UCHAR,
    pub SlaveSelect_Suspend: UCHAR,
    pub GPIO0_Drive: UCHAR,
    pub GPIO1_Drive: UCHAR,
    pub GPIO2_Drive: UCHAR,
    pub GPIO3_Drive: UCHAR,
    pub GPIO0_SlowSlew: UCHAR,
    pub GPIO1_SlowSlew: UCHAR,
    pub GPIO2_SlowSlew: UCHAR,
    pub GPIO3_SlowSlew: UCHAR,
    pub GPIO0_PullDown: UCHAR,
    pub GPIO1_PullDown: UCHAR,
    pub GPIO2_PullDown: UCHAR,
    pub GPIO3_PullDown: UCHAR,
    pub GPIO0_PullUp: UCHAR,
    pub GPIO1_PullUp: UCHAR,
    pub GPIO2_PullUp: UCHAR,
    pub GPIO3_PullUp: UCHAR,
    pub GPIO0_OpenDrain: UCHAR,
    pub GPIO1_OpenDrain: UCHAR,
    pub GPIO2_OpenDrain: UCHAR,
    pub GPIO3_OpenDrain: UCHAR,
    pub GPIO0_Suspend: UCHAR,
    pub GPIO1_Suspend: UCHAR,
    pub GPIO2_Suspend: UCHAR,
    pub GPIO3_Suspend: UCHAR,
    pub FallingEdge: UCHAR,
    pub BCD_Disable: UCHAR,
    pub BCD_OutputActiveLow: UCHAR,
    pub BCD_Drive: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_4222h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_4222h>(),
        64usize,
        concat!("Size of: ", stringify!(ft_eeprom_4222h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_4222h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_4222h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Revision as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Revision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).I2C_Slave_Address as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(I2C_Slave_Address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SPISuspend as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SPISuspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SuspendOutPol as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SuspendOutPol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).EnableSuspendOut as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(EnableSuspendOut)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Clock_SlowSlew as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Clock_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Clock_Drive as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Clock_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO0_SlowSlew as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO0_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO1_SlowSlew as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO1_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO2_SlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO2_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO3_SlowSlew as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO3_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO_Drive as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO_Drive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_PullUp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_PullUp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_PullDown as *const _ as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_PullDown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_Drive as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_Drive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_SlowSlew as *const _ as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).MISO_Suspend as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(MISO_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SIMO_Suspend as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SIMO_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO2_IO3_Suspend as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO2_IO3_Suspend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_Suspend as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_Drive as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_Drive as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_Drive as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_Drive as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_SlowSlew as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_SlowSlew as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_SlowSlew as *const _ as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_SlowSlew as *const _ as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_PullDown as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_PullDown as *const _ as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_PullDown as *const _ as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_PullDown as *const _ as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_PullUp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_PullUp as *const _ as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_PullUp as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_PullUp as *const _ as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_OpenDrain as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_OpenDrain as *const _ as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_OpenDrain as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_OpenDrain as *const _ as usize },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_Suspend as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_Suspend as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_Suspend as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_Suspend as *const _ as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).FallingEdge as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(FallingEdge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_Disable as *const _ as usize },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_Disable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_OutputActiveLow as *const _ as usize
        },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_OutputActiveLow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_Drive as *const _ as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_Drive)
        )
    );
}
pub type FT_EEPROM_4222H = ft_eeprom_4222h;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_PD_PDO_mv_ma {
    pub PDO1ma: USHORT,
    pub PDO1mv: USHORT,
    pub PDO2ma: USHORT,
    pub PDO2mv: USHORT,
    pub PDO3ma: USHORT,
    pub PDO3mv: USHORT,
    pub PDO4ma: USHORT,
    pub PDO4mv: USHORT,
    pub PDO5ma: USHORT,
    pub PDO5mv: USHORT,
    pub PDO6ma: USHORT,
    pub PDO6mv: USHORT,
    pub PDO7ma: USHORT,
    pub PDO7mv: USHORT,
}
#[test]
fn bindgen_test_layout_ft_eeprom_PD_PDO_mv_ma() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_PD_PDO_mv_ma>(),
        28usize,
        concat!("Size of: ", stringify!(ft_eeprom_PD_PDO_mv_ma))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_PD_PDO_mv_ma>(),
        2usize,
        concat!("Alignment of ", stringify!(ft_eeprom_PD_PDO_mv_ma))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO1ma as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO1ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO1mv as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO1mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO2ma as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO2ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO2mv as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO2mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO3ma as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO3ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO3mv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO3mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO4ma as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO4ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO4mv as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO4mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO5ma as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO5ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO5mv as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO5mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO6ma as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO6ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO6mv as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO6mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO7ma as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO7ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO7mv as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO7mv)
        )
    );
}
pub type FT_EEPROM_PD_PDO_mv_ma = ft_eeprom_PD_PDO_mv_ma;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ft_eeprom_pd {
    pub srprs: UCHAR,
    pub sraprs: UCHAR,
    pub srrprs: UCHAR,
    pub saprs: UCHAR,
    pub vconns: UCHAR,
    pub passthru: UCHAR,
    pub extmcu: UCHAR,
    pub pd2en: UCHAR,
    pub pd1autoclk: UCHAR,
    pub pd2autoclk: UCHAR,
    pub useefuse: UCHAR,
    pub extvconn: UCHAR,
    pub count: UCHAR,
    pub gpio1: UCHAR,
    pub gpio2: UCHAR,
    pub gpio3: UCHAR,
    pub gpio4: UCHAR,
    pub gpio5: UCHAR,
    pub gpio6: UCHAR,
    pub gpio7: UCHAR,
    pub pd1lden: UCHAR,
    pub pd2lden: UCHAR,
    pub dispin: UCHAR,
    pub disenbm: UCHAR,
    pub disdisbm: UCHAR,
    pub ccselect: UCHAR,
    pub iset1: UCHAR,
    pub iset2: UCHAR,
    pub iset3: UCHAR,
    pub extiset: UCHAR,
    pub isetpd2: UCHAR,
    pub iseten: UCHAR,
    pub PDO1_GPIO: [UCHAR; 7usize],
    pub PDO2_GPIO: [UCHAR; 7usize],
    pub PDO3_GPIO: [UCHAR; 7usize],
    pub PDO4_GPIO: [UCHAR; 7usize],
    pub PDO5_GPIO: [UCHAR; 7usize],
    pub PDO6_GPIO: [UCHAR; 7usize],
    pub PDO7_GPIO: [UCHAR; 7usize],
    pub VSET0V_GPIO: [UCHAR; 7usize],
    pub VSAFE5V_GPIO: [UCHAR; 7usize],
    pub BM_PDO_Sink: FT_EEPROM_PD_PDO_mv_ma,
    pub BM_PDO_Source: FT_EEPROM_PD_PDO_mv_ma,
    pub BM_PDO_Sink_2: FT_EEPROM_PD_PDO_mv_ma,
    pub srt: UCHAR,
    pub hrt: UCHAR,
    pub sct: UCHAR,
    pub dit: UCHAR,
    pub srcrt: USHORT,
    pub trt: USHORT,
    pub sofft: USHORT,
    pub nrt: USHORT,
    pub swct: USHORT,
    pub snkrt: USHORT,
    pub dt: UCHAR,
    pub cnst: UCHAR,
    pub it: USHORT,
    pub i2caddr: UCHAR,
    pub prou: UINT,
    pub trim1: UINT,
    pub trim2: UINT,
    pub extdc: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_pd() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_pd>(),
        220usize,
        concat!("Size of: ", stringify!(ft_eeprom_pd))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_pd>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_pd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srprs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sraprs as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sraprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srrprs as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srrprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).saprs as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(saprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).vconns as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(vconns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).passthru as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(passthru)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extmcu as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extmcu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2en as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2en)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd1autoclk as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd1autoclk)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2autoclk as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2autoclk)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).useefuse as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(useefuse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extvconn as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extvconn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).count as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio1 as *const _ as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio2 as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio3 as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio4 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio5 as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio6 as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio7 as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd1lden as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd1lden)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2lden as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2lden)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dispin as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dispin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).disenbm as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(disenbm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).disdisbm as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(disdisbm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).ccselect as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(ccselect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset1 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset2 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset3 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extiset as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extiset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).isetpd2 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(isetpd2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iseten as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iseten)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO1_GPIO as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO1_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO2_GPIO as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO2_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO3_GPIO as *const _ as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO3_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO4_GPIO as *const _ as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO4_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO5_GPIO as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO5_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO6_GPIO as *const _ as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO6_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO7_GPIO as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO7_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).VSET0V_GPIO as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(VSET0V_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).VSAFE5V_GPIO as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(VSAFE5V_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Sink as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Sink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Source as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Sink_2 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Sink_2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srt as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).hrt as *const _ as usize },
        181usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(hrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sct as *const _ as usize },
        182usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dit as *const _ as usize },
        183usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srcrt as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srcrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trt as *const _ as usize },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sofft as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sofft)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).nrt as *const _ as usize },
        190usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(nrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).swct as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(swct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).snkrt as *const _ as usize },
        194usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(snkrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dt as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).cnst as *const _ as usize },
        197usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(cnst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).it as *const _ as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(it)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).i2caddr as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(i2caddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).prou as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(prou)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trim1 as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trim1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trim2 as *const _ as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trim2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extdc as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extdc)
        )
    );
}
pub type FT_EEPROM_PD = ft_eeprom_pd;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_2233hp {
    pub ft2232h: FT_EEPROM_2232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_2233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_2233hp>(),
        260usize,
        concat!("Size of: ", stringify!(_ft_eeprom_2233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_2233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_2233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2233hp>())).ft2232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2233hp),
            "::",
            stringify!(ft2232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2233hp>())).pd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2233hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_2233HP = _ft_eeprom_2233hp;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_4233hp {
    pub ft4232h: FT_EEPROM_4232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_4233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_4233hp>(),
        256usize,
        concat!("Size of: ", stringify!(_ft_eeprom_4233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_4233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_4233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4233hp>())).ft4232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4233hp),
            "::",
            stringify!(ft4232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4233hp>())).pd as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4233hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_4233HP = _ft_eeprom_4233hp;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_2232hp {
    pub ft2232h: FT_EEPROM_2232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_2232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_2232hp>(),
        260usize,
        concat!("Size of: ", stringify!(_ft_eeprom_2232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_2232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_2232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2232hp>())).ft2232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2232hp),
            "::",
            stringify!(ft2232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2232hp>())).pd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2232hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_2232HP = _ft_eeprom_2232hp;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_4232hp {
    pub ft4232h: FT_EEPROM_4232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_4232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_4232hp>(),
        256usize,
        concat!("Size of: ", stringify!(_ft_eeprom_4232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_4232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_4232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4232hp>())).ft4232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4232hp),
            "::",
            stringify!(ft4232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4232hp>())).pd as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4232hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_4232HP = _ft_eeprom_4232hp;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_233hp {
    pub ft232h: FT_EEPROM_232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_233hp>(),
        264usize,
        concat!("Size of: ", stringify!(_ft_eeprom_233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_233hp>())).ft232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_233hp),
            "::",
            stringify!(ft232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_233hp>())).pd as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_233hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_233HP = _ft_eeprom_233hp;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _ft_eeprom_232hp {
    pub ft232h: FT_EEPROM_232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_232hp>(),
        264usize,
        concat!("Size of: ", stringify!(_ft_eeprom_232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_232hp>())).ft232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_232hp),
            "::",
            stringify!(ft232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_232hp>())).pd as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_232hp),
            "::",
            stringify!(pd)
        )
    );
}
pub type FT_EEPROM_232HP = _ft_eeprom_232hp;
extern "C" {
    pub fn FT_EEPROM_Read(
        ftHandle: FT_HANDLE,
        eepromData: *mut ::std::os::raw::c_void,
        eepromDataSize: DWORD,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EEPROM_Program(
        ftHandle: FT_HANDLE,
        eepromData: *mut ::std::os::raw::c_void,
        eepromDataSize: DWORD,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetLatencyTimer(ftHandle: FT_HANDLE, ucLatency: UCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetLatencyTimer(ftHandle: FT_HANDLE, pucLatency: PUCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetBitMode(ftHandle: FT_HANDLE, ucMask: UCHAR, ucEnable: UCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetBitMode(ftHandle: FT_HANDLE, pucMode: PUCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetUSBParameters(
        ftHandle: FT_HANDLE,
        ulInTransferSize: ULONG,
        ulOutTransferSize: ULONG,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetDeadmanTimeout(ftHandle: FT_HANDLE, ulDeadmanTimeout: ULONG) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetDeviceInfo(
        ftHandle: FT_HANDLE,
        lpftDevice: *mut FT_DEVICE,
        lpdwID: LPDWORD,
        SerialNumber: PCHAR,
        Description: PCHAR,
        Dummy: LPVOID,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_StopInTask(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_RestartInTask(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_SetResetPipeRetryCount(ftHandle: FT_HANDLE, dwCount: DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ResetPort(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_CyclePort(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_W32_CreateFile(
        lpszName: LPCTSTR,
        dwAccess: DWORD,
        dwShareMode: DWORD,
        lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
        dwCreate: DWORD,
        dwAttrsAndFlags: DWORD,
        hTemplate: HANDLE,
    ) -> FT_HANDLE;
}
extern "C" {
    pub fn FT_W32_CloseHandle(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    pub fn FT_W32_ReadFile(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        nBufferSize: DWORD,
        lpBytesReturned: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
extern "C" {
    pub fn FT_W32_WriteFile(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        nBufferSize: DWORD,
        lpBytesWritten: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
extern "C" {
    pub fn FT_W32_GetLastError(ftHandle: FT_HANDLE) -> DWORD;
}
extern "C" {
    pub fn FT_W32_GetOverlappedResult(
        ftHandle: FT_HANDLE,
        lpOverlapped: LPOVERLAPPED,
        lpdwBytesTransferred: LPDWORD,
        bWait: BOOL,
    ) -> BOOL;
}
extern "C" {
    pub fn FT_W32_CancelIo(ftHandle: FT_HANDLE) -> BOOL;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _FTCOMSTAT {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub cbInQue: DWORD,
    pub cbOutQue: DWORD,
}
#[test]
fn bindgen_test_layout__FTCOMSTAT() {
    assert_eq!(
        ::std::mem::size_of::<_FTCOMSTAT>(),
        12usize,
        concat!("Size of: ", stringify!(_FTCOMSTAT))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTCOMSTAT>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTCOMSTAT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTCOMSTAT>())).cbInQue as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTCOMSTAT),
            "::",
            stringify!(cbInQue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTCOMSTAT>())).cbOutQue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTCOMSTAT),
            "::",
            stringify!(cbOutQue)
        )
    );
}
impl _FTCOMSTAT {
    #[inline]
    pub fn fCtsHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fCtsHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDsrHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fDsrHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fRlsdHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fRlsdHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fXoffHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fXoffHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fXoffSent(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fXoffSent(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fEof(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fEof(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fTxim(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fTxim(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fReserved(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set_fReserved(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fCtsHold: DWORD,
        fDsrHold: DWORD,
        fRlsdHold: DWORD,
        fXoffHold: DWORD,
        fXoffSent: DWORD,
        fEof: DWORD,
        fTxim: DWORD,
        fReserved: DWORD,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fCtsHold: u32 = unsafe { ::std::mem::transmute(fCtsHold) };
            fCtsHold as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fDsrHold: u32 = unsafe { ::std::mem::transmute(fDsrHold) };
            fDsrHold as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fRlsdHold: u32 = unsafe { ::std::mem::transmute(fRlsdHold) };
            fRlsdHold as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fXoffHold: u32 = unsafe { ::std::mem::transmute(fXoffHold) };
            fXoffHold as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let fXoffSent: u32 = unsafe { ::std::mem::transmute(fXoffSent) };
            fXoffSent as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let fEof: u32 = unsafe { ::std::mem::transmute(fEof) };
            fEof as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let fTxim: u32 = unsafe { ::std::mem::transmute(fTxim) };
            fTxim as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let fReserved: u32 = unsafe { ::std::mem::transmute(fReserved) };
            fReserved as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type LPFTCOMSTAT = *mut _FTCOMSTAT;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _FTDCB {
    pub DCBlength: DWORD,
    pub BaudRate: DWORD,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub wReserved: WORD,
    pub XonLim: WORD,
    pub XoffLim: WORD,
    pub ByteSize: BYTE,
    pub Parity: BYTE,
    pub StopBits: BYTE,
    pub XonChar: ::std::os::raw::c_char,
    pub XoffChar: ::std::os::raw::c_char,
    pub ErrorChar: ::std::os::raw::c_char,
    pub EofChar: ::std::os::raw::c_char,
    pub EvtChar: ::std::os::raw::c_char,
    pub wReserved1: WORD,
}
#[test]
fn bindgen_test_layout__FTDCB() {
    assert_eq!(
        ::std::mem::size_of::<_FTDCB>(),
        28usize,
        concat!("Size of: ", stringify!(_FTDCB))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTDCB>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTDCB))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).DCBlength as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(DCBlength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).BaudRate as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(BaudRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).wReserved as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(wReserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XonLim as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XonLim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XoffLim as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XoffLim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).ByteSize as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(ByteSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).Parity as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(Parity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).StopBits as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(StopBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XonChar as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XonChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XoffChar as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XoffChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).ErrorChar as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(ErrorChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).EofChar as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(EofChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).EvtChar as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(EvtChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).wReserved1 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(wReserved1)
        )
    );
}
impl _FTDCB {
    #[inline]
    pub fn fBinary(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fBinary(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fParity(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fParity(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutxCtsFlow(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutxCtsFlow(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutxDsrFlow(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutxDsrFlow(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDtrControl(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fDtrControl(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn fDsrSensitivity(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fDsrSensitivity(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fTXContinueOnXoff(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fTXContinueOnXoff(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutX(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutX(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fInX(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fInX(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fErrorChar(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fErrorChar(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fNull(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fNull(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fRtsControl(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fRtsControl(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn fAbortOnError(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fAbortOnError(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDummy2(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 17u8) as u32) }
    }
    #[inline]
    pub fn set_fDummy2(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 17u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fBinary: DWORD,
        fParity: DWORD,
        fOutxCtsFlow: DWORD,
        fOutxDsrFlow: DWORD,
        fDtrControl: DWORD,
        fDsrSensitivity: DWORD,
        fTXContinueOnXoff: DWORD,
        fOutX: DWORD,
        fInX: DWORD,
        fErrorChar: DWORD,
        fNull: DWORD,
        fRtsControl: DWORD,
        fAbortOnError: DWORD,
        fDummy2: DWORD,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fBinary: u32 = unsafe { ::std::mem::transmute(fBinary) };
            fBinary as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fParity: u32 = unsafe { ::std::mem::transmute(fParity) };
            fParity as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fOutxCtsFlow: u32 = unsafe { ::std::mem::transmute(fOutxCtsFlow) };
            fOutxCtsFlow as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fOutxDsrFlow: u32 = unsafe { ::std::mem::transmute(fOutxDsrFlow) };
            fOutxDsrFlow as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let fDtrControl: u32 = unsafe { ::std::mem::transmute(fDtrControl) };
            fDtrControl as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let fDsrSensitivity: u32 = unsafe { ::std::mem::transmute(fDsrSensitivity) };
            fDsrSensitivity as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let fTXContinueOnXoff: u32 = unsafe { ::std::mem::transmute(fTXContinueOnXoff) };
            fTXContinueOnXoff as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fOutX: u32 = unsafe { ::std::mem::transmute(fOutX) };
            fOutX as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let fInX: u32 = unsafe { ::std::mem::transmute(fInX) };
            fInX as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let fErrorChar: u32 = unsafe { ::std::mem::transmute(fErrorChar) };
            fErrorChar as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let fNull: u32 = unsafe { ::std::mem::transmute(fNull) };
            fNull as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let fRtsControl: u32 = unsafe { ::std::mem::transmute(fRtsControl) };
            fRtsControl as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let fAbortOnError: u32 = unsafe { ::std::mem::transmute(fAbortOnError) };
            fAbortOnError as u64
        });
        __bindgen_bitfield_unit.set(15usize, 17u8, {
            let fDummy2: u32 = unsafe { ::std::mem::transmute(fDummy2) };
            fDummy2 as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type LPFTDCB = *mut _FTDCB;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _FTTIMEOUTS {
    pub ReadIntervalTimeout: DWORD,
    pub ReadTotalTimeoutMultiplier: DWORD,
    pub ReadTotalTimeoutConstant: DWORD,
    pub WriteTotalTimeoutMultiplier: DWORD,
    pub WriteTotalTimeoutConstant: DWORD,
}
#[test]
fn bindgen_test_layout__FTTIMEOUTS() {
    assert_eq!(
        ::std::mem::size_of::<_FTTIMEOUTS>(),
        20usize,
        concat!("Size of: ", stringify!(_FTTIMEOUTS))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTTIMEOUTS>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTTIMEOUTS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadIntervalTimeout as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadIntervalTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadTotalTimeoutMultiplier as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadTotalTimeoutMultiplier)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadTotalTimeoutConstant as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadTotalTimeoutConstant)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).WriteTotalTimeoutMultiplier as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(WriteTotalTimeoutMultiplier)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).WriteTotalTimeoutConstant as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(WriteTotalTimeoutConstant)
        )
    );
}
pub type FTTIMEOUTS = _FTTIMEOUTS;
extern "C" {
    pub fn FT_W32_ClearCommBreak(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    pub fn FT_W32_ClearCommError(
        ftHandle: FT_HANDLE,
        lpdwErrors: LPDWORD,
        lpftComstat: LPFTCOMSTAT,
    ) -> BOOL;
}
extern "C" {
    pub fn FT_W32_EscapeCommFunction(ftHandle: FT_HANDLE, dwFunc: DWORD) -> BOOL;
}
extern "C" {
    pub fn FT_W32_GetCommModemStatus(ftHandle: FT_HANDLE, lpdwModemStatus: LPDWORD) -> BOOL;
}
extern "C" {
    pub fn FT_W32_GetCommState(ftHandle: FT_HANDLE, lpftDcb: LPFTDCB) -> BOOL;
}
extern "C" {
    pub fn FT_W32_GetCommTimeouts(ftHandle: FT_HANDLE, pTimeouts: *mut FTTIMEOUTS) -> BOOL;
}
extern "C" {
    pub fn FT_W32_PurgeComm(ftHandle: FT_HANDLE, dwMask: DWORD) -> BOOL;
}
extern "C" {
    pub fn FT_W32_SetCommBreak(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    pub fn FT_W32_SetCommMask(ftHandle: FT_HANDLE, ulEventMask: ULONG) -> BOOL;
}
extern "C" {
    pub fn FT_W32_GetCommMask(ftHandle: FT_HANDLE, lpdwEventMask: LPDWORD) -> BOOL;
}
extern "C" {
    pub fn FT_W32_SetCommState(ftHandle: FT_HANDLE, lpftDcb: LPFTDCB) -> BOOL;
}
extern "C" {
    pub fn FT_W32_SetCommTimeouts(ftHandle: FT_HANDLE, pTimeouts: *mut FTTIMEOUTS) -> BOOL;
}
extern "C" {
    pub fn FT_W32_SetupComm(
        ftHandle: FT_HANDLE,
        dwReadBufferSize: DWORD,
        dwWriteBufferSize: DWORD,
    ) -> BOOL;
}
extern "C" {
    pub fn FT_W32_WaitCommEvent(
        ftHandle: FT_HANDLE,
        pulEvent: PULONG,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ft_device_list_info_node {
    pub Flags: ULONG,
    pub Type: ULONG,
    pub ID: ULONG,
    pub LocId: DWORD,
    pub SerialNumber: [::std::os::raw::c_char; 16usize],
    pub Description: [::std::os::raw::c_char; 64usize],
    pub ftHandle: FT_HANDLE,
}
#[test]
fn bindgen_test_layout__ft_device_list_info_node() {
    assert_eq!(
        ::std::mem::size_of::<_ft_device_list_info_node>(),
        104usize,
        concat!("Size of: ", stringify!(_ft_device_list_info_node))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_device_list_info_node>(),
        8usize,
        concat!("Alignment of ", stringify!(_ft_device_list_info_node))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).Flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).Type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).ID as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(ID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).LocId as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(LocId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).SerialNumber as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(SerialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).Description as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Description)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).ftHandle as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(ftHandle)
        )
    );
}
impl Default for _ft_device_list_info_node {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
pub type FT_DEVICE_LIST_INFO_NODE = _ft_device_list_info_node;
pub const FT_FLAGS_OPENED: ::std::os::raw::c_int = 1;
pub const FT_FLAGS_HISPEED: ::std::os::raw::c_int = 2;
pub type _bindgen_ty_7 = ::std::os::raw::c_int;
extern "C" {
    pub fn FT_CreateDeviceInfoList(lpdwNumDevs: LPDWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetDeviceInfoList(
        pDest: *mut FT_DEVICE_LIST_INFO_NODE,
        lpdwNumDevs: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetDeviceInfoDetail(
        dwIndex: DWORD,
        lpdwFlags: LPDWORD,
        lpdwType: LPDWORD,
        lpdwID: LPDWORD,
        lpdwLocId: LPDWORD,
        lpSerialNumber: LPVOID,
        lpDescription: LPVOID,
        pftHandle: *mut FT_HANDLE,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetDriverVersion(ftHandle: FT_HANDLE, lpdwVersion: LPDWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetLibraryVersion(lpdwVersion: LPDWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_Rescan() -> FT_STATUS;
}
extern "C" {
    pub fn FT_Reload(wVid: WORD, wPid: WORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetComPortNumber(ftHandle: FT_HANDLE, lpdwComPortNumber: LPLONG) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_ReadConfig(ftHandle: FT_HANDLE, ucAddress: UCHAR, pucValue: PUCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_WriteConfig(ftHandle: FT_HANDLE, ucAddress: UCHAR, ucValue: UCHAR) -> FT_STATUS;
}
extern "C" {
    pub fn FT_EE_ReadECC(ftHandle: FT_HANDLE, ucOption: UCHAR, lpwValue: LPWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_GetQueueStatusEx(ftHandle: FT_HANDLE, dwRxBytes: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ComPortIdle(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_ComPortCancelIdle(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    pub fn FT_VendorCmdGet(
        ftHandle: FT_HANDLE,
        Request: UCHAR,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_VendorCmdSet(
        ftHandle: FT_HANDLE,
        Request: UCHAR,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_VendorCmdGetEx(
        ftHandle: FT_HANDLE,
        wValue: USHORT,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    pub fn FT_VendorCmdSetEx(
        ftHandle: FT_HANDLE,
        wValue: USHORT,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
