/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const FT_OPEN_BY_SERIAL_NUMBER: u32 = 1;
pub const FT_OPEN_BY_DESCRIPTION: u32 = 2;
pub const FT_OPEN_BY_LOCATION: u32 = 4;
pub const FT_OPEN_MASK: u32 = 7;
pub const FT_LIST_NUMBER_ONLY: u32 = 2147483648;
pub const FT_LIST_BY_INDEX: u32 = 1073741824;
pub const FT_LIST_ALL: u32 = 536870912;
pub const FT_LIST_MASK: u32 = 3758096384;
pub const FT_BAUD_300: u32 = 300;
pub const FT_BAUD_600: u32 = 600;
pub const FT_BAUD_1200: u32 = 1200;
pub const FT_BAUD_2400: u32 = 2400;
pub const FT_BAUD_4800: u32 = 4800;
pub const FT_BAUD_9600: u32 = 9600;
pub const FT_BAUD_14400: u32 = 14400;
pub const FT_BAUD_19200: u32 = 19200;
pub const FT_BAUD_38400: u32 = 38400;
pub const FT_BAUD_57600: u32 = 57600;
pub const FT_BAUD_115200: u32 = 115200;
pub const FT_BAUD_230400: u32 = 230400;
pub const FT_BAUD_460800: u32 = 460800;
pub const FT_BAUD_921600: u32 = 921600;
pub const FT_FLOW_NONE: u32 = 0;
pub const FT_FLOW_RTS_CTS: u32 = 256;
pub const FT_FLOW_DTR_DSR: u32 = 512;
pub const FT_FLOW_XON_XOFF: u32 = 1024;
pub const FT_PURGE_RX: u32 = 1;
pub const FT_PURGE_TX: u32 = 2;
pub const FT_EVENT_RXCHAR: u32 = 1;
pub const FT_EVENT_MODEM_STATUS: u32 = 2;
pub const FT_EVENT_LINE_STATUS: u32 = 4;
pub const FT_DEFAULT_RX_TIMEOUT: u32 = 300;
pub const FT_DEFAULT_TX_TIMEOUT: u32 = 300;
pub const FT_BITMODE_RESET: u32 = 0;
pub const FT_BITMODE_ASYNC_BITBANG: u32 = 1;
pub const FT_BITMODE_MPSSE: u32 = 2;
pub const FT_BITMODE_SYNC_BITBANG: u32 = 4;
pub const FT_BITMODE_MCU_HOST: u32 = 8;
pub const FT_BITMODE_FAST_SERIAL: u32 = 16;
pub const FT_BITMODE_CBUS_BITBANG: u32 = 32;
pub const FT_BITMODE_SYNC_FIFO: u32 = 64;
pub const FT_232R_CBUS_TXDEN: u32 = 0;
pub const FT_232R_CBUS_PWRON: u32 = 1;
pub const FT_232R_CBUS_RXLED: u32 = 2;
pub const FT_232R_CBUS_TXLED: u32 = 3;
pub const FT_232R_CBUS_TXRXLED: u32 = 4;
pub const FT_232R_CBUS_SLEEP: u32 = 5;
pub const FT_232R_CBUS_CLK48: u32 = 6;
pub const FT_232R_CBUS_CLK24: u32 = 7;
pub const FT_232R_CBUS_CLK12: u32 = 8;
pub const FT_232R_CBUS_CLK6: u32 = 9;
pub const FT_232R_CBUS_IOMODE: u32 = 10;
pub const FT_232R_CBUS_BITBANG_WR: u32 = 11;
pub const FT_232R_CBUS_BITBANG_RD: u32 = 12;
pub const FT_232H_CBUS_TRISTATE: u32 = 0;
pub const FT_232H_CBUS_TXLED: u32 = 1;
pub const FT_232H_CBUS_RXLED: u32 = 2;
pub const FT_232H_CBUS_TXRXLED: u32 = 3;
pub const FT_232H_CBUS_PWREN: u32 = 4;
pub const FT_232H_CBUS_SLEEP: u32 = 5;
pub const FT_232H_CBUS_DRIVE_0: u32 = 6;
pub const FT_232H_CBUS_DRIVE_1: u32 = 7;
pub const FT_232H_CBUS_IOMODE: u32 = 8;
pub const FT_232H_CBUS_TXDEN: u32 = 9;
pub const FT_232H_CBUS_CLK30: u32 = 10;
pub const FT_232H_CBUS_CLK15: u32 = 11;
pub const FT_232H_CBUS_CLK7_5: u32 = 12;
pub const FT_X_SERIES_CBUS_TRISTATE: u32 = 0;
pub const FT_X_SERIES_CBUS_TXLED: u32 = 1;
pub const FT_X_SERIES_CBUS_RXLED: u32 = 2;
pub const FT_X_SERIES_CBUS_TXRXLED: u32 = 3;
pub const FT_X_SERIES_CBUS_PWREN: u32 = 4;
pub const FT_X_SERIES_CBUS_SLEEP: u32 = 5;
pub const FT_X_SERIES_CBUS_DRIVE_0: u32 = 6;
pub const FT_X_SERIES_CBUS_DRIVE_1: u32 = 7;
pub const FT_X_SERIES_CBUS_IOMODE: u32 = 8;
pub const FT_X_SERIES_CBUS_TXDEN: u32 = 9;
pub const FT_X_SERIES_CBUS_CLK24: u32 = 10;
pub const FT_X_SERIES_CBUS_CLK12: u32 = 11;
pub const FT_X_SERIES_CBUS_CLK6: u32 = 12;
pub const FT_X_SERIES_CBUS_BCD_CHARGER: u32 = 13;
pub const FT_X_SERIES_CBUS_BCD_CHARGER_N: u32 = 14;
pub const FT_X_SERIES_CBUS_I2C_TXE: u32 = 15;
pub const FT_X_SERIES_CBUS_I2C_RXF: u32 = 16;
pub const FT_X_SERIES_CBUS_VBUS_SENSE: u32 = 17;
pub const FT_X_SERIES_CBUS_BITBANG_WR: u32 = 18;
pub const FT_X_SERIES_CBUS_BITBANG_RD: u32 = 19;
pub const FT_X_SERIES_CBUS_TIMESTAMP: u32 = 20;
pub const FT_X_SERIES_CBUS_KEEP_AWAKE: u32 = 21;
pub const FT_DRIVER_TYPE_D2XX: u32 = 0;
pub const FT_DRIVER_TYPE_VCP: u32 = 1;
pub type DWORD = ::std::os::raw::c_uint;
pub type ULONG = ::std::os::raw::c_uint;
pub type USHORT = ::std::os::raw::c_ushort;
pub type UCHAR = ::std::os::raw::c_uchar;
pub type WORD = ::std::os::raw::c_ushort;
pub type BYTE = ::std::os::raw::c_uchar;
pub type BOOL = ::std::os::raw::c_uint;
pub type CHAR = ::std::os::raw::c_uchar;
pub type PUCHAR = *mut UCHAR;
pub type PCHAR = *mut ::std::os::raw::c_char;
pub type PVOID = *mut ::std::os::raw::c_void;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type LONG = ::std::os::raw::c_uint;
pub type UINT = ::std::os::raw::c_uint;
pub type LPCTSTR = *const ::std::os::raw::c_char;
pub type LPDWORD = *mut DWORD;
pub type LPWORD = *mut WORD;
pub type PULONG = *mut ULONG;
pub type LPLONG = *mut LONG;
pub type LPVOID = PVOID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _OVERLAPPED {
    pub Internal: DWORD,
    pub InternalHigh: DWORD,
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1,
    pub hEvent: HANDLE,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _OVERLAPPED__bindgen_ty_1 {
    pub __bindgen_anon_1: _OVERLAPPED__bindgen_ty_1__bindgen_ty_1,
    pub Pointer: PVOID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _OVERLAPPED__bindgen_ty_1__bindgen_ty_1 {
    pub Offset: DWORD,
    pub OffsetHigh: DWORD,
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).Offset as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(Offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1__bindgen_ty_1>())).OffsetHigh
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(OffsetHigh)
        )
    );
}
#[test]
fn bindgen_test_layout__OVERLAPPED__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_OVERLAPPED__bindgen_ty_1>())).Pointer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED__bindgen_ty_1),
            "::",
            stringify!(Pointer)
        )
    );
}
#[test]
fn bindgen_test_layout__OVERLAPPED() {
    assert_eq!(
        ::std::mem::size_of::<_OVERLAPPED>(),
        24usize,
        concat!("Size of: ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        ::std::mem::align_of::<_OVERLAPPED>(),
        8usize,
        concat!("Alignment of ", stringify!(_OVERLAPPED))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).Internal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(Internal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).InternalHigh as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(InternalHigh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_OVERLAPPED>())).hEvent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_OVERLAPPED),
            "::",
            stringify!(hEvent)
        )
    );
}
pub type LPOVERLAPPED = *mut _OVERLAPPED;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _SECURITY_ATTRIBUTES {
    pub nLength: DWORD,
    pub lpSecurityDescriptor: LPVOID,
    pub bInheritHandle: BOOL,
}
#[test]
fn bindgen_test_layout__SECURITY_ATTRIBUTES() {
    assert_eq!(
        ::std::mem::size_of::<_SECURITY_ATTRIBUTES>(),
        24usize,
        concat!("Size of: ", stringify!(_SECURITY_ATTRIBUTES))
    );
    assert_eq!(
        ::std::mem::align_of::<_SECURITY_ATTRIBUTES>(),
        8usize,
        concat!("Alignment of ", stringify!(_SECURITY_ATTRIBUTES))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).nLength as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(nLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).lpSecurityDescriptor as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(lpSecurityDescriptor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_SECURITY_ATTRIBUTES>())).bInheritHandle as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_SECURITY_ATTRIBUTES),
            "::",
            stringify!(bInheritHandle)
        )
    );
}
pub type LPSECURITY_ATTRIBUTES = *mut _SECURITY_ATTRIBUTES;
#[doc = " @name FT_HANDLE"]
#[doc = " An opaque value used as a handle to an opened FT device."]
pub type FT_HANDLE = PVOID;
#[doc = " @{"]
#[doc = " @name FT_STATUS"]
#[doc = " @details Return status values for API calls."]
pub type FT_STATUS = ULONG;
pub const FT_OK: ::std::os::raw::c_uint = 0;
pub const FT_INVALID_HANDLE: ::std::os::raw::c_uint = 1;
pub const FT_DEVICE_NOT_FOUND: ::std::os::raw::c_uint = 2;
pub const FT_DEVICE_NOT_OPENED: ::std::os::raw::c_uint = 3;
pub const FT_IO_ERROR: ::std::os::raw::c_uint = 4;
pub const FT_INSUFFICIENT_RESOURCES: ::std::os::raw::c_uint = 5;
pub const FT_INVALID_PARAMETER: ::std::os::raw::c_uint = 6;
pub const FT_INVALID_BAUD_RATE: ::std::os::raw::c_uint = 7;
pub const FT_DEVICE_NOT_OPENED_FOR_ERASE: ::std::os::raw::c_uint = 8;
pub const FT_DEVICE_NOT_OPENED_FOR_WRITE: ::std::os::raw::c_uint = 9;
pub const FT_FAILED_TO_WRITE_DEVICE: ::std::os::raw::c_uint = 10;
pub const FT_EEPROM_READ_FAILED: ::std::os::raw::c_uint = 11;
pub const FT_EEPROM_WRITE_FAILED: ::std::os::raw::c_uint = 12;
pub const FT_EEPROM_ERASE_FAILED: ::std::os::raw::c_uint = 13;
pub const FT_EEPROM_NOT_PRESENT: ::std::os::raw::c_uint = 14;
pub const FT_EEPROM_NOT_PROGRAMMED: ::std::os::raw::c_uint = 15;
pub const FT_INVALID_ARGS: ::std::os::raw::c_uint = 16;
pub const FT_NOT_SUPPORTED: ::std::os::raw::c_uint = 17;
pub const FT_OTHER_ERROR: ::std::os::raw::c_uint = 18;
pub const FT_DEVICE_LIST_NOT_READY: ::std::os::raw::c_uint = 19;
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
#[doc = " @{"]
#[doc = " @name Device Types"]
#[doc = " @details Known supported FTDI device types supported by this library."]
pub type FT_DEVICE = ULONG;
pub const FT_DEVICE_BM: ::std::os::raw::c_uint = 0;
pub const FT_DEVICE_AM: ::std::os::raw::c_uint = 1;
pub const FT_DEVICE_100AX: ::std::os::raw::c_uint = 2;
pub const FT_DEVICE_UNKNOWN: ::std::os::raw::c_uint = 3;
pub const FT_DEVICE_2232C: ::std::os::raw::c_uint = 4;
pub const FT_DEVICE_232R: ::std::os::raw::c_uint = 5;
pub const FT_DEVICE_2232H: ::std::os::raw::c_uint = 6;
pub const FT_DEVICE_4232H: ::std::os::raw::c_uint = 7;
pub const FT_DEVICE_232H: ::std::os::raw::c_uint = 8;
pub const FT_DEVICE_X_SERIES: ::std::os::raw::c_uint = 9;
pub const FT_DEVICE_4222H_0: ::std::os::raw::c_uint = 10;
pub const FT_DEVICE_4222H_1_2: ::std::os::raw::c_uint = 11;
pub const FT_DEVICE_4222H_3: ::std::os::raw::c_uint = 12;
pub const FT_DEVICE_4222_PROG: ::std::os::raw::c_uint = 13;
pub const FT_DEVICE_900: ::std::os::raw::c_uint = 14;
pub const FT_DEVICE_930: ::std::os::raw::c_uint = 15;
pub const FT_DEVICE_UMFTPD3A: ::std::os::raw::c_uint = 16;
pub const FT_DEVICE_2233HP: ::std::os::raw::c_uint = 17;
pub const FT_DEVICE_4233HP: ::std::os::raw::c_uint = 18;
pub const FT_DEVICE_2232HP: ::std::os::raw::c_uint = 19;
pub const FT_DEVICE_4232HP: ::std::os::raw::c_uint = 20;
pub const FT_DEVICE_233HP: ::std::os::raw::c_uint = 21;
pub const FT_DEVICE_232HP: ::std::os::raw::c_uint = 22;
pub const FT_DEVICE_2232HA: ::std::os::raw::c_uint = 23;
pub const FT_DEVICE_4232HA: ::std::os::raw::c_uint = 24;
pub type _bindgen_ty_3 = ::std::os::raw::c_uint;
pub const FT_FLAGS_OPENED: ::std::os::raw::c_uint = 1;
pub const FT_FLAGS_HISPEED: ::std::os::raw::c_uint = 2;
#[doc = " @{"]
#[doc = " @name FT_DEVICE_LIST_INFO_NODE Device Information Flags"]
#[doc = " @par Summary"]
#[doc = " These flags are used in the Flags member of FT_DEVICE_LIST_INFO_NODE to indicated the state of"]
#[doc = " the device and speed of the device."]
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
extern "C" {
    #[doc = " @noop FT_SetVIDPID"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " @par Summary"]
    #[doc = " A command to include a custom VID and PID combination within the internal device list table."]
    #[doc = " This will allow the driver to load for the specified VID and PID combination."]
    #[doc = " @param dwVID Device Vendor ID (VID)"]
    #[doc = " @param dwPID Device Product ID (PID)"]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " By default, the driver will support a limited set of VID and PID matched devices (VID 0x0403"]
    #[doc = " with PIDs for standard FTDI devices only)."]
    #[doc = " @n In order to use the driver with other VID and PID combinations the FT_SetVIDPID function"]
    #[doc = " must be used prior to calling FT_ListDevices, FT_Open, FT_OpenEx or FT_CreateDeviceInfoList."]
    #[doc = " @note Extra function for non-Windows platforms to compensate for lack of .INF file to specify"]
    #[doc = " Vendor and Product IDs."]
    pub fn FT_SetVIDPID(dwVID: DWORD, dwPID: DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetVIDPID"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " @par Summary"]
    #[doc = " A command to retrieve the current VID and PID combination from within the internal device list table."]
    #[doc = " @param pdwVID Pointer to DWORD that will contain the internal VID"]
    #[doc = " @param pdwPID Pointer to DWORD that will contain the internal PID"]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " @note Extra function for non-Windows platforms to compensate for lack of .INF file to specify Vendor and Product IDs."]
    #[doc = " @see FT_SetVIDPID."]
    pub fn FT_GetVIDPID(pdwVID: *mut DWORD, pdwPID: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_CreateDeviceInfoList"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function builds a device information list and returns the number of D2XX devices connected to the"]
    #[doc = " system. The list contains information about both unopen and open devices."]
    #[doc = " @param lpdwNumDevs Pointer to unsigned long to store the number of devices connected."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " An application can use this function to get the number of devices attached to the system. It can then"]
    #[doc = " allocate space for the device information list and retrieve the list using FT_GetDeviceInfoList or"]
    #[doc = " FT_GetDeviceInfoDetail."]
    #[doc = " @n If the devices connected to the system change, the device info list will not be updated until"]
    #[doc = " FT_CreateDeviceInfoList is called again."]
    #[doc = " @see FT_GetDeviceInfoList"]
    #[doc = " @see FT_GetDeviceInfoDetail"]
    pub fn FT_CreateDeviceInfoList(lpdwNumDevs: LPDWORD) -> FT_STATUS;
}
#[doc = "  @noop FT_DEVICE_LIST_INFO_NODE"]
#[doc = " @par Summary"]
#[doc = " This structure is used for passing information about a device back from the FT_GetDeviceInfoList function."]
#[doc = " @see FT_GetDeviceInfoList"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_device_list_info_node {
    pub Flags: ULONG,
    pub Type: ULONG,
    pub ID: ULONG,
    pub LocId: DWORD,
    pub SerialNumber: [::std::os::raw::c_char; 16usize],
    pub Description: [::std::os::raw::c_char; 64usize],
    pub ftHandle: FT_HANDLE,
}
#[test]
fn bindgen_test_layout__ft_device_list_info_node() {
    assert_eq!(
        ::std::mem::size_of::<_ft_device_list_info_node>(),
        104usize,
        concat!("Size of: ", stringify!(_ft_device_list_info_node))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_device_list_info_node>(),
        8usize,
        concat!("Alignment of ", stringify!(_ft_device_list_info_node))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).Flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).Type as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).ID as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(ID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_device_list_info_node>())).LocId as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(LocId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).SerialNumber as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(SerialNumber)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).Description as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(Description)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_ft_device_list_info_node>())).ftHandle as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_device_list_info_node),
            "::",
            stringify!(ftHandle)
        )
    );
}
#[doc = "  @noop FT_DEVICE_LIST_INFO_NODE"]
#[doc = " @par Summary"]
#[doc = " This structure is used for passing information about a device back from the FT_GetDeviceInfoList function."]
#[doc = " @see FT_GetDeviceInfoList"]
pub type FT_DEVICE_LIST_INFO_NODE = _ft_device_list_info_node;
extern "C" {
    #[doc = " @noop FT_GetDeviceInfoList"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function returns a device information list and the number of D2XX devices in the list."]
    #[doc = " @param *pDest Pointer to an array of FT_DEVICE_LIST_INFO_NODE structures."]
    #[doc = " @param lpdwNumDevs Pointer to the number of elements in the array."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function should only be called after calling FT_CreateDeviceInfoList. If the devices connected to the"]
    #[doc = " system change, the device info list will not be updated until FT_CreateDeviceInfoList is called again."]
    #[doc = " Location ID information is not returned for devices that are open when FT_CreateDeviceInfoList is called."]
    #[doc = " Information is not available for devices which are open in other processes. In this case, the Flags"]
    #[doc = " parameter of the FT_DEVICE_LIST_INFO_NODE will indicate that the device is open, but other fields will"]
    #[doc = " be unpopulated."]
    #[doc = " @n The flag value is a 4-byte bit map containing miscellaneous data as defined Appendix A - Type"]
    #[doc = " Definitions. Bit 0 (least significant bit) of this number indicates if the port is open (1) or closed (0). Bit 1"]
    #[doc = " indicates if the device is enumerated as a high-speed USB device (2) or a full-speed USB device (0). The"]
    #[doc = " remaining bits (2 - 31) are reserved."]
    #[doc = " @n The array of FT_DEVICE_LIST_INFO_NODES contains all available data on each device. The structure of"]
    #[doc = " FT_DEVICE_LIST_INFO_NODES is given in the Appendix. The storage for the list must be allocated by"]
    #[doc = " the application. The number of devices returned by FT_CreateDeviceInfoList can be used to do this."]
    #[doc = " When programming in Visual Basic, LabVIEW or similar languages, FT_GetDeviceInfoDetail may be"]
    #[doc = " required instead of this function."]
    #[doc = " @note Please note that Windows CE does not support location IDs. As such, the Location ID parameter in the"]
    #[doc = " structure will be empty."]
    #[doc = " @see FT_CreateDeviceInfoList"]
    pub fn FT_GetDeviceInfoList(
        pDest: *mut FT_DEVICE_LIST_INFO_NODE,
        lpdwNumDevs: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetDeviceInfoDetail"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function returns an entry from the device information list."]
    #[doc = " @param dwIndex Index of the entry in the device info list."]
    #[doc = " @param lpdwFlags Pointer to unsigned long to store the flag value."]
    #[doc = " @param lpdwType Pointer to unsigned long to store device type."]
    #[doc = " @param lpdwID Pointer to unsigned long to store device ID."]
    #[doc = " @param lpdwLocId Pointer to unsigned long to store the device location ID."]
    #[doc = " @param lpSerialNumber Pointer to buffer to store device serial number as a nullterminated string."]
    #[doc = " @param lpDescription Pointer to buffer to store device description as a null-terminated string."]
    #[doc = " @param *pftHandle Pointer to a variable of type FT_HANDLE where the handle will be stored."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function should only be called after calling FT_CreateDeviceInfoList. If the devices connected to the"]
    #[doc = " system change, the device info list will not be updated until FT_CreateDeviceInfoList is called again."]
    #[doc = " @n The index value is zero-based."]
    #[doc = " @n The flag value is a 4-byte bit map containing miscellaneous data as defined Appendix A - Type"]
    #[doc = " Definitions. Bit 0 (least significant bit) of this number indicates if the port is open (1) or closed (0). Bit 1"]
    #[doc = " indicates if the device is enumerated as a high-speed USB device (2) or a full-speed USB device (0). The"]
    #[doc = " remaining bits (2 - 31) are reserved."]
    #[doc = " @n Location ID information is not returned for devices that are open when FT_CreateDeviceInfoList is called."]
    #[doc = " Information is not available for devices which are open in other processes. In this case, the lpdwFlags"]
    #[doc = " parameter will indicate that the device is open, but other fields will be unpopulated."]
    #[doc = " To return the whole device info list as an array of FT_DEVICE_LIST_INFO_NODE structures, use"]
    #[doc = " FT_CreateDeviceInfoList."]
    #[doc = " @note Please note that Windows CE does not support location IDs. As such, the Location ID parameter in the"]
    #[doc = " structure will be empty."]
    #[doc = " @see FT_CreateDeviceInfoList"]
    pub fn FT_GetDeviceInfoDetail(
        dwIndex: DWORD,
        lpdwFlags: LPDWORD,
        lpdwType: LPDWORD,
        lpdwID: LPDWORD,
        lpdwLocId: LPDWORD,
        lpSerialNumber: LPVOID,
        lpDescription: LPVOID,
        pftHandle: *mut FT_HANDLE,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ListDevices"]
    #[doc = " @par Summary"]
    #[doc = " Gets information concerning the devices currently connected. This function can return information such"]
    #[doc = " as the number of devices connected, the device serial number and device description strings, and the"]
    #[doc = " location IDs of connected devices."]
    #[doc = " @param pvArg1 Meaning depends on dwFlags."]
    #[doc = " @param pvArg2 Meaning depends on dwFlags."]
    #[doc = " @param dwFlags Determines format of returned information."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function can be used in a number of ways to return different types of information. A more powerful"]
    #[doc = " way to get device information is to use the FT_CreateDeviceInfoList, FT_GetDeviceInfoList and"]
    #[doc = " FT_GetDeviceInfoDetail functions as they return all the available information on devices."]
    #[doc = " In its simplest form, it can be used to return the number of devices currently connected. If"]
    #[doc = " FT_LIST_NUMBER_ONLY bit is set in dwFlags, the parameter pvArg1 is interpreted as a pointer to a"]
    #[doc = " DWORD location to store the number of devices currently connected."]
    #[doc = " @n It can be used to return device information: if FT_OPEN_BY_SERIAL_NUMBER bit is set in dwFlags, the"]
    #[doc = " serial number string will be returned; if FT_OPEN_BY_DESCRIPTION bit is set in dwFlags, the product"]
    #[doc = " description string will be returned; if FT_OPEN_BY_LOCATION bit is set in dwFlags, the Location ID will"]
    #[doc = " be returned; if none of these bits is set, the serial number string will be returned by default."]
    #[doc = " @n It can be used to return device string information for a single device. If FT_LIST_BY_INDEX and"]
    #[doc = " FT_OPEN_BY_SERIAL_NUMBER or FT_OPEN_BY_DESCRIPTION bits are set in dwFlags, the parameter"]
    #[doc = " pvArg1 is interpreted as the index of the device, and the parameter pvArg2 is interpreted as a pointer to"]
    #[doc = " a buffer to contain the appropriate string. Indexes are zero-based, and the error code"]
    #[doc = " FT_DEVICE_NOT_FOUND is returned for an invalid index."]
    #[doc = " @n It can be used to return device string information for all connected devices. If FT_LIST_ALL and"]
    #[doc = " FT_OPEN_BY_SERIAL_NUMBER or FT_OPEN_BY_DESCRIPTION bits are set in dwFlags, the parameter"]
    #[doc = " pvArg1 is interpreted as a pointer to an array of pointers to buffers to contain the appropriate strings and"]
    #[doc = " the parameter pvArg2 is interpreted as a pointer to a DWORD location to store the number of devices"]
    #[doc = " currently connected. Note that, for pvArg1, the last entry in the array of pointers to buffers should be a"]
    #[doc = " NULL pointer so the array will contain one more location than the number of devices connected."]
    #[doc = " @n The location ID of a device is returned if FT_LIST_BY_INDEX and FT_OPEN_BY_LOCATION bits are set in"]
    #[doc = " dwFlags. In this case the parameter pvArg1 is interpreted as the index of the device, and the parameter"]
    #[doc = " pvArg2 is interpreted as a pointer to a variable of type long to contain the location ID. Indexes are"]
    #[doc = " zerobased, and the error code FT_DEVICE_NOT_FOUND is returned for an invalid index. Please note that"]
    #[doc = " Windows CE and Linux do not support location IDs."]
    #[doc = " @n The location IDs of all connected devices are returned if FT_LIST_ALL and FT_OPEN_BY_LOCATION bits"]
    #[doc = " are set in dwFlags. In this case, the parameter pvArg1 is interpreted as a pointer to an array of variables"]
    #[doc = " of type long to contain the location IDs, and the parameter pvArg2 is interpreted as a pointer to a"]
    #[doc = " DWORD location to store the number of devices currently connected."]
    #[doc = " @see FT_CreateDeviceInfoList"]
    #[doc = " @see FT_GetDeviceInfoList"]
    #[doc = " @see FT_GetDeviceInfoDetail"]
    pub fn FT_ListDevices(pvArg1: PVOID, pvArg2: PVOID, dwFlags: DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Open"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Open the device and return a handle which will be used for subsequent accesses."]
    #[doc = " @param deviceNumber Index of the device to open. Indices are 0 based."]
    #[doc = " @param pHandle Pointer to a variable of type FT_HANDLE where the handle will be stored. This handle must"]
    #[doc = " be used to access the device."]
    #[doc = " @return"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " Although this function can be used to open multiple devices by setting iDevice to 0, 1, 2 etc. there is no"]
    #[doc = " ability to open a specific device. To open named devices, use the function FT_OpenEx."]
    #[doc = " @see FT_OpenEx."]
    pub fn FT_Open(deviceNumber: ::std::os::raw::c_int, pHandle: *mut FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_OpenEx"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Open the specified device and return a handle that will be used for subsequent accesses. The device can"]
    #[doc = " be specified by its serial number, device description or location."]
    #[doc = " @n This function can also be used to open multiple devices simultaneously. Multiple devices can be specified"]
    #[doc = " by serial number, device description or location ID (location information derived from the physical"]
    #[doc = " location of a device on USB). Location IDs for specific USB ports can be obtained using the utility"]
    #[doc = " USBView and are given in hexadecimal format. Location IDs for devices connected to a system can be"]
    #[doc = " obtained by calling FT_GetDeviceInfoList or FT_ListDevices with the appropriate flags."]
    #[doc = " @param pvArg1 Pointer to an argument whose type depends on the value of dwFlags."]
    #[doc = " It is normally be interpreted as a pointer to a null terminated string."]
    #[doc = " @param dwFlags FT_OPEN_BY_SERIAL_NUMBER, FT_OPEN_BY_DESCRIPTION or FT_OPEN_BY_LOCATION."]
    #[doc = " @param pHandle Pointer to a variable of type FT_HANDLE where the handle will be"]
    #[doc = " stored. This handle must be used to access the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " The parameter specified in pvArg1 depends on dwFlags: if dwFlags is FT_OPEN_BY_SERIAL_NUMBER,"]
    #[doc = " pvArg1 is interpreted as a pointer to a null-terminated string that represents the serial number of the"]
    #[doc = " device; if dwFlags is FT_OPEN_BY_DESCRIPTION, pvArg1 is interpreted as a pointer to a nullterminated"]
    #[doc = " string that represents the device description; if dwFlags is FT_OPEN_BY_LOCATION, pvArg1"]
    #[doc = " is interpreted as a long value that contains the location ID of the device. Please note that Windows CE"]
    #[doc = " and Linux do not support location IDs."]
    #[doc = " @n ftHandle is a pointer to a variable of type FT_HANDLE where the handle is to be stored. This handle must"]
    #[doc = " be used to access the device."]
    pub fn FT_OpenEx(pvArg1: PVOID, dwFlags: DWORD, pHandle: *mut FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Close"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Close an open device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_Close(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Read"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read data from the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpBuffer Pointer to the buffer that receives the data from the device."]
    #[doc = " @param dwBytesToRead Number of bytes to be read from the device."]
    #[doc = " @param lpdwBytesReturned Pointer to a variable of type DWORD which receives the number of"]
    #[doc = " bytes read from the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, FT_IO_ERROR otherwise. $see FT_STATUS"]
    #[doc = " @remarks"]
    #[doc = " FT_Read always returns the number of bytes read in lpdwBytesReturned."]
    #[doc = " @n This function does not return until dwBytesToRead bytes have been read into the buffer. The number of"]
    #[doc = " bytes in the receive queue can be determined by calling FT_GetStatus or FT_GetQueueStatus, and"]
    #[doc = " passed to FT_Read as dwBytesToRead so that the function reads the device and returns immediately."]
    #[doc = " When a read timeout value has been specified in a previous call to FT_SetTimeouts, FT_Read returns"]
    #[doc = " when the timer expires or dwBytesToRead have been read, whichever occurs first. If the timeout"]
    #[doc = " occurred, FT_Read reads available data into the buffer and returns FT_OK."]
    #[doc = " @n An application should use the function return value and lpdwBytesReturned when processing the buffer."]
    #[doc = " If the return value is FT_OK, and lpdwBytesReturned is equal to dwBytesToRead then FT_Read has"]
    #[doc = " completed normally. If the return value is FT_OK, and lpdwBytesReturned is less then dwBytesToRead"]
    #[doc = " then a timeout has occurred and the read has been partially completed. Note that if a timeout occurred"]
    #[doc = " and no data was read, the return value is still FT_OK."]
    #[doc = " @n A return value of FT_IO_ERROR suggests an error in the parameters of the function, or a fatal error like a"]
    #[doc = " USB disconnect has occurred."]
    pub fn FT_Read(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        dwBytesToRead: DWORD,
        lpdwBytesReturned: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Write"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Write data to the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpBuffer Pointer to the buffer that contains the data to be written to the device."]
    #[doc = " @param dwBytesToWrite Number of bytes to write to the device."]
    #[doc = " @param lpdwBytesWritten Pointer to a variable of type DWORD which receives the number of"]
    #[doc = " bytes written to the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_Write(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        dwBytesToWrite: DWORD,
        lpdwBytesWritten: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetBaudRate"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the baud rate for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwBaudRate Baud rate."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code"]
    pub fn FT_SetBaudRate(ftHandle: FT_HANDLE, dwBaudRate: ULONG) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetDivisor"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the baud rate for the device. It is used to set non-standard baud rates."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param usDivisor Divisor."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is no longer required as FT_SetBaudRate will now automatically calculate the required"]
    #[doc = " divisor for a requested baud rate. The application note \"Setting baud rates for the FT8U232AM\" is"]
    #[doc = " available from the Application Notes section of the FTDI website describes how to calculate the divisor for"]
    #[doc = " a non-standard baud rate."]
    pub fn FT_SetDivisor(ftHandle: FT_HANDLE, usDivisor: USHORT) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetDataCharacteristics"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the data characteristics for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param uWordLength Number of bits per word - must be FT_BITS_8 or FT_BITS_7."]
    #[doc = " @param uStopBits Number of stop bits - must be FT_STOP_BITS_1 or FT_STOP_BITS_2."]
    #[doc = " @param uParity Parity - must be FT_PARITY_NONE, FT_PARITY_ODD, FT_PARITY_EVEN,"]
    #[doc = " FT_PARITY_MARK or FT_PARITY SPACE."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_SetDataCharacteristics(
        ftHandle: FT_HANDLE,
        uWordLength: UCHAR,
        uStopBits: UCHAR,
        uParity: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetTimeouts"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the read and write timeouts for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwReadTimeout Read timeout in milliseconds."]
    #[doc = " @param dwWriteTimeout Write timeout in milliseconds."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_SetTimeouts(
        ftHandle: FT_HANDLE,
        dwReadTimeout: ULONG,
        dwWriteTimeout: ULONG,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetFlowControl"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the flow control for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param usFlowControl Must be one of FT_FLOW_NONE, FT_FLOW_RTS_CTS, FT_FLOW_DTR_DSR or"]
    #[doc = " FT_FLOW_XON_XOFF."]
    #[doc = " @param uXonChar Character used to signal Xon. Only used if flow control is FT_FLOW_XON_XOFF."]
    #[doc = " @param uXoffChar Character used to signal Xoff. Only used if flow control is\tFT_FLOW_XON_XOFF."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_SetFlowControl(
        ftHandle: FT_HANDLE,
        usFlowControl: USHORT,
        uXonChar: UCHAR,
        uXoffChar: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetDtr"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the Data Terminal Ready (DTR) control signal."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function asserts the Data Terminal Ready (DTR) line of the device."]
    pub fn FT_SetDtr(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ClrDtr"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function clears the Data Terminal Ready (DTR) control signal."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function de-asserts the Data Terminal Ready (DTR) line of the device."]
    pub fn FT_ClrDtr(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetRts"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the Request To Send (RTS) control signal."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function asserts the Request To Send (RTS) line of the device."]
    pub fn FT_SetRts(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ClrRts"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function clears the Request To Send (RTS) control signal."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function de-asserts the Request To Send (RTS) line of the device."]
    pub fn FT_ClrRts(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetModemStatus"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the modem status and line status from the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwModemStatus Pointer to a variable of type DWORD which receives the modem"]
    #[doc = " status and line status from the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " The least significant byte of the lpdwModemStatus value holds the modem status. On Windows and"]
    #[doc = " Windows CE, the line status is held in the second least significant byte of the lpdwModemStatus value."]
    #[doc = " @n The modem status is bit-mapped as follows: Clear To Send (CTS) = 0x10, Data Set Ready (DSR) = 0x20,"]
    #[doc = " Ring Indicator (RI) = 0x40, Data Carrier Detect (DCD) = 0x80."]
    #[doc = " @n The line status is bit-mapped as follows: Overrun Error (OE) = 0x02, Parity Error (PE) = 0x04, Framing"]
    #[doc = " Error (FE) = 0x08, Break Interrupt (BI) = 0x10."]
    pub fn FT_GetModemStatus(ftHandle: FT_HANDLE, lpdwModemStatus: *mut ULONG) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetQueueStatus"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the number of bytes in the receive queue."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwAmountInRxQueue Pointer to a variable of type DWORD which receives the number of"]
    #[doc = " bytes in the receive queue."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_GetQueueStatus(ftHandle: FT_HANDLE, lpdwAmountInRxQueue: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetDeviceInfo"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Get device information for an open device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpftDevice Pointer to unsigned long to store device type."]
    #[doc = " @param lpdwID Pointer to unsigned long to store device ID."]
    #[doc = " @param pcSerialNumber Pointer to buffer to store device serial number as a nullterminated string."]
    #[doc = " @param pcDescription Pointer to buffer to store device description as a null-terminated string."]
    #[doc = " @param pvDummy Reserved for future use - should be set to NULL."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is used to return the device type, device ID, device description and serial number."]
    #[doc = " The device ID is encoded in a DWORD - the most significant word contains the vendor ID, and the least"]
    #[doc = " significant word contains the product ID. So the returned ID 0x04036001 corresponds to the device ID"]
    #[doc = " VID_0403&PID_6001."]
    pub fn FT_GetDeviceInfo(
        ftHandle: FT_HANDLE,
        lpftDevice: *mut FT_DEVICE,
        lpdwID: LPDWORD,
        pcSerialNumber: PCHAR,
        pcDescription: PCHAR,
        pvDummy: LPVOID,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @note Extra function for non-Windows platforms to compensate for lack of .INF file to specify Vendor and Product IDs."]
    pub fn FT_GetDeviceLocId(ftHandle: FT_HANDLE, lpdwLocId: LPDWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetDriverVersion"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function returns the D2XX driver version number."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwDriverVersion Pointer to the driver version number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " A version number consists of major, minor and build version numbers contained in a 4-byte field"]
    #[doc = " (unsigned long). Byte0 (least significant) holds the build version, Byte1 holds the minor version, and"]
    #[doc = " Byte2 holds the major version. Byte3 is currently set to zero."]
    #[doc = " @n For example, driver version \"2.04.06\" is represented as 0x00020406. Note that a device has to be"]
    #[doc = " opened before this function can be called."]
    pub fn FT_GetDriverVersion(ftHandle: FT_HANDLE, lpdwDriverVersion: LPDWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetLibraryVersion"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @n"]
    #[doc = " This function returns D2XX DLL or library version number."]
    #[doc = " @param lpdwDLLVersion Pointer to the DLL or library version number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " A version number consists of major, minor and build version numbers contained in a 4-byte field"]
    #[doc = " (unsigned long). Byte0 (least significant) holds the build version, Byte1 holds the minor version, and"]
    #[doc = " Byte2 holds the major version. Byte3 is currently set to zero."]
    #[doc = " @n For example, D2XX DLL version \"3.01.15\" is represented as 0x00030115. Note that this function does"]
    #[doc = " not take a handle, and so it can be called without opening a device."]
    pub fn FT_GetLibraryVersion(lpdwDLLVersion: LPDWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetComPortNumber"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Retrieves the COM port associated with a device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lplComPortNumber Pointer to a variable of type LONG which receives the COM port number"]
    #[doc = " associated with the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is only available when using the Windows CDM driver as both the D2XX and VCP drivers can"]
    #[doc = " be installed at the same time."]
    #[doc = " @n If no COM port is associated with the device, lplComPortNumber will have a value of -1"]
    pub fn FT_GetComPortNumber(ftHandle: FT_HANDLE, lplComPortNumber: LPLONG) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetStatus"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the device status including number of characters in the receive queue, number of characters in the"]
    #[doc = " transmit queue, and the current event status."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwAmountInRxQueue Pointer to a variable of type DWORD which receives the number of characters in"]
    #[doc = " the receive queue."]
    #[doc = " @param lpdwAmountInTxQueue Pointer to a variable of type DWORD which receives the number of characters in"]
    #[doc = " the transmit queue."]
    #[doc = " @param lpdwEventStatus Pointer to a variable of type DWORD which receives the current state of"]
    #[doc = " the event status."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " For an example of how to use this function, see the sample code in FT_SetEventNotification."]
    pub fn FT_GetStatus(
        ftHandle: FT_HANDLE,
        lpdwAmountInRxQueue: *mut DWORD,
        lpdwAmountInTxQueue: *mut DWORD,
        lpdwEventStatus: *mut DWORD,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetEventNotification"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Sets conditions for event notification."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwEventMask Conditions that cause the event to be set."]
    #[doc = " @param pvArg Interpreted as the handle of an event."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " An application can use this function to setup conditions which allow a thread to block until one of the"]
    #[doc = " conditions is met. Typically, an application will create an event, call this function, then block on the"]
    #[doc = " event. When the conditions are met, the event is set, and the application thread unblocked."]
    #[doc = " dwEventMask is a bit-map that describes the events the application is interested in. pvArg is interpreted"]
    #[doc = " as the handle of an event which has been created by the application. If one of the event conditions is"]
    #[doc = " met, the event is set."]
    #[doc = " @n If FT_EVENT_RXCHAR is set in dwEventMask, the event will be set when a character has been received"]
    #[doc = " by the device."]
    #[doc = " @n If FT_EVENT_MODEM_STATUS is set in dwEventMask, the event will be set when a change in the modem"]
    #[doc = " signals has been detected by the device."]
    #[doc = " @n If FT_EVENT_LINE_STATUS is set in dwEventMask, the event will be set when a change in the line status"]
    #[doc = " has been detected by the device."]
    pub fn FT_SetEventNotification(
        ftHandle: FT_HANDLE,
        dwEventMask: DWORD,
        pvArg: PVOID,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetChars"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the special characters for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param uEventChar Event character."]
    #[doc = " @param uEventCharEnabled 0 if event character disabled, non-zero otherwise."]
    #[doc = " @param uErrorChar Error character."]
    #[doc = " @param uErrorCharEnabled 0 if error character disabled, non-zero otherwise."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function allows for inserting specified characters in the data stream to represent events firing or"]
    #[doc = " errors occurring."]
    pub fn FT_SetChars(
        ftHandle: FT_HANDLE,
        uEventChar: UCHAR,
        uEventCharEnabled: UCHAR,
        uErrorChar: UCHAR,
        uErrorCharEnabled: UCHAR,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetBreakOn"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Sets the BREAK condition for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code"]
    pub fn FT_SetBreakOn(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetBreakOff"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Resets the BREAK condition for the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_SetBreakOff(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Purge"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function purges receive and transmit buffers in the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ulMask Combination of FT_PURGE_RX and FT_PURGE_TX."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_Purge(ftHandle: FT_HANDLE, ulMask: ULONG) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ResetDevice"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sends a reset command to the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    pub fn FT_ResetDevice(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ResetPort"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Send a reset command to the port."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is used to attempt to recover the port after a failure. It is not equivalent"]
    #[doc = " to an unplug-replug event. For the equivalent of an unplug-replug event, use FT_CyclePort."]
    #[doc = " @see FT_CyclePort"]
    pub fn FT_ResetPort(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_CyclePort"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Send a cycle command to the USB port."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " The effect of this function is the same as disconnecting then reconnecting the device from"]
    #[doc = " USB. Possible use of this function is situations where a fatal error has occurred and it is"]
    #[doc = " difficult, or not possible, to recover without unplugging and replugging the USB cable."]
    #[doc = " This function can also be used after reprogramming the EEPROM to force the FTDI device to"]
    #[doc = " read the new EEPROM contents which would\totherwise require a physical disconnect-reconnect."]
    #[doc = " @n As the current session is not restored when the driver is reloaded, the application must"]
    #[doc = " be able to recover after calling this function. It is ithe responisbility of the application"]
    #[doc = " to close the handle after successfully calling FT_CyclePort."]
    #[doc = " @n For FT4232H, FT2232H and FT2232 devices, FT_CyclePort will only work under Windows XP and later."]
    pub fn FT_CyclePort(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Rescan"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function can be of use when trying to recover devices programatically."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " Calling FT_Rescan is equivalent to clicking the \"Scan for hardware changes\" button in the Device"]
    #[doc = " Manager. Only USB hardware is checked for new devices. All USB devices are scanned, not just FTDI"]
    #[doc = " devices."]
    pub fn FT_Rescan() -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_Reload"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function forces a reload of the driver for devices with a specific VID and PID combination."]
    #[doc = " @param wVID Vendor ID of the devices to reload the driver for."]
    #[doc = " @param wPID Product ID of the devices to reload the driver for."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " Calling FT_Reload forces the operating system to unload and reload the driver for the specified device"]
    #[doc = " IDs. If the VID and PID parameters are null, the drivers for USB root hubs will be reloaded, causing all"]
    #[doc = " USB devices connected to reload their drivers. Please note that this function will not work correctly on"]
    #[doc = " 64-bit Windows when called from a 32-bit application."]
    pub fn FT_Reload(wVID: WORD, wPID: WORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetResetPipeRetryCount"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Set the ResetPipeRetryCount value."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwCount Unsigned long containing required ResetPipeRetryCount."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is used to set the ResetPipeRetryCount. ResetPipeRetryCount controls the maximum"]
    #[doc = " number of times that the driver tries to reset a pipe on which an error has occurred."]
    #[doc = " ResetPipeRequestRetryCount defaults to 50. It may be necessary to increase this value in noisy"]
    #[doc = " environments where a lot of USB errors occur."]
    pub fn FT_SetResetPipeRetryCount(ftHandle: FT_HANDLE, dwCount: DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_StopInTask"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Stops the driver's IN task."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is used to put the driver's IN task (read) into a wait state. It can be used in situations"]
    #[doc = " where data is being received continuously, so that the device can be purged without more data being"]
    #[doc = " received. It is used together with FT_RestartInTask which sets the IN task running again."]
    #[doc = " @see FT_RestartInTask"]
    pub fn FT_StopInTask(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_RestartInTask"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Restart the driver's IN task."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function is used to restart the driver's IN task (read) after it has been stopped by a call to"]
    #[doc = " FT_StopInTask."]
    #[doc = " @see FT_StopInTask"]
    pub fn FT_RestartInTask(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetDeadmanTimeout"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function allows the maximum time in milliseconds that a USB request can remain outstanding to"]
    #[doc = " be set."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ulDeadmanTimeout Deadman timeout value in milliseconds. Default value is 5000."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " The deadman timeout is referred to in application note AN232B-10 Advanced Driver Options from the"]
    #[doc = " FTDI web site as the USB timeout. It is unlikely that this function will be required by most users."]
    pub fn FT_SetDeadmanTimeout(ftHandle: FT_HANDLE, ulDeadmanTimeout: ULONG) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_IoCtl"]
    #[doc = " Undocumented function."]
    pub fn FT_IoCtl(
        ftHandle: FT_HANDLE,
        dwIoControlCode: DWORD,
        lpInBuf: LPVOID,
        nInBufSize: DWORD,
        lpOutBuf: LPVOID,
        nOutBufSize: DWORD,
        lpBytesReturned: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetWaitMask"]
    #[doc = " Undocumented function."]
    pub fn FT_SetWaitMask(ftHandle: FT_HANDLE, Mask: DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_WaitOnMask"]
    #[doc = " Undocumented function."]
    pub fn FT_WaitOnMask(ftHandle: FT_HANDLE, Mask: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetEventStatus"]
    #[doc = " Undocumented function."]
    pub fn FT_GetEventStatus(ftHandle: FT_HANDLE, dwEventDWord: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ReadEE"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read a value from an EEPROM location."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwWordOffset EEPROM location to read from."]
    #[doc = " @param lpwValue Pointer to the WORD value read from the EEPROM."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " EEPROMs for FTDI devices are organised by WORD, so each value returned is 16-bits wide."]
    pub fn FT_ReadEE(ftHandle: FT_HANDLE, dwWordOffset: DWORD, lpwValue: LPWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_WriteEE"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Write a value to an EEPROM location."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwWordOffset EEPROM location to read from."]
    #[doc = " @param wValue The WORD value write to the EEPROM."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " EEPROMs for FTDI devices are organised by WORD, so each value written to the EEPROM is"]
    #[doc = " 16-bits wide."]
    pub fn FT_WriteEE(ftHandle: FT_HANDLE, dwWordOffset: DWORD, wValue: WORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EraseEE"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Erases the device EEPROM."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function will erase the entire contents of an EEPROM, including the user area."]
    #[doc = " Note that the FT232R\tand FT245R devices have an internal EEPROM that cannot be erased."]
    pub fn FT_EraseEE(ftHandle: FT_HANDLE) -> FT_STATUS;
}
#[doc = " Structure to hold program data for FT_EE_Program, FT_EE_ProgramEx, FT_EE_Read"]
#[doc = " and FT_EE_ReadEx functions."]
#[doc = " @see FT_EE_Read"]
#[doc = " @see FT_EE_ReadEx"]
#[doc = " @see FT_EE_Program"]
#[doc = " @see FT_EE_ProgramEx"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_program_data {
    pub Signature1: DWORD,
    #[doc = " Header - must be 0x00000000"]
    pub Signature2: DWORD,
    #[doc = " Header - must be 0xffffffff"]
    pub Version: DWORD,
    #[doc = " Header - FT_PROGRAM_DATA version"]
    pub VendorId: WORD,
    #[doc = " 0x0403"]
    pub ProductId: WORD,
    #[doc = " 0x6001"]
    pub Manufacturer: *mut ::std::os::raw::c_char,
    #[doc = " \"FTDI\""]
    pub ManufacturerId: *mut ::std::os::raw::c_char,
    #[doc = " \"FT\""]
    pub Description: *mut ::std::os::raw::c_char,
    #[doc = " \"USB HS Serial Converter\""]
    pub SerialNumber: *mut ::std::os::raw::c_char,
    #[doc = " \"FT000001\" if fixed, or NULL"]
    pub MaxPower: WORD,
    #[doc = " 0 < MaxPower <= 500"]
    pub PnP: WORD,
    #[doc = " 0 = disabled, 1 = enabled"]
    pub SelfPowered: WORD,
    #[doc = " 0 = bus powered, 1 = self powered"]
    pub RemoteWakeup: WORD,
    #[doc = " 0 = not capable, 1 = capable"]
    #[doc = " Rev4 (FT232B) extensions"]
    pub Rev4: UCHAR,
    #[doc = " non-zero if Rev4 chip, zero otherwise"]
    pub IsoIn: UCHAR,
    #[doc = " non-zero if in endpoint is isochronous"]
    pub IsoOut: UCHAR,
    #[doc = " non-zero if out endpoint is isochronous"]
    pub PullDownEnable: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnable: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub USBVersionEnable: UCHAR,
    #[doc = " non-zero if chip uses USBVersion"]
    pub USBVersion: WORD,
    #[doc = " BCD (0x0200 => USB2)"]
    #[doc = " Rev 5 (FT2232) extensions"]
    pub Rev5: UCHAR,
    #[doc = " non-zero if Rev5 chip, zero otherwise"]
    pub IsoInA: UCHAR,
    #[doc = " non-zero if in endpoint is isochronous"]
    pub IsoInB: UCHAR,
    #[doc = " non-zero if in endpoint is isochronous"]
    pub IsoOutA: UCHAR,
    #[doc = " non-zero if out endpoint is isochronous"]
    pub IsoOutB: UCHAR,
    #[doc = " non-zero if out endpoint is isochronous"]
    pub PullDownEnable5: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnable5: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub USBVersionEnable5: UCHAR,
    #[doc = " non-zero if chip uses USBVersion"]
    pub USBVersion5: WORD,
    #[doc = " BCD (0x0200 => USB2)"]
    pub AIsHighCurrent: UCHAR,
    #[doc = " non-zero if interface is high current"]
    pub BIsHighCurrent: UCHAR,
    #[doc = " non-zero if interface is high current"]
    pub IFAIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IFAIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IFAIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub AIsVCP: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub IFBIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IFBIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IFBIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub BIsVCP: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    #[doc = " Rev 6 (FT232R) extensions"]
    pub UseExtOsc: UCHAR,
    #[doc = " Use External Oscillator"]
    pub HighDriveIOs: UCHAR,
    #[doc = " High Drive I/Os"]
    pub EndpointSize: UCHAR,
    #[doc = " Endpoint size"]
    pub PullDownEnableR: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnableR: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub InvertTXD: UCHAR,
    #[doc = " non-zero if invert TXD"]
    pub InvertRXD: UCHAR,
    #[doc = " non-zero if invert RXD"]
    pub InvertRTS: UCHAR,
    #[doc = " non-zero if invert RTS"]
    pub InvertCTS: UCHAR,
    #[doc = " non-zero if invert CTS"]
    pub InvertDTR: UCHAR,
    #[doc = " non-zero if invert DTR"]
    pub InvertDSR: UCHAR,
    #[doc = " non-zero if invert DSR"]
    pub InvertDCD: UCHAR,
    #[doc = " non-zero if invert DCD"]
    pub InvertRI: UCHAR,
    #[doc = " non-zero if invert RI"]
    pub Cbus0: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus1: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus2: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus3: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus4: UCHAR,
    #[doc = " Cbus Mux control"]
    pub RIsD2XX: UCHAR,
    #[doc = " non-zero if using D2XX driver"]
    #[doc = " Rev 7 (FT2232H) Extensions"]
    pub PullDownEnable7: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnable7: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub ALSlowSlew: UCHAR,
    #[doc = " non-zero if AL pins have slow slew"]
    pub ALSchmittInput: UCHAR,
    #[doc = " non-zero if AL pins are Schmitt input"]
    pub ALDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub AHSlowSlew: UCHAR,
    #[doc = " non-zero if AH pins have slow slew"]
    pub AHSchmittInput: UCHAR,
    #[doc = " non-zero if AH pins are Schmitt input"]
    pub AHDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BLSlowSlew: UCHAR,
    #[doc = " non-zero if BL pins have slow slew"]
    pub BLSchmittInput: UCHAR,
    #[doc = " non-zero if BL pins are Schmitt input"]
    pub BLDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BHSlowSlew: UCHAR,
    #[doc = " non-zero if BH pins have slow slew"]
    pub BHSchmittInput: UCHAR,
    #[doc = " non-zero if BH pins are Schmitt input"]
    pub BHDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub IFAIsFifo7: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IFAIsFifoTar7: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IFAIsFastSer7: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub AIsVCP7: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub IFBIsFifo7: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IFBIsFifoTar7: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IFBIsFastSer7: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub BIsVCP7: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub PowerSaveEnable: UCHAR,
    #[doc = " non-zero if using BCBUS7 to save power for self-powered designs"]
    #[doc = " Rev 8 (FT4232H) Extensions"]
    pub PullDownEnable8: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnable8: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub ASlowSlew: UCHAR,
    #[doc = " non-zero if A pins have slow slew"]
    pub ASchmittInput: UCHAR,
    #[doc = " non-zero if A pins are Schmitt input"]
    pub ADriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BSlowSlew: UCHAR,
    #[doc = " non-zero if B pins have slow slew"]
    pub BSchmittInput: UCHAR,
    #[doc = " non-zero if B pins are Schmitt input"]
    pub BDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub CSlowSlew: UCHAR,
    #[doc = " non-zero if C pins have slow slew"]
    pub CSchmittInput: UCHAR,
    #[doc = " non-zero if C pins are Schmitt input"]
    pub CDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub DSlowSlew: UCHAR,
    #[doc = " non-zero if D pins have slow slew"]
    pub DSchmittInput: UCHAR,
    #[doc = " non-zero if D pins are Schmitt input"]
    pub DDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub ARIIsTXDEN: UCHAR,
    #[doc = " non-zero if port A uses RI as RS485 TXDEN"]
    pub BRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port B uses RI as RS485 TXDEN"]
    pub CRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port C uses RI as RS485 TXDEN"]
    pub DRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port D uses RI as RS485 TXDEN"]
    pub AIsVCP8: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub BIsVCP8: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub CIsVCP8: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub DIsVCP8: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    #[doc = " Rev 9 (FT232H) Extensions"]
    pub PullDownEnableH: UCHAR,
    #[doc = " non-zero if pull down enabled"]
    pub SerNumEnableH: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    pub ACSlowSlewH: UCHAR,
    #[doc = " non-zero if AC pins have slow slew"]
    pub ACSchmittInputH: UCHAR,
    #[doc = " non-zero if AC pins are Schmitt input"]
    pub ACDriveCurrentH: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub ADSlowSlewH: UCHAR,
    #[doc = " non-zero if AD pins have slow slew"]
    pub ADSchmittInputH: UCHAR,
    #[doc = " non-zero if AD pins are Schmitt input"]
    pub ADDriveCurrentH: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub Cbus0H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus1H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus2H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus3H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus4H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus5H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus6H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus7H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus8H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus9H: UCHAR,
    #[doc = " Cbus Mux control"]
    pub IsFifoH: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IsFifoTarH: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IsFastSerH: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub IsFT1248H: UCHAR,
    #[doc = " non-zero if interface is FT1248"]
    pub FT1248CpolH: UCHAR,
    #[doc = " FT1248 clock polarity - clock idle high (1) or clock idle low (0)"]
    pub FT1248LsbH: UCHAR,
    #[doc = " FT1248 data is LSB (1) or MSB (0)"]
    pub FT1248FlowControlH: UCHAR,
    #[doc = " FT1248 flow control enable"]
    pub IsVCPH: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub PowerSaveEnableH: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_program_data() {
    assert_eq!(
        ::std::mem::size_of::<ft_program_data>(),
        176usize,
        concat!("Size of: ", stringify!(ft_program_data))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_program_data>(),
        8usize,
        concat!("Alignment of ", stringify!(ft_program_data))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Signature1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Signature1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Signature2 as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Signature2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).VendorId as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(VendorId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ProductId as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ProductId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Manufacturer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Manufacturer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ManufacturerId as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ManufacturerId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Description as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerialNumber as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerialNumber)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).MaxPower as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(MaxPower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PnP as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PnP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SelfPowered as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SelfPowered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).RemoteWakeup as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(RemoteWakeup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Rev4 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Rev4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoIn as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoIn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOut as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOut)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable as *const _ as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).USBVersionEnable as *const _ as usize
        },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersionEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).USBVersion as *const _ as usize },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Rev5 as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Rev5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoInA as *const _ as usize },
        65usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoInA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoInB as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoInB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOutA as *const _ as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOutA)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsoOutB as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsoOutB)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable5 as *const _ as usize },
        69usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable5 as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).USBVersionEnable5 as *const _ as usize
        },
        71usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersionEnable5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).USBVersion5 as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(USBVersion5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsHighCurrent as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsHighCurrent as *const _ as usize },
        75usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifo as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifoTar as *const _ as usize },
        77usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFastSer as *const _ as usize },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP as *const _ as usize },
        79usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifo as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifoTar as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFastSer as *const _ as usize },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP as *const _ as usize },
        83usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).UseExtOsc as *const _ as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(UseExtOsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).HighDriveIOs as *const _ as usize },
        85usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(HighDriveIOs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).EndpointSize as *const _ as usize },
        86usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(EndpointSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnableR as *const _ as usize },
        87usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnableR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnableR as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnableR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertTXD as *const _ as usize },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRXD as *const _ as usize },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRTS as *const _ as usize },
        91usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertCTS as *const _ as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDTR as *const _ as usize },
        93usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDSR as *const _ as usize },
        94usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertDCD as *const _ as usize },
        95usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).InvertRI as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus0 as *const _ as usize },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus1 as *const _ as usize },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus2 as *const _ as usize },
        99usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus3 as *const _ as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus4 as *const _ as usize },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).RIsD2XX as *const _ as usize },
        102usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(RIsD2XX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable7 as *const _ as usize },
        103usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable7 as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALSlowSlew as *const _ as usize },
        105usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALSchmittInput as *const _ as usize },
        106usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ALDriveCurrent as *const _ as usize },
        107usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ALDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHSlowSlew as *const _ as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHSchmittInput as *const _ as usize },
        109usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AHDriveCurrent as *const _ as usize },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLSlowSlew as *const _ as usize },
        111usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLSchmittInput as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BLDriveCurrent as *const _ as usize },
        113usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BLDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHSlowSlew as *const _ as usize },
        114usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHSchmittInput as *const _ as usize },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BHDriveCurrent as *const _ as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifo7 as *const _ as usize },
        117usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifo7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFifoTar7 as *const _ as usize },
        118usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFifoTar7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFAIsFastSer7 as *const _ as usize },
        119usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFAIsFastSer7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP7 as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifo7 as *const _ as usize },
        121usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifo7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFifoTar7 as *const _ as usize },
        122usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFifoTar7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IFBIsFastSer7 as *const _ as usize },
        123usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IFBIsFastSer7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP7 as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PowerSaveEnable as *const _ as usize },
        125usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnable8 as *const _ as usize },
        126usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnable8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnable8 as *const _ as usize },
        127usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnable8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ASlowSlew as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ASlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ASchmittInput as *const _ as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ASchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADriveCurrent as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BSlowSlew as *const _ as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BSchmittInput as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BDriveCurrent as *const _ as usize },
        133usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CSlowSlew as *const _ as usize },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CSchmittInput as *const _ as usize },
        135usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CDriveCurrent as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DSlowSlew as *const _ as usize },
        137usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DSchmittInput as *const _ as usize },
        138usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DDriveCurrent as *const _ as usize },
        139usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ARIIsTXDEN as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ARIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BRIIsTXDEN as *const _ as usize },
        141usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CRIIsTXDEN as *const _ as usize },
        142usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DRIIsTXDEN as *const _ as usize },
        143usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).AIsVCP8 as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(AIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).BIsVCP8 as *const _ as usize },
        145usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(BIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).CIsVCP8 as *const _ as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(CIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).DIsVCP8 as *const _ as usize },
        147usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(DIsVCP8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).PullDownEnableH as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PullDownEnableH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).SerNumEnableH as *const _ as usize },
        149usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(SerNumEnableH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACSlowSlewH as *const _ as usize },
        150usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACSlowSlewH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACSchmittInputH as *const _ as usize },
        151usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACSchmittInputH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ACDriveCurrentH as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ACDriveCurrentH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADSlowSlewH as *const _ as usize },
        153usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADSlowSlewH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADSchmittInputH as *const _ as usize },
        154usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADSchmittInputH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).ADDriveCurrentH as *const _ as usize },
        155usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(ADDriveCurrentH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus0H as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus0H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus1H as *const _ as usize },
        157usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus1H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus2H as *const _ as usize },
        158usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus2H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus3H as *const _ as usize },
        159usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus3H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus4H as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus4H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus5H as *const _ as usize },
        161usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus5H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus6H as *const _ as usize },
        162usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus6H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus7H as *const _ as usize },
        163usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus7H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus8H as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus8H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).Cbus9H as *const _ as usize },
        165usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(Cbus9H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFifoH as *const _ as usize },
        166usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFifoH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFifoTarH as *const _ as usize },
        167usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFifoTarH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFastSerH as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFastSerH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsFT1248H as *const _ as usize },
        169usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsFT1248H)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).FT1248CpolH as *const _ as usize },
        170usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248CpolH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).FT1248LsbH as *const _ as usize },
        171usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248LsbH)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).FT1248FlowControlH as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(FT1248FlowControlH)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_program_data>())).IsVCPH as *const _ as usize },
        173usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(IsVCPH)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_program_data>())).PowerSaveEnableH as *const _ as usize
        },
        174usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_program_data),
            "::",
            stringify!(PowerSaveEnableH)
        )
    );
}
#[doc = " Structure to hold program data for FT_EE_Program, FT_EE_ProgramEx, FT_EE_Read"]
#[doc = " and FT_EE_ReadEx functions."]
#[doc = " @see FT_EE_Read"]
#[doc = " @see FT_EE_ReadEx"]
#[doc = " @see FT_EE_Program"]
#[doc = " @see FT_EE_ProgramEx"]
pub type FT_PROGRAM_DATA = ft_program_data;
#[doc = " Structure to hold program data for FT_EE_Program, FT_EE_ProgramEx, FT_EE_Read"]
#[doc = " and FT_EE_ReadEx functions."]
#[doc = " @see FT_EE_Read"]
#[doc = " @see FT_EE_ReadEx"]
#[doc = " @see FT_EE_Program"]
#[doc = " @see FT_EE_ProgramEx"]
pub type PFT_PROGRAM_DATA = *mut ft_program_data;
extern "C" {
    #[doc = " @noop FT_EE_Read"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read the contents of the EEPROM."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pData Pointer to structure of type FT_PROGRAM_DATA."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter pData as a pointer to a structure of type FT_PROGRAM_DATA"]
    #[doc = " that contains storage for the data to be read from the EEPROM."]
    #[doc = " @n The function does not perform any checks on buffer sizes, so the buffers passed in the"]
    #[doc = " FT_PROGRAM_DATA structure must be big enough to accommodate their respective strings (including"]
    #[doc = " null terminators). The sizes shown in the following example are more than adequate and can be rounded"]
    #[doc = " down if necessary. The restriction is that the Manufacturer string length plus the Description string"]
    #[doc = " length is less than or equal to 40 characters."]
    #[doc = " @note Note that the DLL must be informed which version of the FT_PROGRAM_DATA structure is being used."]
    #[doc = " This is done through the Signature1, Signature2 and Version elements of the structure. Signature1"]
    #[doc = " should always be 0x00000000, Signature2 should always be 0xFFFFFFFF and Version can be set to use"]
    #[doc = " whichever version is required. For compatibility with all current devices Version should be set to the"]
    #[doc = " latest version of the FT_PROGRAM_DATA structure which is defined in FTD2XX.h."]
    #[doc = " @see FT_PROGRAM_DATA"]
    pub fn FT_EE_Read(ftHandle: FT_HANDLE, pData: PFT_PROGRAM_DATA) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_ReadEx"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read the contents of the EEPROM and pass strings separately."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pData Pointer to structure of type FT_PROGRAM_DATA."]
    #[doc = " @param *Manufacturer Pointer to a null-terminated string containing the manufacturer name."]
    #[doc = " @param *ManufacturerId Pointer to a null-terminated string containing the manufacturer ID."]
    #[doc = " @param *Description Pointer to a null-terminated string containing the device description."]
    #[doc = " @param *SerialNumber Pointer to a null-terminated string containing the device serial number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This variation of the standard FT_EE_Read function was included to provide support for languages such"]
    #[doc = " as LabVIEW where problems can occur when string pointers are contained in a structure."]
    #[doc = " @n This function interprets the parameter pData as a pointer to a structure of type FT_PROGRAM_DATA that"]
    #[doc = " contains storage for the data to be read from the EEPROM."]
    #[doc = " @n The function does not perform any checks on buffer sizes, so the buffers passed in the"]
    #[doc = " FT_PROGRAM_DATA structure must be big enough to accommodate their respective strings (including"]
    #[doc = " null terminators)."]
    #[doc = " @note Note that the DLL must be informed which version of the FT_PROGRAM_DATA structure is being used."]
    #[doc = " This is done through the Signature1, Signature2 and Version elements of the structure. Signature1"]
    #[doc = " should always be 0x00000000, Signature2 should always be 0xFFFFFFFF and Version can be set to use"]
    #[doc = " whichever version is required. For compatibility with all current devices Version should be set to the"]
    #[doc = " latest version of the FT_PROGRAM_DATA structure which is defined in FTD2XX.h."]
    #[doc = " @n The string parameters in the FT_PROGRAM_DATA structure should be passed as DWORDs to avoid"]
    #[doc = " overlapping of parameters. All string pointers are passed out separately from the FT_PROGRAM_DATA"]
    #[doc = " structure."]
    #[doc = " @see FT_PROGRAM_DATA"]
    pub fn FT_EE_ReadEx(
        ftHandle: FT_HANDLE,
        pData: PFT_PROGRAM_DATA,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_Program"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Program the EEPROM."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pData Pointer to structure of type FT_PROGRAM_DATA."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter pData as a pointer to a structure of type FT_PROGRAM_DATA"]
    #[doc = " that\tcontains the data to write to the EEPROM. The data is written to EEPROM, then read back and"]
    #[doc = " verified."]
    #[doc = " @n If the SerialNumber field in FT_PROGRAM_DATA is NULL, or SerialNumber points to a NULL string,"]
    #[doc = " a serial number based on the ManufacturerId and the current date and time will be generated. The"]
    #[doc = " Manufacturer string length plus the Description string length must be less than or equal to 40"]
    #[doc = " characters."]
    #[doc = " @note Note that the DLL must be informed which version of the FT_PROGRAM_DATA structure is being"]
    #[doc = " used. This is done through the Signature1, Signature2 and Version elements of the structure."]
    #[doc = " Signature1 should always be 0x00000000, Signature2 should always be 0xFFFFFFFF and Version can be"]
    #[doc = " set to use whichever version is required. For compatibility with all current devices Version"]
    #[doc = " should be set to the latest version of the FT_PROGRAM_DATA structure which is defined in FTD2XX.h."]
    #[doc = " If pData is NULL, the structure version will default to 0 (original BM series) and the device will"]
    #[doc = " be programmed with the default data."]
    #[doc = " @see FT_PROGRAM_DATA"]
    pub fn FT_EE_Program(ftHandle: FT_HANDLE, pData: PFT_PROGRAM_DATA) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_ProgramEx"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Program the EEPROM and pass strings separately."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pData Pointer to structure of type FT_PROGRAM_DATA."]
    #[doc = " @param *Manufacturer Pointer to a null-terminated string containing the manufacturer name."]
    #[doc = " @param *ManufacturerId Pointer to a null-terminated string containing the manufacturer ID."]
    #[doc = " @param *Description Pointer to a null-terminated string containing the device description."]
    #[doc = " @param *SerialNumber Pointer to a null-terminated string containing the device serial number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This variation of the FT_EE_Program function was included to provide support for languages such"]
    #[doc = " as LabVIEW where problems can occur when string pointers are contained in a structure."]
    #[doc = " @n This function interprets the parameter pData as a pointer to a structure of type FT_PROGRAM_DATA"]
    #[doc = " that contains the data to write to the EEPROM. The data is written to EEPROM, then read back and"]
    #[doc = " verified. The string pointer parameters in the FT_PROGRAM_DATA structure should be allocated as"]
    #[doc = " DWORDs to avoid overlapping of parameters. The string parameters are then passed in separately."]
    #[doc = " @n If the SerialNumber field is NULL, or SerialNumber points to a NULL string, a serial number based"]
    #[doc = " on the ManufacturerId and the current date and time will be generated. The Manufacturer string"]
    #[doc = " length plus the Description string length must be less than or equal to 40 characters."]
    #[doc = " @note Note that the DLL must be informed which version of the FT_PROGRAM_DATA structure is being used."]
    #[doc = " This is done through the Signature1, Signature2 and Version elements of the structure. Signature1"]
    #[doc = " should always be 0x00000000, Signature2 should always be 0xFFFFFFFF and Version can be set to use"]
    #[doc = " whichever version is required. For compatibility with all current devices Version should be set to the"]
    #[doc = " latest version of the FT_PROGRAM_DATA structure which is defined in FTD2XX.h."]
    #[doc = " If pData is NULL, the structure version will default to 0 (original BM series) and the device will be"]
    #[doc = " programmed with the default data."]
    #[doc = " @see FT_PROGRAM_DATA"]
    pub fn FT_EE_ProgramEx(
        ftHandle: FT_HANDLE,
        pData: PFT_PROGRAM_DATA,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_UASize"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Get the available size of the EEPROM user area."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwSize Pointer to a DWORD that receives the available size, in bytes, of the EEPROM"]
    #[doc = " user area."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " The user area of an FTDI device EEPROM is the total area of the EEPROM that is unused by device"]
    #[doc = " configuration information and descriptors. This area is available to the user to store information"]
    #[doc = " specific\tto their application. The size of the user area depends on the length of the Manufacturer,"]
    #[doc = " ManufacturerId, Description and SerialNumber strings programmed into the EEPROM."]
    pub fn FT_EE_UASize(ftHandle: FT_HANDLE, lpdwSize: LPDWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_UARead"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read the contents of the EEPROM user area."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pucData Pointer to a buffer that contains storage for data to be read."]
    #[doc = " @param dwDataLen Size, in bytes, of buffer that contains storage for the data to be read."]
    #[doc = " @param lpdwBytesRead Pointer to a DWORD that receives the number of bytes read."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter pucData as a pointer to an array of bytes of size"]
    #[doc = " dwDataLen that contains storage for the data to be read from the EEPROM user area. The actual"]
    #[doc = " number of bytes read is stored in the DWORD referenced by lpdwBytesRead."]
    #[doc = " @n If dwDataLen is less than the size of the EEPROM user area, then dwDataLen bytes are read"]
    #[doc = " into the buffer. Otherwise, the whole of the EEPROM user area is read into the buffer. The"]
    #[doc = " available user area size can be determined by calling FT_EE_UASize."]
    #[doc = " @n An application should check the function return value and lpdwBytesRead when FT_EE_UARead"]
    #[doc = " returns."]
    pub fn FT_EE_UARead(
        ftHandle: FT_HANDLE,
        pucData: PUCHAR,
        dwDataLen: DWORD,
        lpdwBytesRead: LPDWORD,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_UAWrite"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Write data into the EEPROM user area."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pucData Pointer to a buffer that contains the data to be written."]
    #[doc = " @param dwDataLen Size, in bytes, of buffer that contains storage for the data to be read."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter pucData as a pointer to an array of bytes of size"]
    #[doc = " dwDataLen that contains the data to be written to the EEPROM user area. It is a programming"]
    #[doc = " error for dwDataLen to be greater than the size of the EEPROM user area. The available user"]
    #[doc = " area size can be determined by calling FT_EE_UASize."]
    pub fn FT_EE_UAWrite(ftHandle: FT_HANDLE, pucData: PUCHAR, dwDataLen: DWORD) -> FT_STATUS;
}
#[doc = "  @noop FT_EEPROM_HEADER"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " The structure for the command includes one FT_EEPROM_HEADER with a device-specific"]
#[doc = " structure appended."]
#[doc = " @see FT_EEPROM_Read"]
#[doc = " @see FT_EEPROM_Program"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_header {
    pub deviceType: FT_DEVICE,
    #[doc = " FTxxxx device type to be programmed"]
    #[doc = " Device descriptor options"]
    pub VendorId: WORD,
    #[doc = " 0x0403"]
    pub ProductId: WORD,
    #[doc = " 0x6001"]
    pub SerNumEnable: UCHAR,
    #[doc = " non-zero if serial number to be used"]
    #[doc = " Config descriptor options"]
    pub MaxPower: WORD,
    #[doc = " 0 < MaxPower <= 500"]
    pub SelfPowered: UCHAR,
    #[doc = " 0 = bus powered, 1 = self powered"]
    pub RemoteWakeup: UCHAR,
    #[doc = " 0 = not capable, 1 = capable"]
    #[doc = " Hardware options"]
    pub PullDownEnable: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_header() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_header>(),
        16usize,
        concat!("Size of: ", stringify!(ft_eeprom_header))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_header>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_header))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).deviceType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(deviceType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).VendorId as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(VendorId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).ProductId as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(ProductId)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).SerNumEnable as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(SerNumEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).MaxPower as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(MaxPower)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).SelfPowered as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(SelfPowered)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).RemoteWakeup as *const _ as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(RemoteWakeup)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_header>())).PullDownEnable as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_header),
            "::",
            stringify!(PullDownEnable)
        )
    );
}
#[doc = "  @noop FT_EEPROM_HEADER"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " The structure for the command includes one FT_EEPROM_HEADER with a device-specific"]
#[doc = " structure appended."]
#[doc = " @see FT_EEPROM_Read"]
#[doc = " @see FT_EEPROM_Program"]
pub type FT_EEPROM_HEADER = ft_eeprom_header;
#[doc = "  @noop FT_EEPROM_232B"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232B data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_232b {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232b() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232b>(),
        16usize,
        concat!("Size of: ", stringify!(ft_eeprom_232b))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232b>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232b))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232b>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232b),
            "::",
            stringify!(common)
        )
    );
}
#[doc = "  @noop FT_EEPROM_232B"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232B data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_232B = ft_eeprom_232b;
#[doc = "  @noop FT_EEPROM_2232"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT2232C, FT2232D and FT2232L data in the FT_EEPROM_Program"]
#[doc = " and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_2232 {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub AIsHighCurrent: UCHAR,
    #[doc = " non-zero if interface is high current"]
    pub BIsHighCurrent: UCHAR,
    #[doc = " non-zero if interface is high current"]
    #[doc = " Hardware options"]
    pub AIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub AIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub AIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub BIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub BIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub BIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    #[doc = " Driver option"]
    pub ADriverType: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub BDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_2232() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_2232>(),
        28usize,
        concat!("Size of: ", stringify!(ft_eeprom_2232))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_2232>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_2232))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsHighCurrent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsHighCurrent as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFifo as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFifoTar as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).AIsFastSer as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(AIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFifo as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFifoTar as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BIsFastSer as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).ADriverType as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232>())).BDriverType as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232),
            "::",
            stringify!(BDriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_2232"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT2232C, FT2232D and FT2232L data in the FT_EEPROM_Program"]
#[doc = " and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_2232 = ft_eeprom_2232;
#[doc = "  @noop FT_EEPROM_232R"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232R data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_232r {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub IsHighCurrent: UCHAR,
    #[doc = " non-zero if interface is high current"]
    #[doc = " Hardware options"]
    pub UseExtOsc: UCHAR,
    #[doc = " Use External Oscillator"]
    pub InvertTXD: UCHAR,
    #[doc = " non-zero if invert TXD"]
    pub InvertRXD: UCHAR,
    #[doc = " non-zero if invert RXD"]
    pub InvertRTS: UCHAR,
    #[doc = " non-zero if invert RTS"]
    pub InvertCTS: UCHAR,
    #[doc = " non-zero if invert CTS"]
    pub InvertDTR: UCHAR,
    #[doc = " non-zero if invert DTR"]
    pub InvertDSR: UCHAR,
    #[doc = " non-zero if invert DSR"]
    pub InvertDCD: UCHAR,
    #[doc = " non-zero if invert DCD"]
    pub InvertRI: UCHAR,
    #[doc = " non-zero if invert RI"]
    pub Cbus0: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus1: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus2: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus3: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus4: UCHAR,
    #[doc = " Cbus Mux control"]
    #[doc = " Driver option"]
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232r() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232r>(),
        32usize,
        concat!("Size of: ", stringify!(ft_eeprom_232r))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232r>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232r))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).IsHighCurrent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(IsHighCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).UseExtOsc as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(UseExtOsc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertTXD as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRXD as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRTS as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertCTS as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDTR as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDSR as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertDCD as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).InvertRI as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus0 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus1 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus2 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus3 as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).Cbus4 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232r>())).DriverType as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232r),
            "::",
            stringify!(DriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_232R"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232R data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_232R = ft_eeprom_232r;
#[doc = "  @noop FT_EEPROM_2232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT2232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_2232h {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub ALSlowSlew: UCHAR,
    #[doc = " non-zero if AL pins have slow slew"]
    pub ALSchmittInput: UCHAR,
    #[doc = " non-zero if AL pins are Schmitt input"]
    pub ALDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub AHSlowSlew: UCHAR,
    #[doc = " non-zero if AH pins have slow slew"]
    pub AHSchmittInput: UCHAR,
    #[doc = " non-zero if AH pins are Schmitt input"]
    pub AHDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BLSlowSlew: UCHAR,
    #[doc = " non-zero if BL pins have slow slew"]
    pub BLSchmittInput: UCHAR,
    #[doc = " non-zero if BL pins are Schmitt input"]
    pub BLDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BHSlowSlew: UCHAR,
    #[doc = " non-zero if BH pins have slow slew"]
    pub BHSchmittInput: UCHAR,
    #[doc = " non-zero if BH pins are Schmitt input"]
    pub BHDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    #[doc = " Hardware options"]
    pub AIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub AIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub AIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub BIsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub BIsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub BIsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub PowerSaveEnable: UCHAR,
    #[doc = " non-zero if using BCBUS7 to save power for self-powered designs"]
    #[doc = " Driver option"]
    pub ADriverType: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub BDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_2232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_2232h>(),
        40usize,
        concat!("Size of: ", stringify!(ft_eeprom_2232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_2232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_2232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALSchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ALDriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ALDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AHDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLSlowSlew as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLSchmittInput as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BLDriveCurrent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BLDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHSlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHSchmittInput as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BHDriveCurrent as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BHDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFifo as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFifoTar as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).AIsFastSer as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(AIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFifo as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFifoTar as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BIsFastSer as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BIsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).PowerSaveEnable as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).ADriverType as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_2232h>())).BDriverType as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_2232h),
            "::",
            stringify!(BDriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_2232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT2232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_2232H = ft_eeprom_2232h;
#[doc = "  @noop FT_EEPROM_4232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT4232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_4232h {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub ASlowSlew: UCHAR,
    #[doc = " non-zero if A pins have slow slew"]
    pub ASchmittInput: UCHAR,
    #[doc = " non-zero if A pins are Schmitt input"]
    pub ADriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub BSlowSlew: UCHAR,
    #[doc = " non-zero if B pins have slow slew"]
    pub BSchmittInput: UCHAR,
    #[doc = " non-zero if B pins are Schmitt input"]
    pub BDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub CSlowSlew: UCHAR,
    #[doc = " non-zero if C pins have slow slew"]
    pub CSchmittInput: UCHAR,
    #[doc = " non-zero if C pins are Schmitt input"]
    pub CDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub DSlowSlew: UCHAR,
    #[doc = " non-zero if D pins have slow slew"]
    pub DSchmittInput: UCHAR,
    #[doc = " non-zero if D pins are Schmitt input"]
    pub DDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    #[doc = " Hardware options"]
    pub ARIIsTXDEN: UCHAR,
    #[doc = " non-zero if port A uses RI as RS485 TXDEN"]
    pub BRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port B uses RI as RS485 TXDEN"]
    pub CRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port C uses RI as RS485 TXDEN"]
    pub DRIIsTXDEN: UCHAR,
    #[doc = " non-zero if port D uses RI as RS485 TXDEN"]
    #[doc = " Driver option"]
    pub ADriverType: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub BDriverType: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub CDriverType: UCHAR,
    #[doc = " non-zero if interface is to use VCP drivers"]
    pub DDriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_4232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_4232h>(),
        36usize,
        concat!("Size of: ", stringify!(ft_eeprom_4232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_4232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_4232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ASlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ASlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ASchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ASchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ADriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ADriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CSlowSlew as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CSchmittInput as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CDriveCurrent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DSlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DSchmittInput as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DDriveCurrent as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ARIIsTXDEN as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ARIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BRIIsTXDEN as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CRIIsTXDEN as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DRIIsTXDEN as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DRIIsTXDEN)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).ADriverType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(ADriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).BDriverType as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(BDriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).CDriverType as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(CDriverType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4232h>())).DDriverType as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4232h),
            "::",
            stringify!(DDriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_4232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT4232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_4232H = ft_eeprom_4232h;
#[doc = "  @noop FT_EEPROM_232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_232h {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub ACSlowSlew: UCHAR,
    #[doc = " non-zero if AC bus pins have slow slew"]
    pub ACSchmittInput: UCHAR,
    #[doc = " non-zero if AC bus pins are Schmitt input"]
    pub ACDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub ADSlowSlew: UCHAR,
    #[doc = " non-zero if AD bus pins have slow slew"]
    pub ADSchmittInput: UCHAR,
    #[doc = " non-zero if AD bus pins are Schmitt input"]
    pub ADDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    #[doc = " CBUS options"]
    pub Cbus0: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus1: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus2: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus3: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus4: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus5: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus6: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus7: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus8: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus9: UCHAR,
    #[doc = " Cbus Mux control"]
    #[doc = " FT1248 options"]
    pub FT1248Cpol: UCHAR,
    #[doc = " FT1248 clock polarity - clock idle high (1) or clock idle low (0)"]
    pub FT1248Lsb: UCHAR,
    #[doc = " FT1248 data is LSB (1) or MSB (0)"]
    pub FT1248FlowControl: UCHAR,
    #[doc = " FT1248 flow control enable"]
    #[doc = " Hardware options"]
    pub IsFifo: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO"]
    pub IsFifoTar: UCHAR,
    #[doc = " non-zero if interface is 245 FIFO CPU target"]
    pub IsFastSer: UCHAR,
    #[doc = " non-zero if interface is Fast serial"]
    pub IsFT1248: UCHAR,
    #[doc = " non-zero if interface is FT1248"]
    pub PowerSaveEnable: UCHAR,
    #[doc = ""]
    #[doc = " Driver option"]
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_232h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_232h>(),
        44usize,
        concat!("Size of: ", stringify!(ft_eeprom_232h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_232h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_232h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACSchmittInput as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ACDriveCurrent as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ACDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADSlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADSchmittInput as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADSchmittInput)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).ADDriveCurrent as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(ADDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus0 as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus1 as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus3 as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus4 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus5 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus7 as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus8 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).Cbus9 as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(Cbus9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248Cpol as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248Cpol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248Lsb as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248Lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_232h>())).FT1248FlowControl as *const _ as usize
        },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(FT1248FlowControl)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFifo as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFifo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFifoTar as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFifoTar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFastSer as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFastSer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).IsFT1248 as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(IsFT1248)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).PowerSaveEnable as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_232h>())).DriverType as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_232h),
            "::",
            stringify!(DriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_232H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT232H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_232H = ft_eeprom_232h;
#[doc = "  @noop FT_EEPROM_X_SERIES"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT-X series data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_x_series {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    #[doc = " Drive options"]
    pub ACSlowSlew: UCHAR,
    #[doc = " non-zero if AC bus pins have slow slew"]
    pub ACSchmittInput: UCHAR,
    #[doc = " non-zero if AC bus pins are Schmitt input"]
    pub ACDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub ADSlowSlew: UCHAR,
    #[doc = " non-zero if AD bus pins have slow slew"]
    pub ADSchmittInput: UCHAR,
    #[doc = " non-zero if AD bus pins are Schmitt input"]
    pub ADDriveCurrent: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    #[doc = " CBUS options"]
    pub Cbus0: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus1: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus2: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus3: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus4: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus5: UCHAR,
    #[doc = " Cbus Mux control"]
    pub Cbus6: UCHAR,
    #[doc = " Cbus Mux control"]
    #[doc = " UART signal options"]
    pub InvertTXD: UCHAR,
    #[doc = " non-zero if invert TXD"]
    pub InvertRXD: UCHAR,
    #[doc = " non-zero if invert RXD"]
    pub InvertRTS: UCHAR,
    #[doc = " non-zero if invert RTS"]
    pub InvertCTS: UCHAR,
    #[doc = " non-zero if invert CTS"]
    pub InvertDTR: UCHAR,
    #[doc = " non-zero if invert DTR"]
    pub InvertDSR: UCHAR,
    #[doc = " non-zero if invert DSR"]
    pub InvertDCD: UCHAR,
    #[doc = " non-zero if invert DCD"]
    pub InvertRI: UCHAR,
    #[doc = " non-zero if invert RI"]
    #[doc = " Battery Charge Detect options"]
    pub BCDEnable: UCHAR,
    #[doc = " Enable Battery Charger Detection"]
    pub BCDForceCbusPWREN: UCHAR,
    #[doc = " asserts the power enable signal on CBUS when charging port detected"]
    pub BCDDisableSleep: UCHAR,
    #[doc = " forces the device never to go into sleep mode"]
    #[doc = " I2C options"]
    pub I2CSlaveAddress: WORD,
    #[doc = " I2C slave device address"]
    pub I2CDeviceId: DWORD,
    #[doc = " I2C device ID"]
    pub I2CDisableSchmitt: UCHAR,
    #[doc = " Disable I2C Schmitt trigger"]
    #[doc = " FT1248 options"]
    pub FT1248Cpol: UCHAR,
    #[doc = " FT1248 clock polarity - clock idle high (1) or clock idle low (0)"]
    pub FT1248Lsb: UCHAR,
    #[doc = " FT1248 data is LSB (1) or MSB (0)"]
    pub FT1248FlowControl: UCHAR,
    #[doc = " FT1248 flow control enable"]
    #[doc = " Hardware options"]
    pub RS485EchoSuppress: UCHAR,
    #[doc = ""]
    pub PowerSaveEnable: UCHAR,
    #[doc = ""]
    #[doc = " Driver option"]
    pub DriverType: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_x_series() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_x_series>(),
        56usize,
        concat!("Size of: ", stringify!(ft_eeprom_x_series))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_x_series>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_x_series))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACSlowSlew as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACSlowSlew)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACSchmittInput as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACSchmittInput)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ACDriveCurrent as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ACDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADSlowSlew as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADSlowSlew)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADSchmittInput as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADSchmittInput)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).ADDriveCurrent as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(ADDriveCurrent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus0 as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus1 as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus3 as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus4 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus5 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).Cbus6 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(Cbus6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertTXD as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertTXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRXD as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRXD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRTS as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertCTS as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertCTS)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDTR as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDTR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDSR as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDSR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertDCD as *const _ as usize },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertDCD)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).InvertRI as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(InvertRI)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDEnable as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDForceCbusPWREN as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDForceCbusPWREN)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).BCDDisableSleep as *const _ as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(BCDDisableSleep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CSlaveAddress as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CSlaveAddress)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CDeviceId as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CDeviceId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).I2CDisableSchmitt as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(I2CDisableSchmitt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248Cpol as *const _ as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248Cpol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248Lsb as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248Lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).FT1248FlowControl as *const _ as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(FT1248FlowControl)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).RS485EchoSuppress as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(RS485EchoSuppress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_x_series>())).PowerSaveEnable as *const _ as usize
        },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(PowerSaveEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_x_series>())).DriverType as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_x_series),
            "::",
            stringify!(DriverType)
        )
    );
}
#[doc = "  @noop FT_EEPROM_X_SERIES"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT-X series data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_X_SERIES = ft_eeprom_x_series;
#[doc = "  @noop FT_EEPROM_4222H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT4222H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_4222h {
    #[doc = " Common header"]
    pub common: FT_EEPROM_HEADER,
    #[doc = " common elements for all device EEPROMs"]
    pub Revision: CHAR,
    #[doc = " 'A', 'B', 'C', or 'D'."]
    pub I2C_Slave_Address: UCHAR,
    #[doc = " Suspend"]
    pub SPISuspend: UCHAR,
    #[doc = " 0 for \"Disable SPI, tristate pins\", 2 for \"Keep SPI pin status\", 3 for \"Enable SPI pin control\""]
    pub SuspendOutPol: UCHAR,
    #[doc = " 0 for negative, 1 for positive (not implemented on Rev A)"]
    pub EnableSuspendOut: UCHAR,
    #[doc = " non-zero to enable (not implemented on Rev A)"]
    #[doc = " QSPI"]
    pub Clock_SlowSlew: UCHAR,
    #[doc = " non-zero if clock pin has slow slew"]
    pub Clock_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub IO0_SlowSlew: UCHAR,
    #[doc = " non-zero if IO0 pin has slow slew"]
    pub IO1_SlowSlew: UCHAR,
    #[doc = " non-zero if IO1 pin has slow slew"]
    pub IO2_SlowSlew: UCHAR,
    #[doc = " non-zero if IO2 pin has slow slew"]
    pub IO3_SlowSlew: UCHAR,
    #[doc = " non-zero if IO3 pin has slow slew"]
    pub IO_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub SlaveSelect_PullUp: UCHAR,
    #[doc = " non-zero to enable pull up"]
    pub SlaveSelect_PullDown: UCHAR,
    #[doc = " non-zero to enable pull down"]
    pub SlaveSelect_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub SlaveSelect_SlowSlew: UCHAR,
    #[doc = " non-zero if slave select pin has slow slew"]
    pub MISO_Suspend: UCHAR,
    #[doc = " 2 for push-low, 3 for push high, 0 and 1 reserved"]
    pub SIMO_Suspend: UCHAR,
    #[doc = " 2 for push-low, 3 for push high, 0 and 1 reserved"]
    pub IO2_IO3_Suspend: UCHAR,
    #[doc = " 2 for push-low, 3 for push high, 0 and 1 reserved"]
    pub SlaveSelect_Suspend: UCHAR,
    #[doc = " 0 for no-change (not implemented on Rev A), 2 for push-low, 3 for push high, 1 reserved"]
    #[doc = " GPIO"]
    pub GPIO0_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub GPIO1_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub GPIO2_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub GPIO3_Drive: UCHAR,
    #[doc = " valid values are 4mA, 8mA, 12mA, 16mA"]
    pub GPIO0_SlowSlew: UCHAR,
    #[doc = " non-zero if IO0 pin has slow slew"]
    pub GPIO1_SlowSlew: UCHAR,
    #[doc = " non-zero if IO0 pin has slow slew"]
    pub GPIO2_SlowSlew: UCHAR,
    #[doc = " non-zero if IO0 pin has slow slew"]
    pub GPIO3_SlowSlew: UCHAR,
    #[doc = " non-zero if IO0 pin has slow slew"]
    pub GPIO0_PullDown: UCHAR,
    #[doc = " non-zero to enable pull down"]
    pub GPIO1_PullDown: UCHAR,
    #[doc = " non-zero to enable pull down"]
    pub GPIO2_PullDown: UCHAR,
    #[doc = " non-zero to enable pull down"]
    pub GPIO3_PullDown: UCHAR,
    #[doc = " non-zero to enable pull down"]
    pub GPIO0_PullUp: UCHAR,
    #[doc = " non-zero to enable pull up"]
    pub GPIO1_PullUp: UCHAR,
    #[doc = " non-zero to enable pull up"]
    pub GPIO2_PullUp: UCHAR,
    #[doc = " non-zero to enable pull up"]
    pub GPIO3_PullUp: UCHAR,
    #[doc = " non-zero to enable pull up"]
    pub GPIO0_OpenDrain: UCHAR,
    #[doc = " non-zero to enable open drain"]
    pub GPIO1_OpenDrain: UCHAR,
    #[doc = " non-zero to enable open drain"]
    pub GPIO2_OpenDrain: UCHAR,
    #[doc = " non-zero to enable open drain"]
    pub GPIO3_OpenDrain: UCHAR,
    #[doc = " non-zero to enable open drain"]
    pub GPIO0_Suspend: UCHAR,
    #[doc = " 0 for no-change, 1 for input (not implemented on Rev A), 2 for push-low, 3 for push high"]
    pub GPIO1_Suspend: UCHAR,
    #[doc = " 0 for no-change, 1 for input (not implemented on Rev A), 2 for push-low, 3 for push high"]
    pub GPIO2_Suspend: UCHAR,
    #[doc = " 0 for no-change, 1 for input (not implemented on Rev A), 2 for push-low, 3 for push high"]
    pub GPIO3_Suspend: UCHAR,
    #[doc = " 0 for no-change, 1 for input (not implemented on Rev A), 2 for push-low, 3 for push high"]
    pub FallingEdge: UCHAR,
    #[doc = " non-zero to change GPIO on falling edge"]
    #[doc = " BCD"]
    pub BCD_Disable: UCHAR,
    #[doc = " non-zero to disable BCD"]
    pub BCD_OutputActiveLow: UCHAR,
    #[doc = " non-zero to set BCD output active low"]
    pub BCD_Drive: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_4222h() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_4222h>(),
        64usize,
        concat!("Size of: ", stringify!(ft_eeprom_4222h))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_4222h>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_4222h))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).common as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(common)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Revision as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Revision)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).I2C_Slave_Address as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(I2C_Slave_Address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SPISuspend as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SPISuspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SuspendOutPol as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SuspendOutPol)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).EnableSuspendOut as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(EnableSuspendOut)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Clock_SlowSlew as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Clock_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).Clock_Drive as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(Clock_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO0_SlowSlew as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO0_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO1_SlowSlew as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO1_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO2_SlowSlew as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO2_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO3_SlowSlew as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO3_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO_Drive as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO_Drive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_PullUp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_PullUp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_PullDown as *const _ as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_PullDown)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_Drive as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_Drive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_SlowSlew as *const _ as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).MISO_Suspend as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(MISO_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).SIMO_Suspend as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SIMO_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).IO2_IO3_Suspend as *const _ as usize },
        34usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(IO2_IO3_Suspend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).SlaveSelect_Suspend as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(SlaveSelect_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_Drive as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_Drive as *const _ as usize },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_Drive as *const _ as usize },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_Drive as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_Drive)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_SlowSlew as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_SlowSlew as *const _ as usize },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_SlowSlew as *const _ as usize },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_SlowSlew as *const _ as usize },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_SlowSlew)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_PullDown as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_PullDown as *const _ as usize },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_PullDown as *const _ as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_PullDown as *const _ as usize },
        47usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_PullDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_PullUp as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_PullUp as *const _ as usize },
        49usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_PullUp as *const _ as usize },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_PullUp as *const _ as usize },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_PullUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_OpenDrain as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_OpenDrain as *const _ as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_OpenDrain as *const _ as usize },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_OpenDrain as *const _ as usize },
        55usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_OpenDrain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO0_Suspend as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO0_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO1_Suspend as *const _ as usize },
        57usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO1_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO2_Suspend as *const _ as usize },
        58usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO2_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).GPIO3_Suspend as *const _ as usize },
        59usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(GPIO3_Suspend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).FallingEdge as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(FallingEdge)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_Disable as *const _ as usize },
        61usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_Disable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_OutputActiveLow as *const _ as usize
        },
        62usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_OutputActiveLow)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_4222h>())).BCD_Drive as *const _ as usize },
        63usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_4222h),
            "::",
            stringify!(BCD_Drive)
        )
    );
}
#[doc = "  @noop FT_EEPROM_4222H"]
#[doc = " @par Summary"]
#[doc = " Structure to hold data for the FT4222H data in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER structure."]
#[doc = " @see FT_EEPROM_HEADER"]
pub type FT_EEPROM_4222H = ft_eeprom_4222h;
#[doc = "  @noop FT_EEPROM_PD_PDO_mv_ma"]
#[doc = " @par Summary"]
#[doc = " Structure to hold PDO Configuration structure, mA supported values 0 to 10230mA, mV supported"]
#[doc = " values 0 to 51100mV. This is part of the FT_EEPROM_PD structure."]
#[doc = " @see FT_EEPROM_PD"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_PD_PDO_mv_ma {
    pub PDO1ma: USHORT,
    #[doc = " PDO1 mA"]
    pub PDO1mv: USHORT,
    #[doc = " PDO1 mV"]
    pub PDO2ma: USHORT,
    #[doc = " PDO2 mA"]
    pub PDO2mv: USHORT,
    #[doc = " PDO2 mV"]
    pub PDO3ma: USHORT,
    #[doc = " PDO3 mA"]
    pub PDO3mv: USHORT,
    #[doc = " PDO3 mV"]
    pub PDO4ma: USHORT,
    #[doc = " PDO4 mA"]
    pub PDO4mv: USHORT,
    #[doc = " PDO4 mV"]
    pub PDO5ma: USHORT,
    #[doc = " PDO5 mA (FTx233HP only)"]
    pub PDO5mv: USHORT,
    #[doc = " PDO5 mV (FTx233HP only)"]
    pub PDO6ma: USHORT,
    #[doc = " PDO6 mA (FTx233HP only)"]
    pub PDO6mv: USHORT,
    #[doc = " PDO6 mV (FTx233HP only)"]
    pub PDO7ma: USHORT,
    #[doc = " PDO7 mA (FTx233HP only)"]
    pub PDO7mv: USHORT,
}
#[test]
fn bindgen_test_layout_ft_eeprom_PD_PDO_mv_ma() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_PD_PDO_mv_ma>(),
        28usize,
        concat!("Size of: ", stringify!(ft_eeprom_PD_PDO_mv_ma))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_PD_PDO_mv_ma>(),
        2usize,
        concat!("Alignment of ", stringify!(ft_eeprom_PD_PDO_mv_ma))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO1ma as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO1ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO1mv as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO1mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO2ma as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO2ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO2mv as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO2mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO3ma as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO3ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO3mv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO3mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO4ma as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO4ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO4mv as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO4mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO5ma as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO5ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO5mv as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO5mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO6ma as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO6ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO6mv as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO6mv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO7ma as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO7ma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_PD_PDO_mv_ma>())).PDO7mv as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_PD_PDO_mv_ma),
            "::",
            stringify!(PDO7mv)
        )
    );
}
#[doc = "  @noop FT_EEPROM_PD_PDO_mv_ma"]
#[doc = " @par Summary"]
#[doc = " Structure to hold PDO Configuration structure, mA supported values 0 to 10230mA, mV supported"]
#[doc = " values 0 to 51100mV. This is part of the FT_EEPROM_PD structure."]
#[doc = " @see FT_EEPROM_PD"]
pub type FT_EEPROM_PD_PDO_mv_ma = ft_eeprom_PD_PDO_mv_ma;
#[doc = "  @noop FT_EEPROM_PD"]
#[doc = " @par Summary"]
#[doc = " Structure to hold power delivery configuration data for the FT4233PD, FT2233PD, FT4232PD,"]
#[doc = " FT2232PD, FT233PD and FT232PD in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER and a base device structure."]
#[doc = " e_g. @verbatim"]
#[doc = "\t\tstruct {"]
#[doc = "\t\t\tFT_EEPROM_xxx base;"]
#[doc = "\t\t\tFT_EEPROM_PD pd;"]
#[doc = "\t\t};"]
#[doc = " @endverbatim"]
#[doc = " @remarks"]
#[doc = " Device GPIO values are:"]
#[doc = " @li\tFTx233HP - 0 to 7, 15 for N/A"]
#[doc = " @li FTx232HP - 0 to 3, 15 for N/A"]
#[doc = " @see FT_EEPROM_HEADER"]
#[doc = " @see FT_EEPROM_PD_PDO_mv_ma"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ft_eeprom_pd {
    #[doc = " Configuration"]
    pub srprs: UCHAR,
    #[doc = " non-zero to enable Sink Request Power Role Swap"]
    pub sraprs: UCHAR,
    #[doc = " non-zero to enable Sink Accept PR Swap"]
    pub srrprs: UCHAR,
    #[doc = " non-zero to enable Source Request PR SWAP"]
    pub saprs: UCHAR,
    #[doc = " non-zero to enable Source Accept PR SWAP"]
    pub vconns: UCHAR,
    #[doc = " non-zero to enable vConn Swap"]
    pub passthru: UCHAR,
    #[doc = " non-zero to enable Pass Through (FTx233HP only)"]
    pub extmcu: UCHAR,
    #[doc = " non-zero to enable External MCU"]
    pub pd2en: UCHAR,
    #[doc = " non-zero to enable PD2 (FTx233HP only)"]
    pub pd1autoclk: UCHAR,
    #[doc = " non-zero to enable PD1 Auto Clock"]
    pub pd2autoclk: UCHAR,
    #[doc = " non-zero to enable PD2 Auto Clock (FTx233HP only)"]
    pub useefuse: UCHAR,
    #[doc = " non-zero to Use EFUSE"]
    pub extvconn: UCHAR,
    #[doc = " GPIO Configuration"]
    pub count: UCHAR,
    #[doc = " GPIO Count, supported values are 0 to 7"]
    pub gpio1: UCHAR,
    #[doc = " GPIO Number 1, supports device GPIO values"]
    pub gpio2: UCHAR,
    #[doc = " GPIO Number 2, supports device GPIO values"]
    pub gpio3: UCHAR,
    #[doc = " GPIO Number 3, supports device GPIO values"]
    pub gpio4: UCHAR,
    #[doc = " GPIO Number 4, supports device GPIO values"]
    pub gpio5: UCHAR,
    #[doc = " GPIO Number 5, supports device GPIO values (FTx233HP only)"]
    pub gpio6: UCHAR,
    #[doc = " GPIO Number 6, supports device GPIO values (FTx233HP only)"]
    pub gpio7: UCHAR,
    #[doc = " GPIO Number 7, supports device GPIO values (FTx233HP only)"]
    pub pd1lden: UCHAR,
    #[doc = " PD1 Load Enable, supports device GPIO values"]
    pub pd2lden: UCHAR,
    #[doc = " PD2 Load Enable, supports device GPIO values (FTx233HP only)"]
    pub dispin: UCHAR,
    #[doc = " Discharge Pin, supports device GPIO values"]
    pub disenbm: UCHAR,
    #[doc = " Discharge Enable BM, 0 for \"Drive Hi\", 1 for \"Drive Low\", 2 for \"Input Mode\", 3 for \"Don't Care\""]
    pub disdisbm: UCHAR,
    #[doc = " Discharge Disable BM, 0 for \"Drive Hi\", 1 for \"Drive Low\", 2 for \"Input Mode\", 3 for \"Don't Care\""]
    pub ccselect: UCHAR,
    #[doc = " ISET Configuration"]
    pub iset1: UCHAR,
    #[doc = " ISET1, supports device GPIO values"]
    pub iset2: UCHAR,
    #[doc = " ISET2, supports device GPIO values"]
    pub iset3: UCHAR,
    #[doc = " ISET3, supports device GPIO values"]
    pub extiset: UCHAR,
    #[doc = " non-zero to enable EXTEND_ISET"]
    pub isetpd2: UCHAR,
    #[doc = " non-zero to enable ISET_PD2"]
    pub iseten: UCHAR,
    #[doc = " BM Configuration, 0 for \"Drive Hi\", 1 for \"Drive Low\", 2 for \"Input Mode\", 3 for \"Don't Care\""]
    pub PDO1_GPIO: [UCHAR; 7usize],
    #[doc = " PDO1 GPIO1 to GPIO7"]
    pub PDO2_GPIO: [UCHAR; 7usize],
    #[doc = " PDO2 GPIO1 to GPIO7"]
    pub PDO3_GPIO: [UCHAR; 7usize],
    #[doc = " PDO3 GPIO1 to GPIO7"]
    pub PDO4_GPIO: [UCHAR; 7usize],
    #[doc = " PDO4 GPIO1 to GPIO7"]
    pub PDO5_GPIO: [UCHAR; 7usize],
    #[doc = " PDO5 GPIO1 to GPIO7 (FTx233HP only)"]
    pub PDO6_GPIO: [UCHAR; 7usize],
    #[doc = " PDO6 GPIO1 to GPIO7 (FTx233HP only)"]
    pub PDO7_GPIO: [UCHAR; 7usize],
    #[doc = " PDO7 GPIO1 to GPIO7 (FTx233HP only)"]
    pub VSET0V_GPIO: [UCHAR; 7usize],
    #[doc = " PDO7 GPIO1 to GPIO7"]
    pub VSAFE5V_GPIO: [UCHAR; 7usize],
    #[doc = " PDO7 GPIO1 to GPIO7"]
    pub BM_PDO_Sink: FT_EEPROM_PD_PDO_mv_ma,
    pub BM_PDO_Source: FT_EEPROM_PD_PDO_mv_ma,
    pub BM_PDO_Sink_2: FT_EEPROM_PD_PDO_mv_ma,
    #[doc = " PD Timers"]
    pub srt: UCHAR,
    #[doc = " Sender Response Timer"]
    pub hrt: UCHAR,
    #[doc = " Hard Reset Timer"]
    pub sct: UCHAR,
    #[doc = " Source Capability Timer"]
    pub dit: UCHAR,
    #[doc = " Discover Identity Timer"]
    pub srcrt: USHORT,
    #[doc = " Source Recover Timer"]
    pub trt: USHORT,
    #[doc = " Transition Timer"]
    pub sofft: USHORT,
    #[doc = " Source off timer"]
    pub nrt: USHORT,
    #[doc = " No Response Timer"]
    pub swct: USHORT,
    #[doc = " Sink Wait Capability Timer"]
    pub snkrt: USHORT,
    #[doc = " Sink Request Timer"]
    pub dt: UCHAR,
    #[doc = " Discharge Timer"]
    pub cnst: UCHAR,
    #[doc = " Chunk not supported timer"]
    pub it: USHORT,
    #[doc = " PD Control"]
    pub i2caddr: UCHAR,
    #[doc = " I2C Address (hex)"]
    pub prou: UINT,
    #[doc = " Power Reserved for OWN use"]
    pub trim1: UINT,
    #[doc = " TRIM1"]
    pub trim2: UINT,
    #[doc = " TRIM2"]
    pub extdc: UCHAR,
}
#[test]
fn bindgen_test_layout_ft_eeprom_pd() {
    assert_eq!(
        ::std::mem::size_of::<ft_eeprom_pd>(),
        220usize,
        concat!("Size of: ", stringify!(ft_eeprom_pd))
    );
    assert_eq!(
        ::std::mem::align_of::<ft_eeprom_pd>(),
        4usize,
        concat!("Alignment of ", stringify!(ft_eeprom_pd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srprs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sraprs as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sraprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srrprs as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srrprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).saprs as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(saprs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).vconns as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(vconns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).passthru as *const _ as usize },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(passthru)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extmcu as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extmcu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2en as *const _ as usize },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2en)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd1autoclk as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd1autoclk)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2autoclk as *const _ as usize },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2autoclk)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).useefuse as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(useefuse)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extvconn as *const _ as usize },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extvconn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).count as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio1 as *const _ as usize },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio2 as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio3 as *const _ as usize },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio4 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio5 as *const _ as usize },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio6 as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).gpio7 as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(gpio7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd1lden as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd1lden)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).pd2lden as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(pd2lden)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dispin as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dispin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).disenbm as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(disenbm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).disdisbm as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(disdisbm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).ccselect as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(ccselect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset1 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset2 as *const _ as usize },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iset3 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iset3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extiset as *const _ as usize },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extiset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).isetpd2 as *const _ as usize },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(isetpd2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).iseten as *const _ as usize },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(iseten)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO1_GPIO as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO1_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO2_GPIO as *const _ as usize },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO2_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO3_GPIO as *const _ as usize },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO3_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO4_GPIO as *const _ as usize },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO4_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO5_GPIO as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO5_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO6_GPIO as *const _ as usize },
        67usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO6_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).PDO7_GPIO as *const _ as usize },
        74usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(PDO7_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).VSET0V_GPIO as *const _ as usize },
        81usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(VSET0V_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).VSAFE5V_GPIO as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(VSAFE5V_GPIO)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Sink as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Sink)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Source as *const _ as usize },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Source)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).BM_PDO_Sink_2 as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(BM_PDO_Sink_2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srt as *const _ as usize },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).hrt as *const _ as usize },
        181usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(hrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sct as *const _ as usize },
        182usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dit as *const _ as usize },
        183usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).srcrt as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(srcrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trt as *const _ as usize },
        186usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).sofft as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(sofft)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).nrt as *const _ as usize },
        190usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(nrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).swct as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(swct)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).snkrt as *const _ as usize },
        194usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(snkrt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).dt as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(dt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).cnst as *const _ as usize },
        197usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(cnst)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).it as *const _ as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(it)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).i2caddr as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(i2caddr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).prou as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(prou)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trim1 as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trim1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).trim2 as *const _ as usize },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(trim2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ft_eeprom_pd>())).extdc as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(ft_eeprom_pd),
            "::",
            stringify!(extdc)
        )
    );
}
#[doc = "  @noop FT_EEPROM_PD"]
#[doc = " @par Summary"]
#[doc = " Structure to hold power delivery configuration data for the FT4233PD, FT2233PD, FT4232PD,"]
#[doc = " FT2232PD, FT233PD and FT232PD in the FT_EEPROM_Program and FT_EEPROM_Read functions."]
#[doc = " This is appended to an FT_EEPROM_HEADER and a base device structure."]
#[doc = " e_g. @verbatim"]
#[doc = "\t\tstruct {"]
#[doc = "\t\t\tFT_EEPROM_xxx base;"]
#[doc = "\t\t\tFT_EEPROM_PD pd;"]
#[doc = "\t\t};"]
#[doc = " @endverbatim"]
#[doc = " @remarks"]
#[doc = " Device GPIO values are:"]
#[doc = " @li\tFTx233HP - 0 to 7, 15 for N/A"]
#[doc = " @li FTx232HP - 0 to 3, 15 for N/A"]
#[doc = " @see FT_EEPROM_HEADER"]
#[doc = " @see FT_EEPROM_PD_PDO_mv_ma"]
pub type FT_EEPROM_PD = ft_eeprom_pd;
#[doc = " FT2233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT2232H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_2233hp {
    pub ft2232h: FT_EEPROM_2232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_2233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_2233hp>(),
        260usize,
        concat!("Size of: ", stringify!(_ft_eeprom_2233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_2233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_2233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2233hp>())).ft2232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2233hp),
            "::",
            stringify!(ft2232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2233hp>())).pd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2233hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT2233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT2232H with power delivery"]
pub type FT_EEPROM_2233HP = _ft_eeprom_2233hp;
#[doc = " FT4233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT4232H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_4233hp {
    pub ft4232h: FT_EEPROM_4232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_4233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_4233hp>(),
        256usize,
        concat!("Size of: ", stringify!(_ft_eeprom_4233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_4233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_4233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4233hp>())).ft4232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4233hp),
            "::",
            stringify!(ft4232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4233hp>())).pd as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4233hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT4233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT4232H with power delivery"]
pub type FT_EEPROM_4233HP = _ft_eeprom_4233hp;
#[doc = " FT2232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT2232H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_2232hp {
    pub ft2232h: FT_EEPROM_2232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_2232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_2232hp>(),
        260usize,
        concat!("Size of: ", stringify!(_ft_eeprom_2232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_2232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_2232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2232hp>())).ft2232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2232hp),
            "::",
            stringify!(ft2232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_2232hp>())).pd as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_2232hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT2232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT2232H with power delivery"]
pub type FT_EEPROM_2232HP = _ft_eeprom_2232hp;
#[doc = " FT4232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT4232H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_4232hp {
    pub ft4232h: FT_EEPROM_4232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_4232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_4232hp>(),
        256usize,
        concat!("Size of: ", stringify!(_ft_eeprom_4232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_4232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_4232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4232hp>())).ft4232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4232hp),
            "::",
            stringify!(ft4232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_4232hp>())).pd as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_4232hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT4232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT4232H with power delivery"]
pub type FT_EEPROM_4232HP = _ft_eeprom_4232hp;
#[doc = " FT233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT233H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_233hp {
    pub ft232h: FT_EEPROM_232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_233hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_233hp>(),
        264usize,
        concat!("Size of: ", stringify!(_ft_eeprom_233hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_233hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_233hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_233hp>())).ft232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_233hp),
            "::",
            stringify!(ft232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_233hp>())).pd as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_233hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT233HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT233H with power delivery"]
pub type FT_EEPROM_233HP = _ft_eeprom_233hp;
#[doc = " FT232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT232H with power delivery"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _ft_eeprom_232hp {
    pub ft232h: FT_EEPROM_232H,
    pub pd: FT_EEPROM_PD,
}
#[test]
fn bindgen_test_layout__ft_eeprom_232hp() {
    assert_eq!(
        ::std::mem::size_of::<_ft_eeprom_232hp>(),
        264usize,
        concat!("Size of: ", stringify!(_ft_eeprom_232hp))
    );
    assert_eq!(
        ::std::mem::align_of::<_ft_eeprom_232hp>(),
        4usize,
        concat!("Alignment of ", stringify!(_ft_eeprom_232hp))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_232hp>())).ft232h as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_232hp),
            "::",
            stringify!(ft232h)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ft_eeprom_232hp>())).pd as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_ft_eeprom_232hp),
            "::",
            stringify!(pd)
        )
    );
}
#[doc = " FT232HP EEPROM structure for use with FT_EEPROM_Read and FT_EEPROM_Program"]
#[doc = " FT232H with power delivery"]
pub type FT_EEPROM_232HP = _ft_eeprom_232hp;
extern "C" {
    #[doc = " @noop FT_EEPROM_Read"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (XP and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read data from the EEPROM, this command will work for all existing FTDI chipset, and must be"]
    #[doc = " used for the FT-X series."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param *eepromData Pointer to a buffer that contains the data to be read."]
    #[doc = " Note: This structure is different for each device type."]
    #[doc = " @param eepromDataSize Size of the eepromData buffer that contains storage for the data to be read."]
    #[doc = " @param *Manufacturer Pointer to a null-terminated string containing the manufacturer\tname."]
    #[doc = " @param *ManufacturerId Pointer to a null-terminated string containing the manufacturer ID."]
    #[doc = " @param *Description Pointer to a null-terminated string containing the device description."]
    #[doc = " @param *SerialNumber Pointer to a null-terminated string containing the device serial number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter *eepromDATA as a pointer to a structure matching the device"]
    #[doc = " type being accessed e.g."]
    #[doc = " @li PFT_EEPROM_232B is the structure for FT2xxB devices."]
    #[doc = " @li PFT_EEPROM_2232 is the structure for FT2232D devices."]
    #[doc = " @li PFT_EEPROM_232R is the structure for FT232R devices."]
    #[doc = " @li PFT_EEPROM_2232H is the structure for FT2232H devices."]
    #[doc = " @li PFT_EEPROM_4232H is the structure for FT4232H devices."]
    #[doc = " @li PFT_EEPROM_232H is the structure for FT232H devices."]
    #[doc = " @li PFT_EEPROM_X_SERIES is the structure for FT2xxX devices."]
    #[doc = ""]
    #[doc = " The function does not perform any checks on buffer sizes, so the buffers passed in the eepromDATA"]
    #[doc = " structure must be big enough to accommodate their respective strings (including null terminators)."]
    #[doc = " The sizes shown in the following example are more than adequate and can be rounded down if necessary."]
    #[doc = " The restriction is that the Manufacturer string length plus the Description string length is less than or"]
    #[doc = " equal to 40 characters."]
    #[doc = " @note Note that the DLL must be informed which version of the eepromDATA structure is being used. This is"]
    #[doc = " done through the PFT_EEPROM_HEADER structure. The first element of this structure is deviceType and"]
    #[doc = " may be FT_DEVICE_BM, FT_DEVICE_AM, FT_DEVICE_2232C, FT_DEVICE_232R, FT_DEVICE_2232H,"]
    #[doc = " FT_DEVICE_4232H, FT_DEVICE_232H, or FT_DEVICE_X_SERIES as defined in FTD2XX.h."]
    pub fn FT_EEPROM_Read(
        ftHandle: FT_HANDLE,
        eepromData: *mut ::std::os::raw::c_void,
        eepromDataSize: DWORD,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EEPROM_Program"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (XP and later)"]
    #[doc = " @par Summary"]
    #[doc = " Write data into the EEPROM, this command will work for all existing FTDI chipset, and must be used for"]
    #[doc = " the FT-X series."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param *eepromData Pointer to a buffer that contains the data to be written."]
    #[doc = " Note: This structure is different for each device type."]
    #[doc = " @param eepromDataSize Size of the eepromData buffer that contains storage for the data to be written."]
    #[doc = " @param *Manufacturer Pointer to a null-terminated string containing the manufacturer name."]
    #[doc = " @param *ManufacturerId Pointer to a null-terminated string containing the manufacturer ID."]
    #[doc = " @param *Description Pointer to a null-terminated string containing the device description."]
    #[doc = " @param *SerialNumber Pointer to a null-terminated string containing the device serial number."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function interprets the parameter *eepromDATA as a pointer to a structure matching the device"]
    #[doc = " type being accessed e.g."]
    #[doc = " @li PFT_EEPROM_232B is the structure for FT2xxB devices."]
    #[doc = " @li PFT_EEPROM_2232 is the structure for FT2232D devices."]
    #[doc = " @li PFT_EEPROM_232R is the structure for FT232R devices."]
    #[doc = " @li PFT_EEPROM_2232H is the structure for FT2232H devices."]
    #[doc = " @li PFT_EEPROM_4232H is the structure for FT4232H devices."]
    #[doc = " @li PFT_EEPROM_232H is the structure for FT232H devices."]
    #[doc = " @li PFT_EEPROM_X_SERIES is the structure for FT2xxX devices."]
    #[doc = ""]
    #[doc = " The function does not perform any checks on buffer sizes, so the buffers passed in the eepromDATA"]
    #[doc = " structure must be big enough to accommodate their respective strings (including null terminators)."]
    #[doc = " @n The sizes shown in the following example are more than adequate and can be rounded down if necessary."]
    #[doc = " The restriction is that the Manufacturer string length plus the Description string length is less than or"]
    #[doc = " equal to 40 characters."]
    #[doc = " @note Note that the DLL must be informed which version of the eepromDATA structure is being used. This is"]
    #[doc = " done through the PFT_EEPROM_HEADER structure. The first element of this structure is deviceType and"]
    #[doc = " may be FT_DEVICE_BM, FT_DEVICE_AM, FT_DEVICE_2232C, FT_DEVICE_232R, FT_DEVICE_2232H,"]
    #[doc = " FT_DEVICE_4232H, FT_DEVICE_232H, or FT_DEVICE_X_SERIES as defined in FTD2XX.h."]
    pub fn FT_EEPROM_Program(
        ftHandle: FT_HANDLE,
        eepromData: *mut ::std::os::raw::c_void,
        eepromDataSize: DWORD,
        Manufacturer: *mut ::std::os::raw::c_char,
        ManufacturerId: *mut ::std::os::raw::c_char,
        Description: *mut ::std::os::raw::c_char,
        SerialNumber: *mut ::std::os::raw::c_char,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetLatencyTimer"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Set the latency timer value."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ucLatency Required value, in milliseconds, of latency timer. Valid range is 2 - 255."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " In the FT8U232AM and FT8U245AM devices, the receive buffer timeout that is used to flush remaining"]
    #[doc = " data from the receive buffer was fixed at 16 ms. In all other FTDI devices, this timeout is"]
    #[doc = " programmable and can be set at 1 ms intervals between 2ms and 255 ms. This allows the device to"]
    #[doc = " be better optimize for protocols requiring faster response times from short data packets."]
    pub fn FT_SetLatencyTimer(ftHandle: FT_HANDLE, ucLatency: UCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetLatencyTimer"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Get the current value of the latency timer."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pucLatency Pointer to unsigned char to store latency timer value."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " In the FT8U232AM and FT8U245AM devices, the receive buffer timeout that is used to flush remaining"]
    #[doc = " data from the receive buffer was fixed at 16 ms. In all other FTDI devices, this timeout is"]
    #[doc = " programmable and can be set at 1 ms intervals between 2ms and 255 ms. This allows the device to"]
    #[doc = " be better optimized for protocols requiring faster response times from short data packets."]
    pub fn FT_GetLatencyTimer(ftHandle: FT_HANDLE, pucLatency: PUCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetBitMode"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Enables different chip modes."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ucMask Required value for bit mode mask. This sets up which bits are inputs and outputs."]
    #[doc = " A bit value of 0 sets the corresponding pin to an input, a bit value of 1 sets the corresponding"]
    #[doc = " pin to an output."]
    #[doc = " @n In the case of CBUS Bit Bang, the upper nibble of this value controls which pins are inputs"]
    #[doc = " and outputs,\twhile the lower nibble controls which of the outputs are high and low."]
    #[doc = " @param ucEnable Mode value. Can be one of the following:"]
    #[doc = " @li 0x0 = Reset"]
    #[doc = " @li 0x1 = Asynchronous Bit Bang"]
    #[doc = " @li 0x2 = MPSSE (FT2232, FT2232H, FT4232H and FT232H devices only)"]
    #[doc = " @li 0x4 = Synchronous Bit Bang (FT232R, FT245R, FT2232, FT2232H, FT4232H and FT232H devices only)"]
    #[doc = " @li 0x8 = MCU Host Bus Emulation Mode (FT2232, FT2232H, FT4232H and FT232H devices only)"]
    #[doc = " @li 0x10 = Fast Opto-Isolated Serial Mode (FT2232, FT2232H, FT4232H and FT232H devices only)"]
    #[doc = " @li 0x20 = CBUS Bit Bang Mode (FT232R and FT232H devices only)"]
    #[doc = " @li 0x40 = Single Channel Synchronous 245 FIFO Mode (FT2232H and FT232H devices only)"]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " For a description of available bit modes for the FT232R, see the application note \"Bit Bang Modes"]
    #[doc = " for the FT232R and FT245R\"."]
    #[doc = " @n For a description of available bit modes for the FT2232, see the application note \"Bit Mode"]
    #[doc = " Functions for the FT2232\"."]
    #[doc = " @n For a description of Bit Bang Mode for the FT232B and FT245B, see the application note"]
    #[doc = " \"FT232B/FT245B Bit Bang Mode\"."]
    #[doc = " @n Application notes are available for download from the FTDI website."]
    #[doc = " Note that to use CBUS Bit Bang for the FT232R, the CBUS must be configured for CBUS Bit Bang in the"]
    #[doc = " EEPROM."]
    #[doc = " @note Note that to use Single Channel Synchronous 245 FIFO mode for the FT2232H, channel A must be"]
    #[doc = " configured for FT245 FIFO mode in the EEPROM."]
    pub fn FT_SetBitMode(ftHandle: FT_HANDLE, ucMask: UCHAR, ucEnable: UCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetBitMode"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the instantaneous value of the data bus."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pucMode Pointer to unsigned char to store the instantaneous data bus value."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " For a description of available bit modes for the FT232R, see the application note \"Bit Bang Modes"]
    #[doc = " for the FT232R and FT245R\"."]
    #[doc = " @n For a description of available bit modes for the FT2232, see the application note \"Bit Mode"]
    #[doc = " Functions for the FT2232\"."]
    #[doc = " @n For a description of bit bang modes for the FT232B and FT245B, see the application note"]
    #[doc = " \"FT232B/FT245B Bit Bang Mode\"."]
    #[doc = " @n For a description of bit modes supported by the FT4232H and FT2232H devices, please see the"]
    #[doc = " IC data sheets."]
    #[doc = " @n These application notes are available for download from the FTDI website."]
    pub fn FT_GetBitMode(ftHandle: FT_HANDLE, pucMode: PUCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_SetUSBParameters"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Set the USB request transfer size."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ulInTransferSize Transfer size for USB IN request."]
    #[doc = " @param ulOutTransferSize Transfer size for USB OUT request."]
    #[doc = " @returns"]
    #[doc = " FT_OK if successful, otherwise the return value is an FT error code."]
    #[doc = " @remarks"]
    #[doc = " This function can be used to change the transfer sizes from the default transfer size of 4096"]
    #[doc = " bytes to\tbetter suit the application requirements. Transfer sizes must be set to a multiple"]
    #[doc = " of 64 bytes between 64 bytes and 64k bytes."]
    #[doc = " @n When FT_SetUSBParameters is called, the change comes into effect immediately and any data"]
    #[doc = " that was\theld in the driver at the time of the change is lost."]
    #[doc = " @note Note that, at present, only ulInTransferSize is supported."]
    pub fn FT_SetUSBParameters(
        ftHandle: FT_HANDLE,
        ulInTransferSize: ULONG,
        ulOutTransferSize: ULONG,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_W32_CreateFile"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Opens the specified device and return a handle which will be used for subsequent accesses."]
    #[doc = " The device can be specified by its serial number, device description, or location."]
    #[doc = " @n This function must be used if overlapped I/O is required."]
    #[doc = " @param lpszName Meaning depends on the value of dwAttrsAndFlags. Can be a pointer to a null"]
    #[doc = " terminated string that contains the description or serial number of the device, or can be"]
    #[doc = " the location of the device. These values can be obtained from the FT_CreateDeviceInfoList,"]
    #[doc = " FT_GetDeviceInfoDetail or FT_ListDevices\tfunctions."]
    #[doc = " @param dwAccess Type of access to the device. Access can be GENERIC_READ,"]
    #[doc = " GENERIC_WRITE or both. Ignored in Linux."]
    #[doc = " @param dwShareMode How the device is shared. This value must be set to 0."]
    #[doc = " @param lpSecurityAttributes This parameter has no effect and should be set to NULL."]
    #[doc = " @param dwCreate This parameter must be set to OPEN_EXISTING. Ignored in Linux."]
    #[doc = " @param dwAttrsAndFlags File attributes and flags. This parameter is a combination of"]
    #[doc = " FILE_ATTRIBUTE_NORMAL, FILE_FLAG_OVERLAPPED if overlapped I/O is used,"]
    #[doc = " FT_OPEN_BY_SERIAL_NUMBER if lpszName is the device’s serial number, and"]
    #[doc = " FT_OPEN_BY_DESCRIPTION if lpszName is the device’s description."]
    #[doc = " @param hTemplate This parameter must be NULL."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is a handle."]
    #[doc = " If the function is unsuccessful, the return value is the Win32 error code INVALID_HANDLE_VALUE."]
    #[doc = " @remarks"]
    #[doc = " The meaning of lpszName depends on dwAttrsAndFlags: if FT_OPEN_BY_SERIAL_NUMBER or"]
    #[doc = " FT_OPEN_BY_DESCRIPTION is set in dwAttrsAndFlags, lpszName contains a pointer to a null terminated"]
    #[doc = " string that contains the device's serial number or description; if FT_OPEN_BY_LOCATION is set in"]
    #[doc = " dwAttrsAndFlags, lpszName is interpreted as a value of type long that contains the location ID of"]
    #[doc = " the device. dwAccess can be GENERIC_READ, GENERIC_WRITE or both; dwShareMode must be set to 0;"]
    #[doc = " lpSecurityAttributes must be set to NULL; dwCreate must be set to OPEN_EXISTING; dwAttrsAndFlags"]
    #[doc = " is a combination of FILE_ATTRIBUTE_NORMAL, FILE_FLAG_OVERLAPPED if overlapped I/O is used,"]
    #[doc = " FT_OPEN_BY_SERIAL_NUMBER or FT_OPEN_BY_DESCRIPTION or FT_OPEN_BY_LOCATION; hTemplate"]
    #[doc = " must be NULL."]
    #[doc = " @note Note that Linux, Mac OS X and Windows CE do not support overlapped IO. Windows CE"]
    #[doc = " does not support location IDs."]
    pub fn FT_W32_CreateFile(
        lpszName: LPCTSTR,
        dwAccess: DWORD,
        dwShareMode: DWORD,
        lpSecurityAttributes: LPSECURITY_ATTRIBUTES,
        dwCreate: DWORD,
        dwAttrsAndFlags: DWORD,
        hTemplate: HANDLE,
    ) -> FT_HANDLE;
}
extern "C" {
    #[doc = " @noop FT_W32_CloseHandle"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Close the specified device handle."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_CloseHandle(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_ReadFile"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Read data from the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpBuffer Pointer to a buffer that receives the data from the device."]
    #[doc = " @param nBufferSize Number of bytes to read from the device."]
    #[doc = " @param lpdwBytesReturned Pointer to a variable that receives the number of bytes read from"]
    #[doc = " the device."]
    #[doc = " @param lpOverlapped Pointer to an overlapped structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function supports both non-overlapped and overlapped I/O, except under Linux, Mac OS X"]
    #[doc = " and Windows CE where only non-overlapped IO is supported."]
    #[doc = " @n @b Non-overlapped @b I/O"]
    #[doc = " @n The parameter, lpOverlapped, must be NULL for non-overlapped I/O."]
    #[doc = " @n This function always returns the number of bytes read in lpdwBytesReturned."]
    #[doc = " This function does not return until dwBytesToRead have been read into the buffer. The number of"]
    #[doc = " bytes in the receive queue can be determined by calling FT_GetStatus or FT_GetQueueStatus, and"]
    #[doc = " passed as dwBytesToRead so that the function reads the device and returns immediately."]
    #[doc = " @n When a read timeout has been setup in a previous call to FT_W32_SetCommTimeouts, this function"]
    #[doc = " returns when the timer expires or dwBytesToRead have been read, whichever occurs first. If a"]
    #[doc = " timeout occurred, any available data is read into lpBuffer and the function returns a non-zero value."]
    #[doc = " @n An application should use the function return value and lpdwBytesReturned when processing the"]
    #[doc = " buffer. If the return value is non-zero and lpdwBytesReturned is equal to dwBytesToRead then the"]
    #[doc = " function has\tcompleted normally. If the return value is non-zero and lpdwBytesReturned is less"]
    #[doc = " then dwBytesToRead then a timeout has occurred, and the read request has been partially completed."]
    #[doc = " @note Note that if a timeout\toccurred and no data was read, the return value is still non-zero."]
    #[doc = " @n @b Overlapped @b I/O"]
    #[doc = " @n When the device has been opened for overlapped I/O, an application can issue a request and"]
    #[doc = " perform some additional work while the request is pending. This contrasts with the case"]
    #[doc = " of non-overlapped I/O in\twhich the application issues a request and receives control again only"]
    #[doc = " after the request has been completed."]
    #[doc = " @n The parameter, lpOverlapped, must point to an initialized OVERLAPPED structure. If there is"]
    #[doc = " enough data in the receive queue to satisfy the request, the request completes immediately and"]
    #[doc = " the return code is non-zero. The number of bytes read is returned in lpdwBytesReturned."]
    #[doc = " @n If there is not enough data in the receive queue to satisfy the request, the request completes"]
    #[doc = " immediately, and the return code is zero, signifying an error. An application should call"]
    #[doc = " FT_W32_GetLastError to get the cause of the error. If the error code is ERROR_IO_PENDING, the"]
    #[doc = " overlapped operation is still in progress, and the application can perform other processing."]
    #[doc = " Eventually, the application checks the result of the overlapped request by calling"]
    #[doc = " FT_W32_GetOverlappedResult."]
    #[doc = " @n If successful, the number of bytes read is returned in lpdwBytesReturned."]
    pub fn FT_W32_ReadFile(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        nBufferSize: DWORD,
        lpdwBytesReturned: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_WriteFile"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Write data to the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpBuffer Pointer to the buffer that contains the data to write to the device."]
    #[doc = " @param nBufferSize Number of bytes to be written to the device."]
    #[doc = " @param lpdwBytesWritten Pointer to a variable that receives the number of bytes written to the device."]
    #[doc = " @param lpOverlapped Pointer to an overlapped structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function supports both non-overlapped and overlapped I/O, except under Linux, Mac OS X and"]
    #[doc = " Windows CE where only non-overlapped IO is supported."]
    #[doc = " @n @b Non-overlapped @b I/O"]
    #[doc = " @n The parameter, lpOverlapped, must be NULL for non-overlapped I/O."]
    #[doc = " @n This function always returns the number of bytes written in lpdwBytesWritten."]
    #[doc = " This function does not return until dwBytesToWrite have been written to the device."]
    #[doc = " When a write timeout has been setup in a previous call to FT_W32_SetCommTimeouts, this function"]
    #[doc = " returns when the timer expires or dwBytesToWrite have been written, whichever occurs first. If a"]
    #[doc = " timeout occurred, lpdwBytesWritten contains the number of bytes actually written, and the function"]
    #[doc = " returns a non-zero value."]
    #[doc = " @n An application should always use the function return value and lpdwBytesWritten. If the return"]
    #[doc = " value is\tnon-zero and lpdwBytesWritten is equal to dwBytesToWrite then the function has completed"]
    #[doc = " normally. If\tthe return value is non-zero and lpdwBytesWritten is less then dwBytesToWrite then a"]
    #[doc = " timeout has occurred, and the write request has been partially completed."]
    #[doc = " @note Note that if a timeout occurred and no data was written, the return value is still non-zero."]
    #[doc = " @n @b Overlapped @b I/O"]
    #[doc = " @n When the device has been opened for overlapped I/O, an application can issue a request and perform"]
    #[doc = " some additional work while the request is pending. This contrasts with the case of non-overlapped"]
    #[doc = " I/O in which the application issues a request and receives control again only after the request has"]
    #[doc = " been\tcompleted."]
    #[doc = " @n The parameter, lpOverlapped, must point to an initialized OVERLAPPED structure."]
    #[doc = " This function completes immediately, and the return code is zero, signifying an error. An application"]
    #[doc = " should call FT_W32_GetLastError to get the cause of the error. If the error code is ERROR_IO_PENDING,"]
    #[doc = " the overlapped operation is still in progress, and the application can perform other processing."]
    #[doc = " Eventually, the application checks the result of the overlapped request by calling"]
    #[doc = " FT_W32_GetOverlappedResult."]
    #[doc = " @n If successful, the number of bytes written is returned in lpdwBytesWritten."]
    pub fn FT_W32_WriteFile(
        ftHandle: FT_HANDLE,
        lpBuffer: LPVOID,
        nBufferSize: DWORD,
        lpdwBytesWritten: LPDWORD,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_GetOverlappedResult"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the result of an overlapped operation."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpOverlapped Pointer to an overlapped structure."]
    #[doc = " @param lpdwBytesTransferred Pointer to a variable that receives the number of bytes transferred"]
    #[doc = " during the overlapped operation."]
    #[doc = " @param bWait Set to TRUE if the function does not return until the operation has been completed."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function is used with overlapped I/O and so is not supported in Linux, Mac OS X or Windows CE. For"]
    #[doc = " a description of its use, see FT_W32_ReadFile and FT_W32_WriteFile."]
    pub fn FT_W32_GetOverlappedResult(
        ftHandle: FT_HANDLE,
        lpOverlapped: LPOVERLAPPED,
        lpdwBytesTransferred: LPDWORD,
        bWait: BOOL,
    ) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_EscapeCommFunction"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Perform an extended function."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwFunc The extended function to perform can be one of the following values:"]
    #[doc = " @li CLRDTR - Clear the DTR signal"]
    #[doc = " @li CLRRTS - Clear the RTS signal"]
    #[doc = " @li SETDTR - Set the DTR signal"]
    #[doc = " @li SETRTS - Set the RTS signal"]
    #[doc = " @li SETBREAK - Set the BREAK condition"]
    #[doc = " @li CLRBREAK - Clear the BREAK condition"]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_EscapeCommFunction(ftHandle: FT_HANDLE, dwFunc: DWORD) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_GetCommModemStatus"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function gets the current modem control value."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwModemStatus Pointer to a variable to contain modem control value. The modem"]
    #[doc = " control value can be a combination of the following:"]
    #[doc = " @li MS_CTS_ON - Clear To Send (CTS) is on"]
    #[doc = " @li MS_DSR_ON - Data Set Ready (DSR) is on"]
    #[doc = " @li MS_RING_ON - Ring Indicator (RI) is on"]
    #[doc = " @li MS_RLSD_ON - Receive Line Signal Detect (RLSD) is on"]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_GetCommModemStatus(ftHandle: FT_HANDLE, lpdwModemStatus: LPDWORD) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_SetupComm"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the read and write buffers."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwReadBufferSize Length, in bytes, of the read buffer."]
    #[doc = " @param dwWriteBufferSize Length, in bytes, of the write buffer."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function has no effect. It is the responsibility of the driver to allocate sufficient"]
    #[doc = " storage for I/O requests."]
    pub fn FT_W32_SetupComm(
        ftHandle: FT_HANDLE,
        dwReadBufferSize: DWORD,
        dwWriteBufferSize: DWORD,
    ) -> BOOL;
}
#[doc = " Structure for FT_W32_ClearCommError lpftComstat parameter."]
#[doc = " @see FT_W32_ClearCommError"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _FTCOMSTAT {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub cbInQue: DWORD,
    pub cbOutQue: DWORD,
}
#[test]
fn bindgen_test_layout__FTCOMSTAT() {
    assert_eq!(
        ::std::mem::size_of::<_FTCOMSTAT>(),
        12usize,
        concat!("Size of: ", stringify!(_FTCOMSTAT))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTCOMSTAT>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTCOMSTAT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTCOMSTAT>())).cbInQue as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTCOMSTAT),
            "::",
            stringify!(cbInQue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTCOMSTAT>())).cbOutQue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTCOMSTAT),
            "::",
            stringify!(cbOutQue)
        )
    );
}
impl _FTCOMSTAT {
    #[inline]
    pub fn fCtsHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fCtsHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDsrHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fDsrHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fRlsdHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fRlsdHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fXoffHold(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fXoffHold(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fXoffSent(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fXoffSent(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fEof(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fEof(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fTxim(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fTxim(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fReserved(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 25u8) as u32) }
    }
    #[inline]
    pub fn set_fReserved(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 25u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fCtsHold: DWORD,
        fDsrHold: DWORD,
        fRlsdHold: DWORD,
        fXoffHold: DWORD,
        fXoffSent: DWORD,
        fEof: DWORD,
        fTxim: DWORD,
        fReserved: DWORD,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fCtsHold: u32 = unsafe { ::std::mem::transmute(fCtsHold) };
            fCtsHold as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fDsrHold: u32 = unsafe { ::std::mem::transmute(fDsrHold) };
            fDsrHold as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fRlsdHold: u32 = unsafe { ::std::mem::transmute(fRlsdHold) };
            fRlsdHold as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fXoffHold: u32 = unsafe { ::std::mem::transmute(fXoffHold) };
            fXoffHold as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let fXoffSent: u32 = unsafe { ::std::mem::transmute(fXoffSent) };
            fXoffSent as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let fEof: u32 = unsafe { ::std::mem::transmute(fEof) };
            fEof as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let fTxim: u32 = unsafe { ::std::mem::transmute(fTxim) };
            fTxim as u64
        });
        __bindgen_bitfield_unit.set(7usize, 25u8, {
            let fReserved: u32 = unsafe { ::std::mem::transmute(fReserved) };
            fReserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Structure for FT_W32_ClearCommError lpftComstat parameter."]
#[doc = " @see FT_W32_ClearCommError"]
pub type LPFTCOMSTAT = *mut _FTCOMSTAT;
#[doc = " Structure for FT_W32_SetCommState and FT_W32_GetCommState lpftDcb parameter."]
#[doc = " @see FT_W32_SetCommState"]
#[doc = " @see FT_W32_GetCommState"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _FTDCB {
    pub DCBlength: DWORD,
    #[doc = " sizeof(FTDCB)"]
    pub BaudRate: DWORD,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    #[doc = " Reserved"]
    pub wReserved: WORD,
    #[doc = " Not currently used"]
    pub XonLim: WORD,
    #[doc = " Transmit X-ON threshold"]
    pub XoffLim: WORD,
    #[doc = " Transmit X-OFF threshold"]
    pub ByteSize: BYTE,
    #[doc = " Number of bits/byte, 4-8"]
    pub Parity: BYTE,
    #[doc = " 0-4=None,Odd,Even,Mark,Space"]
    pub StopBits: BYTE,
    #[doc = " FT_STOP_BITS_1 or FT_STOP_BITS_2"]
    pub XonChar: ::std::os::raw::c_char,
    #[doc = " Tx and Rx X-ON character"]
    pub XoffChar: ::std::os::raw::c_char,
    #[doc = " Tx and Rx X-OFF character"]
    pub ErrorChar: ::std::os::raw::c_char,
    #[doc = " Error replacement char"]
    pub EofChar: ::std::os::raw::c_char,
    #[doc = " End of Input character"]
    pub EvtChar: ::std::os::raw::c_char,
    #[doc = " Received Event character"]
    pub wReserved1: WORD,
}
#[test]
fn bindgen_test_layout__FTDCB() {
    assert_eq!(
        ::std::mem::size_of::<_FTDCB>(),
        28usize,
        concat!("Size of: ", stringify!(_FTDCB))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTDCB>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTDCB))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).DCBlength as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(DCBlength)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).BaudRate as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(BaudRate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).wReserved as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(wReserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XonLim as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XonLim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XoffLim as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XoffLim)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).ByteSize as *const _ as usize },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(ByteSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).Parity as *const _ as usize },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(Parity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).StopBits as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(StopBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XonChar as *const _ as usize },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XonChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).XoffChar as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(XoffChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).ErrorChar as *const _ as usize },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(ErrorChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).EofChar as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(EofChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).EvtChar as *const _ as usize },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(EvtChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTDCB>())).wReserved1 as *const _ as usize },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTDCB),
            "::",
            stringify!(wReserved1)
        )
    );
}
impl _FTDCB {
    #[inline]
    pub fn fBinary(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fBinary(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fParity(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fParity(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutxCtsFlow(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutxCtsFlow(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutxDsrFlow(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutxDsrFlow(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDtrControl(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fDtrControl(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn fDsrSensitivity(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fDsrSensitivity(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fTXContinueOnXoff(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fTXContinueOnXoff(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fOutX(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fOutX(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fInX(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fInX(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fErrorChar(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fErrorChar(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fNull(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fNull(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fRtsControl(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_fRtsControl(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn fAbortOnError(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fAbortOnError(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fDummy2(&self) -> DWORD {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 17u8) as u32) }
    }
    #[inline]
    pub fn set_fDummy2(&mut self, val: DWORD) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 17u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        fBinary: DWORD,
        fParity: DWORD,
        fOutxCtsFlow: DWORD,
        fOutxDsrFlow: DWORD,
        fDtrControl: DWORD,
        fDsrSensitivity: DWORD,
        fTXContinueOnXoff: DWORD,
        fOutX: DWORD,
        fInX: DWORD,
        fErrorChar: DWORD,
        fNull: DWORD,
        fRtsControl: DWORD,
        fAbortOnError: DWORD,
        fDummy2: DWORD,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let fBinary: u32 = unsafe { ::std::mem::transmute(fBinary) };
            fBinary as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let fParity: u32 = unsafe { ::std::mem::transmute(fParity) };
            fParity as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let fOutxCtsFlow: u32 = unsafe { ::std::mem::transmute(fOutxCtsFlow) };
            fOutxCtsFlow as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let fOutxDsrFlow: u32 = unsafe { ::std::mem::transmute(fOutxDsrFlow) };
            fOutxDsrFlow as u64
        });
        __bindgen_bitfield_unit.set(4usize, 2u8, {
            let fDtrControl: u32 = unsafe { ::std::mem::transmute(fDtrControl) };
            fDtrControl as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let fDsrSensitivity: u32 = unsafe { ::std::mem::transmute(fDsrSensitivity) };
            fDsrSensitivity as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let fTXContinueOnXoff: u32 = unsafe { ::std::mem::transmute(fTXContinueOnXoff) };
            fTXContinueOnXoff as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fOutX: u32 = unsafe { ::std::mem::transmute(fOutX) };
            fOutX as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let fInX: u32 = unsafe { ::std::mem::transmute(fInX) };
            fInX as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let fErrorChar: u32 = unsafe { ::std::mem::transmute(fErrorChar) };
            fErrorChar as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let fNull: u32 = unsafe { ::std::mem::transmute(fNull) };
            fNull as u64
        });
        __bindgen_bitfield_unit.set(12usize, 2u8, {
            let fRtsControl: u32 = unsafe { ::std::mem::transmute(fRtsControl) };
            fRtsControl as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let fAbortOnError: u32 = unsafe { ::std::mem::transmute(fAbortOnError) };
            fAbortOnError as u64
        });
        __bindgen_bitfield_unit.set(15usize, 17u8, {
            let fDummy2: u32 = unsafe { ::std::mem::transmute(fDummy2) };
            fDummy2 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " Structure for FT_W32_SetCommState and FT_W32_GetCommState lpftDcb parameter."]
#[doc = " @see FT_W32_SetCommState"]
#[doc = " @see FT_W32_GetCommState"]
pub type LPFTDCB = *mut _FTDCB;
#[doc = " Structure for FT_W32_SetCommTimeouts and FT_W32_GetCommTimeouts lpftTimeouts parameter."]
#[doc = " @see FT_W32_SetCommTimeouts"]
#[doc = " @see FT_W32_GetCommTimeouts"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _FTTIMEOUTS {
    pub ReadIntervalTimeout: DWORD,
    #[doc = " Maximum time between read chars."]
    pub ReadTotalTimeoutMultiplier: DWORD,
    #[doc = " Multiplier of characters."]
    pub ReadTotalTimeoutConstant: DWORD,
    #[doc = " Constant in milliseconds."]
    pub WriteTotalTimeoutMultiplier: DWORD,
    #[doc = " Multiplier of characters."]
    pub WriteTotalTimeoutConstant: DWORD,
}
#[test]
fn bindgen_test_layout__FTTIMEOUTS() {
    assert_eq!(
        ::std::mem::size_of::<_FTTIMEOUTS>(),
        20usize,
        concat!("Size of: ", stringify!(_FTTIMEOUTS))
    );
    assert_eq!(
        ::std::mem::align_of::<_FTTIMEOUTS>(),
        4usize,
        concat!("Alignment of ", stringify!(_FTTIMEOUTS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadIntervalTimeout as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadIntervalTimeout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadTotalTimeoutMultiplier as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadTotalTimeoutMultiplier)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).ReadTotalTimeoutConstant as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(ReadTotalTimeoutConstant)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).WriteTotalTimeoutMultiplier as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(WriteTotalTimeoutMultiplier)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_FTTIMEOUTS>())).WriteTotalTimeoutConstant as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_FTTIMEOUTS),
            "::",
            stringify!(WriteTotalTimeoutConstant)
        )
    );
}
#[doc = " Structure for FT_W32_SetCommTimeouts and FT_W32_GetCommTimeouts lpftTimeouts parameter."]
#[doc = " @see FT_W32_SetCommTimeouts"]
#[doc = " @see FT_W32_GetCommTimeouts"]
pub type FTTIMEOUTS = _FTTIMEOUTS;
extern "C" {
    #[doc = " @noop FT_W32_SetCommState"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the state of the device according to the contents of a device control block (DCB)."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpftDcb Pointer to an FTDCB structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_SetCommState(ftHandle: FT_HANDLE, lpftDcb: LPFTDCB) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_GetCommState"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function gets the current device state."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpftDcb Pointer to an FTDCB structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " The current state of the device is returned in a device control block."]
    pub fn FT_W32_GetCommState(ftHandle: FT_HANDLE, lpftDcb: LPFTDCB) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_SetCommTimeouts"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function sets the timeout parameters for I/O requests."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pftTimeouts Pointer to an FTTIMEOUTS structure to store timeout information."]
    #[doc = " @returns"]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " Timeouts are calculated using the information in the FTTIMEOUTS structure."]
    #[doc = " @n For read requests, the number of bytes to be read is multiplied by the total timeout"]
    #[doc = " multiplier, and added to the total timeout constant. So, if TS is an FTTIMEOUTS structure"]
    #[doc = " and the number of bytes to read is dwToRead, the read timeout, rdTO, is calculated as follows."]
    #[doc = " @n rdTO = (dwToRead * TS.ReadTotalTimeoutMultiplier) + TS.ReadTotalTimeoutConstant"]
    #[doc = " @n For write requests, the number of bytes to be written is multiplied by the total timeout"]
    #[doc = " multiplier, and added to the total timeout constant. So, if TS is an FTTIMEOUTS structure"]
    #[doc = " and the number of bytes to write is dwToWrite, the write timeout, wrTO, is calculated as follows."]
    #[doc = " @n wrTO = (dwToWrite * TS.WriteTotalTimeoutMultiplier) + TS.WriteTotalTimeoutConstant"]
    #[doc = " @n Linux and Mac OS X currently ignore the ReadIntervalTimeout, ReadTotalTimeoutMultiplier and"]
    #[doc = " WriteTotalTimeoutMultiplier."]
    pub fn FT_W32_SetCommTimeouts(ftHandle: FT_HANDLE, pftTimeouts: *mut FTTIMEOUTS) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_GetCommTimeouts"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function gets the current read and write request timeout parameters for the specified device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pftTimeouts Pointer to an FTTIMEOUTS structure to store timeout information."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " For an explanation of how timeouts are used, see FT_W32_SetCommTimeouts."]
    pub fn FT_W32_GetCommTimeouts(ftHandle: FT_HANDLE, pftTimeouts: *mut FTTIMEOUTS) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_SetCommBreak"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Puts the communications line in the BREAK state."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_SetCommBreak(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_ClearCommBreak"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Puts the communications line in the non-BREAK state."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_ClearCommBreak(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_SetCommMask"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function specifies events that the device has to monitor."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param ulEventMask Mask containing events that the device has to monitor. This can be a combination of"]
    #[doc = " the following:"]
    #[doc = " @li EV_BREAK - BREAK condition detected"]
    #[doc = " @li EV_CTS - Change in Clear To Send (CTS)"]
    #[doc = " @li EV_DSR - Change in Data Set Ready (DSR)"]
    #[doc = " @li EV_ERR - Error in line status"]
    #[doc = " @li EV_RING - Change in Ring Indicator (RI)"]
    #[doc = " @li EV_RLSD - Change in Receive Line Signal Detect (RLSD)"]
    #[doc = " @li EV_RXCHAR - Character received"]
    #[doc = " @li EV_RXFLAG - Event character received"]
    #[doc = " @li EV_TXEMPTY - Transmitter empty"]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function specifies the events that the device should monitor. An application can call the"]
    #[doc = " function FT_W32_WaitCommEvent to wait for an event to occur."]
    pub fn FT_W32_SetCommMask(ftHandle: FT_HANDLE, ulEventMask: ULONG) -> BOOL;
}
extern "C" {
    #[doc = " @noop 6 FT_W32_GetCommMask"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Retrieves the events that are currently being monitored by a device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwEventMask Pointer to a location that receives a mask that contains the events that are"]
    #[doc = " currently enabled. This parameter can be one or more of the following values:"]
    #[doc = " @li EV_BREAK - BREAK condition detected"]
    #[doc = " @li EV_CTS - Change in Clear To Send (CTS)"]
    #[doc = " @li EV_DSR - Change in Data Set Ready (DSR)"]
    #[doc = " @li EV_ERR - Error in line status"]
    #[doc = " @li EV_RING - Change in Ring Indicator (RI)"]
    #[doc = " @li EV_RLSD - Change in Receive Line Signal Detect (RLSD)"]
    #[doc = " @li EV_RXCHAR - Character received"]
    #[doc = " @li EV_RXFLAG - Event character received"]
    #[doc = " @li EV_TXEMPTY - Transmitter empty"]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function returns events currently being monitored by the device. Event monitoring for these"]
    #[doc = " events is enabled by the FT_W32_SetCommMask function."]
    pub fn FT_W32_GetCommMask(ftHandle: FT_HANDLE, lpdwEventMask: LPDWORD) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_WaitCommEvent"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function waits for an event to occur."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param pulEvent Pointer to a location that receives a mask that contains the events that occurred."]
    #[doc = " @param lpOverlapped Pointer to an overlapped structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function supports both non-overlapped and overlapped I/O, except under Windows CE and Linux"]
    #[doc = " where only non-overlapped IO is supported."]
    #[doc = " @n @b Non-overlapped @b I/O"]
    #[doc = " The parameter, lpOverlapped, must be NULL for non-overlapped I/O."]
    #[doc = " @n This function does not return until an event that has been specified in a call to"]
    #[doc = " FT_W32_SetCommMask has occurred. The events that occurred and resulted in this function returning"]
    #[doc = " are stored in lpdwEvent."]
    #[doc = " @n @b Overlapped @b I/O"]
    #[doc = " @n When the device has been opened for overlapped I/O, an application can issue a request and perform"]
    #[doc = " some additional work while the request is pending. This contrasts with the case of non-overlapped"]
    #[doc = " I/O in which the application issues a request and receives control again only after the request has"]
    #[doc = " been\tcompleted."]
    #[doc = " @n The parameter, lpOverlapped, must point to an initialized OVERLAPPED structure."]
    #[doc = " This function does not return until an event that has been specified in a call to FT_W32_SetCommMask"]
    #[doc = " has occurred."]
    #[doc = " @n If an event has already occurred, the request completes immediately, and the return code is non-zero."]
    #[doc = " @n The events that occurred are stored in lpdwEvent."]
    #[doc = " @n If an event has not yet occurred, the request completes immediately, and the return code is zero,"]
    #[doc = " signifying an error. An application should call FT_W32_GetLastError to get the cause of the error. If"]
    #[doc = " the error code is ERROR_IO_PENDING, the overlapped operation is still in progress, and the application"]
    #[doc = " can perform other processing. Eventually, the application checks the result of the overlapped request"]
    #[doc = " by calling FT_W32_GetOverlappedResult. The events that occurred and resulted in this function"]
    #[doc = " returning are stored in lpdwEvent."]
    pub fn FT_W32_WaitCommEvent(
        ftHandle: FT_HANDLE,
        pulEvent: PULONG,
        lpOverlapped: LPOVERLAPPED,
    ) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_PurgeComm"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " This function purges the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param dwMask Specifies the action to take. The action can be a combination of the following:"]
    #[doc = " @li PURGE_TXABORT - Terminate outstanding overlapped writes"]
    #[doc = " @li PURGE_RXABORT - Terminate outstanding overlapped reads"]
    #[doc = " @li PURGE_TXCLEAR - Clear the transmit buffer"]
    #[doc = " @li PURGE_RXCLEAR - Clear the receive buffer"]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_PurgeComm(ftHandle: FT_HANDLE, dwMask: DWORD) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_GetLastError"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets the last error that occurred on the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    #[doc = " @remarks"]
    #[doc = " This function is normally used with overlapped I/O and so is not supported in Windows CE. For a"]
    #[doc = " description of its use, see FT_W32_ReadFile and FT_W32_WriteFile."]
    #[doc = " @n In Linux and Mac OS X, this function returns a DWORD that directly maps to the FT Errors (for"]
    #[doc = " example the FT_INVALID_HANDLE error number)."]
    pub fn FT_W32_GetLastError(ftHandle: FT_HANDLE) -> DWORD;
}
extern "C" {
    #[doc = " @noop FT_W32_ClearCommError"]
    #[doc = " @par Supported Operating Systems"]
    #[doc = " Linux"]
    #[doc = " Mac OS X (10.4 and later)"]
    #[doc = " Windows (2000 and later)"]
    #[doc = " Windows CE (4.2 and later)"]
    #[doc = " @par Summary"]
    #[doc = " Gets information about a communications error and get current status of the device."]
    #[doc = " @param ftHandle Handle of the device."]
    #[doc = " @param lpdwErrors Variable that contains the error mask."]
    #[doc = " @param lpftComstat Pointer to FTCOMSTAT structure."]
    #[doc = " @returns"]
    #[doc = " If the function is successful, the return value is nonzero."]
    #[doc = " If the function is unsuccessful, the return value is zero."]
    pub fn FT_W32_ClearCommError(
        ftHandle: FT_HANDLE,
        lpdwErrors: LPDWORD,
        lpftComstat: LPFTCOMSTAT,
    ) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_W32_CancelIo"]
    #[doc = " Undocumented function."]
    pub fn FT_W32_CancelIo(ftHandle: FT_HANDLE) -> BOOL;
}
extern "C" {
    #[doc = " @noop FT_EE_ReadConfig"]
    #[doc = " Undocumented function."]
    pub fn FT_EE_ReadConfig(ftHandle: FT_HANDLE, ucAddress: UCHAR, pucValue: PUCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_WriteConfig"]
    #[doc = " Undocumented function."]
    pub fn FT_EE_WriteConfig(ftHandle: FT_HANDLE, ucAddress: UCHAR, ucValue: UCHAR) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_EE_ReadECC"]
    #[doc = " Undocumented function."]
    pub fn FT_EE_ReadECC(ftHandle: FT_HANDLE, ucOption: UCHAR, lpwValue: LPWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_GetQueueStatusEx"]
    #[doc = " Undocumented function."]
    pub fn FT_GetQueueStatusEx(ftHandle: FT_HANDLE, dwRxBytes: *mut DWORD) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ComPortIdle"]
    #[doc = " Undocumented function."]
    pub fn FT_ComPortIdle(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_ComPortCancelIdle"]
    #[doc = " Undocumented function."]
    pub fn FT_ComPortCancelIdle(ftHandle: FT_HANDLE) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_VendorCmdGet"]
    #[doc = " Undocumented function."]
    pub fn FT_VendorCmdGet(
        ftHandle: FT_HANDLE,
        Request: UCHAR,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_VendorCmdSet"]
    #[doc = " Undocumented function."]
    pub fn FT_VendorCmdSet(
        ftHandle: FT_HANDLE,
        Request: UCHAR,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_VendorCmdGetEx"]
    #[doc = " Undocumented function."]
    pub fn FT_VendorCmdGetEx(
        ftHandle: FT_HANDLE,
        wValue: USHORT,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
extern "C" {
    #[doc = " @noop FT_VendorCmdSetEx"]
    #[doc = " Undocumented function."]
    pub fn FT_VendorCmdSetEx(
        ftHandle: FT_HANDLE,
        wValue: USHORT,
        Buf: *mut UCHAR,
        Len: USHORT,
    ) -> FT_STATUS;
}
