# libFMOD ![Crates.io](https://img.shields.io/crates/v/libfmod)

A library wrapper for integrating FMOD Engine in Rust applications. 
FFI wrapped in Rust code to make them safe, more idiomatic 
and abstract away uncomfortable manual C interface using.

#### FMOD Development Libraries

FMOD development libraries can't be integrated and distributed as part of this crate. 
You should download and install it considering your current licensing option from:
https://www.fmod.com/download

#### Installation

A crate uses FMOD development libraries version number to simplify version match.
The concept of "pre-releases" with a dash in the version used to specify 
backwards compatible changes and bug fixes in libFMOD code. 
Be aware that Cargo will avoid automatically using pre-releases unless explicitly asked.

```toml
[dependencies]
libfmod = "2.2.3-r.1"
```

#### Getting Started

The simplest way to get started is to initialize the FMOD system, load a sound, and play it.
Playing a sound does not block the application, all functions execute immediately, so we should poll for the sound to finish.

```rust
use libfmod::{Error, System};
use libfmod::ffi::{FMOD_DEFAULT, FMOD_INIT_NORMAL};

fn test_playing_sound() -> Result<(), Error> {
    let system = System::create()?;
    system.init(512, FMOD_INIT_NORMAL, None)?;
    let sound = system.create_sound("./data/heartbeat.ogg", FMOD_DEFAULT, None)?;
    let channel = system.play_sound(sound, None, false)?;
    while channel.is_playing()? {
        // do something else
    }
    system.release()
}
```

See more examples in [tests](tests) folder.

#### Contributing

This library is automatically generated by [libfmod-gen](https://github.com/lebedev-games/libfmod-gen) 
and can't be changed manually. All issues and pull requests must be created in repository of generator. 
