#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(unused_parens)]

use std::os::raw::{
    c_char, c_float, c_int, c_longlong, c_short, c_uchar, c_uint, c_ulonglong, c_ushort, c_void,
};
use std::ptr::null_mut;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_EVENTDESCRIPTION {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_EVENTINSTANCE {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_BUS {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_VCA {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_BANK {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_COMMANDREPLAY {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_SYSTEM {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_SOUND {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CHANNELCONTROL {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CHANNEL {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CHANNELGROUP {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_SOUNDGROUP {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_REVERB3D {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSPCONNECTION {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_POLYGON {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_GEOMETRY {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_SYNCPOINT {
    _unused: [u8; 0],
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_SYSTEM {
    _unused: [u8; 0],
}

pub type FMOD_BOOL = c_int;
pub type FMOD_PORT_INDEX = c_ulonglong;

pub const FMOD_STUDIO_LOAD_MEMORY_ALIGNMENT: c_uint = 32;
pub const FMOD_VERSION: c_uint = 0x00020203;
pub const FMOD_MAX_CHANNEL_WIDTH: c_uint = 32;
pub const FMOD_MAX_SYSTEMS: c_uint = 8;
pub const FMOD_MAX_LISTENERS: c_uint = 8;
pub const FMOD_REVERB_MAXINSTANCES: c_uint = 4;
pub const FMOD_PORT_INDEX_NONE: c_ulonglong = 0xFFFFFFFFFFFFFFFF;
pub const FMOD_CODEC_PLUGIN_VERSION: c_uint = 1;
pub const FMOD_OUTPUT_PLUGIN_VERSION: c_uint = 5;
pub const FMOD_PLUGIN_SDK_VERSION: c_uint = 110;
pub const FMOD_DSP_GETPARAM_VALUESTR_LENGTH: c_uint = 32;
pub const FMOD_DSP_LOUDNESS_METER_HISTOGRAM_SAMPLES: c_uint = 66;

pub type FMOD_STUDIO_LOADING_STATE = c_int;

pub const FMOD_STUDIO_LOADING_STATE_UNLOADING: FMOD_STUDIO_LOADING_STATE = 0;
pub const FMOD_STUDIO_LOADING_STATE_UNLOADED: FMOD_STUDIO_LOADING_STATE = 1;
pub const FMOD_STUDIO_LOADING_STATE_LOADING: FMOD_STUDIO_LOADING_STATE = 2;
pub const FMOD_STUDIO_LOADING_STATE_LOADED: FMOD_STUDIO_LOADING_STATE = 3;
pub const FMOD_STUDIO_LOADING_STATE_ERROR: FMOD_STUDIO_LOADING_STATE = 4;
pub const FMOD_STUDIO_LOADING_STATE_FORCEINT: FMOD_STUDIO_LOADING_STATE = 65536;

pub type FMOD_STUDIO_LOAD_MEMORY_MODE = c_int;

pub const FMOD_STUDIO_LOAD_MEMORY: FMOD_STUDIO_LOAD_MEMORY_MODE = 0;
pub const FMOD_STUDIO_LOAD_MEMORY_POINT: FMOD_STUDIO_LOAD_MEMORY_MODE = 1;
pub const FMOD_STUDIO_LOAD_MEMORY_FORCEINT: FMOD_STUDIO_LOAD_MEMORY_MODE = 65536;

pub type FMOD_STUDIO_PARAMETER_TYPE = c_int;

pub const FMOD_STUDIO_PARAMETER_GAME_CONTROLLED: FMOD_STUDIO_PARAMETER_TYPE = 0;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_DISTANCE: FMOD_STUDIO_PARAMETER_TYPE = 1;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_EVENT_CONE_ANGLE: FMOD_STUDIO_PARAMETER_TYPE = 2;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_EVENT_ORIENTATION: FMOD_STUDIO_PARAMETER_TYPE = 3;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_DIRECTION: FMOD_STUDIO_PARAMETER_TYPE = 4;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_ELEVATION: FMOD_STUDIO_PARAMETER_TYPE = 5;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_LISTENER_ORIENTATION: FMOD_STUDIO_PARAMETER_TYPE = 6;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_SPEED: FMOD_STUDIO_PARAMETER_TYPE = 7;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_SPEED_ABSOLUTE: FMOD_STUDIO_PARAMETER_TYPE = 8;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC_DISTANCE_NORMALIZED: FMOD_STUDIO_PARAMETER_TYPE = 9;
pub const FMOD_STUDIO_PARAMETER_MAX: FMOD_STUDIO_PARAMETER_TYPE = 10;
pub const FMOD_STUDIO_PARAMETER_FORCEINT: FMOD_STUDIO_PARAMETER_TYPE = 65536;

pub type FMOD_STUDIO_USER_PROPERTY_TYPE = c_int;

pub const FMOD_STUDIO_USER_PROPERTY_TYPE_INTEGER: FMOD_STUDIO_USER_PROPERTY_TYPE = 0;
pub const FMOD_STUDIO_USER_PROPERTY_TYPE_BOOLEAN: FMOD_STUDIO_USER_PROPERTY_TYPE = 1;
pub const FMOD_STUDIO_USER_PROPERTY_TYPE_FLOAT: FMOD_STUDIO_USER_PROPERTY_TYPE = 2;
pub const FMOD_STUDIO_USER_PROPERTY_TYPE_STRING: FMOD_STUDIO_USER_PROPERTY_TYPE = 3;
pub const FMOD_STUDIO_USER_PROPERTY_TYPE_FORCEINT: FMOD_STUDIO_USER_PROPERTY_TYPE = 65536;

pub type FMOD_STUDIO_EVENT_PROPERTY = c_int;

pub const FMOD_STUDIO_EVENT_PROPERTY_CHANNELPRIORITY: FMOD_STUDIO_EVENT_PROPERTY = 0;
pub const FMOD_STUDIO_EVENT_PROPERTY_SCHEDULE_DELAY: FMOD_STUDIO_EVENT_PROPERTY = 1;
pub const FMOD_STUDIO_EVENT_PROPERTY_SCHEDULE_LOOKAHEAD: FMOD_STUDIO_EVENT_PROPERTY = 2;
pub const FMOD_STUDIO_EVENT_PROPERTY_MINIMUM_DISTANCE: FMOD_STUDIO_EVENT_PROPERTY = 3;
pub const FMOD_STUDIO_EVENT_PROPERTY_MAXIMUM_DISTANCE: FMOD_STUDIO_EVENT_PROPERTY = 4;
pub const FMOD_STUDIO_EVENT_PROPERTY_COOLDOWN: FMOD_STUDIO_EVENT_PROPERTY = 5;
pub const FMOD_STUDIO_EVENT_PROPERTY_MAX: FMOD_STUDIO_EVENT_PROPERTY = 6;
pub const FMOD_STUDIO_EVENT_PROPERTY_FORCEINT: FMOD_STUDIO_EVENT_PROPERTY = 65536;

pub type FMOD_STUDIO_PLAYBACK_STATE = c_int;

pub const FMOD_STUDIO_PLAYBACK_PLAYING: FMOD_STUDIO_PLAYBACK_STATE = 0;
pub const FMOD_STUDIO_PLAYBACK_SUSTAINING: FMOD_STUDIO_PLAYBACK_STATE = 1;
pub const FMOD_STUDIO_PLAYBACK_STOPPED: FMOD_STUDIO_PLAYBACK_STATE = 2;
pub const FMOD_STUDIO_PLAYBACK_STARTING: FMOD_STUDIO_PLAYBACK_STATE = 3;
pub const FMOD_STUDIO_PLAYBACK_STOPPING: FMOD_STUDIO_PLAYBACK_STATE = 4;
pub const FMOD_STUDIO_PLAYBACK_FORCEINT: FMOD_STUDIO_PLAYBACK_STATE = 65536;

pub type FMOD_STUDIO_STOP_MODE = c_int;

pub const FMOD_STUDIO_STOP_ALLOWFADEOUT: FMOD_STUDIO_STOP_MODE = 0;
pub const FMOD_STUDIO_STOP_IMMEDIATE: FMOD_STUDIO_STOP_MODE = 1;
pub const FMOD_STUDIO_STOP_FORCEINT: FMOD_STUDIO_STOP_MODE = 65536;

pub type FMOD_STUDIO_INSTANCETYPE = c_int;

pub const FMOD_STUDIO_INSTANCETYPE_NONE: FMOD_STUDIO_INSTANCETYPE = 0;
pub const FMOD_STUDIO_INSTANCETYPE_SYSTEM: FMOD_STUDIO_INSTANCETYPE = 1;
pub const FMOD_STUDIO_INSTANCETYPE_EVENTDESCRIPTION: FMOD_STUDIO_INSTANCETYPE = 2;
pub const FMOD_STUDIO_INSTANCETYPE_EVENTINSTANCE: FMOD_STUDIO_INSTANCETYPE = 3;
pub const FMOD_STUDIO_INSTANCETYPE_PARAMETERINSTANCE: FMOD_STUDIO_INSTANCETYPE = 4;
pub const FMOD_STUDIO_INSTANCETYPE_BUS: FMOD_STUDIO_INSTANCETYPE = 5;
pub const FMOD_STUDIO_INSTANCETYPE_VCA: FMOD_STUDIO_INSTANCETYPE = 6;
pub const FMOD_STUDIO_INSTANCETYPE_BANK: FMOD_STUDIO_INSTANCETYPE = 7;
pub const FMOD_STUDIO_INSTANCETYPE_COMMANDREPLAY: FMOD_STUDIO_INSTANCETYPE = 8;
pub const FMOD_STUDIO_INSTANCETYPE_FORCEINT: FMOD_STUDIO_INSTANCETYPE = 65536;

pub type FMOD_THREAD_TYPE = c_int;

pub const FMOD_THREAD_TYPE_MIXER: FMOD_THREAD_TYPE = 0;
pub const FMOD_THREAD_TYPE_FEEDER: FMOD_THREAD_TYPE = 1;
pub const FMOD_THREAD_TYPE_STREAM: FMOD_THREAD_TYPE = 2;
pub const FMOD_THREAD_TYPE_FILE: FMOD_THREAD_TYPE = 3;
pub const FMOD_THREAD_TYPE_NONBLOCKING: FMOD_THREAD_TYPE = 4;
pub const FMOD_THREAD_TYPE_RECORD: FMOD_THREAD_TYPE = 5;
pub const FMOD_THREAD_TYPE_GEOMETRY: FMOD_THREAD_TYPE = 6;
pub const FMOD_THREAD_TYPE_PROFILER: FMOD_THREAD_TYPE = 7;
pub const FMOD_THREAD_TYPE_STUDIO_UPDATE: FMOD_THREAD_TYPE = 8;
pub const FMOD_THREAD_TYPE_STUDIO_LOAD_BANK: FMOD_THREAD_TYPE = 9;
pub const FMOD_THREAD_TYPE_STUDIO_LOAD_SAMPLE: FMOD_THREAD_TYPE = 10;
pub const FMOD_THREAD_TYPE_CONVOLUTION1: FMOD_THREAD_TYPE = 11;
pub const FMOD_THREAD_TYPE_CONVOLUTION2: FMOD_THREAD_TYPE = 12;
pub const FMOD_THREAD_TYPE_MAX: FMOD_THREAD_TYPE = 13;
pub const FMOD_THREAD_TYPE_FORCEINT: FMOD_THREAD_TYPE = 65536;

pub type FMOD_RESULT = c_int;

pub const FMOD_OK: FMOD_RESULT = 0;
pub const FMOD_ERR_BADCOMMAND: FMOD_RESULT = 1;
pub const FMOD_ERR_CHANNEL_ALLOC: FMOD_RESULT = 2;
pub const FMOD_ERR_CHANNEL_STOLEN: FMOD_RESULT = 3;
pub const FMOD_ERR_DMA: FMOD_RESULT = 4;
pub const FMOD_ERR_DSP_CONNECTION: FMOD_RESULT = 5;
pub const FMOD_ERR_DSP_DONTPROCESS: FMOD_RESULT = 6;
pub const FMOD_ERR_DSP_FORMAT: FMOD_RESULT = 7;
pub const FMOD_ERR_DSP_INUSE: FMOD_RESULT = 8;
pub const FMOD_ERR_DSP_NOTFOUND: FMOD_RESULT = 9;
pub const FMOD_ERR_DSP_RESERVED: FMOD_RESULT = 10;
pub const FMOD_ERR_DSP_SILENCE: FMOD_RESULT = 11;
pub const FMOD_ERR_DSP_TYPE: FMOD_RESULT = 12;
pub const FMOD_ERR_FILE_BAD: FMOD_RESULT = 13;
pub const FMOD_ERR_FILE_COULDNOTSEEK: FMOD_RESULT = 14;
pub const FMOD_ERR_FILE_DISKEJECTED: FMOD_RESULT = 15;
pub const FMOD_ERR_FILE_EOF: FMOD_RESULT = 16;
pub const FMOD_ERR_FILE_ENDOFDATA: FMOD_RESULT = 17;
pub const FMOD_ERR_FILE_NOTFOUND: FMOD_RESULT = 18;
pub const FMOD_ERR_FORMAT: FMOD_RESULT = 19;
pub const FMOD_ERR_HEADER_MISMATCH: FMOD_RESULT = 20;
pub const FMOD_ERR_HTTP: FMOD_RESULT = 21;
pub const FMOD_ERR_HTTP_ACCESS: FMOD_RESULT = 22;
pub const FMOD_ERR_HTTP_PROXY_AUTH: FMOD_RESULT = 23;
pub const FMOD_ERR_HTTP_SERVER_ERROR: FMOD_RESULT = 24;
pub const FMOD_ERR_HTTP_TIMEOUT: FMOD_RESULT = 25;
pub const FMOD_ERR_INITIALIZATION: FMOD_RESULT = 26;
pub const FMOD_ERR_INITIALIZED: FMOD_RESULT = 27;
pub const FMOD_ERR_INTERNAL: FMOD_RESULT = 28;
pub const FMOD_ERR_INVALID_FLOAT: FMOD_RESULT = 29;
pub const FMOD_ERR_INVALID_HANDLE: FMOD_RESULT = 30;
pub const FMOD_ERR_INVALID_PARAM: FMOD_RESULT = 31;
pub const FMOD_ERR_INVALID_POSITION: FMOD_RESULT = 32;
pub const FMOD_ERR_INVALID_SPEAKER: FMOD_RESULT = 33;
pub const FMOD_ERR_INVALID_SYNCPOINT: FMOD_RESULT = 34;
pub const FMOD_ERR_INVALID_THREAD: FMOD_RESULT = 35;
pub const FMOD_ERR_INVALID_VECTOR: FMOD_RESULT = 36;
pub const FMOD_ERR_MAXAUDIBLE: FMOD_RESULT = 37;
pub const FMOD_ERR_MEMORY: FMOD_RESULT = 38;
pub const FMOD_ERR_MEMORY_CANTPOINT: FMOD_RESULT = 39;
pub const FMOD_ERR_NEEDS3D: FMOD_RESULT = 40;
pub const FMOD_ERR_NEEDSHARDWARE: FMOD_RESULT = 41;
pub const FMOD_ERR_NET_CONNECT: FMOD_RESULT = 42;
pub const FMOD_ERR_NET_SOCKET_ERROR: FMOD_RESULT = 43;
pub const FMOD_ERR_NET_URL: FMOD_RESULT = 44;
pub const FMOD_ERR_NET_WOULD_BLOCK: FMOD_RESULT = 45;
pub const FMOD_ERR_NOTREADY: FMOD_RESULT = 46;
pub const FMOD_ERR_OUTPUT_ALLOCATED: FMOD_RESULT = 47;
pub const FMOD_ERR_OUTPUT_CREATEBUFFER: FMOD_RESULT = 48;
pub const FMOD_ERR_OUTPUT_DRIVERCALL: FMOD_RESULT = 49;
pub const FMOD_ERR_OUTPUT_FORMAT: FMOD_RESULT = 50;
pub const FMOD_ERR_OUTPUT_INIT: FMOD_RESULT = 51;
pub const FMOD_ERR_OUTPUT_NODRIVERS: FMOD_RESULT = 52;
pub const FMOD_ERR_PLUGIN: FMOD_RESULT = 53;
pub const FMOD_ERR_PLUGIN_MISSING: FMOD_RESULT = 54;
pub const FMOD_ERR_PLUGIN_RESOURCE: FMOD_RESULT = 55;
pub const FMOD_ERR_PLUGIN_VERSION: FMOD_RESULT = 56;
pub const FMOD_ERR_RECORD: FMOD_RESULT = 57;
pub const FMOD_ERR_REVERB_CHANNELGROUP: FMOD_RESULT = 58;
pub const FMOD_ERR_REVERB_INSTANCE: FMOD_RESULT = 59;
pub const FMOD_ERR_SUBSOUNDS: FMOD_RESULT = 60;
pub const FMOD_ERR_SUBSOUND_ALLOCATED: FMOD_RESULT = 61;
pub const FMOD_ERR_SUBSOUND_CANTMOVE: FMOD_RESULT = 62;
pub const FMOD_ERR_TAGNOTFOUND: FMOD_RESULT = 63;
pub const FMOD_ERR_TOOMANYCHANNELS: FMOD_RESULT = 64;
pub const FMOD_ERR_TRUNCATED: FMOD_RESULT = 65;
pub const FMOD_ERR_UNIMPLEMENTED: FMOD_RESULT = 66;
pub const FMOD_ERR_UNINITIALIZED: FMOD_RESULT = 67;
pub const FMOD_ERR_UNSUPPORTED: FMOD_RESULT = 68;
pub const FMOD_ERR_VERSION: FMOD_RESULT = 69;
pub const FMOD_ERR_EVENT_ALREADY_LOADED: FMOD_RESULT = 70;
pub const FMOD_ERR_EVENT_LIVEUPDATE_BUSY: FMOD_RESULT = 71;
pub const FMOD_ERR_EVENT_LIVEUPDATE_MISMATCH: FMOD_RESULT = 72;
pub const FMOD_ERR_EVENT_LIVEUPDATE_TIMEOUT: FMOD_RESULT = 73;
pub const FMOD_ERR_EVENT_NOTFOUND: FMOD_RESULT = 74;
pub const FMOD_ERR_STUDIO_UNINITIALIZED: FMOD_RESULT = 75;
pub const FMOD_ERR_STUDIO_NOT_LOADED: FMOD_RESULT = 76;
pub const FMOD_ERR_INVALID_STRING: FMOD_RESULT = 77;
pub const FMOD_ERR_ALREADY_LOCKED: FMOD_RESULT = 78;
pub const FMOD_ERR_NOT_LOCKED: FMOD_RESULT = 79;
pub const FMOD_ERR_RECORD_DISCONNECTED: FMOD_RESULT = 80;
pub const FMOD_ERR_TOOMANYSAMPLES: FMOD_RESULT = 81;
pub const FMOD_RESULT_FORCEINT: FMOD_RESULT = 65536;

pub type FMOD_CHANNELCONTROL_TYPE = c_int;

pub const FMOD_CHANNELCONTROL_CHANNEL: FMOD_CHANNELCONTROL_TYPE = 0;
pub const FMOD_CHANNELCONTROL_CHANNELGROUP: FMOD_CHANNELCONTROL_TYPE = 1;
pub const FMOD_CHANNELCONTROL_MAX: FMOD_CHANNELCONTROL_TYPE = 2;
pub const FMOD_CHANNELCONTROL_FORCEINT: FMOD_CHANNELCONTROL_TYPE = 65536;

pub type FMOD_OUTPUTTYPE = c_int;

pub const FMOD_OUTPUTTYPE_AUTODETECT: FMOD_OUTPUTTYPE = 0;
pub const FMOD_OUTPUTTYPE_UNKNOWN: FMOD_OUTPUTTYPE = 1;
pub const FMOD_OUTPUTTYPE_NOSOUND: FMOD_OUTPUTTYPE = 2;
pub const FMOD_OUTPUTTYPE_WAVWRITER: FMOD_OUTPUTTYPE = 3;
pub const FMOD_OUTPUTTYPE_NOSOUND_NRT: FMOD_OUTPUTTYPE = 4;
pub const FMOD_OUTPUTTYPE_WAVWRITER_NRT: FMOD_OUTPUTTYPE = 5;
pub const FMOD_OUTPUTTYPE_WASAPI: FMOD_OUTPUTTYPE = 6;
pub const FMOD_OUTPUTTYPE_ASIO: FMOD_OUTPUTTYPE = 7;
pub const FMOD_OUTPUTTYPE_PULSEAUDIO: FMOD_OUTPUTTYPE = 8;
pub const FMOD_OUTPUTTYPE_ALSA: FMOD_OUTPUTTYPE = 9;
pub const FMOD_OUTPUTTYPE_COREAUDIO: FMOD_OUTPUTTYPE = 10;
pub const FMOD_OUTPUTTYPE_AUDIOTRACK: FMOD_OUTPUTTYPE = 11;
pub const FMOD_OUTPUTTYPE_OPENSL: FMOD_OUTPUTTYPE = 12;
pub const FMOD_OUTPUTTYPE_AUDIOOUT: FMOD_OUTPUTTYPE = 13;
pub const FMOD_OUTPUTTYPE_AUDIO3D: FMOD_OUTPUTTYPE = 14;
pub const FMOD_OUTPUTTYPE_WEBAUDIO: FMOD_OUTPUTTYPE = 15;
pub const FMOD_OUTPUTTYPE_NNAUDIO: FMOD_OUTPUTTYPE = 16;
pub const FMOD_OUTPUTTYPE_WINSONIC: FMOD_OUTPUTTYPE = 17;
pub const FMOD_OUTPUTTYPE_AAUDIO: FMOD_OUTPUTTYPE = 18;
pub const FMOD_OUTPUTTYPE_MAX: FMOD_OUTPUTTYPE = 19;
pub const FMOD_OUTPUTTYPE_FORCEINT: FMOD_OUTPUTTYPE = 65536;

pub type FMOD_DEBUG_MODE = c_int;

pub const FMOD_DEBUG_MODE_TTY: FMOD_DEBUG_MODE = 0;
pub const FMOD_DEBUG_MODE_FILE: FMOD_DEBUG_MODE = 1;
pub const FMOD_DEBUG_MODE_CALLBACK: FMOD_DEBUG_MODE = 2;
pub const FMOD_DEBUG_MODE_FORCEINT: FMOD_DEBUG_MODE = 65536;

pub type FMOD_SPEAKERMODE = c_int;

pub const FMOD_SPEAKERMODE_DEFAULT: FMOD_SPEAKERMODE = 0;
pub const FMOD_SPEAKERMODE_RAW: FMOD_SPEAKERMODE = 1;
pub const FMOD_SPEAKERMODE_MONO: FMOD_SPEAKERMODE = 2;
pub const FMOD_SPEAKERMODE_STEREO: FMOD_SPEAKERMODE = 3;
pub const FMOD_SPEAKERMODE_QUAD: FMOD_SPEAKERMODE = 4;
pub const FMOD_SPEAKERMODE_SURROUND: FMOD_SPEAKERMODE = 5;
pub const FMOD_SPEAKERMODE_5POINT1: FMOD_SPEAKERMODE = 6;
pub const FMOD_SPEAKERMODE_7POINT1: FMOD_SPEAKERMODE = 7;
pub const FMOD_SPEAKERMODE_7POINT1POINT4: FMOD_SPEAKERMODE = 8;
pub const FMOD_SPEAKERMODE_MAX: FMOD_SPEAKERMODE = 9;
pub const FMOD_SPEAKERMODE_FORCEINT: FMOD_SPEAKERMODE = 65536;

pub type FMOD_SPEAKER = c_int;

pub const FMOD_SPEAKER_NONE: FMOD_SPEAKER = -1;
pub const FMOD_SPEAKER_FRONT_LEFT: FMOD_SPEAKER = 0;
pub const FMOD_SPEAKER_FRONT_RIGHT: FMOD_SPEAKER = 1;
pub const FMOD_SPEAKER_FRONT_CENTER: FMOD_SPEAKER = 2;
pub const FMOD_SPEAKER_LOW_FREQUENCY: FMOD_SPEAKER = 3;
pub const FMOD_SPEAKER_SURROUND_LEFT: FMOD_SPEAKER = 4;
pub const FMOD_SPEAKER_SURROUND_RIGHT: FMOD_SPEAKER = 5;
pub const FMOD_SPEAKER_BACK_LEFT: FMOD_SPEAKER = 6;
pub const FMOD_SPEAKER_BACK_RIGHT: FMOD_SPEAKER = 7;
pub const FMOD_SPEAKER_TOP_FRONT_LEFT: FMOD_SPEAKER = 8;
pub const FMOD_SPEAKER_TOP_FRONT_RIGHT: FMOD_SPEAKER = 9;
pub const FMOD_SPEAKER_TOP_BACK_LEFT: FMOD_SPEAKER = 10;
pub const FMOD_SPEAKER_TOP_BACK_RIGHT: FMOD_SPEAKER = 11;
pub const FMOD_SPEAKER_MAX: FMOD_SPEAKER = 12;
pub const FMOD_SPEAKER_FORCEINT: FMOD_SPEAKER = 65536;

pub type FMOD_CHANNELORDER = c_int;

pub const FMOD_CHANNELORDER_DEFAULT: FMOD_CHANNELORDER = 0;
pub const FMOD_CHANNELORDER_WAVEFORMAT: FMOD_CHANNELORDER = 1;
pub const FMOD_CHANNELORDER_PROTOOLS: FMOD_CHANNELORDER = 2;
pub const FMOD_CHANNELORDER_ALLMONO: FMOD_CHANNELORDER = 3;
pub const FMOD_CHANNELORDER_ALLSTEREO: FMOD_CHANNELORDER = 4;
pub const FMOD_CHANNELORDER_ALSA: FMOD_CHANNELORDER = 5;
pub const FMOD_CHANNELORDER_MAX: FMOD_CHANNELORDER = 6;
pub const FMOD_CHANNELORDER_FORCEINT: FMOD_CHANNELORDER = 65536;

pub type FMOD_PLUGINTYPE = c_int;

pub const FMOD_PLUGINTYPE_OUTPUT: FMOD_PLUGINTYPE = 0;
pub const FMOD_PLUGINTYPE_CODEC: FMOD_PLUGINTYPE = 1;
pub const FMOD_PLUGINTYPE_DSP: FMOD_PLUGINTYPE = 2;
pub const FMOD_PLUGINTYPE_MAX: FMOD_PLUGINTYPE = 3;
pub const FMOD_PLUGINTYPE_FORCEINT: FMOD_PLUGINTYPE = 65536;

pub type FMOD_SOUND_TYPE = c_int;

pub const FMOD_SOUND_TYPE_UNKNOWN: FMOD_SOUND_TYPE = 0;
pub const FMOD_SOUND_TYPE_AIFF: FMOD_SOUND_TYPE = 1;
pub const FMOD_SOUND_TYPE_ASF: FMOD_SOUND_TYPE = 2;
pub const FMOD_SOUND_TYPE_DLS: FMOD_SOUND_TYPE = 3;
pub const FMOD_SOUND_TYPE_FLAC: FMOD_SOUND_TYPE = 4;
pub const FMOD_SOUND_TYPE_FSB: FMOD_SOUND_TYPE = 5;
pub const FMOD_SOUND_TYPE_IT: FMOD_SOUND_TYPE = 6;
pub const FMOD_SOUND_TYPE_MIDI: FMOD_SOUND_TYPE = 7;
pub const FMOD_SOUND_TYPE_MOD: FMOD_SOUND_TYPE = 8;
pub const FMOD_SOUND_TYPE_MPEG: FMOD_SOUND_TYPE = 9;
pub const FMOD_SOUND_TYPE_OGGVORBIS: FMOD_SOUND_TYPE = 10;
pub const FMOD_SOUND_TYPE_PLAYLIST: FMOD_SOUND_TYPE = 11;
pub const FMOD_SOUND_TYPE_RAW: FMOD_SOUND_TYPE = 12;
pub const FMOD_SOUND_TYPE_S3M: FMOD_SOUND_TYPE = 13;
pub const FMOD_SOUND_TYPE_USER: FMOD_SOUND_TYPE = 14;
pub const FMOD_SOUND_TYPE_WAV: FMOD_SOUND_TYPE = 15;
pub const FMOD_SOUND_TYPE_XM: FMOD_SOUND_TYPE = 16;
pub const FMOD_SOUND_TYPE_XMA: FMOD_SOUND_TYPE = 17;
pub const FMOD_SOUND_TYPE_AUDIOQUEUE: FMOD_SOUND_TYPE = 18;
pub const FMOD_SOUND_TYPE_AT9: FMOD_SOUND_TYPE = 19;
pub const FMOD_SOUND_TYPE_VORBIS: FMOD_SOUND_TYPE = 20;
pub const FMOD_SOUND_TYPE_MEDIA_FOUNDATION: FMOD_SOUND_TYPE = 21;
pub const FMOD_SOUND_TYPE_MEDIACODEC: FMOD_SOUND_TYPE = 22;
pub const FMOD_SOUND_TYPE_FADPCM: FMOD_SOUND_TYPE = 23;
pub const FMOD_SOUND_TYPE_OPUS: FMOD_SOUND_TYPE = 24;
pub const FMOD_SOUND_TYPE_MAX: FMOD_SOUND_TYPE = 25;
pub const FMOD_SOUND_TYPE_FORCEINT: FMOD_SOUND_TYPE = 65536;

pub type FMOD_SOUND_FORMAT = c_int;

pub const FMOD_SOUND_FORMAT_NONE: FMOD_SOUND_FORMAT = 0;
pub const FMOD_SOUND_FORMAT_PCM8: FMOD_SOUND_FORMAT = 1;
pub const FMOD_SOUND_FORMAT_PCM16: FMOD_SOUND_FORMAT = 2;
pub const FMOD_SOUND_FORMAT_PCM24: FMOD_SOUND_FORMAT = 3;
pub const FMOD_SOUND_FORMAT_PCM32: FMOD_SOUND_FORMAT = 4;
pub const FMOD_SOUND_FORMAT_PCMFLOAT: FMOD_SOUND_FORMAT = 5;
pub const FMOD_SOUND_FORMAT_BITSTREAM: FMOD_SOUND_FORMAT = 6;
pub const FMOD_SOUND_FORMAT_MAX: FMOD_SOUND_FORMAT = 7;
pub const FMOD_SOUND_FORMAT_FORCEINT: FMOD_SOUND_FORMAT = 65536;

pub type FMOD_OPENSTATE = c_int;

pub const FMOD_OPENSTATE_READY: FMOD_OPENSTATE = 0;
pub const FMOD_OPENSTATE_LOADING: FMOD_OPENSTATE = 1;
pub const FMOD_OPENSTATE_ERROR: FMOD_OPENSTATE = 2;
pub const FMOD_OPENSTATE_CONNECTING: FMOD_OPENSTATE = 3;
pub const FMOD_OPENSTATE_BUFFERING: FMOD_OPENSTATE = 4;
pub const FMOD_OPENSTATE_SEEKING: FMOD_OPENSTATE = 5;
pub const FMOD_OPENSTATE_PLAYING: FMOD_OPENSTATE = 6;
pub const FMOD_OPENSTATE_SETPOSITION: FMOD_OPENSTATE = 7;
pub const FMOD_OPENSTATE_MAX: FMOD_OPENSTATE = 8;
pub const FMOD_OPENSTATE_FORCEINT: FMOD_OPENSTATE = 65536;

pub type FMOD_SOUNDGROUP_BEHAVIOR = c_int;

pub const FMOD_SOUNDGROUP_BEHAVIOR_FAIL: FMOD_SOUNDGROUP_BEHAVIOR = 0;
pub const FMOD_SOUNDGROUP_BEHAVIOR_MUTE: FMOD_SOUNDGROUP_BEHAVIOR = 1;
pub const FMOD_SOUNDGROUP_BEHAVIOR_STEALLOWEST: FMOD_SOUNDGROUP_BEHAVIOR = 2;
pub const FMOD_SOUNDGROUP_BEHAVIOR_MAX: FMOD_SOUNDGROUP_BEHAVIOR = 3;
pub const FMOD_SOUNDGROUP_BEHAVIOR_FORCEINT: FMOD_SOUNDGROUP_BEHAVIOR = 65536;

pub type FMOD_CHANNELCONTROL_CALLBACK_TYPE = c_int;

pub const FMOD_CHANNELCONTROL_CALLBACK_END: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 0;
pub const FMOD_CHANNELCONTROL_CALLBACK_VIRTUALVOICE: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 1;
pub const FMOD_CHANNELCONTROL_CALLBACK_SYNCPOINT: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 2;
pub const FMOD_CHANNELCONTROL_CALLBACK_OCCLUSION: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 3;
pub const FMOD_CHANNELCONTROL_CALLBACK_MAX: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 4;
pub const FMOD_CHANNELCONTROL_CALLBACK_FORCEINT: FMOD_CHANNELCONTROL_CALLBACK_TYPE = 65536;

pub type FMOD_CHANNELCONTROL_DSP_INDEX = c_int;

pub const FMOD_CHANNELCONTROL_DSP_HEAD: FMOD_CHANNELCONTROL_DSP_INDEX = -1;
pub const FMOD_CHANNELCONTROL_DSP_FADER: FMOD_CHANNELCONTROL_DSP_INDEX = -2;
pub const FMOD_CHANNELCONTROL_DSP_TAIL: FMOD_CHANNELCONTROL_DSP_INDEX = -3;
pub const FMOD_CHANNELCONTROL_DSP_FORCEINT: FMOD_CHANNELCONTROL_DSP_INDEX = 65536;

pub type FMOD_ERRORCALLBACK_INSTANCETYPE = c_int;

pub const FMOD_ERRORCALLBACK_INSTANCETYPE_NONE: FMOD_ERRORCALLBACK_INSTANCETYPE = 0;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_SYSTEM: FMOD_ERRORCALLBACK_INSTANCETYPE = 1;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_CHANNEL: FMOD_ERRORCALLBACK_INSTANCETYPE = 2;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_CHANNELGROUP: FMOD_ERRORCALLBACK_INSTANCETYPE = 3;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_CHANNELCONTROL: FMOD_ERRORCALLBACK_INSTANCETYPE = 4;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_SOUND: FMOD_ERRORCALLBACK_INSTANCETYPE = 5;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_SOUNDGROUP: FMOD_ERRORCALLBACK_INSTANCETYPE = 6;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_DSP: FMOD_ERRORCALLBACK_INSTANCETYPE = 7;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_DSPCONNECTION: FMOD_ERRORCALLBACK_INSTANCETYPE = 8;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_GEOMETRY: FMOD_ERRORCALLBACK_INSTANCETYPE = 9;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_REVERB3D: FMOD_ERRORCALLBACK_INSTANCETYPE = 10;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_SYSTEM: FMOD_ERRORCALLBACK_INSTANCETYPE = 11;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_EVENTDESCRIPTION: FMOD_ERRORCALLBACK_INSTANCETYPE =
    12;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_EVENTINSTANCE: FMOD_ERRORCALLBACK_INSTANCETYPE =
    13;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_PARAMETERINSTANCE:
FMOD_ERRORCALLBACK_INSTANCETYPE = 14;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_BUS: FMOD_ERRORCALLBACK_INSTANCETYPE = 15;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_VCA: FMOD_ERRORCALLBACK_INSTANCETYPE = 16;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_BANK: FMOD_ERRORCALLBACK_INSTANCETYPE = 17;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_STUDIO_COMMANDREPLAY: FMOD_ERRORCALLBACK_INSTANCETYPE =
    18;
pub const FMOD_ERRORCALLBACK_INSTANCETYPE_FORCEINT: FMOD_ERRORCALLBACK_INSTANCETYPE = 65536;

pub type FMOD_DSP_RESAMPLER = c_int;

pub const FMOD_DSP_RESAMPLER_DEFAULT: FMOD_DSP_RESAMPLER = 0;
pub const FMOD_DSP_RESAMPLER_NOINTERP: FMOD_DSP_RESAMPLER = 1;
pub const FMOD_DSP_RESAMPLER_LINEAR: FMOD_DSP_RESAMPLER = 2;
pub const FMOD_DSP_RESAMPLER_CUBIC: FMOD_DSP_RESAMPLER = 3;
pub const FMOD_DSP_RESAMPLER_SPLINE: FMOD_DSP_RESAMPLER = 4;
pub const FMOD_DSP_RESAMPLER_MAX: FMOD_DSP_RESAMPLER = 5;
pub const FMOD_DSP_RESAMPLER_FORCEINT: FMOD_DSP_RESAMPLER = 65536;

pub type FMOD_DSPCONNECTION_TYPE = c_int;

pub const FMOD_DSPCONNECTION_TYPE_STANDARD: FMOD_DSPCONNECTION_TYPE = 0;
pub const FMOD_DSPCONNECTION_TYPE_SIDECHAIN: FMOD_DSPCONNECTION_TYPE = 1;
pub const FMOD_DSPCONNECTION_TYPE_SEND: FMOD_DSPCONNECTION_TYPE = 2;
pub const FMOD_DSPCONNECTION_TYPE_SEND_SIDECHAIN: FMOD_DSPCONNECTION_TYPE = 3;
pub const FMOD_DSPCONNECTION_TYPE_MAX: FMOD_DSPCONNECTION_TYPE = 4;
pub const FMOD_DSPCONNECTION_TYPE_FORCEINT: FMOD_DSPCONNECTION_TYPE = 65536;

pub type FMOD_TAGTYPE = c_int;

pub const FMOD_TAGTYPE_UNKNOWN: FMOD_TAGTYPE = 0;
pub const FMOD_TAGTYPE_ID3V1: FMOD_TAGTYPE = 1;
pub const FMOD_TAGTYPE_ID3V2: FMOD_TAGTYPE = 2;
pub const FMOD_TAGTYPE_VORBISCOMMENT: FMOD_TAGTYPE = 3;
pub const FMOD_TAGTYPE_SHOUTCAST: FMOD_TAGTYPE = 4;
pub const FMOD_TAGTYPE_ICECAST: FMOD_TAGTYPE = 5;
pub const FMOD_TAGTYPE_ASF: FMOD_TAGTYPE = 6;
pub const FMOD_TAGTYPE_MIDI: FMOD_TAGTYPE = 7;
pub const FMOD_TAGTYPE_PLAYLIST: FMOD_TAGTYPE = 8;
pub const FMOD_TAGTYPE_FMOD: FMOD_TAGTYPE = 9;
pub const FMOD_TAGTYPE_USER: FMOD_TAGTYPE = 10;
pub const FMOD_TAGTYPE_MAX: FMOD_TAGTYPE = 11;
pub const FMOD_TAGTYPE_FORCEINT: FMOD_TAGTYPE = 65536;

pub type FMOD_TAGDATATYPE = c_int;

pub const FMOD_TAGDATATYPE_BINARY: FMOD_TAGDATATYPE = 0;
pub const FMOD_TAGDATATYPE_INT: FMOD_TAGDATATYPE = 1;
pub const FMOD_TAGDATATYPE_FLOAT: FMOD_TAGDATATYPE = 2;
pub const FMOD_TAGDATATYPE_STRING: FMOD_TAGDATATYPE = 3;
pub const FMOD_TAGDATATYPE_STRING_UTF16: FMOD_TAGDATATYPE = 4;
pub const FMOD_TAGDATATYPE_STRING_UTF16BE: FMOD_TAGDATATYPE = 5;
pub const FMOD_TAGDATATYPE_STRING_UTF8: FMOD_TAGDATATYPE = 6;
pub const FMOD_TAGDATATYPE_MAX: FMOD_TAGDATATYPE = 7;
pub const FMOD_TAGDATATYPE_FORCEINT: FMOD_TAGDATATYPE = 65536;

pub type FMOD_PORT_TYPE = c_int;

pub const FMOD_PORT_TYPE_MUSIC: FMOD_PORT_TYPE = 0;
pub const FMOD_PORT_TYPE_COPYRIGHT_MUSIC: FMOD_PORT_TYPE = 1;
pub const FMOD_PORT_TYPE_VOICE: FMOD_PORT_TYPE = 2;
pub const FMOD_PORT_TYPE_CONTROLLER: FMOD_PORT_TYPE = 3;
pub const FMOD_PORT_TYPE_PERSONAL: FMOD_PORT_TYPE = 4;
pub const FMOD_PORT_TYPE_VIBRATION: FMOD_PORT_TYPE = 5;
pub const FMOD_PORT_TYPE_AUX: FMOD_PORT_TYPE = 6;
pub const FMOD_PORT_TYPE_MAX: FMOD_PORT_TYPE = 7;
pub const FMOD_PORT_TYPE_FORCEINT: FMOD_PORT_TYPE = 65536;

pub type FMOD_DSP_PROCESS_OPERATION = c_int;

pub const FMOD_DSP_PROCESS_PERFORM: FMOD_DSP_PROCESS_OPERATION = 0;
pub const FMOD_DSP_PROCESS_QUERY: FMOD_DSP_PROCESS_OPERATION = 1;

pub type FMOD_DSP_PAN_SURROUND_FLAGS = c_int;

pub const FMOD_DSP_PAN_SURROUND_DEFAULT: FMOD_DSP_PAN_SURROUND_FLAGS = 0;
pub const FMOD_DSP_PAN_SURROUND_ROTATION_NOT_BIASED: FMOD_DSP_PAN_SURROUND_FLAGS = 1;
pub const FMOD_DSP_PAN_SURROUND_FLAGS_FORCEINT: FMOD_DSP_PAN_SURROUND_FLAGS = 65536;

pub type FMOD_DSP_PARAMETER_TYPE = c_int;

pub const FMOD_DSP_PARAMETER_TYPE_FLOAT: FMOD_DSP_PARAMETER_TYPE = 0;
pub const FMOD_DSP_PARAMETER_TYPE_INT: FMOD_DSP_PARAMETER_TYPE = 1;
pub const FMOD_DSP_PARAMETER_TYPE_BOOL: FMOD_DSP_PARAMETER_TYPE = 2;
pub const FMOD_DSP_PARAMETER_TYPE_DATA: FMOD_DSP_PARAMETER_TYPE = 3;
pub const FMOD_DSP_PARAMETER_TYPE_MAX: FMOD_DSP_PARAMETER_TYPE = 4;
pub const FMOD_DSP_PARAMETER_TYPE_FORCEINT: FMOD_DSP_PARAMETER_TYPE = 65536;

pub type FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE = c_int;

pub const FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE_LINEAR: FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE = 0;
pub const FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE_AUTO: FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE = 1;
pub const FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE_PIECEWISE_LINEAR:
FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE = 2;
pub const FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE_FORCEINT: FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE =
    65536;

pub type FMOD_DSP_PARAMETER_DATA_TYPE = c_int;

pub const FMOD_DSP_PARAMETER_DATA_TYPE_USER: FMOD_DSP_PARAMETER_DATA_TYPE = 0;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_OVERALLGAIN: FMOD_DSP_PARAMETER_DATA_TYPE = -1;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_3DATTRIBUTES: FMOD_DSP_PARAMETER_DATA_TYPE = -2;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_SIDECHAIN: FMOD_DSP_PARAMETER_DATA_TYPE = -3;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_FFT: FMOD_DSP_PARAMETER_DATA_TYPE = -4;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_3DATTRIBUTES_MULTI: FMOD_DSP_PARAMETER_DATA_TYPE = -5;
pub const FMOD_DSP_PARAMETER_DATA_TYPE_ATTENUATION_RANGE: FMOD_DSP_PARAMETER_DATA_TYPE = -6;

pub type FMOD_DSP_TYPE = c_int;

pub const FMOD_DSP_TYPE_UNKNOWN: FMOD_DSP_TYPE = 0;
pub const FMOD_DSP_TYPE_MIXER: FMOD_DSP_TYPE = 1;
pub const FMOD_DSP_TYPE_OSCILLATOR: FMOD_DSP_TYPE = 2;
pub const FMOD_DSP_TYPE_LOWPASS: FMOD_DSP_TYPE = 3;
pub const FMOD_DSP_TYPE_ITLOWPASS: FMOD_DSP_TYPE = 4;
pub const FMOD_DSP_TYPE_HIGHPASS: FMOD_DSP_TYPE = 5;
pub const FMOD_DSP_TYPE_ECHO: FMOD_DSP_TYPE = 6;
pub const FMOD_DSP_TYPE_FADER: FMOD_DSP_TYPE = 7;
pub const FMOD_DSP_TYPE_FLANGE: FMOD_DSP_TYPE = 8;
pub const FMOD_DSP_TYPE_DISTORTION: FMOD_DSP_TYPE = 9;
pub const FMOD_DSP_TYPE_NORMALIZE: FMOD_DSP_TYPE = 10;
pub const FMOD_DSP_TYPE_LIMITER: FMOD_DSP_TYPE = 11;
pub const FMOD_DSP_TYPE_PARAMEQ: FMOD_DSP_TYPE = 12;
pub const FMOD_DSP_TYPE_PITCHSHIFT: FMOD_DSP_TYPE = 13;
pub const FMOD_DSP_TYPE_CHORUS: FMOD_DSP_TYPE = 14;
pub const FMOD_DSP_TYPE_VSTPLUGIN: FMOD_DSP_TYPE = 15;
pub const FMOD_DSP_TYPE_WINAMPPLUGIN: FMOD_DSP_TYPE = 16;
pub const FMOD_DSP_TYPE_ITECHO: FMOD_DSP_TYPE = 17;
pub const FMOD_DSP_TYPE_COMPRESSOR: FMOD_DSP_TYPE = 18;
pub const FMOD_DSP_TYPE_SFXREVERB: FMOD_DSP_TYPE = 19;
pub const FMOD_DSP_TYPE_LOWPASS_SIMPLE: FMOD_DSP_TYPE = 20;
pub const FMOD_DSP_TYPE_DELAY: FMOD_DSP_TYPE = 21;
pub const FMOD_DSP_TYPE_TREMOLO: FMOD_DSP_TYPE = 22;
pub const FMOD_DSP_TYPE_LADSPAPLUGIN: FMOD_DSP_TYPE = 23;
pub const FMOD_DSP_TYPE_SEND: FMOD_DSP_TYPE = 24;
pub const FMOD_DSP_TYPE_RETURN: FMOD_DSP_TYPE = 25;
pub const FMOD_DSP_TYPE_HIGHPASS_SIMPLE: FMOD_DSP_TYPE = 26;
pub const FMOD_DSP_TYPE_PAN: FMOD_DSP_TYPE = 27;
pub const FMOD_DSP_TYPE_THREE_EQ: FMOD_DSP_TYPE = 28;
pub const FMOD_DSP_TYPE_FFT: FMOD_DSP_TYPE = 29;
pub const FMOD_DSP_TYPE_LOUDNESS_METER: FMOD_DSP_TYPE = 30;
pub const FMOD_DSP_TYPE_ENVELOPEFOLLOWER: FMOD_DSP_TYPE = 31;
pub const FMOD_DSP_TYPE_CONVOLUTIONREVERB: FMOD_DSP_TYPE = 32;
pub const FMOD_DSP_TYPE_CHANNELMIX: FMOD_DSP_TYPE = 33;
pub const FMOD_DSP_TYPE_TRANSCEIVER: FMOD_DSP_TYPE = 34;
pub const FMOD_DSP_TYPE_OBJECTPAN: FMOD_DSP_TYPE = 35;
pub const FMOD_DSP_TYPE_MULTIBAND_EQ: FMOD_DSP_TYPE = 36;
pub const FMOD_DSP_TYPE_MAX: FMOD_DSP_TYPE = 37;
pub const FMOD_DSP_TYPE_FORCEINT: FMOD_DSP_TYPE = 65536;

pub type FMOD_DSP_OSCILLATOR = c_int;

pub const FMOD_DSP_OSCILLATOR_TYPE: FMOD_DSP_OSCILLATOR = 0;
pub const FMOD_DSP_OSCILLATOR_RATE: FMOD_DSP_OSCILLATOR = 1;

pub type FMOD_DSP_LOWPASS = c_int;

pub const FMOD_DSP_LOWPASS_CUTOFF: FMOD_DSP_LOWPASS = 0;
pub const FMOD_DSP_LOWPASS_RESONANCE: FMOD_DSP_LOWPASS = 1;

pub type FMOD_DSP_ITLOWPASS = c_int;

pub const FMOD_DSP_ITLOWPASS_CUTOFF: FMOD_DSP_ITLOWPASS = 0;
pub const FMOD_DSP_ITLOWPASS_RESONANCE: FMOD_DSP_ITLOWPASS = 1;

pub type FMOD_DSP_HIGHPASS = c_int;

pub const FMOD_DSP_HIGHPASS_CUTOFF: FMOD_DSP_HIGHPASS = 0;
pub const FMOD_DSP_HIGHPASS_RESONANCE: FMOD_DSP_HIGHPASS = 1;

pub type FMOD_DSP_ECHO = c_int;

pub const FMOD_DSP_ECHO_DELAY: FMOD_DSP_ECHO = 0;
pub const FMOD_DSP_ECHO_FEEDBACK: FMOD_DSP_ECHO = 1;
pub const FMOD_DSP_ECHO_DRYLEVEL: FMOD_DSP_ECHO = 2;
pub const FMOD_DSP_ECHO_WETLEVEL: FMOD_DSP_ECHO = 3;

pub type FMOD_DSP_FADER = c_int;

pub const FMOD_DSP_FADER_GAIN: FMOD_DSP_FADER = 0;
pub const FMOD_DSP_FADER_OVERALL_GAIN: FMOD_DSP_FADER = 1;

pub type FMOD_DSP_FLANGE = c_int;

pub const FMOD_DSP_FLANGE_MIX: FMOD_DSP_FLANGE = 0;
pub const FMOD_DSP_FLANGE_DEPTH: FMOD_DSP_FLANGE = 1;
pub const FMOD_DSP_FLANGE_RATE: FMOD_DSP_FLANGE = 2;

pub type FMOD_DSP_DISTORTION = c_int;

pub const FMOD_DSP_DISTORTION_LEVEL: FMOD_DSP_DISTORTION = 0;

pub type FMOD_DSP_NORMALIZE = c_int;

pub const FMOD_DSP_NORMALIZE_FADETIME: FMOD_DSP_NORMALIZE = 0;
pub const FMOD_DSP_NORMALIZE_THRESHOLD: FMOD_DSP_NORMALIZE = 1;
pub const FMOD_DSP_NORMALIZE_MAXAMP: FMOD_DSP_NORMALIZE = 2;

pub type FMOD_DSP_LIMITER = c_int;

pub const FMOD_DSP_LIMITER_RELEASETIME: FMOD_DSP_LIMITER = 0;
pub const FMOD_DSP_LIMITER_CEILING: FMOD_DSP_LIMITER = 1;
pub const FMOD_DSP_LIMITER_MAXIMIZERGAIN: FMOD_DSP_LIMITER = 2;
pub const FMOD_DSP_LIMITER_MODE: FMOD_DSP_LIMITER = 3;

pub type FMOD_DSP_PARAMEQ = c_int;

pub const FMOD_DSP_PARAMEQ_CENTER: FMOD_DSP_PARAMEQ = 0;
pub const FMOD_DSP_PARAMEQ_BANDWIDTH: FMOD_DSP_PARAMEQ = 1;
pub const FMOD_DSP_PARAMEQ_GAIN: FMOD_DSP_PARAMEQ = 2;

pub type FMOD_DSP_MULTIBAND_EQ = c_int;

pub const FMOD_DSP_MULTIBAND_EQ_A_FILTER: FMOD_DSP_MULTIBAND_EQ = 0;
pub const FMOD_DSP_MULTIBAND_EQ_A_FREQUENCY: FMOD_DSP_MULTIBAND_EQ = 1;
pub const FMOD_DSP_MULTIBAND_EQ_A_Q: FMOD_DSP_MULTIBAND_EQ = 2;
pub const FMOD_DSP_MULTIBAND_EQ_A_GAIN: FMOD_DSP_MULTIBAND_EQ = 3;
pub const FMOD_DSP_MULTIBAND_EQ_B_FILTER: FMOD_DSP_MULTIBAND_EQ = 4;
pub const FMOD_DSP_MULTIBAND_EQ_B_FREQUENCY: FMOD_DSP_MULTIBAND_EQ = 5;
pub const FMOD_DSP_MULTIBAND_EQ_B_Q: FMOD_DSP_MULTIBAND_EQ = 6;
pub const FMOD_DSP_MULTIBAND_EQ_B_GAIN: FMOD_DSP_MULTIBAND_EQ = 7;
pub const FMOD_DSP_MULTIBAND_EQ_C_FILTER: FMOD_DSP_MULTIBAND_EQ = 8;
pub const FMOD_DSP_MULTIBAND_EQ_C_FREQUENCY: FMOD_DSP_MULTIBAND_EQ = 9;
pub const FMOD_DSP_MULTIBAND_EQ_C_Q: FMOD_DSP_MULTIBAND_EQ = 10;
pub const FMOD_DSP_MULTIBAND_EQ_C_GAIN: FMOD_DSP_MULTIBAND_EQ = 11;
pub const FMOD_DSP_MULTIBAND_EQ_D_FILTER: FMOD_DSP_MULTIBAND_EQ = 12;
pub const FMOD_DSP_MULTIBAND_EQ_D_FREQUENCY: FMOD_DSP_MULTIBAND_EQ = 13;
pub const FMOD_DSP_MULTIBAND_EQ_D_Q: FMOD_DSP_MULTIBAND_EQ = 14;
pub const FMOD_DSP_MULTIBAND_EQ_D_GAIN: FMOD_DSP_MULTIBAND_EQ = 15;
pub const FMOD_DSP_MULTIBAND_EQ_E_FILTER: FMOD_DSP_MULTIBAND_EQ = 16;
pub const FMOD_DSP_MULTIBAND_EQ_E_FREQUENCY: FMOD_DSP_MULTIBAND_EQ = 17;
pub const FMOD_DSP_MULTIBAND_EQ_E_Q: FMOD_DSP_MULTIBAND_EQ = 18;
pub const FMOD_DSP_MULTIBAND_EQ_E_GAIN: FMOD_DSP_MULTIBAND_EQ = 19;

pub type FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = c_int;

pub const FMOD_DSP_MULTIBAND_EQ_FILTER_DISABLED: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 0;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_LOWPASS_12DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 1;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_LOWPASS_24DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 2;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_LOWPASS_48DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 3;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_HIGHPASS_12DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 4;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_HIGHPASS_24DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 5;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_HIGHPASS_48DB: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 6;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_LOWSHELF: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 7;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_HIGHSHELF: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 8;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_PEAKING: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 9;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_BANDPASS: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 10;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_NOTCH: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 11;
pub const FMOD_DSP_MULTIBAND_EQ_FILTER_ALLPASS: FMOD_DSP_MULTIBAND_EQ_FILTER_TYPE = 12;

pub type FMOD_DSP_PITCHSHIFT = c_int;

pub const FMOD_DSP_PITCHSHIFT_PITCH: FMOD_DSP_PITCHSHIFT = 0;
pub const FMOD_DSP_PITCHSHIFT_FFTSIZE: FMOD_DSP_PITCHSHIFT = 1;
pub const FMOD_DSP_PITCHSHIFT_OVERLAP: FMOD_DSP_PITCHSHIFT = 2;
pub const FMOD_DSP_PITCHSHIFT_MAXCHANNELS: FMOD_DSP_PITCHSHIFT = 3;

pub type FMOD_DSP_CHORUS = c_int;

pub const FMOD_DSP_CHORUS_MIX: FMOD_DSP_CHORUS = 0;
pub const FMOD_DSP_CHORUS_RATE: FMOD_DSP_CHORUS = 1;
pub const FMOD_DSP_CHORUS_DEPTH: FMOD_DSP_CHORUS = 2;

pub type FMOD_DSP_ITECHO = c_int;

pub const FMOD_DSP_ITECHO_WETDRYMIX: FMOD_DSP_ITECHO = 0;
pub const FMOD_DSP_ITECHO_FEEDBACK: FMOD_DSP_ITECHO = 1;
pub const FMOD_DSP_ITECHO_LEFTDELAY: FMOD_DSP_ITECHO = 2;
pub const FMOD_DSP_ITECHO_RIGHTDELAY: FMOD_DSP_ITECHO = 3;
pub const FMOD_DSP_ITECHO_PANDELAY: FMOD_DSP_ITECHO = 4;

pub type FMOD_DSP_COMPRESSOR = c_int;

pub const FMOD_DSP_COMPRESSOR_THRESHOLD: FMOD_DSP_COMPRESSOR = 0;
pub const FMOD_DSP_COMPRESSOR_RATIO: FMOD_DSP_COMPRESSOR = 1;
pub const FMOD_DSP_COMPRESSOR_ATTACK: FMOD_DSP_COMPRESSOR = 2;
pub const FMOD_DSP_COMPRESSOR_RELEASE: FMOD_DSP_COMPRESSOR = 3;
pub const FMOD_DSP_COMPRESSOR_GAINMAKEUP: FMOD_DSP_COMPRESSOR = 4;
pub const FMOD_DSP_COMPRESSOR_USESIDECHAIN: FMOD_DSP_COMPRESSOR = 5;
pub const FMOD_DSP_COMPRESSOR_LINKED: FMOD_DSP_COMPRESSOR = 6;

pub type FMOD_DSP_SFXREVERB = c_int;

pub const FMOD_DSP_SFXREVERB_DECAYTIME: FMOD_DSP_SFXREVERB = 0;
pub const FMOD_DSP_SFXREVERB_EARLYDELAY: FMOD_DSP_SFXREVERB = 1;
pub const FMOD_DSP_SFXREVERB_LATEDELAY: FMOD_DSP_SFXREVERB = 2;
pub const FMOD_DSP_SFXREVERB_HFREFERENCE: FMOD_DSP_SFXREVERB = 3;
pub const FMOD_DSP_SFXREVERB_HFDECAYRATIO: FMOD_DSP_SFXREVERB = 4;
pub const FMOD_DSP_SFXREVERB_DIFFUSION: FMOD_DSP_SFXREVERB = 5;
pub const FMOD_DSP_SFXREVERB_DENSITY: FMOD_DSP_SFXREVERB = 6;
pub const FMOD_DSP_SFXREVERB_LOWSHELFFREQUENCY: FMOD_DSP_SFXREVERB = 7;
pub const FMOD_DSP_SFXREVERB_LOWSHELFGAIN: FMOD_DSP_SFXREVERB = 8;
pub const FMOD_DSP_SFXREVERB_HIGHCUT: FMOD_DSP_SFXREVERB = 9;
pub const FMOD_DSP_SFXREVERB_EARLYLATEMIX: FMOD_DSP_SFXREVERB = 10;
pub const FMOD_DSP_SFXREVERB_WETLEVEL: FMOD_DSP_SFXREVERB = 11;
pub const FMOD_DSP_SFXREVERB_DRYLEVEL: FMOD_DSP_SFXREVERB = 12;

pub type FMOD_DSP_LOWPASS_SIMPLE = c_int;

pub const FMOD_DSP_LOWPASS_SIMPLE_CUTOFF: FMOD_DSP_LOWPASS_SIMPLE = 0;

pub type FMOD_DSP_DELAY = c_int;

pub const FMOD_DSP_DELAY_CH0: FMOD_DSP_DELAY = 0;
pub const FMOD_DSP_DELAY_CH1: FMOD_DSP_DELAY = 1;
pub const FMOD_DSP_DELAY_CH2: FMOD_DSP_DELAY = 2;
pub const FMOD_DSP_DELAY_CH3: FMOD_DSP_DELAY = 3;
pub const FMOD_DSP_DELAY_CH4: FMOD_DSP_DELAY = 4;
pub const FMOD_DSP_DELAY_CH5: FMOD_DSP_DELAY = 5;
pub const FMOD_DSP_DELAY_CH6: FMOD_DSP_DELAY = 6;
pub const FMOD_DSP_DELAY_CH7: FMOD_DSP_DELAY = 7;
pub const FMOD_DSP_DELAY_CH8: FMOD_DSP_DELAY = 8;
pub const FMOD_DSP_DELAY_CH9: FMOD_DSP_DELAY = 9;
pub const FMOD_DSP_DELAY_CH10: FMOD_DSP_DELAY = 10;
pub const FMOD_DSP_DELAY_CH11: FMOD_DSP_DELAY = 11;
pub const FMOD_DSP_DELAY_CH12: FMOD_DSP_DELAY = 12;
pub const FMOD_DSP_DELAY_CH13: FMOD_DSP_DELAY = 13;
pub const FMOD_DSP_DELAY_CH14: FMOD_DSP_DELAY = 14;
pub const FMOD_DSP_DELAY_CH15: FMOD_DSP_DELAY = 15;
pub const FMOD_DSP_DELAY_MAXDELAY: FMOD_DSP_DELAY = 16;

pub type FMOD_DSP_TREMOLO = c_int;

pub const FMOD_DSP_TREMOLO_FREQUENCY: FMOD_DSP_TREMOLO = 0;
pub const FMOD_DSP_TREMOLO_DEPTH: FMOD_DSP_TREMOLO = 1;
pub const FMOD_DSP_TREMOLO_SHAPE: FMOD_DSP_TREMOLO = 2;
pub const FMOD_DSP_TREMOLO_SKEW: FMOD_DSP_TREMOLO = 3;
pub const FMOD_DSP_TREMOLO_DUTY: FMOD_DSP_TREMOLO = 4;
pub const FMOD_DSP_TREMOLO_SQUARE: FMOD_DSP_TREMOLO = 5;
pub const FMOD_DSP_TREMOLO_PHASE: FMOD_DSP_TREMOLO = 6;
pub const FMOD_DSP_TREMOLO_SPREAD: FMOD_DSP_TREMOLO = 7;

pub type FMOD_DSP_SEND = c_int;

pub const FMOD_DSP_SEND_RETURNID: FMOD_DSP_SEND = 0;
pub const FMOD_DSP_SEND_LEVEL: FMOD_DSP_SEND = 1;

pub type FMOD_DSP_RETURN = c_int;

pub const FMOD_DSP_RETURN_ID: FMOD_DSP_RETURN = 0;
pub const FMOD_DSP_RETURN_INPUT_SPEAKER_MODE: FMOD_DSP_RETURN = 1;

pub type FMOD_DSP_HIGHPASS_SIMPLE = c_int;

pub const FMOD_DSP_HIGHPASS_SIMPLE_CUTOFF: FMOD_DSP_HIGHPASS_SIMPLE = 0;

pub type FMOD_DSP_PAN_2D_STEREO_MODE_TYPE = c_int;

pub const FMOD_DSP_PAN_2D_STEREO_MODE_DISTRIBUTED: FMOD_DSP_PAN_2D_STEREO_MODE_TYPE = 0;
pub const FMOD_DSP_PAN_2D_STEREO_MODE_DISCRETE: FMOD_DSP_PAN_2D_STEREO_MODE_TYPE = 1;

pub type FMOD_DSP_PAN_MODE_TYPE = c_int;

pub const FMOD_DSP_PAN_MODE_MONO: FMOD_DSP_PAN_MODE_TYPE = 0;
pub const FMOD_DSP_PAN_MODE_STEREO: FMOD_DSP_PAN_MODE_TYPE = 1;
pub const FMOD_DSP_PAN_MODE_SURROUND: FMOD_DSP_PAN_MODE_TYPE = 2;

pub type FMOD_DSP_PAN_3D_ROLLOFF_TYPE = c_int;

pub const FMOD_DSP_PAN_3D_ROLLOFF_LINEARSQUARED: FMOD_DSP_PAN_3D_ROLLOFF_TYPE = 0;
pub const FMOD_DSP_PAN_3D_ROLLOFF_LINEAR: FMOD_DSP_PAN_3D_ROLLOFF_TYPE = 1;
pub const FMOD_DSP_PAN_3D_ROLLOFF_INVERSE: FMOD_DSP_PAN_3D_ROLLOFF_TYPE = 2;
pub const FMOD_DSP_PAN_3D_ROLLOFF_INVERSETAPERED: FMOD_DSP_PAN_3D_ROLLOFF_TYPE = 3;
pub const FMOD_DSP_PAN_3D_ROLLOFF_CUSTOM: FMOD_DSP_PAN_3D_ROLLOFF_TYPE = 4;

pub type FMOD_DSP_PAN_3D_EXTENT_MODE_TYPE = c_int;

pub const FMOD_DSP_PAN_3D_EXTENT_MODE_AUTO: FMOD_DSP_PAN_3D_EXTENT_MODE_TYPE = 0;
pub const FMOD_DSP_PAN_3D_EXTENT_MODE_USER: FMOD_DSP_PAN_3D_EXTENT_MODE_TYPE = 1;
pub const FMOD_DSP_PAN_3D_EXTENT_MODE_OFF: FMOD_DSP_PAN_3D_EXTENT_MODE_TYPE = 2;

pub type FMOD_DSP_PAN = c_int;

pub const FMOD_DSP_PAN_MODE: FMOD_DSP_PAN = 0;
pub const FMOD_DSP_PAN_2D_STEREO_POSITION: FMOD_DSP_PAN = 1;
pub const FMOD_DSP_PAN_2D_DIRECTION: FMOD_DSP_PAN = 2;
pub const FMOD_DSP_PAN_2D_EXTENT: FMOD_DSP_PAN = 3;
pub const FMOD_DSP_PAN_2D_ROTATION: FMOD_DSP_PAN = 4;
pub const FMOD_DSP_PAN_2D_LFE_LEVEL: FMOD_DSP_PAN = 5;
pub const FMOD_DSP_PAN_2D_STEREO_MODE: FMOD_DSP_PAN = 6;
pub const FMOD_DSP_PAN_2D_STEREO_SEPARATION: FMOD_DSP_PAN = 7;
pub const FMOD_DSP_PAN_2D_STEREO_AXIS: FMOD_DSP_PAN = 8;
pub const FMOD_DSP_PAN_ENABLED_SPEAKERS: FMOD_DSP_PAN = 9;
pub const FMOD_DSP_PAN_3D_POSITION: FMOD_DSP_PAN = 10;
pub const FMOD_DSP_PAN_3D_ROLLOFF: FMOD_DSP_PAN = 11;
pub const FMOD_DSP_PAN_3D_MIN_DISTANCE: FMOD_DSP_PAN = 12;
pub const FMOD_DSP_PAN_3D_MAX_DISTANCE: FMOD_DSP_PAN = 13;
pub const FMOD_DSP_PAN_3D_EXTENT_MODE: FMOD_DSP_PAN = 14;
pub const FMOD_DSP_PAN_3D_SOUND_SIZE: FMOD_DSP_PAN = 15;
pub const FMOD_DSP_PAN_3D_MIN_EXTENT: FMOD_DSP_PAN = 16;
pub const FMOD_DSP_PAN_3D_PAN_BLEND: FMOD_DSP_PAN = 17;
pub const FMOD_DSP_PAN_LFE_UPMIX_ENABLED: FMOD_DSP_PAN = 18;
pub const FMOD_DSP_PAN_OVERALL_GAIN: FMOD_DSP_PAN = 19;
pub const FMOD_DSP_PAN_SURROUND_SPEAKER_MODE: FMOD_DSP_PAN = 20;
pub const FMOD_DSP_PAN_2D_HEIGHT_BLEND: FMOD_DSP_PAN = 21;
pub const FMOD_DSP_PAN_ATTENUATION_RANGE: FMOD_DSP_PAN = 22;
pub const FMOD_DSP_PAN_OVERRIDE_RANGE: FMOD_DSP_PAN = 23;

pub type FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_TYPE = c_int;

pub const FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_12DB: FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_TYPE = 0;
pub const FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_24DB: FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_TYPE = 1;
pub const FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_48DB: FMOD_DSP_THREE_EQ_CROSSOVERSLOPE_TYPE = 2;

pub type FMOD_DSP_THREE_EQ = c_int;

pub const FMOD_DSP_THREE_EQ_LOWGAIN: FMOD_DSP_THREE_EQ = 0;
pub const FMOD_DSP_THREE_EQ_MIDGAIN: FMOD_DSP_THREE_EQ = 1;
pub const FMOD_DSP_THREE_EQ_HIGHGAIN: FMOD_DSP_THREE_EQ = 2;
pub const FMOD_DSP_THREE_EQ_LOWCROSSOVER: FMOD_DSP_THREE_EQ = 3;
pub const FMOD_DSP_THREE_EQ_HIGHCROSSOVER: FMOD_DSP_THREE_EQ = 4;
pub const FMOD_DSP_THREE_EQ_CROSSOVERSLOPE: FMOD_DSP_THREE_EQ = 5;

pub type FMOD_DSP_FFT_WINDOW = c_int;

pub const FMOD_DSP_FFT_WINDOW_RECT: FMOD_DSP_FFT_WINDOW = 0;
pub const FMOD_DSP_FFT_WINDOW_TRIANGLE: FMOD_DSP_FFT_WINDOW = 1;
pub const FMOD_DSP_FFT_WINDOW_HAMMING: FMOD_DSP_FFT_WINDOW = 2;
pub const FMOD_DSP_FFT_WINDOW_HANNING: FMOD_DSP_FFT_WINDOW = 3;
pub const FMOD_DSP_FFT_WINDOW_BLACKMAN: FMOD_DSP_FFT_WINDOW = 4;
pub const FMOD_DSP_FFT_WINDOW_BLACKMANHARRIS: FMOD_DSP_FFT_WINDOW = 5;

pub type FMOD_DSP_FFT = c_int;

pub const FMOD_DSP_FFT_WINDOWSIZE: FMOD_DSP_FFT = 0;
pub const FMOD_DSP_FFT_WINDOWTYPE: FMOD_DSP_FFT = 1;
pub const FMOD_DSP_FFT_SPECTRUMDATA: FMOD_DSP_FFT = 2;
pub const FMOD_DSP_FFT_DOMINANT_FREQ: FMOD_DSP_FFT = 3;

pub type FMOD_DSP_LOUDNESS_METER = c_int;

pub const FMOD_DSP_LOUDNESS_METER_STATE: FMOD_DSP_LOUDNESS_METER = 0;
pub const FMOD_DSP_LOUDNESS_METER_WEIGHTING: FMOD_DSP_LOUDNESS_METER = 1;
pub const FMOD_DSP_LOUDNESS_METER_INFO: FMOD_DSP_LOUDNESS_METER = 2;

pub type FMOD_DSP_LOUDNESS_METER_STATE_TYPE = c_int;

pub const FMOD_DSP_LOUDNESS_METER_STATE_RESET_INTEGRATED: FMOD_DSP_LOUDNESS_METER_STATE_TYPE = -3;
pub const FMOD_DSP_LOUDNESS_METER_STATE_RESET_MAXPEAK: FMOD_DSP_LOUDNESS_METER_STATE_TYPE = -2;
pub const FMOD_DSP_LOUDNESS_METER_STATE_RESET_ALL: FMOD_DSP_LOUDNESS_METER_STATE_TYPE = -1;
pub const FMOD_DSP_LOUDNESS_METER_STATE_PAUSED: FMOD_DSP_LOUDNESS_METER_STATE_TYPE = 0;
pub const FMOD_DSP_LOUDNESS_METER_STATE_ANALYZING: FMOD_DSP_LOUDNESS_METER_STATE_TYPE = 1;

pub type FMOD_DSP_ENVELOPEFOLLOWER = c_int;

pub const FMOD_DSP_ENVELOPEFOLLOWER_ATTACK: FMOD_DSP_ENVELOPEFOLLOWER = 0;
pub const FMOD_DSP_ENVELOPEFOLLOWER_RELEASE: FMOD_DSP_ENVELOPEFOLLOWER = 1;
pub const FMOD_DSP_ENVELOPEFOLLOWER_ENVELOPE: FMOD_DSP_ENVELOPEFOLLOWER = 2;
pub const FMOD_DSP_ENVELOPEFOLLOWER_USESIDECHAIN: FMOD_DSP_ENVELOPEFOLLOWER = 3;

pub type FMOD_DSP_CONVOLUTION_REVERB = c_int;

pub const FMOD_DSP_CONVOLUTION_REVERB_PARAM_IR: FMOD_DSP_CONVOLUTION_REVERB = 0;
pub const FMOD_DSP_CONVOLUTION_REVERB_PARAM_WET: FMOD_DSP_CONVOLUTION_REVERB = 1;
pub const FMOD_DSP_CONVOLUTION_REVERB_PARAM_DRY: FMOD_DSP_CONVOLUTION_REVERB = 2;
pub const FMOD_DSP_CONVOLUTION_REVERB_PARAM_LINKED: FMOD_DSP_CONVOLUTION_REVERB = 3;

pub type FMOD_DSP_CHANNELMIX_OUTPUT = c_int;

pub const FMOD_DSP_CHANNELMIX_OUTPUT_DEFAULT: FMOD_DSP_CHANNELMIX_OUTPUT = 0;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALLMONO: FMOD_DSP_CHANNELMIX_OUTPUT = 1;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALLSTEREO: FMOD_DSP_CHANNELMIX_OUTPUT = 2;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALLQUAD: FMOD_DSP_CHANNELMIX_OUTPUT = 3;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALL5POINT1: FMOD_DSP_CHANNELMIX_OUTPUT = 4;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALL7POINT1: FMOD_DSP_CHANNELMIX_OUTPUT = 5;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALLLFE: FMOD_DSP_CHANNELMIX_OUTPUT = 6;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_ALL7POINT1POINT4: FMOD_DSP_CHANNELMIX_OUTPUT = 7;

pub type FMOD_DSP_CHANNELMIX = c_int;

pub const FMOD_DSP_CHANNELMIX_OUTPUTGROUPING: FMOD_DSP_CHANNELMIX = 0;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH0: FMOD_DSP_CHANNELMIX = 1;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH1: FMOD_DSP_CHANNELMIX = 2;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH2: FMOD_DSP_CHANNELMIX = 3;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH3: FMOD_DSP_CHANNELMIX = 4;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH4: FMOD_DSP_CHANNELMIX = 5;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH5: FMOD_DSP_CHANNELMIX = 6;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH6: FMOD_DSP_CHANNELMIX = 7;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH7: FMOD_DSP_CHANNELMIX = 8;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH8: FMOD_DSP_CHANNELMIX = 9;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH9: FMOD_DSP_CHANNELMIX = 10;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH10: FMOD_DSP_CHANNELMIX = 11;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH11: FMOD_DSP_CHANNELMIX = 12;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH12: FMOD_DSP_CHANNELMIX = 13;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH13: FMOD_DSP_CHANNELMIX = 14;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH14: FMOD_DSP_CHANNELMIX = 15;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH15: FMOD_DSP_CHANNELMIX = 16;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH16: FMOD_DSP_CHANNELMIX = 17;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH17: FMOD_DSP_CHANNELMIX = 18;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH18: FMOD_DSP_CHANNELMIX = 19;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH19: FMOD_DSP_CHANNELMIX = 20;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH20: FMOD_DSP_CHANNELMIX = 21;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH21: FMOD_DSP_CHANNELMIX = 22;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH22: FMOD_DSP_CHANNELMIX = 23;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH23: FMOD_DSP_CHANNELMIX = 24;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH24: FMOD_DSP_CHANNELMIX = 25;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH25: FMOD_DSP_CHANNELMIX = 26;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH26: FMOD_DSP_CHANNELMIX = 27;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH27: FMOD_DSP_CHANNELMIX = 28;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH28: FMOD_DSP_CHANNELMIX = 29;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH29: FMOD_DSP_CHANNELMIX = 30;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH30: FMOD_DSP_CHANNELMIX = 31;
pub const FMOD_DSP_CHANNELMIX_GAIN_CH31: FMOD_DSP_CHANNELMIX = 32;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH0: FMOD_DSP_CHANNELMIX = 33;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH1: FMOD_DSP_CHANNELMIX = 34;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH2: FMOD_DSP_CHANNELMIX = 35;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH3: FMOD_DSP_CHANNELMIX = 36;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH4: FMOD_DSP_CHANNELMIX = 37;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH5: FMOD_DSP_CHANNELMIX = 38;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH6: FMOD_DSP_CHANNELMIX = 39;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH7: FMOD_DSP_CHANNELMIX = 40;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH8: FMOD_DSP_CHANNELMIX = 41;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH9: FMOD_DSP_CHANNELMIX = 42;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH10: FMOD_DSP_CHANNELMIX = 43;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH11: FMOD_DSP_CHANNELMIX = 44;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH12: FMOD_DSP_CHANNELMIX = 45;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH13: FMOD_DSP_CHANNELMIX = 46;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH14: FMOD_DSP_CHANNELMIX = 47;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH15: FMOD_DSP_CHANNELMIX = 48;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH16: FMOD_DSP_CHANNELMIX = 49;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH17: FMOD_DSP_CHANNELMIX = 50;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH18: FMOD_DSP_CHANNELMIX = 51;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH19: FMOD_DSP_CHANNELMIX = 52;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH20: FMOD_DSP_CHANNELMIX = 53;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH21: FMOD_DSP_CHANNELMIX = 54;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH22: FMOD_DSP_CHANNELMIX = 55;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH23: FMOD_DSP_CHANNELMIX = 56;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH24: FMOD_DSP_CHANNELMIX = 57;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH25: FMOD_DSP_CHANNELMIX = 58;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH26: FMOD_DSP_CHANNELMIX = 59;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH27: FMOD_DSP_CHANNELMIX = 60;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH28: FMOD_DSP_CHANNELMIX = 61;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH29: FMOD_DSP_CHANNELMIX = 62;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH30: FMOD_DSP_CHANNELMIX = 63;
pub const FMOD_DSP_CHANNELMIX_OUTPUT_CH31: FMOD_DSP_CHANNELMIX = 64;

pub type FMOD_DSP_TRANSCEIVER_SPEAKERMODE = c_int;

pub const FMOD_DSP_TRANSCEIVER_SPEAKERMODE_AUTO: FMOD_DSP_TRANSCEIVER_SPEAKERMODE = -1;
pub const FMOD_DSP_TRANSCEIVER_SPEAKERMODE_MONO: FMOD_DSP_TRANSCEIVER_SPEAKERMODE = 0;
pub const FMOD_DSP_TRANSCEIVER_SPEAKERMODE_STEREO: FMOD_DSP_TRANSCEIVER_SPEAKERMODE = 1;
pub const FMOD_DSP_TRANSCEIVER_SPEAKERMODE_SURROUND: FMOD_DSP_TRANSCEIVER_SPEAKERMODE = 2;

pub type FMOD_DSP_TRANSCEIVER = c_int;

pub const FMOD_DSP_TRANSCEIVER_TRANSMIT: FMOD_DSP_TRANSCEIVER = 0;
pub const FMOD_DSP_TRANSCEIVER_GAIN: FMOD_DSP_TRANSCEIVER = 1;
pub const FMOD_DSP_TRANSCEIVER_CHANNEL: FMOD_DSP_TRANSCEIVER = 2;
pub const FMOD_DSP_TRANSCEIVER_TRANSMITSPEAKERMODE: FMOD_DSP_TRANSCEIVER = 3;

pub type FMOD_DSP_OBJECTPAN = c_int;

pub const FMOD_DSP_OBJECTPAN_3D_POSITION: FMOD_DSP_OBJECTPAN = 0;
pub const FMOD_DSP_OBJECTPAN_3D_ROLLOFF: FMOD_DSP_OBJECTPAN = 1;
pub const FMOD_DSP_OBJECTPAN_3D_MIN_DISTANCE: FMOD_DSP_OBJECTPAN = 2;
pub const FMOD_DSP_OBJECTPAN_3D_MAX_DISTANCE: FMOD_DSP_OBJECTPAN = 3;
pub const FMOD_DSP_OBJECTPAN_3D_EXTENT_MODE: FMOD_DSP_OBJECTPAN = 4;
pub const FMOD_DSP_OBJECTPAN_3D_SOUND_SIZE: FMOD_DSP_OBJECTPAN = 5;
pub const FMOD_DSP_OBJECTPAN_3D_MIN_EXTENT: FMOD_DSP_OBJECTPAN = 6;
pub const FMOD_DSP_OBJECTPAN_OVERALL_GAIN: FMOD_DSP_OBJECTPAN = 7;
pub const FMOD_DSP_OBJECTPAN_OUTPUTGAIN: FMOD_DSP_OBJECTPAN = 8;
pub const FMOD_DSP_OBJECTPAN_ATTENUATION_RANGE: FMOD_DSP_OBJECTPAN = 9;
pub const FMOD_DSP_OBJECTPAN_OVERRIDE_RANGE: FMOD_DSP_OBJECTPAN = 10;

pub type FMOD_STUDIO_INITFLAGS = c_uint;

pub const FMOD_STUDIO_INIT_NORMAL: FMOD_STUDIO_INITFLAGS = 0x00000000;
pub const FMOD_STUDIO_INIT_LIVEUPDATE: FMOD_STUDIO_INITFLAGS = 0x00000001;
pub const FMOD_STUDIO_INIT_ALLOW_MISSING_PLUGINS: FMOD_STUDIO_INITFLAGS = 0x00000002;
pub const FMOD_STUDIO_INIT_SYNCHRONOUS_UPDATE: FMOD_STUDIO_INITFLAGS = 0x00000004;
pub const FMOD_STUDIO_INIT_DEFERRED_CALLBACKS: FMOD_STUDIO_INITFLAGS = 0x00000008;
pub const FMOD_STUDIO_INIT_LOAD_FROM_UPDATE: FMOD_STUDIO_INITFLAGS = 0x00000010;
pub const FMOD_STUDIO_INIT_MEMORY_TRACKING: FMOD_STUDIO_INITFLAGS = 0x00000020;

pub type FMOD_STUDIO_PARAMETER_FLAGS = c_uint;

pub const FMOD_STUDIO_PARAMETER_READONLY: FMOD_STUDIO_PARAMETER_FLAGS = 0x00000001;
pub const FMOD_STUDIO_PARAMETER_AUTOMATIC: FMOD_STUDIO_PARAMETER_FLAGS = 0x00000002;
pub const FMOD_STUDIO_PARAMETER_GLOBAL: FMOD_STUDIO_PARAMETER_FLAGS = 0x00000004;
pub const FMOD_STUDIO_PARAMETER_DISCRETE: FMOD_STUDIO_PARAMETER_FLAGS = 0x00000008;
pub const FMOD_STUDIO_PARAMETER_LABELED: FMOD_STUDIO_PARAMETER_FLAGS = 0x00000010;

pub type FMOD_STUDIO_SYSTEM_CALLBACK_TYPE = c_uint;

pub const FMOD_STUDIO_SYSTEM_CALLBACK_PREUPDATE: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE = 0x00000001;
pub const FMOD_STUDIO_SYSTEM_CALLBACK_POSTUPDATE: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE = 0x00000002;
pub const FMOD_STUDIO_SYSTEM_CALLBACK_BANK_UNLOAD: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE = 0x00000004;
pub const FMOD_STUDIO_SYSTEM_CALLBACK_LIVEUPDATE_CONNECTED: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE =
    0x00000008;
pub const FMOD_STUDIO_SYSTEM_CALLBACK_LIVEUPDATE_DISCONNECTED: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE =
    0x00000010;
pub const FMOD_STUDIO_SYSTEM_CALLBACK_ALL: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE = 0xFFFFFFFF;

pub type FMOD_STUDIO_EVENT_CALLBACK_TYPE = c_uint;

pub const FMOD_STUDIO_EVENT_CALLBACK_CREATED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000001;
pub const FMOD_STUDIO_EVENT_CALLBACK_DESTROYED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000002;
pub const FMOD_STUDIO_EVENT_CALLBACK_STARTING: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000004;
pub const FMOD_STUDIO_EVENT_CALLBACK_STARTED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000008;
pub const FMOD_STUDIO_EVENT_CALLBACK_RESTARTED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000010;
pub const FMOD_STUDIO_EVENT_CALLBACK_STOPPED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000020;
pub const FMOD_STUDIO_EVENT_CALLBACK_START_FAILED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000040;
pub const FMOD_STUDIO_EVENT_CALLBACK_CREATE_PROGRAMMER_SOUND: FMOD_STUDIO_EVENT_CALLBACK_TYPE =
    0x00000080;
pub const FMOD_STUDIO_EVENT_CALLBACK_DESTROY_PROGRAMMER_SOUND: FMOD_STUDIO_EVENT_CALLBACK_TYPE =
    0x00000100;
pub const FMOD_STUDIO_EVENT_CALLBACK_PLUGIN_CREATED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000200;
pub const FMOD_STUDIO_EVENT_CALLBACK_PLUGIN_DESTROYED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000400;
pub const FMOD_STUDIO_EVENT_CALLBACK_TIMELINE_MARKER: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00000800;
pub const FMOD_STUDIO_EVENT_CALLBACK_TIMELINE_BEAT: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00001000;
pub const FMOD_STUDIO_EVENT_CALLBACK_SOUND_PLAYED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00002000;
pub const FMOD_STUDIO_EVENT_CALLBACK_SOUND_STOPPED: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00004000;
pub const FMOD_STUDIO_EVENT_CALLBACK_REAL_TO_VIRTUAL: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00008000;
pub const FMOD_STUDIO_EVENT_CALLBACK_VIRTUAL_TO_REAL: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0x00010000;
pub const FMOD_STUDIO_EVENT_CALLBACK_START_EVENT_COMMAND: FMOD_STUDIO_EVENT_CALLBACK_TYPE =
    0x00020000;
pub const FMOD_STUDIO_EVENT_CALLBACK_NESTED_TIMELINE_BEAT: FMOD_STUDIO_EVENT_CALLBACK_TYPE =
    0x00040000;
pub const FMOD_STUDIO_EVENT_CALLBACK_ALL: FMOD_STUDIO_EVENT_CALLBACK_TYPE = 0xFFFFFFFF;

pub type FMOD_STUDIO_LOAD_BANK_FLAGS = c_uint;

pub const FMOD_STUDIO_LOAD_BANK_NORMAL: FMOD_STUDIO_LOAD_BANK_FLAGS = 0x00000000;
pub const FMOD_STUDIO_LOAD_BANK_NONBLOCKING: FMOD_STUDIO_LOAD_BANK_FLAGS = 0x00000001;
pub const FMOD_STUDIO_LOAD_BANK_DECOMPRESS_SAMPLES: FMOD_STUDIO_LOAD_BANK_FLAGS = 0x00000002;
pub const FMOD_STUDIO_LOAD_BANK_UNENCRYPTED: FMOD_STUDIO_LOAD_BANK_FLAGS = 0x00000004;

pub type FMOD_STUDIO_COMMANDCAPTURE_FLAGS = c_uint;

pub const FMOD_STUDIO_COMMANDCAPTURE_NORMAL: FMOD_STUDIO_COMMANDCAPTURE_FLAGS = 0x00000000;
pub const FMOD_STUDIO_COMMANDCAPTURE_FILEFLUSH: FMOD_STUDIO_COMMANDCAPTURE_FLAGS = 0x00000001;
pub const FMOD_STUDIO_COMMANDCAPTURE_SKIP_INITIAL_STATE: FMOD_STUDIO_COMMANDCAPTURE_FLAGS =
    0x00000002;

pub type FMOD_STUDIO_COMMANDREPLAY_FLAGS = c_uint;

pub const FMOD_STUDIO_COMMANDREPLAY_NORMAL: FMOD_STUDIO_COMMANDREPLAY_FLAGS = 0x00000000;
pub const FMOD_STUDIO_COMMANDREPLAY_SKIP_CLEANUP: FMOD_STUDIO_COMMANDREPLAY_FLAGS = 0x00000001;
pub const FMOD_STUDIO_COMMANDREPLAY_FAST_FORWARD: FMOD_STUDIO_COMMANDREPLAY_FLAGS = 0x00000002;
pub const FMOD_STUDIO_COMMANDREPLAY_SKIP_BANK_LOAD: FMOD_STUDIO_COMMANDREPLAY_FLAGS = 0x00000004;

pub type FMOD_DEBUG_FLAGS = c_uint;

pub const FMOD_DEBUG_LEVEL_NONE: FMOD_DEBUG_FLAGS = 0x00000000;
pub const FMOD_DEBUG_LEVEL_ERROR: FMOD_DEBUG_FLAGS = 0x00000001;
pub const FMOD_DEBUG_LEVEL_WARNING: FMOD_DEBUG_FLAGS = 0x00000002;
pub const FMOD_DEBUG_LEVEL_LOG: FMOD_DEBUG_FLAGS = 0x00000004;
pub const FMOD_DEBUG_TYPE_MEMORY: FMOD_DEBUG_FLAGS = 0x00000100;
pub const FMOD_DEBUG_TYPE_FILE: FMOD_DEBUG_FLAGS = 0x00000200;
pub const FMOD_DEBUG_TYPE_CODEC: FMOD_DEBUG_FLAGS = 0x00000400;
pub const FMOD_DEBUG_TYPE_TRACE: FMOD_DEBUG_FLAGS = 0x00000800;
pub const FMOD_DEBUG_DISPLAY_TIMESTAMPS: FMOD_DEBUG_FLAGS = 0x00010000;
pub const FMOD_DEBUG_DISPLAY_LINENUMBERS: FMOD_DEBUG_FLAGS = 0x00020000;
pub const FMOD_DEBUG_DISPLAY_THREAD: FMOD_DEBUG_FLAGS = 0x00040000;

pub type FMOD_MEMORY_TYPE = c_uint;

pub const FMOD_MEMORY_NORMAL: FMOD_MEMORY_TYPE = 0x00000000;
pub const FMOD_MEMORY_STREAM_FILE: FMOD_MEMORY_TYPE = 0x00000001;
pub const FMOD_MEMORY_STREAM_DECODE: FMOD_MEMORY_TYPE = 0x00000002;
pub const FMOD_MEMORY_SAMPLEDATA: FMOD_MEMORY_TYPE = 0x00000004;
pub const FMOD_MEMORY_DSP_BUFFER: FMOD_MEMORY_TYPE = 0x00000008;
pub const FMOD_MEMORY_PLUGIN: FMOD_MEMORY_TYPE = 0x00000010;
pub const FMOD_MEMORY_PERSISTENT: FMOD_MEMORY_TYPE = 0x00200000;
pub const FMOD_MEMORY_ALL: FMOD_MEMORY_TYPE = 0xFFFFFFFF;

pub type FMOD_INITFLAGS = c_uint;

pub const FMOD_INIT_NORMAL: FMOD_INITFLAGS = 0x00000000;
pub const FMOD_INIT_STREAM_FROM_UPDATE: FMOD_INITFLAGS = 0x00000001;
pub const FMOD_INIT_MIX_FROM_UPDATE: FMOD_INITFLAGS = 0x00000002;
pub const FMOD_INIT_3D_RIGHTHANDED: FMOD_INITFLAGS = 0x00000004;
pub const FMOD_INIT_CHANNEL_LOWPASS: FMOD_INITFLAGS = 0x00000100;
pub const FMOD_INIT_CHANNEL_DISTANCEFILTER: FMOD_INITFLAGS = 0x00000200;
pub const FMOD_INIT_PROFILE_ENABLE: FMOD_INITFLAGS = 0x00010000;
pub const FMOD_INIT_VOL0_BECOMES_VIRTUAL: FMOD_INITFLAGS = 0x00020000;
pub const FMOD_INIT_GEOMETRY_USECLOSEST: FMOD_INITFLAGS = 0x00040000;
pub const FMOD_INIT_PREFER_DOLBY_DOWNMIX: FMOD_INITFLAGS = 0x00080000;
pub const FMOD_INIT_THREAD_UNSAFE: FMOD_INITFLAGS = 0x00100000;
pub const FMOD_INIT_PROFILE_METER_ALL: FMOD_INITFLAGS = 0x00200000;
pub const FMOD_INIT_MEMORY_TRACKING: FMOD_INITFLAGS = 0x00400000;

pub type FMOD_DRIVER_STATE = c_uint;

pub const FMOD_DRIVER_STATE_CONNECTED: FMOD_DRIVER_STATE = 0x00000001;
pub const FMOD_DRIVER_STATE_DEFAULT: FMOD_DRIVER_STATE = 0x00000002;

pub type FMOD_TIMEUNIT = c_uint;

pub const FMOD_TIMEUNIT_MS: FMOD_TIMEUNIT = 0x00000001;
pub const FMOD_TIMEUNIT_PCM: FMOD_TIMEUNIT = 0x00000002;
pub const FMOD_TIMEUNIT_PCMBYTES: FMOD_TIMEUNIT = 0x00000004;
pub const FMOD_TIMEUNIT_RAWBYTES: FMOD_TIMEUNIT = 0x00000008;
pub const FMOD_TIMEUNIT_PCMFRACTION: FMOD_TIMEUNIT = 0x00000010;
pub const FMOD_TIMEUNIT_MODORDER: FMOD_TIMEUNIT = 0x00000100;
pub const FMOD_TIMEUNIT_MODROW: FMOD_TIMEUNIT = 0x00000200;
pub const FMOD_TIMEUNIT_MODPATTERN: FMOD_TIMEUNIT = 0x00000400;

pub type FMOD_SYSTEM_CALLBACK_TYPE = c_uint;

pub const FMOD_SYSTEM_CALLBACK_DEVICELISTCHANGED: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000001;
pub const FMOD_SYSTEM_CALLBACK_DEVICELOST: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000002;
pub const FMOD_SYSTEM_CALLBACK_MEMORYALLOCATIONFAILED: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000004;
pub const FMOD_SYSTEM_CALLBACK_THREADCREATED: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000008;
pub const FMOD_SYSTEM_CALLBACK_BADDSPCONNECTION: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000010;
pub const FMOD_SYSTEM_CALLBACK_PREMIX: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000020;
pub const FMOD_SYSTEM_CALLBACK_POSTMIX: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000040;
pub const FMOD_SYSTEM_CALLBACK_ERROR: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000080;
pub const FMOD_SYSTEM_CALLBACK_MIDMIX: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000100;
pub const FMOD_SYSTEM_CALLBACK_THREADDESTROYED: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000200;
pub const FMOD_SYSTEM_CALLBACK_PREUPDATE: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000400;
pub const FMOD_SYSTEM_CALLBACK_POSTUPDATE: FMOD_SYSTEM_CALLBACK_TYPE = 0x00000800;
pub const FMOD_SYSTEM_CALLBACK_RECORDLISTCHANGED: FMOD_SYSTEM_CALLBACK_TYPE = 0x00001000;
pub const FMOD_SYSTEM_CALLBACK_BUFFEREDNOMIX: FMOD_SYSTEM_CALLBACK_TYPE = 0x00002000;
pub const FMOD_SYSTEM_CALLBACK_DEVICEREINITIALIZE: FMOD_SYSTEM_CALLBACK_TYPE = 0x00004000;
pub const FMOD_SYSTEM_CALLBACK_OUTPUTUNDERRUN: FMOD_SYSTEM_CALLBACK_TYPE = 0x00008000;
pub const FMOD_SYSTEM_CALLBACK_ALL: FMOD_SYSTEM_CALLBACK_TYPE = 0xFFFFFFFF;

pub type FMOD_MODE = c_uint;

pub const FMOD_DEFAULT: FMOD_MODE = 0x00000000;
pub const FMOD_LOOP_OFF: FMOD_MODE = 0x00000001;
pub const FMOD_LOOP_NORMAL: FMOD_MODE = 0x00000002;
pub const FMOD_LOOP_BIDI: FMOD_MODE = 0x00000004;
pub const FMOD_2D: FMOD_MODE = 0x00000008;
pub const FMOD_3D: FMOD_MODE = 0x00000010;
pub const FMOD_CREATESTREAM: FMOD_MODE = 0x00000080;
pub const FMOD_CREATESAMPLE: FMOD_MODE = 0x00000100;
pub const FMOD_CREATECOMPRESSEDSAMPLE: FMOD_MODE = 0x00000200;
pub const FMOD_OPENUSER: FMOD_MODE = 0x00000400;
pub const FMOD_OPENMEMORY: FMOD_MODE = 0x00000800;
pub const FMOD_OPENMEMORY_POINT: FMOD_MODE = 0x10000000;
pub const FMOD_OPENRAW: FMOD_MODE = 0x00001000;
pub const FMOD_OPENONLY: FMOD_MODE = 0x00002000;
pub const FMOD_ACCURATETIME: FMOD_MODE = 0x00004000;
pub const FMOD_MPEGSEARCH: FMOD_MODE = 0x00008000;
pub const FMOD_NONBLOCKING: FMOD_MODE = 0x00010000;
pub const FMOD_UNIQUE: FMOD_MODE = 0x00020000;
pub const FMOD_3D_HEADRELATIVE: FMOD_MODE = 0x00040000;
pub const FMOD_3D_WORLDRELATIVE: FMOD_MODE = 0x00080000;
pub const FMOD_3D_INVERSEROLLOFF: FMOD_MODE = 0x00100000;
pub const FMOD_3D_LINEARROLLOFF: FMOD_MODE = 0x00200000;
pub const FMOD_3D_LINEARSQUAREROLLOFF: FMOD_MODE = 0x00400000;
pub const FMOD_3D_INVERSETAPEREDROLLOFF: FMOD_MODE = 0x00800000;
pub const FMOD_3D_CUSTOMROLLOFF: FMOD_MODE = 0x04000000;
pub const FMOD_3D_IGNOREGEOMETRY: FMOD_MODE = 0x40000000;
pub const FMOD_IGNORETAGS: FMOD_MODE = 0x02000000;
pub const FMOD_LOWMEM: FMOD_MODE = 0x08000000;
pub const FMOD_VIRTUAL_PLAYFROMSTART: FMOD_MODE = 0x80000000;

pub type FMOD_CHANNELMASK = c_uint;

pub const FMOD_CHANNELMASK_FRONT_LEFT: FMOD_CHANNELMASK = 0x00000001;
pub const FMOD_CHANNELMASK_FRONT_RIGHT: FMOD_CHANNELMASK = 0x00000002;
pub const FMOD_CHANNELMASK_FRONT_CENTER: FMOD_CHANNELMASK = 0x00000004;
pub const FMOD_CHANNELMASK_LOW_FREQUENCY: FMOD_CHANNELMASK = 0x00000008;
pub const FMOD_CHANNELMASK_SURROUND_LEFT: FMOD_CHANNELMASK = 0x00000010;
pub const FMOD_CHANNELMASK_SURROUND_RIGHT: FMOD_CHANNELMASK = 0x00000020;
pub const FMOD_CHANNELMASK_BACK_LEFT: FMOD_CHANNELMASK = 0x00000040;
pub const FMOD_CHANNELMASK_BACK_RIGHT: FMOD_CHANNELMASK = 0x00000080;
pub const FMOD_CHANNELMASK_BACK_CENTER: FMOD_CHANNELMASK = 0x00000100;
pub const FMOD_CHANNELMASK_MONO: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT);
pub const FMOD_CHANNELMASK_STEREO: FMOD_CHANNELMASK =
    (FMOD_CHANNELMASK_FRONT_LEFT | FMOD_CHANNELMASK_FRONT_RIGHT);
pub const FMOD_CHANNELMASK_LRC: FMOD_CHANNELMASK =
    (FMOD_CHANNELMASK_FRONT_LEFT | FMOD_CHANNELMASK_FRONT_RIGHT | FMOD_CHANNELMASK_FRONT_CENTER);
pub const FMOD_CHANNELMASK_QUAD: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_SURROUND_LEFT
    | FMOD_CHANNELMASK_SURROUND_RIGHT);
pub const FMOD_CHANNELMASK_SURROUND: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_FRONT_CENTER
    | FMOD_CHANNELMASK_SURROUND_LEFT
    | FMOD_CHANNELMASK_SURROUND_RIGHT);
pub const FMOD_CHANNELMASK_5POINT1: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_FRONT_CENTER
    | FMOD_CHANNELMASK_LOW_FREQUENCY
    | FMOD_CHANNELMASK_SURROUND_LEFT
    | FMOD_CHANNELMASK_SURROUND_RIGHT);
pub const FMOD_CHANNELMASK_5POINT1_REARS: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_FRONT_CENTER
    | FMOD_CHANNELMASK_LOW_FREQUENCY
    | FMOD_CHANNELMASK_BACK_LEFT
    | FMOD_CHANNELMASK_BACK_RIGHT);
pub const FMOD_CHANNELMASK_7POINT0: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_FRONT_CENTER
    | FMOD_CHANNELMASK_SURROUND_LEFT
    | FMOD_CHANNELMASK_SURROUND_RIGHT
    | FMOD_CHANNELMASK_BACK_LEFT
    | FMOD_CHANNELMASK_BACK_RIGHT);
pub const FMOD_CHANNELMASK_7POINT1: FMOD_CHANNELMASK = (FMOD_CHANNELMASK_FRONT_LEFT
    | FMOD_CHANNELMASK_FRONT_RIGHT
    | FMOD_CHANNELMASK_FRONT_CENTER
    | FMOD_CHANNELMASK_LOW_FREQUENCY
    | FMOD_CHANNELMASK_SURROUND_LEFT
    | FMOD_CHANNELMASK_SURROUND_RIGHT
    | FMOD_CHANNELMASK_BACK_LEFT
    | FMOD_CHANNELMASK_BACK_RIGHT);

pub type FMOD_THREAD_PRIORITY = c_int;

pub const FMOD_THREAD_PRIORITY_PLATFORM_MIN: FMOD_THREAD_PRIORITY = (-32 * 1024);
pub const FMOD_THREAD_PRIORITY_PLATFORM_MAX: FMOD_THREAD_PRIORITY = (32 * 1024);
pub const FMOD_THREAD_PRIORITY_DEFAULT: FMOD_THREAD_PRIORITY =
    (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 1);
pub const FMOD_THREAD_PRIORITY_LOW: FMOD_THREAD_PRIORITY = (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 2);
pub const FMOD_THREAD_PRIORITY_MEDIUM: FMOD_THREAD_PRIORITY =
    (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 3);
pub const FMOD_THREAD_PRIORITY_HIGH: FMOD_THREAD_PRIORITY = (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 4);
pub const FMOD_THREAD_PRIORITY_VERY_HIGH: FMOD_THREAD_PRIORITY =
    (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 5);
pub const FMOD_THREAD_PRIORITY_EXTREME: FMOD_THREAD_PRIORITY =
    (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 6);
pub const FMOD_THREAD_PRIORITY_CRITICAL: FMOD_THREAD_PRIORITY =
    (FMOD_THREAD_PRIORITY_PLATFORM_MIN - 7);
pub const FMOD_THREAD_PRIORITY_MIXER: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_EXTREME;
pub const FMOD_THREAD_PRIORITY_FEEDER: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_CRITICAL;
pub const FMOD_THREAD_PRIORITY_STREAM: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_VERY_HIGH;
pub const FMOD_THREAD_PRIORITY_FILE: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_HIGH;
pub const FMOD_THREAD_PRIORITY_NONBLOCKING: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_HIGH;
pub const FMOD_THREAD_PRIORITY_RECORD: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_HIGH;
pub const FMOD_THREAD_PRIORITY_GEOMETRY: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_LOW;
pub const FMOD_THREAD_PRIORITY_PROFILER: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_MEDIUM;
pub const FMOD_THREAD_PRIORITY_STUDIO_UPDATE: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_MEDIUM;
pub const FMOD_THREAD_PRIORITY_STUDIO_LOAD_BANK: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_MEDIUM;
pub const FMOD_THREAD_PRIORITY_STUDIO_LOAD_SAMPLE: FMOD_THREAD_PRIORITY =
    FMOD_THREAD_PRIORITY_MEDIUM;
pub const FMOD_THREAD_PRIORITY_CONVOLUTION1: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_VERY_HIGH;
pub const FMOD_THREAD_PRIORITY_CONVOLUTION2: FMOD_THREAD_PRIORITY = FMOD_THREAD_PRIORITY_VERY_HIGH;

pub type FMOD_THREAD_STACK_SIZE = c_uint;

pub const FMOD_THREAD_STACK_SIZE_MIXER: FMOD_THREAD_STACK_SIZE = (80 * 1024);
pub const FMOD_THREAD_STACK_SIZE_FEEDER: FMOD_THREAD_STACK_SIZE = (16 * 1024);
pub const FMOD_THREAD_STACK_SIZE_STREAM: FMOD_THREAD_STACK_SIZE = (96 * 1024);
pub const FMOD_THREAD_STACK_SIZE_FILE: FMOD_THREAD_STACK_SIZE = (64 * 1024);
pub const FMOD_THREAD_STACK_SIZE_NONBLOCKING: FMOD_THREAD_STACK_SIZE = (112 * 1024);
pub const FMOD_THREAD_STACK_SIZE_RECORD: FMOD_THREAD_STACK_SIZE = (16 * 1024);
pub const FMOD_THREAD_STACK_SIZE_GEOMETRY: FMOD_THREAD_STACK_SIZE = (48 * 1024);
pub const FMOD_THREAD_STACK_SIZE_PROFILER: FMOD_THREAD_STACK_SIZE = (128 * 1024);
pub const FMOD_THREAD_STACK_SIZE_STUDIO_UPDATE: FMOD_THREAD_STACK_SIZE = (96 * 1024);
pub const FMOD_THREAD_STACK_SIZE_STUDIO_LOAD_BANK: FMOD_THREAD_STACK_SIZE = (96 * 1024);
pub const FMOD_THREAD_STACK_SIZE_STUDIO_LOAD_SAMPLE: FMOD_THREAD_STACK_SIZE = (96 * 1024);
pub const FMOD_THREAD_STACK_SIZE_CONVOLUTION1: FMOD_THREAD_STACK_SIZE = (16 * 1024);
pub const FMOD_THREAD_STACK_SIZE_CONVOLUTION2: FMOD_THREAD_STACK_SIZE = (16 * 1024);

pub type FMOD_THREAD_AFFINITY = c_longlong;

pub const FMOD_THREAD_AFFINITY_GROUP_DEFAULT: FMOD_THREAD_AFFINITY = 0x4000000000000000;
pub const FMOD_THREAD_AFFINITY_GROUP_A: FMOD_THREAD_AFFINITY = 0x4000000000000001;
pub const FMOD_THREAD_AFFINITY_GROUP_B: FMOD_THREAD_AFFINITY = 0x4000000000000002;
pub const FMOD_THREAD_AFFINITY_GROUP_C: FMOD_THREAD_AFFINITY = 0x4000000000000003;
pub const FMOD_THREAD_AFFINITY_MIXER: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_A;
pub const FMOD_THREAD_AFFINITY_FEEDER: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_STREAM: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_FILE: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_NONBLOCKING: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_RECORD: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_GEOMETRY: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_PROFILER: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_STUDIO_UPDATE: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_B;
pub const FMOD_THREAD_AFFINITY_STUDIO_LOAD_BANK: FMOD_THREAD_AFFINITY =
    FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_STUDIO_LOAD_SAMPLE: FMOD_THREAD_AFFINITY =
    FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_CONVOLUTION1: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_CONVOLUTION2: FMOD_THREAD_AFFINITY = FMOD_THREAD_AFFINITY_GROUP_C;
pub const FMOD_THREAD_AFFINITY_CORE_ALL: FMOD_THREAD_AFFINITY = 0;
pub const FMOD_THREAD_AFFINITY_CORE_0: FMOD_THREAD_AFFINITY = (1 << 0);
pub const FMOD_THREAD_AFFINITY_CORE_1: FMOD_THREAD_AFFINITY = (1 << 1);
pub const FMOD_THREAD_AFFINITY_CORE_2: FMOD_THREAD_AFFINITY = (1 << 2);
pub const FMOD_THREAD_AFFINITY_CORE_3: FMOD_THREAD_AFFINITY = (1 << 3);
pub const FMOD_THREAD_AFFINITY_CORE_4: FMOD_THREAD_AFFINITY = (1 << 4);
pub const FMOD_THREAD_AFFINITY_CORE_5: FMOD_THREAD_AFFINITY = (1 << 5);
pub const FMOD_THREAD_AFFINITY_CORE_6: FMOD_THREAD_AFFINITY = (1 << 6);
pub const FMOD_THREAD_AFFINITY_CORE_7: FMOD_THREAD_AFFINITY = (1 << 7);
pub const FMOD_THREAD_AFFINITY_CORE_8: FMOD_THREAD_AFFINITY = (1 << 8);
pub const FMOD_THREAD_AFFINITY_CORE_9: FMOD_THREAD_AFFINITY = (1 << 9);
pub const FMOD_THREAD_AFFINITY_CORE_10: FMOD_THREAD_AFFINITY = (1 << 10);
pub const FMOD_THREAD_AFFINITY_CORE_11: FMOD_THREAD_AFFINITY = (1 << 11);
pub const FMOD_THREAD_AFFINITY_CORE_12: FMOD_THREAD_AFFINITY = (1 << 12);
pub const FMOD_THREAD_AFFINITY_CORE_13: FMOD_THREAD_AFFINITY = (1 << 13);
pub const FMOD_THREAD_AFFINITY_CORE_14: FMOD_THREAD_AFFINITY = (1 << 14);
pub const FMOD_THREAD_AFFINITY_CORE_15: FMOD_THREAD_AFFINITY = (1 << 15);

pub type FMOD_CODEC_SEEK_METHOD = c_int;

pub const FMOD_CODEC_SEEK_METHOD_SET: FMOD_CODEC_SEEK_METHOD = 0;
pub const FMOD_CODEC_SEEK_METHOD_CURRENT: FMOD_CODEC_SEEK_METHOD = 1;
pub const FMOD_CODEC_SEEK_METHOD_END: FMOD_CODEC_SEEK_METHOD = 2;

pub type FMOD_OUTPUT_METHOD = c_uint;

pub const FMOD_OUTPUT_METHOD_MIX_DIRECT: FMOD_OUTPUT_METHOD = 0;
pub const FMOD_OUTPUT_METHOD_MIX_BUFFERED: FMOD_OUTPUT_METHOD = 1;

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_BANK_INFO {
    pub size: c_int,
    pub userdata: *mut c_void,
    pub userdatalength: c_int,
    pub opencallback: FMOD_FILE_OPEN_CALLBACK,
    pub closecallback: FMOD_FILE_CLOSE_CALLBACK,
    pub readcallback: FMOD_FILE_READ_CALLBACK,
    pub seekcallback: FMOD_FILE_SEEK_CALLBACK,
}

impl Default for FMOD_STUDIO_BANK_INFO {
    fn default() -> Self {
        Self {
            size: Default::default(),
            userdata: null_mut(),
            userdatalength: Default::default(),
            opencallback: Default::default(),
            closecallback: Default::default(),
            readcallback: Default::default(),
            seekcallback: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_PARAMETER_ID {
    pub data1: c_uint,
    pub data2: c_uint,
}

impl Default for FMOD_STUDIO_PARAMETER_ID {
    fn default() -> Self {
        Self {
            data1: Default::default(),
            data2: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_PARAMETER_DESCRIPTION {
    pub name: *const c_char,
    pub id: FMOD_STUDIO_PARAMETER_ID,
    pub minimum: c_float,
    pub maximum: c_float,
    pub defaultvalue: c_float,
    pub type_: FMOD_STUDIO_PARAMETER_TYPE,
    pub flags: FMOD_STUDIO_PARAMETER_FLAGS,
    pub guid: FMOD_GUID,
}

impl Default for FMOD_STUDIO_PARAMETER_DESCRIPTION {
    fn default() -> Self {
        Self {
            name: null_mut(),
            id: Default::default(),
            minimum: Default::default(),
            maximum: Default::default(),
            defaultvalue: Default::default(),
            type_: Default::default(),
            flags: Default::default(),
            guid: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FMOD_STUDIO_USER_PROPERTY {
    pub name: *const c_char,
    pub type_: FMOD_STUDIO_USER_PROPERTY_TYPE,
    pub __union: FMOD_STUDIO_USER_PROPERTY__union,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union FMOD_STUDIO_USER_PROPERTY__union {
    pub intvalue: c_int,
    pub boolvalue: FMOD_BOOL,
    pub floatvalue: c_float,
    pub stringvalue: *const c_char,
}

impl Default for FMOD_STUDIO_USER_PROPERTY {
    fn default() -> Self {
        unimplemented!()
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_PROGRAMMER_SOUND_PROPERTIES {
    pub name: *const c_char,
    pub sound: *mut FMOD_SOUND,
    pub subsoundIndex: c_int,
}

impl Default for FMOD_STUDIO_PROGRAMMER_SOUND_PROPERTIES {
    fn default() -> Self {
        Self {
            name: null_mut(),
            sound: null_mut(),
            subsoundIndex: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_PLUGIN_INSTANCE_PROPERTIES {
    pub name: *const c_char,
    pub dsp: *mut FMOD_DSP,
}

impl Default for FMOD_STUDIO_PLUGIN_INSTANCE_PROPERTIES {
    fn default() -> Self {
        Self {
            name: null_mut(),
            dsp: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_TIMELINE_MARKER_PROPERTIES {
    pub name: *const c_char,
    pub position: c_int,
}

impl Default for FMOD_STUDIO_TIMELINE_MARKER_PROPERTIES {
    fn default() -> Self {
        Self {
            name: null_mut(),
            position: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_TIMELINE_BEAT_PROPERTIES {
    pub bar: c_int,
    pub beat: c_int,
    pub position: c_int,
    pub tempo: c_float,
    pub timesignatureupper: c_int,
    pub timesignaturelower: c_int,
}

impl Default for FMOD_STUDIO_TIMELINE_BEAT_PROPERTIES {
    fn default() -> Self {
        Self {
            bar: Default::default(),
            beat: Default::default(),
            position: Default::default(),
            tempo: Default::default(),
            timesignatureupper: Default::default(),
            timesignaturelower: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_TIMELINE_NESTED_BEAT_PROPERTIES {
    pub eventid: FMOD_GUID,
    pub properties: FMOD_STUDIO_TIMELINE_BEAT_PROPERTIES,
}

impl Default for FMOD_STUDIO_TIMELINE_NESTED_BEAT_PROPERTIES {
    fn default() -> Self {
        Self {
            eventid: Default::default(),
            properties: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_ADVANCEDSETTINGS {
    pub cbsize: c_int,
    pub commandqueuesize: c_uint,
    pub handleinitialsize: c_uint,
    pub studioupdateperiod: c_int,
    pub idlesampledatapoolsize: c_int,
    pub streamingscheduledelay: c_uint,
    pub encryptionkey: *const c_char,
}

impl Default for FMOD_STUDIO_ADVANCEDSETTINGS {
    fn default() -> Self {
        Self {
            cbsize: Default::default(),
            commandqueuesize: Default::default(),
            handleinitialsize: Default::default(),
            studioupdateperiod: Default::default(),
            idlesampledatapoolsize: Default::default(),
            streamingscheduledelay: Default::default(),
            encryptionkey: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_CPU_USAGE {
    pub update: c_float,
}

impl Default for FMOD_STUDIO_CPU_USAGE {
    fn default() -> Self {
        Self {
            update: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_BUFFER_INFO {
    pub currentusage: c_int,
    pub peakusage: c_int,
    pub capacity: c_int,
    pub stallcount: c_int,
    pub stalltime: c_float,
}

impl Default for FMOD_STUDIO_BUFFER_INFO {
    fn default() -> Self {
        Self {
            currentusage: Default::default(),
            peakusage: Default::default(),
            capacity: Default::default(),
            stallcount: Default::default(),
            stalltime: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_BUFFER_USAGE {
    pub studiocommandqueue: FMOD_STUDIO_BUFFER_INFO,
    pub studiohandle: FMOD_STUDIO_BUFFER_INFO,
}

impl Default for FMOD_STUDIO_BUFFER_USAGE {
    fn default() -> Self {
        Self {
            studiocommandqueue: Default::default(),
            studiohandle: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_SOUND_INFO {
    pub name_or_data: *const c_char,
    pub mode: FMOD_MODE,
    pub exinfo: FMOD_CREATESOUNDEXINFO,
    pub subsoundindex: c_int,
}

impl Default for FMOD_STUDIO_SOUND_INFO {
    fn default() -> Self {
        Self {
            name_or_data: null_mut(),
            mode: Default::default(),
            exinfo: Default::default(),
            subsoundindex: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_COMMAND_INFO {
    pub commandname: *const c_char,
    pub parentcommandindex: c_int,
    pub framenumber: c_int,
    pub frametime: c_float,
    pub instancetype: FMOD_STUDIO_INSTANCETYPE,
    pub outputtype: FMOD_STUDIO_INSTANCETYPE,
    pub instancehandle: c_uint,
    pub outputhandle: c_uint,
}

impl Default for FMOD_STUDIO_COMMAND_INFO {
    fn default() -> Self {
        Self {
            commandname: null_mut(),
            parentcommandindex: Default::default(),
            framenumber: Default::default(),
            frametime: Default::default(),
            instancetype: Default::default(),
            outputtype: Default::default(),
            instancehandle: Default::default(),
            outputhandle: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_STUDIO_MEMORY_USAGE {
    pub exclusive: c_int,
    pub inclusive: c_int,
    pub sampledata: c_int,
}

impl Default for FMOD_STUDIO_MEMORY_USAGE {
    fn default() -> Self {
        Self {
            exclusive: Default::default(),
            inclusive: Default::default(),
            sampledata: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_ASYNCREADINFO {
    pub handle: *mut c_void,
    pub offset: c_uint,
    pub sizebytes: c_uint,
    pub priority: c_int,
    pub userdata: *mut c_void,
    pub buffer: *mut c_void,
    pub bytesread: c_uint,
    pub done: FMOD_FILE_ASYNCDONE_FUNC,
}

impl Default for FMOD_ASYNCREADINFO {
    fn default() -> Self {
        Self {
            handle: null_mut(),
            offset: Default::default(),
            sizebytes: Default::default(),
            priority: Default::default(),
            userdata: null_mut(),
            buffer: null_mut(),
            bytesread: Default::default(),
            done: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_VECTOR {
    pub x: c_float,
    pub y: c_float,
    pub z: c_float,
}

impl Default for FMOD_VECTOR {
    fn default() -> Self {
        Self {
            x: Default::default(),
            y: Default::default(),
            z: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_3D_ATTRIBUTES {
    pub position: FMOD_VECTOR,
    pub velocity: FMOD_VECTOR,
    pub forward: FMOD_VECTOR,
    pub up: FMOD_VECTOR,
}

impl Default for FMOD_3D_ATTRIBUTES {
    fn default() -> Self {
        Self {
            position: Default::default(),
            velocity: Default::default(),
            forward: Default::default(),
            up: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_GUID {
    pub Data1: c_uint,
    pub Data2: c_ushort,
    pub Data3: c_ushort,
    pub Data4: [c_uchar; 8 as usize],
}

impl Default for FMOD_GUID {
    fn default() -> Self {
        Self {
            Data1: Default::default(),
            Data2: Default::default(),
            Data3: Default::default(),
            Data4: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_PLUGINLIST {
    pub type_: FMOD_PLUGINTYPE,
    pub description: *mut c_void,
}

impl Default for FMOD_PLUGINLIST {
    fn default() -> Self {
        Self {
            type_: Default::default(),
            description: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_ADVANCEDSETTINGS {
    pub cbSize: c_int,
    pub maxMPEGCodecs: c_int,
    pub maxADPCMCodecs: c_int,
    pub maxXMACodecs: c_int,
    pub maxVorbisCodecs: c_int,
    pub maxAT9Codecs: c_int,
    pub maxFADPCMCodecs: c_int,
    pub maxPCMCodecs: c_int,
    pub ASIONumChannels: c_int,
    pub ASIOChannelList: *mut *mut c_char,
    pub ASIOSpeakerList: *mut FMOD_SPEAKER,
    pub vol0virtualvol: c_float,
    pub defaultDecodeBufferSize: c_uint,
    pub profilePort: c_ushort,
    pub geometryMaxFadeTime: c_uint,
    pub distanceFilterCenterFreq: c_float,
    pub reverb3Dinstance: c_int,
    pub DSPBufferPoolSize: c_int,
    pub resamplerMethod: FMOD_DSP_RESAMPLER,
    pub randomSeed: c_uint,
    pub maxConvolutionThreads: c_int,
    pub maxOpusCodecs: c_int,
}

impl Default for FMOD_ADVANCEDSETTINGS {
    fn default() -> Self {
        Self {
            cbSize: Default::default(),
            maxMPEGCodecs: Default::default(),
            maxADPCMCodecs: Default::default(),
            maxXMACodecs: Default::default(),
            maxVorbisCodecs: Default::default(),
            maxAT9Codecs: Default::default(),
            maxFADPCMCodecs: Default::default(),
            maxPCMCodecs: Default::default(),
            ASIONumChannels: Default::default(),
            ASIOChannelList: null_mut(),
            ASIOSpeakerList: null_mut(),
            vol0virtualvol: Default::default(),
            defaultDecodeBufferSize: Default::default(),
            profilePort: Default::default(),
            geometryMaxFadeTime: Default::default(),
            distanceFilterCenterFreq: Default::default(),
            reverb3Dinstance: Default::default(),
            DSPBufferPoolSize: Default::default(),
            resamplerMethod: Default::default(),
            randomSeed: Default::default(),
            maxConvolutionThreads: Default::default(),
            maxOpusCodecs: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_TAG {
    pub type_: FMOD_TAGTYPE,
    pub datatype: FMOD_TAGDATATYPE,
    pub name: *mut c_char,
    pub data: *mut c_void,
    pub datalen: c_uint,
    pub updated: FMOD_BOOL,
}

impl Default for FMOD_TAG {
    fn default() -> Self {
        Self {
            type_: Default::default(),
            datatype: Default::default(),
            name: null_mut(),
            data: null_mut(),
            datalen: Default::default(),
            updated: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CREATESOUNDEXINFO {
    pub cbsize: c_int,
    pub length: c_uint,
    pub fileoffset: c_uint,
    pub numchannels: c_int,
    pub defaultfrequency: c_int,
    pub format: FMOD_SOUND_FORMAT,
    pub decodebuffersize: c_uint,
    pub initialsubsound: c_int,
    pub numsubsounds: c_int,
    pub inclusionlist: *mut c_int,
    pub inclusionlistnum: c_int,
    pub pcmreadcallback: FMOD_SOUND_PCMREAD_CALLBACK,
    pub pcmsetposcallback: FMOD_SOUND_PCMSETPOS_CALLBACK,
    pub nonblockcallback: FMOD_SOUND_NONBLOCK_CALLBACK,
    pub dlsname: *const c_char,
    pub encryptionkey: *const c_char,
    pub maxpolyphony: c_int,
    pub userdata: *mut c_void,
    pub suggestedsoundtype: FMOD_SOUND_TYPE,
    pub fileuseropen: FMOD_FILE_OPEN_CALLBACK,
    pub fileuserclose: FMOD_FILE_CLOSE_CALLBACK,
    pub fileuserread: FMOD_FILE_READ_CALLBACK,
    pub fileuserseek: FMOD_FILE_SEEK_CALLBACK,
    pub fileuserasyncread: FMOD_FILE_ASYNCREAD_CALLBACK,
    pub fileuserasynccancel: FMOD_FILE_ASYNCCANCEL_CALLBACK,
    pub fileuserdata: *mut c_void,
    pub filebuffersize: c_int,
    pub channelorder: FMOD_CHANNELORDER,
    pub initialsoundgroup: *mut FMOD_SOUNDGROUP,
    pub initialseekposition: c_uint,
    pub initialseekpostype: FMOD_TIMEUNIT,
    pub ignoresetfilesystem: c_int,
    pub audioqueuepolicy: c_uint,
    pub minmidigranularity: c_uint,
    pub nonblockthreadid: c_int,
    pub fsbguid: *mut FMOD_GUID,
}

impl Default for FMOD_CREATESOUNDEXINFO {
    fn default() -> Self {
        Self {
            cbsize: Default::default(),
            length: Default::default(),
            fileoffset: Default::default(),
            numchannels: Default::default(),
            defaultfrequency: Default::default(),
            format: Default::default(),
            decodebuffersize: Default::default(),
            initialsubsound: Default::default(),
            numsubsounds: Default::default(),
            inclusionlist: null_mut(),
            inclusionlistnum: Default::default(),
            pcmreadcallback: Default::default(),
            pcmsetposcallback: Default::default(),
            nonblockcallback: Default::default(),
            dlsname: null_mut(),
            encryptionkey: null_mut(),
            maxpolyphony: Default::default(),
            userdata: null_mut(),
            suggestedsoundtype: Default::default(),
            fileuseropen: Default::default(),
            fileuserclose: Default::default(),
            fileuserread: Default::default(),
            fileuserseek: Default::default(),
            fileuserasyncread: Default::default(),
            fileuserasynccancel: Default::default(),
            fileuserdata: null_mut(),
            filebuffersize: Default::default(),
            channelorder: Default::default(),
            initialsoundgroup: null_mut(),
            initialseekposition: Default::default(),
            initialseekpostype: Default::default(),
            ignoresetfilesystem: Default::default(),
            audioqueuepolicy: Default::default(),
            minmidigranularity: Default::default(),
            nonblockthreadid: Default::default(),
            fsbguid: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_REVERB_PROPERTIES {
    pub DecayTime: c_float,
    pub EarlyDelay: c_float,
    pub LateDelay: c_float,
    pub HFReference: c_float,
    pub HFDecayRatio: c_float,
    pub Diffusion: c_float,
    pub Density: c_float,
    pub LowShelfFrequency: c_float,
    pub LowShelfGain: c_float,
    pub HighCut: c_float,
    pub EarlyLateMix: c_float,
    pub WetLevel: c_float,
}

impl Default for FMOD_REVERB_PROPERTIES {
    fn default() -> Self {
        Self {
            DecayTime: Default::default(),
            EarlyDelay: Default::default(),
            LateDelay: Default::default(),
            HFReference: Default::default(),
            HFDecayRatio: Default::default(),
            Diffusion: Default::default(),
            Density: Default::default(),
            LowShelfFrequency: Default::default(),
            LowShelfGain: Default::default(),
            HighCut: Default::default(),
            EarlyLateMix: Default::default(),
            WetLevel: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_ERRORCALLBACK_INFO {
    pub result: FMOD_RESULT,
    pub instancetype: FMOD_ERRORCALLBACK_INSTANCETYPE,
    pub instance: *mut c_void,
    pub functionname: *const c_char,
    pub functionparams: *const c_char,
}

impl Default for FMOD_ERRORCALLBACK_INFO {
    fn default() -> Self {
        Self {
            result: Default::default(),
            instancetype: Default::default(),
            instance: null_mut(),
            functionname: null_mut(),
            functionparams: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CPU_USAGE {
    pub dsp: c_float,
    pub stream: c_float,
    pub geometry: c_float,
    pub update: c_float,
    pub convolution1: c_float,
    pub convolution2: c_float,
}

impl Default for FMOD_CPU_USAGE {
    fn default() -> Self {
        Self {
            dsp: Default::default(),
            stream: Default::default(),
            geometry: Default::default(),
            update: Default::default(),
            convolution1: Default::default(),
            convolution2: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CODEC_DESCRIPTION {
    pub apiversion: c_uint,
    pub name: *const c_char,
    pub version: c_uint,
    pub defaultasstream: c_int,
    pub timeunits: FMOD_TIMEUNIT,
    pub open: FMOD_CODEC_OPEN_CALLBACK,
    pub close: FMOD_CODEC_CLOSE_CALLBACK,
    pub read: FMOD_CODEC_READ_CALLBACK,
    pub getlength: FMOD_CODEC_GETLENGTH_CALLBACK,
    pub setposition: FMOD_CODEC_SETPOSITION_CALLBACK,
    pub getposition: FMOD_CODEC_GETPOSITION_CALLBACK,
    pub soundcreate: FMOD_CODEC_SOUNDCREATE_CALLBACK,
    pub getwaveformat: FMOD_CODEC_GETWAVEFORMAT_CALLBACK,
}

impl Default for FMOD_CODEC_DESCRIPTION {
    fn default() -> Self {
        Self {
            apiversion: Default::default(),
            name: null_mut(),
            version: Default::default(),
            defaultasstream: Default::default(),
            timeunits: Default::default(),
            open: Default::default(),
            close: Default::default(),
            read: Default::default(),
            getlength: Default::default(),
            setposition: Default::default(),
            getposition: Default::default(),
            soundcreate: Default::default(),
            getwaveformat: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CODEC_WAVEFORMAT {
    pub name: *const c_char,
    pub format: FMOD_SOUND_FORMAT,
    pub channels: c_int,
    pub frequency: c_int,
    pub lengthbytes: c_uint,
    pub lengthpcm: c_uint,
    pub pcmblocksize: c_uint,
    pub loopstart: c_int,
    pub loopend: c_int,
    pub mode: FMOD_MODE,
    pub channelmask: FMOD_CHANNELMASK,
    pub channelorder: FMOD_CHANNELORDER,
    pub peakvolume: c_float,
}

impl Default for FMOD_CODEC_WAVEFORMAT {
    fn default() -> Self {
        Self {
            name: null_mut(),
            format: Default::default(),
            channels: Default::default(),
            frequency: Default::default(),
            lengthbytes: Default::default(),
            lengthpcm: Default::default(),
            pcmblocksize: Default::default(),
            loopstart: Default::default(),
            loopend: Default::default(),
            mode: Default::default(),
            channelmask: Default::default(),
            channelorder: Default::default(),
            peakvolume: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CODEC_STATE_FUNCTIONS {
    pub metadata: FMOD_CODEC_METADATA_FUNC,
    pub alloc: FMOD_CODEC_ALLOC_FUNC,
    pub free: FMOD_CODEC_FREE_FUNC,
    pub log: FMOD_CODEC_LOG_FUNC,
    pub read: FMOD_CODEC_FILE_READ_FUNC,
    pub seek: FMOD_CODEC_FILE_SEEK_FUNC,
    pub tell: FMOD_CODEC_FILE_TELL_FUNC,
    pub size: FMOD_CODEC_FILE_SIZE_FUNC,
}

impl Default for FMOD_CODEC_STATE_FUNCTIONS {
    fn default() -> Self {
        Self {
            metadata: Default::default(),
            alloc: Default::default(),
            free: Default::default(),
            log: Default::default(),
            read: Default::default(),
            seek: Default::default(),
            tell: Default::default(),
            size: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_CODEC_STATE {
    pub plugindata: *mut c_void,
    pub waveformat: *mut FMOD_CODEC_WAVEFORMAT,
    pub functions: *mut FMOD_CODEC_STATE_FUNCTIONS,
    pub numsubsounds: c_int,
}

impl Default for FMOD_CODEC_STATE {
    fn default() -> Self {
        Self {
            plugindata: null_mut(),
            waveformat: null_mut(),
            functions: null_mut(),
            numsubsounds: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_OUTPUT_DESCRIPTION {
    pub apiversion: c_uint,
    pub name: *const c_char,
    pub version: c_uint,
    pub method: FMOD_OUTPUT_METHOD,
    pub getnumdrivers: FMOD_OUTPUT_GETNUMDRIVERS_CALLBACK,
    pub getdriverinfo: FMOD_OUTPUT_GETDRIVERINFO_CALLBACK,
    pub init: FMOD_OUTPUT_INIT_CALLBACK,
    pub start: FMOD_OUTPUT_START_CALLBACK,
    pub stop: FMOD_OUTPUT_STOP_CALLBACK,
    pub close: FMOD_OUTPUT_CLOSE_CALLBACK,
    pub update: FMOD_OUTPUT_UPDATE_CALLBACK,
    pub gethandle: FMOD_OUTPUT_GETHANDLE_CALLBACK,
    pub mixer: FMOD_OUTPUT_MIXER_CALLBACK,
    pub object3dgetinfo: FMOD_OUTPUT_OBJECT3DGETINFO_CALLBACK,
    pub object3dalloc: FMOD_OUTPUT_OBJECT3DALLOC_CALLBACK,
    pub object3dfree: FMOD_OUTPUT_OBJECT3DFREE_CALLBACK,
    pub object3dupdate: FMOD_OUTPUT_OBJECT3DUPDATE_CALLBACK,
    pub openport: FMOD_OUTPUT_OPENPORT_CALLBACK,
    pub closeport: FMOD_OUTPUT_CLOSEPORT_CALLBACK,
    pub devicelistchanged: FMOD_OUTPUT_DEVICELISTCHANGED_CALLBACK,
}

impl Default for FMOD_OUTPUT_DESCRIPTION {
    fn default() -> Self {
        Self {
            apiversion: Default::default(),
            name: null_mut(),
            version: Default::default(),
            method: Default::default(),
            getnumdrivers: Default::default(),
            getdriverinfo: Default::default(),
            init: Default::default(),
            start: Default::default(),
            stop: Default::default(),
            close: Default::default(),
            update: Default::default(),
            gethandle: Default::default(),
            mixer: Default::default(),
            object3dgetinfo: Default::default(),
            object3dalloc: Default::default(),
            object3dfree: Default::default(),
            object3dupdate: Default::default(),
            openport: Default::default(),
            closeport: Default::default(),
            devicelistchanged: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_OUTPUT_STATE {
    pub plugindata: *mut c_void,
    pub readfrommixer: FMOD_OUTPUT_READFROMMIXER_FUNC,
    pub alloc: FMOD_OUTPUT_ALLOC_FUNC,
    pub free: FMOD_OUTPUT_FREE_FUNC,
    pub log: FMOD_OUTPUT_LOG_FUNC,
    pub copyport: FMOD_OUTPUT_COPYPORT_FUNC,
    pub requestreset: FMOD_OUTPUT_REQUESTRESET_FUNC,
}

impl Default for FMOD_OUTPUT_STATE {
    fn default() -> Self {
        Self {
            plugindata: null_mut(),
            readfrommixer: Default::default(),
            alloc: Default::default(),
            free: Default::default(),
            log: Default::default(),
            copyport: Default::default(),
            requestreset: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_OUTPUT_OBJECT3DINFO {
    pub buffer: *mut c_float,
    pub bufferlength: c_uint,
    pub position: FMOD_VECTOR,
    pub gain: c_float,
    pub spread: c_float,
    pub priority: c_float,
}

impl Default for FMOD_OUTPUT_OBJECT3DINFO {
    fn default() -> Self {
        Self {
            buffer: null_mut(),
            bufferlength: Default::default(),
            position: Default::default(),
            gain: Default::default(),
            spread: Default::default(),
            priority: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_BUFFER_ARRAY {
    pub numbuffers: c_int,
    pub buffernumchannels: *mut c_int,
    pub bufferchannelmask: *mut FMOD_CHANNELMASK,
    pub buffers: *mut *mut c_float,
    pub speakermode: FMOD_SPEAKERMODE,
}

impl Default for FMOD_DSP_BUFFER_ARRAY {
    fn default() -> Self {
        Self {
            numbuffers: Default::default(),
            buffernumchannels: null_mut(),
            bufferchannelmask: null_mut(),
            buffers: null_mut(),
            speakermode: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_COMPLEX {
    pub real: c_float,
    pub imag: c_float,
}

impl Default for FMOD_COMPLEX {
    fn default() -> Self {
        Self {
            real: Default::default(),
            imag: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_FLOAT_MAPPING_PIECEWISE_LINEAR {
    pub numpoints: c_int,
    pub pointparamvalues: *mut c_float,
    pub pointpositions: *mut c_float,
}

impl Default for FMOD_DSP_PARAMETER_FLOAT_MAPPING_PIECEWISE_LINEAR {
    fn default() -> Self {
        Self {
            numpoints: Default::default(),
            pointparamvalues: null_mut(),
            pointpositions: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_FLOAT_MAPPING {
    pub type_: FMOD_DSP_PARAMETER_FLOAT_MAPPING_TYPE,
    pub piecewiselinearmapping: FMOD_DSP_PARAMETER_FLOAT_MAPPING_PIECEWISE_LINEAR,
}

impl Default for FMOD_DSP_PARAMETER_FLOAT_MAPPING {
    fn default() -> Self {
        Self {
            type_: Default::default(),
            piecewiselinearmapping: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_DESC_FLOAT {
    pub min: c_float,
    pub max: c_float,
    pub defaultval: c_float,
    pub mapping: FMOD_DSP_PARAMETER_FLOAT_MAPPING,
}

impl Default for FMOD_DSP_PARAMETER_DESC_FLOAT {
    fn default() -> Self {
        Self {
            min: Default::default(),
            max: Default::default(),
            defaultval: Default::default(),
            mapping: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_DESC_INT {
    pub min: c_int,
    pub max: c_int,
    pub defaultval: c_int,
    pub goestoinf: FMOD_BOOL,
    pub valuenames: *const *const c_char,
}

impl Default for FMOD_DSP_PARAMETER_DESC_INT {
    fn default() -> Self {
        Self {
            min: Default::default(),
            max: Default::default(),
            defaultval: Default::default(),
            goestoinf: Default::default(),
            valuenames: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_DESC_BOOL {
    pub defaultval: FMOD_BOOL,
    pub valuenames: *const *const c_char,
}

impl Default for FMOD_DSP_PARAMETER_DESC_BOOL {
    fn default() -> Self {
        Self {
            defaultval: Default::default(),
            valuenames: null_mut(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_DESC_DATA {
    pub datatype: c_int,
}

impl Default for FMOD_DSP_PARAMETER_DESC_DATA {
    fn default() -> Self {
        Self {
            datatype: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_DESC {
    pub type_: FMOD_DSP_PARAMETER_TYPE,
    pub name: [c_char; 16 as usize],
    pub label: [c_char; 16 as usize],
    pub description: *const c_char,
    pub __union: FMOD_DSP_PARAMETER_DESC__union,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union FMOD_DSP_PARAMETER_DESC__union {
    pub floatdesc: FMOD_DSP_PARAMETER_DESC_FLOAT,
    pub intdesc: FMOD_DSP_PARAMETER_DESC_INT,
    pub booldesc: FMOD_DSP_PARAMETER_DESC_BOOL,
    pub datadesc: FMOD_DSP_PARAMETER_DESC_DATA,
}

impl Default for FMOD_DSP_PARAMETER_DESC {
    fn default() -> Self {
        unimplemented!()
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_OVERALLGAIN {
    pub linear_gain: c_float,
    pub linear_gain_additive: c_float,
}

impl Default for FMOD_DSP_PARAMETER_OVERALLGAIN {
    fn default() -> Self {
        Self {
            linear_gain: Default::default(),
            linear_gain_additive: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_3DATTRIBUTES {
    pub relative: FMOD_3D_ATTRIBUTES,
    pub absolute: FMOD_3D_ATTRIBUTES,
}

impl Default for FMOD_DSP_PARAMETER_3DATTRIBUTES {
    fn default() -> Self {
        Self {
            relative: Default::default(),
            absolute: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI {
    pub numlisteners: c_int,
    pub relative: [FMOD_3D_ATTRIBUTES; FMOD_MAX_LISTENERS as usize],
    pub weight: [c_float; FMOD_MAX_LISTENERS as usize],
    pub absolute: FMOD_3D_ATTRIBUTES,
}

impl Default for FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI {
    fn default() -> Self {
        Self {
            numlisteners: Default::default(),
            relative: Default::default(),
            weight: Default::default(),
            absolute: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_ATTENUATION_RANGE {
    pub min: c_float,
    pub max: c_float,
}

impl Default for FMOD_DSP_PARAMETER_ATTENUATION_RANGE {
    fn default() -> Self {
        Self {
            min: Default::default(),
            max: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_SIDECHAIN {
    pub sidechainenable: FMOD_BOOL,
}

impl Default for FMOD_DSP_PARAMETER_SIDECHAIN {
    fn default() -> Self {
        Self {
            sidechainenable: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_PARAMETER_FFT {
    pub length: c_int,
    pub numchannels: c_int,
    pub spectrum: [*mut c_float; 32 as usize],
}

impl Default for FMOD_DSP_PARAMETER_FFT {
    fn default() -> Self {
        unimplemented!()
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_DESCRIPTION {
    pub pluginsdkversion: c_uint,
    pub name: [c_char; 32 as usize],
    pub version: c_uint,
    pub numinputbuffers: c_int,
    pub numoutputbuffers: c_int,
    pub create: FMOD_DSP_CREATE_CALLBACK,
    pub release: FMOD_DSP_RELEASE_CALLBACK,
    pub reset: FMOD_DSP_RESET_CALLBACK,
    pub read: FMOD_DSP_READ_CALLBACK,
    pub process: FMOD_DSP_PROCESS_CALLBACK,
    pub setposition: FMOD_DSP_SETPOSITION_CALLBACK,
    pub numparameters: c_int,
    pub paramdesc: *mut *mut FMOD_DSP_PARAMETER_DESC,
    pub setparameterfloat: FMOD_DSP_SETPARAM_FLOAT_CALLBACK,
    pub setparameterint: FMOD_DSP_SETPARAM_INT_CALLBACK,
    pub setparameterbool: FMOD_DSP_SETPARAM_BOOL_CALLBACK,
    pub setparameterdata: FMOD_DSP_SETPARAM_DATA_CALLBACK,
    pub getparameterfloat: FMOD_DSP_GETPARAM_FLOAT_CALLBACK,
    pub getparameterint: FMOD_DSP_GETPARAM_INT_CALLBACK,
    pub getparameterbool: FMOD_DSP_GETPARAM_BOOL_CALLBACK,
    pub getparameterdata: FMOD_DSP_GETPARAM_DATA_CALLBACK,
    pub shouldiprocess: FMOD_DSP_SHOULDIPROCESS_CALLBACK,
    pub userdata: *mut c_void,
    pub sys_register: FMOD_DSP_SYSTEM_REGISTER_CALLBACK,
    pub sys_deregister: FMOD_DSP_SYSTEM_DEREGISTER_CALLBACK,
    pub sys_mix: FMOD_DSP_SYSTEM_MIX_CALLBACK,
}

impl Default for FMOD_DSP_DESCRIPTION {
    fn default() -> Self {
        Self {
            pluginsdkversion: Default::default(),
            name: Default::default(),
            version: Default::default(),
            numinputbuffers: Default::default(),
            numoutputbuffers: Default::default(),
            create: Default::default(),
            release: Default::default(),
            reset: Default::default(),
            read: Default::default(),
            process: Default::default(),
            setposition: Default::default(),
            numparameters: Default::default(),
            paramdesc: null_mut(),
            setparameterfloat: Default::default(),
            setparameterint: Default::default(),
            setparameterbool: Default::default(),
            setparameterdata: Default::default(),
            getparameterfloat: Default::default(),
            getparameterint: Default::default(),
            getparameterbool: Default::default(),
            getparameterdata: Default::default(),
            shouldiprocess: Default::default(),
            userdata: null_mut(),
            sys_register: Default::default(),
            sys_deregister: Default::default(),
            sys_mix: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_STATE_DFT_FUNCTIONS {
    pub fftreal: FMOD_DSP_DFT_FFTREAL_FUNC,
    pub inversefftreal: FMOD_DSP_DFT_IFFTREAL_FUNC,
}

impl Default for FMOD_DSP_STATE_DFT_FUNCTIONS {
    fn default() -> Self {
        Self {
            fftreal: Default::default(),
            inversefftreal: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_STATE_PAN_FUNCTIONS {
    pub summonomatrix: FMOD_DSP_PAN_SUMMONOMATRIX_FUNC,
    pub sumstereomatrix: FMOD_DSP_PAN_SUMSTEREOMATRIX_FUNC,
    pub sumsurroundmatrix: FMOD_DSP_PAN_SUMSURROUNDMATRIX_FUNC,
    pub summonotosurroundmatrix: FMOD_DSP_PAN_SUMMONOTOSURROUNDMATRIX_FUNC,
    pub sumstereotosurroundmatrix: FMOD_DSP_PAN_SUMSTEREOTOSURROUNDMATRIX_FUNC,
    pub getrolloffgain: FMOD_DSP_PAN_GETROLLOFFGAIN_FUNC,
}

impl Default for FMOD_DSP_STATE_PAN_FUNCTIONS {
    fn default() -> Self {
        Self {
            summonomatrix: Default::default(),
            sumstereomatrix: Default::default(),
            sumsurroundmatrix: Default::default(),
            summonotosurroundmatrix: Default::default(),
            sumstereotosurroundmatrix: Default::default(),
            getrolloffgain: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_STATE_FUNCTIONS {
    pub alloc: FMOD_DSP_ALLOC_FUNC,
    pub realloc: FMOD_DSP_REALLOC_FUNC,
    pub free: FMOD_DSP_FREE_FUNC,
    pub getsamplerate: FMOD_DSP_GETSAMPLERATE_FUNC,
    pub getblocksize: FMOD_DSP_GETBLOCKSIZE_FUNC,
    pub dft: *mut FMOD_DSP_STATE_DFT_FUNCTIONS,
    pub pan: *mut FMOD_DSP_STATE_PAN_FUNCTIONS,
    pub getspeakermode: FMOD_DSP_GETSPEAKERMODE_FUNC,
    pub getclock: FMOD_DSP_GETCLOCK_FUNC,
    pub getlistenerattributes: FMOD_DSP_GETLISTENERATTRIBUTES_FUNC,
    pub log: FMOD_DSP_LOG_FUNC,
    pub getuserdata: FMOD_DSP_GETUSERDATA_FUNC,
}

impl Default for FMOD_DSP_STATE_FUNCTIONS {
    fn default() -> Self {
        Self {
            alloc: Default::default(),
            realloc: Default::default(),
            free: Default::default(),
            getsamplerate: Default::default(),
            getblocksize: Default::default(),
            dft: null_mut(),
            pan: null_mut(),
            getspeakermode: Default::default(),
            getclock: Default::default(),
            getlistenerattributes: Default::default(),
            log: Default::default(),
            getuserdata: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_STATE {
    pub instance: *mut c_void,
    pub plugindata: *mut c_void,
    pub channelmask: FMOD_CHANNELMASK,
    pub source_speakermode: FMOD_SPEAKERMODE,
    pub sidechaindata: *mut c_float,
    pub sidechainchannels: c_int,
    pub functions: *mut FMOD_DSP_STATE_FUNCTIONS,
    pub systemobject: c_int,
}

impl Default for FMOD_DSP_STATE {
    fn default() -> Self {
        Self {
            instance: null_mut(),
            plugindata: null_mut(),
            channelmask: Default::default(),
            source_speakermode: Default::default(),
            sidechaindata: null_mut(),
            sidechainchannels: Default::default(),
            functions: null_mut(),
            systemobject: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_METERING_INFO {
    pub numsamples: c_int,
    pub peaklevel: [c_float; 32 as usize],
    pub rmslevel: [c_float; 32 as usize],
    pub numchannels: c_short,
}

impl Default for FMOD_DSP_METERING_INFO {
    fn default() -> Self {
        Self {
            numsamples: Default::default(),
            peaklevel: Default::default(),
            rmslevel: Default::default(),
            numchannels: Default::default(),
        }
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_LOUDNESS_METER_INFO_TYPE {
    pub momentaryloudness: c_float,
    pub shorttermloudness: c_float,
    pub integratedloudness: c_float,
    pub loudness10thpercentile: c_float,
    pub loudness95thpercentile: c_float,
    pub loudnesshistogram: [c_float; FMOD_DSP_LOUDNESS_METER_HISTOGRAM_SAMPLES as usize],
    pub maxtruepeak: c_float,
    pub maxmomentaryloudness: c_float,
}

impl Default for FMOD_DSP_LOUDNESS_METER_INFO_TYPE {
    fn default() -> Self {
        unimplemented!()
    }
}

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FMOD_DSP_LOUDNESS_METER_WEIGHTING_TYPE {
    pub channelweight: [c_float; 32 as usize],
}

impl Default for FMOD_DSP_LOUDNESS_METER_WEIGHTING_TYPE {
    fn default() -> Self {
        Self {
            channelweight: Default::default(),
        }
    }
}

pub const FMOD_PRESET_OFF: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1000.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 100.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 20.0,
    EarlyLateMix: 96.0,
    WetLevel: -80.0,
};
pub const FMOD_PRESET_GENERIC: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 83.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 14500.0,
    EarlyLateMix: 96.0,
    WetLevel: -8.0,
};
pub const FMOD_PRESET_PADDEDCELL: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 170.0,
    EarlyDelay: 1.0,
    LateDelay: 2.0,
    HFReference: 5000.0,
    HFDecayRatio: 10.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 160.0,
    EarlyLateMix: 84.0,
    WetLevel: -7.8,
};
pub const FMOD_PRESET_ROOM: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 400.0,
    EarlyDelay: 2.0,
    LateDelay: 3.0,
    HFReference: 5000.0,
    HFDecayRatio: 83.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 6050.0,
    EarlyLateMix: 88.0,
    WetLevel: -9.4,
};
pub const FMOD_PRESET_BATHROOM: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 54.0,
    Diffusion: 100.0,
    Density: 60.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 2900.0,
    EarlyLateMix: 83.0,
    WetLevel: 0.5,
};
pub const FMOD_PRESET_LIVINGROOM: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 500.0,
    EarlyDelay: 3.0,
    LateDelay: 4.0,
    HFReference: 5000.0,
    HFDecayRatio: 10.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 160.0,
    EarlyLateMix: 58.0,
    WetLevel: -19.0,
};
pub const FMOD_PRESET_STONEROOM: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 2300.0,
    EarlyDelay: 12.0,
    LateDelay: 17.0,
    HFReference: 5000.0,
    HFDecayRatio: 64.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 7800.0,
    EarlyLateMix: 71.0,
    WetLevel: -8.5,
};
pub const FMOD_PRESET_AUDITORIUM: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 4300.0,
    EarlyDelay: 20.0,
    LateDelay: 30.0,
    HFReference: 5000.0,
    HFDecayRatio: 59.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 5850.0,
    EarlyLateMix: 64.0,
    WetLevel: -11.7,
};
pub const FMOD_PRESET_CONCERTHALL: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 3900.0,
    EarlyDelay: 20.0,
    LateDelay: 29.0,
    HFReference: 5000.0,
    HFDecayRatio: 70.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 5650.0,
    EarlyLateMix: 80.0,
    WetLevel: -9.8,
};
pub const FMOD_PRESET_CAVE: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 2900.0,
    EarlyDelay: 15.0,
    LateDelay: 22.0,
    HFReference: 5000.0,
    HFDecayRatio: 100.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 20000.0,
    EarlyLateMix: 59.0,
    WetLevel: -11.3,
};
pub const FMOD_PRESET_ARENA: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 7200.0,
    EarlyDelay: 20.0,
    LateDelay: 30.0,
    HFReference: 5000.0,
    HFDecayRatio: 33.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 4500.0,
    EarlyLateMix: 80.0,
    WetLevel: -9.6,
};
pub const FMOD_PRESET_HANGAR: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 10000.0,
    EarlyDelay: 20.0,
    LateDelay: 30.0,
    HFReference: 5000.0,
    HFDecayRatio: 23.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 3400.0,
    EarlyLateMix: 72.0,
    WetLevel: -7.4,
};
pub const FMOD_PRESET_CARPETTEDHALLWAY: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 300.0,
    EarlyDelay: 2.0,
    LateDelay: 30.0,
    HFReference: 5000.0,
    HFDecayRatio: 10.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 500.0,
    EarlyLateMix: 56.0,
    WetLevel: -24.0,
};
pub const FMOD_PRESET_HALLWAY: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 59.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 7800.0,
    EarlyLateMix: 87.0,
    WetLevel: -5.5,
};
pub const FMOD_PRESET_STONECORRIDOR: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 270.0,
    EarlyDelay: 13.0,
    LateDelay: 20.0,
    HFReference: 5000.0,
    HFDecayRatio: 79.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 9000.0,
    EarlyLateMix: 86.0,
    WetLevel: -6.0,
};
pub const FMOD_PRESET_ALLEY: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 86.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 8300.0,
    EarlyLateMix: 80.0,
    WetLevel: -9.8,
};
pub const FMOD_PRESET_FOREST: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 162.0,
    LateDelay: 88.0,
    HFReference: 5000.0,
    HFDecayRatio: 54.0,
    Diffusion: 79.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 760.0,
    EarlyLateMix: 94.0,
    WetLevel: -12.3,
};
pub const FMOD_PRESET_CITY: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 67.0,
    Diffusion: 50.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 4050.0,
    EarlyLateMix: 66.0,
    WetLevel: -26.0,
};
pub const FMOD_PRESET_MOUNTAINS: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 300.0,
    LateDelay: 100.0,
    HFReference: 5000.0,
    HFDecayRatio: 21.0,
    Diffusion: 27.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 1220.0,
    EarlyLateMix: 82.0,
    WetLevel: -24.0,
};
pub const FMOD_PRESET_QUARRY: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 61.0,
    LateDelay: 25.0,
    HFReference: 5000.0,
    HFDecayRatio: 83.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 3400.0,
    EarlyLateMix: 100.0,
    WetLevel: -5.0,
};
pub const FMOD_PRESET_PLAIN: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 179.0,
    LateDelay: 100.0,
    HFReference: 5000.0,
    HFDecayRatio: 50.0,
    Diffusion: 21.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 1670.0,
    EarlyLateMix: 65.0,
    WetLevel: -28.0,
};
pub const FMOD_PRESET_PARKINGLOT: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1700.0,
    EarlyDelay: 8.0,
    LateDelay: 12.0,
    HFReference: 5000.0,
    HFDecayRatio: 100.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 20000.0,
    EarlyLateMix: 56.0,
    WetLevel: -19.5,
};
pub const FMOD_PRESET_SEWERPIPE: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 2800.0,
    EarlyDelay: 14.0,
    LateDelay: 21.0,
    HFReference: 5000.0,
    HFDecayRatio: 14.0,
    Diffusion: 80.0,
    Density: 60.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 3400.0,
    EarlyLateMix: 66.0,
    WetLevel: 1.2,
};
pub const FMOD_PRESET_UNDERWATER: FMOD_REVERB_PROPERTIES = FMOD_REVERB_PROPERTIES {
    DecayTime: 1500.0,
    EarlyDelay: 7.0,
    LateDelay: 11.0,
    HFReference: 5000.0,
    HFDecayRatio: 10.0,
    Diffusion: 100.0,
    Density: 100.0,
    LowShelfFrequency: 250.0,
    LowShelfGain: 0.0,
    HighCut: 500.0,
    EarlyLateMix: 92.0,
    WetLevel: 7.0,
};

pub type FMOD_STUDIO_SYSTEM_CALLBACK = Option<
    unsafe extern "C" fn(
        system: *mut FMOD_STUDIO_SYSTEM,
        type_: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE,
        commanddata: *mut c_void,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_STUDIO_EVENT_CALLBACK = Option<
    unsafe extern "C" fn(
        type_: FMOD_STUDIO_EVENT_CALLBACK_TYPE,
        event: *mut FMOD_STUDIO_EVENTINSTANCE,
        parameters: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_STUDIO_COMMANDREPLAY_FRAME_CALLBACK = Option<
    unsafe extern "C" fn(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
        currenttime: c_float,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_STUDIO_COMMANDREPLAY_LOAD_BANK_CALLBACK = Option<
    unsafe extern "C" fn(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
        bankguid: *const FMOD_GUID,
        bankfilename: *const c_char,
        flags: FMOD_STUDIO_LOAD_BANK_FLAGS,
        bank: *mut *mut FMOD_STUDIO_BANK,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_STUDIO_COMMANDREPLAY_CREATE_INSTANCE_CALLBACK = Option<
    unsafe extern "C" fn(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        instance: *mut *mut FMOD_STUDIO_EVENTINSTANCE,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DEBUG_CALLBACK = Option<
    unsafe extern "C" fn(
        flags: FMOD_DEBUG_FLAGS,
        file: *const c_char,
        line: c_int,
        func: *const c_char,
        message: *const c_char,
    ) -> FMOD_RESULT,
>;
pub type FMOD_SYSTEM_CALLBACK = Option<
    unsafe extern "C" fn(
        system: *mut FMOD_SYSTEM,
        type_: FMOD_SYSTEM_CALLBACK_TYPE,
        commanddata1: *mut c_void,
        commanddata2: *mut c_void,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CHANNELCONTROL_CALLBACK = Option<
    unsafe extern "C" fn(
        channelcontrol: *mut FMOD_CHANNELCONTROL,
        controltype: FMOD_CHANNELCONTROL_TYPE,
        callbacktype: FMOD_CHANNELCONTROL_CALLBACK_TYPE,
        commanddata1: *mut c_void,
        commanddata2: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_SOUND_NONBLOCK_CALLBACK =
Option<unsafe extern "C" fn(sound: *mut FMOD_SOUND, result: FMOD_RESULT) -> FMOD_RESULT>;
pub type FMOD_SOUND_PCMREAD_CALLBACK = Option<
    unsafe extern "C" fn(sound: *mut FMOD_SOUND, data: *mut c_void, datalen: c_uint) -> FMOD_RESULT,
>;
pub type FMOD_SOUND_PCMSETPOS_CALLBACK = Option<
    unsafe extern "C" fn(
        sound: *mut FMOD_SOUND,
        subsound: c_int,
        position: c_uint,
        postype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_FILE_OPEN_CALLBACK = Option<
    unsafe extern "C" fn(
        name: *const c_char,
        filesize: *mut c_uint,
        handle: *mut *mut c_void,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_FILE_CLOSE_CALLBACK =
Option<unsafe extern "C" fn(handle: *mut c_void, userdata: *mut c_void) -> FMOD_RESULT>;
pub type FMOD_FILE_READ_CALLBACK = Option<
    unsafe extern "C" fn(
        handle: *mut c_void,
        buffer: *mut c_void,
        sizebytes: c_uint,
        bytesread: *mut c_uint,
        userdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_FILE_SEEK_CALLBACK = Option<
    unsafe extern "C" fn(handle: *mut c_void, pos: c_uint, userdata: *mut c_void) -> FMOD_RESULT,
>;
pub type FMOD_FILE_ASYNCREAD_CALLBACK = Option<
    unsafe extern "C" fn(info: *mut FMOD_ASYNCREADINFO, userdata: *mut c_void) -> FMOD_RESULT,
>;
pub type FMOD_FILE_ASYNCCANCEL_CALLBACK = Option<
    unsafe extern "C" fn(info: *mut FMOD_ASYNCREADINFO, userdata: *mut c_void) -> FMOD_RESULT,
>;
pub type FMOD_FILE_ASYNCDONE_FUNC =
Option<unsafe extern "C" fn(info: *mut FMOD_ASYNCREADINFO, result: FMOD_RESULT)>;
pub type FMOD_MEMORY_ALLOC_CALLBACK = Option<
    unsafe extern "C" fn(
        size: c_uint,
        type_: FMOD_MEMORY_TYPE,
        sourcestr: *const c_char,
    ) -> *mut c_void,
>;
pub type FMOD_MEMORY_REALLOC_CALLBACK = Option<
    unsafe extern "C" fn(
        ptr: *mut c_void,
        size: c_uint,
        type_: FMOD_MEMORY_TYPE,
        sourcestr: *const c_char,
    ) -> *mut c_void,
>;
pub type FMOD_MEMORY_FREE_CALLBACK = Option<
    unsafe extern "C" fn(ptr: *mut c_void, type_: FMOD_MEMORY_TYPE, sourcestr: *const c_char),
>;
pub type FMOD_3D_ROLLOFF_CALLBACK = Option<
    unsafe extern "C" fn(channelcontrol: *mut FMOD_CHANNELCONTROL, distance: c_float) -> c_float,
>;
pub type FMOD_CODEC_OPEN_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        usermode: FMOD_MODE,
        userexinfo: *mut FMOD_CREATESOUNDEXINFO,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_CLOSE_CALLBACK =
Option<unsafe extern "C" fn(codec_state: *mut FMOD_CODEC_STATE) -> FMOD_RESULT>;
pub type FMOD_CODEC_READ_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        buffer: *mut c_void,
        samples_in: c_uint,
        samples_out: *mut c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_GETLENGTH_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        length: *mut c_uint,
        lengthtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_SETPOSITION_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        subsound: c_int,
        position: c_uint,
        postype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_GETPOSITION_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        position: *mut c_uint,
        postype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_SOUNDCREATE_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        subsound: c_int,
        sound: *mut FMOD_SOUND,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_GETWAVEFORMAT_CALLBACK = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        index: c_int,
        waveformat: *mut FMOD_CODEC_WAVEFORMAT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_METADATA_FUNC = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        tagtype: FMOD_TAGTYPE,
        name: *mut c_char,
        data: *mut c_void,
        datalen: c_uint,
        datatype: FMOD_TAGDATATYPE,
        unique: c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_ALLOC_FUNC = Option<
    unsafe extern "C" fn(
        size: c_uint,
        align: c_uint,
        file: *const c_char,
        line: c_int,
    ) -> *mut c_void,
>;
pub type FMOD_CODEC_FREE_FUNC =
Option<unsafe extern "C" fn(ptr: *mut c_void, file: *const c_char, line: c_int)>;
pub type FMOD_CODEC_LOG_FUNC = Option<
    unsafe extern "C" fn(
        level: FMOD_DEBUG_FLAGS,
        file: *const c_char,
        line: c_int,
        function: *const c_char,
        string: *const c_char,
        ...
    ),
>;
pub type FMOD_CODEC_FILE_READ_FUNC = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        buffer: *mut c_void,
        sizebytes: c_uint,
        bytesread: *mut c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_FILE_SEEK_FUNC = Option<
    unsafe extern "C" fn(
        codec_state: *mut FMOD_CODEC_STATE,
        pos: c_uint,
        method: FMOD_CODEC_SEEK_METHOD,
    ) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_FILE_TELL_FUNC = Option<
    unsafe extern "C" fn(codec_state: *mut FMOD_CODEC_STATE, pos: *mut c_uint) -> FMOD_RESULT,
>;
pub type FMOD_CODEC_FILE_SIZE_FUNC = Option<
    unsafe extern "C" fn(codec_state: *mut FMOD_CODEC_STATE, size: *mut c_uint) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_GETNUMDRIVERS_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        numdrivers: *mut c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_GETDRIVERINFO_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        id: c_int,
        name: *mut c_char,
        namelen: c_int,
        guid: *mut FMOD_GUID,
        systemrate: *mut c_int,
        speakermode: *mut FMOD_SPEAKERMODE,
        speakermodechannels: *mut c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_INIT_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        selecteddriver: c_int,
        flags: FMOD_INITFLAGS,
        outputrate: *mut c_int,
        speakermode: *mut FMOD_SPEAKERMODE,
        speakermodechannels: *mut c_int,
        outputformat: *mut FMOD_SOUND_FORMAT,
        dspbufferlength: c_int,
        dspnumbuffers: *mut c_int,
        dspnumadditionalbuffers: *mut c_int,
        extradriverdata: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_START_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_STOP_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_CLOSE_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_UPDATE_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_GETHANDLE_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        handle: *mut *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_MIXER_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_OBJECT3DGETINFO_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        maxhardwareobjects: *mut c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_OBJECT3DALLOC_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        object3d: *mut *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_OBJECT3DFREE_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        object3d: *mut c_void,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_OBJECT3DUPDATE_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        object3d: *mut c_void,
        info: *const FMOD_OUTPUT_OBJECT3DINFO,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_OPENPORT_CALLBACK = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        portType: FMOD_PORT_TYPE,
        portIndex: FMOD_PORT_INDEX,
        portId: *mut c_int,
        portRate: *mut c_int,
        portChannels: *mut c_int,
        portFormat: *mut FMOD_SOUND_FORMAT,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_CLOSEPORT_CALLBACK = Option<
    unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE, portId: c_int) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_DEVICELISTCHANGED_CALLBACK =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_READFROMMIXER_FUNC = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        buffer: *mut c_void,
        length: c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_COPYPORT_FUNC = Option<
    unsafe extern "C" fn(
        output_state: *mut FMOD_OUTPUT_STATE,
        portId: c_int,
        buffer: *mut c_void,
        length: c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_OUTPUT_REQUESTRESET_FUNC =
Option<unsafe extern "C" fn(output_state: *mut FMOD_OUTPUT_STATE) -> FMOD_RESULT>;
pub type FMOD_OUTPUT_ALLOC_FUNC = Option<
    unsafe extern "C" fn(
        size: c_uint,
        align: c_uint,
        file: *const c_char,
        line: c_int,
    ) -> *mut c_void,
>;
pub type FMOD_OUTPUT_FREE_FUNC =
Option<unsafe extern "C" fn(ptr: *mut c_void, file: *const c_char, line: c_int)>;
pub type FMOD_OUTPUT_LOG_FUNC = Option<
    unsafe extern "C" fn(
        level: FMOD_DEBUG_FLAGS,
        file: *const c_char,
        line: c_int,
        function: *const c_char,
        string: *const c_char,
        ...
    ),
>;
pub type FMOD_DSP_CREATE_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE) -> FMOD_RESULT>;
pub type FMOD_DSP_RELEASE_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE) -> FMOD_RESULT>;
pub type FMOD_DSP_RESET_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE) -> FMOD_RESULT>;
pub type FMOD_DSP_READ_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        inbuffer: *mut c_float,
        outbuffer: *mut c_float,
        length: c_uint,
        inchannels: c_int,
        outchannels: *mut c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PROCESS_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        length: c_uint,
        inbufferarray: *const FMOD_DSP_BUFFER_ARRAY,
        outbufferarray: *mut FMOD_DSP_BUFFER_ARRAY,
        inputsidle: FMOD_BOOL,
        op: FMOD_DSP_PROCESS_OPERATION,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SETPOSITION_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, pos: c_uint) -> FMOD_RESULT>;
pub type FMOD_DSP_SHOULDIPROCESS_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        inputsidle: FMOD_BOOL,
        length: c_uint,
        inmask: FMOD_CHANNELMASK,
        inchannels: c_int,
        speakermode: FMOD_SPEAKERMODE,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SETPARAM_FLOAT_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        value: c_float,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SETPARAM_INT_CALLBACK = Option<
    unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, index: c_int, value: c_int) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SETPARAM_BOOL_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        value: FMOD_BOOL,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SETPARAM_DATA_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        data: *mut c_void,
        length: c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETPARAM_FLOAT_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        value: *mut c_float,
        valuestr: *mut c_char,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETPARAM_INT_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        value: *mut c_int,
        valuestr: *mut c_char,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETPARAM_BOOL_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        value: *mut FMOD_BOOL,
        valuestr: *mut c_char,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETPARAM_DATA_CALLBACK = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        index: c_int,
        data: *mut *mut c_void,
        length: *mut c_uint,
        valuestr: *mut c_char,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_SYSTEM_REGISTER_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE) -> FMOD_RESULT>;
pub type FMOD_DSP_SYSTEM_DEREGISTER_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE) -> FMOD_RESULT>;
pub type FMOD_DSP_SYSTEM_MIX_CALLBACK =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, stage: c_int) -> FMOD_RESULT>;
pub type FMOD_DSP_ALLOC_FUNC = Option<
    unsafe extern "C" fn(
        size: c_uint,
        type_: FMOD_MEMORY_TYPE,
        sourcestr: *const c_char,
    ) -> *mut c_void,
>;
pub type FMOD_DSP_REALLOC_FUNC = Option<
    unsafe extern "C" fn(
        ptr: *mut c_void,
        size: c_uint,
        type_: FMOD_MEMORY_TYPE,
        sourcestr: *const c_char,
    ) -> *mut c_void,
>;
pub type FMOD_DSP_FREE_FUNC = Option<
    unsafe extern "C" fn(ptr: *mut c_void, type_: FMOD_MEMORY_TYPE, sourcestr: *const c_char),
>;
pub type FMOD_DSP_LOG_FUNC = Option<
    unsafe extern "C" fn(
        level: FMOD_DEBUG_FLAGS,
        file: *const c_char,
        line: c_int,
        function: *const c_char,
        string: *const c_char,
        ...
    ),
>;
pub type FMOD_DSP_GETSAMPLERATE_FUNC =
Option<unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, rate: *mut c_int) -> FMOD_RESULT>;
pub type FMOD_DSP_GETBLOCKSIZE_FUNC = Option<
    unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, blocksize: *mut c_uint) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETSPEAKERMODE_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        speakermode_mixer: *mut FMOD_SPEAKERMODE,
        speakermode_output: *mut FMOD_SPEAKERMODE,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETCLOCK_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        clock: *mut c_ulonglong,
        offset: *mut c_uint,
        length: *mut c_uint,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETLISTENERATTRIBUTES_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        numlisteners: *mut c_int,
        attributes: *mut FMOD_3D_ATTRIBUTES,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_GETUSERDATA_FUNC = Option<
    unsafe extern "C" fn(dsp_state: *mut FMOD_DSP_STATE, userdata: *mut *mut c_void) -> FMOD_RESULT,
>;
pub type FMOD_DSP_DFT_FFTREAL_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        size: c_int,
        signal: *const c_float,
        dft: *mut FMOD_COMPLEX,
        window: *const c_float,
        signalhop: c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_DFT_IFFTREAL_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        size: c_int,
        dft: *const FMOD_COMPLEX,
        signal: *mut c_float,
        window: *const c_float,
        signalhop: c_int,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_SUMMONOMATRIX_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        sourceSpeakerMode: FMOD_SPEAKERMODE,
        lowFrequencyGain: c_float,
        overallGain: c_float,
        matrix: *mut c_float,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_SUMSTEREOMATRIX_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        sourceSpeakerMode: FMOD_SPEAKERMODE,
        pan: c_float,
        lowFrequencyGain: c_float,
        overallGain: c_float,
        matrixHop: c_int,
        matrix: *mut c_float,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_SUMSURROUNDMATRIX_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        sourceSpeakerMode: FMOD_SPEAKERMODE,
        targetSpeakerMode: FMOD_SPEAKERMODE,
        direction: c_float,
        extent: c_float,
        rotation: c_float,
        lowFrequencyGain: c_float,
        overallGain: c_float,
        matrixHop: c_int,
        matrix: *mut c_float,
        flags: FMOD_DSP_PAN_SURROUND_FLAGS,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_SUMMONOTOSURROUNDMATRIX_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        targetSpeakerMode: FMOD_SPEAKERMODE,
        direction: c_float,
        extent: c_float,
        lowFrequencyGain: c_float,
        overallGain: c_float,
        matrixHop: c_int,
        matrix: *mut c_float,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_SUMSTEREOTOSURROUNDMATRIX_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        targetSpeakerMode: FMOD_SPEAKERMODE,
        direction: c_float,
        extent: c_float,
        rotation: c_float,
        lowFrequencyGain: c_float,
        overallGain: c_float,
        matrixHop: c_int,
        matrix: *mut c_float,
    ) -> FMOD_RESULT,
>;
pub type FMOD_DSP_PAN_GETROLLOFFGAIN_FUNC = Option<
    unsafe extern "C" fn(
        dsp_state: *mut FMOD_DSP_STATE,
        rolloff: FMOD_DSP_PAN_3D_ROLLOFF_TYPE,
        distance: c_float,
        mindistance: c_float,
        maxdistance: c_float,
        gain: *mut c_float,
    ) -> FMOD_RESULT,
>;

#[link(name = "fmodstudio")]
extern "C" {
    pub fn FMOD_Studio_ParseID(idstring: *const c_char, id: *mut FMOD_GUID) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_Create(
        system: *mut *mut FMOD_STUDIO_SYSTEM,
        headerversion: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_IsValid(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_BOOL;
    pub fn FMOD_Studio_System_SetAdvancedSettings(
        system: *mut FMOD_STUDIO_SYSTEM,
        settings: *mut FMOD_STUDIO_ADVANCEDSETTINGS,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetAdvancedSettings(
        system: *mut FMOD_STUDIO_SYSTEM,
        settings: *mut FMOD_STUDIO_ADVANCEDSETTINGS,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_Initialize(
        system: *mut FMOD_STUDIO_SYSTEM,
        maxchannels: c_int,
        studioflags: FMOD_STUDIO_INITFLAGS,
        flags: FMOD_INITFLAGS,
        extradriverdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_Release(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_Update(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetCoreSystem(
        system: *mut FMOD_STUDIO_SYSTEM,
        coresystem: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetEvent(
        system: *mut FMOD_STUDIO_SYSTEM,
        pathOrID: *const c_char,
        event: *mut *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBus(
        system: *mut FMOD_STUDIO_SYSTEM,
        pathOrID: *const c_char,
        bus: *mut *mut FMOD_STUDIO_BUS,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetVCA(
        system: *mut FMOD_STUDIO_SYSTEM,
        pathOrID: *const c_char,
        vca: *mut *mut FMOD_STUDIO_VCA,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBank(
        system: *mut FMOD_STUDIO_SYSTEM,
        pathOrID: *const c_char,
        bank: *mut *mut FMOD_STUDIO_BANK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetEventByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: *const FMOD_GUID,
        event: *mut *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBusByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: *const FMOD_GUID,
        bus: *mut *mut FMOD_STUDIO_BUS,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetVCAByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: *const FMOD_GUID,
        vca: *mut *mut FMOD_STUDIO_VCA,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBankByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: *const FMOD_GUID,
        bank: *mut *mut FMOD_STUDIO_BANK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetSoundInfo(
        system: *mut FMOD_STUDIO_SYSTEM,
        key: *const c_char,
        info: *mut FMOD_STUDIO_SOUND_INFO,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterDescriptionByName(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
        parameter: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterDescriptionByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: FMOD_STUDIO_PARAMETER_ID,
        parameter: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterLabelByName(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
        labelindex: c_int,
        label: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterLabelByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: FMOD_STUDIO_PARAMETER_ID,
        labelindex: c_int,
        label: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: FMOD_STUDIO_PARAMETER_ID,
        value: *mut c_float,
        finalvalue: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetParameterByID(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: FMOD_STUDIO_PARAMETER_ID,
        value: c_float,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetParameterByIDWithLabel(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: FMOD_STUDIO_PARAMETER_ID,
        label: *const c_char,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetParametersByIDs(
        system: *mut FMOD_STUDIO_SYSTEM,
        ids: *const FMOD_STUDIO_PARAMETER_ID,
        values: *mut c_float,
        count: c_int,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterByName(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
        value: *mut c_float,
        finalvalue: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetParameterByName(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
        value: c_float,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetParameterByNameWithLabel(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
        label: *const c_char,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LookupID(
        system: *mut FMOD_STUDIO_SYSTEM,
        path: *const c_char,
        id: *mut FMOD_GUID,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LookupPath(
        system: *mut FMOD_STUDIO_SYSTEM,
        id: *const FMOD_GUID,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetNumListeners(
        system: *mut FMOD_STUDIO_SYSTEM,
        numlisteners: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetNumListeners(
        system: *mut FMOD_STUDIO_SYSTEM,
        numlisteners: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetListenerAttributes(
        system: *mut FMOD_STUDIO_SYSTEM,
        index: c_int,
        attributes: *mut FMOD_3D_ATTRIBUTES,
        attenuationposition: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetListenerAttributes(
        system: *mut FMOD_STUDIO_SYSTEM,
        index: c_int,
        attributes: *const FMOD_3D_ATTRIBUTES,
        attenuationposition: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetListenerWeight(
        system: *mut FMOD_STUDIO_SYSTEM,
        index: c_int,
        weight: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetListenerWeight(
        system: *mut FMOD_STUDIO_SYSTEM,
        index: c_int,
        weight: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LoadBankFile(
        system: *mut FMOD_STUDIO_SYSTEM,
        filename: *const c_char,
        flags: FMOD_STUDIO_LOAD_BANK_FLAGS,
        bank: *mut *mut FMOD_STUDIO_BANK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LoadBankMemory(
        system: *mut FMOD_STUDIO_SYSTEM,
        buffer: *const c_char,
        length: c_int,
        mode: FMOD_STUDIO_LOAD_MEMORY_MODE,
        flags: FMOD_STUDIO_LOAD_BANK_FLAGS,
        bank: *mut *mut FMOD_STUDIO_BANK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LoadBankCustom(
        system: *mut FMOD_STUDIO_SYSTEM,
        info: *const FMOD_STUDIO_BANK_INFO,
        flags: FMOD_STUDIO_LOAD_BANK_FLAGS,
        bank: *mut *mut FMOD_STUDIO_BANK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_RegisterPlugin(
        system: *mut FMOD_STUDIO_SYSTEM,
        description: *const FMOD_DSP_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_UnregisterPlugin(
        system: *mut FMOD_STUDIO_SYSTEM,
        name: *const c_char,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_UnloadAll(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_FlushCommands(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_FlushSampleLoading(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_StartCommandCapture(
        system: *mut FMOD_STUDIO_SYSTEM,
        filename: *const c_char,
        flags: FMOD_STUDIO_COMMANDCAPTURE_FLAGS,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_StopCommandCapture(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_LoadCommandReplay(
        system: *mut FMOD_STUDIO_SYSTEM,
        filename: *const c_char,
        flags: FMOD_STUDIO_COMMANDREPLAY_FLAGS,
        replay: *mut *mut FMOD_STUDIO_COMMANDREPLAY,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBankCount(
        system: *mut FMOD_STUDIO_SYSTEM,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBankList(
        system: *mut FMOD_STUDIO_SYSTEM,
        array: *mut *mut FMOD_STUDIO_BANK,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterDescriptionCount(
        system: *mut FMOD_STUDIO_SYSTEM,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetParameterDescriptionList(
        system: *mut FMOD_STUDIO_SYSTEM,
        array: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetCPUUsage(
        system: *mut FMOD_STUDIO_SYSTEM,
        usage: *mut FMOD_STUDIO_CPU_USAGE,
        usage_core: *mut FMOD_CPU_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetBufferUsage(
        system: *mut FMOD_STUDIO_SYSTEM,
        usage: *mut FMOD_STUDIO_BUFFER_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_ResetBufferUsage(system: *mut FMOD_STUDIO_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetCallback(
        system: *mut FMOD_STUDIO_SYSTEM,
        callback: FMOD_STUDIO_SYSTEM_CALLBACK,
        callbackmask: FMOD_STUDIO_SYSTEM_CALLBACK_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_SetUserData(
        system: *mut FMOD_STUDIO_SYSTEM,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetUserData(
        system: *mut FMOD_STUDIO_SYSTEM,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_System_GetMemoryUsage(
        system: *mut FMOD_STUDIO_SYSTEM,
        memoryusage: *mut FMOD_STUDIO_MEMORY_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_IsValid(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_BOOL;
    pub fn FMOD_Studio_EventDescription_GetID(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        id: *mut FMOD_GUID,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetPath(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterDescriptionCount(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterDescriptionByIndex(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        index: c_int,
        parameter: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterDescriptionByName(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        name: *const c_char,
        parameter: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterDescriptionByID(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        id: FMOD_STUDIO_PARAMETER_ID,
        parameter: *mut FMOD_STUDIO_PARAMETER_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterLabelByIndex(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        index: c_int,
        labelindex: c_int,
        label: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterLabelByName(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        name: *const c_char,
        labelindex: c_int,
        label: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetParameterLabelByID(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        id: FMOD_STUDIO_PARAMETER_ID,
        labelindex: c_int,
        label: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetUserPropertyCount(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetUserPropertyByIndex(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        index: c_int,
        property: *mut FMOD_STUDIO_USER_PROPERTY,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetUserProperty(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        name: *const c_char,
        property: *mut FMOD_STUDIO_USER_PROPERTY,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetLength(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        length: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetMinMaxDistance(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        min: *mut c_float,
        max: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetSoundSize(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        size: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_IsSnapshot(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        snapshot: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_IsOneshot(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        oneshot: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_IsStream(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        isStream: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_Is3D(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        is3D: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_IsDopplerEnabled(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        doppler: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_HasSustainPoint(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        sustainPoint: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_CreateInstance(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        instance: *mut *mut FMOD_STUDIO_EVENTINSTANCE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetInstanceCount(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetInstanceList(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        array: *mut *mut FMOD_STUDIO_EVENTINSTANCE,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_LoadSampleData(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_UnloadSampleData(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetSampleLoadingState(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        state: *mut FMOD_STUDIO_LOADING_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_ReleaseAllInstances(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_SetCallback(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        callback: FMOD_STUDIO_EVENT_CALLBACK,
        callbackmask: FMOD_STUDIO_EVENT_CALLBACK_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_GetUserData(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventDescription_SetUserData(
        eventdescription: *mut FMOD_STUDIO_EVENTDESCRIPTION,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_IsValid(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
    ) -> FMOD_BOOL;
    pub fn FMOD_Studio_EventInstance_GetDescription(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        description: *mut *mut FMOD_STUDIO_EVENTDESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetVolume(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        volume: *mut c_float,
        finalvolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetVolume(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetPitch(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        pitch: *mut c_float,
        finalpitch: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetPitch(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        pitch: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_Get3DAttributes(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        attributes: *mut FMOD_3D_ATTRIBUTES,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_Set3DAttributes(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        attributes: *mut FMOD_3D_ATTRIBUTES,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetListenerMask(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        mask: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetListenerMask(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        mask: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetProperty(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        index: FMOD_STUDIO_EVENT_PROPERTY,
        value: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetProperty(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        index: FMOD_STUDIO_EVENT_PROPERTY,
        value: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetReverbLevel(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        index: c_int,
        level: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetReverbLevel(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        index: c_int,
        level: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetPaused(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        paused: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetPaused(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        paused: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_Start(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_Stop(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        mode: FMOD_STUDIO_STOP_MODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetTimelinePosition(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        position: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetTimelinePosition(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        position: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetPlaybackState(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        state: *mut FMOD_STUDIO_PLAYBACK_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetChannelGroup(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        group: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetMinMaxDistance(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        min: *mut c_float,
        max: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_Release(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_IsVirtual(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        virtualstate: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetParameterByName(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        name: *const c_char,
        value: *mut c_float,
        finalvalue: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetParameterByName(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        name: *const c_char,
        value: c_float,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetParameterByNameWithLabel(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        name: *const c_char,
        label: *const c_char,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetParameterByID(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        id: FMOD_STUDIO_PARAMETER_ID,
        value: *mut c_float,
        finalvalue: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetParameterByID(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        id: FMOD_STUDIO_PARAMETER_ID,
        value: c_float,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetParameterByIDWithLabel(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        id: FMOD_STUDIO_PARAMETER_ID,
        label: *const c_char,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetParametersByIDs(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        ids: *const FMOD_STUDIO_PARAMETER_ID,
        values: *mut c_float,
        count: c_int,
        ignoreseekspeed: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_KeyOff(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetCallback(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        callback: FMOD_STUDIO_EVENT_CALLBACK,
        callbackmask: FMOD_STUDIO_EVENT_CALLBACK_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetUserData(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_SetUserData(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetCPUUsage(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        exclusive: *mut c_uint,
        inclusive: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_EventInstance_GetMemoryUsage(
        eventinstance: *mut FMOD_STUDIO_EVENTINSTANCE,
        memoryusage: *mut FMOD_STUDIO_MEMORY_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_IsValid(bus: *mut FMOD_STUDIO_BUS) -> FMOD_BOOL;
    pub fn FMOD_Studio_Bus_GetID(bus: *mut FMOD_STUDIO_BUS, id: *mut FMOD_GUID) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetPath(
        bus: *mut FMOD_STUDIO_BUS,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetVolume(
        bus: *mut FMOD_STUDIO_BUS,
        volume: *mut c_float,
        finalvolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_SetVolume(bus: *mut FMOD_STUDIO_BUS, volume: c_float) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetPaused(
        bus: *mut FMOD_STUDIO_BUS,
        paused: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_SetPaused(bus: *mut FMOD_STUDIO_BUS, paused: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetMute(bus: *mut FMOD_STUDIO_BUS, mute: *mut FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_SetMute(bus: *mut FMOD_STUDIO_BUS, mute: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_StopAllEvents(
        bus: *mut FMOD_STUDIO_BUS,
        mode: FMOD_STUDIO_STOP_MODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetPortIndex(
        bus: *mut FMOD_STUDIO_BUS,
        index: *mut FMOD_PORT_INDEX,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_SetPortIndex(
        bus: *mut FMOD_STUDIO_BUS,
        index: FMOD_PORT_INDEX,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_LockChannelGroup(bus: *mut FMOD_STUDIO_BUS) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_UnlockChannelGroup(bus: *mut FMOD_STUDIO_BUS) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetChannelGroup(
        bus: *mut FMOD_STUDIO_BUS,
        group: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetCPUUsage(
        bus: *mut FMOD_STUDIO_BUS,
        exclusive: *mut c_uint,
        inclusive: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bus_GetMemoryUsage(
        bus: *mut FMOD_STUDIO_BUS,
        memoryusage: *mut FMOD_STUDIO_MEMORY_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_VCA_IsValid(vca: *mut FMOD_STUDIO_VCA) -> FMOD_BOOL;
    pub fn FMOD_Studio_VCA_GetID(vca: *mut FMOD_STUDIO_VCA, id: *mut FMOD_GUID) -> FMOD_RESULT;
    pub fn FMOD_Studio_VCA_GetPath(
        vca: *mut FMOD_STUDIO_VCA,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_VCA_GetVolume(
        vca: *mut FMOD_STUDIO_VCA,
        volume: *mut c_float,
        finalvolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_VCA_SetVolume(vca: *mut FMOD_STUDIO_VCA, volume: c_float) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_IsValid(bank: *mut FMOD_STUDIO_BANK) -> FMOD_BOOL;
    pub fn FMOD_Studio_Bank_GetID(bank: *mut FMOD_STUDIO_BANK, id: *mut FMOD_GUID) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetPath(
        bank: *mut FMOD_STUDIO_BANK,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_Unload(bank: *mut FMOD_STUDIO_BANK) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_LoadSampleData(bank: *mut FMOD_STUDIO_BANK) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_UnloadSampleData(bank: *mut FMOD_STUDIO_BANK) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetLoadingState(
        bank: *mut FMOD_STUDIO_BANK,
        state: *mut FMOD_STUDIO_LOADING_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetSampleLoadingState(
        bank: *mut FMOD_STUDIO_BANK,
        state: *mut FMOD_STUDIO_LOADING_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetStringCount(
        bank: *mut FMOD_STUDIO_BANK,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetStringInfo(
        bank: *mut FMOD_STUDIO_BANK,
        index: c_int,
        id: *mut FMOD_GUID,
        path: *mut c_char,
        size: c_int,
        retrieved: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetEventCount(
        bank: *mut FMOD_STUDIO_BANK,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetEventList(
        bank: *mut FMOD_STUDIO_BANK,
        array: *mut *mut FMOD_STUDIO_EVENTDESCRIPTION,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetBusCount(
        bank: *mut FMOD_STUDIO_BANK,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetBusList(
        bank: *mut FMOD_STUDIO_BANK,
        array: *mut *mut FMOD_STUDIO_BUS,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetVCACount(
        bank: *mut FMOD_STUDIO_BANK,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetVCAList(
        bank: *mut FMOD_STUDIO_BANK,
        array: *mut *mut FMOD_STUDIO_VCA,
        capacity: c_int,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_GetUserData(
        bank: *mut FMOD_STUDIO_BANK,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_Bank_SetUserData(
        bank: *mut FMOD_STUDIO_BANK,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_IsValid(replay: *mut FMOD_STUDIO_COMMANDREPLAY) -> FMOD_BOOL;
    pub fn FMOD_Studio_CommandReplay_GetSystem(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        system: *mut *mut FMOD_STUDIO_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetLength(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        length: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetCommandCount(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetCommandInfo(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
        info: *mut FMOD_STUDIO_COMMAND_INFO,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetCommandString(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
        buffer: *mut c_char,
        length: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetCommandAtTime(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        time: c_float,
        commandindex: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetBankPath(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        bankPath: *const c_char,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_Start(replay: *mut FMOD_STUDIO_COMMANDREPLAY) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_Stop(replay: *mut FMOD_STUDIO_COMMANDREPLAY) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SeekToTime(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        time: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SeekToCommand(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetPaused(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        paused: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetPaused(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        paused: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetPlaybackState(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        state: *mut FMOD_STUDIO_PLAYBACK_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetCurrentCommand(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        commandindex: *mut c_int,
        currenttime: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_Release(replay: *mut FMOD_STUDIO_COMMANDREPLAY)
                                             -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetFrameCallback(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        callback: FMOD_STUDIO_COMMANDREPLAY_FRAME_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetLoadBankCallback(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        callback: FMOD_STUDIO_COMMANDREPLAY_LOAD_BANK_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetCreateInstanceCallback(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        callback: FMOD_STUDIO_COMMANDREPLAY_CREATE_INSTANCE_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_GetUserData(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Studio_CommandReplay_SetUserData(
        replay: *mut FMOD_STUDIO_COMMANDREPLAY,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
}

#[link(name = "fmod")]
extern "C" {
    pub fn FMOD_Memory_Initialize(
        poolmem: *mut c_void,
        poollen: c_int,
        useralloc: FMOD_MEMORY_ALLOC_CALLBACK,
        userrealloc: FMOD_MEMORY_REALLOC_CALLBACK,
        userfree: FMOD_MEMORY_FREE_CALLBACK,
        memtypeflags: FMOD_MEMORY_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_Memory_GetStats(
        currentalloced: *mut c_int,
        maxalloced: *mut c_int,
        blocking: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Debug_Initialize(
        flags: FMOD_DEBUG_FLAGS,
        mode: FMOD_DEBUG_MODE,
        callback: FMOD_DEBUG_CALLBACK,
        filename: *const c_char,
    ) -> FMOD_RESULT;
    pub fn FMOD_File_SetDiskBusy(busy: c_int) -> FMOD_RESULT;
    pub fn FMOD_File_GetDiskBusy(busy: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_Thread_SetAttributes(
        type_: FMOD_THREAD_TYPE,
        affinity: FMOD_THREAD_AFFINITY,
        priority: FMOD_THREAD_PRIORITY,
        stacksize: FMOD_THREAD_STACK_SIZE,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Create(system: *mut *mut FMOD_SYSTEM, headerversion: c_uint) -> FMOD_RESULT;
    pub fn FMOD_System_Release(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_SetOutput(system: *mut FMOD_SYSTEM, output: FMOD_OUTPUTTYPE) -> FMOD_RESULT;
    pub fn FMOD_System_GetOutput(
        system: *mut FMOD_SYSTEM,
        output: *mut FMOD_OUTPUTTYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetNumDrivers(
        system: *mut FMOD_SYSTEM,
        numdrivers: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetDriverInfo(
        system: *mut FMOD_SYSTEM,
        id: c_int,
        name: *mut c_char,
        namelen: c_int,
        guid: *mut FMOD_GUID,
        systemrate: *mut c_int,
        speakermode: *mut FMOD_SPEAKERMODE,
        speakermodechannels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetDriver(system: *mut FMOD_SYSTEM, driver: c_int) -> FMOD_RESULT;
    pub fn FMOD_System_GetDriver(system: *mut FMOD_SYSTEM, driver: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_System_SetSoftwareChannels(
        system: *mut FMOD_SYSTEM,
        numsoftwarechannels: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetSoftwareChannels(
        system: *mut FMOD_SYSTEM,
        numsoftwarechannels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetSoftwareFormat(
        system: *mut FMOD_SYSTEM,
        samplerate: c_int,
        speakermode: FMOD_SPEAKERMODE,
        numrawspeakers: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetSoftwareFormat(
        system: *mut FMOD_SYSTEM,
        samplerate: *mut c_int,
        speakermode: *mut FMOD_SPEAKERMODE,
        numrawspeakers: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetDSPBufferSize(
        system: *mut FMOD_SYSTEM,
        bufferlength: c_uint,
        numbuffers: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetDSPBufferSize(
        system: *mut FMOD_SYSTEM,
        bufferlength: *mut c_uint,
        numbuffers: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetFileSystem(
        system: *mut FMOD_SYSTEM,
        useropen: FMOD_FILE_OPEN_CALLBACK,
        userclose: FMOD_FILE_CLOSE_CALLBACK,
        userread: FMOD_FILE_READ_CALLBACK,
        userseek: FMOD_FILE_SEEK_CALLBACK,
        userasyncread: FMOD_FILE_ASYNCREAD_CALLBACK,
        userasynccancel: FMOD_FILE_ASYNCCANCEL_CALLBACK,
        blockalign: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_AttachFileSystem(
        system: *mut FMOD_SYSTEM,
        useropen: FMOD_FILE_OPEN_CALLBACK,
        userclose: FMOD_FILE_CLOSE_CALLBACK,
        userread: FMOD_FILE_READ_CALLBACK,
        userseek: FMOD_FILE_SEEK_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetAdvancedSettings(
        system: *mut FMOD_SYSTEM,
        settings: *mut FMOD_ADVANCEDSETTINGS,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetAdvancedSettings(
        system: *mut FMOD_SYSTEM,
        settings: *mut FMOD_ADVANCEDSETTINGS,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetCallback(
        system: *mut FMOD_SYSTEM,
        callback: FMOD_SYSTEM_CALLBACK,
        callbackmask: FMOD_SYSTEM_CALLBACK_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetPluginPath(system: *mut FMOD_SYSTEM, path: *const c_char) -> FMOD_RESULT;
    pub fn FMOD_System_LoadPlugin(
        system: *mut FMOD_SYSTEM,
        filename: *const c_char,
        handle: *mut c_uint,
        priority: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_UnloadPlugin(system: *mut FMOD_SYSTEM, handle: c_uint) -> FMOD_RESULT;
    pub fn FMOD_System_GetNumNestedPlugins(
        system: *mut FMOD_SYSTEM,
        handle: c_uint,
        count: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetNestedPlugin(
        system: *mut FMOD_SYSTEM,
        handle: c_uint,
        index: c_int,
        nestedhandle: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetNumPlugins(
        system: *mut FMOD_SYSTEM,
        plugintype: FMOD_PLUGINTYPE,
        numplugins: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetPluginHandle(
        system: *mut FMOD_SYSTEM,
        plugintype: FMOD_PLUGINTYPE,
        index: c_int,
        handle: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetPluginInfo(
        system: *mut FMOD_SYSTEM,
        handle: c_uint,
        plugintype: *mut FMOD_PLUGINTYPE,
        name: *mut c_char,
        namelen: c_int,
        version: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetOutputByPlugin(system: *mut FMOD_SYSTEM, handle: c_uint) -> FMOD_RESULT;
    pub fn FMOD_System_GetOutputByPlugin(
        system: *mut FMOD_SYSTEM,
        handle: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateDSPByPlugin(
        system: *mut FMOD_SYSTEM,
        handle: c_uint,
        dsp: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetDSPInfoByPlugin(
        system: *mut FMOD_SYSTEM,
        handle: c_uint,
        description: *const *const FMOD_DSP_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_RegisterCodec(
        system: *mut FMOD_SYSTEM,
        description: *mut FMOD_CODEC_DESCRIPTION,
        handle: *mut c_uint,
        priority: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_RegisterDSP(
        system: *mut FMOD_SYSTEM,
        description: *const FMOD_DSP_DESCRIPTION,
        handle: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_RegisterOutput(
        system: *mut FMOD_SYSTEM,
        description: *const FMOD_OUTPUT_DESCRIPTION,
        handle: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Init(
        system: *mut FMOD_SYSTEM,
        maxchannels: c_int,
        flags: FMOD_INITFLAGS,
        extradriverdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Close(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_Update(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_SetSpeakerPosition(
        system: *mut FMOD_SYSTEM,
        speaker: FMOD_SPEAKER,
        x: c_float,
        y: c_float,
        active: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetSpeakerPosition(
        system: *mut FMOD_SYSTEM,
        speaker: FMOD_SPEAKER,
        x: *mut c_float,
        y: *mut c_float,
        active: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetStreamBufferSize(
        system: *mut FMOD_SYSTEM,
        filebuffersize: c_uint,
        filebuffersizetype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetStreamBufferSize(
        system: *mut FMOD_SYSTEM,
        filebuffersize: *mut c_uint,
        filebuffersizetype: *mut FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Set3DSettings(
        system: *mut FMOD_SYSTEM,
        dopplerscale: c_float,
        distancefactor: c_float,
        rolloffscale: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Get3DSettings(
        system: *mut FMOD_SYSTEM,
        dopplerscale: *mut c_float,
        distancefactor: *mut c_float,
        rolloffscale: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Set3DNumListeners(
        system: *mut FMOD_SYSTEM,
        numlisteners: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Get3DNumListeners(
        system: *mut FMOD_SYSTEM,
        numlisteners: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Set3DListenerAttributes(
        system: *mut FMOD_SYSTEM,
        listener: c_int,
        pos: *const FMOD_VECTOR,
        vel: *const FMOD_VECTOR,
        forward: *const FMOD_VECTOR,
        up: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Get3DListenerAttributes(
        system: *mut FMOD_SYSTEM,
        listener: c_int,
        pos: *mut FMOD_VECTOR,
        vel: *mut FMOD_VECTOR,
        forward: *mut FMOD_VECTOR,
        up: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_Set3DRolloffCallback(
        system: *mut FMOD_SYSTEM,
        callback: FMOD_3D_ROLLOFF_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_MixerSuspend(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_MixerResume(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_GetDefaultMixMatrix(
        system: *mut FMOD_SYSTEM,
        sourcespeakermode: FMOD_SPEAKERMODE,
        targetspeakermode: FMOD_SPEAKERMODE,
        matrix: *mut c_float,
        matrixhop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetSpeakerModeChannels(
        system: *mut FMOD_SYSTEM,
        mode: FMOD_SPEAKERMODE,
        channels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetVersion(system: *mut FMOD_SYSTEM, version: *mut c_uint) -> FMOD_RESULT;
    pub fn FMOD_System_GetOutputHandle(
        system: *mut FMOD_SYSTEM,
        handle: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetChannelsPlaying(
        system: *mut FMOD_SYSTEM,
        channels: *mut c_int,
        realchannels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetCPUUsage(
        system: *mut FMOD_SYSTEM,
        usage: *mut FMOD_CPU_USAGE,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetFileUsage(
        system: *mut FMOD_SYSTEM,
        sampleBytesRead: *mut c_longlong,
        streamBytesRead: *mut c_longlong,
        otherBytesRead: *mut c_longlong,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateSound(
        system: *mut FMOD_SYSTEM,
        name_or_data: *const c_char,
        mode: FMOD_MODE,
        exinfo: *mut FMOD_CREATESOUNDEXINFO,
        sound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateStream(
        system: *mut FMOD_SYSTEM,
        name_or_data: *const c_char,
        mode: FMOD_MODE,
        exinfo: *mut FMOD_CREATESOUNDEXINFO,
        sound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateDSP(
        system: *mut FMOD_SYSTEM,
        description: *const FMOD_DSP_DESCRIPTION,
        dsp: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateDSPByType(
        system: *mut FMOD_SYSTEM,
        type_: FMOD_DSP_TYPE,
        dsp: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateChannelGroup(
        system: *mut FMOD_SYSTEM,
        name: *const c_char,
        channelgroup: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateSoundGroup(
        system: *mut FMOD_SYSTEM,
        name: *const c_char,
        soundgroup: *mut *mut FMOD_SOUNDGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateReverb3D(
        system: *mut FMOD_SYSTEM,
        reverb: *mut *mut FMOD_REVERB3D,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_PlaySound(
        system: *mut FMOD_SYSTEM,
        sound: *mut FMOD_SOUND,
        channelgroup: *mut FMOD_CHANNELGROUP,
        paused: FMOD_BOOL,
        channel: *mut *mut FMOD_CHANNEL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_PlayDSP(
        system: *mut FMOD_SYSTEM,
        dsp: *mut FMOD_DSP,
        channelgroup: *mut FMOD_CHANNELGROUP,
        paused: FMOD_BOOL,
        channel: *mut *mut FMOD_CHANNEL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetChannel(
        system: *mut FMOD_SYSTEM,
        channelid: c_int,
        channel: *mut *mut FMOD_CHANNEL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetDSPInfoByType(
        system: *mut FMOD_SYSTEM,
        type_: FMOD_DSP_TYPE,
        description: *const *const FMOD_DSP_DESCRIPTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetMasterChannelGroup(
        system: *mut FMOD_SYSTEM,
        channelgroup: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetMasterSoundGroup(
        system: *mut FMOD_SYSTEM,
        soundgroup: *mut *mut FMOD_SOUNDGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_AttachChannelGroupToPort(
        system: *mut FMOD_SYSTEM,
        portType: FMOD_PORT_TYPE,
        portIndex: FMOD_PORT_INDEX,
        channelgroup: *mut FMOD_CHANNELGROUP,
        passThru: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_DetachChannelGroupFromPort(
        system: *mut FMOD_SYSTEM,
        channelgroup: *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetReverbProperties(
        system: *mut FMOD_SYSTEM,
        instance: c_int,
        prop: *const FMOD_REVERB_PROPERTIES,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetReverbProperties(
        system: *mut FMOD_SYSTEM,
        instance: c_int,
        prop: *mut FMOD_REVERB_PROPERTIES,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_LockDSP(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_UnlockDSP(system: *mut FMOD_SYSTEM) -> FMOD_RESULT;
    pub fn FMOD_System_GetRecordNumDrivers(
        system: *mut FMOD_SYSTEM,
        numdrivers: *mut c_int,
        numconnected: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetRecordDriverInfo(
        system: *mut FMOD_SYSTEM,
        id: c_int,
        name: *mut c_char,
        namelen: c_int,
        guid: *mut FMOD_GUID,
        systemrate: *mut c_int,
        speakermode: *mut FMOD_SPEAKERMODE,
        speakermodechannels: *mut c_int,
        state: *mut FMOD_DRIVER_STATE,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetRecordPosition(
        system: *mut FMOD_SYSTEM,
        id: c_int,
        position: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_RecordStart(
        system: *mut FMOD_SYSTEM,
        id: c_int,
        sound: *mut FMOD_SOUND,
        loop_: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_RecordStop(system: *mut FMOD_SYSTEM, id: c_int) -> FMOD_RESULT;
    pub fn FMOD_System_IsRecording(
        system: *mut FMOD_SYSTEM,
        id: c_int,
        recording: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_CreateGeometry(
        system: *mut FMOD_SYSTEM,
        maxpolygons: c_int,
        maxvertices: c_int,
        geometry: *mut *mut FMOD_GEOMETRY,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetGeometrySettings(
        system: *mut FMOD_SYSTEM,
        maxworldsize: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetGeometrySettings(
        system: *mut FMOD_SYSTEM,
        maxworldsize: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_LoadGeometry(
        system: *mut FMOD_SYSTEM,
        data: *const c_void,
        datasize: c_int,
        geometry: *mut *mut FMOD_GEOMETRY,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetGeometryOcclusion(
        system: *mut FMOD_SYSTEM,
        listener: *const FMOD_VECTOR,
        source: *const FMOD_VECTOR,
        direct: *mut c_float,
        reverb: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetNetworkProxy(
        system: *mut FMOD_SYSTEM,
        proxy: *const c_char,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_GetNetworkProxy(
        system: *mut FMOD_SYSTEM,
        proxy: *mut c_char,
        proxylen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetNetworkTimeout(system: *mut FMOD_SYSTEM, timeout: c_int) -> FMOD_RESULT;
    pub fn FMOD_System_GetNetworkTimeout(
        system: *mut FMOD_SYSTEM,
        timeout: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_System_SetUserData(system: *mut FMOD_SYSTEM, userdata: *mut c_void) -> FMOD_RESULT;
    pub fn FMOD_System_GetUserData(
        system: *mut FMOD_SYSTEM,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Release(sound: *mut FMOD_SOUND) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSystemObject(
        sound: *mut FMOD_SOUND,
        system: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Lock(
        sound: *mut FMOD_SOUND,
        offset: c_uint,
        length: c_uint,
        ptr1: *mut *mut c_void,
        ptr2: *mut *mut c_void,
        len1: *mut c_uint,
        len2: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Unlock(
        sound: *mut FMOD_SOUND,
        ptr1: *mut c_void,
        ptr2: *mut c_void,
        len1: c_uint,
        len2: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetDefaults(
        sound: *mut FMOD_SOUND,
        frequency: c_float,
        priority: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetDefaults(
        sound: *mut FMOD_SOUND,
        frequency: *mut c_float,
        priority: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Set3DMinMaxDistance(
        sound: *mut FMOD_SOUND,
        min: c_float,
        max: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Get3DMinMaxDistance(
        sound: *mut FMOD_SOUND,
        min: *mut c_float,
        max: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Set3DConeSettings(
        sound: *mut FMOD_SOUND,
        insideconeangle: c_float,
        outsideconeangle: c_float,
        outsidevolume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Get3DConeSettings(
        sound: *mut FMOD_SOUND,
        insideconeangle: *mut c_float,
        outsideconeangle: *mut c_float,
        outsidevolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Set3DCustomRolloff(
        sound: *mut FMOD_SOUND,
        points: *mut FMOD_VECTOR,
        numpoints: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_Get3DCustomRolloff(
        sound: *mut FMOD_SOUND,
        points: *mut *mut FMOD_VECTOR,
        numpoints: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSubSound(
        sound: *mut FMOD_SOUND,
        index: c_int,
        subsound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSubSoundParent(
        sound: *mut FMOD_SOUND,
        parentsound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetName(
        sound: *mut FMOD_SOUND,
        name: *mut c_char,
        namelen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetLength(
        sound: *mut FMOD_SOUND,
        length: *mut c_uint,
        lengthtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetFormat(
        sound: *mut FMOD_SOUND,
        type_: *mut FMOD_SOUND_TYPE,
        format: *mut FMOD_SOUND_FORMAT,
        channels: *mut c_int,
        bits: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetNumSubSounds(
        sound: *mut FMOD_SOUND,
        numsubsounds: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetNumTags(
        sound: *mut FMOD_SOUND,
        numtags: *mut c_int,
        numtagsupdated: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetTag(
        sound: *mut FMOD_SOUND,
        name: *const c_char,
        index: c_int,
        tag: *mut FMOD_TAG,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetOpenState(
        sound: *mut FMOD_SOUND,
        openstate: *mut FMOD_OPENSTATE,
        percentbuffered: *mut c_uint,
        starving: *mut FMOD_BOOL,
        diskbusy: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_ReadData(
        sound: *mut FMOD_SOUND,
        buffer: *mut c_void,
        length: c_uint,
        read: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_SeekData(sound: *mut FMOD_SOUND, pcm: c_uint) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetSoundGroup(
        sound: *mut FMOD_SOUND,
        soundgroup: *mut FMOD_SOUNDGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSoundGroup(
        sound: *mut FMOD_SOUND,
        soundgroup: *mut *mut FMOD_SOUNDGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetNumSyncPoints(
        sound: *mut FMOD_SOUND,
        numsyncpoints: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSyncPoint(
        sound: *mut FMOD_SOUND,
        index: c_int,
        point: *mut *mut FMOD_SYNCPOINT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetSyncPointInfo(
        sound: *mut FMOD_SOUND,
        point: *mut FMOD_SYNCPOINT,
        name: *mut c_char,
        namelen: c_int,
        offset: *mut c_uint,
        offsettype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_AddSyncPoint(
        sound: *mut FMOD_SOUND,
        offset: c_uint,
        offsettype: FMOD_TIMEUNIT,
        name: *const c_char,
        point: *mut *mut FMOD_SYNCPOINT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_DeleteSyncPoint(
        sound: *mut FMOD_SOUND,
        point: *mut FMOD_SYNCPOINT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetMode(sound: *mut FMOD_SOUND, mode: FMOD_MODE) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetMode(sound: *mut FMOD_SOUND, mode: *mut FMOD_MODE) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetLoopCount(sound: *mut FMOD_SOUND, loopcount: c_int) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetLoopCount(sound: *mut FMOD_SOUND, loopcount: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetLoopPoints(
        sound: *mut FMOD_SOUND,
        loopstart: c_uint,
        loopstarttype: FMOD_TIMEUNIT,
        loopend: c_uint,
        loopendtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetLoopPoints(
        sound: *mut FMOD_SOUND,
        loopstart: *mut c_uint,
        loopstarttype: FMOD_TIMEUNIT,
        loopend: *mut c_uint,
        loopendtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetMusicNumChannels(
        sound: *mut FMOD_SOUND,
        numchannels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetMusicChannelVolume(
        sound: *mut FMOD_SOUND,
        channel: c_int,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetMusicChannelVolume(
        sound: *mut FMOD_SOUND,
        channel: c_int,
        volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetMusicSpeed(sound: *mut FMOD_SOUND, speed: c_float) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetMusicSpeed(sound: *mut FMOD_SOUND, speed: *mut c_float) -> FMOD_RESULT;
    pub fn FMOD_Sound_SetUserData(sound: *mut FMOD_SOUND, userdata: *mut c_void) -> FMOD_RESULT;
    pub fn FMOD_Sound_GetUserData(
        sound: *mut FMOD_SOUND,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetSystemObject(
        channel: *mut FMOD_CHANNEL,
        system: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Stop(channel: *mut FMOD_CHANNEL) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetPaused(channel: *mut FMOD_CHANNEL, paused: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetPaused(
        channel: *mut FMOD_CHANNEL,
        paused: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetVolume(channel: *mut FMOD_CHANNEL, volume: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetVolume(channel: *mut FMOD_CHANNEL, volume: *mut c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetVolumeRamp(channel: *mut FMOD_CHANNEL, ramp: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetVolumeRamp(
        channel: *mut FMOD_CHANNEL,
        ramp: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetAudibility(
        channel: *mut FMOD_CHANNEL,
        audibility: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetPitch(channel: *mut FMOD_CHANNEL, pitch: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetPitch(channel: *mut FMOD_CHANNEL, pitch: *mut c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetMute(channel: *mut FMOD_CHANNEL, mute: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetMute(channel: *mut FMOD_CHANNEL, mute: *mut FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetReverbProperties(
        channel: *mut FMOD_CHANNEL,
        instance: c_int,
        wet: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetReverbProperties(
        channel: *mut FMOD_CHANNEL,
        instance: c_int,
        wet: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetLowPassGain(channel: *mut FMOD_CHANNEL, gain: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetLowPassGain(
        channel: *mut FMOD_CHANNEL,
        gain: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetMode(channel: *mut FMOD_CHANNEL, mode: FMOD_MODE) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetMode(channel: *mut FMOD_CHANNEL, mode: *mut FMOD_MODE) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetCallback(
        channel: *mut FMOD_CHANNEL,
        callback: FMOD_CHANNELCONTROL_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_IsPlaying(
        channel: *mut FMOD_CHANNEL,
        isplaying: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetPan(channel: *mut FMOD_CHANNEL, pan: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetMixLevelsOutput(
        channel: *mut FMOD_CHANNEL,
        frontleft: c_float,
        frontright: c_float,
        center: c_float,
        lfe: c_float,
        surroundleft: c_float,
        surroundright: c_float,
        backleft: c_float,
        backright: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetMixLevelsInput(
        channel: *mut FMOD_CHANNEL,
        levels: *mut c_float,
        numlevels: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetMixMatrix(
        channel: *mut FMOD_CHANNEL,
        matrix: *mut c_float,
        outchannels: c_int,
        inchannels: c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetMixMatrix(
        channel: *mut FMOD_CHANNEL,
        matrix: *mut c_float,
        outchannels: *mut c_int,
        inchannels: *mut c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetDSPClock(
        channel: *mut FMOD_CHANNEL,
        dspclock: *mut c_ulonglong,
        parentclock: *mut c_ulonglong,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetDelay(
        channel: *mut FMOD_CHANNEL,
        dspclock_start: c_ulonglong,
        dspclock_end: c_ulonglong,
        stopchannels: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetDelay(
        channel: *mut FMOD_CHANNEL,
        dspclock_start: *mut c_ulonglong,
        dspclock_end: *mut c_ulonglong,
        stopchannels: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_AddFadePoint(
        channel: *mut FMOD_CHANNEL,
        dspclock: c_ulonglong,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetFadePointRamp(
        channel: *mut FMOD_CHANNEL,
        dspclock: c_ulonglong,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_RemoveFadePoints(
        channel: *mut FMOD_CHANNEL,
        dspclock_start: c_ulonglong,
        dspclock_end: c_ulonglong,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetFadePoints(
        channel: *mut FMOD_CHANNEL,
        numpoints: *mut c_uint,
        point_dspclock: *mut c_ulonglong,
        point_volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetDSP(
        channel: *mut FMOD_CHANNEL,
        index: c_int,
        dsp: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_AddDSP(
        channel: *mut FMOD_CHANNEL,
        index: c_int,
        dsp: *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_RemoveDSP(channel: *mut FMOD_CHANNEL, dsp: *mut FMOD_DSP) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetNumDSPs(channel: *mut FMOD_CHANNEL, numdsps: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetDSPIndex(
        channel: *mut FMOD_CHANNEL,
        dsp: *mut FMOD_DSP,
        index: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetDSPIndex(
        channel: *mut FMOD_CHANNEL,
        dsp: *mut FMOD_DSP,
        index: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DAttributes(
        channel: *mut FMOD_CHANNEL,
        pos: *const FMOD_VECTOR,
        vel: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DAttributes(
        channel: *mut FMOD_CHANNEL,
        pos: *mut FMOD_VECTOR,
        vel: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DMinMaxDistance(
        channel: *mut FMOD_CHANNEL,
        mindistance: c_float,
        maxdistance: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DMinMaxDistance(
        channel: *mut FMOD_CHANNEL,
        mindistance: *mut c_float,
        maxdistance: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DConeSettings(
        channel: *mut FMOD_CHANNEL,
        insideconeangle: c_float,
        outsideconeangle: c_float,
        outsidevolume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DConeSettings(
        channel: *mut FMOD_CHANNEL,
        insideconeangle: *mut c_float,
        outsideconeangle: *mut c_float,
        outsidevolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DConeOrientation(
        channel: *mut FMOD_CHANNEL,
        orientation: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DConeOrientation(
        channel: *mut FMOD_CHANNEL,
        orientation: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DCustomRolloff(
        channel: *mut FMOD_CHANNEL,
        points: *mut FMOD_VECTOR,
        numpoints: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DCustomRolloff(
        channel: *mut FMOD_CHANNEL,
        points: *mut *mut FMOD_VECTOR,
        numpoints: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DOcclusion(
        channel: *mut FMOD_CHANNEL,
        directocclusion: c_float,
        reverbocclusion: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DOcclusion(
        channel: *mut FMOD_CHANNEL,
        directocclusion: *mut c_float,
        reverbocclusion: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DSpread(channel: *mut FMOD_CHANNEL, angle: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DSpread(channel: *mut FMOD_CHANNEL, angle: *mut c_float)
                                    -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DLevel(channel: *mut FMOD_CHANNEL, level: c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DLevel(channel: *mut FMOD_CHANNEL, level: *mut c_float) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DDopplerLevel(
        channel: *mut FMOD_CHANNEL,
        level: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DDopplerLevel(
        channel: *mut FMOD_CHANNEL,
        level: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Set3DDistanceFilter(
        channel: *mut FMOD_CHANNEL,
        custom: FMOD_BOOL,
        customLevel: c_float,
        centerFreq: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_Get3DDistanceFilter(
        channel: *mut FMOD_CHANNEL,
        custom: *mut FMOD_BOOL,
        customLevel: *mut c_float,
        centerFreq: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetUserData(
        channel: *mut FMOD_CHANNEL,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetUserData(
        channel: *mut FMOD_CHANNEL,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetFrequency(channel: *mut FMOD_CHANNEL, frequency: c_float)
                                     -> FMOD_RESULT;
    pub fn FMOD_Channel_GetFrequency(
        channel: *mut FMOD_CHANNEL,
        frequency: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetPriority(channel: *mut FMOD_CHANNEL, priority: c_int) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetPriority(
        channel: *mut FMOD_CHANNEL,
        priority: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetPosition(
        channel: *mut FMOD_CHANNEL,
        position: c_uint,
        postype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetPosition(
        channel: *mut FMOD_CHANNEL,
        position: *mut c_uint,
        postype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetChannelGroup(
        channel: *mut FMOD_CHANNEL,
        channelgroup: *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetChannelGroup(
        channel: *mut FMOD_CHANNEL,
        channelgroup: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetLoopCount(channel: *mut FMOD_CHANNEL, loopcount: c_int) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetLoopCount(
        channel: *mut FMOD_CHANNEL,
        loopcount: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_SetLoopPoints(
        channel: *mut FMOD_CHANNEL,
        loopstart: c_uint,
        loopstarttype: FMOD_TIMEUNIT,
        loopend: c_uint,
        loopendtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetLoopPoints(
        channel: *mut FMOD_CHANNEL,
        loopstart: *mut c_uint,
        loopstarttype: FMOD_TIMEUNIT,
        loopend: *mut c_uint,
        loopendtype: FMOD_TIMEUNIT,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_IsVirtual(
        channel: *mut FMOD_CHANNEL,
        isvirtual: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetCurrentSound(
        channel: *mut FMOD_CHANNEL,
        sound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_Channel_GetIndex(channel: *mut FMOD_CHANNEL, index: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetSystemObject(
        channelgroup: *mut FMOD_CHANNELGROUP,
        system: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Stop(channelgroup: *mut FMOD_CHANNELGROUP) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetPaused(
        channelgroup: *mut FMOD_CHANNELGROUP,
        paused: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetPaused(
        channelgroup: *mut FMOD_CHANNELGROUP,
        paused: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetVolume(
        channelgroup: *mut FMOD_CHANNELGROUP,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetVolume(
        channelgroup: *mut FMOD_CHANNELGROUP,
        volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetVolumeRamp(
        channelgroup: *mut FMOD_CHANNELGROUP,
        ramp: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetVolumeRamp(
        channelgroup: *mut FMOD_CHANNELGROUP,
        ramp: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetAudibility(
        channelgroup: *mut FMOD_CHANNELGROUP,
        audibility: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetPitch(
        channelgroup: *mut FMOD_CHANNELGROUP,
        pitch: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetPitch(
        channelgroup: *mut FMOD_CHANNELGROUP,
        pitch: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetMute(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mute: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetMute(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mute: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetReverbProperties(
        channelgroup: *mut FMOD_CHANNELGROUP,
        instance: c_int,
        wet: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetReverbProperties(
        channelgroup: *mut FMOD_CHANNELGROUP,
        instance: c_int,
        wet: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetLowPassGain(
        channelgroup: *mut FMOD_CHANNELGROUP,
        gain: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetLowPassGain(
        channelgroup: *mut FMOD_CHANNELGROUP,
        gain: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetMode(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mode: FMOD_MODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetMode(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mode: *mut FMOD_MODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetCallback(
        channelgroup: *mut FMOD_CHANNELGROUP,
        callback: FMOD_CHANNELCONTROL_CALLBACK,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_IsPlaying(
        channelgroup: *mut FMOD_CHANNELGROUP,
        isplaying: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetPan(
        channelgroup: *mut FMOD_CHANNELGROUP,
        pan: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetMixLevelsOutput(
        channelgroup: *mut FMOD_CHANNELGROUP,
        frontleft: c_float,
        frontright: c_float,
        center: c_float,
        lfe: c_float,
        surroundleft: c_float,
        surroundright: c_float,
        backleft: c_float,
        backright: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetMixLevelsInput(
        channelgroup: *mut FMOD_CHANNELGROUP,
        levels: *mut c_float,
        numlevels: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetMixMatrix(
        channelgroup: *mut FMOD_CHANNELGROUP,
        matrix: *mut c_float,
        outchannels: c_int,
        inchannels: c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetMixMatrix(
        channelgroup: *mut FMOD_CHANNELGROUP,
        matrix: *mut c_float,
        outchannels: *mut c_int,
        inchannels: *mut c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetDSPClock(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock: *mut c_ulonglong,
        parentclock: *mut c_ulonglong,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetDelay(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock_start: c_ulonglong,
        dspclock_end: c_ulonglong,
        stopchannels: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetDelay(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock_start: *mut c_ulonglong,
        dspclock_end: *mut c_ulonglong,
        stopchannels: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_AddFadePoint(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock: c_ulonglong,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetFadePointRamp(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock: c_ulonglong,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_RemoveFadePoints(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dspclock_start: c_ulonglong,
        dspclock_end: c_ulonglong,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetFadePoints(
        channelgroup: *mut FMOD_CHANNELGROUP,
        numpoints: *mut c_uint,
        point_dspclock: *mut c_ulonglong,
        point_volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetDSP(
        channelgroup: *mut FMOD_CHANNELGROUP,
        index: c_int,
        dsp: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_AddDSP(
        channelgroup: *mut FMOD_CHANNELGROUP,
        index: c_int,
        dsp: *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_RemoveDSP(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dsp: *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetNumDSPs(
        channelgroup: *mut FMOD_CHANNELGROUP,
        numdsps: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetDSPIndex(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dsp: *mut FMOD_DSP,
        index: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetDSPIndex(
        channelgroup: *mut FMOD_CHANNELGROUP,
        dsp: *mut FMOD_DSP,
        index: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DAttributes(
        channelgroup: *mut FMOD_CHANNELGROUP,
        pos: *const FMOD_VECTOR,
        vel: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DAttributes(
        channelgroup: *mut FMOD_CHANNELGROUP,
        pos: *mut FMOD_VECTOR,
        vel: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DMinMaxDistance(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mindistance: c_float,
        maxdistance: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DMinMaxDistance(
        channelgroup: *mut FMOD_CHANNELGROUP,
        mindistance: *mut c_float,
        maxdistance: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DConeSettings(
        channelgroup: *mut FMOD_CHANNELGROUP,
        insideconeangle: c_float,
        outsideconeangle: c_float,
        outsidevolume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DConeSettings(
        channelgroup: *mut FMOD_CHANNELGROUP,
        insideconeangle: *mut c_float,
        outsideconeangle: *mut c_float,
        outsidevolume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DConeOrientation(
        channelgroup: *mut FMOD_CHANNELGROUP,
        orientation: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DConeOrientation(
        channelgroup: *mut FMOD_CHANNELGROUP,
        orientation: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DCustomRolloff(
        channelgroup: *mut FMOD_CHANNELGROUP,
        points: *mut FMOD_VECTOR,
        numpoints: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DCustomRolloff(
        channelgroup: *mut FMOD_CHANNELGROUP,
        points: *mut *mut FMOD_VECTOR,
        numpoints: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DOcclusion(
        channelgroup: *mut FMOD_CHANNELGROUP,
        directocclusion: c_float,
        reverbocclusion: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DOcclusion(
        channelgroup: *mut FMOD_CHANNELGROUP,
        directocclusion: *mut c_float,
        reverbocclusion: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DSpread(
        channelgroup: *mut FMOD_CHANNELGROUP,
        angle: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DSpread(
        channelgroup: *mut FMOD_CHANNELGROUP,
        angle: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DLevel(
        channelgroup: *mut FMOD_CHANNELGROUP,
        level: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DLevel(
        channelgroup: *mut FMOD_CHANNELGROUP,
        level: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DDopplerLevel(
        channelgroup: *mut FMOD_CHANNELGROUP,
        level: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DDopplerLevel(
        channelgroup: *mut FMOD_CHANNELGROUP,
        level: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Set3DDistanceFilter(
        channelgroup: *mut FMOD_CHANNELGROUP,
        custom: FMOD_BOOL,
        customLevel: c_float,
        centerFreq: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Get3DDistanceFilter(
        channelgroup: *mut FMOD_CHANNELGROUP,
        custom: *mut FMOD_BOOL,
        customLevel: *mut c_float,
        centerFreq: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_SetUserData(
        channelgroup: *mut FMOD_CHANNELGROUP,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetUserData(
        channelgroup: *mut FMOD_CHANNELGROUP,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_Release(channelgroup: *mut FMOD_CHANNELGROUP) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_AddGroup(
        channelgroup: *mut FMOD_CHANNELGROUP,
        group: *mut FMOD_CHANNELGROUP,
        propagatedspclock: FMOD_BOOL,
        connection: *mut *mut FMOD_DSPCONNECTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetNumGroups(
        channelgroup: *mut FMOD_CHANNELGROUP,
        numgroups: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetGroup(
        channelgroup: *mut FMOD_CHANNELGROUP,
        index: c_int,
        group: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetParentGroup(
        channelgroup: *mut FMOD_CHANNELGROUP,
        group: *mut *mut FMOD_CHANNELGROUP,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetName(
        channelgroup: *mut FMOD_CHANNELGROUP,
        name: *mut c_char,
        namelen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetNumChannels(
        channelgroup: *mut FMOD_CHANNELGROUP,
        numchannels: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_ChannelGroup_GetChannel(
        channelgroup: *mut FMOD_CHANNELGROUP,
        index: c_int,
        channel: *mut *mut FMOD_CHANNEL,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_Release(soundgroup: *mut FMOD_SOUNDGROUP) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetSystemObject(
        soundgroup: *mut FMOD_SOUNDGROUP,
        system: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_SetMaxAudible(
        soundgroup: *mut FMOD_SOUNDGROUP,
        maxaudible: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetMaxAudible(
        soundgroup: *mut FMOD_SOUNDGROUP,
        maxaudible: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_SetMaxAudibleBehavior(
        soundgroup: *mut FMOD_SOUNDGROUP,
        behavior: FMOD_SOUNDGROUP_BEHAVIOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetMaxAudibleBehavior(
        soundgroup: *mut FMOD_SOUNDGROUP,
        behavior: *mut FMOD_SOUNDGROUP_BEHAVIOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_SetMuteFadeSpeed(
        soundgroup: *mut FMOD_SOUNDGROUP,
        speed: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetMuteFadeSpeed(
        soundgroup: *mut FMOD_SOUNDGROUP,
        speed: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_SetVolume(
        soundgroup: *mut FMOD_SOUNDGROUP,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetVolume(
        soundgroup: *mut FMOD_SOUNDGROUP,
        volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_Stop(soundgroup: *mut FMOD_SOUNDGROUP) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetName(
        soundgroup: *mut FMOD_SOUNDGROUP,
        name: *mut c_char,
        namelen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetNumSounds(
        soundgroup: *mut FMOD_SOUNDGROUP,
        numsounds: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetSound(
        soundgroup: *mut FMOD_SOUNDGROUP,
        index: c_int,
        sound: *mut *mut FMOD_SOUND,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetNumPlaying(
        soundgroup: *mut FMOD_SOUNDGROUP,
        numplaying: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_SetUserData(
        soundgroup: *mut FMOD_SOUNDGROUP,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_SoundGroup_GetUserData(
        soundgroup: *mut FMOD_SOUNDGROUP,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_Release(dsp: *mut FMOD_DSP) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetSystemObject(
        dsp: *mut FMOD_DSP,
        system: *mut *mut FMOD_SYSTEM,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_AddInput(
        dsp: *mut FMOD_DSP,
        input: *mut FMOD_DSP,
        connection: *mut *mut FMOD_DSPCONNECTION,
        type_: FMOD_DSPCONNECTION_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_DisconnectFrom(
        dsp: *mut FMOD_DSP,
        target: *mut FMOD_DSP,
        connection: *mut FMOD_DSPCONNECTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_DisconnectAll(
        dsp: *mut FMOD_DSP,
        inputs: FMOD_BOOL,
        outputs: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetNumInputs(dsp: *mut FMOD_DSP, numinputs: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetNumOutputs(dsp: *mut FMOD_DSP, numoutputs: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetInput(
        dsp: *mut FMOD_DSP,
        index: c_int,
        input: *mut *mut FMOD_DSP,
        inputconnection: *mut *mut FMOD_DSPCONNECTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetOutput(
        dsp: *mut FMOD_DSP,
        index: c_int,
        output: *mut *mut FMOD_DSP,
        outputconnection: *mut *mut FMOD_DSPCONNECTION,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetActive(dsp: *mut FMOD_DSP, active: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetActive(dsp: *mut FMOD_DSP, active: *mut FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetBypass(dsp: *mut FMOD_DSP, bypass: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetBypass(dsp: *mut FMOD_DSP, bypass: *mut FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetWetDryMix(
        dsp: *mut FMOD_DSP,
        prewet: c_float,
        postwet: c_float,
        dry: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetWetDryMix(
        dsp: *mut FMOD_DSP,
        prewet: *mut c_float,
        postwet: *mut c_float,
        dry: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetChannelFormat(
        dsp: *mut FMOD_DSP,
        channelmask: FMOD_CHANNELMASK,
        numchannels: c_int,
        source_speakermode: FMOD_SPEAKERMODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetChannelFormat(
        dsp: *mut FMOD_DSP,
        channelmask: *mut FMOD_CHANNELMASK,
        numchannels: *mut c_int,
        source_speakermode: *mut FMOD_SPEAKERMODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetOutputChannelFormat(
        dsp: *mut FMOD_DSP,
        inmask: FMOD_CHANNELMASK,
        inchannels: c_int,
        inspeakermode: FMOD_SPEAKERMODE,
        outmask: *mut FMOD_CHANNELMASK,
        outchannels: *mut c_int,
        outspeakermode: *mut FMOD_SPEAKERMODE,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_Reset(dsp: *mut FMOD_DSP) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetParameterFloat(
        dsp: *mut FMOD_DSP,
        index: c_int,
        value: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetParameterInt(dsp: *mut FMOD_DSP, index: c_int, value: c_int) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetParameterBool(
        dsp: *mut FMOD_DSP,
        index: c_int,
        value: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetParameterData(
        dsp: *mut FMOD_DSP,
        index: c_int,
        data: *mut c_void,
        length: c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetParameterFloat(
        dsp: *mut FMOD_DSP,
        index: c_int,
        value: *mut c_float,
        valuestr: *mut c_char,
        valuestrlen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetParameterInt(
        dsp: *mut FMOD_DSP,
        index: c_int,
        value: *mut c_int,
        valuestr: *mut c_char,
        valuestrlen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetParameterBool(
        dsp: *mut FMOD_DSP,
        index: c_int,
        value: *mut FMOD_BOOL,
        valuestr: *mut c_char,
        valuestrlen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetParameterData(
        dsp: *mut FMOD_DSP,
        index: c_int,
        data: *mut *mut c_void,
        length: *mut c_uint,
        valuestr: *mut c_char,
        valuestrlen: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetNumParameters(dsp: *mut FMOD_DSP, numparams: *mut c_int) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetParameterInfo(
        dsp: *mut FMOD_DSP,
        index: c_int,
        desc: *mut *mut FMOD_DSP_PARAMETER_DESC,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetDataParameterIndex(
        dsp: *mut FMOD_DSP,
        datatype: c_int,
        index: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_ShowConfigDialog(
        dsp: *mut FMOD_DSP,
        hwnd: *mut c_void,
        show: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetInfo(
        dsp: *mut FMOD_DSP,
        name: *mut c_char,
        version: *mut c_uint,
        channels: *mut c_int,
        configwidth: *mut c_int,
        configheight: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetType(dsp: *mut FMOD_DSP, type_: *mut FMOD_DSP_TYPE) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetIdle(dsp: *mut FMOD_DSP, idle: *mut FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetUserData(dsp: *mut FMOD_DSP, userdata: *mut c_void) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetUserData(dsp: *mut FMOD_DSP, userdata: *mut *mut c_void) -> FMOD_RESULT;
    pub fn FMOD_DSP_SetMeteringEnabled(
        dsp: *mut FMOD_DSP,
        inputEnabled: FMOD_BOOL,
        outputEnabled: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetMeteringEnabled(
        dsp: *mut FMOD_DSP,
        inputEnabled: *mut FMOD_BOOL,
        outputEnabled: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetMeteringInfo(
        dsp: *mut FMOD_DSP,
        inputInfo: *mut FMOD_DSP_METERING_INFO,
        outputInfo: *mut FMOD_DSP_METERING_INFO,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSP_GetCPUUsage(
        dsp: *mut FMOD_DSP,
        exclusive: *mut c_uint,
        inclusive: *mut c_uint,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetInput(
        dspconnection: *mut FMOD_DSPCONNECTION,
        input: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetOutput(
        dspconnection: *mut FMOD_DSPCONNECTION,
        output: *mut *mut FMOD_DSP,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_SetMix(
        dspconnection: *mut FMOD_DSPCONNECTION,
        volume: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetMix(
        dspconnection: *mut FMOD_DSPCONNECTION,
        volume: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_SetMixMatrix(
        dspconnection: *mut FMOD_DSPCONNECTION,
        matrix: *mut c_float,
        outchannels: c_int,
        inchannels: c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetMixMatrix(
        dspconnection: *mut FMOD_DSPCONNECTION,
        matrix: *mut c_float,
        outchannels: *mut c_int,
        inchannels: *mut c_int,
        inchannel_hop: c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetType(
        dspconnection: *mut FMOD_DSPCONNECTION,
        type_: *mut FMOD_DSPCONNECTION_TYPE,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_SetUserData(
        dspconnection: *mut FMOD_DSPCONNECTION,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_DSPConnection_GetUserData(
        dspconnection: *mut FMOD_DSPCONNECTION,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_Release(geometry: *mut FMOD_GEOMETRY) -> FMOD_RESULT;
    pub fn FMOD_Geometry_AddPolygon(
        geometry: *mut FMOD_GEOMETRY,
        directocclusion: c_float,
        reverbocclusion: c_float,
        doublesided: FMOD_BOOL,
        numvertices: c_int,
        vertices: *const FMOD_VECTOR,
        polygonindex: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetNumPolygons(
        geometry: *mut FMOD_GEOMETRY,
        numpolygons: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetMaxPolygons(
        geometry: *mut FMOD_GEOMETRY,
        maxpolygons: *mut c_int,
        maxvertices: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetPolygonNumVertices(
        geometry: *mut FMOD_GEOMETRY,
        index: c_int,
        numvertices: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetPolygonVertex(
        geometry: *mut FMOD_GEOMETRY,
        index: c_int,
        vertexindex: c_int,
        vertex: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetPolygonVertex(
        geometry: *mut FMOD_GEOMETRY,
        index: c_int,
        vertexindex: c_int,
        vertex: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetPolygonAttributes(
        geometry: *mut FMOD_GEOMETRY,
        index: c_int,
        directocclusion: c_float,
        reverbocclusion: c_float,
        doublesided: FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetPolygonAttributes(
        geometry: *mut FMOD_GEOMETRY,
        index: c_int,
        directocclusion: *mut c_float,
        reverbocclusion: *mut c_float,
        doublesided: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetActive(geometry: *mut FMOD_GEOMETRY, active: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetActive(
        geometry: *mut FMOD_GEOMETRY,
        active: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetRotation(
        geometry: *mut FMOD_GEOMETRY,
        forward: *const FMOD_VECTOR,
        up: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetRotation(
        geometry: *mut FMOD_GEOMETRY,
        forward: *mut FMOD_VECTOR,
        up: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetPosition(
        geometry: *mut FMOD_GEOMETRY,
        position: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetPosition(
        geometry: *mut FMOD_GEOMETRY,
        position: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetScale(
        geometry: *mut FMOD_GEOMETRY,
        scale: *const FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetScale(
        geometry: *mut FMOD_GEOMETRY,
        scale: *mut FMOD_VECTOR,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_Save(
        geometry: *mut FMOD_GEOMETRY,
        data: *mut c_void,
        datasize: *mut c_int,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_SetUserData(
        geometry: *mut FMOD_GEOMETRY,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Geometry_GetUserData(
        geometry: *mut FMOD_GEOMETRY,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_Release(reverb3d: *mut FMOD_REVERB3D) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_Set3DAttributes(
        reverb3d: *mut FMOD_REVERB3D,
        position: *const FMOD_VECTOR,
        mindistance: c_float,
        maxdistance: c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_Get3DAttributes(
        reverb3d: *mut FMOD_REVERB3D,
        position: *mut FMOD_VECTOR,
        mindistance: *mut c_float,
        maxdistance: *mut c_float,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_SetProperties(
        reverb3d: *mut FMOD_REVERB3D,
        properties: *const FMOD_REVERB_PROPERTIES,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_GetProperties(
        reverb3d: *mut FMOD_REVERB3D,
        properties: *mut FMOD_REVERB_PROPERTIES,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_SetActive(reverb3d: *mut FMOD_REVERB3D, active: FMOD_BOOL) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_GetActive(
        reverb3d: *mut FMOD_REVERB3D,
        active: *mut FMOD_BOOL,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_SetUserData(
        reverb3d: *mut FMOD_REVERB3D,
        userdata: *mut c_void,
    ) -> FMOD_RESULT;
    pub fn FMOD_Reverb3D_GetUserData(
        reverb3d: *mut FMOD_REVERB3D,
        userdata: *mut *mut c_void,
    ) -> FMOD_RESULT;
}

pub fn map_fmod_error(result: FMOD_RESULT) -> &'static str {
    match result {
        FMOD_OK => "No errors.",
        FMOD_ERR_BADCOMMAND => "Tried to call a function on a data type that does not allow this type of functionality (ie calling Sound::lock on a streaming sound).",
        FMOD_ERR_CHANNEL_ALLOC => "Error trying to allocate a channel.",
        FMOD_ERR_CHANNEL_STOLEN => "The specified channel has been reused to play another sound.",
        FMOD_ERR_DMA => "DMA Failure.  See debug output for more information.",
        FMOD_ERR_DSP_CONNECTION => "DSP connection error.  Connection possibly caused a cyclic dependency or connected dsps with incompatible buffer counts.",
        FMOD_ERR_DSP_DONTPROCESS => "DSP return code from a DSP process query callback.  Tells mixer not to call the process callback and therefore not consume CPU.  Use this to optimize the DSP graph.",
        FMOD_ERR_DSP_FORMAT => "DSP Format error.  A DSP unit may have attempted to connect to this network with the wrong format, or a matrix may have been set with the wrong size if the target unit has a specified channel map.",
        FMOD_ERR_DSP_INUSE => "DSP is already in the mixer's DSP network. It must be removed before being reinserted or released.",
        FMOD_ERR_DSP_NOTFOUND => "DSP connection error.  Couldn't find the DSP unit specified.",
        FMOD_ERR_DSP_RESERVED => "DSP operation error.  Cannot perform operation on this DSP as it is reserved by the system.",
        FMOD_ERR_DSP_SILENCE => "DSP return code from a DSP process query callback.  Tells mixer silence would be produced from read, so go idle and not consume CPU.  Use this to optimize the DSP graph.",
        FMOD_ERR_DSP_TYPE => "DSP operation cannot be performed on a DSP of this type.",
        FMOD_ERR_FILE_BAD => "Error loading file.",
        FMOD_ERR_FILE_COULDNOTSEEK => "Couldn't perform seek operation.  This is a limitation of the medium (ie netstreams) or the file format.",
        FMOD_ERR_FILE_DISKEJECTED => "Media was ejected while reading.",
        FMOD_ERR_FILE_EOF => "End of file unexpectedly reached while trying to read essential data (truncated?).",
        FMOD_ERR_FILE_ENDOFDATA => "End of current chunk reached while trying to read data.",
        FMOD_ERR_FILE_NOTFOUND => "File not found.",
        FMOD_ERR_FORMAT => "Unsupported file or audio format.",
        FMOD_ERR_HEADER_MISMATCH => "There is a version mismatch between the FMOD header and either the FMOD Studio library or the FMOD Low Level library.",
        FMOD_ERR_HTTP => "A HTTP error occurred. This is a catch-all for HTTP errors not listed elsewhere.",
        FMOD_ERR_HTTP_ACCESS => "The specified resource requires authentication or is forbidden.",
        FMOD_ERR_HTTP_PROXY_AUTH => "Proxy authentication is required to access the specified resource.",
        FMOD_ERR_HTTP_SERVER_ERROR => "A HTTP server error occurred.",
        FMOD_ERR_HTTP_TIMEOUT => "The HTTP request timed out.",
        FMOD_ERR_INITIALIZATION => "FMOD was not initialized correctly to support this function.",
        FMOD_ERR_INITIALIZED => "Cannot call this command after System::init.",
        FMOD_ERR_INTERNAL => "An error occurred that wasn't supposed to.  Contact support.",
        FMOD_ERR_INVALID_FLOAT => "Value passed in was a NaN, Inf or denormalized float.",
        FMOD_ERR_INVALID_HANDLE => "An invalid object handle was used.",
        FMOD_ERR_INVALID_PARAM => "An invalid parameter was passed to this function.",
        FMOD_ERR_INVALID_POSITION => "An invalid seek position was passed to this function.",
        FMOD_ERR_INVALID_SPEAKER => "An invalid speaker was passed to this function based on the current speaker mode.",
        FMOD_ERR_INVALID_SYNCPOINT => "The syncpoint did not come from this sound handle.",
        FMOD_ERR_INVALID_THREAD => "Tried to call a function on a thread that is not supported.",
        FMOD_ERR_INVALID_VECTOR => "The vectors passed in are not unit length, or perpendicular.",
        FMOD_ERR_MAXAUDIBLE => "Reached maximum audible playback count for this sound's soundgroup.",
        FMOD_ERR_MEMORY => "Not enough memory or resources.",
        FMOD_ERR_MEMORY_CANTPOINT => "Can't use FMOD_OPENMEMORY_POINT on non PCM source data, or non mp3/xma/adpcm data if FMOD_CREATECOMPRESSEDSAMPLE was used.",
        FMOD_ERR_NEEDS3D => "Tried to call a command on a 2d sound when the command was meant for 3d sound.",
        FMOD_ERR_NEEDSHARDWARE => "Tried to use a feature that requires hardware support.",
        FMOD_ERR_NET_CONNECT => "Couldn't connect to the specified host.",
        FMOD_ERR_NET_SOCKET_ERROR => "A socket error occurred.  This is a catch-all for socket-related errors not listed elsewhere.",
        FMOD_ERR_NET_URL => "The specified URL couldn't be resolved.",
        FMOD_ERR_NET_WOULD_BLOCK => "Operation on a non-blocking socket could not complete immediately.",
        FMOD_ERR_NOTREADY => "Operation could not be performed because specified sound/DSP connection is not ready.",
        FMOD_ERR_OUTPUT_ALLOCATED => "Error initializing output device, but more specifically, the output device is already in use and cannot be reused.",
        FMOD_ERR_OUTPUT_CREATEBUFFER => "Error creating hardware sound buffer.",
        FMOD_ERR_OUTPUT_DRIVERCALL => "A call to a standard soundcard driver failed, which could possibly mean a bug in the driver or resources were missing or exhausted.",
        FMOD_ERR_OUTPUT_FORMAT => "Soundcard does not support the specified format.",
        FMOD_ERR_OUTPUT_INIT => "Error initializing output device.",
        FMOD_ERR_OUTPUT_NODRIVERS => "The output device has no drivers installed.  If pre-init, FMOD_OUTPUT_NOSOUND is selected as the output mode.  If post-init, the function just fails.",
        FMOD_ERR_PLUGIN => "An unspecified error has been returned from a plugin.",
        FMOD_ERR_PLUGIN_MISSING => "A requested output, dsp unit type or codec was not available.",
        FMOD_ERR_PLUGIN_RESOURCE => "A resource that the plugin requires cannot be found. (ie the DLS file for MIDI playback)",
        FMOD_ERR_PLUGIN_VERSION => "A plugin was built with an unsupported SDK version.",
        FMOD_ERR_RECORD => "An error occurred trying to initialize the recording device.",
        FMOD_ERR_REVERB_CHANNELGROUP => "Reverb properties cannot be set on this channel because a parent channelgroup owns the reverb connection.",
        FMOD_ERR_REVERB_INSTANCE => "Specified instance in FMOD_REVERB_PROPERTIES couldn't be set. Most likely because it is an invalid instance number or the reverb doesn't exist.",
        FMOD_ERR_SUBSOUNDS => "The error occurred because the sound referenced contains subsounds when it shouldn't have, or it doesn't contain subsounds when it should have.  The operation may also not be able to be performed on a parent sound.",
        FMOD_ERR_SUBSOUND_ALLOCATED => "This subsound is already being used by another sound, you cannot have more than one parent to a sound.  Null out the other parent's entry first.",
        FMOD_ERR_SUBSOUND_CANTMOVE => "Shared subsounds cannot be replaced or moved from their parent stream, such as when the parent stream is an FSB file.",
        FMOD_ERR_TAGNOTFOUND => "The specified tag could not be found or there are no tags.",
        FMOD_ERR_TOOMANYCHANNELS => "The sound created exceeds the allowable input channel count.  This can be increased using the 'maxinputchannels' parameter in System::setSoftwareFormat.",
        FMOD_ERR_TRUNCATED => "The retrieved string is too long to fit in the supplied buffer and has been truncated.",
        FMOD_ERR_UNIMPLEMENTED => "Something in FMOD hasn't been implemented when it should be! contact support!",
        FMOD_ERR_UNINITIALIZED => "This command failed because System::init or System::setDriver was not called.",
        FMOD_ERR_UNSUPPORTED => "A command issued was not supported by this object.  Possibly a plugin without certain callbacks specified.",
        FMOD_ERR_VERSION => "The version number of this file format is not supported.",
        FMOD_ERR_EVENT_ALREADY_LOADED => "The specified bank has already been loaded.",
        FMOD_ERR_EVENT_LIVEUPDATE_BUSY => "The live update connection failed due to the game already being connected.",
        FMOD_ERR_EVENT_LIVEUPDATE_MISMATCH => "The live update connection failed due to the game data being out of sync with the tool.",
        FMOD_ERR_EVENT_LIVEUPDATE_TIMEOUT => "The live update connection timed out.",
        FMOD_ERR_EVENT_NOTFOUND => "The requested event, parameter, bus or vca could not be found.",
        FMOD_ERR_STUDIO_UNINITIALIZED => "The Studio::System object is not yet initialized.",
        FMOD_ERR_STUDIO_NOT_LOADED => "The specified resource is not loaded, so it can't be unloaded.",
        FMOD_ERR_INVALID_STRING => "An invalid string was passed to this function.",
        FMOD_ERR_ALREADY_LOCKED => "The specified resource is already locked.",
        FMOD_ERR_NOT_LOCKED => "The specified resource is not locked, so it can't be unlocked.",
        FMOD_ERR_RECORD_DISCONNECTED => "The specified recording driver has been disconnected.",
        FMOD_ERR_TOOMANYSAMPLES => "The length provided exceeds the allowable limit.",
        _ => "Unknown error code"
    }
}
