// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Installation;
use crate::TransactionOperation;
use crate::TransactionProgress;
use crate::TransactionRemoteReason;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakTransaction")]
    pub struct Transaction(Object<ffi::FlatpakTransaction, ffi::FlatpakTransactionClass>);

    match fn {
        type_ => || ffi::flatpak_transaction_get_type(),
    }
}

impl Transaction {
    pub const NONE: Option<&'static Transaction> = None;

    #[doc(alias = "flatpak_transaction_new_for_installation")]
    #[doc(alias = "new_for_installation")]
    pub fn for_installation(
        installation: &impl IsA<Installation>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Transaction, glib::Error> {
        skip_assert_initialized!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_transaction_new_for_installation(
                installation.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Transaction`] objects.
    ///
    /// This method returns an instance of [`TransactionBuilder`](crate::builders::TransactionBuilder) which can be used to create [`Transaction`] objects.
    pub fn builder() -> TransactionBuilder {
        TransactionBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Transaction`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TransactionBuilder {
    installation: Option<Installation>,
}

impl TransactionBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TransactionBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Transaction`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Transaction {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref installation) = self.installation {
            properties.push(("installation", installation));
        }
        glib::Object::new::<Transaction>(&properties)
            .expect("Failed to create an instance of Transaction")
    }

    pub fn installation(mut self, installation: &impl IsA<Installation>) -> Self {
        self.installation = Some(installation.clone().upcast());
        self
    }
}

pub trait TransactionExt: 'static {
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_transaction_abort_webflow")]
    fn abort_webflow(&self, id: u32);

    #[doc(alias = "flatpak_transaction_add_default_dependency_sources")]
    fn add_default_dependency_sources(&self);

    #[doc(alias = "flatpak_transaction_add_dependency_source")]
    fn add_dependency_source(&self, installation: &impl IsA<Installation>);

    #[doc(alias = "flatpak_transaction_add_install")]
    fn add_install(&self, remote: &str, ref_: &str, subpaths: &[&str]) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_transaction_add_install_bundle")]
    fn add_install_bundle(
        &self,
        file: &impl IsA<gio::File>,
        gpg_data: Option<&glib::Bytes>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_transaction_add_install_flatpakref")]
    fn add_install_flatpakref(&self, flatpakref_data: &glib::Bytes) -> Result<(), glib::Error>;

    #[cfg(any(feature = "v1_7_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_1")))]
    #[doc(alias = "flatpak_transaction_add_sideload_repo")]
    fn add_sideload_repo(&self, path: &str);

    #[doc(alias = "flatpak_transaction_add_uninstall")]
    fn add_uninstall(&self, ref_: &str) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_transaction_add_update")]
    fn add_update(
        &self,
        ref_: &str,
        subpaths: &[&str],
        commit: Option<&str>,
    ) -> Result<(), glib::Error>;

    #[cfg(any(feature = "v1_5_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_2")))]
    #[doc(alias = "flatpak_transaction_complete_basic_auth")]
    fn complete_basic_auth(&self, id: u32, user: &str, password: &str, options: &glib::Variant);

    #[doc(alias = "flatpak_transaction_get_current_operation")]
    #[doc(alias = "get_current_operation")]
    fn current_operation(&self) -> Option<TransactionOperation>;

    #[doc(alias = "flatpak_transaction_get_installation")]
    #[doc(alias = "get_installation")]
    fn installation(&self) -> Option<Installation>;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_transaction_get_no_deploy")]
    #[doc(alias = "get_no_deploy")]
    fn is_no_deploy(&self) -> bool;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_transaction_get_no_pull")]
    #[doc(alias = "get_no_pull")]
    fn is_no_pull(&self) -> bool;

    #[doc(alias = "flatpak_transaction_get_operations")]
    #[doc(alias = "get_operations")]
    fn operations(&self) -> Vec<TransactionOperation>;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_transaction_get_parent_window")]
    #[doc(alias = "get_parent_window")]
    fn parent_window(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_transaction_is_empty")]
    fn is_empty(&self) -> bool;

    #[doc(alias = "flatpak_transaction_run")]
    fn run(&self, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_transaction_set_default_arch")]
    fn set_default_arch(&self, arch: &str);

    #[doc(alias = "flatpak_transaction_set_disable_dependencies")]
    fn set_disable_dependencies(&self, disable_dependencies: bool);

    #[doc(alias = "flatpak_transaction_set_disable_prune")]
    fn set_disable_prune(&self, disable_prune: bool);

    #[doc(alias = "flatpak_transaction_set_disable_related")]
    fn set_disable_related(&self, disable_related: bool);

    #[doc(alias = "flatpak_transaction_set_disable_static_deltas")]
    fn set_disable_static_deltas(&self, disable_static_deltas: bool);

    #[doc(alias = "flatpak_transaction_set_force_uninstall")]
    fn set_force_uninstall(&self, force_uninstall: bool);

    #[doc(alias = "flatpak_transaction_set_no_deploy")]
    fn set_no_deploy(&self, no_deploy: bool);

    #[cfg(any(feature = "v1_7_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_3")))]
    #[doc(alias = "flatpak_transaction_set_no_interaction")]
    fn set_no_interaction(&self, no_interaction: bool);

    #[doc(alias = "flatpak_transaction_set_no_pull")]
    fn set_no_pull(&self, no_pull: bool);

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_transaction_set_parent_window")]
    fn set_parent_window(&self, parent_window: &str);

    #[doc(alias = "flatpak_transaction_set_reinstall")]
    fn set_reinstall(&self, reinstall: bool);

    #[doc(alias = "add-new-remote")]
    fn connect_add_new_remote<
        F: Fn(&Self, TransactionRemoteReason, &str, &str, &str) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v1_5_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_2")))]
    #[doc(alias = "basic-auth-start")]
    fn connect_basic_auth_start<F: Fn(&Self, &str, &str, &glib::Variant, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    //#[doc(alias = "choose-remote-for-ref")]
    //fn connect_choose_remote_for_ref<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "end-of-lifed")]
    fn connect_end_of_lifed<F: Fn(&Self, &str, &str, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    //#[doc(alias = "end-of-lifed-with-rebase")]
    //fn connect_end_of_lifed_with_rebase<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v1_7_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_4")))]
    #[doc(alias = "install-authenticator")]
    fn connect_install_authenticator<F: Fn(&Self, &str, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "new-operation")]
    fn connect_new_operation<F: Fn(&Self, &TransactionOperation, &TransactionProgress) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "ready")]
    fn connect_ready<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "webflow-done")]
    fn connect_webflow_done<F: Fn(&Self, &glib::Variant, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "webflow-start")]
    fn connect_webflow_start<F: Fn(&Self, &str, &str, &glib::Variant, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<Transaction>> TransactionExt for O {
    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn abort_webflow(&self, id: u32) {
        unsafe {
            ffi::flatpak_transaction_abort_webflow(self.as_ref().to_glib_none().0, id);
        }
    }

    fn add_default_dependency_sources(&self) {
        unsafe {
            ffi::flatpak_transaction_add_default_dependency_sources(self.as_ref().to_glib_none().0);
        }
    }

    fn add_dependency_source(&self, installation: &impl IsA<Installation>) {
        unsafe {
            ffi::flatpak_transaction_add_dependency_source(
                self.as_ref().to_glib_none().0,
                installation.as_ref().to_glib_none().0,
            );
        }
    }

    fn add_install(&self, remote: &str, ref_: &str, subpaths: &[&str]) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_add_install(
                self.as_ref().to_glib_none().0,
                remote.to_glib_none().0,
                ref_.to_glib_none().0,
                subpaths.to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn add_install_bundle(
        &self,
        file: &impl IsA<gio::File>,
        gpg_data: Option<&glib::Bytes>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_add_install_bundle(
                self.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                gpg_data.to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn add_install_flatpakref(&self, flatpakref_data: &glib::Bytes) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_add_install_flatpakref(
                self.as_ref().to_glib_none().0,
                flatpakref_data.to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_7_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_1")))]
    fn add_sideload_repo(&self, path: &str) {
        unsafe {
            ffi::flatpak_transaction_add_sideload_repo(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
            );
        }
    }

    fn add_uninstall(&self, ref_: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_add_uninstall(
                self.as_ref().to_glib_none().0,
                ref_.to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn add_update(
        &self,
        ref_: &str,
        subpaths: &[&str],
        commit: Option<&str>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_add_update(
                self.as_ref().to_glib_none().0,
                ref_.to_glib_none().0,
                subpaths.to_glib_none().0,
                commit.to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_5_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_2")))]
    fn complete_basic_auth(&self, id: u32, user: &str, password: &str, options: &glib::Variant) {
        unsafe {
            ffi::flatpak_transaction_complete_basic_auth(
                self.as_ref().to_glib_none().0,
                id,
                user.to_glib_none().0,
                password.to_glib_none().0,
                options.to_glib_none().0,
            );
        }
    }

    fn current_operation(&self) -> Option<TransactionOperation> {
        unsafe {
            from_glib_full(ffi::flatpak_transaction_get_current_operation(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn installation(&self) -> Option<Installation> {
        unsafe {
            from_glib_full(ffi::flatpak_transaction_get_installation(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn is_no_deploy(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_transaction_get_no_deploy(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn is_no_pull(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_transaction_get_no_pull(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn operations(&self) -> Vec<TransactionOperation> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::flatpak_transaction_get_operations(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn parent_window(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_transaction_get_parent_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_empty(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_transaction_is_empty(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn run(&self, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_transaction_run(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_default_arch(&self, arch: &str) {
        unsafe {
            ffi::flatpak_transaction_set_default_arch(
                self.as_ref().to_glib_none().0,
                arch.to_glib_none().0,
            );
        }
    }

    fn set_disable_dependencies(&self, disable_dependencies: bool) {
        unsafe {
            ffi::flatpak_transaction_set_disable_dependencies(
                self.as_ref().to_glib_none().0,
                disable_dependencies.into_glib(),
            );
        }
    }

    fn set_disable_prune(&self, disable_prune: bool) {
        unsafe {
            ffi::flatpak_transaction_set_disable_prune(
                self.as_ref().to_glib_none().0,
                disable_prune.into_glib(),
            );
        }
    }

    fn set_disable_related(&self, disable_related: bool) {
        unsafe {
            ffi::flatpak_transaction_set_disable_related(
                self.as_ref().to_glib_none().0,
                disable_related.into_glib(),
            );
        }
    }

    fn set_disable_static_deltas(&self, disable_static_deltas: bool) {
        unsafe {
            ffi::flatpak_transaction_set_disable_static_deltas(
                self.as_ref().to_glib_none().0,
                disable_static_deltas.into_glib(),
            );
        }
    }

    fn set_force_uninstall(&self, force_uninstall: bool) {
        unsafe {
            ffi::flatpak_transaction_set_force_uninstall(
                self.as_ref().to_glib_none().0,
                force_uninstall.into_glib(),
            );
        }
    }

    fn set_no_deploy(&self, no_deploy: bool) {
        unsafe {
            ffi::flatpak_transaction_set_no_deploy(
                self.as_ref().to_glib_none().0,
                no_deploy.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v1_7_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_3")))]
    fn set_no_interaction(&self, no_interaction: bool) {
        unsafe {
            ffi::flatpak_transaction_set_no_interaction(
                self.as_ref().to_glib_none().0,
                no_interaction.into_glib(),
            );
        }
    }

    fn set_no_pull(&self, no_pull: bool) {
        unsafe {
            ffi::flatpak_transaction_set_no_pull(
                self.as_ref().to_glib_none().0,
                no_pull.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn set_parent_window(&self, parent_window: &str) {
        unsafe {
            ffi::flatpak_transaction_set_parent_window(
                self.as_ref().to_glib_none().0,
                parent_window.to_glib_none().0,
            );
        }
    }

    fn set_reinstall(&self, reinstall: bool) {
        unsafe {
            ffi::flatpak_transaction_set_reinstall(
                self.as_ref().to_glib_none().0,
                reinstall.into_glib(),
            );
        }
    }

    fn connect_add_new_remote<
        F: Fn(&Self, TransactionRemoteReason, &str, &str, &str) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn add_new_remote_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, TransactionRemoteReason, &str, &str, &str) -> bool + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            reason: libc::c_int,
            from_id: *mut libc::c_char,
            suggested_remote_name: *mut libc::c_char,
            url: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(reason),
                &glib::GString::from_glib_borrow(from_id),
                &glib::GString::from_glib_borrow(suggested_remote_name),
                &glib::GString::from_glib_borrow(url),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"add-new-remote\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    add_new_remote_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_5_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_2")))]
    fn connect_basic_auth_start<F: Fn(&Self, &str, &str, &glib::Variant, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn basic_auth_start_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &str, &str, &glib::Variant, i32) -> bool + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            remote: *mut libc::c_char,
            realm: *mut libc::c_char,
            options: *mut glib::ffi::GVariant,
            id: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(remote),
                &glib::GString::from_glib_borrow(realm),
                &from_glib_borrow(options),
                id,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"basic-auth-start\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    basic_auth_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_choose_remote_for_ref<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Empty ctype remotes: *.CArray TypeId { ns_id: 0, id: 28 }
    //}

    fn connect_end_of_lifed<F: Fn(&Self, &str, &str, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn end_of_lifed_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &str, &str, &str) + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            ref_: *mut libc::c_char,
            reason: *mut libc::c_char,
            rebase: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(ref_),
                &glib::GString::from_glib_borrow(reason),
                &glib::GString::from_glib_borrow(rebase),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"end-of-lifed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    end_of_lifed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_end_of_lifed_with_rebase<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Empty ctype previous_ids: *.CArray TypeId { ns_id: 0, id: 28 }
    //}

    #[cfg(any(feature = "v1_7_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_7_4")))]
    fn connect_install_authenticator<F: Fn(&Self, &str, &str) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn install_authenticator_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &str, &str) + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            remote: *mut libc::c_char,
            authenticator_ref: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(remote),
                &glib::GString::from_glib_borrow(authenticator_ref),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"install-authenticator\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    install_authenticator_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_new_operation<
        F: Fn(&Self, &TransactionOperation, &TransactionProgress) + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn new_operation_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &TransactionOperation, &TransactionProgress) + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            operation: *mut ffi::FlatpakTransactionOperation,
            progress: *mut ffi::FlatpakTransactionProgress,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(operation),
                &from_glib_borrow(progress),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"new-operation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    new_operation_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_ready<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn ready_trampoline<P: IsA<Transaction>, F: Fn(&P) -> bool + 'static>(
            this: *mut ffi::FlatpakTransaction,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(Transaction::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"ready\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    ready_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn connect_webflow_done<F: Fn(&Self, &glib::Variant, i32) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn webflow_done_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &glib::Variant, i32) + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            options: *mut glib::ffi::GVariant,
            id: libc::c_int,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(options),
                id,
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"webflow-done\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    webflow_done_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn connect_webflow_start<F: Fn(&Self, &str, &str, &glib::Variant, i32) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn webflow_start_trampoline<
            P: IsA<Transaction>,
            F: Fn(&P, &str, &str, &glib::Variant, i32) -> bool + 'static,
        >(
            this: *mut ffi::FlatpakTransaction,
            remote: *mut libc::c_char,
            url: *mut libc::c_char,
            options: *mut glib::ffi::GVariant,
            id: libc::c_int,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Transaction::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(remote),
                &glib::GString::from_glib_borrow(url),
                &from_glib_borrow(options),
                id,
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"webflow-start\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    webflow_start_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Transaction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Transaction")
    }
}
