// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Ref;
use crate::RefKind;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "FlatpakRemoteRef")]
    pub struct RemoteRef(Object<ffi::FlatpakRemoteRef, ffi::FlatpakRemoteRefClass>) @extends Ref;

    match fn {
        type_ => || ffi::flatpak_remote_ref_get_type(),
    }
}

impl RemoteRef {
    pub const NONE: Option<&'static RemoteRef> = None;

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`RemoteRef`] objects.
    ///
    /// This method returns an instance of [`RemoteRefBuilder`](crate::builders::RemoteRefBuilder) which can be used to create [`RemoteRef`] objects.
    pub fn builder() -> RemoteRefBuilder {
        RemoteRefBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`RemoteRef`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RemoteRefBuilder {
    download_size: Option<u64>,
    end_of_life: Option<String>,
    end_of_life_rebase: Option<String>,
    installed_size: Option<u64>,
    metadata: Option<glib::Bytes>,
    remote_name: Option<String>,
    arch: Option<String>,
    branch: Option<String>,
    collection_id: Option<String>,
    commit: Option<String>,
    kind: Option<RefKind>,
    name: Option<String>,
}

impl RemoteRefBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`RemoteRefBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`RemoteRef`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> RemoteRef {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref download_size) = self.download_size {
            properties.push(("download-size", download_size));
        }
        if let Some(ref end_of_life) = self.end_of_life {
            properties.push(("end-of-life", end_of_life));
        }
        if let Some(ref end_of_life_rebase) = self.end_of_life_rebase {
            properties.push(("end-of-life-rebase", end_of_life_rebase));
        }
        if let Some(ref installed_size) = self.installed_size {
            properties.push(("installed-size", installed_size));
        }
        if let Some(ref metadata) = self.metadata {
            properties.push(("metadata", metadata));
        }
        if let Some(ref remote_name) = self.remote_name {
            properties.push(("remote-name", remote_name));
        }
        if let Some(ref arch) = self.arch {
            properties.push(("arch", arch));
        }
        if let Some(ref branch) = self.branch {
            properties.push(("branch", branch));
        }
        if let Some(ref collection_id) = self.collection_id {
            properties.push(("collection-id", collection_id));
        }
        if let Some(ref commit) = self.commit {
            properties.push(("commit", commit));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<RemoteRef>(&properties)
            .expect("Failed to create an instance of RemoteRef")
    }

    pub fn download_size(mut self, download_size: u64) -> Self {
        self.download_size = Some(download_size);
        self
    }

    pub fn end_of_life(mut self, end_of_life: &str) -> Self {
        self.end_of_life = Some(end_of_life.to_string());
        self
    }

    pub fn end_of_life_rebase(mut self, end_of_life_rebase: &str) -> Self {
        self.end_of_life_rebase = Some(end_of_life_rebase.to_string());
        self
    }

    pub fn installed_size(mut self, installed_size: u64) -> Self {
        self.installed_size = Some(installed_size);
        self
    }

    pub fn metadata(mut self, metadata: &glib::Bytes) -> Self {
        self.metadata = Some(metadata.clone());
        self
    }

    pub fn remote_name(mut self, remote_name: &str) -> Self {
        self.remote_name = Some(remote_name.to_string());
        self
    }

    pub fn arch(mut self, arch: &str) -> Self {
        self.arch = Some(arch.to_string());
        self
    }

    pub fn branch(mut self, branch: &str) -> Self {
        self.branch = Some(branch.to_string());
        self
    }

    pub fn collection_id(mut self, collection_id: &str) -> Self {
        self.collection_id = Some(collection_id.to_string());
        self
    }

    pub fn commit(mut self, commit: &str) -> Self {
        self.commit = Some(commit.to_string());
        self
    }

    pub fn kind(mut self, kind: RefKind) -> Self {
        self.kind = Some(kind);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait RemoteRefExt: 'static {
    #[doc(alias = "flatpak_remote_ref_get_download_size")]
    #[doc(alias = "get_download_size")]
    fn download_size(&self) -> u64;

    #[doc(alias = "flatpak_remote_ref_get_eol")]
    #[doc(alias = "get_eol")]
    fn eol(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_ref_get_eol_rebase")]
    #[doc(alias = "get_eol_rebase")]
    fn eol_rebase(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_ref_get_installed_size")]
    #[doc(alias = "get_installed_size")]
    fn installed_size(&self) -> u64;

    #[doc(alias = "flatpak_remote_ref_get_metadata")]
    #[doc(alias = "get_metadata")]
    fn metadata(&self) -> Option<glib::Bytes>;

    #[doc(alias = "flatpak_remote_ref_get_remote_name")]
    #[doc(alias = "get_remote_name")]
    fn remote_name(&self) -> Option<glib::GString>;

    #[doc(alias = "end-of-life")]
    fn end_of_life(&self) -> Option<glib::GString>;

    #[doc(alias = "end-of-life-rebase")]
    fn end_of_life_rebase(&self) -> Option<glib::GString>;
}

impl<O: IsA<RemoteRef>> RemoteRefExt for O {
    fn download_size(&self) -> u64 {
        unsafe { ffi::flatpak_remote_ref_get_download_size(self.as_ref().to_glib_none().0) }
    }

    fn eol(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_remote_ref_get_eol(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn eol_rebase(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_remote_ref_get_eol_rebase(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn installed_size(&self) -> u64 {
        unsafe { ffi::flatpak_remote_ref_get_installed_size(self.as_ref().to_glib_none().0) }
    }

    fn metadata(&self) -> Option<glib::Bytes> {
        unsafe {
            from_glib_none(ffi::flatpak_remote_ref_get_metadata(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn remote_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_remote_ref_get_remote_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn end_of_life(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "end-of-life")
    }

    fn end_of_life_rebase(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "end-of-life-rebase")
    }
}

impl fmt::Display for RemoteRef {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("RemoteRef")
    }
}
