// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::RemoteType;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
#[cfg(any(feature = "v1_3_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakRemote")]
    pub struct Remote(Object<ffi::FlatpakRemote, ffi::FlatpakRemoteClass>);

    match fn {
        type_ => || ffi::flatpak_remote_get_type(),
    }
}

impl Remote {
    pub const NONE: Option<&'static Remote> = None;

    #[doc(alias = "flatpak_remote_new")]
    pub fn new(name: &str) -> Remote {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::flatpak_remote_new(name.to_glib_none().0)) }
    }

    #[cfg(any(feature = "v1_3_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
    #[doc(alias = "flatpak_remote_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(name: &str, data: &glib::Bytes) -> Result<Remote, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_remote_new_from_file(
                name.to_glib_none().0,
                data.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Remote`] objects.
    ///
    /// This method returns an instance of [`RemoteBuilder`](crate::builders::RemoteBuilder) which can be used to create [`Remote`] objects.
    pub fn builder() -> RemoteBuilder {
        RemoteBuilder::default()
    }
}

impl Default for Remote {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct Remote object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Remote`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RemoteBuilder {
    name: Option<String>,
    type_: Option<RemoteType>,
}

impl RemoteBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`RemoteBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Remote`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Remote {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref type_) = self.type_ {
            properties.push(("type", type_));
        }
        glib::Object::new::<Remote>(&properties).expect("Failed to create an instance of Remote")
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn type_(mut self, type_: RemoteType) -> Self {
        self.type_ = Some(type_);
        self
    }
}

pub trait RemoteExt: 'static {
    #[doc(alias = "flatpak_remote_get_appstream_dir")]
    #[doc(alias = "get_appstream_dir")]
    fn appstream_dir(&self, arch: Option<&str>) -> Option<gio::File>;

    #[doc(alias = "flatpak_remote_get_appstream_timestamp")]
    #[doc(alias = "get_appstream_timestamp")]
    fn appstream_timestamp(&self, arch: Option<&str>) -> Option<gio::File>;

    #[doc(alias = "flatpak_remote_get_collection_id")]
    #[doc(alias = "get_collection_id")]
    fn collection_id(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_get_comment")]
    #[doc(alias = "get_comment")]
    fn comment(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_default_branch")]
    #[doc(alias = "get_default_branch")]
    fn default_branch(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_get_description")]
    #[doc(alias = "get_description")]
    fn description(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_disabled")]
    #[doc(alias = "get_disabled")]
    fn is_disabled(&self) -> bool;

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_get_filter")]
    #[doc(alias = "get_filter")]
    fn filter(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_gpg_verify")]
    #[doc(alias = "get_gpg_verify")]
    fn is_gpg_verify(&self) -> bool;

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_get_homepage")]
    #[doc(alias = "get_homepage")]
    fn homepage(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_get_icon")]
    #[doc(alias = "get_icon")]
    fn icon(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    #[doc(alias = "flatpak_remote_get_main_ref")]
    #[doc(alias = "get_main_ref")]
    fn main_ref(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_nodeps")]
    #[doc(alias = "get_nodeps")]
    fn is_nodeps(&self) -> bool;

    #[doc(alias = "flatpak_remote_get_noenumerate")]
    #[doc(alias = "get_noenumerate")]
    fn is_noenumerate(&self) -> bool;

    #[doc(alias = "flatpak_remote_get_prio")]
    #[doc(alias = "get_prio")]
    fn prio(&self) -> i32;

    #[doc(alias = "flatpak_remote_get_remote_type")]
    #[doc(alias = "get_remote_type")]
    fn remote_type(&self) -> RemoteType;

    #[doc(alias = "flatpak_remote_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_get_url")]
    #[doc(alias = "get_url")]
    fn url(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_remote_set_collection_id")]
    fn set_collection_id(&self, collection_id: Option<&str>);

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_set_comment")]
    fn set_comment(&self, comment: &str);

    #[doc(alias = "flatpak_remote_set_default_branch")]
    fn set_default_branch(&self, default_branch: &str);

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_set_description")]
    fn set_description(&self, description: &str);

    #[doc(alias = "flatpak_remote_set_disabled")]
    fn set_disabled(&self, disabled: bool);

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_set_filter")]
    fn set_filter(&self, filter_path: &str);

    #[doc(alias = "flatpak_remote_set_gpg_key")]
    fn set_gpg_key(&self, gpg_key: &glib::Bytes);

    #[doc(alias = "flatpak_remote_set_gpg_verify")]
    fn set_gpg_verify(&self, gpg_verify: bool);

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_set_homepage")]
    fn set_homepage(&self, homepage: &str);

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    #[doc(alias = "flatpak_remote_set_icon")]
    fn set_icon(&self, icon: &str);

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    #[doc(alias = "flatpak_remote_set_main_ref")]
    fn set_main_ref(&self, main_ref: &str);

    #[doc(alias = "flatpak_remote_set_nodeps")]
    fn set_nodeps(&self, nodeps: bool);

    #[doc(alias = "flatpak_remote_set_noenumerate")]
    fn set_noenumerate(&self, noenumerate: bool);

    #[doc(alias = "flatpak_remote_set_prio")]
    fn set_prio(&self, prio: i32);

    #[doc(alias = "flatpak_remote_set_title")]
    fn set_title(&self, title: &str);

    #[doc(alias = "flatpak_remote_set_url")]
    fn set_url(&self, url: &str);

    fn set_name(&self, name: Option<&str>);

    #[doc(alias = "type")]
    fn type_(&self) -> RemoteType;

    #[doc(alias = "name")]
    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Remote>> RemoteExt for O {
    fn appstream_dir(&self, arch: Option<&str>) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_appstream_dir(
                self.as_ref().to_glib_none().0,
                arch.to_glib_none().0,
            ))
        }
    }

    fn appstream_timestamp(&self, arch: Option<&str>) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_appstream_timestamp(
                self.as_ref().to_glib_none().0,
                arch.to_glib_none().0,
            ))
        }
    }

    fn collection_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_collection_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn comment(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_comment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn default_branch(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_default_branch(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn description(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_description(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_disabled(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_remote_get_disabled(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn filter(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_filter(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_gpg_verify(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_remote_get_gpg_verify(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn homepage(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_homepage(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn icon(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::flatpak_remote_get_icon(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    fn main_ref(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_main_ref(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::flatpak_remote_get_name(self.as_ref().to_glib_none().0)) }
    }

    fn is_nodeps(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_remote_get_nodeps(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_noenumerate(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_remote_get_noenumerate(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn prio(&self) -> i32 {
        unsafe { ffi::flatpak_remote_get_prio(self.as_ref().to_glib_none().0) }
    }

    fn remote_type(&self) -> RemoteType {
        unsafe {
            from_glib(ffi::flatpak_remote_get_remote_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::flatpak_remote_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn url(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::flatpak_remote_get_url(self.as_ref().to_glib_none().0)) }
    }

    fn set_collection_id(&self, collection_id: Option<&str>) {
        unsafe {
            ffi::flatpak_remote_set_collection_id(
                self.as_ref().to_glib_none().0,
                collection_id.to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn set_comment(&self, comment: &str) {
        unsafe {
            ffi::flatpak_remote_set_comment(
                self.as_ref().to_glib_none().0,
                comment.to_glib_none().0,
            );
        }
    }

    fn set_default_branch(&self, default_branch: &str) {
        unsafe {
            ffi::flatpak_remote_set_default_branch(
                self.as_ref().to_glib_none().0,
                default_branch.to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn set_description(&self, description: &str) {
        unsafe {
            ffi::flatpak_remote_set_description(
                self.as_ref().to_glib_none().0,
                description.to_glib_none().0,
            );
        }
    }

    fn set_disabled(&self, disabled: bool) {
        unsafe {
            ffi::flatpak_remote_set_disabled(self.as_ref().to_glib_none().0, disabled.into_glib());
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn set_filter(&self, filter_path: &str) {
        unsafe {
            ffi::flatpak_remote_set_filter(
                self.as_ref().to_glib_none().0,
                filter_path.to_glib_none().0,
            );
        }
    }

    fn set_gpg_key(&self, gpg_key: &glib::Bytes) {
        unsafe {
            ffi::flatpak_remote_set_gpg_key(
                self.as_ref().to_glib_none().0,
                gpg_key.to_glib_none().0,
            );
        }
    }

    fn set_gpg_verify(&self, gpg_verify: bool) {
        unsafe {
            ffi::flatpak_remote_set_gpg_verify(
                self.as_ref().to_glib_none().0,
                gpg_verify.into_glib(),
            );
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn set_homepage(&self, homepage: &str) {
        unsafe {
            ffi::flatpak_remote_set_homepage(
                self.as_ref().to_glib_none().0,
                homepage.to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v1_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4")))]
    fn set_icon(&self, icon: &str) {
        unsafe {
            ffi::flatpak_remote_set_icon(self.as_ref().to_glib_none().0, icon.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    fn set_main_ref(&self, main_ref: &str) {
        unsafe {
            ffi::flatpak_remote_set_main_ref(
                self.as_ref().to_glib_none().0,
                main_ref.to_glib_none().0,
            );
        }
    }

    fn set_nodeps(&self, nodeps: bool) {
        unsafe {
            ffi::flatpak_remote_set_nodeps(self.as_ref().to_glib_none().0, nodeps.into_glib());
        }
    }

    fn set_noenumerate(&self, noenumerate: bool) {
        unsafe {
            ffi::flatpak_remote_set_noenumerate(
                self.as_ref().to_glib_none().0,
                noenumerate.into_glib(),
            );
        }
    }

    fn set_prio(&self, prio: i32) {
        unsafe {
            ffi::flatpak_remote_set_prio(self.as_ref().to_glib_none().0, prio);
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            ffi::flatpak_remote_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_url(&self, url: &str) {
        unsafe {
            ffi::flatpak_remote_set_url(self.as_ref().to_glib_none().0, url.to_glib_none().0);
        }
    }

    fn set_name(&self, name: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "name", &name)
    }

    fn type_(&self) -> RemoteType {
        glib::ObjectExt::property(self.as_ref(), "type")
    }

    fn connect_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_name_trampoline<P: IsA<Remote>, F: Fn(&P) + 'static>(
            this: *mut ffi::FlatpakRemote,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Remote::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Remote {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Remote")
    }
}
