// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Ref;
use crate::RefKind;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "FlatpakRelatedRef")]
    pub struct RelatedRef(Object<ffi::FlatpakRelatedRef, ffi::FlatpakRelatedRefClass>) @extends Ref;

    match fn {
        type_ => || ffi::flatpak_related_ref_get_type(),
    }
}

impl RelatedRef {
    pub const NONE: Option<&'static RelatedRef> = None;

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`RelatedRef`] objects.
    ///
    /// This method returns an instance of [`RelatedRefBuilder`](crate::builders::RelatedRefBuilder) which can be used to create [`RelatedRef`] objects.
    pub fn builder() -> RelatedRefBuilder {
        RelatedRefBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`RelatedRef`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RelatedRefBuilder {
    should_autoprune: Option<bool>,
    should_delete: Option<bool>,
    should_download: Option<bool>,
    subpaths: Option<Vec<String>>,
    arch: Option<String>,
    branch: Option<String>,
    collection_id: Option<String>,
    commit: Option<String>,
    kind: Option<RefKind>,
    name: Option<String>,
}

impl RelatedRefBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`RelatedRefBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`RelatedRef`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> RelatedRef {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref should_autoprune) = self.should_autoprune {
            properties.push(("should-autoprune", should_autoprune));
        }
        if let Some(ref should_delete) = self.should_delete {
            properties.push(("should-delete", should_delete));
        }
        if let Some(ref should_download) = self.should_download {
            properties.push(("should-download", should_download));
        }
        if let Some(ref subpaths) = self.subpaths {
            properties.push(("subpaths", subpaths));
        }
        if let Some(ref arch) = self.arch {
            properties.push(("arch", arch));
        }
        if let Some(ref branch) = self.branch {
            properties.push(("branch", branch));
        }
        if let Some(ref collection_id) = self.collection_id {
            properties.push(("collection-id", collection_id));
        }
        if let Some(ref commit) = self.commit {
            properties.push(("commit", commit));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<RelatedRef>(&properties)
            .expect("Failed to create an instance of RelatedRef")
    }

    pub fn should_autoprune(mut self, should_autoprune: bool) -> Self {
        self.should_autoprune = Some(should_autoprune);
        self
    }

    pub fn should_delete(mut self, should_delete: bool) -> Self {
        self.should_delete = Some(should_delete);
        self
    }

    pub fn should_download(mut self, should_download: bool) -> Self {
        self.should_download = Some(should_download);
        self
    }

    pub fn subpaths(mut self, subpaths: Vec<String>) -> Self {
        self.subpaths = Some(subpaths);
        self
    }

    pub fn arch(mut self, arch: &str) -> Self {
        self.arch = Some(arch.to_string());
        self
    }

    pub fn branch(mut self, branch: &str) -> Self {
        self.branch = Some(branch.to_string());
        self
    }

    pub fn collection_id(mut self, collection_id: &str) -> Self {
        self.collection_id = Some(collection_id.to_string());
        self
    }

    pub fn commit(mut self, commit: &str) -> Self {
        self.commit = Some(commit.to_string());
        self
    }

    pub fn kind(mut self, kind: RefKind) -> Self {
        self.kind = Some(kind);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait RelatedRefExt: 'static {
    #[doc(alias = "flatpak_related_ref_get_subpaths")]
    #[doc(alias = "get_subpaths")]
    fn subpaths(&self) -> Vec<glib::GString>;

    #[doc(alias = "flatpak_related_ref_should_autoprune")]
    fn should_autoprune(&self) -> bool;

    #[doc(alias = "flatpak_related_ref_should_delete")]
    fn should_delete(&self) -> bool;

    #[doc(alias = "flatpak_related_ref_should_download")]
    fn should_download(&self) -> bool;
}

impl<O: IsA<RelatedRef>> RelatedRefExt for O {
    fn subpaths(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::flatpak_related_ref_get_subpaths(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn should_autoprune(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_related_ref_should_autoprune(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn should_delete(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_related_ref_should_delete(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn should_download(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_related_ref_should_download(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for RelatedRef {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("RelatedRef")
    }
}
