// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::RefKind;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakRef")]
    pub struct Ref(Object<ffi::FlatpakRef, ffi::FlatpakRefClass>);

    match fn {
        type_ => || ffi::flatpak_ref_get_type(),
    }
}

impl Ref {
    pub const NONE: Option<&'static Ref> = None;

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Ref`] objects.
    ///
    /// This method returns an instance of [`RefBuilder`](crate::builders::RefBuilder) which can be used to create [`Ref`] objects.
    pub fn builder() -> RefBuilder {
        RefBuilder::default()
    }

    #[doc(alias = "flatpak_ref_parse")]
    pub fn parse(ref_: &str) -> Result<Ref, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_ref_parse(ref_.to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Ref`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct RefBuilder {
    arch: Option<String>,
    branch: Option<String>,
    collection_id: Option<String>,
    commit: Option<String>,
    kind: Option<RefKind>,
    name: Option<String>,
}

impl RefBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`RefBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Ref`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Ref {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref arch) = self.arch {
            properties.push(("arch", arch));
        }
        if let Some(ref branch) = self.branch {
            properties.push(("branch", branch));
        }
        if let Some(ref collection_id) = self.collection_id {
            properties.push(("collection-id", collection_id));
        }
        if let Some(ref commit) = self.commit {
            properties.push(("commit", commit));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<Ref>(&properties).expect("Failed to create an instance of Ref")
    }

    pub fn arch(mut self, arch: &str) -> Self {
        self.arch = Some(arch.to_string());
        self
    }

    pub fn branch(mut self, branch: &str) -> Self {
        self.branch = Some(branch.to_string());
        self
    }

    pub fn collection_id(mut self, collection_id: &str) -> Self {
        self.collection_id = Some(collection_id.to_string());
        self
    }

    pub fn commit(mut self, commit: &str) -> Self {
        self.commit = Some(commit.to_string());
        self
    }

    pub fn kind(mut self, kind: RefKind) -> Self {
        self.kind = Some(kind);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait RefExt: 'static {
    #[doc(alias = "flatpak_ref_format_ref")]
    fn format_ref(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_ref_get_arch")]
    #[doc(alias = "get_arch")]
    fn arch(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_ref_get_branch")]
    #[doc(alias = "get_branch")]
    fn branch(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_ref_get_collection_id")]
    #[doc(alias = "get_collection_id")]
    fn collection_id(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_ref_get_commit")]
    #[doc(alias = "get_commit")]
    fn commit(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_ref_get_kind")]
    #[doc(alias = "get_kind")]
    fn kind(&self) -> RefKind;

    #[doc(alias = "flatpak_ref_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString>;
}

impl<O: IsA<Ref>> RefExt for O {
    fn format_ref(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::flatpak_ref_format_ref(self.as_ref().to_glib_none().0)) }
    }

    fn arch(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::flatpak_ref_get_arch(self.as_ref().to_glib_none().0)) }
    }

    fn branch(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::flatpak_ref_get_branch(self.as_ref().to_glib_none().0)) }
    }

    fn collection_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_ref_get_collection_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn commit(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::flatpak_ref_get_commit(self.as_ref().to_glib_none().0)) }
    }

    fn kind(&self) -> RefKind {
        unsafe { from_glib(ffi::flatpak_ref_get_kind(self.as_ref().to_glib_none().0)) }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::flatpak_ref_get_name(self.as_ref().to_glib_none().0)) }
    }
}

impl fmt::Display for Ref {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Ref")
    }
}
