// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Ref;
use crate::RefKind;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakInstalledRef")]
    pub struct InstalledRef(Object<ffi::FlatpakInstalledRef, ffi::FlatpakInstalledRefClass>) @extends Ref;

    match fn {
        type_ => || ffi::flatpak_installed_ref_get_type(),
    }
}

impl InstalledRef {
    pub const NONE: Option<&'static InstalledRef> = None;

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`InstalledRef`] objects.
    ///
    /// This method returns an instance of [`InstalledRefBuilder`](crate::builders::InstalledRefBuilder) which can be used to create [`InstalledRef`] objects.
    pub fn builder() -> InstalledRefBuilder {
        InstalledRefBuilder::default()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`InstalledRef`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct InstalledRefBuilder {
    //appdata-content-rating: /*Unknown type*/,
    appdata_content_rating_type: Option<String>,
    appdata_license: Option<String>,
    appdata_name: Option<String>,
    appdata_summary: Option<String>,
    appdata_version: Option<String>,
    deploy_dir: Option<String>,
    end_of_life: Option<String>,
    end_of_life_rebase: Option<String>,
    installed_size: Option<u64>,
    is_current: Option<bool>,
    latest_commit: Option<String>,
    origin: Option<String>,
    subpaths: Option<Vec<String>>,
    arch: Option<String>,
    branch: Option<String>,
    collection_id: Option<String>,
    commit: Option<String>,
    kind: Option<RefKind>,
    name: Option<String>,
}

impl InstalledRefBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`InstalledRefBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`InstalledRef`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> InstalledRef {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref appdata_content_rating_type) = self.appdata_content_rating_type {
            properties.push(("appdata-content-rating-type", appdata_content_rating_type));
        }
        if let Some(ref appdata_license) = self.appdata_license {
            properties.push(("appdata-license", appdata_license));
        }
        if let Some(ref appdata_name) = self.appdata_name {
            properties.push(("appdata-name", appdata_name));
        }
        if let Some(ref appdata_summary) = self.appdata_summary {
            properties.push(("appdata-summary", appdata_summary));
        }
        if let Some(ref appdata_version) = self.appdata_version {
            properties.push(("appdata-version", appdata_version));
        }
        if let Some(ref deploy_dir) = self.deploy_dir {
            properties.push(("deploy-dir", deploy_dir));
        }
        if let Some(ref end_of_life) = self.end_of_life {
            properties.push(("end-of-life", end_of_life));
        }
        if let Some(ref end_of_life_rebase) = self.end_of_life_rebase {
            properties.push(("end-of-life-rebase", end_of_life_rebase));
        }
        if let Some(ref installed_size) = self.installed_size {
            properties.push(("installed-size", installed_size));
        }
        if let Some(ref is_current) = self.is_current {
            properties.push(("is-current", is_current));
        }
        if let Some(ref latest_commit) = self.latest_commit {
            properties.push(("latest-commit", latest_commit));
        }
        if let Some(ref origin) = self.origin {
            properties.push(("origin", origin));
        }
        if let Some(ref subpaths) = self.subpaths {
            properties.push(("subpaths", subpaths));
        }
        if let Some(ref arch) = self.arch {
            properties.push(("arch", arch));
        }
        if let Some(ref branch) = self.branch {
            properties.push(("branch", branch));
        }
        if let Some(ref collection_id) = self.collection_id {
            properties.push(("collection-id", collection_id));
        }
        if let Some(ref commit) = self.commit {
            properties.push(("commit", commit));
        }
        if let Some(ref kind) = self.kind {
            properties.push(("kind", kind));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        glib::Object::new::<InstalledRef>(&properties)
            .expect("Failed to create an instance of InstalledRef")
    }

    pub fn appdata_content_rating_type(mut self, appdata_content_rating_type: &str) -> Self {
        self.appdata_content_rating_type = Some(appdata_content_rating_type.to_string());
        self
    }

    pub fn appdata_license(mut self, appdata_license: &str) -> Self {
        self.appdata_license = Some(appdata_license.to_string());
        self
    }

    pub fn appdata_name(mut self, appdata_name: &str) -> Self {
        self.appdata_name = Some(appdata_name.to_string());
        self
    }

    pub fn appdata_summary(mut self, appdata_summary: &str) -> Self {
        self.appdata_summary = Some(appdata_summary.to_string());
        self
    }

    pub fn appdata_version(mut self, appdata_version: &str) -> Self {
        self.appdata_version = Some(appdata_version.to_string());
        self
    }

    pub fn deploy_dir(mut self, deploy_dir: &str) -> Self {
        self.deploy_dir = Some(deploy_dir.to_string());
        self
    }

    pub fn end_of_life(mut self, end_of_life: &str) -> Self {
        self.end_of_life = Some(end_of_life.to_string());
        self
    }

    pub fn end_of_life_rebase(mut self, end_of_life_rebase: &str) -> Self {
        self.end_of_life_rebase = Some(end_of_life_rebase.to_string());
        self
    }

    pub fn installed_size(mut self, installed_size: u64) -> Self {
        self.installed_size = Some(installed_size);
        self
    }

    pub fn is_current(mut self, is_current: bool) -> Self {
        self.is_current = Some(is_current);
        self
    }

    pub fn latest_commit(mut self, latest_commit: &str) -> Self {
        self.latest_commit = Some(latest_commit.to_string());
        self
    }

    pub fn origin(mut self, origin: &str) -> Self {
        self.origin = Some(origin.to_string());
        self
    }

    pub fn subpaths(mut self, subpaths: Vec<String>) -> Self {
        self.subpaths = Some(subpaths);
        self
    }

    pub fn arch(mut self, arch: &str) -> Self {
        self.arch = Some(arch.to_string());
        self
    }

    pub fn branch(mut self, branch: &str) -> Self {
        self.branch = Some(branch.to_string());
        self
    }

    pub fn collection_id(mut self, collection_id: &str) -> Self {
        self.collection_id = Some(collection_id.to_string());
        self
    }

    pub fn commit(mut self, commit: &str) -> Self {
        self.commit = Some(commit.to_string());
        self
    }

    pub fn kind(mut self, kind: RefKind) -> Self {
        self.kind = Some(kind);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }
}

pub trait InstalledRefExt: 'static {
    //#[cfg(any(feature = "v1_4_2", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    //#[doc(alias = "flatpak_installed_ref_get_appdata_content_rating")]
    //#[doc(alias = "get_appdata_content_rating")]
    //fn appdata_content_rating(&self) -> /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 };

    #[cfg(any(feature = "v1_4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    #[doc(alias = "flatpak_installed_ref_get_appdata_content_rating_type")]
    #[doc(alias = "get_appdata_content_rating_type")]
    fn appdata_content_rating_type(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installed_ref_get_appdata_license")]
    #[doc(alias = "get_appdata_license")]
    fn appdata_license(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installed_ref_get_appdata_name")]
    #[doc(alias = "get_appdata_name")]
    fn appdata_name(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installed_ref_get_appdata_summary")]
    #[doc(alias = "get_appdata_summary")]
    fn appdata_summary(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installed_ref_get_appdata_version")]
    #[doc(alias = "get_appdata_version")]
    fn appdata_version(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_deploy_dir")]
    #[doc(alias = "get_deploy_dir")]
    fn deploy_dir(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_eol")]
    #[doc(alias = "get_eol")]
    fn eol(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_eol_rebase")]
    #[doc(alias = "get_eol_rebase")]
    fn eol_rebase(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_installed_size")]
    #[doc(alias = "get_installed_size")]
    fn installed_size(&self) -> u64;

    #[doc(alias = "flatpak_installed_ref_get_is_current")]
    #[doc(alias = "get_is_current")]
    fn is_current(&self) -> bool;

    #[doc(alias = "flatpak_installed_ref_get_latest_commit")]
    #[doc(alias = "get_latest_commit")]
    fn latest_commit(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_origin")]
    #[doc(alias = "get_origin")]
    fn origin(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installed_ref_get_subpaths")]
    #[doc(alias = "get_subpaths")]
    fn subpaths(&self) -> Vec<glib::GString>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installed_ref_load_appdata")]
    fn load_appdata(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error>;

    #[doc(alias = "flatpak_installed_ref_load_metadata")]
    fn load_metadata(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error>;

    //#[doc(alias = "appdata-content-rating")]
    //fn get_property_appdata_content_rating(&self) -> /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 };

    #[doc(alias = "appdata-content-rating-type")]
    fn get_property_appdata_content_rating_type(&self) -> Option<glib::GString>;

    #[doc(alias = "appdata-license")]
    fn get_property_appdata_license(&self) -> Option<glib::GString>;

    #[doc(alias = "appdata-name")]
    fn get_property_appdata_name(&self) -> Option<glib::GString>;

    #[doc(alias = "appdata-summary")]
    fn get_property_appdata_summary(&self) -> Option<glib::GString>;

    #[doc(alias = "appdata-version")]
    fn get_property_appdata_version(&self) -> Option<glib::GString>;

    #[doc(alias = "deploy-dir")]
    fn set_deploy_dir(&self, deploy_dir: Option<&str>);

    #[doc(alias = "end-of-life")]
    fn end_of_life(&self) -> Option<glib::GString>;

    #[doc(alias = "end-of-life-rebase")]
    fn end_of_life_rebase(&self) -> Option<glib::GString>;

    #[doc(alias = "installed-size")]
    fn set_installed_size(&self, installed_size: u64);

    #[doc(alias = "is-current")]
    fn set_is_current(&self, is_current: bool);

    #[doc(alias = "latest-commit")]
    fn set_latest_commit(&self, latest_commit: Option<&str>);

    fn set_origin(&self, origin: Option<&str>);

    fn set_subpaths(&self, subpaths: &[&str]);

    #[doc(alias = "deploy-dir")]
    fn connect_deploy_dir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "installed-size")]
    fn connect_installed_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "is-current")]
    fn connect_is_current_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "latest-commit")]
    fn connect_latest_commit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "origin")]
    fn connect_origin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "subpaths")]
    fn connect_subpaths_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<InstalledRef>> InstalledRefExt for O {
    //#[cfg(any(feature = "v1_4_2", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    //fn appdata_content_rating(&self) -> /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 } {
    //    unsafe { TODO: call ffi:flatpak_installed_ref_get_appdata_content_rating() }
    //}

    #[cfg(any(feature = "v1_4_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_4_2")))]
    fn appdata_content_rating_type(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_appdata_content_rating_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn appdata_license(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_appdata_license(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn appdata_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_appdata_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn appdata_summary(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_appdata_summary(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn appdata_version(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_appdata_version(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn deploy_dir(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_deploy_dir(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn eol(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_eol(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn eol_rebase(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_eol_rebase(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn installed_size(&self) -> u64 {
        unsafe { ffi::flatpak_installed_ref_get_installed_size(self.as_ref().to_glib_none().0) }
    }

    fn is_current(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_installed_ref_get_is_current(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn latest_commit(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_latest_commit(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn origin(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installed_ref_get_origin(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn subpaths(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::flatpak_installed_ref_get_subpaths(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn load_appdata(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installed_ref_load_appdata(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_metadata(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installed_ref_load_metadata(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn get_property_appdata_content_rating(&self) -> /*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 } {
    //    glib::ObjectExt::property(self.as_ref(), "appdata-content-rating")
    //}

    fn get_property_appdata_content_rating_type(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "appdata-content-rating-type")
    }

    fn get_property_appdata_license(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "appdata-license")
    }

    fn get_property_appdata_name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "appdata-name")
    }

    fn get_property_appdata_summary(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "appdata-summary")
    }

    fn get_property_appdata_version(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "appdata-version")
    }

    fn set_deploy_dir(&self, deploy_dir: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "deploy-dir", &deploy_dir)
    }

    fn end_of_life(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "end-of-life")
    }

    fn end_of_life_rebase(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "end-of-life-rebase")
    }

    fn set_installed_size(&self, installed_size: u64) {
        glib::ObjectExt::set_property(self.as_ref(), "installed-size", &installed_size)
    }

    fn set_is_current(&self, is_current: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "is-current", &is_current)
    }

    fn set_latest_commit(&self, latest_commit: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "latest-commit", &latest_commit)
    }

    fn set_origin(&self, origin: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "origin", &origin)
    }

    fn set_subpaths(&self, subpaths: &[&str]) {
        glib::ObjectExt::set_property(self.as_ref(), "subpaths", &subpaths)
    }

    fn connect_deploy_dir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_deploy_dir_trampoline<
            P: IsA<InstalledRef>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::deploy-dir\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_deploy_dir_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_installed_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_installed_size_trampoline<
            P: IsA<InstalledRef>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::installed-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_installed_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_is_current_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_current_trampoline<
            P: IsA<InstalledRef>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::is-current\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_is_current_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_latest_commit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_latest_commit_trampoline<
            P: IsA<InstalledRef>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::latest-commit\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_latest_commit_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_origin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_origin_trampoline<P: IsA<InstalledRef>, F: Fn(&P) + 'static>(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::origin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_origin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_subpaths_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_subpaths_trampoline<
            P: IsA<InstalledRef>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::FlatpakInstalledRef,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(InstalledRef::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::subpaths\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_subpaths_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for InstalledRef {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("InstalledRef")
    }
}
