// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::InstalledRef;
#[cfg(any(feature = "v1_3_3", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
use crate::QueryFlags;
use crate::Ref;
use crate::RefKind;
use crate::RelatedRef;
use crate::Remote;
use crate::RemoteRef;
use crate::StorageType;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use std::mem;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "FlatpakInstallation")]
    pub struct Installation(Object<ffi::FlatpakInstallation, ffi::FlatpakInstallationClass>);

    match fn {
        type_ => || ffi::flatpak_installation_get_type(),
    }
}

impl Installation {
    pub const NONE: Option<&'static Installation> = None;

    #[doc(alias = "flatpak_installation_new_for_path")]
    #[doc(alias = "new_for_path")]
    pub fn for_path(
        path: &impl IsA<gio::File>,
        user: bool,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Installation, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_new_for_path(
                path.as_ref().to_glib_none().0,
                user.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "flatpak_installation_new_system")]
    pub fn new_system(
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Installation, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_new_system(
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "flatpak_installation_new_system_with_id")]
    pub fn new_system_with_id(
        id: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Installation, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_new_system_with_id(
                id.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "flatpak_installation_new_user")]
    pub fn new_user(
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Installation, glib::Error> {
        assert_initialized_main_thread!();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_new_user(
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

pub trait InstallationExt: 'static {
    #[cfg(any(feature = "v1_3_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
    #[doc(alias = "flatpak_installation_add_remote")]
    fn add_remote(
        &self,
        remote: &impl IsA<Remote>,
        if_needed: bool,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_cleanup_local_refs_sync")]
    fn cleanup_local_refs_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_create_monitor")]
    fn create_monitor(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<gio::FileMonitor, glib::Error>;

    #[doc(alias = "flatpak_installation_drop_caches")]
    fn drop_caches(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_fetch_remote_metadata_sync")]
    fn fetch_remote_metadata_sync(
        &self,
        remote_name: &str,
        ref_: &impl IsA<Ref>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error>;

    #[doc(alias = "flatpak_installation_fetch_remote_ref_sync")]
    fn fetch_remote_ref_sync(
        &self,
        remote_name: &str,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error>;

    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    #[doc(alias = "flatpak_installation_fetch_remote_ref_sync_full")]
    fn fetch_remote_ref_sync_full(
        &self,
        remote_name: &str,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        flags: QueryFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error>;

    #[doc(alias = "flatpak_installation_fetch_remote_size_sync")]
    fn fetch_remote_size_sync(
        &self,
        remote_name: &str,
        ref_: &impl IsA<Ref>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(u64, u64), glib::Error>;

    #[doc(alias = "flatpak_installation_get_config")]
    #[doc(alias = "get_config")]
    fn config(
        &self,
        key: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::GString, glib::Error>;

    #[doc(alias = "flatpak_installation_get_current_installed_app")]
    #[doc(alias = "get_current_installed_app")]
    fn current_installed_app(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<InstalledRef, glib::Error>;

    #[cfg(any(feature = "v1_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5")))]
    #[doc(alias = "flatpak_installation_get_default_languages")]
    #[doc(alias = "get_default_languages")]
    fn default_languages(&self) -> Result<Vec<glib::GString>, glib::Error>;

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    #[doc(alias = "flatpak_installation_get_default_locales")]
    #[doc(alias = "get_default_locales")]
    fn default_locales(&self) -> Result<Vec<glib::GString>, glib::Error>;

    #[doc(alias = "flatpak_installation_get_display_name")]
    #[doc(alias = "get_display_name")]
    fn display_name(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installation_get_id")]
    #[doc(alias = "get_id")]
    fn id(&self) -> Option<glib::GString>;

    #[doc(alias = "flatpak_installation_get_installed_ref")]
    #[doc(alias = "get_installed_ref")]
    fn installed_ref(
        &self,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<InstalledRef, glib::Error>;

    #[doc(alias = "flatpak_installation_get_is_user")]
    #[doc(alias = "get_is_user")]
    fn is_user(&self) -> bool;

    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    #[doc(alias = "flatpak_installation_get_min_free_space_bytes")]
    #[doc(alias = "get_min_free_space_bytes")]
    fn min_free_space_bytes(&self) -> Result<u64, glib::Error>;

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    #[doc(alias = "flatpak_installation_get_no_interaction")]
    #[doc(alias = "get_no_interaction")]
    fn is_no_interaction(&self) -> bool;

    #[doc(alias = "flatpak_installation_get_path")]
    #[doc(alias = "get_path")]
    fn path(&self) -> Option<gio::File>;

    #[doc(alias = "flatpak_installation_get_priority")]
    #[doc(alias = "get_priority")]
    fn priority(&self) -> i32;

    #[doc(alias = "flatpak_installation_get_remote_by_name")]
    #[doc(alias = "get_remote_by_name")]
    fn remote_by_name(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Remote, glib::Error>;

    #[doc(alias = "flatpak_installation_get_storage_type")]
    #[doc(alias = "get_storage_type")]
    fn storage_type(&self) -> StorageType;

    #[cfg_attr(feature = "v1_7", deprecated = "Since 1.7")]
    #[doc(alias = "flatpak_installation_install_ref_file")]
    fn install_ref_file(
        &self,
        ref_file_data: &glib::Bytes,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error>;

    #[doc(alias = "flatpak_installation_launch")]
    fn launch(
        &self,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        commit: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_list_installed_refs")]
    fn list_installed_refs(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_installed_refs_by_kind")]
    fn list_installed_refs_by_kind(
        &self,
        kind: RefKind,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_installed_refs_for_update")]
    fn list_installed_refs_for_update(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_installed_related_refs_sync")]
    fn list_installed_related_refs_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RelatedRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_remote_refs_sync")]
    fn list_remote_refs_sync(
        &self,
        remote_or_uri: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RemoteRef>, glib::Error>;

    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    #[doc(alias = "flatpak_installation_list_remote_refs_sync_full")]
    fn list_remote_refs_sync_full(
        &self,
        remote_or_uri: &str,
        flags: QueryFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RemoteRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_remote_related_refs_sync")]
    fn list_remote_related_refs_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RelatedRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_list_remotes")]
    fn list_remotes(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<Remote>, glib::Error>;

    //#[doc(alias = "flatpak_installation_list_remotes_by_type")]
    //fn list_remotes_by_type(&self, types: /*Unimplemented*/&CArray TypeId { ns_id: 1, id: 17 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Vec<Remote>, glib::Error>;

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    #[doc(alias = "flatpak_installation_list_unused_refs")]
    fn list_unused_refs(
        &self,
        arch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error>;

    #[doc(alias = "flatpak_installation_load_app_overrides")]
    fn load_app_overrides(
        &self,
        app_id: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::GString, glib::Error>;

    #[doc(alias = "flatpak_installation_modify_remote")]
    fn modify_remote(
        &self,
        remote: &impl IsA<Remote>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_prune_local_repo")]
    fn prune_local_repo(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_remove_local_ref_sync")]
    fn remove_local_ref_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_remove_remote")]
    fn remove_remote(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[cfg(any(feature = "v1_0_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_0_3")))]
    #[doc(alias = "flatpak_installation_run_triggers")]
    fn run_triggers(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "flatpak_installation_set_config_sync")]
    fn set_config_sync(
        &self,
        key: &str,
        value: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    #[doc(alias = "flatpak_installation_set_no_interaction")]
    fn set_no_interaction(&self, no_interaction: bool);

    #[doc(alias = "flatpak_installation_update_remote_sync")]
    fn update_remote_sync(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error>;
}

impl<O: IsA<Installation>> InstallationExt for O {
    #[cfg(any(feature = "v1_3_4", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_4")))]
    fn add_remote(
        &self,
        remote: &impl IsA<Remote>,
        if_needed: bool,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_add_remote(
                self.as_ref().to_glib_none().0,
                remote.as_ref().to_glib_none().0,
                if_needed.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn cleanup_local_refs_sync(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_cleanup_local_refs_sync(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create_monitor(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<gio::FileMonitor, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_create_monitor(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn drop_caches(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_drop_caches(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn fetch_remote_metadata_sync(
        &self,
        remote_name: &str,
        ref_: &impl IsA<Ref>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::Bytes, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_fetch_remote_metadata_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                ref_.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn fetch_remote_ref_sync(
        &self,
        remote_name: &str,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_fetch_remote_ref_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                kind.into_glib(),
                name.to_glib_none().0,
                arch.to_glib_none().0,
                branch.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    fn fetch_remote_ref_sync_full(
        &self,
        remote_name: &str,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        flags: QueryFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_fetch_remote_ref_sync_full(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                kind.into_glib(),
                name.to_glib_none().0,
                arch.to_glib_none().0,
                branch.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn fetch_remote_size_sync(
        &self,
        remote_name: &str,
        ref_: &impl IsA<Ref>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(u64, u64), glib::Error> {
        unsafe {
            let mut download_size = mem::MaybeUninit::uninit();
            let mut installed_size = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_fetch_remote_size_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                ref_.as_ref().to_glib_none().0,
                download_size.as_mut_ptr(),
                installed_size.as_mut_ptr(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            let download_size = download_size.assume_init();
            let installed_size = installed_size.assume_init();
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok((download_size, installed_size))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn config(
        &self,
        key: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::GString, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_config(
                self.as_ref().to_glib_none().0,
                key.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn current_installed_app(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<InstalledRef, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_current_installed_app(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_5", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5")))]
    fn default_languages(&self) -> Result<Vec<glib::GString>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_default_languages(
                self.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_5_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_5_1")))]
    fn default_locales(&self) -> Result<Vec<glib::GString>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_default_locales(
                self.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn display_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installation_get_display_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::flatpak_installation_get_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn installed_ref(
        &self,
        kind: RefKind,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<InstalledRef, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_installed_ref(
                self.as_ref().to_glib_none().0,
                kind.into_glib(),
                name.to_glib_none().0,
                arch.to_glib_none().0,
                branch.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn is_user(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_installation_get_is_user(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1")))]
    fn min_free_space_bytes(&self) -> Result<u64, glib::Error> {
        unsafe {
            let mut out_bytes = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_get_min_free_space_bytes(
                self.as_ref().to_glib_none().0,
                out_bytes.as_mut_ptr(),
                &mut error,
            );
            let out_bytes = out_bytes.assume_init();
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(out_bytes)
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    fn is_no_interaction(&self) -> bool {
        unsafe {
            from_glib(ffi::flatpak_installation_get_no_interaction(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn path(&self) -> Option<gio::File> {
        unsafe {
            from_glib_full(ffi::flatpak_installation_get_path(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn priority(&self) -> i32 {
        unsafe { ffi::flatpak_installation_get_priority(self.as_ref().to_glib_none().0) }
    }

    fn remote_by_name(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Remote, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_get_remote_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn storage_type(&self) -> StorageType {
        unsafe {
            from_glib(ffi::flatpak_installation_get_storage_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn install_ref_file(
        &self,
        ref_file_data: &glib::Bytes,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<RemoteRef, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_install_ref_file(
                self.as_ref().to_glib_none().0,
                ref_file_data.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn launch(
        &self,
        name: &str,
        arch: Option<&str>,
        branch: Option<&str>,
        commit: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_launch(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                arch.to_glib_none().0,
                branch.to_glib_none().0,
                commit.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_installed_refs(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_installed_refs(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_installed_refs_by_kind(
        &self,
        kind: RefKind,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_installed_refs_by_kind(
                self.as_ref().to_glib_none().0,
                kind.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_installed_refs_for_update(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_installed_refs_for_update(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_installed_related_refs_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RelatedRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_installed_related_refs_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                ref_.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_remote_refs_sync(
        &self,
        remote_or_uri: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RemoteRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_remote_refs_sync(
                self.as_ref().to_glib_none().0,
                remote_or_uri.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_3_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_3_3")))]
    fn list_remote_refs_sync_full(
        &self,
        remote_or_uri: &str,
        flags: QueryFlags,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RemoteRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_remote_refs_sync_full(
                self.as_ref().to_glib_none().0,
                remote_or_uri.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_remote_related_refs_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<RelatedRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_remote_related_refs_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                ref_.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn list_remotes(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<Remote>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_remotes(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn list_remotes_by_type(&self, types: /*Unimplemented*/&CArray TypeId { ns_id: 1, id: 17 }, cancellable: Option<&impl IsA<gio::Cancellable>>) -> Result<Vec<Remote>, glib::Error> {
    //    unsafe { TODO: call ffi:flatpak_installation_list_remotes_by_type() }
    //}

    #[cfg(any(feature = "v1_1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_2")))]
    fn list_unused_refs(
        &self,
        arch: Option<&str>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<Vec<InstalledRef>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_list_unused_refs(
                self.as_ref().to_glib_none().0,
                arch.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(FromGlibPtrContainer::from_glib_container(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_app_overrides(
        &self,
        app_id: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<glib::GString, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::flatpak_installation_load_app_overrides(
                self.as_ref().to_glib_none().0,
                app_id.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn modify_remote(
        &self,
        remote: &impl IsA<Remote>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_modify_remote(
                self.as_ref().to_glib_none().0,
                remote.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn prune_local_repo(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_prune_local_repo(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn remove_local_ref_sync(
        &self,
        remote_name: &str,
        ref_: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_remove_local_ref_sync(
                self.as_ref().to_glib_none().0,
                remote_name.to_glib_none().0,
                ref_.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn remove_remote(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_remove_remote(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_0_3", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_0_3")))]
    fn run_triggers(
        &self,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_run_triggers(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_config_sync(
        &self,
        key: &str,
        value: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_set_config_sync(
                self.as_ref().to_glib_none().0,
                key.to_glib_none().0,
                value.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v1_1_1", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_1_1")))]
    fn set_no_interaction(&self, no_interaction: bool) {
        unsafe {
            ffi::flatpak_installation_set_no_interaction(
                self.as_ref().to_glib_none().0,
                no_interaction.into_glib(),
            );
        }
    }

    fn update_remote_sync(
        &self,
        name: &str,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::flatpak_installation_update_remote_sync(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}

impl fmt::Display for Installation {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Installation")
    }
}
