// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakError")]
pub enum Error {
    #[doc(alias = "FLATPAK_ERROR_ALREADY_INSTALLED")]
    AlreadyInstalled,
    #[doc(alias = "FLATPAK_ERROR_NOT_INSTALLED")]
    NotInstalled,
    #[doc(alias = "FLATPAK_ERROR_ONLY_PULLED")]
    OnlyPulled,
    #[doc(alias = "FLATPAK_ERROR_DIFFERENT_REMOTE")]
    DifferentRemote,
    #[doc(alias = "FLATPAK_ERROR_ABORTED")]
    Aborted,
    #[doc(alias = "FLATPAK_ERROR_SKIPPED")]
    Skipped,
    #[doc(alias = "FLATPAK_ERROR_NEED_NEW_FLATPAK")]
    NeedNewFlatpak,
    #[doc(alias = "FLATPAK_ERROR_REMOTE_NOT_FOUND")]
    RemoteNotFound,
    #[doc(alias = "FLATPAK_ERROR_RUNTIME_NOT_FOUND")]
    RuntimeNotFound,
    #[doc(alias = "FLATPAK_ERROR_DOWNGRADE")]
    Downgrade,
    #[doc(alias = "FLATPAK_ERROR_INVALID_REF")]
    InvalidRef,
    #[doc(alias = "FLATPAK_ERROR_INVALID_DATA")]
    InvalidData,
    #[doc(alias = "FLATPAK_ERROR_UNTRUSTED")]
    Untrusted,
    #[doc(alias = "FLATPAK_ERROR_SETUP_FAILED")]
    SetupFailed,
    #[doc(alias = "FLATPAK_ERROR_EXPORT_FAILED")]
    ExportFailed,
    #[doc(alias = "FLATPAK_ERROR_REMOTE_USED")]
    RemoteUsed,
    #[doc(alias = "FLATPAK_ERROR_RUNTIME_USED")]
    RuntimeUsed,
    #[doc(alias = "FLATPAK_ERROR_INVALID_NAME")]
    InvalidName,
    #[doc(alias = "FLATPAK_ERROR_OUT_OF_SPACE")]
    OutOfSpace,
    #[doc(alias = "FLATPAK_ERROR_WRONG_USER")]
    WrongUser,
    #[doc(alias = "FLATPAK_ERROR_NOT_CACHED")]
    NotCached,
    #[doc(alias = "FLATPAK_ERROR_REF_NOT_FOUND")]
    RefNotFound,
    #[doc(alias = "FLATPAK_ERROR_PERMISSION_DENIED")]
    PermissionDenied,
    #[doc(alias = "FLATPAK_ERROR_AUTHENTICATION_FAILED")]
    AuthenticationFailed,
    #[doc(alias = "FLATPAK_ERROR_NOT_AUTHORIZED")]
    NotAuthorized,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Error::{}",
            match *self {
                Self::AlreadyInstalled => "AlreadyInstalled",
                Self::NotInstalled => "NotInstalled",
                Self::OnlyPulled => "OnlyPulled",
                Self::DifferentRemote => "DifferentRemote",
                Self::Aborted => "Aborted",
                Self::Skipped => "Skipped",
                Self::NeedNewFlatpak => "NeedNewFlatpak",
                Self::RemoteNotFound => "RemoteNotFound",
                Self::RuntimeNotFound => "RuntimeNotFound",
                Self::Downgrade => "Downgrade",
                Self::InvalidRef => "InvalidRef",
                Self::InvalidData => "InvalidData",
                Self::Untrusted => "Untrusted",
                Self::SetupFailed => "SetupFailed",
                Self::ExportFailed => "ExportFailed",
                Self::RemoteUsed => "RemoteUsed",
                Self::RuntimeUsed => "RuntimeUsed",
                Self::InvalidName => "InvalidName",
                Self::OutOfSpace => "OutOfSpace",
                Self::WrongUser => "WrongUser",
                Self::NotCached => "NotCached",
                Self::RefNotFound => "RefNotFound",
                Self::PermissionDenied => "PermissionDenied",
                Self::AuthenticationFailed => "AuthenticationFailed",
                Self::NotAuthorized => "NotAuthorized",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for Error {
    type GlibType = ffi::FlatpakError;

    fn into_glib(self) -> ffi::FlatpakError {
        match self {
            Self::AlreadyInstalled => ffi::FLATPAK_ERROR_ALREADY_INSTALLED,
            Self::NotInstalled => ffi::FLATPAK_ERROR_NOT_INSTALLED,
            Self::OnlyPulled => ffi::FLATPAK_ERROR_ONLY_PULLED,
            Self::DifferentRemote => ffi::FLATPAK_ERROR_DIFFERENT_REMOTE,
            Self::Aborted => ffi::FLATPAK_ERROR_ABORTED,
            Self::Skipped => ffi::FLATPAK_ERROR_SKIPPED,
            Self::NeedNewFlatpak => ffi::FLATPAK_ERROR_NEED_NEW_FLATPAK,
            Self::RemoteNotFound => ffi::FLATPAK_ERROR_REMOTE_NOT_FOUND,
            Self::RuntimeNotFound => ffi::FLATPAK_ERROR_RUNTIME_NOT_FOUND,
            Self::Downgrade => ffi::FLATPAK_ERROR_DOWNGRADE,
            Self::InvalidRef => ffi::FLATPAK_ERROR_INVALID_REF,
            Self::InvalidData => ffi::FLATPAK_ERROR_INVALID_DATA,
            Self::Untrusted => ffi::FLATPAK_ERROR_UNTRUSTED,
            Self::SetupFailed => ffi::FLATPAK_ERROR_SETUP_FAILED,
            Self::ExportFailed => ffi::FLATPAK_ERROR_EXPORT_FAILED,
            Self::RemoteUsed => ffi::FLATPAK_ERROR_REMOTE_USED,
            Self::RuntimeUsed => ffi::FLATPAK_ERROR_RUNTIME_USED,
            Self::InvalidName => ffi::FLATPAK_ERROR_INVALID_NAME,
            Self::OutOfSpace => ffi::FLATPAK_ERROR_OUT_OF_SPACE,
            Self::WrongUser => ffi::FLATPAK_ERROR_WRONG_USER,
            Self::NotCached => ffi::FLATPAK_ERROR_NOT_CACHED,
            Self::RefNotFound => ffi::FLATPAK_ERROR_REF_NOT_FOUND,
            Self::PermissionDenied => ffi::FLATPAK_ERROR_PERMISSION_DENIED,
            Self::AuthenticationFailed => ffi::FLATPAK_ERROR_AUTHENTICATION_FAILED,
            Self::NotAuthorized => ffi::FLATPAK_ERROR_NOT_AUTHORIZED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakError> for Error {
    unsafe fn from_glib(value: ffi::FlatpakError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_ERROR_ALREADY_INSTALLED => Self::AlreadyInstalled,
            ffi::FLATPAK_ERROR_NOT_INSTALLED => Self::NotInstalled,
            ffi::FLATPAK_ERROR_ONLY_PULLED => Self::OnlyPulled,
            ffi::FLATPAK_ERROR_DIFFERENT_REMOTE => Self::DifferentRemote,
            ffi::FLATPAK_ERROR_ABORTED => Self::Aborted,
            ffi::FLATPAK_ERROR_SKIPPED => Self::Skipped,
            ffi::FLATPAK_ERROR_NEED_NEW_FLATPAK => Self::NeedNewFlatpak,
            ffi::FLATPAK_ERROR_REMOTE_NOT_FOUND => Self::RemoteNotFound,
            ffi::FLATPAK_ERROR_RUNTIME_NOT_FOUND => Self::RuntimeNotFound,
            ffi::FLATPAK_ERROR_DOWNGRADE => Self::Downgrade,
            ffi::FLATPAK_ERROR_INVALID_REF => Self::InvalidRef,
            ffi::FLATPAK_ERROR_INVALID_DATA => Self::InvalidData,
            ffi::FLATPAK_ERROR_UNTRUSTED => Self::Untrusted,
            ffi::FLATPAK_ERROR_SETUP_FAILED => Self::SetupFailed,
            ffi::FLATPAK_ERROR_EXPORT_FAILED => Self::ExportFailed,
            ffi::FLATPAK_ERROR_REMOTE_USED => Self::RemoteUsed,
            ffi::FLATPAK_ERROR_RUNTIME_USED => Self::RuntimeUsed,
            ffi::FLATPAK_ERROR_INVALID_NAME => Self::InvalidName,
            ffi::FLATPAK_ERROR_OUT_OF_SPACE => Self::OutOfSpace,
            ffi::FLATPAK_ERROR_WRONG_USER => Self::WrongUser,
            ffi::FLATPAK_ERROR_NOT_CACHED => Self::NotCached,
            ffi::FLATPAK_ERROR_REF_NOT_FOUND => Self::RefNotFound,
            ffi::FLATPAK_ERROR_PERMISSION_DENIED => Self::PermissionDenied,
            ffi::FLATPAK_ERROR_AUTHENTICATION_FAILED => Self::AuthenticationFailed,
            ffi::FLATPAK_ERROR_NOT_AUTHORIZED => Self::NotAuthorized,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for Error {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::flatpak_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::FLATPAK_ERROR_ALREADY_INSTALLED => Some(Self::AlreadyInstalled),
            ffi::FLATPAK_ERROR_NOT_INSTALLED => Some(Self::NotInstalled),
            ffi::FLATPAK_ERROR_ONLY_PULLED => Some(Self::OnlyPulled),
            ffi::FLATPAK_ERROR_DIFFERENT_REMOTE => Some(Self::DifferentRemote),
            ffi::FLATPAK_ERROR_ABORTED => Some(Self::Aborted),
            ffi::FLATPAK_ERROR_SKIPPED => Some(Self::Skipped),
            ffi::FLATPAK_ERROR_NEED_NEW_FLATPAK => Some(Self::NeedNewFlatpak),
            ffi::FLATPAK_ERROR_REMOTE_NOT_FOUND => Some(Self::RemoteNotFound),
            ffi::FLATPAK_ERROR_RUNTIME_NOT_FOUND => Some(Self::RuntimeNotFound),
            ffi::FLATPAK_ERROR_DOWNGRADE => Some(Self::Downgrade),
            ffi::FLATPAK_ERROR_INVALID_REF => Some(Self::InvalidRef),
            ffi::FLATPAK_ERROR_INVALID_DATA => Some(Self::InvalidData),
            ffi::FLATPAK_ERROR_UNTRUSTED => Some(Self::Untrusted),
            ffi::FLATPAK_ERROR_SETUP_FAILED => Some(Self::SetupFailed),
            ffi::FLATPAK_ERROR_EXPORT_FAILED => Some(Self::ExportFailed),
            ffi::FLATPAK_ERROR_REMOTE_USED => Some(Self::RemoteUsed),
            ffi::FLATPAK_ERROR_RUNTIME_USED => Some(Self::RuntimeUsed),
            ffi::FLATPAK_ERROR_INVALID_NAME => Some(Self::InvalidName),
            ffi::FLATPAK_ERROR_OUT_OF_SPACE => Some(Self::OutOfSpace),
            ffi::FLATPAK_ERROR_WRONG_USER => Some(Self::WrongUser),
            ffi::FLATPAK_ERROR_NOT_CACHED => Some(Self::NotCached),
            ffi::FLATPAK_ERROR_REF_NOT_FOUND => Some(Self::RefNotFound),
            ffi::FLATPAK_ERROR_PERMISSION_DENIED => Some(Self::PermissionDenied),
            ffi::FLATPAK_ERROR_AUTHENTICATION_FAILED => Some(Self::AuthenticationFailed),
            ffi::FLATPAK_ERROR_NOT_AUTHORIZED => Some(Self::NotAuthorized),
            value => Some(Self::__Unknown(value)),
        }
    }
}

impl StaticType for Error {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_error_get_type()) }
    }
}

impl glib::value::ValueType for Error {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for Error {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for Error {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakPortalError")]
pub enum PortalError {
    #[doc(alias = "FLATPAK_PORTAL_ERROR_FAILED")]
    Failed,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT")]
    InvalidArgument,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_NOT_FOUND")]
    NotFound,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_EXISTS")]
    Exists,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_NOT_ALLOWED")]
    NotAllowed,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_CANCELLED")]
    Cancelled,
    #[doc(alias = "FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED")]
    WindowDestroyed,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for PortalError {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "PortalError::{}",
            match *self {
                Self::Failed => "Failed",
                Self::InvalidArgument => "InvalidArgument",
                Self::NotFound => "NotFound",
                Self::Exists => "Exists",
                Self::NotAllowed => "NotAllowed",
                Self::Cancelled => "Cancelled",
                Self::WindowDestroyed => "WindowDestroyed",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for PortalError {
    type GlibType = ffi::FlatpakPortalError;

    fn into_glib(self) -> ffi::FlatpakPortalError {
        match self {
            Self::Failed => ffi::FLATPAK_PORTAL_ERROR_FAILED,
            Self::InvalidArgument => ffi::FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT,
            Self::NotFound => ffi::FLATPAK_PORTAL_ERROR_NOT_FOUND,
            Self::Exists => ffi::FLATPAK_PORTAL_ERROR_EXISTS,
            Self::NotAllowed => ffi::FLATPAK_PORTAL_ERROR_NOT_ALLOWED,
            Self::Cancelled => ffi::FLATPAK_PORTAL_ERROR_CANCELLED,
            Self::WindowDestroyed => ffi::FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakPortalError> for PortalError {
    unsafe fn from_glib(value: ffi::FlatpakPortalError) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_PORTAL_ERROR_FAILED => Self::Failed,
            ffi::FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT => Self::InvalidArgument,
            ffi::FLATPAK_PORTAL_ERROR_NOT_FOUND => Self::NotFound,
            ffi::FLATPAK_PORTAL_ERROR_EXISTS => Self::Exists,
            ffi::FLATPAK_PORTAL_ERROR_NOT_ALLOWED => Self::NotAllowed,
            ffi::FLATPAK_PORTAL_ERROR_CANCELLED => Self::Cancelled,
            ffi::FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED => Self::WindowDestroyed,
            value => Self::__Unknown(value),
        }
    }
}

impl ErrorDomain for PortalError {
    fn domain() -> Quark {
        skip_assert_initialized!();

        unsafe { from_glib(ffi::flatpak_portal_error_quark()) }
    }

    fn code(self) -> i32 {
        self.into_glib()
    }

    fn from(code: i32) -> Option<Self> {
        skip_assert_initialized!();
        match code {
            ffi::FLATPAK_PORTAL_ERROR_FAILED => Some(Self::Failed),
            ffi::FLATPAK_PORTAL_ERROR_INVALID_ARGUMENT => Some(Self::InvalidArgument),
            ffi::FLATPAK_PORTAL_ERROR_NOT_FOUND => Some(Self::NotFound),
            ffi::FLATPAK_PORTAL_ERROR_EXISTS => Some(Self::Exists),
            ffi::FLATPAK_PORTAL_ERROR_NOT_ALLOWED => Some(Self::NotAllowed),
            ffi::FLATPAK_PORTAL_ERROR_CANCELLED => Some(Self::Cancelled),
            ffi::FLATPAK_PORTAL_ERROR_WINDOW_DESTROYED => Some(Self::WindowDestroyed),
            _ => Some(Self::Failed),
        }
    }
}

impl StaticType for PortalError {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_portal_error_get_type()) }
    }
}

impl glib::value::ValueType for PortalError {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PortalError {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for PortalError {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakRefKind")]
pub enum RefKind {
    #[doc(alias = "FLATPAK_REF_KIND_APP")]
    App,
    #[doc(alias = "FLATPAK_REF_KIND_RUNTIME")]
    Runtime,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RefKind {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RefKind::{}",
            match *self {
                Self::App => "App",
                Self::Runtime => "Runtime",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RefKind {
    type GlibType = ffi::FlatpakRefKind;

    fn into_glib(self) -> ffi::FlatpakRefKind {
        match self {
            Self::App => ffi::FLATPAK_REF_KIND_APP,
            Self::Runtime => ffi::FLATPAK_REF_KIND_RUNTIME,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakRefKind> for RefKind {
    unsafe fn from_glib(value: ffi::FlatpakRefKind) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_REF_KIND_APP => Self::App,
            ffi::FLATPAK_REF_KIND_RUNTIME => Self::Runtime,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RefKind {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_ref_kind_get_type()) }
    }
}

impl glib::value::ValueType for RefKind {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RefKind {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RefKind {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakRemoteType")]
pub enum RemoteType {
    #[doc(alias = "FLATPAK_REMOTE_TYPE_STATIC")]
    Static,
    #[doc(alias = "FLATPAK_REMOTE_TYPE_USB")]
    Usb,
    #[doc(alias = "FLATPAK_REMOTE_TYPE_LAN")]
    Lan,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RemoteType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RemoteType::{}",
            match *self {
                Self::Static => "Static",
                Self::Usb => "Usb",
                Self::Lan => "Lan",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for RemoteType {
    type GlibType = ffi::FlatpakRemoteType;

    fn into_glib(self) -> ffi::FlatpakRemoteType {
        match self {
            Self::Static => ffi::FLATPAK_REMOTE_TYPE_STATIC,
            Self::Usb => ffi::FLATPAK_REMOTE_TYPE_USB,
            Self::Lan => ffi::FLATPAK_REMOTE_TYPE_LAN,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakRemoteType> for RemoteType {
    unsafe fn from_glib(value: ffi::FlatpakRemoteType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_REMOTE_TYPE_STATIC => Self::Static,
            ffi::FLATPAK_REMOTE_TYPE_USB => Self::Usb,
            ffi::FLATPAK_REMOTE_TYPE_LAN => Self::Lan,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for RemoteType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_remote_type_get_type()) }
    }
}

impl glib::value::ValueType for RemoteType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for RemoteType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for RemoteType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakStorageType")]
pub enum StorageType {
    #[doc(alias = "FLATPAK_STORAGE_TYPE_DEFAULT")]
    Default,
    #[doc(alias = "FLATPAK_STORAGE_TYPE_HARD_DISK")]
    HardDisk,
    #[doc(alias = "FLATPAK_STORAGE_TYPE_SDCARD")]
    Sdcard,
    #[doc(alias = "FLATPAK_STORAGE_TYPE_MMC")]
    Mmc,
    #[doc(alias = "FLATPAK_STORAGE_TYPE_NETWORK")]
    Network,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StorageType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StorageType::{}",
            match *self {
                Self::Default => "Default",
                Self::HardDisk => "HardDisk",
                Self::Sdcard => "Sdcard",
                Self::Mmc => "Mmc",
                Self::Network => "Network",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for StorageType {
    type GlibType = ffi::FlatpakStorageType;

    fn into_glib(self) -> ffi::FlatpakStorageType {
        match self {
            Self::Default => ffi::FLATPAK_STORAGE_TYPE_DEFAULT,
            Self::HardDisk => ffi::FLATPAK_STORAGE_TYPE_HARD_DISK,
            Self::Sdcard => ffi::FLATPAK_STORAGE_TYPE_SDCARD,
            Self::Mmc => ffi::FLATPAK_STORAGE_TYPE_MMC,
            Self::Network => ffi::FLATPAK_STORAGE_TYPE_NETWORK,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakStorageType> for StorageType {
    unsafe fn from_glib(value: ffi::FlatpakStorageType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_STORAGE_TYPE_DEFAULT => Self::Default,
            ffi::FLATPAK_STORAGE_TYPE_HARD_DISK => Self::HardDisk,
            ffi::FLATPAK_STORAGE_TYPE_SDCARD => Self::Sdcard,
            ffi::FLATPAK_STORAGE_TYPE_MMC => Self::Mmc,
            ffi::FLATPAK_STORAGE_TYPE_NETWORK => Self::Network,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for StorageType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_storage_type_get_type()) }
    }
}

impl glib::value::ValueType for StorageType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for StorageType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for StorageType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakTransactionOperationType")]
pub enum TransactionOperationType {
    #[doc(alias = "FLATPAK_TRANSACTION_OPERATION_INSTALL")]
    Install,
    #[doc(alias = "FLATPAK_TRANSACTION_OPERATION_UPDATE")]
    Update,
    #[doc(alias = "FLATPAK_TRANSACTION_OPERATION_INSTALL_BUNDLE")]
    InstallBundle,
    #[doc(alias = "FLATPAK_TRANSACTION_OPERATION_UNINSTALL")]
    Uninstall,
    #[doc(alias = "FLATPAK_TRANSACTION_OPERATION_LAST_TYPE")]
    LastType,
    #[doc(hidden)]
    __Unknown(i32),
}

impl TransactionOperationType {
    #[doc(alias = "flatpak_transaction_operation_type_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(self) -> Option<glib::GString> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::flatpak_transaction_operation_type_to_string(
                self.into_glib(),
            ))
        }
    }
}

impl fmt::Display for TransactionOperationType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TransactionOperationType::{}",
            match *self {
                Self::Install => "Install",
                Self::Update => "Update",
                Self::InstallBundle => "InstallBundle",
                Self::Uninstall => "Uninstall",
                Self::LastType => "LastType",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TransactionOperationType {
    type GlibType = ffi::FlatpakTransactionOperationType;

    fn into_glib(self) -> ffi::FlatpakTransactionOperationType {
        match self {
            Self::Install => ffi::FLATPAK_TRANSACTION_OPERATION_INSTALL,
            Self::Update => ffi::FLATPAK_TRANSACTION_OPERATION_UPDATE,
            Self::InstallBundle => ffi::FLATPAK_TRANSACTION_OPERATION_INSTALL_BUNDLE,
            Self::Uninstall => ffi::FLATPAK_TRANSACTION_OPERATION_UNINSTALL,
            Self::LastType => ffi::FLATPAK_TRANSACTION_OPERATION_LAST_TYPE,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakTransactionOperationType> for TransactionOperationType {
    unsafe fn from_glib(value: ffi::FlatpakTransactionOperationType) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_TRANSACTION_OPERATION_INSTALL => Self::Install,
            ffi::FLATPAK_TRANSACTION_OPERATION_UPDATE => Self::Update,
            ffi::FLATPAK_TRANSACTION_OPERATION_INSTALL_BUNDLE => Self::InstallBundle,
            ffi::FLATPAK_TRANSACTION_OPERATION_UNINSTALL => Self::Uninstall,
            ffi::FLATPAK_TRANSACTION_OPERATION_LAST_TYPE => Self::LastType,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TransactionOperationType {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_transaction_operation_type_get_type()) }
    }
}

impl glib::value::ValueType for TransactionOperationType {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TransactionOperationType {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TransactionOperationType {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "FlatpakTransactionRemoteReason")]
pub enum TransactionRemoteReason {
    #[doc(alias = "FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO")]
    GenericRepo,
    #[doc(alias = "FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS")]
    RuntimeDeps,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TransactionRemoteReason {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TransactionRemoteReason::{}",
            match *self {
                Self::GenericRepo => "GenericRepo",
                Self::RuntimeDeps => "RuntimeDeps",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl IntoGlib for TransactionRemoteReason {
    type GlibType = ffi::FlatpakTransactionRemoteReason;

    fn into_glib(self) -> ffi::FlatpakTransactionRemoteReason {
        match self {
            Self::GenericRepo => ffi::FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO,
            Self::RuntimeDeps => ffi::FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS,
            Self::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<ffi::FlatpakTransactionRemoteReason> for TransactionRemoteReason {
    unsafe fn from_glib(value: ffi::FlatpakTransactionRemoteReason) -> Self {
        skip_assert_initialized!();
        match value {
            ffi::FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO => Self::GenericRepo,
            ffi::FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS => Self::RuntimeDeps,
            value => Self::__Unknown(value),
        }
    }
}

impl StaticType for TransactionRemoteReason {
    fn static_type() -> Type {
        unsafe { from_glib(ffi::flatpak_transaction_remote_reason_get_type()) }
    }
}

impl glib::value::ValueType for TransactionRemoteReason {
    type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TransactionRemoteReason {
    type Checker = glib::value::GenericValueTypeChecker<Self>;

    unsafe fn from_value(value: &'a glib::Value) -> Self {
        skip_assert_initialized!();
        from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
    }
}

impl ToValue for TransactionRemoteReason {
    fn to_value(&self) -> glib::Value {
        let mut value = glib::Value::for_value_type::<Self>();
        unsafe {
            glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
        }
        value
    }

    fn value_type(&self) -> glib::Type {
        Self::static_type()
    }
}
